/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.apt;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import com.google.java.contract.core.apt.ContractJavaFileManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

@Invariant(value={"javaCompiler != null", "fileManager != null"})
public class ContractJavaCompiler {
    protected static final List<String> OPTIONS = Arrays.asList("-g:source,vars", "-proc:none", "-implicit:none");
    protected JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
    protected ContractJavaFileManager fileManager;

    public ContractJavaCompiler(String string, String string2, String string3) throws IOException {
        if (this.javaCompiler == null) {
            throw new IOException("no system JavaCompiler found; are you using a JRE instead of a JDK?");
        }
        this.fileManager = new ContractJavaFileManager(this.javaCompiler.getStandardFileManager(null, null, null));
        if (string != null) {
            this.setPath(StandardLocation.SOURCE_PATH, string);
        }
        if (string2 != null) {
            this.setPath(StandardLocation.CLASS_PATH, string2);
        }
        if (string3 != null) {
            this.setClassOutputDirectory(string3);
        }
    }

    @Requires(value={"files != null", "diagnostics != null"})
    @Ensures(value={"result != null"})
    public JavaCompiler.CompilationTask getTask(List<? extends JavaFileObject> list, DiagnosticListener<JavaFileObject> diagnosticListener) {
        return this.javaCompiler.getTask(null, this.fileManager, diagnosticListener, OPTIONS, null, list);
    }

    @Requires(value={"location != null", "path != null"})
    protected void setPath(JavaFileManager.Location location, String string) throws IOException {
        String[] stringArray = string.split(Pattern.quote(File.pathSeparator));
        ArrayList<File> arrayList = new ArrayList<File>(stringArray.length);
        for (String string2 : stringArray) {
            arrayList.add(new File(string2));
        }
        this.fileManager.setLocation(location, arrayList);
    }

    @Requires(value={"outputDirectory != null"})
    protected void setClassOutputDirectory(String string) throws IOException {
        this.fileManager.setLocation(StandardLocation.CLASS_OUTPUT, Collections.singletonList(new File(string)));
    }
}

