/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.apt;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import com.google.java.contract.core.apt.DiagnosticManager;
import com.google.java.contract.core.model.ClassName;
import com.google.java.contract.core.model.ElementKind;
import com.google.java.contract.core.model.VariableModel;
import com.google.java.contract.core.util.BalancedTokenizer;
import com.google.java.contract.core.util.JavaTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

@Invariant(value={"diagnosticManager != null", "oldId >= 0", "oldParameters == null || oldParametersCode != null", "oldParameters == null || oldParametersLineNumbers != null", "oldParameters == null || !oldParameters.contains(null)", "oldParameters == null || !oldParametersCode.contains(null)", "oldParameters == null || oldParameters.size() == oldParametersCode.size()", "oldParameters == null || oldParameters.size() == oldParametersLineNumbers.size()"})
public class ContractExpressionTransformer {
    private static final String MAGIC_CAST_METHOD = "com.google.java.contract.core.runtime.ContractRuntime.magicCast";
    protected DiagnosticManager diagnosticManager;
    protected boolean acceptOld;
    protected List<VariableModel> oldParameters;
    protected List<String> oldParametersCode;
    protected List<Long> oldParametersLineNumbers;
    protected List<String> newCode;
    protected boolean parsed;
    protected int oldId;

    public ContractExpressionTransformer(DiagnosticManager diagnosticManager, boolean bl) {
        this.diagnosticManager = diagnosticManager;
        this.acceptOld = bl;
        this.oldParameters = null;
        this.oldParametersCode = null;
        this.oldParametersLineNumbers = null;
        this.newCode = null;
        this.parsed = false;
        this.oldId = 0;
    }

    public void setAcceptOld(boolean bl) {
        this.acceptOld = bl;
    }

    @Requires(value={"currentBuffer != null", "tokenizer != null", "token != null"})
    private void transformCommon(StringBuilder stringBuilder, BalancedTokenizer balancedTokenizer, JavaTokenizer.Token token) {
        switch (token.kind) {
            case COMMENT: {
                int n = token.text.length();
                for (int i = 0; i < n; ++i) {
                    stringBuilder.append(" ");
                }
                break;
            }
            default: {
                stringBuilder.append(token.text);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Requires(value={"code != null", "lineNumbers != null", "code.size() == lineNumbers.size()"})
    @Ensures(value={"result == canQueryResults()", "!result || newCode.size() == code.size()"})
    public boolean transform(List<String> var1_1, List<Long> var2_2, Object var3_3) {
        this.oldParameters = new ArrayList<VariableModel>();
        this.oldParametersCode = new ArrayList<String>();
        this.oldParametersLineNumbers = new ArrayList<Long>();
        this.newCode = new ArrayList<String>();
        this.parsed = true;
        var4_4 = var2_2.iterator();
        block6: for (String var6_6 : var1_1) {
            var7_7 = var4_4.hasNext() != false ? var4_4.next() : null;
            var8_8 = new BalancedTokenizer(new StringReader(var6_6));
            var9_9 = 0;
            var10_10 = 0;
            var11_11 = new StringBuilder();
            var12_12 = null;
            var13_13 = null;
            var14_14 = -1;
            while (var8_8.hasNext()) {
                block17: {
                    block16: {
                        var15_15 = var8_8.next();
                        var10_10 = var8_8.getCurrentLevel();
                        v0 = var16_17 = var12_12 != null ? var12_12 : var11_11;
                        if (var10_10 == 0 && var15_15.text.equals(";")) {
                            this.diagnosticManager.error("'\"' expected", var6_6, var15_15.offset, var15_15.offset, var15_15.offset, var3_3);
                            this.parsed = false;
                            continue block6;
                        }
                        if (var12_12 == null) break block16;
                        if (var10_10 == var14_14) {
                            var17_18 = var12_12.toString();
                            this.oldParameters.add(new VariableModel(ElementKind.PARAMETER, var13_13, new ClassName("java/lang/Object")));
                            this.oldParametersCode.add((String)var17_18);
                            this.oldParametersLineNumbers.add(var7_7);
                            var11_11.append("(   ");
                            var11_11.append("/*[*/");
                            var11_11.append("com.google.java.contract.core.runtime.ContractRuntime.magicCast");
                            var11_11.append("(");
                            var11_11.append(var13_13);
                            var11_11.append(", ");
                            var11_11.append("true ? null : ");
                            var11_11.append("/*]*/");
                            var11_11.append((String)var17_18);
                            var11_11.append("/*[*/");
                            var11_11.append(")");
                            var11_11.append("/*]*/");
                            var11_11.append(")");
                            var12_12 = null;
                            var14_14 = -1;
                        } else {
                            switch (1.$SwitchMap$com$google$java$contract$core$util$JavaTokenizer$TokenKind[var15_15.kind.ordinal()]) {
                                case 2: {
                                    if (var15_15.text.equals("old")) {
                                        this.diagnosticManager.error("nested old expression", var6_6, var15_15.offset, var15_15.offset, var15_15.offset, var3_3);
                                        this.parsed = false;
                                        continue block6;
                                    }
                                    var12_12.append(var15_15.text);
                                    break;
                                }
                                default: {
                                    this.transformCommon(var12_12, var8_8, var15_15);
                                    break;
                                }
                            }
                        }
                        break block17;
                    }
                    switch (1.$SwitchMap$com$google$java$contract$core$util$JavaTokenizer$TokenKind[var15_15.kind.ordinal()]) {
                        case 2: {
                            if (!this.acceptOld || !var15_15.text.equals("old")) ** GOTO lbl91
                            var17_18 = null;
                            if (!var8_8.hasNext()) ** GOTO lbl83
                            var17_18 = var8_8.next();
                            if (var17_18.text.equals("(") || var17_18.kind == JavaTokenizer.TokenKind.SPACE && var8_8.hasNext() && var8_8.next().text.equals("(")) ** GOTO lbl87
lbl83:
                            // 2 sources

                            var18_19 = var17_18 != null ? var17_18.offset : var8_8.getCurrentOffset();
                            this.diagnosticManager.error("'(' expected", var6_6, var18_19, var18_19, var18_19, var3_3);
                            this.parsed = false;
                            continue block6;
lbl87:
                            // 1 sources

                            var13_13 = "com$google$java$contract$local$old" + this.oldId++;
                            var12_12 = var17_18.kind == JavaTokenizer.TokenKind.SPACE ? new StringBuilder(var17_18.text) : new StringBuilder();
                            var14_14 = var9_9;
                            break;
                        }
lbl91:
                        // 2 sources

                        default: {
                            this.transformCommon(var11_11, var8_8, var15_15);
                        }
                    }
                }
                var9_9 = var10_10;
            }
            if (var8_8.hasErrors()) {
                var15_16 = var8_8.getCurrentOffset();
                this.diagnosticManager.error(var8_8.getErrorMessage(), var6_6, var15_16, var15_16, var15_16, var3_3);
                this.parsed = false;
                continue;
            }
            this.newCode.add(var11_11.toString());
        }
        return this.parsed;
    }

    public boolean canQueryResults() {
        return this.parsed;
    }

    @Ensures(value={"result >= 0"})
    public int getNextOldId() {
        return this.oldId;
    }

    @Requires(value={"canQueryResults()"})
    @Ensures(value={"result != null", "result.size() == getOldParametersCode().size()", "result.size() == getOldParametersLineNumbers().size()"})
    public List<VariableModel> getOldParameters() {
        return this.oldParameters;
    }

    @Requires(value={"canQueryResults()"})
    @Ensures(value={"result != null", "result.size() == getOldParameters().size()", "result.size() == getOldParametersLineNumbers().size()"})
    public List<String> getOldParametersCode() {
        return this.oldParametersCode;
    }

    @Requires(value={"canQueryResults()"})
    @Ensures(value={"result != null", "result.size() == getOldParameters().size()", "result.size() == getOldParametersCode().size()"})
    public List<Long> getOldParametersLineNumbers() {
        return this.oldParametersLineNumbers;
    }

    @Requires(value={"canQueryResults()"})
    @Ensures(value={"result != null"})
    public List<String> getTransformedCode() {
        return this.newCode;
    }
}

