/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.apt;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import com.google.java.contract.core.apt.ClassContractCreator;
import com.google.java.contract.core.apt.ContractFinder;
import com.google.java.contract.core.apt.ContractJavaCompiler;
import com.google.java.contract.core.apt.ContractWriter;
import com.google.java.contract.core.apt.DiagnosticManager;
import com.google.java.contract.core.apt.FactoryUtils;
import com.google.java.contract.core.apt.TypeFactory;
import com.google.java.contract.core.model.ContractAnnotationModel;
import com.google.java.contract.core.model.TypeModel;
import com.google.java.contract.core.util.DebugUtils;
import com.google.java.contract.core.util.ElementScanner;
import com.google.java.contract.core.util.SyntheticJavaFile;
import com.sun.tools.javac.main.OptionName;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Options;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementScanner6;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedOptions(value={"com.google.java.contract.debug", "com.google.java.contract.dump", "com.google.java.contract.sourcepath", "com.google.java.contract.classpath", "com.google.java.contract.classoutput", "com.google.java.contract.depspath", "com.google.java.contract.experimental"})
public class AnnotationProcessor
extends AbstractProcessor {
    protected static final String OPT_DEBUG = "com.google.java.contract.debug";
    protected static final String OPT_DUMP = "com.google.java.contract.dump";
    protected static final String OPT_SOURCEPATH = "com.google.java.contract.sourcepath";
    protected static final String OPT_CLASSPATH = "com.google.java.contract.classpath";
    protected static final String OPT_CLASSOUTPUT = "com.google.java.contract.classoutput";
    protected static final String OPT_DEPSPATH = "com.google.java.contract.depspath";
    protected static final String OPT_EXPERIMENTAL = "com.google.java.contract.experimental";
    protected TypeFactory factory;
    protected FactoryUtils utils;
    protected String sourcePath;
    protected String classPath;
    protected String outputDirectory;
    protected boolean debug;
    protected boolean dump;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        Map<String, String> map = processingEnvironment.getOptions();
        this.debug = map.containsKey(OPT_DEBUG);
        this.dump = map.containsKey(OPT_DUMP);
        String string = map.get(OPT_DUMP);
        if (string != null) {
            DebugUtils.setDumpDirectory(string);
        }
        this.utils = new FactoryUtils(processingEnvironment);
        this.factory = new TypeFactory(this.utils, map.get(OPT_DEPSPATH));
        this.setupPaths();
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        Set<TypeElement> set2 = this.getContractedRootElements(roundEnvironment);
        if (set2.isEmpty()) {
            return false;
        }
        DiagnosticManager diagnosticManager = new DiagnosticManager();
        List<TypeModel> list = this.createTypes(set2, diagnosticManager);
        boolean bl = diagnosticManager.getErrorCount() == 0;
        ArrayList<SyntheticJavaFile> arrayList = new ArrayList<SyntheticJavaFile>(list.size());
        if (bl) {
            for (TypeModel object : list) {
                ContractWriter contractWriter = new ContractWriter(this.debug);
                object.accept(contractWriter);
                arrayList.add(new SyntheticJavaFile(object.getName().getBinaryName(), contractWriter.toByteArray(), contractWriter.getLineNumberMap()));
            }
            if (this.dump) {
                this.dumpSources(list, arrayList);
            }
            try {
                ContractJavaCompiler contractJavaCompiler = new ContractJavaCompiler(this.sourcePath, this.classPath, this.outputDirectory);
                JavaCompiler.CompilationTask compilationTask = contractJavaCompiler.getTask(arrayList, diagnosticManager);
                bl = compilationTask.call();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        if (!bl || diagnosticManager.getCount() != 0) {
            for (DiagnosticManager.Report report : diagnosticManager) {
                this.printDiagnostic(report);
            }
        }
        return true;
    }

    private void setupPaths() {
        this.sourcePath = this.processingEnv.getOptions().get(OPT_SOURCEPATH);
        this.classPath = this.processingEnv.getOptions().get(OPT_CLASSPATH);
        this.outputDirectory = this.processingEnv.getOptions().get(OPT_CLASSOUTPUT);
        if (this.processingEnv.getClass().getName().equals("com.sun.tools.javac.processing.JavacProcessingEnvironment")) {
            JavacProcessingEnvironment javacProcessingEnvironment = (JavacProcessingEnvironment)this.processingEnv;
            Options options = Options.instance(javacProcessingEnvironment.getContext());
            if (this.sourcePath == null) {
                this.sourcePath = options.get(OptionName.SOURCEPATH);
            }
            if (this.classPath == null) {
                String string = options.get(OptionName.CP);
                String string2 = options.get(OptionName.CLASSPATH);
                this.classPath = string != null ? (string2 != null ? string + File.pathSeparator + string2 : string) : string2;
            }
            if (this.outputDirectory == null) {
                this.outputDirectory = options.get(OptionName.D);
            }
        }
    }

    @Requires(value={"r != null"})
    protected void printDiagnostic(DiagnosticManager.Report report) {
        Messager messager = this.processingEnv.getMessager();
        if (report.getElement() == null) {
            messager.printMessage(report.getKind(), report.getMessage(null));
        } else {
            messager.printMessage(report.getKind(), report.getMessage(null), report.getElement(), report.getAnnotationMirror(), report.getAnnotationValue());
        }
    }

    @Requires(value={"types != null", "sources != null", "types.size() == sources.size()"})
    protected void dumpSources(List<TypeModel> list, List<SyntheticJavaFile> list2) {
        Iterator<TypeModel> iterator = list.iterator();
        Iterator<SyntheticJavaFile> iterator2 = list2.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            TypeModel typeModel = iterator.next();
            SyntheticJavaFile syntheticJavaFile = iterator2.next();
            DebugUtils.dump(typeModel.getName().getBinaryName(), ((Object)syntheticJavaFile.getCharContent(true)).toString().getBytes(), JavaFileObject.Kind.SOURCE);
        }
    }

    @Requires(value={"roots != null", "diagnosticManager != null"})
    @Ensures(value={"result != null", "result.size() >= roots.size()", "result.size() <= 2 * roots.size()"})
    protected List<TypeModel> createTypes(Set<TypeElement> set, DiagnosticManager diagnosticManager) {
        ElementScanner elementScanner;
        TypeModel typeModel;
        boolean bl = false;
        final HashSet hashSet = new HashSet();
        for (TypeElement arrayList2 : set) {
            ElementScanner6<Void, Void> elementScanner6 = new ElementScanner6<Void, Void>(){

                @Override
                public Void visitType(TypeElement typeElement, Void void_) {
                    hashSet.add(typeElement.getQualifiedName().toString());
                    return (Void)super.visitType(typeElement, void_);
                }
            };
            arrayList2.accept(elementScanner6, null);
        }
        ArrayList arrayList3 = new ArrayList(set.size());
        for (TypeElement typeElement : set) {
            typeModel = this.factory.createType(typeElement, diagnosticManager);
            elementScanner = new ElementScanner(){

                @Override
                public void visitContractAnnotation(ContractAnnotationModel contractAnnotationModel) {
                    if (contractAnnotationModel.isVirtual() && hashSet.contains(contractAnnotationModel.getOwner().getQualifiedName())) {
                        contractAnnotationModel.setWeakVirtual(true);
                    }
                }
            };
            typeModel.accept(elementScanner);
            arrayList3.add(typeModel);
        }
        ArrayList<TypeModel> arrayList = new ArrayList<TypeModel>(arrayList3.size());
        Iterator iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            typeModel = (TypeModel)iterator.next();
            elementScanner = new ClassContractCreator(diagnosticManager);
            typeModel.accept(elementScanner);
            TypeModel typeModel2 = ((ClassContractCreator)elementScanner).getHelperType();
            arrayList.add(typeModel);
            if (typeModel2 == null) continue;
            arrayList.add(typeModel2);
        }
        return arrayList;
    }

    @Requires(value={"roundEnv != null"})
    @Ensures(value={"result != null"})
    protected Set<TypeElement> getContractedRootElements(RoundEnvironment roundEnvironment) {
        Set<? extends Element> set = roundEnvironment.getRootElements();
        HashSet<TypeElement> hashSet = new HashSet<TypeElement>(set.size());
        ContractFinder contractFinder = new ContractFinder(this.utils);
        for (Element element : set) {
            if (!element.accept(contractFinder, null).booleanValue()) continue;
            hashSet.add(AnnotationProcessor.getRootElement(element));
        }
        return hashSet;
    }

    @Requires(value={"element != null", "element.getKind() != ElementKind.PACKAGE", "element.getKind() != ElementKind.OTHER"})
    @Ensures(value={"element != null"})
    protected static TypeElement getRootElement(Element element) {
        TypeElement typeElement;
        if ((element.getKind().isClass() || element.getKind().isInterface()) && !(typeElement = (TypeElement)element).getNestingKind().isNested()) {
            return typeElement;
        }
        return AnnotationProcessor.getRootElement(element.getEnclosingElement());
    }
}

