/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.agent;

import com.google.java.contract.ContractEnvironment;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.AgentContractEnvironment;
import com.google.java.contract.core.agent.ContractClassFileTransformer;
import com.google.java.contract.core.util.DebugUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import javax.tools.JavaFileObject;
import org.objectweb.asm.ClassReader;

public class PreMain {
    private static void configure() {
        String string = System.getProperty("com.google.java.contract.configurator");
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                Object obj = clazz.newInstance();
                clazz.getMethod("configure", ContractEnvironment.class).invoke(obj, new AgentContractEnvironment());
            }
            catch (ClassNotFoundException classNotFoundException) {
                DebugUtils.warn("agent", "cannot find configurator class");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                DebugUtils.warn("agent", "cannot find configure method");
            }
            catch (Exception exception) {
                DebugUtils.warn("agent", "error during configure method: " + exception.toString());
            }
        }
    }

    public static void premain(String string, Instrumentation instrumentation) {
        ClassFileTransformer classFileTransformer = new ContractClassFileTransformer();
        String string2 = System.getProperty("com.google.java.contract.dump");
        if (string2 != null) {
            classFileTransformer = new DumpClassFileTransformer(classFileTransformer, string2);
        }
        instrumentation.addTransformer(classFileTransformer);
        PreMain.configure();
    }

    public static void main(String[] stringArray) throws IllegalClassFormatException, IOException {
        String string = System.getProperty("com.google.java.contract.classoutput");
        PreMain.instrument(stringArray, string);
    }

    public static void instrument(String[] stringArray, String string) throws IllegalClassFormatException, IOException {
        ContractClassFileTransformer contractClassFileTransformer = new ContractClassFileTransformer();
        PreMain.configure();
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            File file;
            File file2;
            String string2;
            String string3 = string2 = stringArray2[i];
            if (string2.endsWith(JavaFileObject.Kind.CLASS.extension)) {
                string3 = string3.substring(0, string3.length() - JavaFileObject.Kind.CLASS.extension.length());
            }
            if (string3.endsWith("$com$google$java$contract$H")) continue;
            File file3 = new File(string3 + JavaFileObject.Kind.CLASS.extension);
            File file4 = new File(string3 + ".contracts");
            File file5 = new File(string3 + "$com$google$java$contract$H" + JavaFileObject.Kind.CLASS.extension);
            byte[] byArray = PreMain.getBytes(file3);
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            if (string == null) {
                file2 = new File(string3 + ".class.contracted");
                file = new File(string3 + "$com$google$java$contract$H" + ".class.contracted");
            } else {
                object2 = PreMain.getClassName(byArray);
                object = string + "/" + (String)object2;
                file2 = new File((String)object + JavaFileObject.Kind.CLASS.extension);
                file = new File((String)object + "$com$google$java$contract$H" + JavaFileObject.Kind.CLASS.extension);
            }
            if (file5.isFile()) {
                object2 = PreMain.getBytes(file5);
                byArray3 = contractClassFileTransformer.transformWithDebug((byte[])object2);
            } else if (file4.isFile()) {
                object2 = PreMain.getBytes(file4);
                byArray2 = contractClassFileTransformer.transformWithContracts(byArray, (byte[])object2);
            }
            file2.getParentFile().mkdirs();
            object2 = new FileOutputStream(file2);
            ((FileOutputStream)object2).write(byArray2 == null ? byArray : byArray2);
            ((FileOutputStream)object2).close();
            if (byArray3 == null) continue;
            file.getParentFile().mkdirs();
            object = new FileOutputStream(file);
            ((FileOutputStream)object).write(byArray3);
            ((FileOutputStream)object).close();
        }
    }

    private static byte[] getBytes(File file) throws IOException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(file);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n = fileInputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private static String getClassName(byte[] byArray) throws IllegalClassFormatException {
        try {
            return new ClassReader(byArray).getClassName();
        }
        catch (Throwable throwable) {
            IllegalClassFormatException illegalClassFormatException = new IllegalClassFormatException();
            illegalClassFormatException.initCause(throwable);
            throw illegalClassFormatException;
        }
    }

    @Invariant(value={"transformer != null"})
    private static class DumpClassFileTransformer
    implements ClassFileTransformer {
        protected ClassFileTransformer transformer;

        @Requires(value={"parent != null", "dumpDir != null"})
        public DumpClassFileTransformer(ClassFileTransformer classFileTransformer, String string) {
            this.transformer = classFileTransformer;
            DebugUtils.setDumpDirectory(string);
        }

        @Override
        public byte[] transform(ClassLoader classLoader, String string, Class<?> clazz, ProtectionDomain protectionDomain, byte[] byArray) throws IllegalClassFormatException {
            byte[] byArray2 = this.transformer.transform(classLoader, string, clazz, protectionDomain, byArray);
            if (byArray2 != null) {
                DebugUtils.dump(string, byArray2, JavaFileObject.Kind.CLASS);
            }
            return byArray2;
        }
    }
}

