/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.agent;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import com.google.java.contract.core.model.ContractKind;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.MethodNode;

class ContractMethodSignatures {
    static final String CONTRACT_METHOD_SIGNATURE_DESC = Type.getObjectType("com/google/java/contract/core/agent/ContractMethodSignature").getDescriptor();

    ContractMethodSignatures() {
    }

    @Requires(value={"contractMethod != null"})
    static String getTarget(MethodNode methodNode) {
        return ContractMethodSignatures.getMetaData(methodNode, "target", String.class);
    }

    @Requires(value={"contractMethod != null"})
    static ContractKind getKind(MethodNode methodNode) {
        String[] stringArray = ContractMethodSignatures.getMetaData(methodNode, "kind", String[].class);
        if (stringArray != null) {
            return Enum.valueOf(ContractKind.class, stringArray[1]);
        }
        if (methodNode.name.startsWith("access$")) {
            return ContractKind.ACCESS;
        }
        return null;
    }

    @Requires(value={"contractMethod != null"})
    @Ensures(value={"result >= -1"})
    static int getId(MethodNode methodNode) {
        Integer n = ContractMethodSignatures.getMetaData(methodNode, "id", Integer.class);
        return n == null || n < 0 ? -1 : n;
    }

    @Requires(value={"contractMethod != null"})
    @Ensures(value={"result == null || isLineNumberList(result)"})
    static List<Long> getLineNumbers(MethodNode methodNode) {
        Object object = ContractMethodSignatures.getMetaData(methodNode, "lines", Object.class);
        return ContractMethodSignatures.getLineNumbers(object);
    }

    @Ensures(value={"lines == null ? result == null : isLineNumberList(result)"})
    static List<Long> getLineNumbers(Object object) {
        if (object == null) {
            return null;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        if (object.getClass().isArray()) {
            for (long l : (long[])object) {
                arrayList.add(l < 1L ? null : Long.valueOf(l));
            }
        } else {
            for (Long l : (List)object) {
                arrayList.add(l < 1L ? null : l);
            }
        }
        return arrayList;
    }

    static boolean isLineNumberList(List<Long> list) {
        if (list == null) {
            return false;
        }
        for (Long l : list) {
            if (l == null || l >= 1L) continue;
            return false;
        }
        return true;
    }

    @Requires(value={"contractMethod != null", "field != null", "clazz != null"})
    static <T> T getMetaData(MethodNode methodNode, String string, Class<T> clazz) {
        List list = methodNode.invisibleAnnotations;
        if (list == null) {
            return null;
        }
        for (AnnotationNode annotationNode : list) {
            if (!annotationNode.desc.equals(CONTRACT_METHOD_SIGNATURE_DESC)) continue;
            if (annotationNode.values == null) {
                return null;
            }
            Iterator iterator = annotationNode.values.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Object e = iterator.next();
                if (!string2.equals(string)) continue;
                return (T)e;
            }
        }
        return null;
    }
}

