/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.agent;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import com.google.java.contract.core.util.DebugUtils;
import com.google.java.contract.core.util.PatternMap;

@Invariant(value={"assertPre != null", "assertPost != null", "assertInvariant != null"})
public class ActivationRuleManager {
    protected static ActivationRuleManager instance = null;
    protected PatternMap<Boolean> assertPre = new PatternMap();
    protected PatternMap<Boolean> assertPost = new PatternMap();
    protected PatternMap<Boolean> assertInvariant = new PatternMap();

    protected ActivationRuleManager() {
        this.assertPre = new PatternMap();
        this.assertPost = new PatternMap();
        this.assertInvariant = new PatternMap();
    }

    public static ActivationRuleManager getInstance() {
        if (instance == null) {
            instance = new ActivationRuleManager();
        }
        return instance;
    }

    @Requires(value={"pattern != null"})
    @Ensures(value={"hasPreconditionsEnabled(pattern)"})
    public synchronized void enablePreconditions(String string) {
        DebugUtils.info("activation", string + " +requires");
        this.assertPre.put(string, true);
    }

    @Requires(value={"pattern != null"})
    @Ensures(value={"!hasPreconditionsEnabled(pattern)"})
    public synchronized void disablePreconditions(String string) {
        DebugUtils.info("activation", string + " -requires");
        this.assertPre.put(string, false);
    }

    @Requires(value={"pattern != null"})
    @Ensures(value={"hasPostconditionsEnabled(pattern)"})
    public synchronized void enablePostconditions(String string) {
        DebugUtils.info("activation", string + " +ensures");
        this.assertPost.put(string, true);
    }

    @Requires(value={"pattern != null"})
    @Ensures(value={"!hasPostconditionsEnabled(pattern)"})
    public synchronized void disablePostconditions(String string) {
        DebugUtils.info("activation", string + " -ensures");
        this.assertPost.put(string, false);
    }

    @Requires(value={"pattern != null"})
    @Ensures(value={"hasInvariantsEnabled(pattern)"})
    public synchronized void enableInvariants(String string) {
        DebugUtils.info("activation", string + " +invariant");
        this.assertInvariant.put(string, true);
    }

    @Requires(value={"pattern != null"})
    @Ensures(value={"!hasInvariantsEnabled(pattern)"})
    public synchronized void disableInvariants(String string) {
        DebugUtils.info("activation", string + " -invariant");
        this.assertInvariant.put(string, false);
    }

    @Requires(value={"pattern != null"})
    public synchronized boolean hasPreconditionsEnabled(String string) {
        if (string.endsWith(".*") && this.assertPre.isOverriden(string)) {
            return false;
        }
        Boolean bl = this.assertPre.get(string);
        return bl == null || bl != false;
    }

    @Requires(value={"pattern != null"})
    public synchronized boolean hasPostconditionsEnabled(String string) {
        if (string.endsWith(".*") && this.assertPost.isOverriden(string)) {
            return false;
        }
        Boolean bl = this.assertPost.get(string);
        return bl == null || bl != false;
    }

    @Requires(value={"pattern != null"})
    public synchronized boolean hasInvariantsEnabled(String string) {
        if (string.endsWith(".*") && this.assertInvariant.isOverriden(string)) {
            return false;
        }
        Boolean bl = this.assertInvariant.get(string);
        return bl == null || bl != false;
    }
}

