/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.exceptions.StingException;

public class SWPairwiseAlignment {
    private int alignment_offset;
    private Cigar alignmentCigar;
    private final double w_match;
    private final double w_mismatch;
    private final double w_open;
    private final double w_extend;
    private static final int MSTATE = 0;
    private static final int ISTATE = 1;
    private static final int DSTATE = 2;
    private static final int CLIP = 3;
    private static boolean cutoff = false;
    private static boolean DO_SOFTCLIP = true;
    double[] SW;

    public SWPairwiseAlignment(byte[] seq1, byte[] seq2, double match, double mismatch, double open, double extend) {
        this.w_match = match;
        this.w_mismatch = mismatch;
        this.w_open = open;
        this.w_extend = extend;
        this.align(seq1, seq2);
    }

    public SWPairwiseAlignment(byte[] seq1, byte[] seq2) {
        this(seq1, seq2, 1.0, -0.3333333333333333, -1.3333333333333333, -0.3333333333333333);
    }

    public Cigar getCigar() {
        return this.alignmentCigar;
    }

    public int getAlignmentStart2wrt1() {
        return this.alignment_offset;
    }

    public void align(byte[] a, byte[] b) {
        int n = a.length;
        int m = b.length;
        double[] sw = new double[(n + 1) * (m + 1)];
        this.SW = sw;
        int[] btrack = new int[(n + 1) * (m + 1)];
        this.calculateMatrix(a, b, sw, btrack);
        this.calculateCigar(n, m, sw, btrack);
    }

    private void calculateMatrix(byte[] a, byte[] b, double[] sw, int[] btrack) {
        int n = a.length + 1;
        int m = b.length + 1;
        double MATRIX_MIN_CUTOFF = cutoff ? 0.0 : -1.0E100;
        double[] best_gap_v = new double[m + 1];
        Arrays.fill(best_gap_v, -1.0E40);
        int[] gap_size_v = new int[m + 1];
        double[] best_gap_h = new double[n + 1];
        Arrays.fill(best_gap_h, -1.0E40);
        int[] gap_size_h = new int[n + 1];
        int row_offset_1 = 0;
        for (int i = 1; i < n; ++i) {
            byte a_base = a[i - 1];
            int row_offset = row_offset_1 + m;
            int j = 1;
            int data_offset_1 = row_offset_1;
            while (j < m) {
                byte b_base = b[j - 1];
                double step_diag = sw[data_offset_1] + this.wd(a_base, b_base);
                double prev_gap = sw[data_offset_1 + 1] + this.w_open;
                int n2 = j;
                best_gap_v[n2] = best_gap_v[n2] + this.w_extend;
                if (prev_gap > best_gap_v[j]) {
                    best_gap_v[j] = prev_gap;
                    gap_size_v[j] = 1;
                } else {
                    int n3 = j;
                    gap_size_v[n3] = gap_size_v[n3] + 1;
                }
                double step_down = best_gap_v[j];
                int kd = gap_size_v[j];
                int data_offset = row_offset + j;
                prev_gap = sw[data_offset - 1] + this.w_open;
                int n4 = i;
                best_gap_h[n4] = best_gap_h[n4] + this.w_extend;
                if (prev_gap > best_gap_h[i]) {
                    best_gap_h[i] = prev_gap;
                    gap_size_h[i] = 1;
                } else {
                    int n5 = i;
                    gap_size_h[n5] = gap_size_h[n5] + 1;
                }
                double step_right = best_gap_h[i];
                int ki = gap_size_h[i];
                if (step_down > step_right) {
                    if (step_down > step_diag) {
                        sw[data_offset] = Math.max(MATRIX_MIN_CUTOFF, step_down);
                        btrack[data_offset] = kd;
                    } else {
                        sw[data_offset] = Math.max(MATRIX_MIN_CUTOFF, step_diag);
                        btrack[data_offset] = 0;
                    }
                } else if (step_right > step_diag) {
                    sw[data_offset] = Math.max(MATRIX_MIN_CUTOFF, step_right);
                    btrack[data_offset] = -ki;
                } else {
                    sw[data_offset] = Math.max(MATRIX_MIN_CUTOFF, step_diag);
                    btrack[data_offset] = 0;
                }
                ++j;
                ++data_offset_1;
            }
            row_offset_1 = row_offset;
        }
    }

    private void calculateCigar(int n, int m, double[] sw, int[] btrack) {
        int p1 = 0;
        int p2 = 0;
        double maxscore = 0.0;
        int segment_length = 0;
        int i = 1;
        int data_offset = m + 1 + m;
        while (i < n + 1) {
            if (sw[data_offset] >= maxscore) {
                p1 = i;
                p2 = m;
                maxscore = sw[data_offset];
            }
            ++i;
            data_offset += m + 1;
        }
        int j = 1;
        data_offset = n * (m + 1) + 1;
        while (j < m + 1) {
            if (sw[data_offset] > maxscore || sw[data_offset] == maxscore && Math.abs(n - j) < Math.abs(p1 - p2)) {
                p1 = n;
                p2 = j;
                maxscore = sw[data_offset];
                segment_length = m - j;
            }
            ++j;
            ++data_offset;
        }
        ArrayList<CigarElement> lce = new ArrayList<CigarElement>(5);
        if (segment_length > 0 && DO_SOFTCLIP) {
            lce.add(this.makeElement(3, segment_length));
            segment_length = 0;
        }
        int state = 0;
        int data_offset2 = p1 * (m + 1) + p2;
        do {
            int new_state;
            int btr = btrack[data_offset2];
            int step_length = 1;
            if (btr > 0) {
                new_state = 2;
                step_length = btr;
            } else if (btr < 0) {
                new_state = 1;
                step_length = -btr;
            } else {
                new_state = 0;
            }
            switch (new_state) {
                case 0: {
                    data_offset2 -= m + 2;
                    --p1;
                    --p2;
                    break;
                }
                case 1: {
                    data_offset2 -= step_length;
                    p2 -= step_length;
                    break;
                }
                case 2: {
                    data_offset2 -= (m + 1) * step_length;
                    p1 -= step_length;
                }
            }
            if (new_state == state) {
                segment_length += step_length;
                continue;
            }
            lce.add(this.makeElement(state, segment_length));
            segment_length = step_length;
            state = new_state;
        } while (p1 > 0 && p2 > 0);
        if (DO_SOFTCLIP) {
            lce.add(this.makeElement(state, segment_length));
            if (p2 > 0) {
                lce.add(this.makeElement(3, p2));
            }
            this.alignment_offset = p1;
        } else {
            lce.add(this.makeElement(state, segment_length + p2));
            this.alignment_offset = p1 - p2;
        }
        Collections.reverse(lce);
        this.alignmentCigar = new Cigar(lce);
    }

    private CigarElement makeElement(int state, int segment_length) {
        CigarOperator o = null;
        switch (state) {
            case 0: {
                o = CigarOperator.M;
                break;
            }
            case 1: {
                o = CigarOperator.I;
                break;
            }
            case 2: {
                o = CigarOperator.D;
                break;
            }
            case 3: {
                o = CigarOperator.S;
            }
        }
        return new CigarElement(segment_length, o);
    }

    private double wd(byte x, byte y) {
        return x == y ? this.w_match : this.w_mismatch;
    }

    private double wk(int k) {
        return this.w_open + (double)(k - 1) * this.w_extend;
    }

    private void print(int[][] s) {
        for (int i = 0; i < s.length; ++i) {
            for (int j = 0; j < s[i].length; ++j) {
                System.out.printf(" %4d", s[i][j]);
            }
            System.out.println();
        }
    }

    private void print(double[][] s) {
        for (int i = 0; i < s.length; ++i) {
            for (int j = 0; j < s[i].length; ++j) {
                System.out.printf(" %4g", s[i][j]);
            }
            System.out.println();
        }
    }

    private void print(int[][] s, String a, String b) {
        System.out.print("        ");
        for (int j = 1; j < s[0].length; ++j) {
            System.out.printf(" %4c", Character.valueOf(b.charAt(j - 1)));
        }
        System.out.println();
        for (int i = 0; i < s.length; ++i) {
            if (i > 0) {
                System.out.print(a.charAt(i - 1));
            } else {
                System.out.print(' ');
            }
            System.out.print("  ");
            for (int j = 0; j < s[i].length; ++j) {
                System.out.printf(" %4d", s[i][j]);
            }
            System.out.println();
        }
    }

    private void print(double[][] s, String a, String b) {
        System.out.print("");
        for (int j = 1; j < s[0].length; ++j) {
            System.out.printf(" %4c", Character.valueOf(b.charAt(j - 1)));
        }
        System.out.println();
        for (int i = 0; i < s.length; ++i) {
            if (i > 0) {
                System.out.print(a.charAt(i - 1));
            } else {
                System.out.print(' ');
            }
            System.out.print("  ");
            for (int j = 0; j < s[i].length; ++j) {
                System.out.printf(" %2.1f", s[i][j]);
            }
            System.out.println();
        }
    }

    private void print(double[] s, byte[] a, byte[] b) {
        int n = a.length + 1;
        int m = b.length + 1;
        System.out.print("         ");
        for (int j = 1; j < m; ++j) {
            System.out.printf(" %5c", Character.valueOf((char)b[j - 1]));
        }
        System.out.println();
        int i = 0;
        int row_offset = 0;
        while (i < n) {
            if (i > 0) {
                System.out.print((char)a[i - 1]);
            } else {
                System.out.print(' ');
            }
            System.out.print("  ");
            for (int j = 0; j < m; ++j) {
                System.out.printf(" %5.1f", s[row_offset + j]);
            }
            System.out.println();
            ++i;
            row_offset += m;
        }
    }

    static void printAlignment(SWPairwiseAlignment a, byte[] ref, byte[] read) {
        SWPairwiseAlignment.printAlignment(a, ref, read, 100);
    }

    static void printAlignment(SWPairwiseAlignment a, byte[] ref, byte[] read, int width) {
        int j;
        StringBuilder bread = new StringBuilder();
        StringBuilder bref = new StringBuilder();
        StringBuilder match = new StringBuilder();
        int i = 0;
        int offset = a.getAlignmentStart2wrt1();
        Cigar cigar = a.getCigar();
        if (!DO_SOFTCLIP && offset < 0) {
            for (j = 0; j < -offset; ++j) {
                bread.append((char)read[j]);
                bref.append(' ');
                match.append(' ');
            }
            ArrayList<CigarElement> tweaked = new ArrayList<CigarElement>();
            tweaked.addAll(cigar.getCigarElements());
            tweaked.set(0, new CigarElement(cigar.getCigarElement(0).getLength() + offset, cigar.getCigarElement(0).getOperator()));
            cigar = new Cigar(tweaked);
        }
        if (offset > 0) {
            while (i < a.getAlignmentStart2wrt1()) {
                bref.append((char)ref[i]);
                bread.append(' ');
                match.append(' ');
                ++i;
            }
        }
        block8: for (CigarElement e : cigar.getCigarElements()) {
            switch (e.getOperator()) {
                case M: {
                    int z = 0;
                    while (z < e.getLength()) {
                        bref.append(i < ref.length ? (char)ref[i] : (char)' ');
                        bread.append(j < read.length ? (char)read[j] : (char)' ');
                        match.append((char)(i < ref.length && j < read.length ? (ref[i] == read[j] ? 46 : 42) : 32));
                        ++z;
                        ++i;
                        ++j;
                    }
                    continue block8;
                }
                case I: {
                    int z = 0;
                    while (z < e.getLength()) {
                        bref.append('-');
                        bread.append((char)read[j]);
                        match.append('I');
                        ++z;
                        ++j;
                    }
                    continue block8;
                }
                case S: {
                    int z = 0;
                    while (z < e.getLength()) {
                        bref.append(' ');
                        bread.append((char)read[j]);
                        match.append('S');
                        ++z;
                        ++j;
                    }
                    continue block8;
                }
                case D: {
                    int z = 0;
                    while (z < e.getLength()) {
                        bref.append((char)ref[i]);
                        bread.append('-');
                        match.append('D');
                        ++z;
                        ++i;
                    }
                    continue block8;
                }
                default: {
                    throw new StingException("Unexpected Cigar element:" + e.getOperator());
                }
            }
        }
        while (i < ref.length) {
            bref.append((char)ref[i]);
            ++i;
        }
        while (j < read.length) {
            bread.append((char)read[j]);
            ++j;
        }
        int maxlength = Math.max(match.length(), Math.max(bread.length(), bref.length()));
        for (int pos = 0; pos < maxlength; pos += width) {
            SWPairwiseAlignment.print_cautiously(match, pos, width);
            SWPairwiseAlignment.print_cautiously(bread, pos, width);
            SWPairwiseAlignment.print_cautiously(bref, pos, width);
            System.out.println();
        }
    }

    private static void print_cautiously(StringBuilder s, int start, int width) {
        if (start >= s.length()) {
            System.out.println();
            return;
        }
        int end = Math.min(start + width, s.length());
        System.out.println(s.substring(start, end));
    }

    public static void main(String[] argv) {
        String ref = null;
        String read = null;
        Map<String, List<String>> args = SWPairwiseAlignment.processArgs(argv);
        List<String> l = args.get("SEQ");
        args.remove("SEQ");
        if (l == null) {
            System.err.println("SEQ argument is missing. Two input sequences must be provided");
            System.exit(1);
        }
        if (l.size() != 2) {
            System.err.println("Two input sequences (SEQ arguments) must be provided. Found " + l.size() + " instead");
            System.exit(1);
        }
        ref = l.get(0);
        read = l.get(1);
        Double m = SWPairwiseAlignment.extractSingleDoubleArg("MATCH", args);
        Double mm = SWPairwiseAlignment.extractSingleDoubleArg("MISMATCH", args);
        Double open = SWPairwiseAlignment.extractSingleDoubleArg("OPEN", args);
        Double ext = SWPairwiseAlignment.extractSingleDoubleArg("EXTEND", args);
        Boolean reverse = SWPairwiseAlignment.extractSingleBooleanArg("REVERSE", args);
        if (reverse != null && reverse.booleanValue()) {
            ref = Utils.reverse(ref);
            read = Utils.reverse(read);
        }
        Boolean print_mat = SWPairwiseAlignment.extractSingleBooleanArg("PRINT_MATRIX", args);
        Boolean cut = SWPairwiseAlignment.extractSingleBooleanArg("CUTOFF", args);
        if (cut != null) {
            cutoff = cut;
        }
        if (args.size() != 0) {
            System.err.println("Unknown argument on the command line: " + args.keySet().iterator().next());
            System.exit(1);
        }
        double w_match = m == null ? 30.0 : m;
        double w_mismatch = mm == null ? -10.0 : mm;
        double w_open = open == null ? -10.0 : open;
        double w_extend = ext == null ? -2.0 : ext;
        SWPairwiseAlignment a = new SWPairwiseAlignment(ref.getBytes(), read.getBytes(), w_match, w_mismatch, w_open, w_extend);
        System.out.println("start=" + a.getAlignmentStart2wrt1() + ", cigar=" + a.getCigar() + " length1=" + ref.length() + " length2=" + read.length());
        System.out.println();
        SWPairwiseAlignment.printAlignment(a, ref.getBytes(), read.getBytes());
        System.out.println();
        if (print_mat != null && print_mat.booleanValue()) {
            a.print(a.SW, ref.getBytes(), read.getBytes());
        }
    }

    static Pair<String, Integer> getArg(String prefix, String[] argv, int i) {
        String arg = null;
        if (argv[i].startsWith(prefix)) {
            arg = argv[i].substring(prefix.length());
            if (arg.length() == 0) {
                if (++i < argv.length) {
                    arg = argv[i];
                } else {
                    System.err.println("No value found after " + prefix + " argument tag");
                    System.exit(1);
                }
            }
            ++i;
        }
        return new Pair<Object, Integer>(arg, i);
    }

    static Map<String, List<String>> processArgs(String[] argv) {
        HashMap<String, List<String>> args = new HashMap<String, List<String>>();
        for (int i = 0; i < argv.length; ++i) {
            ArrayList<String> l;
            String val;
            String arg = argv[i];
            int pos = arg.indexOf(61);
            if (pos < 0) {
                System.err.println("Argument " + arg + " is not of the form <ARG>=<VAL>");
                System.exit(1);
            }
            if ((val = arg.substring(pos + 1)).length() == 0) {
                if (++i < argv.length) {
                    val = argv[i];
                } else {
                    System.err.println("No value found after " + arg + " argument tag");
                    System.exit(1);
                }
            }
            if ((l = (ArrayList<String>)args.get(arg = arg.substring(0, pos))) == null) {
                l = new ArrayList<String>();
                args.put(arg, l);
            }
            l.add(val);
        }
        return args;
    }

    static Double extractSingleDoubleArg(String argname, Map<String, List<String>> args) {
        List<String> l = args.get(argname);
        args.remove(argname);
        if (l == null) {
            return null;
        }
        if (l.size() > 1) {
            System.err.println("Only one " + argname + " argument is allowed");
            System.exit(1);
        }
        double d = 0.0;
        try {
            d = Double.parseDouble(l.get(0));
        }
        catch (NumberFormatException e) {
            System.err.println("Can not parse value provided for " + argname + " argument (" + l.get(0) + ")");
            System.exit(1);
        }
        System.out.println("Argument " + argname + " set to " + d);
        return new Double(d);
    }

    static Boolean extractSingleBooleanArg(String argname, Map<String, List<String>> args) {
        List<String> l = args.get(argname);
        args.remove(argname);
        if (l == null) {
            return null;
        }
        if (l.size() > 1) {
            System.err.println("Only one " + argname + " argument is allowed");
            System.exit(1);
        }
        if (l.get(0).equals("true")) {
            return new Boolean(true);
        }
        if (l.get(0).equals("false")) {
            return new Boolean(false);
        }
        System.err.println("Can not parse value provided for " + argname + " argument (" + l.get(0) + "); true/false are allowed");
        System.exit(1);
        return null;
    }
}

