/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.map.AbstractIntDoubleMap;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.AbstractMatrix2D;
import cern.colt.matrix.impl.SelectedSparseDoubleMatrix1D;
import cern.colt.matrix.impl.SparseDoubleMatrix1D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;

class SelectedSparseDoubleMatrix2D
extends DoubleMatrix2D {
    protected AbstractIntDoubleMap elements;
    protected int[] rowOffsets;
    protected int[] columnOffsets;
    protected int offset;

    protected SelectedSparseDoubleMatrix2D(int n, int n2, AbstractIntDoubleMap abstractIntDoubleMap, int n3, int n4, int n5, int n6, int[] nArray, int[] nArray2, int n7) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = abstractIntDoubleMap;
        this.rowOffsets = nArray;
        this.columnOffsets = nArray2;
        this.offset = n7;
        this.isNoView = false;
    }

    protected SelectedSparseDoubleMatrix2D(AbstractIntDoubleMap abstractIntDoubleMap, int[] nArray, int[] nArray2, int n) {
        this(nArray.length, nArray2.length, abstractIntDoubleMap, 0, 0, 1, 1, nArray, nArray2, n);
    }

    protected int _columnOffset(int n) {
        return this.columnOffsets[n];
    }

    protected int _rowOffset(int n) {
        return this.rowOffsets[n];
    }

    public double getQuick(int n, int n2) {
        return this.elements.get(this.offset + this.rowOffsets[this.rowZero + n * this.rowStride] + this.columnOffsets[this.columnZero + n2 * this.columnStride]);
    }

    protected boolean haveSharedCellsRaw(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D instanceof SelectedSparseDoubleMatrix2D) {
            SelectedSparseDoubleMatrix2D selectedSparseDoubleMatrix2D = (SelectedSparseDoubleMatrix2D)doubleMatrix2D;
            return this.elements == selectedSparseDoubleMatrix2D.elements;
        }
        if (doubleMatrix2D instanceof SparseDoubleMatrix2D) {
            SparseDoubleMatrix2D sparseDoubleMatrix2D = (SparseDoubleMatrix2D)doubleMatrix2D;
            return this.elements == sparseDoubleMatrix2D.elements;
        }
        return false;
    }

    protected int index(int n, int n2) {
        return this.offset + this.rowOffsets[this.rowZero + n * this.rowStride] + this.columnOffsets[this.columnZero + n2 * this.columnStride];
    }

    public DoubleMatrix2D like(int n, int n2) {
        return new SparseDoubleMatrix2D(n, n2);
    }

    public DoubleMatrix1D like1D(int n) {
        return new SparseDoubleMatrix1D(n);
    }

    protected DoubleMatrix1D like1D(int n, int n2, int n3) {
        throw new InternalError();
    }

    public void setQuick(int n, int n2, double d) {
        int n3 = this.offset + this.rowOffsets[this.rowZero + n * this.rowStride] + this.columnOffsets[this.columnZero + n2 * this.columnStride];
        if (d == 0.0) {
            this.elements.removeKey(n3);
        } else {
            this.elements.put(n3, d);
        }
    }

    protected void setUp(int n, int n2) {
        super.setUp(n, n2);
        this.rowStride = 1;
        this.columnStride = 1;
        this.offset = 0;
    }

    protected AbstractMatrix2D vDice() {
        super.vDice();
        int[] nArray = this.rowOffsets;
        this.rowOffsets = this.columnOffsets;
        this.columnOffsets = nArray;
        this.isNoView = false;
        return this;
    }

    public DoubleMatrix1D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.rows;
        int n3 = this.rowZero;
        int n4 = this.rowStride;
        int[] nArray = this.rowOffsets;
        int n5 = this.offset + this._columnOffset(this._columnRank(n));
        return new SelectedSparseDoubleMatrix1D(n2, this.elements, n3, n4, nArray, n5);
    }

    public DoubleMatrix1D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.columns;
        int n3 = this.columnZero;
        int n4 = this.columnStride;
        int[] nArray = this.columnOffsets;
        int n5 = this.offset + this._rowOffset(this._rowRank(n));
        return new SelectedSparseDoubleMatrix1D(n2, this.elements, n3, n4, nArray, n5);
    }

    protected DoubleMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedSparseDoubleMatrix2D(this.elements, nArray, nArray2, this.offset);
    }
}

