/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.variantcontext;

import java.util.EnumMap;
import org.broad.tribble.TribbleException;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.Genotype;

public class GenotypeLikelihoods {
    public static final boolean CAP_PLS = false;
    public static final int PL_CAP = 255;
    private double[] log10Likelihoods = null;
    private String likelihoodsAsString_PLs = null;
    public static final int MAX_ALT_ALLELES_THAT_CAN_BE_GENOTYPED = 50;
    private static final GenotypeLikelihoodsAllelePair[] PLIndexToAlleleIndex = GenotypeLikelihoods.calculatePLcache(50);
    protected static int[] PLindexConversion = new int[]{0, 1, 3, 6, 2, 4, 7, 5, 8, 9};

    public static final GenotypeLikelihoods fromPLField(String PLs) {
        return new GenotypeLikelihoods(PLs);
    }

    public static final GenotypeLikelihoods fromGLField(String GLs) {
        return new GenotypeLikelihoods(GenotypeLikelihoods.parseDeprecatedGLString(GLs));
    }

    public static final GenotypeLikelihoods fromLog10Likelihoods(double[] log10Likelihoods) {
        return new GenotypeLikelihoods(log10Likelihoods);
    }

    protected GenotypeLikelihoods(String asString) {
        this.likelihoodsAsString_PLs = asString;
    }

    protected GenotypeLikelihoods(double[] asVector) {
        this.log10Likelihoods = asVector;
    }

    public double[] getAsVector() {
        if (this.log10Likelihoods == null) {
            this.log10Likelihoods = GenotypeLikelihoods.parsePLsIntoLikelihoods(this.likelihoodsAsString_PLs);
        }
        return this.log10Likelihoods;
    }

    public String toString() {
        return this.getAsString();
    }

    public String getAsString() {
        if (this.likelihoodsAsString_PLs == null) {
            if (this.log10Likelihoods == null) {
                throw new TribbleException("BUG: Attempted to get likelihoods as strings and neither the vector nor the string is set!");
            }
            this.likelihoodsAsString_PLs = GenotypeLikelihoods.convertLikelihoodsToPLString(this.log10Likelihoods);
        }
        return this.likelihoodsAsString_PLs;
    }

    public EnumMap<Genotype.Type, Double> getAsMap(boolean normalizeFromLog10) {
        double[] likelihoods;
        double[] dArray = likelihoods = normalizeFromLog10 ? MathUtils.normalizeFromLog10((double[])this.getAsVector()) : this.getAsVector();
        if (likelihoods == null) {
            return null;
        }
        EnumMap<Genotype.Type, Double> likelihoodsMap = new EnumMap<Genotype.Type, Double>(Genotype.Type.class);
        likelihoodsMap.put(Genotype.Type.HOM_REF, likelihoods[Genotype.Type.HOM_REF.ordinal() - 1]);
        likelihoodsMap.put(Genotype.Type.HET, likelihoods[Genotype.Type.HET.ordinal() - 1]);
        likelihoodsMap.put(Genotype.Type.HOM_VAR, likelihoods[Genotype.Type.HOM_VAR.ordinal() - 1]);
        return likelihoodsMap;
    }

    public double getLog10GQ(Genotype.Type genotype) {
        return GenotypeLikelihoods.getQualFromLikelihoods(genotype.ordinal() - 1, this.getAsVector());
    }

    public static double getQualFromLikelihoods(int iOfChoosenGenotype, double[] likelihoods) {
        if (likelihoods == null) {
            return Double.NEGATIVE_INFINITY;
        }
        double qual = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < likelihoods.length; ++i) {
            if (i == iOfChoosenGenotype || !(likelihoods[i] >= qual)) continue;
            qual = likelihoods[i];
        }
        if ((qual = likelihoods[iOfChoosenGenotype] - qual) < 0.0) {
            double[] normalized = MathUtils.normalizeFromLog10((double[])likelihoods);
            double chosenGenotype = normalized[iOfChoosenGenotype];
            return Math.log10(1.0 - chosenGenotype);
        }
        return -1.0 * qual;
    }

    private static final double[] parsePLsIntoLikelihoods(String likelihoodsAsString_PLs) {
        if (!likelihoodsAsString_PLs.equals(".")) {
            String[] strings = likelihoodsAsString_PLs.split(",");
            double[] likelihoodsAsVector = new double[strings.length];
            try {
                for (int i = 0; i < strings.length; ++i) {
                    likelihoodsAsVector[i] = (double)Integer.parseInt(strings[i]) / -10.0;
                }
            }
            catch (NumberFormatException e) {
                throw new UserException.MalformedVCF("The GL/PL tag contains non-integer values: " + likelihoodsAsString_PLs);
            }
            return likelihoodsAsVector;
        }
        return null;
    }

    private static final double[] parseDeprecatedGLString(String GLString) {
        if (!GLString.equals(".")) {
            String[] strings = GLString.split(",");
            double[] likelihoodsAsVector = new double[strings.length];
            for (int i = 0; i < strings.length; ++i) {
                likelihoodsAsVector[i] = Double.parseDouble(strings[i]);
            }
            return likelihoodsAsVector;
        }
        return null;
    }

    private static final String convertLikelihoodsToPLString(double[] GLs) {
        if (GLs == null) {
            return ".";
        }
        StringBuilder s = new StringBuilder();
        double adjust = Double.NEGATIVE_INFINITY;
        for (double l : GLs) {
            adjust = Math.max(adjust, l);
        }
        boolean first = true;
        for (double l : GLs) {
            if (!first) {
                s.append(",");
            } else {
                first = false;
            }
            long PL = Math.round(-10.0 * (l - adjust));
            s.append(Long.toString(PL));
        }
        return s.toString();
    }

    private static GenotypeLikelihoodsAllelePair[] calculatePLcache(int altAlleles) {
        int numLikelihoods = GenotypeLikelihoods.calculateNumLikelihoods(1 + altAlleles, 2);
        GenotypeLikelihoodsAllelePair[] cache = new GenotypeLikelihoodsAllelePair[numLikelihoods];
        for (int allele1 = 0; allele1 <= altAlleles; ++allele1) {
            for (int allele2 = allele1; allele2 <= altAlleles; ++allele2) {
                cache[GenotypeLikelihoods.calculatePLindex((int)allele1, (int)allele2)] = new GenotypeLikelihoodsAllelePair(allele1, allele2);
            }
        }
        for (int i = 0; i < cache.length; ++i) {
            if (cache[i] != null) continue;
            throw new ReviewedStingException("BUG: cache entry " + i + " is unexpected null");
        }
        return cache;
    }

    public static int calculateNumLikelihoods(int numAlleles, int ploidy) {
        if (ploidy == 2) {
            return numAlleles * (numAlleles + 1) / 2;
        }
        if (numAlleles == 1) {
            return 1;
        }
        if (ploidy == 1) {
            return numAlleles;
        }
        int acc = 0;
        for (int k = 0; k <= ploidy; ++k) {
            acc += GenotypeLikelihoods.calculateNumLikelihoods(numAlleles - 1, ploidy - k);
        }
        return acc;
    }

    public static int calculatePLindex(int allele1Index, int allele2Index) {
        return allele2Index * (allele2Index + 1) / 2 + allele1Index;
    }

    public static GenotypeLikelihoodsAllelePair getAllelePair(int PLindex) {
        if (PLindex >= PLIndexToAlleleIndex.length) {
            throw new ReviewedStingException("GATK limitation: cannot genotype more than 50 alleles");
        }
        return PLIndexToAlleleIndex[PLindex];
    }

    @Deprecated
    public static GenotypeLikelihoodsAllelePair getAllelePairUsingDeprecatedOrdering(int PLindex) {
        return GenotypeLikelihoods.getAllelePair(PLindexConversion[PLindex]);
    }

    public static int[] getPLIndecesOfAlleles(int allele1Index, int allele2Index) {
        int[] indexes = new int[]{GenotypeLikelihoods.calculatePLindex(allele1Index, allele1Index), GenotypeLikelihoods.calculatePLindex(allele1Index, allele2Index), GenotypeLikelihoods.calculatePLindex(allele2Index, allele2Index)};
        return indexes;
    }

    public static class GenotypeLikelihoodsAllelePair {
        public final int alleleIndex1;
        public final int alleleIndex2;

        public GenotypeLikelihoodsAllelePair(int alleleIndex1, int alleleIndex2) {
            this.alleleIndex1 = alleleIndex1;
            this.alleleIndex2 = alleleIndex2;
        }
    }
}

