/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.codecs.vcf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broad.tribble.TribbleException;
import org.broad.tribble.readers.LineReader;
import org.broad.tribble.util.ParsingUtils;
import org.broadinstitute.sting.utils.codecs.vcf.AbstractVCFCodec;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderVersion;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.LazyGenotypesContext;

public class VCFCodec
extends AbstractVCFCodec {
    public static final String VCF4_MAGIC_HEADER = "##fileformat=VCFv4";

    @Override
    public Object readHeader(LineReader reader) {
        ArrayList<String> headerStrings = new ArrayList<String>();
        try {
            String line;
            boolean foundHeaderVersion = false;
            while ((line = reader.readLine()) != null) {
                ++this.lineNo;
                if (line.startsWith("##")) {
                    String[] lineFields = line.substring(2).split("=");
                    if (lineFields.length == 2 && VCFHeaderVersion.isFormatString(lineFields[0])) {
                        if (!VCFHeaderVersion.isVersionString(lineFields[1])) {
                            throw new TribbleException.InvalidHeader(lineFields[1] + " is not a supported version");
                        }
                        foundHeaderVersion = true;
                        this.version = VCFHeaderVersion.toHeaderVersion(lineFields[1]);
                        if (this.version == VCFHeaderVersion.VCF3_3 || this.version == VCFHeaderVersion.VCF3_2) {
                            throw new TribbleException.InvalidHeader("This codec is strictly for VCFv4; please use the VCF3 codec for " + lineFields[1]);
                        }
                        if (this.version != VCFHeaderVersion.VCF4_0 && this.version != VCFHeaderVersion.VCF4_1) {
                            throw new TribbleException.InvalidHeader("This codec is strictly for VCFv4 and does not support " + lineFields[1]);
                        }
                    }
                    headerStrings.add(line);
                    continue;
                }
                if (line.startsWith("#")) {
                    if (!foundHeaderVersion) {
                        throw new TribbleException.InvalidHeader("We never saw a header line specifying VCF version");
                    }
                    return this.createHeader(headerStrings, line);
                }
                throw new TribbleException.InvalidHeader("We never saw the required CHROM header line (starting with one #) for the input VCF file");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("IO Exception ", e);
        }
        throw new TribbleException.InvalidHeader("We never saw the required CHROM header line (starting with one #) for the input VCF file");
    }

    @Override
    protected Set<String> parseFilters(String filterString) {
        return VCFCodec.parseFilters(this.filterHash, this.lineNo, filterString);
    }

    public static Set<String> parseFilters(Map<String, LinkedHashSet<String>> cache, int lineNo, String filterString) {
        if (filterString.equals(".")) {
            return null;
        }
        if (filterString.equals("PASS")) {
            return Collections.emptySet();
        }
        if (filterString.equals("0")) {
            VCFCodec.generateException("0 is an invalid filter name in vcf4", lineNo);
        }
        if (filterString.length() == 0) {
            VCFCodec.generateException("The VCF specification requires a valid filter status: filter was " + filterString, lineNo);
        }
        if (cache != null && cache.containsKey(filterString)) {
            return Collections.unmodifiableSet((Set)cache.get(filterString));
        }
        LinkedHashSet<String> fFields = new LinkedHashSet<String>();
        if (filterString.indexOf(";") == -1) {
            fFields.add(filterString);
        } else {
            fFields.addAll(Arrays.asList(filterString.split(";")));
        }
        if (cache != null) {
            cache.put(filterString, fFields);
        }
        return Collections.unmodifiableSet(fFields);
    }

    @Override
    public LazyGenotypesContext.LazyData createGenotypeMap(String str, List<Allele> alleles, String chr, int pos) {
        int nParts;
        if (this.genotypeParts == null) {
            this.genotypeParts = new String[this.header.getColumnCount() - 8];
        }
        if ((nParts = ParsingUtils.split((String)str, (String[])this.genotypeParts, (char)'\t')) != this.genotypeParts.length) {
            VCFCodec.generateException("there are " + (nParts - 1) + " genotypes while the header requires that " + (this.genotypeParts.length - 1) + " genotypes be present for all records", this.lineNo);
        }
        ArrayList<Genotype> genotypes = new ArrayList<Genotype>(nParts);
        int nGTKeys = ParsingUtils.split((String)this.genotypeParts[0], (String[])this.genotypeKeyArray, (char)':');
        Iterator<String> sampleNameIterator = this.header.getGenotypeSamples().iterator();
        this.alleleMap.clear();
        for (int genotypeOffset = 1; genotypeOffset < nParts; ++genotypeOffset) {
            int GTValueSplitSize = ParsingUtils.split((String)this.genotypeParts[genotypeOffset], (String[])this.GTValueArray, (char)':');
            double GTQual = 1.0;
            Set<String> genotypeFilters = null;
            HashMap<String, Object> gtAttributes = null;
            String sampleName = sampleNameIterator.next();
            if (nGTKeys < GTValueSplitSize) {
                this.generateException("There are too many keys for the sample " + sampleName + ", keys = " + this.parts[8] + ", values = " + this.parts[genotypeOffset]);
            }
            int genotypeAlleleLocation = -1;
            if (nGTKeys >= 1) {
                gtAttributes = new HashMap<String, Object>(nGTKeys - 1);
                for (int i = 0; i < nGTKeys; ++i) {
                    boolean missing;
                    String gtKey = new String(this.genotypeKeyArray[i]);
                    boolean bl = missing = i >= GTValueSplitSize;
                    if (gtKey.equals("GT")) {
                        genotypeAlleleLocation = i;
                        continue;
                    }
                    if (gtKey.equals("GQ")) {
                        GTQual = missing ? VCFCodec.parseQual(".") : VCFCodec.parseQual(this.GTValueArray[i]);
                        continue;
                    }
                    if (gtKey.equals("FT")) {
                        genotypeFilters = missing ? this.parseFilters(".") : this.parseFilters(this.getCachedString(this.GTValueArray[i]));
                        continue;
                    }
                    if (missing) {
                        gtAttributes.put(gtKey, ".");
                        continue;
                    }
                    gtAttributes.put(gtKey, new String(this.GTValueArray[i]));
                }
            }
            if (this.version == VCFHeaderVersion.VCF4_0 && genotypeAlleleLocation == -1) {
                this.generateException("Unable to find the GT field for the record; the GT field is required in VCF4.0");
            }
            if (genotypeAlleleLocation > 0) {
                this.generateException("Saw GT field at position " + genotypeAlleleLocation + ", but it must be at the first position for genotypes when present");
            }
            ArrayList<Allele> GTalleles = genotypeAlleleLocation == -1 ? new ArrayList<Allele>(0) : VCFCodec.parseGenotypeAlleles(this.GTValueArray[genotypeAlleleLocation], alleles, this.alleleMap);
            boolean phased = genotypeAlleleLocation != -1 && this.GTValueArray[genotypeAlleleLocation].indexOf("|") != -1;
            try {
                genotypes.add(new Genotype(sampleName, GTalleles, GTQual, genotypeFilters, gtAttributes, phased));
                continue;
            }
            catch (TribbleException e) {
                throw new TribbleException.InternalCodecException(e.getMessage() + ", at position " + chr + ":" + pos);
            }
        }
        return new LazyGenotypesContext.LazyData(genotypes, this.header.sampleNamesInOrder, this.header.sampleNameToOffset);
    }

    public boolean canDecode(String potentialInput) {
        return VCFCodec.canDecodeFile(potentialInput, VCF4_MAGIC_HEADER);
    }
}

