/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.exceptions;

import java.lang.reflect.InvocationTargetException;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class DynamicClassResolutionException
extends UserException {
    public DynamicClassResolutionException(Class c, Exception ex) {
        super(String.format("Could not create module %s because %s caused by exception %s", c.getSimpleName(), DynamicClassResolutionException.moreInfo(ex), ex.getMessage()));
    }

    private static String moreInfo(Exception ex) {
        try {
            throw ex;
        }
        catch (InstantiationException e) {
            return "BUG: cannot instantiate class: must be concrete class";
        }
        catch (NoSuchMethodException e) {
            return "BUG: Cannot find expected constructor for class";
        }
        catch (IllegalAccessException e) {
            return "Cannot instantiate class (Illegal Access)";
        }
        catch (InvocationTargetException e) {
            return "Cannot instantiate class (Invocation failure)";
        }
        catch (Exception e) {
            return String.format("an exception of type %s occurred", e.getClass().getSimpleName());
        }
    }
}

