/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.BarcodeData;
import net.sf.picard.illumina.parser.IlluminaDataType;
import net.sf.picard.illumina.parser.IlluminaFileMap;
import net.sf.picard.illumina.parser.IlluminaParser;
import net.sf.picard.illumina.parser.IlluminaTextIterator;
import net.sf.picard.illumina.parser.ReadStructure;
import net.sf.picard.util.CollectionUtil;

class BarcodeParser
implements IlluminaParser<BarcodeData> {
    private static final int Y_OR_N_COLUMN = 1;
    private static final int BARCODE_COLUMN = 2;
    private final IlluminaTextIterator textIterator;
    private final IlluminaFileMap tilesToFiles;
    private static final Set<IlluminaDataType> SupportedTypes = Collections.unmodifiableSet(CollectionUtil.makeSet(IlluminaDataType.Barcodes));

    public BarcodeParser(int lane, IlluminaFileMap tilesToFiles) {
        this.textIterator = new IlluminaTextIterator(lane, tilesToFiles, false);
        this.tilesToFiles = tilesToFiles;
    }

    @Override
    public void seekToTile(int oneBasedTileNumber) {
        this.textIterator.seekToTile(oneBasedTileNumber);
    }

    @Override
    public BarcodeData next() {
        String[] fields = this.textIterator.next();
        final String barcode = fields[1].equals("Y") ? fields[2] : null;
        return new BarcodeData(){

            @Override
            public String getBarcode() {
                return barcode;
            }
        };
    }

    @Override
    public boolean hasNext() {
        return this.textIterator.hasNext();
    }

    @Override
    public void verifyData(ReadStructure readStructure, List<Integer> tiles) {
        if (tiles == null) {
            tiles = new ArrayList<Integer>();
            tiles.addAll(this.tilesToFiles.keySet());
        }
        for (Integer tile : tiles) {
            File barcodeFile = (File)this.tilesToFiles.get(tile);
            if (barcodeFile == null) {
                throw new PicardException("Missing barcode file for tile(" + tile + ")");
            }
            if (barcodeFile.exists()) continue;
            throw new PicardException("Barcode file (" + barcodeFile.getAbsolutePath() + " does not exist for tile(" + tile + ")");
        }
    }

    @Override
    public Set<IlluminaDataType> supportedTypes() {
        return SupportedTypes;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported by " + BarcodeParser.class.getName());
    }
}

