/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.alignment;

import java.io.File;
import net.sf.picard.reference.ReferenceSequenceFileFactory;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMSequenceDictionary;
import org.broadinstitute.sting.alignment.bwa.BWAConfiguration;
import org.broadinstitute.sting.alignment.bwa.BWTFiles;
import org.broadinstitute.sting.alignment.bwa.c.BWACAligner;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.io.StingSAMFileWriter;
import org.broadinstitute.sting.gatk.refdata.ReadMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.ReadWalker;
import org.broadinstitute.sting.gatk.walkers.WalkerName;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

@WalkerName(value="Align")
public class AlignmentWalker
extends ReadWalker<Integer, Integer> {
    @Argument(fullName="target_reference", shortName="target_ref", doc="The reference to which reads in the source file should be aligned.  Alongside this reference should sit index files generated by bwa index -d bwtsw.  If unspecified, will default to the reference specified via the -R argument.", required=false)
    private File targetReferenceFile = null;
    @Output
    private StingSAMFileWriter out = null;
    private BWACAligner aligner = null;
    private SAMFileHeader header;

    public void initialize() {
        if (this.targetReferenceFile == null) {
            this.targetReferenceFile = this.getToolkit().getArguments().referenceFile;
        }
        BWTFiles bwtFiles = new BWTFiles(this.targetReferenceFile.getAbsolutePath());
        BWAConfiguration configuration = new BWAConfiguration();
        this.aligner = new BWACAligner(bwtFiles, configuration);
        this.header = this.getToolkit().getSAMFileHeader().clone();
        SAMSequenceDictionary referenceDictionary = ReferenceSequenceFileFactory.getReferenceSequenceFile((File)this.targetReferenceFile).getSequenceDictionary();
        this.header.setSequenceDictionary(referenceDictionary);
        this.header.setSortOrder(SAMFileHeader.SortOrder.unsorted);
        this.out.writeHeader(this.header);
    }

    public Integer map(ReferenceContext ref, GATKSAMRecord read, ReadMetaDataTracker metaDataTracker) {
        SAMRecord alignedRead = this.aligner.align((SAMRecord)read, this.header);
        this.out.addAlignment(alignedRead);
        return 1;
    }

    public Integer reduceInit() {
        return 0;
    }

    public Integer reduce(Integer value, Integer sum) {
        return value + sum;
    }

    public void onTraversalDone(Integer result) {
        this.aligner.close();
        super.onTraversalDone((Object)result);
    }
}

