/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.alignment;

import java.util.Iterator;
import org.broadinstitute.sting.alignment.Alignment;
import org.broadinstitute.sting.alignment.bwa.BWAConfiguration;
import org.broadinstitute.sting.alignment.bwa.BWTFiles;
import org.broadinstitute.sting.alignment.bwa.c.BWACAligner;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.ReadMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.ReadWalker;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class AlignmentValidationWalker
extends ReadWalker<Integer, Integer> {
    @Argument(fullName="BWTPrefix", shortName="BWT", doc="Index files generated by bwa index -d bwtsw", required=false)
    private String prefix = null;
    private BWACAligner aligner = null;

    public void initialize() {
        if (this.prefix == null) {
            this.prefix = this.getToolkit().getArguments().referenceFile.getAbsolutePath();
        }
        BWTFiles bwtFiles = new BWTFiles(this.prefix);
        BWAConfiguration configuration = new BWAConfiguration();
        this.aligner = new BWACAligner(bwtFiles, configuration);
    }

    public Integer map(ReferenceContext ref, GATKSAMRecord read, ReadMetaDataTracker metaDataTracker) {
        byte[] bases = read.getReadBases();
        if (read.getReadNegativeStrandFlag()) {
            bases = BaseUtils.simpleReverseComplement((byte[])bases);
        }
        boolean matches = true;
        Iterable<Alignment[]> alignments = this.aligner.getAllAlignments(bases);
        Iterator<Alignment[]> alignmentIterator = alignments.iterator();
        if (!alignmentIterator.hasNext()) {
            matches = read.getReadUnmappedFlag();
        } else {
            Alignment[] alignmentsOfBestQuality;
            for (Alignment alignment : alignmentsOfBestQuality = alignmentIterator.next()) {
                matches = alignment.getContigIndex() == read.getReferenceIndex().intValue();
                matches &= alignment.getAlignmentStart() == (long)read.getAlignmentStart();
                matches &= alignment.isNegativeStrand() == read.getReadNegativeStrandFlag();
                matches &= alignment.getCigar().equals((Object)read.getCigar());
                if (matches &= alignment.getMappingQuality() == read.getMappingQuality()) break;
            }
        }
        if (!matches) {
            logger.error((Object)"Found mismatch!");
            logger.error((Object)String.format("Read %s:", read.getReadName()));
            logger.error((Object)String.format("    Contig index: %d", read.getReferenceIndex()));
            logger.error((Object)String.format("    Alignment start: %d", read.getAlignmentStart()));
            logger.error((Object)String.format("    Negative strand: %b", read.getReadNegativeStrandFlag()));
            logger.error((Object)String.format("    Cigar: %s%n", read.getCigarString()));
            logger.error((Object)String.format("    Mapping quality: %s%n", read.getMappingQuality()));
            for (Alignment[] alignmentsByScore : alignments) {
                for (int i = 0; i < alignmentsByScore.length; ++i) {
                    logger.error((Object)String.format("Alignment %d:", i));
                    logger.error((Object)String.format("    Contig index: %d", alignmentsByScore[i].getContigIndex()));
                    logger.error((Object)String.format("    Alignment start: %d", alignmentsByScore[i].getAlignmentStart()));
                    logger.error((Object)String.format("    Negative strand: %b", alignmentsByScore[i].isNegativeStrand()));
                    logger.error((Object)String.format("    Cigar: %s", alignmentsByScore[i].getCigarString()));
                    logger.error((Object)String.format("    Mapping quality: %s%n", alignmentsByScore[i].getMappingQuality()));
                }
            }
            throw new ReviewedStingException(String.format("Read %s mismatches!", read.getReadName()));
        }
        return 1;
    }

    public Integer reduceInit() {
        return 0;
    }

    public Integer reduce(Integer value, Integer sum) {
        return value + sum;
    }

    public void onTraversalDone(Integer result) {
        this.aligner.close();
        super.onTraversalDone((Object)result);
    }
}

