/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.ext.beans.BeansWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleCollection;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.WrappingTemplateModel;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class SimpleHash
extends WrappingTemplateModel
implements TemplateHashModelEx,
Serializable {
    private Map map;
    private boolean putFailed;
    private Map unwrappedMap;

    public SimpleHash() {
        this((ObjectWrapper)null);
    }

    public SimpleHash(Map map2) {
        this(map2, null);
    }

    public SimpleHash(ObjectWrapper wrapper) {
        super(wrapper);
        this.map = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleHash(Map map2, ObjectWrapper wrapper) {
        super(wrapper);
        try {
            this.map = this.copyMap(map2);
        }
        catch (ConcurrentModificationException cme) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            Map map3 = map2;
            synchronized (map3) {
                this.map = this.copyMap(map2);
            }
        }
    }

    protected Map copyMap(Map map2) {
        if (map2 instanceof HashMap) {
            return (Map)((HashMap)map2).clone();
        }
        if (map2 instanceof SortedMap) {
            if (map2 instanceof TreeMap) {
                return (Map)((TreeMap)map2).clone();
            }
            return new TreeMap((SortedMap)map2);
        }
        return new HashMap(map2);
    }

    public void put(String key, Object obj) {
        this.map.put(key, obj);
        this.unwrappedMap = null;
    }

    public void put(String key, boolean b) {
        this.put(key, b ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE);
    }

    public TemplateModel get(String key) throws TemplateModelException {
        Object putKey;
        Object result2 = this.map.get(key);
        if (result2 == null) {
            if (key.length() == 1) {
                Character charKey = new Character(key.charAt(0));
                result2 = this.map.get(charKey);
                if (result2 == null && !this.map.containsKey(key) && !this.map.containsKey(charKey)) {
                    return null;
                }
                putKey = charKey;
            } else {
                if (!this.map.containsKey(key)) {
                    return null;
                }
                putKey = key;
            }
        } else {
            putKey = key;
        }
        if (result2 instanceof TemplateModel) {
            return (TemplateModel)result2;
        }
        TemplateModel tm = this.wrap(result2);
        if (!this.putFailed) {
            try {
                this.map.put(putKey, tm);
            }
            catch (Exception e) {
                this.putFailed = true;
            }
        }
        return tm;
    }

    public void remove(String key) {
        this.map.remove(key);
    }

    public void putAll(Map m) {
        Iterator it = m.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            this.put((String)entry.getKey(), entry.getValue());
        }
    }

    public Map toMap() throws TemplateModelException {
        if (this.unwrappedMap == null) {
            Class<?> mapClass = this.map.getClass();
            Map m = null;
            try {
                m = (Map)mapClass.newInstance();
            }
            catch (Exception e) {
                throw new TemplateModelException("Error instantiating map of type " + mapClass.getName() + "\n" + e.getMessage());
            }
            BeansWrapper bw = BeansWrapper.getDefaultInstance();
            Iterator it = this.map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object key = entry.getKey();
                Object value2 = entry.getValue();
                if (value2 instanceof TemplateModel) {
                    value2 = bw.unwrap((TemplateModel)value2);
                }
                m.put(key, value2);
            }
            this.unwrappedMap = m;
        }
        return this.unwrappedMap;
    }

    public String toString() {
        return this.map.toString();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map == null || this.map.isEmpty();
    }

    public TemplateCollectionModel keys() {
        return new SimpleCollection(this.map.keySet(), this.getObjectWrapper());
    }

    public TemplateCollectionModel values() {
        return new SimpleCollection(this.map.values(), this.getObjectWrapper());
    }

    public SimpleHash synchronizedWrapper() {
        return new SynchronizedHash();
    }

    private class SynchronizedHash
    extends SimpleHash {
        private SynchronizedHash() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            SimpleHash simpleHash = SimpleHash.this;
            synchronized (simpleHash) {
                return SimpleHash.this.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(String key, Object obj) {
            SimpleHash simpleHash = SimpleHash.this;
            synchronized (simpleHash) {
                SimpleHash.this.put(key, obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TemplateModel get(String key) throws TemplateModelException {
            SimpleHash simpleHash = SimpleHash.this;
            synchronized (simpleHash) {
                return SimpleHash.this.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(String key) {
            SimpleHash simpleHash = SimpleHash.this;
            synchronized (simpleHash) {
                SimpleHash.this.remove(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            SimpleHash simpleHash = SimpleHash.this;
            synchronized (simpleHash) {
                return SimpleHash.this.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TemplateCollectionModel keys() {
            SimpleHash simpleHash = SimpleHash.this;
            synchronized (simpleHash) {
                return SimpleHash.this.keys();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TemplateCollectionModel values() {
            SimpleHash simpleHash = SimpleHash.this;
            synchronized (simpleHash) {
                return SimpleHash.this.values();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map toMap() throws TemplateModelException {
            SimpleHash simpleHash = SimpleHash.this;
            synchronized (simpleHash) {
                return SimpleHash.this.toMap();
            }
        }
    }
}

