/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.xml;

import freemarker.ext.xml.Navigator;
import freemarker.template.TemplateModelException;
import freemarker.template.utility.StringUtil;
import java.io.StringWriter;
import java.util.List;
import org.jaxen.Context;
import org.jaxen.NamespaceContext;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

class DomNavigator
extends Navigator {
    DomNavigator() {
    }

    void getAsString(Object node, StringWriter sw) {
        this.outputContent((Node)node, sw.getBuffer());
    }

    private void outputContent(Node n, StringBuffer buf) {
        switch (n.getNodeType()) {
            case 2: {
                buf.append(' ').append(this.getQualifiedName(n)).append("=\"").append(StringUtil.XMLEncNA(n.getNodeValue())).append('\"');
                break;
            }
            case 4: {
                buf.append("<![CDATA[").append(n.getNodeValue()).append("]]>");
                break;
            }
            case 8: {
                buf.append("<!--").append(n.getNodeValue()).append("-->");
                break;
            }
            case 9: {
                this.outputContent(n.getChildNodes(), buf);
                break;
            }
            case 10: {
                buf.append("<!DOCTYPE ").append(n.getNodeName());
                DocumentType dt = (DocumentType)n;
                if (dt.getPublicId() != null) {
                    buf.append(" PUBLIC \"").append(dt.getPublicId()).append('\"');
                }
                if (dt.getSystemId() != null) {
                    buf.append('\"').append(dt.getSystemId()).append('\"');
                }
                if (dt.getInternalSubset() != null) {
                    buf.append(" [").append(dt.getInternalSubset()).append(']');
                }
                buf.append('>');
                break;
            }
            case 1: {
                buf.append('<').append(this.getQualifiedName(n));
                this.outputContent(n.getAttributes(), buf);
                buf.append('>');
                this.outputContent(n.getChildNodes(), buf);
                buf.append("</").append(this.getQualifiedName(n)).append('>');
                break;
            }
            case 6: {
                this.outputContent(n.getChildNodes(), buf);
                break;
            }
            case 5: {
                buf.append('&').append(n.getNodeName()).append(';');
                break;
            }
            case 7: {
                buf.append("<?").append(n.getNodeName()).append(' ').append(n.getNodeValue()).append("?>");
                break;
            }
            case 3: {
                buf.append(StringUtil.XMLEncNQG(n.getNodeValue()));
            }
        }
    }

    private void outputContent(NodeList nodes, StringBuffer buf) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            this.outputContent(nodes.item(i), buf);
        }
    }

    private void outputContent(NamedNodeMap nodes, StringBuffer buf) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            this.outputContent(nodes.item(i), buf);
        }
    }

    void getChildren(Object node, String localName, String namespaceUri, List result2) {
        if ("".equals(namespaceUri)) {
            namespaceUri = null;
        }
        NodeList children2 = ((Node)node).getChildNodes();
        for (int i = 0; i < children2.getLength(); ++i) {
            Node subnode = children2.item(i);
            if (subnode.getNodeType() != 1 && subnode.getNodeType() != 3 || localName != null && (!this.equal(subnode.getNodeName(), localName) || !this.equal(subnode.getNamespaceURI(), namespaceUri))) continue;
            result2.add(subnode);
        }
    }

    void getAttributes(Object node, String localName, String namespaceUri, List result2) {
        if (node instanceof Element) {
            Element e = (Element)node;
            if (localName == null) {
                NamedNodeMap atts = e.getAttributes();
                for (int i = 0; i < atts.getLength(); ++i) {
                    result2.add(atts.item(i));
                }
            } else {
                Attr attr;
                if ("".equals(namespaceUri)) {
                    namespaceUri = null;
                }
                if ((attr = e.getAttributeNodeNS(namespaceUri, localName)) != null) {
                    result2.add(attr);
                }
            }
        } else if (node instanceof ProcessingInstruction) {
            ProcessingInstruction pi = (ProcessingInstruction)node;
            if ("target".equals(localName)) {
                result2.add(this.createAttribute(pi, "target", pi.getTarget()));
            } else if ("data".equals(localName)) {
                result2.add(this.createAttribute(pi, "data", pi.getData()));
            }
        } else if (node instanceof DocumentType) {
            DocumentType doctype = (DocumentType)node;
            if ("publicId".equals(localName)) {
                result2.add(this.createAttribute(doctype, "publicId", doctype.getPublicId()));
            } else if ("systemId".equals(localName)) {
                result2.add(this.createAttribute(doctype, "systemId", doctype.getSystemId()));
            } else if ("elementName".equals(localName)) {
                result2.add(this.createAttribute(doctype, "elementName", doctype.getNodeName()));
            }
        }
    }

    private Attr createAttribute(Node node, String name, String value2) {
        Attr attr = node.getOwnerDocument().createAttribute(name);
        attr.setNodeValue(value2);
        return attr;
    }

    void getDescendants(Object node, List result2) {
        NodeList children2 = ((Node)node).getChildNodes();
        for (int i = 0; i < children2.getLength(); ++i) {
            Node subnode = children2.item(i);
            if (subnode.getNodeType() != 1) continue;
            result2.add(subnode);
            this.getDescendants(subnode, result2);
        }
    }

    Object getParent(Object node) {
        return ((Node)node).getParentNode();
    }

    Object getDocument(Object node) {
        return ((Node)node).getOwnerDocument();
    }

    Object getDocumentType(Object node) {
        return node instanceof Document ? ((Document)node).getDoctype() : null;
    }

    void getContent(Object node, List result2) {
        NodeList children2 = ((Node)node).getChildNodes();
        for (int i = 0; i < children2.getLength(); ++i) {
            result2.add(children2.item(i));
        }
    }

    String getText(Object node) {
        StringBuffer buf = new StringBuffer();
        if (node instanceof Element) {
            NodeList children2 = ((Node)node).getChildNodes();
            for (int i = 0; i < children2.getLength(); ++i) {
                Node child = children2.item(i);
                if (!(child instanceof Text)) continue;
                buf.append(child.getNodeValue());
            }
            return buf.toString();
        }
        return ((Node)node).getNodeValue();
    }

    String getLocalName(Object node) {
        return ((Node)node).getNodeName();
    }

    String getNamespacePrefix(Object node) {
        return ((Node)node).getPrefix();
    }

    String getNamespaceUri(Object node) {
        return ((Node)node).getNamespaceURI();
    }

    String getType(Object node) {
        switch (((Node)node).getNodeType()) {
            case 2: {
                return "attribute";
            }
            case 4: {
                return "cdata";
            }
            case 8: {
                return "comment";
            }
            case 9: {
                return "document";
            }
            case 10: {
                return "documentType";
            }
            case 1: {
                return "element";
            }
            case 6: {
                return "entity";
            }
            case 5: {
                return "entityReference";
            }
            case 7: {
                return "processingInstruction";
            }
            case 3: {
                return "text";
            }
        }
        return "unknown";
    }

    Navigator.XPathEx createXPathEx(String xpathString) throws TemplateModelException {
        try {
            return new DomXPathEx(xpathString);
        }
        catch (Exception e) {
            throw new TemplateModelException(e);
        }
    }

    private static final class DomXPathEx
    extends DOMXPath
    implements Navigator.XPathEx {
        DomXPathEx(String path) throws Exception {
            super(path);
        }

        public List selectNodes(Object object, NamespaceContext namespaces) throws TemplateModelException {
            Context context = this.getContext(object);
            context.getContextSupport().setNamespaceContext(namespaces);
            try {
                return this.selectNodesForContext(context);
            }
            catch (Exception e) {
                throw new TemplateModelException(e);
            }
        }
    }
}

