/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.CollectionAndSequence;
import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.TemplateObject;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;

final class HashLiteral
extends Expression {
    private final ArrayList keys;
    private final ArrayList values;
    private final int size;

    HashLiteral(ArrayList keys, ArrayList values2) {
        this.keys = keys;
        this.values = values2;
        this.size = keys.size();
        keys.trimToSize();
        values2.trimToSize();
    }

    TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
        return new SequenceHash(env);
    }

    public String getCanonicalForm() {
        StringBuffer buf = new StringBuffer("{");
        for (int i = 0; i < this.size; ++i) {
            Expression key = (Expression)this.keys.get(i);
            Expression value2 = (Expression)this.values.get(i);
            buf.append(key.getCanonicalForm());
            buf.append(" : ");
            buf.append(value2.getCanonicalForm());
            if (i == this.size - 1) continue;
            buf.append(",");
        }
        buf.append("}");
        return buf.toString();
    }

    boolean isLiteral() {
        if (this.constantValue != null) {
            return true;
        }
        for (int i = 0; i < this.size; ++i) {
            Expression key = (Expression)this.keys.get(i);
            Expression value2 = (Expression)this.values.get(i);
            if (key.isLiteral() && value2.isLiteral()) continue;
            return false;
        }
        return true;
    }

    Expression _deepClone(String name, Expression subst) {
        ArrayList clonedKeys = (ArrayList)this.keys.clone();
        ListIterator<Expression> iter2 = clonedKeys.listIterator();
        while (iter2.hasNext()) {
            iter2.set(((Expression)iter2.next()).deepClone(name, subst));
        }
        ArrayList clonedValues = (ArrayList)this.values.clone();
        ListIterator<Expression> iter3 = clonedValues.listIterator();
        while (iter3.hasNext()) {
            iter3.set(((Expression)iter3.next()).deepClone(name, subst));
        }
        return new HashLiteral(clonedKeys, clonedValues);
    }

    private class SequenceHash
    implements TemplateHashModelEx {
        private HashMap keyMap = new HashMap();
        private TemplateCollectionModel keyCollection;
        private TemplateCollectionModel valueCollection;

        SequenceHash(Environment env) throws TemplateException {
            ArrayList<String> keyList = new ArrayList<String>(HashLiteral.this.size);
            ArrayList<TemplateModel> valueList = new ArrayList<TemplateModel>(HashLiteral.this.size);
            for (int i = 0; i < HashLiteral.this.size; ++i) {
                Expression keyExp = (Expression)HashLiteral.this.keys.get(i);
                Expression valExp = (Expression)HashLiteral.this.values.get(i);
                String key = keyExp.getStringValue(env);
                TemplateModel value2 = valExp.getAsTemplateModel(env);
                TemplateObject.assertNonNull(value2, valExp, env);
                this.keyMap.put(key, value2);
                keyList.add(key);
                valueList.add(value2);
            }
            this.keyCollection = new CollectionAndSequence(new SimpleSequence(keyList));
            this.valueCollection = new CollectionAndSequence(new SimpleSequence(valueList));
        }

        public int size() {
            return HashLiteral.this.size;
        }

        public TemplateCollectionModel keys() {
            return this.keyCollection;
        }

        public TemplateCollectionModel values() {
            return this.valueCollection;
        }

        public TemplateModel get(String key) {
            return (TemplateModel)this.keyMap.get(key);
        }

        public boolean isEmpty() {
            return HashLiteral.this.size == 0;
        }
    }
}

