/*
 * Decompiled with CFR 0.152.
 */
package flanagan.roots;

import flanagan.complex.Complex;
import flanagan.complex.ComplexPoly;
import flanagan.math.Fmath;
import flanagan.roots.RealRootDerivFunction;
import flanagan.roots.RealRootFunction;
import java.util.ArrayList;

public class RealRoot {
    private double root = Double.NaN;
    private double tol = 1.0E-9;
    private int iterMax = 3000;
    private int iterN = 0;
    private double upperBound = 0.0;
    private double lowerBound = 0.0;
    private double estimate = 0.0;
    private int maximumBoundsExtension = 100;
    private boolean noBoundExtensions = false;
    private boolean noLowerBoundExtensions = false;
    private boolean noUpperBoundExtensions = false;
    private boolean supressLimitReachedMessage = false;
    private boolean returnNaN = false;
    private boolean supressNaNmessage = false;
    private static int staticIterMax = 3000;
    private static int maximumStaticBoundsExtension = 100;
    private static boolean noStaticBoundExtensions = false;
    private static boolean noStaticLowerBoundExtensions = false;
    private static boolean noStaticUpperBoundExtensions = false;
    private static boolean staticReturnNaN = false;
    private static double realTol = 1.0E-14;

    public void setLowerBound(double lower) {
        this.lowerBound = lower;
    }

    public void setUpperBound(double upper) {
        this.upperBound = upper;
    }

    public void resetNaNexceptionToTrue() {
        this.returnNaN = true;
    }

    public void resetNaNexceptionToFalse() {
        this.returnNaN = false;
    }

    public void supressNaNmessage() {
        this.supressNaNmessage = true;
    }

    public void allowNaNmessage() {
        this.supressNaNmessage = false;
    }

    public void setEstimate(double estimate) {
        this.estimate = estimate;
    }

    public void setTolerance(double tolerance) {
        this.tol = tolerance;
    }

    public double getTolerance() {
        return this.tol;
    }

    public void setIterMax(int imax) {
        this.iterMax = imax;
    }

    public int getIterMax() {
        return this.iterMax;
    }

    public int getIterN() {
        return this.iterN;
    }

    public void setmaximumStaticBoundsExtension(int maximumBoundsExtension) {
        this.maximumBoundsExtension = maximumBoundsExtension;
    }

    public void noBoundsExtensions() {
        this.noBoundExtensions = true;
        this.noLowerBoundExtensions = true;
        this.noUpperBoundExtensions = true;
    }

    public void noLowerBoundExtension() {
        this.noLowerBoundExtensions = true;
        if (this.noUpperBoundExtensions) {
            this.noBoundExtensions = true;
        }
    }

    public void noUpperBoundExtension() {
        this.noUpperBoundExtensions = true;
        if (this.noLowerBoundExtensions) {
            this.noBoundExtensions = true;
        }
    }

    public void supressLimitReachedMessage() {
        this.supressLimitReachedMessage = true;
    }

    public double brent(RealRootFunction g) {
        return this.brent(g, this.lowerBound, this.upperBound);
    }

    public double brent(RealRootFunction g, double lower, double upper) {
        double mid;
        this.lowerBound = lower;
        this.upperBound = upper;
        if (upper == lower) {
            throw new IllegalArgumentException("upper cannot equal lower");
        }
        boolean testConv = true;
        this.iterN = 0;
        double temp = 0.0;
        if (upper < lower) {
            temp = upper;
            upper = lower;
            lower = temp;
        }
        double fu = g.function(upper);
        double fl = g.function(lower);
        if (Double.isNaN(fl)) {
            if (this.returnNaN) {
                if (!this.supressNaNmessage) {
                    System.out.println("Realroot: brent: lower bound returned NaN as the function value - NaN returned as root");
                }
                return Double.NaN;
            }
            throw new ArithmeticException("lower bound returned NaN as the function value");
        }
        if (Double.isNaN(fu)) {
            if (this.returnNaN) {
                if (!this.supressNaNmessage) {
                    System.out.println("Realroot: brent: upper bound returned NaN as the function value - NaN returned as root");
                }
                return Double.NaN;
            }
            throw new ArithmeticException("upper bound returned NaN as the function value");
        }
        boolean testBounds = true;
        int numberOfBoundsExtension = 0;
        double initialBoundsDifference = (upper - lower) / 2.0;
        while (testBounds) {
            if (fu * fl <= 0.0) {
                testBounds = false;
                continue;
            }
            if (this.noBoundExtensions) {
                String message = "RealRoot.brent: root not bounded and no extension to bounds allowed\n";
                message = String.valueOf(message) + "NaN returned";
                if (!this.supressNaNmessage) {
                    System.out.println(message);
                }
                return Double.NaN;
            }
            if (++numberOfBoundsExtension > this.maximumBoundsExtension) {
                String message = "RealRoot.brent: root not bounded and maximum number of extension to bounds allowed, " + this.maximumBoundsExtension + ", exceeded\n";
                message = String.valueOf(message) + "NaN returned";
                if (!this.supressNaNmessage) {
                    System.out.println(message);
                }
                return Double.NaN;
            }
            if (!this.noLowerBoundExtensions) {
                fl = g.function(lower -= initialBoundsDifference);
            }
            if (this.noUpperBoundExtensions) continue;
            fu = g.function(upper += initialBoundsDifference);
        }
        if (fl == 0.0) {
            this.root = lower;
            testConv = false;
        }
        if (fu == 0.0) {
            this.root = upper;
            testConv = false;
        }
        double lastMidB = mid = (lower + upper) / 2.0;
        double fm = g.function(mid);
        double diff2 = mid - lower;
        double fmB = fm;
        double lastMid = mid;
        boolean lastMethod = true;
        boolean nextMethod = true;
        double rr = 0.0;
        double ss = 0.0;
        double tt = 0.0;
        double pp = 0.0;
        double qq = 0.0;
        while (testConv) {
            if (fm == 0.0 || Math.abs(diff2) < this.tol) {
                testConv = false;
                if (fm == 0.0) {
                    this.root = lastMid;
                } else if (Math.abs(diff2) < this.tol) {
                    this.root = mid;
                }
            } else {
                lastMethod = nextMethod;
                if (lastMethod) {
                    if (mid < lower || mid > upper) {
                        nextMethod = false;
                    } else {
                        fmB = fm;
                        lastMidB = mid;
                    }
                } else {
                    nextMethod = true;
                }
                if (nextMethod) {
                    fl = g.function(lower);
                    fm = g.function(mid);
                    fu = g.function(upper);
                    rr = fm / fu;
                    ss = fm / fl;
                    tt = fl / fu;
                    pp = ss * (tt * (rr - tt) * (upper - mid) - (1.0 - rr) * (mid - lower));
                    qq = (tt - 1.0) * (rr - 1.0) * (ss - 1.0);
                    lastMid = mid;
                    diff2 = pp / qq;
                    mid += diff2;
                } else {
                    fm = fmB;
                    mid = lastMidB;
                    if (fm * fl > 0.0) {
                        lower = mid;
                        fl = fm;
                    } else {
                        upper = mid;
                        fu = fm;
                    }
                    lastMid = mid;
                    mid = (lower + upper) / 2.0;
                    fm = g.function(mid);
                    diff2 = mid - lastMid;
                    fmB = fm;
                    lastMidB = mid;
                }
            }
            ++this.iterN;
            if (this.iterN <= this.iterMax) continue;
            if (!this.supressLimitReachedMessage) {
                if (!this.supressNaNmessage) {
                    System.out.println("Class: RealRoot; method: brent; maximum number of iterations exceeded - root at this point, " + Fmath.truncate(mid, 4) + ", returned");
                }
                if (!this.supressNaNmessage) {
                    System.out.println("Last mid-point difference = " + Fmath.truncate(diff2, 4) + ", tolerance = " + this.tol);
                }
            }
            this.root = mid;
            testConv = false;
        }
        return this.root;
    }

    public double bisect(RealRootFunction g) {
        return this.bisect(g, this.lowerBound, this.upperBound);
    }

    public double bisect(RealRootFunction g, double lower, double upper) {
        this.lowerBound = lower;
        this.upperBound = upper;
        if (upper == lower) {
            throw new IllegalArgumentException("upper cannot equal lower");
        }
        if (upper < lower) {
            double temp = upper;
            upper = lower;
            lower = temp;
        }
        boolean testConv = true;
        this.iterN = 0;
        double diff2 = 1.0E300;
        double fu = g.function(upper);
        double fl = g.function(lower);
        if (Double.isNaN(fl)) {
            if (this.returnNaN) {
                if (!this.supressNaNmessage) {
                    System.out.println("RealRoot: bisect: lower bound returned NaN as the function value - NaN returned as root");
                }
                return Double.NaN;
            }
            throw new ArithmeticException("lower bound returned NaN as the function value");
        }
        if (Double.isNaN(fu)) {
            if (this.returnNaN) {
                if (!this.supressNaNmessage) {
                    System.out.println("RealRoot: bisect: upper bound returned NaN as the function value - NaN returned as root");
                }
                return Double.NaN;
            }
            throw new ArithmeticException("upper bound returned NaN as the function value");
        }
        boolean testBounds = true;
        int numberOfBoundsExtension = 0;
        double initialBoundsDifference = (upper - lower) / 2.0;
        while (testBounds) {
            if (fu * fl <= 0.0) {
                testBounds = false;
                continue;
            }
            if (this.noBoundExtensions) {
                String message = "RealRoot.bisect: root not bounded and no extension to bounds allowed\n";
                message = String.valueOf(message) + "NaN returned";
                if (!this.supressNaNmessage) {
                    System.out.println(message);
                }
                return Double.NaN;
            }
            if (++numberOfBoundsExtension > this.maximumBoundsExtension) {
                String message = "RealRoot.bisect: root not bounded and maximum number of extension to bounds allowed, " + this.maximumBoundsExtension + ", exceeded\n";
                message = String.valueOf(message) + "NaN returned";
                if (!this.supressNaNmessage) {
                    System.out.println(message);
                }
                return Double.NaN;
            }
            if (!this.noLowerBoundExtensions) {
                fl = g.function(lower -= initialBoundsDifference);
            }
            if (this.noUpperBoundExtensions) continue;
            fu = g.function(upper += initialBoundsDifference);
        }
        if (fl == 0.0) {
            this.root = lower;
            testConv = false;
        }
        if (fu == 0.0) {
            this.root = upper;
            testConv = false;
        }
        double mid = (lower + upper) / 2.0;
        double lastMid = 1.0E300;
        double fm = g.function(mid);
        while (testConv) {
            if (fm == 0.0 || diff2 < this.tol) {
                testConv = false;
                this.root = mid;
            }
            if (fm * fl > 0.0) {
                lower = mid;
                fl = fm;
            } else {
                upper = mid;
                fu = fm;
            }
            lastMid = mid;
            mid = (lower + upper) / 2.0;
            fm = g.function(mid);
            diff2 = Math.abs(mid - lastMid);
            ++this.iterN;
            if (this.iterN <= this.iterMax) continue;
            if (!this.supressLimitReachedMessage) {
                if (!this.supressNaNmessage) {
                    System.out.println("Class: RealRoot; method: bisect; maximum number of iterations exceeded - root at this point, " + Fmath.truncate(mid, 4) + ", returned");
                }
                if (!this.supressNaNmessage) {
                    System.out.println("Last mid-point difference = " + Fmath.truncate(diff2, 4) + ", tolerance = " + this.tol);
                }
            }
            this.root = mid;
            testConv = false;
        }
        return this.root;
    }

    public double falsePosition(RealRootFunction g) {
        return this.falsePosition(g, this.lowerBound, this.upperBound);
    }

    public double falsePosition(RealRootFunction g, double lower, double upper) {
        this.lowerBound = lower;
        this.upperBound = upper;
        if (upper == lower) {
            throw new IllegalArgumentException("upper cannot equal lower");
        }
        if (upper < lower) {
            double temp = upper;
            upper = lower;
            lower = temp;
        }
        boolean testConv = true;
        this.iterN = 0;
        double diff2 = 1.0E300;
        double fu = g.function(upper);
        double fl = g.function(lower);
        if (Double.isNaN(fl)) {
            if (this.returnNaN) {
                if (!this.supressNaNmessage) {
                    System.out.println("RealRoot: fals: ePositionlower bound returned NaN as the function value - NaN returned as root");
                }
                return Double.NaN;
            }
            throw new ArithmeticException("lower bound returned NaN as the function value");
        }
        if (Double.isNaN(fu)) {
            if (this.returnNaN) {
                if (!this.supressNaNmessage) {
                    System.out.println("RealRoot: falsePosition: upper bound returned NaN as the function value - NaN returned as root");
                }
                return Double.NaN;
            }
            throw new ArithmeticException("upper bound returned NaN as the function value");
        }
        boolean testBounds = true;
        int numberOfBoundsExtension = 0;
        double initialBoundsDifference = (upper - lower) / 2.0;
        while (testBounds) {
            if (fu * fl <= 0.0) {
                testBounds = false;
                continue;
            }
            if (this.noBoundExtensions) {
                String message = "RealRoot.falsePosition: root not bounded and no extension to bounds allowed\n";
                message = String.valueOf(message) + "NaN returned";
                if (!this.supressNaNmessage) {
                    System.out.println(message);
                }
                return Double.NaN;
            }
            if (++numberOfBoundsExtension > this.maximumBoundsExtension) {
                String message = "RealRoot.falsePosition: root not bounded and maximum number of extension to bounds allowed, " + this.maximumBoundsExtension + ", exceeded\n";
                message = String.valueOf(message) + "NaN returned";
                if (!this.supressNaNmessage) {
                    System.out.println(message);
                }
                return Double.NaN;
            }
            if (!this.noLowerBoundExtensions) {
                fl = g.function(lower -= initialBoundsDifference);
            }
            if (this.noUpperBoundExtensions) continue;
            fu = g.function(upper += initialBoundsDifference);
        }
        if (fl == 0.0) {
            this.root = lower;
            testConv = false;
        }
        if (fu == 0.0) {
            this.root = upper;
            testConv = false;
        }
        double mid = lower + (upper - lower) * Math.abs(fl) / (Math.abs(fl) + Math.abs(fu));
        double lastMid = 1.0E300;
        double fm = g.function(mid);
        while (testConv) {
            if (fm == 0.0 || diff2 < this.tol) {
                testConv = false;
                this.root = mid;
            }
            if (fm * fl > 0.0) {
                lower = mid;
                fl = fm;
            } else {
                upper = mid;
                fu = fm;
            }
            lastMid = mid;
            mid = lower + (upper - lower) * Math.abs(fl) / (Math.abs(fl) + Math.abs(fu));
            fm = g.function(mid);
            diff2 = Math.abs(mid - lastMid);
            ++this.iterN;
            if (this.iterN <= this.iterMax) continue;
            if (!this.supressLimitReachedMessage) {
                if (!this.supressNaNmessage) {
                    System.out.println("Class: RealRoot; method: falsePostion; maximum number of iterations exceeded - root at this point, " + Fmath.truncate(mid, 4) + ", returned");
                }
                if (!this.supressNaNmessage) {
                    System.out.println("Last mid-point difference = " + Fmath.truncate(diff2, 4) + ", tolerance = " + this.tol);
                }
            }
            this.root = mid;
            testConv = false;
        }
        return this.root;
    }

    public double bisectNewtonRaphson(RealRootDerivFunction g) {
        return this.bisectNewtonRaphson(g, this.lowerBound, this.upperBound);
    }

    public double bisectNewtonRaphson(RealRootDerivFunction g, double lower, double upper) {
        double fm;
        double mid;
        this.lowerBound = lower;
        this.upperBound = upper;
        if (upper == lower) {
            throw new IllegalArgumentException("upper cannot equal lower");
        }
        boolean testConv = true;
        this.iterN = 0;
        double temp = 0.0;
        if (upper < lower) {
            temp = upper;
            upper = lower;
            lower = temp;
        }
        double[] f2 = g.function(upper);
        double fu = f2[0];
        f2 = g.function(lower);
        double fl = f2[0];
        if (Double.isNaN(fl)) {
            if (this.returnNaN) {
                if (!this.supressNaNmessage) {
                    System.out.println("RealRoot: bisectNewtonRaphson: lower bound returned NaN as the function value - NaN returned as root");
                }
                return Double.NaN;
            }
            throw new ArithmeticException("lower bound returned NaN as the function value");
        }
        if (Double.isNaN(fu)) {
            if (this.returnNaN) {
                if (!this.supressNaNmessage) {
                    System.out.println("RealRoot: bisectNewtonRaphson: upper bound returned NaN as the function value - NaN returned as root");
                }
                return Double.NaN;
            }
            throw new ArithmeticException("upper bound returned NaN as the function value");
        }
        boolean testBounds = true;
        int numberOfBoundsExtension = 0;
        double initialBoundsDifference = (upper - lower) / 2.0;
        while (testBounds) {
            if (fu * fl <= 0.0) {
                testBounds = false;
                continue;
            }
            if (this.noBoundExtensions) {
                String message = "RealRoot.bisectNewtonRaphson: root not bounded and no extension to bounds allowed\n";
                message = String.valueOf(message) + "NaN returned";
                if (!this.supressNaNmessage) {
                    System.out.println(message);
                }
                return Double.NaN;
            }
            if (++numberOfBoundsExtension > this.maximumBoundsExtension) {
                String message = "RealRoot.bisectNewtonRaphson: root not bounded and maximum number of extension to bounds allowed, " + this.maximumBoundsExtension + ", exceeded\n";
                message = String.valueOf(message) + "NaN returned";
                if (!this.supressNaNmessage) {
                    System.out.println(message);
                }
                return Double.NaN;
            }
            if (!this.noLowerBoundExtensions) {
                f2 = g.function(lower -= initialBoundsDifference);
                fl = f2[0];
            }
            if (this.noUpperBoundExtensions) continue;
            f2 = g.function(upper += initialBoundsDifference);
            fu = f2[0];
        }
        if (fl == 0.0) {
            this.root = lower;
            testConv = false;
        }
        if (fu == 0.0) {
            this.root = upper;
            testConv = false;
        }
        double lastMidB = mid = (lower + upper) / 2.0;
        f2 = g.function(mid);
        double diff2 = f2[0] / f2[1];
        double fmB = fm = f2[0];
        double lastMid = mid;
        mid -= diff2;
        boolean lastMethod = true;
        boolean nextMethod = true;
        while (testConv) {
            if (fm == 0.0 || Math.abs(diff2) < this.tol) {
                testConv = false;
                if (fm == 0.0) {
                    this.root = lastMid;
                } else if (Math.abs(diff2) < this.tol) {
                    this.root = mid;
                }
            } else {
                lastMethod = nextMethod;
                if (lastMethod) {
                    if (mid < lower || mid > upper) {
                        nextMethod = false;
                    } else {
                        fmB = fm;
                        lastMidB = mid;
                    }
                } else {
                    nextMethod = true;
                }
                if (nextMethod) {
                    f2 = g.function(mid);
                    fm = f2[0];
                    diff2 = f2[0] / f2[1];
                    lastMid = mid;
                    mid -= diff2;
                } else {
                    fm = fmB;
                    mid = lastMidB;
                    if (fm * fl > 0.0) {
                        lower = mid;
                        fl = fm;
                    } else {
                        upper = mid;
                        fu = fm;
                    }
                    lastMid = mid;
                    mid = (lower + upper) / 2.0;
                    f2 = g.function(mid);
                    fm = f2[0];
                    diff2 = mid - lastMid;
                    fmB = fm;
                    lastMidB = mid;
                }
            }
            ++this.iterN;
            if (this.iterN <= this.iterMax) continue;
            if (!this.supressLimitReachedMessage) {
                if (!this.supressNaNmessage) {
                    System.out.println("Class: RealRoot; method: bisectNewtonRaphson; maximum number of iterations exceeded - root at this point, " + Fmath.truncate(mid, 4) + ", returned");
                }
                if (!this.supressNaNmessage) {
                    System.out.println("Last mid-point difference = " + Fmath.truncate(diff2, 4) + ", tolerance = " + this.tol);
                }
            }
            this.root = mid;
            testConv = false;
        }
        return this.root;
    }

    public double newtonRaphson(RealRootDerivFunction g) {
        return this.newtonRaphson(g, this.estimate);
    }

    /*
     * Unable to fully structure code
     */
    public double newtonRaphson(RealRootDerivFunction g, double x) {
        this.estimate = x;
        testConv = true;
        this.iterN = 0;
        diff = 1.0E300;
        f = g.function(x);
        if (Double.isNaN(f[0])) {
            if (this.returnNaN) {
                if (!this.supressNaNmessage) {
                    System.out.println("RealRoot: newtonRaphson: NaN returned as the function value - NaN returned as root");
                }
                return NaN;
            }
            throw new ArithmeticException("NaN returned as the function value");
        }
        if (!Double.isNaN(f[1])) ** GOTO lbl49
        if (this.returnNaN) {
            if (!this.supressNaNmessage) {
                System.out.println("RealRoot: newtonRaphson: NaN returned as the derivative function value - NaN returned as root");
            }
            return NaN;
        }
        throw new ArithmeticException("NaN returned as the derivative function value");
lbl-1000:
        // 1 sources

        {
            diff = f[0] / f[1];
            if (f[0] == 0.0 || Math.abs(diff) < this.tol) {
                this.root = x;
                testConv = false;
            } else {
                f = g.function(x -= diff);
                if (Double.isNaN(f[0])) {
                    throw new ArithmeticException("NaN returned as the function value");
                }
                if (Double.isNaN(f[1])) {
                    throw new ArithmeticException("NaN returned as the derivative function value");
                }
                if (Double.isNaN(f[0])) {
                    if (this.returnNaN) {
                        if (!this.supressNaNmessage) {
                            System.out.println("RealRoot: bisect: NaN as the function value - NaN returned as root");
                        }
                        return NaN;
                    }
                    throw new ArithmeticException("NaN as the function value");
                }
                if (Double.isNaN(f[1])) {
                    if (this.returnNaN) {
                        if (!this.supressNaNmessage) {
                            System.out.println("NaN as the function value - NaN returned as root");
                        }
                        return NaN;
                    }
                    throw new ArithmeticException("NaN as the function value");
                }
            }
            ++this.iterN;
            if (this.iterN <= this.iterMax) continue;
            if (!this.supressLimitReachedMessage) {
                if (!this.supressNaNmessage) {
                    System.out.println("Class: RealRoot; method: newtonRaphson; maximum number of iterations exceeded - root at this point, " + Fmath.truncate(x, 4) + ", returned");
                }
                if (!this.supressNaNmessage) {
                    System.out.println("Last mid-point difference = " + Fmath.truncate(diff, 4) + ", tolerance = " + this.tol);
                }
            }
            this.root = x;
            testConv = false;
lbl49:
            // 3 sources

            ** while (testConv)
        }
lbl50:
        // 1 sources

        return this.root;
    }

    public void setStaticIterMax(int imax) {
        staticIterMax = imax;
    }

    public int getStaticIterMax() {
        return staticIterMax;
    }

    public void setStaticMaximumStaticBoundsExtension(int maximumBoundsExtension) {
        maximumStaticBoundsExtension = maximumBoundsExtension;
    }

    public void noStaticBoundsExtensions() {
        noStaticBoundExtensions = true;
        noStaticLowerBoundExtensions = true;
        noStaticUpperBoundExtensions = true;
    }

    public void noStaticLowerBoundExtension() {
        noStaticLowerBoundExtensions = true;
        if (noStaticUpperBoundExtensions) {
            noStaticBoundExtensions = true;
        }
    }

    public void noStaticUpperBoundExtension() {
        noStaticUpperBoundExtensions = true;
        if (noStaticLowerBoundExtensions) {
            noStaticBoundExtensions = true;
        }
    }

    public void resetStaticNaNexceptionToTrue() {
        staticReturnNaN = true;
    }

    public void resetStaticNaNexceptionToFalse() {
        staticReturnNaN = false;
    }

    public static double brent(RealRootFunction g, double lower, double upper, double tol) {
        double mid;
        if (upper == lower) {
            throw new IllegalArgumentException("upper cannot equal lower");
        }
        double root2 = Double.NaN;
        boolean testConv = true;
        int iterN = 0;
        double temp = 0.0;
        if (upper < lower) {
            temp = upper;
            upper = lower;
            lower = temp;
        }
        double fu = g.function(upper);
        double fl = g.function(lower);
        if (Double.isNaN(fl)) {
            if (staticReturnNaN) {
                System.out.println("Realroot: brent: lower bound returned NaN as the function value - NaN returned as root");
                return Double.NaN;
            }
            throw new ArithmeticException("lower bound returned NaN as the function value");
        }
        if (Double.isNaN(fu)) {
            if (staticReturnNaN) {
                System.out.println("Realroot: brent: upper bound returned NaN as the function value - NaN returned as root");
                return Double.NaN;
            }
            throw new ArithmeticException("upper bound returned NaN as the function value");
        }
        boolean testBounds = true;
        int numberOfBoundsExtension = 0;
        double initialBoundsDifference = (upper - lower) / 2.0;
        while (testBounds) {
            if (fu * fl <= 0.0) {
                testBounds = false;
                continue;
            }
            if (noStaticBoundExtensions) {
                String message = "RealRoot.brent: root not bounded and no extension to bounds allowed\n";
                message = String.valueOf(message) + "NaN returned";
                System.out.println(message);
                return Double.NaN;
            }
            if (++numberOfBoundsExtension > maximumStaticBoundsExtension) {
                String message = "RealRoot.brent: root not bounded and maximum number of extension to bounds allowed, " + maximumStaticBoundsExtension + ", exceeded\n";
                message = String.valueOf(message) + "NaN returned";
                System.out.println(message);
                return Double.NaN;
            }
            if (!noStaticLowerBoundExtensions) {
                fl = g.function(lower -= initialBoundsDifference);
            }
            if (noStaticUpperBoundExtensions) continue;
            fu = g.function(upper += initialBoundsDifference);
        }
        if (fl == 0.0) {
            root2 = lower;
            testConv = false;
        }
        if (fu == 0.0) {
            root2 = upper;
            testConv = false;
        }
        double lastMidB = mid = (lower + upper) / 2.0;
        double fm = g.function(mid);
        double diff2 = mid - lower;
        double fmB = fm;
        double lastMid = mid;
        boolean lastMethod = true;
        boolean nextMethod = true;
        double rr = 0.0;
        double ss = 0.0;
        double tt = 0.0;
        double pp = 0.0;
        double qq = 0.0;
        while (testConv) {
            if (fm == 0.0 || Math.abs(diff2) < tol) {
                testConv = false;
                if (fm == 0.0) {
                    root2 = lastMid;
                } else if (Math.abs(diff2) < tol) {
                    root2 = mid;
                }
            } else {
                lastMethod = nextMethod;
                if (lastMethod) {
                    if (mid < lower || mid > upper) {
                        nextMethod = false;
                    } else {
                        fmB = fm;
                        lastMidB = mid;
                    }
                } else {
                    nextMethod = true;
                }
                if (nextMethod) {
                    fl = g.function(lower);
                    fm = g.function(mid);
                    fu = g.function(upper);
                    rr = fm / fu;
                    ss = fm / fl;
                    tt = fl / fu;
                    pp = ss * (tt * (rr - tt) * (upper - mid) - (1.0 - rr) * (mid - lower));
                    qq = (tt - 1.0) * (rr - 1.0) * (ss - 1.0);
                    lastMid = mid;
                    diff2 = pp / qq;
                    mid += diff2;
                } else {
                    fm = fmB;
                    mid = lastMidB;
                    if (fm * fl > 0.0) {
                        lower = mid;
                        fl = fm;
                    } else {
                        upper = mid;
                        fu = fm;
                    }
                    lastMid = mid;
                    mid = (lower + upper) / 2.0;
                    fm = g.function(mid);
                    diff2 = mid - lastMid;
                    fmB = fm;
                    lastMidB = mid;
                }
            }
            if (++iterN <= staticIterMax) continue;
            System.out.println("Class: RealRoot; method: brent; maximum number of iterations exceeded - root at this point, " + Fmath.truncate(mid, 4) + ", returned");
            System.out.println("Last mid-point difference = " + Fmath.truncate(diff2, 4) + ", tolerance = " + tol);
            root2 = mid;
            testConv = false;
        }
        return root2;
    }

    public static double bisect(RealRootFunction g, double lower, double upper, double tol) {
        if (upper == lower) {
            throw new IllegalArgumentException("upper cannot equal lower");
        }
        if (upper < lower) {
            double temp = upper;
            upper = lower;
            lower = temp;
        }
        double root2 = Double.NaN;
        boolean testConv = true;
        int iterN = 0;
        double diff2 = 1.0E300;
        double fu = g.function(upper);
        double fl = g.function(lower);
        if (Double.isNaN(fl)) {
            if (staticReturnNaN) {
                System.out.println("RealRoot: bisect: lower bound returned NaN as the function value - NaN returned as root");
                return Double.NaN;
            }
            throw new ArithmeticException("lower bound returned NaN as the function value");
        }
        if (Double.isNaN(fu)) {
            if (staticReturnNaN) {
                System.out.println("RealRoot: bisect: upper bound returned NaN as the function value - NaN returned as root");
                return Double.NaN;
            }
            throw new ArithmeticException("upper bound returned NaN as the function value");
        }
        boolean testBounds = true;
        int numberOfBoundsExtension = 0;
        double initialBoundsDifference = (upper - lower) / 2.0;
        while (testBounds) {
            if (fu * fl <= 0.0) {
                testBounds = false;
                continue;
            }
            if (noStaticBoundExtensions) {
                String message = "RealRoot.bisect: root not bounded and no extension to bounds allowed\n";
                message = String.valueOf(message) + "NaN returned";
                System.out.println(message);
                return Double.NaN;
            }
            if (++numberOfBoundsExtension > maximumStaticBoundsExtension) {
                String message = "RealRoot.bisect: root not bounded and maximum number of extension to bounds allowed, " + maximumStaticBoundsExtension + ", exceeded\n";
                message = String.valueOf(message) + "NaN returned";
                System.out.println(message);
                return Double.NaN;
            }
            if (!noStaticLowerBoundExtensions) {
                fl = g.function(lower -= initialBoundsDifference);
            }
            if (noStaticUpperBoundExtensions) continue;
            fu = g.function(upper += initialBoundsDifference);
        }
        if (fl == 0.0) {
            root2 = lower;
            testConv = false;
        }
        if (fu == 0.0) {
            root2 = upper;
            testConv = false;
        }
        double mid = (lower + upper) / 2.0;
        double lastMid = 1.0E300;
        double fm = g.function(mid);
        while (testConv) {
            if (fm == 0.0 || diff2 < tol) {
                testConv = false;
                root2 = mid;
            }
            if (fm * fl > 0.0) {
                lower = mid;
                fl = fm;
            } else {
                upper = mid;
                fu = fm;
            }
            lastMid = mid;
            mid = (lower + upper) / 2.0;
            fm = g.function(mid);
            diff2 = Math.abs(mid - lastMid);
            if (++iterN <= staticIterMax) continue;
            System.out.println("Class: RealRoot; method: bisect; maximum number of iterations exceeded - root at this point, " + Fmath.truncate(mid, 4) + ", returned");
            System.out.println("Last mid-point difference = " + Fmath.truncate(diff2, 4) + ", tolerance = " + tol);
            root2 = mid;
            testConv = false;
        }
        return root2;
    }

    public static double falsePosition(RealRootFunction g, double lower, double upper, double tol) {
        if (upper == lower) {
            throw new IllegalArgumentException("upper cannot equal lower");
        }
        if (upper < lower) {
            double temp = upper;
            upper = lower;
            lower = temp;
        }
        double root2 = Double.NaN;
        boolean testConv = true;
        int iterN = 0;
        double diff2 = 1.0E300;
        double fu = g.function(upper);
        double fl = g.function(lower);
        if (Double.isNaN(fl)) {
            if (staticReturnNaN) {
                System.out.println("RealRoot: fals: ePositionlower bound returned NaN as the function value - NaN returned as root");
                return Double.NaN;
            }
            throw new ArithmeticException("lower bound returned NaN as the function value");
        }
        if (Double.isNaN(fu)) {
            if (staticReturnNaN) {
                System.out.println("RealRoot: falsePosition: upper bound returned NaN as the function value - NaN returned as root");
                return Double.NaN;
            }
            throw new ArithmeticException("upper bound returned NaN as the function value");
        }
        boolean testBounds = true;
        int numberOfBoundsExtension = 0;
        double initialBoundsDifference = (upper - lower) / 2.0;
        while (testBounds) {
            if (fu * fl <= 0.0) {
                testBounds = false;
                continue;
            }
            if (noStaticBoundExtensions) {
                String message = "RealRoot.falsePosition: root not bounded and no extension to bounds allowed\n";
                message = String.valueOf(message) + "NaN returned";
                System.out.println(message);
                return Double.NaN;
            }
            if (++numberOfBoundsExtension > maximumStaticBoundsExtension) {
                String message = "RealRoot.falsePosition: root not bounded and maximum number of extension to bounds allowed, " + maximumStaticBoundsExtension + ", exceeded\n";
                message = String.valueOf(message) + "NaN returned";
                System.out.println(message);
                return Double.NaN;
            }
            if (!noStaticLowerBoundExtensions) {
                fl = g.function(lower -= initialBoundsDifference);
            }
            if (noStaticUpperBoundExtensions) continue;
            fu = g.function(upper += initialBoundsDifference);
        }
        if (fl == 0.0) {
            root2 = lower;
            testConv = false;
        }
        if (fu == 0.0) {
            root2 = upper;
            testConv = false;
        }
        double mid = lower + (upper - lower) * Math.abs(fl) / (Math.abs(fl) + Math.abs(fu));
        double lastMid = 1.0E300;
        double fm = g.function(mid);
        while (testConv) {
            if (fm == 0.0 || diff2 < tol) {
                testConv = false;
                root2 = mid;
            }
            if (fm * fl > 0.0) {
                lower = mid;
                fl = fm;
            } else {
                upper = mid;
                fu = fm;
            }
            lastMid = mid;
            mid = lower + (upper - lower) * Math.abs(fl) / (Math.abs(fl) + Math.abs(fu));
            fm = g.function(mid);
            diff2 = Math.abs(mid - lastMid);
            if (++iterN <= staticIterMax) continue;
            System.out.println("Class: RealRoot; method: falsePostion; maximum number of iterations exceeded - root at this point, " + Fmath.truncate(mid, 4) + ", returned");
            System.out.println("Last mid-point difference = " + Fmath.truncate(diff2, 4) + ", tolerance = " + tol);
            root2 = mid;
            testConv = false;
        }
        return root2;
    }

    public static double bisectNewtonRaphson(RealRootDerivFunction g, double lower, double upper, double tol) {
        double fm;
        double mid;
        if (upper == lower) {
            throw new IllegalArgumentException("upper cannot equal lower");
        }
        double root2 = Double.NaN;
        boolean testConv = true;
        int iterN = 0;
        double temp = 0.0;
        if (upper < lower) {
            temp = upper;
            upper = lower;
            lower = temp;
        }
        double[] f2 = g.function(upper);
        double fu = f2[0];
        f2 = g.function(lower);
        double fl = f2[0];
        if (Double.isNaN(fl)) {
            if (staticReturnNaN) {
                System.out.println("RealRoot: bisectNewtonRaphson: lower bound returned NaN as the function value - NaN returned as root");
                return Double.NaN;
            }
            throw new ArithmeticException("lower bound returned NaN as the function value");
        }
        if (Double.isNaN(fu)) {
            if (staticReturnNaN) {
                System.out.println("RealRoot: bisectNewtonRaphson: upper bound returned NaN as the function value - NaN returned as root");
                return Double.NaN;
            }
            throw new ArithmeticException("upper bound returned NaN as the function value");
        }
        boolean testBounds = true;
        int numberOfBoundsExtension = 0;
        double initialBoundsDifference = (upper - lower) / 2.0;
        while (testBounds) {
            if (fu * fl <= 0.0) {
                testBounds = false;
                continue;
            }
            if (noStaticBoundExtensions) {
                String message = "RealRoot.bisectNewtonRaphson: root not bounded and no extension to bounds allowed\n";
                message = String.valueOf(message) + "NaN returned";
                System.out.println(message);
                return Double.NaN;
            }
            if (++numberOfBoundsExtension > maximumStaticBoundsExtension) {
                String message = "RealRoot.bisectNewtonRaphson: root not bounded and maximum number of extension to bounds allowed, " + maximumStaticBoundsExtension + ", exceeded\n";
                message = String.valueOf(message) + "NaN returned";
                System.out.println(message);
                return Double.NaN;
            }
            if (!noStaticLowerBoundExtensions) {
                f2 = g.function(lower -= initialBoundsDifference);
                fl = f2[0];
            }
            if (noStaticUpperBoundExtensions) continue;
            f2 = g.function(upper += initialBoundsDifference);
            fu = f2[0];
        }
        if (fl == 0.0) {
            root2 = lower;
            testConv = false;
        }
        if (fu == 0.0) {
            root2 = upper;
            testConv = false;
        }
        double lastMidB = mid = (lower + upper) / 2.0;
        f2 = g.function(mid);
        double diff2 = f2[0] / f2[1];
        double fmB = fm = f2[0];
        double lastMid = mid;
        mid -= diff2;
        boolean lastMethod = true;
        boolean nextMethod = true;
        while (testConv) {
            if (fm == 0.0 || Math.abs(diff2) < tol) {
                testConv = false;
                if (fm == 0.0) {
                    root2 = lastMid;
                } else if (Math.abs(diff2) < tol) {
                    root2 = mid;
                }
            } else {
                lastMethod = nextMethod;
                if (lastMethod) {
                    if (mid < lower || mid > upper) {
                        nextMethod = false;
                    } else {
                        fmB = fm;
                        lastMidB = mid;
                    }
                } else {
                    nextMethod = true;
                }
                if (nextMethod) {
                    f2 = g.function(mid);
                    fm = f2[0];
                    diff2 = f2[0] / f2[1];
                    lastMid = mid;
                    mid -= diff2;
                } else {
                    fm = fmB;
                    mid = lastMidB;
                    if (fm * fl > 0.0) {
                        lower = mid;
                        fl = fm;
                    } else {
                        upper = mid;
                        fu = fm;
                    }
                    lastMid = mid;
                    mid = (lower + upper) / 2.0;
                    f2 = g.function(mid);
                    fm = f2[0];
                    diff2 = mid - lastMid;
                    fmB = fm;
                    lastMidB = mid;
                }
            }
            if (++iterN <= staticIterMax) continue;
            System.out.println("Class: RealRoot; method: bisectNewtonRaphson; maximum number of iterations exceeded - root at this point, " + Fmath.truncate(mid, 4) + ", returned");
            System.out.println("Last mid-point difference = " + Fmath.truncate(diff2, 4) + ", tolerance = " + tol);
            root2 = mid;
            testConv = false;
        }
        return root2;
    }

    /*
     * Unable to fully structure code
     */
    public static double newtonRaphson(RealRootDerivFunction g, double x, double tol) {
        root = NaN;
        testConv = true;
        iterN = 0;
        diff = 1.0E300;
        f = g.function(x);
        if (Double.isNaN(f[0])) {
            if (RealRoot.staticReturnNaN) {
                System.out.println("RealRoot: newtonRaphson: NaN returned as the function value - NaN returned as root");
                return NaN;
            }
            throw new ArithmeticException("NaN returned as the function value");
        }
        if (!Double.isNaN(f[1])) ** GOTO lbl41
        if (RealRoot.staticReturnNaN) {
            System.out.println("RealRoot: newtonRaphson: NaN returned as the derivative function value - NaN returned as root");
            return NaN;
        }
        throw new ArithmeticException("NaN returned as the derivative function value");
lbl-1000:
        // 1 sources

        {
            diff = f[0] / f[1];
            if (f[0] == 0.0 || Math.abs(diff) < tol) {
                root = x;
                testConv = false;
            } else {
                f = g.function(x -= diff);
                if (Double.isNaN(f[0])) {
                    throw new ArithmeticException("NaN returned as the function value");
                }
                if (Double.isNaN(f[1])) {
                    throw new ArithmeticException("NaN returned as the derivative function value");
                }
                if (Double.isNaN(f[0])) {
                    if (RealRoot.staticReturnNaN) {
                        System.out.println("RealRoot: NewtonRaphson: NaN as the function value - NaN returned as root");
                        return NaN;
                    }
                    throw new ArithmeticException("NaN as the function value");
                }
                if (Double.isNaN(f[1])) {
                    if (RealRoot.staticReturnNaN) {
                        System.out.println("NaN as the function value - NaN returned as root");
                        return NaN;
                    }
                    throw new ArithmeticException("NaN as the function value");
                }
            }
            if (++iterN <= RealRoot.staticIterMax) continue;
            System.out.println("Class: RealRoot; method: newtonRaphson; maximum number of iterations exceeded - root at this point, " + Fmath.truncate(x, 4) + ", returned");
            System.out.println("Last mid-point difference = " + Fmath.truncate(diff, 4) + ", tolerance = " + tol);
            root = x;
            testConv = false;
lbl41:
            // 3 sources

            ** while (testConv)
        }
lbl42:
        // 1 sources

        return root;
    }

    public static ArrayList<Object> quadratic(double c, double b, double a) {
        ArrayList<Object> roots = new ArrayList<Object>(2);
        double bsquared = b * b;
        double fourac = 4.0 * a * c;
        if (bsquared < fourac) {
            Complex[] croots = ComplexPoly.quadratic(c, b, a);
            roots.add("complex");
            roots.add(croots);
        } else {
            double[] droots = new double[2];
            double bsign = Fmath.sign(b);
            double qsqrt = Math.sqrt(bsquared - fourac);
            qsqrt = -0.5 * (b + bsign * qsqrt);
            droots[0] = qsqrt / a;
            droots[1] = c / qsqrt;
            roots.add("real");
            roots.add(droots);
        }
        return roots;
    }

    public static ArrayList<Object> cubic(double a, double b, double c, double d) {
        ArrayList<Object> roots = new ArrayList<Object>(2);
        double aa = c / d;
        double bb = b / d;
        double cc = a / d;
        double bigR = (2.0 * aa * aa * aa - 9.0 * aa * bb + 27.0 * cc) / 54.0;
        double bigRsquared = bigR * bigR;
        double bigQ = (aa * aa - 3.0 * bb) / 9.0;
        double bigQcubed = bigQ * bigQ * bigQ;
        if (bigRsquared >= bigQcubed) {
            Complex[] croots = ComplexPoly.cubic(a, b, c, d);
            roots.add("complex");
            roots.add(croots);
        } else {
            double[] droots = new double[3];
            double theta = Math.acos(bigR / Math.sqrt(bigQcubed));
            double aover3 = aa / 3.0;
            double qterm = -2.0 * Math.sqrt(bigQ);
            droots[0] = qterm * Math.cos(theta / 3.0) - aover3;
            droots[1] = qterm * Math.cos((theta + Math.PI * 2) / 3.0) - aover3;
            droots[2] = qterm * Math.cos((theta - Math.PI * 2) / 3.0) - aover3;
            roots.add("real");
            roots.add(droots);
        }
        return roots;
    }

    public static ArrayList<Object> polynomial(double[] coeff) {
        boolean polish = true;
        double estx = 0.0;
        return RealRoot.polynomial(coeff, polish, estx);
    }

    public static ArrayList<Object> polynomial(double[] coeff, boolean polish) {
        double estx = 0.0;
        return RealRoot.polynomial(coeff, polish, estx);
    }

    public static ArrayList<Object> polynomial(double[] coeff, double estx) {
        boolean polish = true;
        return RealRoot.polynomial(coeff, polish, estx);
    }

    public static ArrayList<Object> polynomial(double[] coeff, boolean polish, double estx) {
        Object[] dtemp2;
        Object[] dtemp1;
        int i;
        int nCoeff = coeff.length;
        if (nCoeff < 2) {
            throw new IllegalArgumentException("a minimum of two coefficients is required");
        }
        ArrayList<Object> roots = new ArrayList<Object>(nCoeff);
        boolean realRoots = true;
        int nZeros = 0;
        int ii = 0;
        boolean testZero = true;
        while (testZero) {
            if (coeff[ii] == 0.0) {
                ++nZeros;
                ++ii;
                continue;
            }
            testZero = false;
        }
        int nCoeffWz = nCoeff - nZeros;
        double[] coeffWz = new double[nCoeffWz];
        if (nZeros > 0) {
            i = 0;
            while (i < nCoeffWz) {
                coeffWz[i] = coeff[i + nZeros];
                ++i;
            }
        } else {
            i = 0;
            while (i < nCoeffWz) {
                coeffWz[i] = coeff[i];
                ++i;
            }
        }
        ArrayList<Object> temp = new ArrayList<String>(2);
        double[] cdreal = null;
        switch (nCoeffWz) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                temp.add("real");
                double[] dtemp = new double[]{-coeffWz[0] / coeffWz[1]};
                temp.add(dtemp);
                break;
            }
            case 3: {
                temp = RealRoot.quadratic(coeffWz[0], coeffWz[1], coeffWz[2]);
                if (!((String)temp.get(0)).equals("complex")) break;
                realRoots = false;
                break;
            }
            case 4: {
                temp = RealRoot.cubic(coeffWz[0], coeffWz[1], coeffWz[2], coeffWz[3]);
                if (!((String)temp.get(0)).equals("complex")) break;
                realRoots = false;
                break;
            }
            default: {
                ComplexPoly cp = new ComplexPoly(coeffWz);
                Complex[] croots = cp.roots(polish, new Complex(estx, 0.0));
                cdreal = new double[nCoeffWz - 1];
                int counter = 0;
                int i2 = 0;
                while (i2 < nCoeffWz - 1) {
                    if (croots[i2].getImag() / croots[i2].getReal() < realTol) {
                        cdreal[i2] = croots[i2].getReal();
                        ++counter;
                    }
                    ++i2;
                }
                if (counter == nCoeffWz - 1) {
                    temp.add("real");
                    temp.add(cdreal);
                    break;
                }
                temp.add("complex");
                temp.add(croots);
                realRoots = false;
            }
        }
        if (nZeros == 0) {
            roots = temp;
        } else if (realRoots) {
            dtemp1 = new double[nCoeff - 1];
            dtemp2 = (double[])temp.get(1);
            int i3 = 0;
            while (i3 < nCoeffWz - 1) {
                dtemp1[i3] = dtemp2[i3];
                ++i3;
            }
            i3 = 0;
            while (i3 < nZeros) {
                dtemp1[i3 + nCoeffWz - 1] = 0.0;
                ++i3;
            }
            roots.add("real");
            roots.add(dtemp1);
        } else {
            dtemp1 = Complex.oneDarray(nCoeff - 1);
            dtemp2 = (Complex[])temp.get(1);
            int i4 = 0;
            while (i4 < nCoeffWz - 1) {
                dtemp1[i4] = dtemp2[i4];
                ++i4;
            }
            i4 = 0;
            while (i4 < nZeros) {
                dtemp1[i4 + nCoeffWz - 1] = (double)new Complex(0.0, 0.0);
                ++i4;
            }
            roots.add("complex");
            roots.add(dtemp1);
        }
        return roots;
    }

    public void resetRealTest(double ratio) {
        realTol = ratio;
    }
}

