/*
 * Decompiled with CFR 0.152.
 */
package flanagan.physchem;

import flanagan.io.Db;
import flanagan.io.FileOutput;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.math.Minimisation;
import flanagan.physchem.DonnanConcn;
import flanagan.physchem.DonnanMinim;
import flanagan.physprop.IonicRadii;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class Donnan {
    private ArrayList<Object> arrayl = new ArrayList();
    private int numOfIons = 0;
    private int numOfAnions = 0;
    private int numOfCations = 0;
    private String[] ionNames = null;
    private double[] concnA = null;
    private double[] concnB = null;
    private double[] molesT = null;
    private double[] complex = null;
    private double[] excessConcnA = null;
    private double[] excessConcnB = null;
    private double[] excessComplex = null;
    private int[] indexC = null;
    private int nonZeroConcns = 0;
    private double[] assocConsts = null;
    private int[] indexK = null;
    private int nonZeroAssocK = 0;
    private double[] radii = null;
    private boolean radiusType = true;
    private double[] charges = null;
    private double tol = 1.0E-6;
    private String ionophore = "ionophore";
    private double ionophoreConcn = 0.0;
    private double freeIonophoreConcn = 0.0;
    private double ionophoreRad = 0.0;
    private boolean ionophoreSet = false;
    private double volumeA = 0.0;
    private double volumeB = 0.0;
    private double interfacialArea = 0.0;
    private boolean volumeSet = false;
    private double epsilonA = 0.0;
    private double epsilonB = 0.0;
    private double epsilonSternA = 0.0;
    private double epsilonSternB = 0.0;
    private boolean epsilonSet = false;
    private double temp = 298.15;
    private boolean tempSet = false;
    private double[] deltaMu0 = null;
    private double[] partCoeff = null;
    private double[] partCoeffPot = null;
    private boolean[] indexPC = null;
    private double donnanPotential = 0.0;
    private double diffPotentialA = 0.0;
    private double diffPotentialB = 0.0;
    private double sternPotential = 0.0;
    private double estimate = 0.0;
    private double step = 0.0;
    private double tolerance = 1.0E-20;
    private int nMaxIter = 10000;
    private int numIterations = 0;
    private double minimum = 1.0E300;
    private double sternCap = 0.0;
    private double diffCapA = 0.0;
    private double diffCapB = 0.0;
    private double donnanCap = 0.0;
    private double sternDeltaA = 0.0;
    private double sternDeltaB = 0.0;
    private double chargeValue = 0.0;
    private boolean chargeSame = true;
    private double interfacialChargeDensity = 0.0;
    private double interfacialCharge = 0.0;
    private boolean includeIc = true;
    private double[] ratioA = null;
    private double[] ratioB = null;
    private double[] ratioC = null;
    private double recipKappaA = 0.0;
    private double recipKappaB = 0.0;

    public void setHydratedRadii() {
        this.radiusType = true;
    }

    public void setBareRadii() {
        this.radiusType = false;
    }

    public void ignoreInterfaceCharge() {
        this.includeIc = false;
    }

    public void includeInterfaceCharge() {
        this.includeIc = true;
    }

    public void setIon(String ion, double concnA, double concnB, double assocK, double radius, int charge) {
        this.arrayl.add(ion);
        this.arrayl.add(new Double(concnA));
        this.arrayl.add(new Double(concnB));
        if (concnA > 0.0 || concnB > 0.0) {
            ++this.nonZeroConcns;
        }
        this.arrayl.add(new Double(assocK));
        if (assocK != 0.0) {
            ++this.nonZeroAssocK;
        }
        this.arrayl.add(new Double(radius));
        this.arrayl.add(new Integer(charge));
        this.arrayl.add(new Double(-1.0));
        ++this.numOfIons;
    }

    public void setIon(double partCoeff, String ion, double concnA, double concnB, double assocK, double radius, int charge) {
        this.arrayl.add(ion);
        this.arrayl.add(new Double(concnA));
        this.arrayl.add(new Double(concnB));
        if (concnA > 0.0 || concnB > 0.0) {
            ++this.nonZeroConcns;
        }
        this.arrayl.add(new Double(assocK));
        if (assocK != 0.0) {
            ++this.nonZeroAssocK;
        }
        this.arrayl.add(new Double(radius));
        this.arrayl.add(new Integer(charge));
        this.arrayl.add(new Double(partCoeff));
        ++this.numOfIons;
    }

    public void setIon(String ion, double concnA, double concnB, double radius, int charge) {
        this.arrayl.add(ion);
        this.arrayl.add(new Double(concnA));
        this.arrayl.add(new Double(concnB));
        if (concnA > 0.0 || concnB > 0.0) {
            ++this.nonZeroConcns;
        }
        this.arrayl.add(new Double(0.0));
        this.arrayl.add(new Double(radius));
        this.arrayl.add(new Integer(charge));
        this.arrayl.add(new Double(-1.0));
        ++this.numOfIons;
    }

    public void setIon(double partCoeff, String ion, double concnA, double concnB, double radius, int charge) {
        this.arrayl.add(ion);
        this.arrayl.add(new Double(concnA));
        this.arrayl.add(new Double(concnB));
        if (concnA > 0.0 || concnB > 0.0) {
            ++this.nonZeroConcns;
        }
        this.arrayl.add(new Double(0.0));
        this.arrayl.add(new Double(radius));
        this.arrayl.add(new Integer(charge));
        this.arrayl.add(new Double(partCoeff));
        ++this.numOfIons;
    }

    public void setIon(String ion, double concnA, double concnB, double assocK) {
        IonicRadii ir = new IonicRadii();
        this.arrayl.add(ion);
        this.arrayl.add(new Double(concnA));
        this.arrayl.add(new Double(concnB));
        if (concnA > 0.0 || concnB > 0.0) {
            ++this.nonZeroConcns;
        }
        this.arrayl.add(new Double(assocK));
        if (assocK != 0.0) {
            ++this.nonZeroAssocK;
        }
        double rad = 0.0;
        rad = this.radiusType ? IonicRadii.hydratedRadius(ion) : IonicRadii.radius(ion);
        if (rad == 0.0) {
            String mess1 = String.valueOf(ion) + " radius is not in the IonicRadii list\n";
            String mess2 = "Please enter radius in metres\n";
            rad = Db.readDouble(String.valueOf(mess1) + mess2);
        }
        this.arrayl.add(new Double(rad));
        int charg = 0;
        charg = IonicRadii.charge(ion);
        if (charg == 0) {
            String mess1 = String.valueOf(ion) + " charge is not in the IonicRadii list\n";
            String mess2 = "Please enter charge, e.g +2";
            charg = Db.readInt(String.valueOf(mess1) + mess2);
        }
        this.arrayl.add(new Integer(charg));
        this.arrayl.add(new Double(-1.0));
        ++this.numOfIons;
    }

    public void setIon(double partCoeff, String ion, double concnA, double concnB, double assocK) {
        IonicRadii ir = new IonicRadii();
        this.arrayl.add(ion);
        this.arrayl.add(new Double(concnA));
        this.arrayl.add(new Double(concnB));
        if (concnA > 0.0 || concnB > 0.0) {
            ++this.nonZeroConcns;
        }
        this.arrayl.add(new Double(assocK));
        if (assocK != 0.0) {
            ++this.nonZeroAssocK;
        }
        double rad = 0.0;
        if (this.includeIc && (rad = this.radiusType ? IonicRadii.hydratedRadius(ion) : IonicRadii.radius(ion)) == 0.0) {
            String mess1 = String.valueOf(ion) + " radius is not in the IonicRadii list\n";
            String mess2 = "Please enter radius in metres\n";
            String mess3 = "Enter 0.0 if you wish interfacial charge to be neglected";
            rad = Db.readDouble(String.valueOf(mess1) + mess2 + mess3);
            if (rad == 0.0) {
                this.includeIc = false;
            }
        }
        this.arrayl.add(new Double(rad));
        int charg = 0;
        charg = IonicRadii.charge(ion);
        if (charg == 0) {
            String mess1 = String.valueOf(ion) + " charge is not in the IonicRadii list\n";
            String mess2 = "Please enter charge, e.g +2";
            charg = Db.readInt(String.valueOf(mess1) + mess2);
        }
        this.arrayl.add(new Integer(charg));
        this.arrayl.add(new Double(partCoeff));
        ++this.numOfIons;
    }

    public void setIon(String ion, double concnA, double concnB) {
        IonicRadii ir = new IonicRadii();
        this.arrayl.add(ion);
        this.arrayl.add(new Double(concnA));
        this.arrayl.add(new Double(concnB));
        if (concnA > 0.0 || concnB > 0.0) {
            ++this.nonZeroConcns;
        }
        this.arrayl.add(new Double(0.0));
        double rad = 0.0;
        rad = this.radiusType ? IonicRadii.hydratedRadius(ion) : IonicRadii.radius(ion);
        if (rad == 0.0) {
            String mess1 = String.valueOf(ion) + " radius is not in the IonicRadii list\n";
            String mess2 = "Please enter radius in metres\n";
            rad = Db.readDouble(String.valueOf(mess1) + mess2);
            if (rad == 0.0) {
                this.includeIc = false;
            }
        }
        this.arrayl.add(new Double(rad));
        int charg = 0;
        charg = IonicRadii.charge(ion);
        if (charg == 0) {
            String mess1 = String.valueOf(ion) + " charge is not in the IonicRadii list\n";
            String mess2 = "Please enter charge, e.g +2";
            charg = Db.readInt(String.valueOf(mess1) + mess2);
        }
        this.arrayl.add(new Integer(charg));
        this.arrayl.add(new Double(-1.0));
        ++this.numOfIons;
    }

    public void setIon(double partCoeff, String ion, double concnA, double concnB) {
        IonicRadii ir = new IonicRadii();
        this.arrayl.add(ion);
        this.arrayl.add(new Double(concnA));
        this.arrayl.add(new Double(concnB));
        if (concnA > 0.0 || concnB > 0.0) {
            ++this.nonZeroConcns;
        }
        this.arrayl.add(new Double(0.0));
        double rad = 0.0;
        if (this.includeIc && (rad = this.radiusType ? IonicRadii.hydratedRadius(ion) : IonicRadii.radius(ion)) == 0.0) {
            String mess1 = String.valueOf(ion) + " radius is not in the IonicRadii list\n";
            String mess2 = "Please enter radius in metres\n";
            String mess3 = "Enter 0.0 if you wish interfacial charge to be neglected";
            rad = Db.readDouble(String.valueOf(mess1) + mess2 + mess3);
            if (rad == 0.0) {
                this.includeIc = false;
            }
        }
        this.arrayl.add(new Double(rad));
        int charg = 0;
        charg = IonicRadii.charge(ion);
        if (charg == 0) {
            String mess1 = String.valueOf(ion) + " charge is not in the IonicRadii list\n";
            String mess2 = "Please enter charge, e.g +2";
            charg = Db.readInt(String.valueOf(mess1) + mess2);
        }
        this.arrayl.add(new Integer(charg));
        this.arrayl.add(new Double(partCoeff));
        ++this.numOfIons;
    }

    public void setIonophore(double concn, double radius) {
        this.ionophoreConcn = concn * 1000.0;
        this.ionophoreRad = radius;
        this.ionophoreSet = true;
    }

    public void setIonophore(String ionophore, double concn, double radius) {
        this.ionophore = ionophore;
        this.ionophoreConcn = concn * 1000.0;
        this.ionophoreRad = radius;
        this.ionophoreSet = true;
    }

    public void setIonophore(String ionophore, double concn) {
        this.ionophore = ionophore;
        this.ionophoreConcn = concn * 1000.0;
        this.includeIc = false;
        this.ionophoreSet = true;
    }

    public void setIonophore(double concn) {
        this.ionophoreConcn = concn * 1000.0;
        this.includeIc = false;
        this.ionophoreSet = true;
    }

    public void setVolumes(double volA, double volB, double area) {
        this.volumeA = volA;
        this.volumeB = volB;
        this.interfacialArea = area;
        this.volumeSet = true;
    }

    public void setVolumes(double volA, double volB) {
        this.volumeA = volA;
        this.volumeB = volB;
        this.includeIc = false;
        this.volumeSet = true;
    }

    public void setRelPerm(double epsA, double epsB, double epsSternA, double epsSternB) {
        this.epsilonA = epsA;
        this.epsilonB = epsB;
        this.epsilonSternA = epsSternA;
        this.epsilonSternB = epsSternB;
        this.epsilonSet = true;
    }

    public void setRelPerm(double epsA, double epsB) {
        this.epsilonA = epsA;
        this.epsilonB = epsB;
        this.includeIc = false;
        this.epsilonSet = true;
    }

    public void setTemp(double temp) {
        this.temp = temp - -273.15;
        this.tempSet = true;
    }

    public void setEstimate(double pot) {
        this.estimate = pot;
    }

    public void setStep(double step2) {
        this.step = step2;
    }

    public void setTolerance(double tol) {
        this.tolerance = tol;
    }

    public void setMaxIterations(int nMax) {
        this.nMaxIter = nMax;
    }

    public double getDonnanPotential() {
        return this.donnanPotential;
    }

    public double getDiffuseLayerPotentialA() {
        return this.diffPotentialA;
    }

    public double getDiffuseLayerPotentialB() {
        return this.diffPotentialB;
    }

    public double getSternLayerPotential() {
        return this.sternPotential;
    }

    public double[] getConcnA() {
        double[] concn = Conv.copy(this.concnA);
        int i = 0;
        while (i < this.numOfIons) {
            int n = i++;
            concn[n] = concn[n] * 0.001;
        }
        return concn;
    }

    public double[] getConcnB() {
        double[] concn = Conv.copy(this.concnB);
        int i = 0;
        while (i < this.numOfIons) {
            int n = i++;
            concn[n] = concn[n] * 0.001;
        }
        return concn;
    }

    public double[] getComplex() {
        double[] concn = Conv.copy(this.complex);
        int i = 0;
        while (i < this.numOfIons) {
            int n = i++;
            concn[n] = concn[n] * 0.001;
        }
        return concn;
    }

    public double[] getExcessConcnA() {
        if (!this.includeIc) {
            System.out.println("Class: Donnan\nMethod: getExcessConcnA\nThe values of the excess concentrations have not been calculated\nzeros returned");
        }
        double[] concn = Conv.copy(this.excessConcnA);
        int i = 0;
        while (i < this.numOfIons) {
            int n = i++;
            concn[n] = concn[n] * 0.001;
        }
        return concn;
    }

    public double[] getExcessConcnB() {
        if (!this.includeIc) {
            System.out.println("Class: Donnan\nMethod: getExcessConcnA\nThe values of the excess concentrations have not been calculated\nzeros returned");
        }
        double[] concn = Conv.copy(this.excessConcnB);
        int i = 0;
        while (i < this.numOfIons) {
            int n = i++;
            concn[n] = concn[n] * 0.001;
        }
        return concn;
    }

    public double[] getExcessComplex() {
        if (!this.includeIc) {
            System.out.println("Class: Donnan\nMethod: getExcessConcnA\nThe values of the excess concentrations have not been calculated\nzeros returned");
        }
        double[] concn = Conv.copy(this.excessComplex);
        int i = 0;
        while (i < this.numOfIons) {
            int n = i++;
            concn[n] = concn[n] * 0.001;
        }
        return concn;
    }

    public double[] getRatioA() {
        if (!this.includeIc) {
            System.out.println("Class: Donnan\nMethod: getRatioA\nThe values of the excess to bulk concentrations have not been calculated\nzeros returned");
        }
        return this.ratioA;
    }

    public double[] getRatioB() {
        if (!this.includeIc) {
            System.out.println("Class: Donnan\nMethod: getRatioB\nThe values of the excess to bulk concentrations have not been calculated\nzeros returned");
        }
        return this.ratioB;
    }

    public double[] getRatioComplex() {
        if (!this.includeIc) {
            System.out.println("Class: Donnan\nMethod: getRatioComplex\nThe values of the excess to bulk concentrations have not been calculated\nzeros returned");
        }
        return this.ratioC;
    }

    public double[] getPartitionCoefficients() {
        return this.partCoeffPot;
    }

    public double[] getPartitionCoefficientsZero() {
        return this.partCoeff;
    }

    public double[] getDeltaMu0() {
        return this.deltaMu0;
    }

    public double getInterfaceCharge() {
        if (!this.includeIc) {
            System.out.println("Class: Donnan\nMethod: getInterfaceCharge\nThe value of the interface charge has not been calculated\nzero returned");
        }
        return this.interfacialCharge;
    }

    public double getInterfaceChargeDensity() {
        if (!this.includeIc) {
            System.out.println("Class: Donnan\nMethod: getInterfaceChargeDensity\nThe value of the interface charge density has not been calculated\nzero returned");
        }
        return this.interfacialCharge;
    }

    public double getSternCapacitance() {
        if (!this.includeIc) {
            System.out.println("Class: Donnan\nMethod: getSternCapacitance\nThe value of the Stern capacitance has not been calculated\nzero returned");
        }
        return this.sternCap * this.interfacialArea;
    }

    public double getDiffuseLayerCapacitanceA() {
        if (!this.includeIc) {
            System.out.println("Class: Donnan\nMethod: getDiffuseLayerCapacitanceA\nThe values of the diffuse layer capacitances have not been calculated\nzero returned");
        }
        return this.diffCapA * this.interfacialArea;
    }

    public double getDiffuseLayerCapacitanceB() {
        if (!this.includeIc) {
            System.out.println("Class: Donnan\nMethod: getDiffuseLayerCapacitanceB\nThe values of the diffuse layer capacitances have not been calculated\nzero returned");
        }
        return this.diffCapB * this.interfacialArea;
    }

    public double getDonnanCapacitanceB() {
        if (!this.includeIc) {
            System.out.println("Class: Donnan\nMethod: getDonnanCapacitance\nThe value of the Donnan capacitance has not been calculated\nzero returned");
        }
        return this.donnanCap * this.interfacialArea;
    }

    public double getSternThicknessA() {
        if (!this.includeIc) {
            System.out.println("Class: Donnan\nMethod: getSternThicknessA\nThe values of the Stern layer thicknesses have not been calculated\nzero returned");
        }
        return this.sternDeltaA;
    }

    public double getSternThicknessB() {
        if (!this.includeIc) {
            System.out.println("Class: Donnan\nMethod: getSternThicknessB\nThe values of the Stern layer thicknesses have not been calculated\nzero returned");
        }
        return this.sternDeltaB;
    }

    public double getDebyeLengthA() {
        if (!this.includeIc) {
            System.out.println("Class: Donnan\nMethod: getDebyeLengthA\nThe values of the Debye lengths have not been calculated\nzero returned");
        }
        return this.recipKappaA;
    }

    public double getDebyeLengthB() {
        if (!this.includeIc) {
            System.out.println("Class: Donnan\nMethod: getDebyeLengthB\nThe values of the Debye lengths have not been calculated\nzero returned");
        }
        return this.recipKappaB;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double calcPotential() {
        this.unpack();
        double numOfIonsHold = this.numOfIons;
        double[] assocConstshold = null;
        double[] radiihold = null;
        double[] chargeshold = null;
        double[] deltaMu0hold = null;
        double[] partCoeffhold = null;
        if (this.nonZeroConcns < this.numOfIons) {
            assocConstshold = Conv.copy(this.assocConsts);
            radiihold = Conv.copy(this.radii);
            chargeshold = Conv.copy(this.charges);
            deltaMu0hold = Conv.copy(this.deltaMu0);
            partCoeffhold = Conv.copy(this.partCoeff);
            boolean test2 = true;
            int jj = 0;
            while (test2) {
                if (this.indexC[jj] == 0) {
                    int k = jj + 1;
                    while (k < this.numOfIons) {
                        this.concnA[k - 1] = this.concnA[k];
                        this.concnB[k - 1] = this.concnB[k];
                        this.complex[k - 1] = this.complex[k];
                        this.molesT[k - 1] = this.molesT[k];
                        this.assocConsts[k - 1] = this.assocConsts[k];
                        this.radii[k - 1] = this.radii[k];
                        this.charges[k - 1] = this.charges[k];
                        this.deltaMu0[k - 1] = this.deltaMu0[k];
                        this.partCoeff[k - 1] = this.partCoeff[k];
                        ++k;
                    }
                    --this.numOfIons;
                } else {
                    ++jj;
                }
                if (this.numOfIons != this.nonZeroConcns) continue;
                test2 = false;
            }
        }
        boolean includeIcHold = false;
        if (this.includeIc) {
            includeIcHold = true;
            this.includeIc = false;
        }
        Minimisation minPot = new Minimisation();
        DonnanMinim functD = new DonnanMinim(this.numOfIons);
        functD.numOfIons = this.numOfIons;
        functD.concnA = this.concnA;
        functD.concnB = this.concnB;
        functD.molesT = this.molesT;
        functD.complex = this.complex;
        functD.excessConcnA = this.excessConcnA;
        functD.excessConcnB = this.excessConcnB;
        functD.excessComplex = this.excessComplex;
        functD.assocConsts = this.assocConsts;
        functD.indexK = this.indexK;
        functD.nonZeroAssocK = this.nonZeroAssocK;
        functD.radii = this.radii;
        functD.charges = this.charges;
        functD.ionophoreConcn = this.ionophoreConcn;
        functD.ionophoreRad = this.ionophoreRad;
        functD.volumeA = this.volumeA;
        functD.volumeB = this.volumeB;
        functD.interfacialArea = this.interfacialArea;
        functD.epsilonA = this.epsilonA;
        functD.epsilonB = this.epsilonB;
        functD.epsilonSternA = this.epsilonSternA;
        functD.epsilonSternB = this.epsilonSternB;
        functD.temp = this.temp;
        functD.partCoeff = this.partCoeff;
        functD.partCoeffPot = this.partCoeffPot;
        functD.sternCap = this.sternCap;
        functD.sternDeltaA = this.sternDeltaA;
        functD.sternDeltaB = this.sternDeltaB;
        functD.chargeValue = this.chargeValue;
        functD.chargeSame = this.chargeSame;
        functD.interfacialCharge = this.interfacialCharge;
        functD.interfacialChargeDensity = this.interfacialChargeDensity;
        functD.includeIc = this.includeIc;
        double[] start = new double[]{this.estimate};
        double[] step2 = new double[]{this.step};
        minPot.nelderMead(functD, start, step2, this.tolerance, this.nMaxIter);
        double[] param2 = minPot.getParamValues();
        this.donnanPotential = param2[0];
        if (includeIcHold) {
            this.includeIc = true;
            start[0] = this.donnanPotential;
            step2[0] = this.step;
            minPot.nelderMead(functD, start, step2, this.tolerance, this.nMaxIter);
            param2 = minPot.getParamValues();
            this.donnanPotential = param2[0];
        }
        this.ionConcns(this.donnanPotential);
        if ((double)this.nonZeroConcns != numOfIonsHold) {
            boolean test3 = true;
            int jj = 0;
            while (test3) {
                if (this.indexC[jj] == 0) {
                    int k = jj;
                    while (k < this.numOfIons) {
                        this.concnA[k + 1] = this.concnA[k];
                        this.concnB[k + 1] = this.concnB[k];
                        this.complex[k + 1] = this.complex[k];
                        this.excessConcnA[k + 1] = this.excessConcnA[k];
                        this.excessConcnB[k + 1] = this.excessConcnB[k];
                        this.excessComplex[k + 1] = this.excessComplex[k];
                        this.molesT[k + 1] = this.molesT[k];
                        this.assocConsts[k + 1] = this.assocConsts[k];
                        this.radii[k + 1] = this.radii[k];
                        this.charges[k + 1] = this.charges[k];
                        this.deltaMu0[k + 1] = this.deltaMu0[k];
                        this.partCoeff[k + 1] = this.partCoeff[k];
                        this.partCoeffPot[k + 1] = this.partCoeffPot[k];
                        ++k;
                    }
                    ++this.numOfIons;
                    this.concnA[jj] = 0.0;
                    this.concnB[jj] = 0.0;
                    this.complex[jj] = 0.0;
                    this.excessConcnA[jj] = 0.0;
                    this.excessConcnB[jj] = 0.0;
                    this.excessComplex[jj] = 0.0;
                    this.molesT[jj] = 0.0;
                    this.assocConsts[jj] = assocConstshold[jj];
                    this.radii[jj] = radiihold[jj];
                    this.charges[jj] = chargeshold[jj];
                    this.deltaMu0[jj] = deltaMu0hold[jj];
                    this.partCoeff[jj] = partCoeffhold[jj];
                } else {
                    ++jj;
                }
                if (this.numOfIons != this.nonZeroConcns) continue;
                test3 = false;
            }
        }
        this.minimum = minPot.getMinimum();
        this.numIterations = minPot.getNiter();
        if (this.includeIc) {
            int i = 0;
            while (i < this.numOfIons) {
                this.ratioA[i] = this.excessConcnA[i] / this.concnA[i];
                this.ratioB[i] = this.excessConcnB[i] / this.concnB[i];
                this.ratioC[i] = this.excessComplex[i] / this.complex[i];
                ++i;
            }
            this.diffCapA = Math.abs(this.interfacialCharge / this.diffPotentialA);
            this.diffCapB = Math.abs(this.interfacialCharge / this.diffPotentialB);
            this.donnanCap = Math.abs(this.interfacialCharge / this.donnanPotential);
            double preterm = 2.0 * Fmath.square(-1.60217646263E-19) * 6.0221419947E23 / (1.2224537278297904E-34 * this.temp);
            double pretermA = preterm / this.epsilonA;
            double pretermB = preterm / this.epsilonB;
            this.recipKappaA = 0.0;
            this.recipKappaB = 0.0;
            int i2 = 0;
            while (i2 < this.numOfIons) {
                this.recipKappaA += this.concnA[i2] * this.charges[i2] * this.charges[i2];
                this.recipKappaB += (this.concnB[i2] + this.complex[i2]) * this.charges[i2] * this.charges[i2];
                ++i2;
            }
            this.recipKappaA = 1.0 / Math.sqrt(this.recipKappaA * pretermA);
            this.recipKappaB = 1.0 / Math.sqrt(this.recipKappaB * pretermB);
            int ii = 0;
            while (ii < this.numOfIons) {
                if (this.indexPC[ii]) {
                    this.deltaMu0[ii] = Math.log(this.partCoeff[ii]) * 8.314472296156563 * this.temp;
                } else {
                    int n = ii;
                    this.deltaMu0[n] = this.deltaMu0[n] * 6.0221419947E23;
                }
                ++ii;
            }
            ii = 0;
            while (ii < this.numOfIons) {
                this.partCoeffPot[ii] = this.partCoeff[ii] * Math.exp(-this.donnanPotential * this.charges[ii] * -1.60217646263E-19 / (1.380650324E-23 * this.temp));
                ++ii;
            }
        }
        return this.donnanPotential;
    }

    private void unpack() {
        if (!this.volumeSet) {
            throw new IllegalArgumentException("The volumes of the partitions have not been set");
        }
        if (this.numOfIons == 0) {
            throw new IllegalArgumentException("No ions have been entered");
        }
        if (this.nonZeroConcns == 0) {
            throw new IllegalArgumentException("No non-zero ionic concentrations have been entered");
        }
        if (!this.epsilonSet) {
            throw new IllegalArgumentException("The relative permittivities of the partitions have not been set");
        }
        if (!this.tempSet) {
            System.out.println("The temperature has not been entered\na value of 25 degrees Celsius has been used");
        }
        if (!this.ionophoreSet) {
            System.out.println("The ionophore has not been entered\na concentration value of zero has been used");
        }
        this.ionNames = new String[this.numOfIons];
        this.concnA = new double[this.numOfIons];
        this.concnB = new double[this.numOfIons];
        this.molesT = new double[this.numOfIons];
        this.complex = new double[this.numOfIons];
        this.excessConcnA = new double[this.numOfIons];
        this.excessConcnB = new double[this.numOfIons];
        this.excessComplex = new double[this.numOfIons];
        this.ratioA = new double[this.numOfIons];
        this.ratioB = new double[this.numOfIons];
        this.ratioC = new double[this.numOfIons];
        this.assocConsts = new double[this.numOfIons];
        this.radii = new double[this.numOfIons];
        this.charges = new double[this.numOfIons];
        this.deltaMu0 = new double[this.numOfIons];
        this.partCoeff = new double[this.numOfIons];
        this.partCoeffPot = new double[this.numOfIons];
        this.indexK = new int[this.nonZeroAssocK];
        this.indexC = new int[this.numOfIons];
        this.indexPC = new boolean[this.numOfIons];
        Double hold = null;
        Integer holi = null;
        int ii = 0;
        this.chargeValue = 0.0;
        this.chargeSame = true;
        int i = 0;
        while (i < this.numOfIons) {
            this.ionNames[i] = (String)this.arrayl.get(0 + i * 7);
            hold = (Double)this.arrayl.get(1 + i * 7);
            this.concnA[i] = hold * 1000.0;
            hold = (Double)this.arrayl.get(2 + i * 7);
            this.concnB[i] = hold * 1000.0;
            this.molesT[i] = this.concnA[i] * this.volumeA + this.concnB[i] * this.volumeB;
            this.indexC[i] = this.molesT[i] > 0.0 ? 1 : 0;
            hold = (Double)this.arrayl.get(3 + i * 7);
            this.assocConsts[i] = hold * 0.001;
            if (this.assocConsts[i] > 0.0) {
                this.indexK[ii] = i;
                ++ii;
            }
            hold = (Double)this.arrayl.get(4 + i * 7);
            this.radii[i] = hold;
            holi = (Integer)this.arrayl.get(5 + i * 7);
            this.charges[i] = holi.intValue();
            if (i == 0) {
                this.chargeValue = Math.abs(this.charges[0]);
            } else if (Math.abs(this.charges[i]) != this.chargeValue) {
                this.chargeSame = false;
            }
            hold = (Double)this.arrayl.get(6 + i * 7);
            this.partCoeff[i] = hold;
            this.indexPC[i] = true;
            if (this.partCoeff[i] == -1.0) {
                this.indexPC[i] = false;
                this.deltaMu0[i] = this.BornChargingEnergy(this.radii[i], this.charges[i], this.epsilonB) - this.BornChargingEnergy(this.radii[i], this.charges[i], this.epsilonA);
                this.partCoeff[i] = Math.exp(this.deltaMu0[i] / (1.380650324E-23 * this.temp));
            }
            if (this.charges[i] < 0.0) {
                ++this.numOfAnions;
            } else {
                ++this.numOfCations;
            }
            if (this.ionophoreConcn == 0.0) {
                this.nonZeroAssocK = 0;
            }
            ++i;
        }
        double overallCharge = 0.0;
        double positives = 0.0;
        double negatives = 0.0;
        int i2 = 0;
        while (i2 < this.numOfIons) {
            if (this.charges[i2] > 0.0) {
                positives += this.molesT[i2] * this.charges[i2];
            } else {
                negatives += this.molesT[i2] * this.charges[i2];
            }
            overallCharge = positives + negatives;
            ++i2;
        }
        if (Math.abs(overallCharge) > positives * this.tol) {
            String quest0 = "Class: Donnan, method: unpack()\n";
            String quest1 = "Total charge = " + overallCharge + " mol/dm, i.e. is not equal to zero\n";
            String quest2 = "Positive charge = " + positives + " mol/dm\n";
            String quest3 = "Do you wish to continue?";
            String quest = String.valueOf(quest0) + quest1 + quest2 + quest3;
            int res = JOptionPane.showConfirmDialog(null, quest, "Neutrality check", 0, 3);
            if (res == 1) {
                System.exit(0);
            }
        }
    }

    public double BornChargingEnergy(double radius, double charge, double epsilon) {
        return Fmath.square(-1.60217646263E-19 * charge) / (Math.PI * 8 * radius * 8.854187817E-12 * epsilon);
    }

    public void ionConcns(double potential) {
        int ii = 0;
        while (ii < this.numOfIons) {
            this.partCoeffPot[ii] = this.partCoeff[ii] * Math.exp(-potential * this.charges[ii] * -1.60217646263E-19 / (1.380650324E-23 * this.temp));
            ++ii;
        }
        if (!this.includeIc) {
            if (this.nonZeroAssocK < 2) {
                this.calcConcnsSingleK(potential);
            } else {
                this.calcConcnsMultiK(potential);
            }
        } else {
            this.calcConcnsMultiK(potential);
        }
    }

    public void calcConcnsSingleK(double potential) {
        int ii = 0;
        while (ii < this.numOfIons) {
            if (this.assocConsts[ii] == 0.0 || this.ionophoreConcn == 0.0) {
                if (this.molesT[ii] == 0.0) {
                    this.concnB[ii] = 0.0;
                    this.concnA[ii] = 0.0;
                    this.complex[ii] = 0.0;
                } else {
                    this.concnB[ii] = this.molesT[ii] / (this.volumeA * this.partCoeffPot[ii] + this.volumeB);
                    this.concnA[ii] = this.concnB[ii] * this.partCoeffPot[ii];
                    this.complex[ii] = 0.0;
                }
            } else {
                double bb = this.volumeB + this.volumeA * this.partCoeffPot[ii] + this.volumeB * this.assocConsts[ii] * this.ionophoreConcn - this.assocConsts[ii] * this.molesT[ii];
                double aa = this.assocConsts[ii] * (this.volumeB + this.volumeA * this.partCoeffPot[ii]);
                double cc = -this.molesT[ii];
                double root2 = bb * bb - 4.0 * aa * cc;
                if (root2 < 0.0) {
                    System.out.println("Class: DonnanMinim\nMethod: ionConcns\nthe square root term (b2-4ac) of the quadratic = " + root2);
                    System.out.println("this term was set to zero as the negative value MAY have arisen from rounding errors");
                    root2 = 0.0;
                }
                double qq = -0.5 * (bb + Fmath.sign(bb) * Math.sqrt(root2));
                double root1 = qq / aa;
                double root22 = cc / qq;
                double limit = this.molesT[ii] / (this.volumeA * this.partCoeffPot[ii] + this.volumeB);
                if (root1 >= 0.0 && root1 <= limit) {
                    if (root22 < 0.0 || root22 > limit) {
                        this.concnB[ii] = root1;
                        this.concnA[ii] = this.concnB[ii] * this.partCoeffPot[ii];
                        this.complex[ii] = this.assocConsts[ii] * this.ionophoreConcn * this.concnB[ii] / (1.0 + this.assocConsts[ii] * this.concnB[ii]);
                    } else {
                        System.out.println("Class: DonnanMinim\nMethod: ionConcns");
                        System.out.println("error1: no physically meaningfull root");
                        System.out.println("root1 = " + root1 + " root2 = " + root22 + " limit = " + limit);
                        System.exit(0);
                    }
                } else if (root22 >= 0.0 && root22 <= limit) {
                    if (root1 < 0.0 || root1 > limit) {
                        this.concnB[ii] = root22;
                        this.concnA[ii] = this.concnB[ii] * this.partCoeffPot[ii];
                        this.complex[ii] = this.assocConsts[ii] * this.ionophoreConcn * this.concnB[ii] / (1.0 + this.assocConsts[ii] * this.concnB[ii]);
                    } else {
                        System.out.println("Class: DonnanMinim\nMethod: ionConcns");
                        System.out.println("error2: no physically meaningfull root");
                        System.out.println("root1 = " + root1 + " root2 = " + root22 + " limit = " + limit);
                        System.exit(0);
                    }
                } else {
                    System.out.println("Class: DonnanMinim\nMethod: ionConcns");
                    System.out.println("error3: no physically meaningfull root");
                    System.out.println("root1 = " + root1 + " root2 = " + root22 + " limit = " + limit);
                    System.exit(0);
                }
            }
            ++ii;
        }
    }

    public void calcConcnsMultiK(double potential) {
        double[] start = new double[this.numOfIons];
        double[] step2 = new double[this.numOfIons];
        int ii = 0;
        while (ii < this.numOfIons) {
            if (this.molesT[ii] == 0.0) {
                this.concnB[ii] = 0.0;
                this.concnA[ii] = 0.0;
                this.complex[ii] = 0.0;
                this.excessConcnA[ii] = 0.0;
                this.excessConcnB[ii] = 0.0;
                this.excessComplex[ii] = 0.0;
            } else {
                this.concnB[ii] = this.molesT[ii] / (this.volumeA * this.partCoeffPot[ii] + this.volumeB);
                this.concnA[ii] = this.concnB[ii] * this.partCoeffPot[ii];
                this.complex[ii] = 0.0;
                this.excessConcnA[ii] = 0.0;
                this.excessConcnB[ii] = 0.0;
                this.excessComplex[ii] = 0.0;
            }
            start[ii] = this.concnB[ii];
            step2[ii] = 0.05 * start[ii];
            ++ii;
        }
        Minimisation minConcn = new Minimisation();
        DonnanConcn functC = new DonnanConcn();
        functC.numOfIons = this.numOfIons;
        functC.concnA = this.concnA;
        functC.concnB = this.concnB;
        functC.molesT = this.molesT;
        functC.complex = this.complex;
        functC.excessConcnA = this.excessConcnA;
        functC.excessConcnB = this.excessConcnB;
        functC.excessComplex = this.excessComplex;
        functC.assocConsts = this.assocConsts;
        functC.indexK = this.indexK;
        functC.nonZeroAssocK = this.nonZeroAssocK;
        functC.radii = this.radii;
        functC.charges = this.charges;
        functC.ionophoreConcn = this.ionophoreConcn;
        functC.ionophoreRad = this.ionophoreRad;
        functC.volumeA = this.volumeA;
        functC.volumeB = this.volumeB;
        functC.interfacialArea = this.interfacialArea;
        functC.epsilonA = this.epsilonA;
        functC.epsilonB = this.epsilonB;
        functC.epsilonSternA = this.epsilonSternA;
        functC.epsilonSternB = this.epsilonSternB;
        functC.temp = this.temp;
        functC.partCoeffPot = this.partCoeffPot;
        functC.sternCap = this.sternCap;
        functC.sternDeltaA = this.sternDeltaA;
        functC.sternDeltaB = this.sternDeltaB;
        functC.chargeValue = this.chargeValue;
        functC.chargeSame = this.chargeSame;
        functC.interfacialCharge = this.interfacialCharge;
        functC.interfacialChargeDensity = this.interfacialChargeDensity;
        functC.potential = potential;
        functC.includeIc = this.includeIc;
        minConcn.nelderMead(functC, start, step2, 1.0E-20, 10000);
        double[] param2 = minConcn.getParamValues();
        this.freeIonophoreConcn = this.ionophoreConcn;
        int i = 0;
        while (i < this.numOfIons) {
            this.concnB[i] = param2[i];
            this.concnA[i] = this.concnB[i] * this.partCoeffPot[i];
            this.freeIonophoreConcn -= this.complex[i];
            ++i;
        }
        this.interfacialCharge = functC.interfacialCharge;
        this.interfacialChargeDensity = functC.interfacialChargeDensity;
        this.sternCap = functC.sternCap;
        this.sternDeltaA = functC.sternDeltaA;
        this.sternDeltaB = functC.sternDeltaB;
        this.sternPotential = functC.sternPotential;
        this.diffPotentialA = functC.diffPotentialA;
        this.diffPotentialB = functC.diffPotentialB;
    }

    public void printToFile(String title) {
        int i;
        FileOutput fout = new FileOutput(title);
        fout.dateAndTimeln(title);
        fout.println();
        fout.print("Donnan potential = ");
        fout.printsp(Fmath.truncate(this.donnanPotential, 7));
        fout.println("volts");
        if (this.includeIc) {
            fout.print("Compartment A double layer potential difference = ");
            fout.printsp(Fmath.truncate(this.diffPotentialA, 7));
            fout.println("volts");
            fout.print("Compartment B double layer potential difference = ");
            fout.printsp(Fmath.truncate(this.diffPotentialB, 7));
            fout.println("volts");
            fout.print("Stern potential difference = ");
            fout.printsp(Fmath.truncate(this.sternPotential, 7));
            fout.println("volts");
        }
        fout.println();
        fout.println("Ionic concentrations expressed as mol per cubic decimetre (M)");
        fout.println("Total = equivalent concentration with all ions in compartment A");
        if (this.includeIc) {
            fout.printtab("Ion");
            fout.println("Bulk concentrations / M                         Excess concentrations / M                       total / M");
            fout.printtab(" ");
            fout.println("A               B               complex         A               B               complex         ");
            i = 0;
            while (i < this.numOfIons) {
                fout.printtab(this.ionNames[i]);
                fout.printtab(Fmath.truncate(this.concnA[i] * 0.001, 7));
                fout.printtab(Fmath.truncate(this.concnB[i] * 0.001, 7));
                fout.printtab(Fmath.truncate(this.complex[i] * 0.001, 7));
                fout.printtab(Fmath.truncate(this.excessConcnA[i] * 0.001, 7));
                fout.printtab(Fmath.truncate(this.excessConcnB[i] * 0.001, 7));
                fout.printtab(Fmath.truncate(this.excessComplex[i] * 0.001, 7));
                fout.println(Fmath.truncate(this.molesT[i] * 0.001 / this.volumeA, 7));
                ++i;
            }
        } else {
            fout.printtab("Ion");
            fout.println("A               B               complex         total");
            i = 0;
            while (i < this.numOfIons) {
                fout.printtab(this.ionNames[i]);
                fout.printtab(Fmath.truncate(this.concnA[i] * 0.001, 7));
                fout.printtab(Fmath.truncate(this.concnB[i] * 0.001, 7));
                fout.printtab(Fmath.truncate(this.complex[i] * 0.001, 7));
                fout.println(Fmath.truncate(this.molesT[i] * 0.001 / this.volumeA, 7));
                ++i;
            }
        }
        fout.println();
        fout.println("mols of each ionic species");
        if (this.includeIc) {
            fout.printtab("Ion");
            fout.println("Bulk mols                                       Excess mols                                 total mols");
            fout.printtab(" ");
            fout.println("A               B               complex         A               B               complex         ");
            i = 0;
            while (i < this.numOfIons) {
                fout.printtab(this.ionNames[i]);
                fout.printtab(Fmath.truncate(this.concnA[i] * this.volumeA, 7));
                fout.printtab(Fmath.truncate(this.concnB[i] * this.volumeB, 7));
                fout.printtab(Fmath.truncate(this.complex[i] * this.volumeB, 7));
                fout.printtab(Fmath.truncate(this.excessConcnA[i] * this.volumeA, 7));
                fout.printtab(Fmath.truncate(this.excessConcnB[i] * this.volumeB, 7));
                fout.printtab(Fmath.truncate(this.excessComplex[i] * this.volumeB, 7));
                fout.println(Fmath.truncate(this.molesT[i], 7));
                ++i;
            }
        } else {
            fout.printtab("Ion");
            fout.println("A               B               complex         total mols");
            i = 0;
            while (i < this.numOfIons) {
                fout.printtab(this.ionNames[i]);
                fout.printtab(Fmath.truncate(this.concnA[i] * this.volumeA, 7));
                fout.printtab(Fmath.truncate(this.concnB[i] * this.volumeB, 7));
                fout.printtab(Fmath.truncate(this.complex[i] * this.volumeB, 7));
                fout.println(Fmath.truncate(this.molesT[i], 7));
                ++i;
            }
        }
        fout.println();
        if (this.includeIc) {
            fout.println("Ratios of excess concentration over bulk concentration");
            fout.printtab("Ion");
            fout.println("A               B               complex");
            i = 0;
            while (i < this.numOfIons) {
                fout.printtab(this.ionNames[i]);
                fout.printtab(Fmath.truncate(this.ratioA[i], 7));
                fout.printtab(Fmath.truncate(this.ratioB[i], 7));
                fout.println(Fmath.truncate(this.ratioC[i], 7));
                ++i;
            }
            fout.println();
        }
        fout.print("Total ionophore concentration = ");
        fout.printsp(Fmath.truncate(this.ionophoreConcn * 0.001, 7));
        fout.println("M");
        fout.print("Free ionophore concentration = ");
        fout.printsp(Fmath.truncate(this.freeIonophoreConcn * 0.001, 7));
        fout.println("M");
        fout.print("Total ionophore moles = ");
        fout.printsp(Fmath.truncate(this.ionophoreConcn * this.volumeB, 7));
        fout.println("mol");
        fout.print("Ionophore radius = ");
        fout.printsp(Fmath.truncate(this.ionophoreRad, 7));
        fout.println("m");
        fout.println();
        if (this.includeIc) {
            fout.print("Interface charge density = ");
            fout.printsp(Fmath.truncate(this.interfacialChargeDensity, 7));
            fout.printsp("C per square metre   ->   ");
            fout.printsp(Fmath.truncate(this.interfacialChargeDensity / Math.abs(-1.60217646263E-19), 7));
            fout.println("unit charges per square metre ");
            fout.print("Total interface charge = ");
            fout.printsp(Fmath.truncate(this.interfacialCharge, 7));
            fout.printsp("unit charges   ->   ");
            fout.printsp(Fmath.truncate(this.interfacialCharge / Math.abs(-1.60217646263E-19), 7));
            fout.println("unit charges ");
            fout.print("Overall interfacial capacitance = ");
            fout.printsp(Fmath.truncate(this.donnanCap * this.interfacialArea, 7));
            fout.printsp("F ");
            fout.print("  ->  ");
            fout.printsp(Fmath.truncate(this.donnanCap, 7));
            fout.println("Farads per square metre");
            fout.print("Diffuse double layer capacitance (Compartment A) = ");
            fout.printsp(Fmath.truncate(this.diffCapA * this.interfacialArea, 7));
            fout.printsp("F ");
            fout.print("  ->  ");
            fout.printsp(Fmath.truncate(this.diffCapA, 7));
            fout.println("Farads per square metre");
            fout.print("Diffuse double layer capacitance (Compartment B) = ");
            fout.printsp(Fmath.truncate(this.diffCapB * this.interfacialArea, 7));
            fout.printsp("F ");
            fout.print("  ->  ");
            fout.printsp(Fmath.truncate(this.diffCapB, 7));
            fout.println("Farads per square metre");
            fout.print("Stern capacitance = ");
            fout.printsp(Fmath.truncate(this.sternCap * this.interfacialArea, 7));
            fout.printsp("F ");
            fout.print("  ->  ");
            fout.printsp(Fmath.truncate(this.sternCap, 7));
            fout.println("Farads per square metre");
            fout.print("Stern thickness (Compartment A) = ");
            fout.printsp(Fmath.truncate(this.sternDeltaA, 7));
            fout.println("m");
            fout.print("Stern thickness (Compartment B) = ");
            fout.printsp(Fmath.truncate(this.sternDeltaB, 7));
            fout.println("m");
            fout.print("Debye length (Compartment A) = ");
            fout.printsp(Fmath.truncate(this.recipKappaA, 7));
            fout.println("m");
            fout.print("Debye length (Compartment B) = ");
            fout.printsp(Fmath.truncate(this.recipKappaB, 7));
            fout.println("m");
            fout.println("Compartment thicknesses assuming cubes with one side equal to the interfacial area");
            fout.print("Compartment A thickness = ");
            fout.printsp(Fmath.truncate(this.volumeA / this.interfacialArea, 7));
            fout.println("m");
            fout.print("Compartment B thickness = ");
            fout.printsp(Fmath.truncate(this.volumeB / this.interfacialArea, 7));
            fout.println("m");
            fout.println();
        }
        fout.print("Volume of compartment A = ");
        fout.printsp(this.volumeA);
        fout.println("cubic metres");
        fout.print("Volume of compartment B = ");
        fout.printsp(this.volumeB);
        fout.println("cubic metres");
        fout.print("Interfacial area = ");
        fout.printsp(this.interfacialArea);
        fout.println("square metres");
        fout.print("Relative electrical permittivity of compartment A = ");
        fout.println(this.epsilonA);
        fout.print("Relative electrical permittivity of compartment B = ");
        fout.println(this.epsilonB);
        fout.print("Relative electrical permittivity of compartment A Stern layer= ");
        fout.println(this.epsilonSternA);
        fout.print("Relative electrical permittivity of compartment B Stern layer= ");
        fout.println(this.epsilonSternB);
        fout.print("Temperature= ");
        fout.printsp(this.temp + -273.15);
        fout.println("degrees Celsius");
        fout.println();
        fout.printtab("Ion");
        fout.printtab("Radius   ");
        fout.printtab("Charge");
        fout.printtab("Partition");
        fout.printtab("Partition");
        fout.printtab("Delta(mu0)");
        fout.println("Ion-Ionophore ");
        fout.printtab("  ");
        fout.printtab(" m       ");
        fout.printtab(" ");
        fout.printtab("Coefficient ");
        fout.printtab("Coefficient ");
        fout.printtab("/ J per mol");
        fout.println("associaion ");
        fout.printtab("  ");
        fout.printtab("         ");
        fout.printtab(" ");
        fout.printtab("at      ");
        fout.printtab("at zero ");
        fout.printtab("       ");
        fout.println("constant");
        fout.printtab("  ");
        fout.printtab("          ");
        fout.printtab(" ");
        fout.printtab("equilibrium ");
        fout.printtab("potential ");
        fout.printtab("          ");
        fout.println("mol per cubic dm");
        i = 0;
        while (i < this.numOfIons) {
            fout.printtab(this.ionNames[i]);
            fout.printtab(Fmath.truncate(this.radii[i], 4));
            fout.printtab(this.charges[i]);
            fout.printtab(Fmath.truncate(this.partCoeffPot[i], 4));
            fout.printtab(Fmath.truncate(this.partCoeff[i], 4));
            fout.printtab(Fmath.truncate(this.deltaMu0[i], 4));
            fout.println(Fmath.truncate(this.assocConsts[i] * 1000.0, 4));
            ++i;
        }
        fout.close();
    }

    public void printToFile() {
        String title = "DonnanOutputFile.txt";
        this.printToFile(title);
    }
}

