/*
 * Decompiled with CFR 0.152.
 */
package flanagan.physchem;

import flanagan.analysis.RegressionFunction;
import flanagan.math.Fmath;

class Amersham
implements RegressionFunction {
    Amersham() {
    }

    @Override
    public double function(double[] p, double[] x2) {
        return this.calcResponse(p[0], p[1], p[2], p[3], x2[0], p[4]);
    }

    public double calcResponse(double assocK, double labelF, double antibodyF, double nsbF, double analyteF, double scaleF) {
        double term1 = assocK + labelF + analyteF;
        double numer = 2.0 * antibodyF * (labelF - nsbF) / labelF;
        double denom = term1 + antibodyF + Math.sqrt(Fmath.square(term1 - antibodyF) + 4.0 * assocK * antibodyF);
        double signal = scaleF * (numer / denom + nsbF / labelF);
        return signal;
    }
}

