/*
 * Decompiled with CFR 0.152.
 */
package flanagan.optics;

import flanagan.roots.RealRootFunction;

class FunctTE
implements RealRootFunction {
    public double substrateRefractiveIndex2 = 0.0;
    public double superstrateRefractiveIndex2 = 0.0;
    public double effectiveRefractiveIndex2 = 0.0;
    public double prismRefractiveIndex2 = 0.0;
    public double ko = 0.0;
    public double prismToWaveguideGap = 0.0;
    public boolean setPrismToWaveguideGap = false;
    public double thickness = 0.0;
    public double modeNumber = 0.0;

    FunctTE() {
    }

    @Override
    public double function(double x2) {
        double y = 0.0;
        double coreFilmRefractiveIndex2 = x2 * x2;
        double zetaSub = Math.sqrt(this.effectiveRefractiveIndex2 - this.substrateRefractiveIndex2);
        double zetaSuper = Math.sqrt(this.effectiveRefractiveIndex2 - this.superstrateRefractiveIndex2);
        double zetaFilm = Math.sqrt(coreFilmRefractiveIndex2 - this.effectiveRefractiveIndex2);
        double zetaPrism = Math.sqrt(this.prismRefractiveIndex2 - this.effectiveRefractiveIndex2);
        double gammaSuper = Math.atan2(zetaSuper, zetaFilm);
        y = Math.PI * this.modeNumber - this.thickness * this.ko * zetaFilm;
        y += gammaSuper + Math.atan2(zetaSub, zetaFilm);
        if (this.setPrismToWaveguideGap) {
            y += Math.sin(gammaSuper) * Math.cos(Math.atan2(zetaSuper, zetaPrism)) * Math.exp(-2.0 * this.prismToWaveguideGap * this.ko * zetaSuper);
        }
        return y;
    }
}

