/*
 * Decompiled with CFR 0.152.
 */
package flanagan.math;

import flanagan.complex.Complex;
import flanagan.io.FileInput;
import flanagan.io.FileOutput;
import flanagan.math.Fmath;
import flanagan.plot.PlotGraph;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.JFrame;

public class FourierTransform
extends Canvas
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Complex[] complexData = null;
    private Complex[] complexCorr = null;
    private boolean complexDataSet = false;
    private int originalDataLength = 0;
    private int fftDataLength = 0;
    private boolean dataAltered = false;
    private double[] fftData = null;
    private double[] fftCorr = null;
    private double[] fftResp = null;
    private boolean fftDataSet = false;
    private double[] fftDataWindow = null;
    private double[] fftCorrWindow = null;
    private int windowOption = 0;
    private String[] windowNames = new String[]{"no windowing applied", "Rectangular (square, box-car)", "Bartlett (triangular)", "Welch", "Hann (Hanning)", "Hamming", "Kaiser", "Gaussian"};
    private String windowName = this.windowNames[0];
    private double kaiserAlpha = 2.0;
    private double gaussianAlpha = 2.5;
    private double[] weights = null;
    private boolean windowSet = false;
    private boolean windowApplied = false;
    private double sumOfSquaredWeights = 0.0;
    private Complex[] transformedDataComplex = null;
    private double[] transformedDataFft = null;
    private boolean fftDone = false;
    private double[][] powerSpectrumEstimate = null;
    private boolean powSpecDone = false;
    private int psdNumberOfPoints = 0;
    private int segmentNumber = 1;
    private int segmentLength = 0;
    private boolean overlap = false;
    private boolean segNumSet = false;
    private boolean segLenSet = false;
    private double deltaT = 1.0;
    private boolean deltaTset = false;
    private double[][] correlationArray = null;
    private boolean correlateDone = false;
    private int numberOfWarnings = 9;
    private boolean[] warning = new boolean[this.numberOfWarnings];
    private int plotLineOption = 0;
    private int plotPointOption = 0;
    private double[][] timeFrequency = null;
    private boolean shortTimeDone = false;
    private int numShortFreq = 0;
    private int numShortTimes = 0;
    private String shortTitle = " ";

    public FourierTransform() {
        int i = 0;
        while (i < this.numberOfWarnings) {
            this.warning[i] = false;
            ++i;
        }
    }

    public FourierTransform(double[] realData) {
        this.originalDataLength = realData.length;
        this.fftDataLength = FourierTransform.nextPowerOfTwo(this.originalDataLength);
        this.complexData = Complex.oneDarray(this.fftDataLength);
        int i = 0;
        while (i < this.originalDataLength) {
            this.complexData[i].setReal(realData[i]);
            this.complexData[i].setImag(0.0);
            ++i;
        }
        i = this.originalDataLength;
        while (i < this.fftDataLength) {
            this.complexData[i].reset(0.0, 0.0);
            ++i;
        }
        this.complexDataSet = true;
        this.fftData = new double[2 * this.fftDataLength];
        int j = 0;
        int i2 = 0;
        while (i2 < this.fftDataLength) {
            this.fftData[j] = this.complexData[i2].getReal();
            this.fftData[++j] = 0.0;
            ++j;
            ++i2;
        }
        this.fftDataSet = true;
        this.fftDataWindow = new double[2 * this.fftDataLength];
        this.weights = new double[this.fftDataLength];
        this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
        this.transformedDataFft = new double[2 * this.fftDataLength];
        this.transformedDataComplex = Complex.oneDarray(this.fftDataLength);
        this.segmentLength = this.fftDataLength;
        i2 = 0;
        while (i2 < this.numberOfWarnings) {
            this.warning[i2] = false;
            ++i2;
        }
    }

    public FourierTransform(Complex[] data2) {
        this.originalDataLength = data2.length;
        this.fftDataLength = FourierTransform.nextPowerOfTwo(this.originalDataLength);
        this.complexData = Complex.oneDarray(this.fftDataLength);
        int i = 0;
        while (i < this.originalDataLength) {
            this.complexData[i] = data2[i].copy();
            ++i;
        }
        i = this.originalDataLength;
        while (i < this.fftDataLength) {
            this.complexData[i].reset(0.0, 0.0);
            ++i;
        }
        this.complexDataSet = true;
        this.fftData = new double[2 * this.fftDataLength];
        int j = 0;
        int i2 = 0;
        while (i2 < this.fftDataLength) {
            this.fftData[j] = this.complexData[i2].getReal();
            this.fftData[++j] = this.complexData[i2].getImag();
            ++j;
            ++i2;
        }
        this.fftDataSet = true;
        this.fftDataWindow = new double[2 * this.fftDataLength];
        this.weights = new double[this.fftDataLength];
        this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
        this.transformedDataFft = new double[2 * this.fftDataLength];
        this.transformedDataComplex = Complex.oneDarray(this.fftDataLength);
        this.segmentLength = this.fftDataLength;
        i2 = 0;
        while (i2 < this.numberOfWarnings) {
            this.warning[i2] = false;
            ++i2;
        }
    }

    public void setData(double[] realData) {
        this.originalDataLength = realData.length;
        this.fftDataLength = FourierTransform.nextPowerOfTwo(this.originalDataLength);
        this.complexData = Complex.oneDarray(this.fftDataLength);
        int i = 0;
        while (i < this.originalDataLength) {
            this.complexData[i].setReal(realData[i]);
            this.complexData[i].setImag(0.0);
            ++i;
        }
        i = this.originalDataLength;
        while (i < this.fftDataLength) {
            this.complexData[i].reset(0.0, 0.0);
            ++i;
        }
        this.complexDataSet = true;
        this.fftData = new double[2 * this.fftDataLength];
        int j = 0;
        int i2 = 0;
        while (i2 < this.fftDataLength) {
            this.fftData[j] = this.complexData[i2].getReal();
            this.fftData[++j] = 0.0;
            ++j;
            ++i2;
        }
        this.fftDataSet = true;
        this.fftDataWindow = new double[2 * this.fftDataLength];
        this.weights = new double[this.fftDataLength];
        this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
        this.transformedDataFft = new double[2 * this.fftDataLength];
        this.transformedDataComplex = Complex.oneDarray(this.fftDataLength);
        if (this.segNumSet) {
            this.setSegmentNumber(this.segmentNumber);
        } else if (this.segLenSet) {
            this.setSegmentLength(this.segmentLength);
        } else {
            this.segmentLength = this.fftDataLength;
        }
    }

    public void setData(Complex[] data2) {
        this.originalDataLength = data2.length;
        this.fftDataLength = FourierTransform.nextPowerOfTwo(this.originalDataLength);
        this.complexData = Complex.oneDarray(this.fftDataLength);
        int i = 0;
        while (i < this.originalDataLength) {
            this.complexData[i] = data2[i].copy();
            ++i;
        }
        i = this.originalDataLength;
        while (i < this.fftDataLength) {
            this.complexData[i].reset(0.0, 0.0);
            ++i;
        }
        this.complexDataSet = true;
        this.fftData = new double[2 * this.fftDataLength];
        int j = 0;
        int i2 = 0;
        while (i2 < this.fftDataLength) {
            this.fftData[j] = this.complexData[i2].getReal();
            this.fftData[++j] = this.complexData[i2].getImag();
            ++j;
            ++i2;
        }
        this.fftDataSet = true;
        this.fftDataWindow = new double[2 * this.fftDataLength];
        this.weights = new double[this.fftDataLength];
        this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
        this.transformedDataFft = new double[2 * this.fftDataLength];
        this.transformedDataComplex = Complex.oneDarray(this.fftDataLength);
        if (this.segNumSet) {
            this.setSegmentNumber(this.segmentNumber);
        } else if (this.segLenSet) {
            this.setSegmentLength(this.segmentLength);
        } else {
            this.segmentLength = this.fftDataLength;
        }
    }

    public void setFftData(double[] fftdata) {
        if (fftdata.length % 2 != 0) {
            throw new IllegalArgumentException("data length must be an even number");
        }
        this.originalDataLength = fftdata.length / 2;
        this.fftDataLength = FourierTransform.nextPowerOfTwo(this.originalDataLength);
        this.fftData = new double[2 * this.fftDataLength];
        int i = 0;
        while (i < 2 * this.originalDataLength) {
            this.fftData[i] = fftdata[i];
            ++i;
        }
        i = 2 * this.originalDataLength;
        while (i < 2 * this.fftDataLength) {
            this.fftData[i] = 0.0;
            ++i;
        }
        this.fftDataSet = true;
        this.complexData = Complex.oneDarray(this.fftDataLength);
        int j = -1;
        int i2 = 0;
        while (i2 < this.fftDataLength) {
            this.complexData[i2].setReal(this.fftData[++j]);
            this.complexData[i2].setImag(this.fftData[++j]);
            ++i2;
        }
        this.complexDataSet = true;
        this.fftDataWindow = new double[2 * this.fftDataLength];
        this.weights = new double[this.fftDataLength];
        this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
        this.transformedDataFft = new double[2 * this.fftDataLength];
        this.transformedDataComplex = Complex.oneDarray(this.fftDataLength);
        if (this.segNumSet) {
            this.setSegmentNumber(this.segmentNumber);
        } else if (this.segLenSet) {
            this.setSegmentLength(this.segmentLength);
        } else {
            this.segmentLength = this.fftDataLength;
        }
    }

    public Complex[] getComplexInputData() {
        if (!this.complexDataSet) {
            System.out.println("complex data set not entered or calculated - null returned");
        }
        return this.complexData;
    }

    public double[] getAlternateInputData() {
        if (!this.fftDataSet) {
            System.out.println("fft data set not entered or calculted - null returned");
        }
        return this.fftData;
    }

    public double[] getAlternateWindowedInputData() {
        if (!this.fftDataSet) {
            System.out.println("fft data set not entered or calculted - null returned");
        }
        if (!this.fftDataSet) {
            System.out.println("fft data set not entered or calculted - null returned");
        }
        if (!this.windowApplied) {
            System.out.println("fft data set has not been multiplied by windowing weights");
        }
        return this.fftDataWindow;
    }

    public int getOriginalDataLength() {
        return this.originalDataLength;
    }

    public int getUsedDataLength() {
        return this.fftDataLength;
    }

    public void setDeltaT(double deltaT) {
        this.deltaT = deltaT;
        this.deltaTset = true;
    }

    public double getDeltaT() {
        double ret = 0.0;
        if (this.deltaTset) {
            ret = this.deltaT;
        } else {
            System.out.println("detaT has not been set - zero returned");
        }
        return ret;
    }

    public void setRectangular() {
        this.windowOption = 1;
        this.windowSet = true;
        if (this.fftDataSet) {
            this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
            this.windowApplied = true;
        }
    }

    public void setBartlett() {
        this.windowOption = 2;
        this.windowSet = true;
        if (this.fftDataSet) {
            this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
            this.windowApplied = true;
        }
    }

    public void setWelch() {
        this.windowOption = 3;
        this.windowSet = true;
        if (this.fftDataSet) {
            this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
            this.windowApplied = true;
        }
    }

    public void setHann() {
        this.windowOption = 4;
        this.windowSet = true;
        if (this.fftDataSet) {
            this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
            this.windowApplied = true;
        }
    }

    public void setHamming() {
        this.windowOption = 5;
        this.windowSet = true;
        if (this.fftDataSet) {
            this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
            this.windowApplied = true;
        }
    }

    public void setKaiser(double alpha) {
        this.kaiserAlpha = alpha;
        this.windowOption = 6;
        this.windowSet = true;
        if (this.fftDataSet) {
            this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
            this.windowApplied = true;
        }
    }

    public void setKaiser() {
        this.windowOption = 6;
        this.windowSet = true;
        if (this.fftDataSet) {
            this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
            this.windowApplied = true;
        }
    }

    public void setGaussian(double alpha) {
        if (alpha < 2.0) {
            alpha = 2.0;
            System.out.println("setGaussian; alpha must be greater than or equal to 2 - alpha has been reset to 2");
        }
        this.gaussianAlpha = alpha;
        this.windowOption = 7;
        this.windowSet = true;
        if (this.fftDataSet) {
            this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
            this.windowApplied = true;
        }
    }

    public void setGaussian() {
        this.windowOption = 7;
        this.windowSet = true;
        if (this.fftDataSet) {
            this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
            this.windowApplied = true;
        }
    }

    public void removeWindow() {
        this.windowOption = 0;
        this.windowSet = false;
        if (this.fftDataSet) {
            this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
            this.windowApplied = false;
        }
    }

    private double windowData(double[] data2, double[] window, double[] weight) {
        int m = data2.length;
        int n = m / 2 - 1;
        int j = 0;
        double sum2 = 0.0;
        switch (this.windowOption) {
            case 0: 
            case 1: {
                int i = 0;
                while (i <= n) {
                    weight[i] = 1.0;
                    window[j] = data2[j++];
                    window[j] = data2[j++];
                    ++i;
                }
                sum2 = n + 1;
                break;
            }
            case 2: {
                int i = 0;
                while (i <= n) {
                    weight[i] = 1.0 - (double)Math.abs((i - n / 2) / n / 2);
                    sum2 += weight[i] * weight[i];
                    window[j] = data2[j++] * weight[i];
                    window[j] = data2[j++] * weight[i];
                    ++i;
                }
                break;
            }
            case 3: {
                int i = 0;
                while (i <= n) {
                    weight[i] = 1.0 - (double)Fmath.square((i - n / 2) / n / 2);
                    sum2 += weight[i] * weight[i];
                    window[j] = data2[j++] * weight[i];
                    window[j] = data2[j++] * weight[i];
                    ++i;
                }
                break;
            }
            case 4: {
                int i = 0;
                while (i <= n) {
                    weight[i] = (1.0 - Math.cos(2.0 * (double)i * Math.PI / (double)n)) / 2.0;
                    sum2 += weight[i] * weight[i];
                    window[j] = data2[j++] * weight[i];
                    window[j] = data2[j++] * weight[i];
                    ++i;
                }
                break;
            }
            case 5: {
                int i = 0;
                while (i <= n) {
                    weight[i] = 0.54 + 0.46 * Math.cos(2.0 * (double)i * Math.PI / (double)n);
                    sum2 += weight[i] * weight[i];
                    window[j] = data2[j++] * weight[i];
                    window[j] = data2[j++] * weight[i];
                    ++i;
                }
                break;
            }
            case 6: {
                double denom = FourierTransform.modBesselIo(Math.PI * this.kaiserAlpha);
                double numer = 0.0;
                int i = 0;
                while (i <= n) {
                    numer = FourierTransform.modBesselIo(Math.PI * this.kaiserAlpha * Math.sqrt(1.0 - Fmath.square(2.0 * (double)i / (double)n - 1.0)));
                    weight[i] = numer / denom;
                    sum2 += weight[i] * weight[i];
                    window[j] = data2[j++] * weight[i];
                    window[j] = data2[j++] * weight[i];
                    ++i;
                }
                break;
            }
            case 7: {
                int i = 0;
                while (i <= n) {
                    weight[i] = Math.exp(-0.5 * Fmath.square(this.gaussianAlpha * (double)(2 * i - n) / (double)n));
                    sum2 += weight[i] * weight[i];
                    window[j] = data2[j++] * weight[i];
                    window[j] = data2[j++] * weight[i];
                    ++i;
                }
                break;
            }
        }
        return sum2;
    }

    public static double modBesselIo(double arg) {
        double d;
        double absArg = 0.0;
        double poly = 0.0;
        double bessel = 0.0;
        absArg = Math.abs(arg);
        if (d < 3.75) {
            poly = arg / 3.75;
            poly *= poly;
            bessel = 1.0 + poly * (3.5156229 + poly * (3.08989424 + poly * (1.2067492 + poly * (0.2659732 + poly * (0.0360768 + poly * 0.0045813)))));
        } else {
            bessel = Math.exp(absArg) / Math.sqrt(absArg) * (0.39894228 + poly * (0.01328592 + poly * (0.00225319 + poly * (-0.00157565 + poly * (0.00916281 + poly * (-0.02057706 + poly * (0.02635537 + poly * (-0.01647633 + poly * 0.00392377))))))));
        }
        return bessel;
    }

    public String getWindowOption() {
        String option = " ";
        switch (this.windowOption) {
            case 0: {
                option = "No windowing applied";
                break;
            }
            case 1: {
                option = "Rectangular";
                break;
            }
            case 2: {
                option = "Bartlett";
                break;
            }
            case 3: {
                option = "Welch";
                break;
            }
            case 4: {
                option = "Hann";
                break;
            }
            case 5: {
                option = "Hamming";
                break;
            }
            case 6: {
                option = "Kaiser";
                break;
            }
            case 7: {
                option = "Gaussian";
            }
        }
        return option;
    }

    public double[] getWeights() {
        return this.weights;
    }

    public void setSegmentNumber(int sNum) {
        this.segmentNumber = sNum;
        this.segNumSet = true;
        if (this.segLenSet) {
            this.segLenSet = false;
        }
    }

    public void setSegmentLength(int sLen) {
        this.segmentLength = sLen;
        this.segLenSet = true;
        if (this.segNumSet) {
            this.segNumSet = false;
        }
    }

    private void checkSegmentDetails() {
        int segL;
        if (!this.fftDataSet) {
            throw new IllegalArgumentException("No fft data has been entered or calculated");
        }
        if (this.fftDataLength < 2) {
            throw new IllegalArgumentException("More than one point, MANY MORE, are needed");
        }
        if (this.fftDataLength % 2 != 0) {
            System.out.println("Number of data points must be an even number");
            System.out.println("last point deleted");
            --this.fftDataLength;
            this.dataAltered = true;
            this.warning[0] = true;
        }
        if (this.segNumSet && !this.overlap) {
            if (this.fftDataLength % this.segmentNumber == 0) {
                segL = this.fftDataLength / this.segmentNumber;
                if (FourierTransform.checkPowerOfTwo(segL)) {
                    this.segmentLength = segL;
                    this.segLenSet = true;
                } else {
                    System.out.println("segment length is not an integer power of two");
                    System.out.println("segment length reset to total data length, i.e. no segmentation");
                    this.warning[1] = true;
                    this.segmentNumber = 1;
                    this.segmentLength = this.fftDataLength;
                    this.segLenSet = true;
                }
            } else {
                System.out.println("total data length divided by the number of segments is not an integer");
                System.out.println("segment length reset to total data length, i.e. no segmentation");
                this.warning[2] = true;
                this.segmentNumber = 1;
                this.segmentLength = this.fftDataLength;
                this.segLenSet = true;
            }
        }
        if (this.segLenSet && !this.overlap) {
            if (this.fftDataLength % this.segmentLength == 0) {
                if (FourierTransform.checkPowerOfTwo(this.segmentLength)) {
                    this.segmentNumber = this.fftDataLength / this.segmentLength;
                    this.segNumSet = true;
                } else {
                    System.out.println("segment length is not an integer power of two");
                    System.out.println("segment length reset to total data length, i.e. no segmentation");
                    this.warning[1] = true;
                    this.segmentNumber = 1;
                    this.segmentLength = this.fftDataLength;
                    this.segNumSet = true;
                }
            } else {
                System.out.println("total data length divided by the segment length is not an integer");
                System.out.println("segment length reset to total data length, i.e. no segmentation");
                this.warning[3] = true;
                this.segmentNumber = 1;
                this.segmentLength = this.fftDataLength;
                this.segNumSet = true;
            }
        }
        if (this.segNumSet && this.overlap) {
            if (this.fftDataLength % (this.segmentNumber + 1) == 0) {
                segL = 2 * this.fftDataLength / (this.segmentNumber + 1);
                if (FourierTransform.checkPowerOfTwo(segL)) {
                    this.segmentLength = segL;
                    this.segLenSet = true;
                } else {
                    System.out.println("segment length is not an integer power of two");
                    System.out.println("segment length reset to total data length, i.e. no segmentation");
                    this.warning[1] = true;
                    this.segmentNumber = 1;
                    this.segmentLength = this.fftDataLength;
                    this.segLenSet = true;
                    this.overlap = false;
                }
            } else {
                System.out.println("total data length divided by the number of segments plus one is not an integer");
                System.out.println("segment length reset to total data length, i.e. no segmentation");
                this.warning[4] = true;
                this.segmentNumber = 1;
                this.segmentLength = this.fftDataLength;
                this.segLenSet = true;
                this.overlap = false;
            }
        }
        if (this.segLenSet && this.overlap) {
            if (2 * this.fftDataLength % this.segmentLength == 0) {
                if (FourierTransform.checkPowerOfTwo(this.segmentLength)) {
                    this.segmentNumber = 2 * this.fftDataLength / this.segmentLength - 1;
                    this.segNumSet = true;
                } else {
                    System.out.println("segment length is not an integer power of two");
                    System.out.println("segment length reset to total data length, i.e. no segmentation");
                    this.warning[1] = true;
                    this.segmentNumber = 1;
                    this.segmentLength = this.fftDataLength;
                    this.segNumSet = true;
                    this.overlap = false;
                }
            } else {
                System.out.println("twice the total data length divided by the segment length is not an integer");
                System.out.println("segment length reset to total data length, i.e. no segmentation");
                this.warning[5] = true;
                this.segmentNumber = 1;
                this.segmentLength = this.fftDataLength;
                this.segNumSet = true;
                this.overlap = false;
            }
        }
        if (!this.segNumSet && !this.segLenSet) {
            this.segmentNumber = 1;
            this.segNumSet = true;
            this.overlap = false;
        }
        if (this.overlap && this.segmentNumber < 2) {
            System.out.println("Overlap is not possible with less than two segments.");
            System.out.println("Overlap option has been reset to 'no overlap' i.e. to false.");
            this.overlap = false;
            this.segmentNumber = 1;
            this.segNumSet = true;
            this.warning[6] = true;
        }
        int segLno = 0;
        int segNno = 0;
        int segLov = 0;
        int segNov = 0;
        if (this.segmentNumber == 1 && !FourierTransform.checkPowerOfTwo(this.fftDataLength)) {
            boolean test0 = true;
            boolean test1 = true;
            boolean test2 = true;
            int newL = 0;
            int ii = 2;
            while (test0) {
                newL = this.fftDataLength / ii;
                if (FourierTransform.checkPowerOfTwo(newL) && this.fftDataLength % ii == 0) {
                    test0 = false;
                    segLno = newL;
                    segNno = ii;
                    continue;
                }
                if (newL < 2) {
                    test1 = false;
                    test0 = false;
                    continue;
                }
                ++ii;
            }
            test0 = true;
            ii = 2;
            while (test0) {
                newL = 2 * (this.fftDataLength / (ii + 1));
                if (FourierTransform.checkPowerOfTwo(newL) && this.fftDataLength % (ii + 1) == 0) {
                    test0 = false;
                    segLov = newL;
                    segNov = ii;
                    continue;
                }
                if (newL < 2) {
                    test2 = false;
                    test0 = false;
                    continue;
                }
                ++ii;
            }
            boolean setSegment = true;
            int segL2 = 0;
            int segN = 0;
            boolean ovrlp = false;
            if (test1) {
                if (test2) {
                    if (segLov > segLno) {
                        segL2 = segLov;
                        segN = segNov;
                        ovrlp = true;
                    } else {
                        segL2 = segLno;
                        segN = segNno;
                        ovrlp = false;
                    }
                } else {
                    segL2 = segLno;
                    segN = segNno;
                    ovrlp = false;
                }
            } else if (test2) {
                segL2 = segLov;
                segN = segNov;
                ovrlp = true;
            } else {
                setSegment = false;
            }
            if (setSegment && this.originalDataLength - segL2 <= this.fftDataLength - this.originalDataLength) {
                System.out.println("Data length is not an integer power of two");
                System.out.println("Data cannot be transformed as a single segment");
                System.out.print("The data has been split into " + segN + " segments of length " + segL2);
                if (ovrlp) {
                    System.out.println(" with 50% overlap");
                } else {
                    System.out.println(" with no overlap");
                }
                this.segmentLength = segL2;
                this.segmentNumber = segN;
                this.overlap = ovrlp;
                this.warning[7] = true;
            } else {
                System.out.println("Data length is not an integer power of two");
                if (this.dataAltered) {
                    System.out.println("Deleted point has been restored and the data has been padded with zeros to give a power of two length");
                    this.warning[0] = false;
                } else {
                    System.out.println("Data has been padded with zeros to give a power of two length");
                }
                this.fftDataLength = this.fftDataLength;
                this.warning[8] = true;
            }
        }
    }

    private void printWarnings(FileOutput fout) {
        if (this.warning[0]) {
            fout.println("WARNING!");
            fout.println("Number of data points must be an even number");
            fout.println("The last point was deleted");
            fout.println();
        }
        if (this.warning[1]) {
            fout.println("WARNING!");
            fout.println("Segment length was not an integer power of two");
            fout.println("Segment length was reset to total data length, i.e. no segmentation");
            fout.println();
        }
        if (this.warning[2]) {
            fout.println("WARNING!");
            fout.println("Total data length divided by the number of segments was not an integer");
            fout.println("Segment length was reset to total data length, i.e. no segmentation");
            fout.println();
        }
        if (this.warning[3]) {
            fout.println("WARNING!");
            fout.println("Total data length divided by the segment length was not an integer");
            fout.println("Segment length was reset to total data length, i.e. no segmentation");
            fout.println();
        }
        if (this.warning[4]) {
            fout.println("WARNING!");
            fout.println("Total data length divided by the number of segments plus one was not an integer");
            fout.println("Segment length was reset to total data length, i.e. no segmentation");
            fout.println();
        }
        if (this.warning[5]) {
            fout.println("WARNING!");
            fout.println("Twice the total data length divided by the segment length was not an integer");
            fout.println("Segment length was reset to total data length, i.e. no segmentation");
            fout.println();
        }
        if (this.warning[6]) {
            fout.println("WARNING!");
            fout.println("Overlap is not possible with less than two segments");
            fout.println("Overlap option has been reset to 'no overlap' i.e. to false");
            fout.println();
        }
        if (this.warning[7]) {
            fout.println("WARNING!");
            fout.println("Data length was not an integer power of two");
            fout.println("The data could not be transformed as a single segment");
            fout.print("The data has been split into " + this.segmentNumber + " segment/s of length " + this.segmentLength);
            if (this.overlap) {
                fout.println(" with 50% overlap");
            } else {
                fout.println(" with no overlap");
            }
            fout.println();
        }
        if (this.warning[8]) {
            fout.println("WARNING!");
            fout.println("Data length was not an integer power of two");
            fout.println("Data has been padded with " + (this.fftDataLength - this.originalDataLength) + " zeros to give an integer power of two length");
            fout.println();
        }
    }

    public int getSegmentNumber() {
        return this.segmentNumber;
    }

    public int getSegmentLength() {
        return this.segmentLength;
    }

    public void setOverlapOption(boolean overlapOpt) {
        boolean old = this.overlap;
        this.overlap = overlapOpt;
        if (old != this.overlap && this.fftDataSet) {
            this.setSegmentNumber(this.segmentNumber);
        }
    }

    public boolean getOverlapOption() {
        return this.overlap;
    }

    public static int calcDataLength(boolean overlap, int segLen, int segNum) {
        if (overlap) {
            return (segNum + 1) * segLen / 2;
        }
        return segNum * segLen;
    }

    public void transform() {
        int isign = 1;
        if (!this.fftDataSet) {
            throw new IllegalArgumentException("No data has been entered for the Fast Fourier Transform");
        }
        if (this.originalDataLength != this.fftDataLength) {
            System.out.println("Fast Fourier Transform data length ," + this.originalDataLength + ", is not an integer power of two");
            System.out.println("WARNING!!! Data has been padded with zeros to fill to nearest integer power of two length " + this.fftDataLength);
        }
        double[] hold = new double[this.fftDataLength * 2];
        int i = 0;
        while (i < this.fftDataLength * 2) {
            hold[i] = this.fftDataWindow[i];
            ++i;
        }
        this.basicFft(hold, this.fftDataLength, isign);
        i = 0;
        while (i < this.fftDataLength * 2) {
            this.transformedDataFft[i] = hold[i];
            ++i;
        }
        i = 0;
        while (i < this.fftDataLength) {
            this.transformedDataComplex[i].reset(this.transformedDataFft[2 * i], this.transformedDataFft[2 * i + 1]);
            ++i;
        }
    }

    public void inverse() {
        int isign = -1;
        if (!this.fftDataSet) {
            throw new IllegalArgumentException("No data has been entered for the inverse Fast Fourier Transform");
        }
        if (this.originalDataLength != this.fftDataLength) {
            System.out.println("Fast Fourier Transform data length ," + this.originalDataLength + ", is not an integer power of two");
            System.out.println("WARNING!!! Data has been padded with zeros to fill to nearest integer power of two length " + this.fftDataLength);
        }
        double[] hold = new double[this.fftDataLength * 2];
        int i = 0;
        while (i < this.fftDataLength * 2) {
            hold[i] = this.fftDataWindow[i];
            ++i;
        }
        this.basicFft(hold, this.fftDataLength, isign);
        i = 0;
        while (i < this.fftDataLength * 2) {
            this.transformedDataFft[i] = hold[i] / (double)this.fftDataLength;
            ++i;
        }
        i = 0;
        while (i < this.fftDataLength) {
            this.transformedDataComplex[i].reset(this.transformedDataFft[2 * i], this.transformedDataFft[2 * i + 1]);
            ++i;
        }
    }

    public void basicFft(double[] data2, int nn, int isign) {
        int ii;
        double dtemp = 0.0;
        double wtemp = 0.0;
        double tempr = 0.0;
        double tempi = 0.0;
        double theta = 0.0;
        double wr = 0.0;
        double wpr = 0.0;
        double wpi = 0.0;
        double wi = 0.0;
        int istep = 0;
        int m = 0;
        int mmax = 0;
        int n = nn << 1;
        int j = 1;
        int jj = 0;
        int i = 1;
        while (i < n) {
            jj = j - 1;
            if (j > i) {
                ii = i - 1;
                dtemp = data2[jj];
                data2[jj] = data2[ii];
                data2[ii] = dtemp;
                dtemp = data2[jj + 1];
                data2[jj + 1] = data2[ii + 1];
                data2[ii + 1] = dtemp;
            }
            m = n >> 1;
            while (m >= 2 && j > m) {
                j -= m;
                m >>= 1;
            }
            j += m;
            i += 2;
        }
        mmax = 2;
        while (n > mmax) {
            istep = mmax << 1;
            theta = (double)isign * (6.28318530717959 / (double)mmax);
            wtemp = Math.sin(0.5 * theta);
            wpr = -2.0 * wtemp * wtemp;
            wpi = Math.sin(theta);
            wr = 1.0;
            wi = 0.0;
            m = 1;
            while (m < mmax) {
                i = m;
                while (i <= n) {
                    ii = i - 1;
                    jj = ii + mmax;
                    tempr = wr * data2[jj] - wi * data2[jj + 1];
                    tempi = wr * data2[jj + 1] + wi * data2[jj];
                    data2[jj] = data2[ii] - tempr;
                    data2[jj + 1] = data2[ii + 1] - tempi;
                    int n2 = ii;
                    data2[n2] = data2[n2] + tempr;
                    int n3 = ii + 1;
                    data2[n3] = data2[n3] + tempi;
                    i += istep;
                }
                wtemp = wr;
                wr = wtemp * wpr - wi * wpi + wr;
                wi = wi * wpr + wtemp * wpi + wi;
                m += 2;
            }
            mmax = istep;
        }
    }

    public Complex[] getTransformedDataAsComplex() {
        return this.transformedDataComplex;
    }

    public double[] getTransformedDataAsAlternate() {
        return this.transformedDataFft;
    }

    public double[][] powerSpectrum() {
        this.checkSegmentDetails();
        this.psdNumberOfPoints = this.segmentLength / 2;
        this.powerSpectrumEstimate = new double[2][this.psdNumberOfPoints];
        if (!this.overlap && this.segmentNumber < 2) {
            int isign = 1;
            if (!this.fftDataSet) {
                throw new IllegalArgumentException("No data has been entered for the Fast Fourier Transform");
            }
            if (!FourierTransform.checkPowerOfTwo(this.fftDataLength)) {
                throw new IllegalArgumentException("Fast Fourier Transform data length ," + this.fftDataLength + ", is not an integer power of two");
            }
            double[] hold = new double[this.fftDataLength * 2];
            int i = 0;
            while (i < this.fftDataLength * 2) {
                hold[i] = this.fftDataWindow[i];
                ++i;
            }
            this.basicFft(hold, this.fftDataLength, isign);
            i = 0;
            while (i < this.fftDataLength * 2) {
                this.transformedDataFft[i] = hold[i];
                ++i;
            }
            i = 0;
            while (i < this.fftDataLength) {
                this.transformedDataComplex[i].reset(this.transformedDataFft[2 * i], this.transformedDataFft[2 * i + 1]);
                ++i;
            }
            this.powerSpectrumEstimate[1][0] = Fmath.square(hold[0]) + Fmath.square(hold[1]);
            i = 1;
            while (i < this.psdNumberOfPoints) {
                this.powerSpectrumEstimate[1][i] = Fmath.square(hold[2 * i]) + Fmath.square(hold[2 * i + 1]) + Fmath.square(hold[2 * this.segmentLength - 2 * i]) + Fmath.square(hold[2 * this.segmentLength - 2 * i + 1]);
                ++i;
            }
            i = 0;
            while (i < this.psdNumberOfPoints) {
                this.powerSpectrumEstimate[1][i] = 2.0 * this.powerSpectrumEstimate[1][i] / ((double)this.fftDataLength * this.sumOfSquaredWeights);
                ++i;
            }
            i = 0;
            while (i < this.psdNumberOfPoints) {
                this.powerSpectrumEstimate[0][i] = (double)i / ((double)this.segmentLength * this.deltaT);
                ++i;
            }
        } else {
            this.powerSpectrumEstimate = this.powerSpectrumSeg();
        }
        this.powSpecDone = true;
        return this.powerSpectrumEstimate;
    }

    public double[][] powerSpectrum(String fileName) {
        if (!FourierTransform.checkPowerOfTwo(this.segmentLength)) {
            throw new IllegalArgumentException("Fast Fourier Transform segment length ," + this.segmentLength + ", is not an integer power of two");
        }
        FileInput fin = new FileInput(fileName);
        this.psdNumberOfPoints = this.segmentLength / 2;
        this.powerSpectrumEstimate = new double[2][this.psdNumberOfPoints];
        this.fftDataLength = FourierTransform.calcDataLength(this.overlap, this.segmentLength, this.segmentNumber);
        if (!this.overlap && this.segmentNumber < 2) {
            this.fftData = new double[2 * this.fftDataLength];
            int j = -1;
            int i = 0;
            while (i < this.segmentLength) {
                this.fftData[++j] = fin.readDouble();
                this.fftData[++j] = fin.readDouble();
                ++i;
            }
            this.complexData = Complex.oneDarray(this.fftDataLength);
            j = -1;
            i = 0;
            while (i < this.fftDataLength) {
                this.complexData[i].setReal(this.fftData[++j]);
                this.complexData[i].setImag(this.fftData[++j]);
                ++i;
            }
            this.fftDataWindow = new double[2 * this.fftDataLength];
            this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
            int isign = 1;
            double[] hold = new double[this.fftDataLength * 2];
            int i2 = 0;
            while (i2 < this.fftDataLength * 2) {
                hold[i2] = this.fftDataWindow[i2];
                ++i2;
            }
            this.basicFft(hold, this.fftDataLength, isign);
            i2 = 0;
            while (i2 < this.fftDataLength * 2) {
                this.transformedDataFft[i2] = hold[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < this.fftDataLength) {
                this.transformedDataComplex[i2].reset(this.transformedDataFft[2 * i2], this.transformedDataFft[2 * i2 + 1]);
                ++i2;
            }
            this.powerSpectrumEstimate[1][0] = Fmath.square(hold[0]) + Fmath.square(hold[1]);
            i2 = 1;
            while (i2 < this.psdNumberOfPoints) {
                this.powerSpectrumEstimate[1][i2] = Fmath.square(hold[2 * i2]) + Fmath.square(hold[2 * i2 + 1]) + Fmath.square(hold[2 * this.segmentLength - 2 * i2]) + Fmath.square(hold[2 * this.segmentLength - 2 * i2 + 1]);
                ++i2;
            }
            i2 = 0;
            while (i2 < this.psdNumberOfPoints) {
                this.powerSpectrumEstimate[1][i2] = 2.0 * this.powerSpectrumEstimate[1][i2] / ((double)this.fftDataLength * this.sumOfSquaredWeights);
                ++i2;
            }
            i2 = 0;
            while (i2 < this.psdNumberOfPoints) {
                this.powerSpectrumEstimate[0][i2] = (double)i2 / ((double)this.segmentLength * this.deltaT);
                ++i2;
            }
        } else {
            this.powerSpectrumEstimate = this.powerSpectrumSeg(fin);
        }
        this.powSpecDone = true;
        return this.powerSpectrumEstimate;
    }

    private double[][] powerSpectrumSeg() {
        int segmentStartIndex = 0;
        int segmentStartIncrement = this.segmentLength;
        if (this.overlap) {
            segmentStartIncrement /= 2;
        }
        double[] data2 = new double[2 * this.segmentLength];
        this.psdNumberOfPoints = this.segmentLength / 2;
        double[] segPSD = new double[this.psdNumberOfPoints];
        double[][] avePSD = new double[2][this.psdNumberOfPoints];
        int j = 0;
        while (j < this.psdNumberOfPoints) {
            avePSD[1][j] = 0.0;
            ++j;
        }
        int isign = 1;
        int i = 1;
        while (i <= this.segmentNumber) {
            int j2 = 0;
            while (j2 < 2 * this.segmentLength) {
                data2[j2] = this.fftData[segmentStartIndex + j2];
                ++j2;
            }
            if (i == 1) {
                this.sumOfSquaredWeights = this.windowData(data2, data2, this.weights);
            } else {
                int k = 0;
                int j3 = 0;
                while (j3 < this.segmentLength) {
                    data2[k] = data2[k] * this.weights[j3];
                    data2[++k] = data2[k] * this.weights[j3];
                    ++k;
                    ++j3;
                }
            }
            this.basicFft(data2, this.segmentLength, isign);
            segPSD[0] = Fmath.square(data2[0]) + Fmath.square(data2[1]);
            j2 = 1;
            while (j2 < this.psdNumberOfPoints) {
                segPSD[j2] = Fmath.square(data2[2 * j2]) + Fmath.square(data2[2 * j2 + 1]) + Fmath.square(data2[2 * this.segmentLength - 2 * j2]) + Fmath.square(data2[2 * this.segmentLength - 2 * j2 + 1]);
                ++j2;
            }
            j2 = 0;
            while (j2 < this.psdNumberOfPoints) {
                segPSD[j2] = 2.0 * segPSD[j2] / ((double)this.segmentLength * this.sumOfSquaredWeights);
                ++j2;
            }
            j2 = 0;
            while (j2 < this.psdNumberOfPoints) {
                double[] dArray = avePSD[1];
                int n = j2;
                dArray[n] = dArray[n] + segPSD[j2];
                ++j2;
            }
            segmentStartIndex += segmentStartIncrement;
            ++i;
        }
        int j4 = 0;
        while (j4 < this.psdNumberOfPoints) {
            double[] dArray = avePSD[1];
            int n = j4++;
            dArray[n] = dArray[n] / (double)this.segmentNumber;
        }
        i = 0;
        while (i < this.psdNumberOfPoints) {
            avePSD[0][i] = (double)i / ((double)this.segmentLength * this.deltaT);
            ++i;
        }
        return avePSD;
    }

    private double[][] powerSpectrumSeg(FileInput fin) {
        int j;
        int k;
        int j2;
        int i;
        int j3;
        double[] data2 = new double[2 * this.segmentLength];
        this.weights = new double[this.segmentLength];
        double[] hold = new double[2 * this.segmentLength];
        this.psdNumberOfPoints = this.segmentLength / 2;
        double[] segPSD = new double[this.psdNumberOfPoints];
        double[][] avePSD = new double[2][this.psdNumberOfPoints];
        int j4 = 0;
        while (j4 < this.psdNumberOfPoints) {
            avePSD[1][j4] = 0.0;
            ++j4;
        }
        int isign = 1;
        this.sumOfSquaredWeights = this.windowData(hold, hold, this.weights);
        if (this.overlap) {
            j3 = 0;
            while (j3 < this.segmentLength) {
                data2[j3] = fin.readDouble();
                ++j3;
            }
            i = 1;
            while (i <= this.segmentNumber) {
                j2 = 0;
                while (j2 < this.segmentLength) {
                    data2[j2 + this.segmentLength] = fin.readDouble();
                    ++j2;
                }
                k = -1;
                j = 0;
                while (j < this.segmentLength) {
                    data2[++k] = data2[k] * this.weights[j];
                    data2[++k] = data2[k] * this.weights[j];
                    ++j;
                }
                this.basicFft(data2, this.segmentLength, isign);
                segPSD[0] = Fmath.square(data2[0]) + Fmath.square(data2[1]);
                j = 1;
                while (j < this.psdNumberOfPoints) {
                    segPSD[j] = Fmath.square(data2[2 * j]) + Fmath.square(data2[2 * j + 1]) + Fmath.square(data2[2 * this.segmentLength - 2 * j]) + Fmath.square(data2[2 * this.segmentLength - 2 * j + 1]);
                    ++j;
                }
                j = 0;
                while (j < this.psdNumberOfPoints) {
                    segPSD[j] = 2.0 * segPSD[j] / ((double)this.segmentLength * this.sumOfSquaredWeights);
                    ++j;
                }
                j = 0;
                while (j < this.psdNumberOfPoints) {
                    double[] dArray = avePSD[1];
                    int n = j;
                    dArray[n] = dArray[n] + segPSD[j];
                    ++j;
                }
                j = 0;
                while (j < this.segmentLength) {
                    data2[j] = data2[j + this.segmentLength];
                    ++j;
                }
                ++i;
            }
        } else {
            i = 1;
            while (i <= this.segmentNumber) {
                j2 = 0;
                while (j2 < 2 * this.segmentLength) {
                    data2[j2] = fin.readDouble();
                    ++j2;
                }
                k = -1;
                j = 0;
                while (j < this.segmentLength) {
                    data2[++k] = data2[k] * this.weights[j];
                    data2[++k] = data2[k] * this.weights[j];
                    ++j;
                }
                this.basicFft(data2, this.segmentLength, isign);
                segPSD[0] = Fmath.square(data2[0]) + Fmath.square(data2[1]);
                j = 1;
                while (j < this.psdNumberOfPoints) {
                    segPSD[j] = Fmath.square(data2[2 * j]) + Fmath.square(data2[2 * j + 1]) + Fmath.square(data2[2 * this.segmentLength - 2 * j]) + Fmath.square(data2[2 * this.segmentLength - 2 * j + 1]);
                    ++j;
                }
                j = 1;
                while (j < this.psdNumberOfPoints) {
                    segPSD[j] = 2.0 * segPSD[j] / ((double)this.segmentLength * this.sumOfSquaredWeights);
                    ++j;
                }
                j = 0;
                while (j < this.psdNumberOfPoints) {
                    double[] dArray = avePSD[1];
                    int n = j;
                    dArray[n] = dArray[n] + segPSD[j];
                    ++j;
                }
                ++i;
            }
        }
        j3 = 0;
        while (j3 < this.psdNumberOfPoints) {
            double[] dArray = avePSD[1];
            int n = j3++;
            dArray[n] = dArray[n] / (double)this.segmentNumber;
        }
        i = 0;
        while (i < this.psdNumberOfPoints) {
            avePSD[0][i] = (double)i / ((double)this.segmentLength * this.deltaT);
            ++i;
        }
        return avePSD;
    }

    public double[][] getpowerSpectrumEstimate() {
        if (!this.powSpecDone) {
            System.out.println("getpowerSpectrumEstimate - powerSpectrum has not been called - null returned");
        }
        return this.powerSpectrumEstimate;
    }

    public int getNumberOfPsdPoints() {
        return this.psdNumberOfPoints;
    }

    public void printPowerSpectrum() {
        String filename = "FourierTransformPSD.txt";
        this.printPowerSpectrum(filename);
    }

    public void printPowerSpectrum(String filename) {
        if (!this.powSpecDone) {
            this.powerSpectrum();
        }
        FileOutput fout = new FileOutput(filename);
        fout.println("Power Spectrum Density Estimate Output File from FourierTransform");
        fout.dateAndTimeln(filename);
        String title = "Window: " + this.windowNames[this.windowOption];
        if (this.windowOption == 6) {
            title = String.valueOf(title) + ", alpha = " + this.kaiserAlpha;
        }
        if (this.windowOption == 7) {
            title = String.valueOf(title) + ", alpha = " + this.gaussianAlpha;
        }
        fout.println(title);
        fout.printtab("Number of segments = ");
        fout.println(this.segmentNumber);
        fout.printtab("Segment length = ");
        fout.println(this.segmentLength);
        if (this.segmentNumber > 1) {
            if (this.overlap) {
                fout.printtab("Segments overlap by 50%");
            } else {
                fout.printtab("Segments do not overlap");
            }
        }
        fout.println();
        this.printWarnings(fout);
        fout.printtab("Frequency");
        fout.println("Mean Square");
        fout.printtab("(cycles per");
        fout.println("Amplitude");
        if (this.deltaTset) {
            fout.printtab("unit time)");
        } else {
            fout.printtab("gridpoint)");
        }
        fout.println(" ");
        int n = this.powerSpectrumEstimate[0].length;
        int i = 0;
        while (i < n) {
            fout.printtab(Fmath.truncate(this.powerSpectrumEstimate[0][i], 4));
            fout.println(Fmath.truncate(this.powerSpectrumEstimate[1][i], 4));
            ++i;
        }
        fout.close();
    }

    public void plotPowerSpectrum(int lowPoint) {
        String graphTitle = "Estimation of Power Spectrum Density";
        this.plotPowerSpectrum(lowPoint, this.powerSpectrumEstimate[0].length - 1, graphTitle);
    }

    public void plotPowerSpectrum(int lowPoint, String graphTitle) {
        this.plotPowerSpectrum(lowPoint, this.powerSpectrumEstimate[0].length - 1, graphTitle);
    }

    public void plotPowerSpectrum(int lowPoint, int highPoint) {
        String graphTitle = "Estimation of Power Spectrum Density";
        this.plotPowerSpectrum(lowPoint, highPoint, graphTitle);
    }

    public void plotPowerSpectrum(int lowPoint, int highPoint, String graphTitle) {
        if (!this.powSpecDone) {
            System.out.println("plotPowerSpectrum - powerSpectrum has not been called - no plot displayed");
        } else {
            int n = this.powerSpectrumEstimate[0].length - 1;
            if (lowPoint < 0 || lowPoint >= n) {
                lowPoint = 0;
            }
            if (highPoint < 0 || highPoint > n) {
                highPoint = n;
            }
            this.plotPowerSpectrumLinear(lowPoint, highPoint, graphTitle);
        }
    }

    public void plotPowerSpectrum(double lowFreq) {
        String graphTitle = "Estimation of Power Spectrum Density";
        this.plotPowerSpectrum(lowFreq, graphTitle);
    }

    public void plotPowerSpectrum(double lowFreq, String graphTitle) {
        if (!this.powSpecDone) {
            this.powerSpectrum();
        }
        double highFreq = this.powerSpectrumEstimate[1][this.powerSpectrumEstimate[0].length - 1];
        this.plotPowerSpectrum(lowFreq, highFreq, graphTitle);
    }

    public void plotPowerSpectrum(double lowFreq, double highFreq) {
        if (!this.powSpecDone) {
            System.out.println("plotPowerSpectrum - powerSpectrum has not been called - no plot displayed");
        } else {
            String graphTitle = "Estimation of Power Spectrum Density";
            this.plotPowerSpectrum(lowFreq, highFreq, graphTitle);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void plotPowerSpectrum(double lowFreq, double highFreq, String graphTitle) {
        block7: {
            block9: {
                block8: {
                    block6: {
                        if (this.powSpecDone) break block6;
                        System.out.println("plotPowerSpectrum - powerSpectrum has not been called - no plot displayed");
                        break block7;
                    }
                    low = 0;
                    high = 0;
                    if (this.deltaTset) break block8;
                    System.out.println("plotPowerSpectrum - deltaT has not been set");
                    System.out.println("full spectrum plotted");
                    break block7;
                }
                ii = 0;
                n = this.powerSpectrumEstimate[0].length - 1;
                test = true;
                if (lowFreq != -1.0) ** GOTO lbl28
                low = 1;
                break block9;
lbl-1000:
                // 1 sources

                {
                    if (this.powerSpectrumEstimate[0][ii] > lowFreq) {
                        low = ii - 1;
                        if (low < 0) {
                            low = 0;
                        }
                        test = false;
                        continue;
                    }
                    if (++ii < n) continue;
                    low = 0;
                    System.out.println("plotPowerSpectrum - lowFreq out of range -  reset to zero");
                    test = false;
lbl28:
                    // 4 sources

                    ** while (test)
                }
            }
            test = true;
            ii = 0;
            while (test) {
                if (this.powerSpectrumEstimate[0][ii] > highFreq) {
                    high = ii - 1;
                    if (high < 0) {
                        System.out.println("plotPowerSpectrum - highFreq out of range -  reset to highest value");
                        high = n;
                    }
                    test = false;
                    continue;
                }
                if (++ii < n) continue;
                high = n;
                System.out.println("plotPowerSpectrum - highFreq out of range -  reset to highest value");
                test = false;
            }
            this.plotPowerSpectrumLinear(low, high, graphTitle);
        }
    }

    public void plotPowerSpectrum() {
        if (!this.powSpecDone) {
            this.powerSpectrum();
        }
        String graphTitle = "Estimation of Power Spectrum Density";
        this.plotPowerSpectrumLinear(0, this.powerSpectrumEstimate[0].length - 1, graphTitle);
    }

    public void plotPowerSpectrum(String graphTitle) {
        if (!this.powSpecDone) {
            this.powerSpectrum();
        }
        this.plotPowerSpectrumLinear(0, this.powerSpectrumEstimate[0].length - 1, graphTitle);
    }

    private void plotPowerSpectrumLinear(int low, int high, String graphTitle) {
        int nData = this.powerSpectrumEstimate[0].length;
        int nNew = high - low + 1;
        double[][] spectrum = new double[2][nNew];
        int i = 0;
        while (i < nNew) {
            spectrum[0][i] = this.powerSpectrumEstimate[0][i + low];
            spectrum[1][i] = this.powerSpectrumEstimate[1][i + low];
            ++i;
        }
        String yLegend = "Mean Square Amplitude";
        this.plotPowerDisplay(spectrum, low, high, graphTitle, yLegend);
    }

    public void plotPowerLog(int lowPoint) {
        String graphTitle = "Estimation of Power Spectrum Density";
        this.plotPowerLog(lowPoint, this.powerSpectrumEstimate[0].length - 1, graphTitle);
    }

    public void plotPowerLog(int lowPoint, String graphTitle) {
        this.plotPowerLog(lowPoint, this.powerSpectrumEstimate[0].length - 1, graphTitle);
    }

    public void plotPowerLog(int lowPoint, int highPoint) {
        String graphTitle = "Estimation of Power Spectrum Density";
        this.plotPowerLog(lowPoint, highPoint, graphTitle);
    }

    public void plotPowerLog(int lowPoint, int highPoint, String graphTitle) {
        if (!this.powSpecDone) {
            this.powerSpectrum();
        }
        int n = this.powerSpectrumEstimate[0].length - 1;
        if (lowPoint < 0 || lowPoint >= n) {
            lowPoint = 0;
        }
        if (highPoint < 0 || highPoint > n) {
            highPoint = n;
        }
        this.plotPowerSpectrumLog(lowPoint, highPoint, graphTitle);
    }

    public void plotPowerLog(double lowFreq) {
        String graphTitle = "Estimation of Power Spectrum Density";
        this.plotPowerLog(lowFreq, graphTitle);
    }

    public void plotPowerLog(double lowFreq, String graphTitle) {
        if (!this.powSpecDone) {
            this.powerSpectrum();
        }
        double highFreq = this.powerSpectrumEstimate[1][this.powerSpectrumEstimate[0].length - 1];
        this.plotPowerLog(lowFreq, highFreq, graphTitle);
    }

    public void plotPowerLog(double lowFreq, double highFreq) {
        if (!this.powSpecDone) {
            this.powerSpectrum();
        }
        String graphTitle = "Estimation of Power Spectrum Density";
        this.plotPowerLog(lowFreq, highFreq, graphTitle);
    }

    /*
     * Unable to fully structure code
     */
    public void plotPowerLog(double lowFreq, double highFreq, String graphTitle) {
        block8: {
            block9: {
                block7: {
                    if (!this.powSpecDone) {
                        this.powerSpectrum();
                    }
                    low = 0;
                    high = 0;
                    if (this.deltaTset) break block7;
                    System.out.println("plotPowerLog - deltaT has not been set");
                    System.out.println("full spectrum plotted");
                    break block8;
                }
                ii = 0;
                n = this.powerSpectrumEstimate[0].length - 1;
                test = true;
                if (lowFreq != -1.0) ** GOTO lbl27
                low = 1;
                break block9;
lbl-1000:
                // 1 sources

                {
                    if (this.powerSpectrumEstimate[0][ii] > lowFreq) {
                        low = ii - 1;
                        if (low < 0) {
                            low = 0;
                        }
                        test = false;
                        continue;
                    }
                    if (++ii < n) continue;
                    low = 0;
                    System.out.println("plotPowerLog - lowFreq out of range -  reset to zero");
                    test = false;
lbl27:
                    // 4 sources

                    ** while (test)
                }
            }
            test = true;
            ii = 0;
            while (test) {
                if (this.powerSpectrumEstimate[0][ii] > highFreq) {
                    high = ii - 1;
                    if (high < 0) {
                        System.out.println("plotPowerLog - highFreq out of range -  reset to highest value");
                        high = n;
                    }
                    test = false;
                    continue;
                }
                if (++ii < n) continue;
                high = n;
                System.out.println("plotPowerSpectrum - highFreq out of range -  reset to highest value");
                test = false;
            }
            this.plotPowerSpectrumLog(low, high, graphTitle);
        }
    }

    public void plotPowerLog() {
        if (!this.powSpecDone) {
            this.powerSpectrum();
        }
        String graphTitle = "Estimation of Power Spectrum Density";
        this.plotPowerSpectrumLog(0, this.powerSpectrumEstimate[0].length - 1, graphTitle);
    }

    public void plotPowerLog(String graphTitle) {
        if (!this.powSpecDone) {
            this.powerSpectrum();
        }
        this.plotPowerSpectrumLog(0, this.powerSpectrumEstimate[0].length - 1, graphTitle);
    }

    private void plotPowerSpectrumLog(int low, int high, String graphTitle) {
        int nData = this.powerSpectrumEstimate[0].length;
        int nNew = high - low + 1;
        double[][] spectrum = new double[2][nNew];
        int i = 0;
        while (i < nNew) {
            spectrum[0][i] = this.powerSpectrumEstimate[0][i + low];
            spectrum[1][i] = this.powerSpectrumEstimate[1][i + low];
            ++i;
        }
        boolean test2 = true;
        int ii = 0;
        double minimum = 0.0;
        while (test2) {
            if (spectrum[1][ii] > 0.0) {
                minimum = spectrum[1][ii];
                test2 = false;
                continue;
            }
            if (++ii < nNew) continue;
            test2 = false;
            System.out.println("plotPowerSpectrumLog:  no non-zero amplitudes");
            System.exit(0);
        }
        int i2 = ii + 1;
        while (i2 < nNew) {
            if (spectrum[1][i2] < minimum) {
                minimum = spectrum[1][i2];
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < nNew) {
            if (spectrum[1][i2] <= 0.0) {
                spectrum[1][i2] = minimum;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < nNew) {
            spectrum[1][i2] = Fmath.log10(spectrum[1][i2]);
            ++i2;
        }
        String yLegend = "Log10(Mean Square Amplitude)";
        this.plotPowerDisplay(spectrum, low, high, graphTitle, yLegend);
    }

    private void plotPowerDisplay(double[][] spectrum, int low, int high, String graphTitle, String yLegend) {
        PlotGraph pg = new PlotGraph(spectrum);
        graphTitle = String.valueOf(graphTitle) + "  [plot between points " + low + " and " + high + "]";
        pg.setGraphTitle(graphTitle);
        String graphTitle2 = "Window: " + this.windowNames[this.windowOption];
        if (this.windowOption == 6) {
            graphTitle2 = String.valueOf(graphTitle2) + " - alpha = " + this.kaiserAlpha;
        }
        if (this.windowOption == 7) {
            graphTitle2 = String.valueOf(graphTitle2) + " - alpha = " + this.gaussianAlpha;
        }
        graphTitle2 = String.valueOf(graphTitle2) + ", " + this.segmentNumber + " segment/s of length " + this.segmentLength;
        if (this.segmentNumber > 1) {
            graphTitle2 = this.overlap ? String.valueOf(graphTitle2) + ", segments overlap by 50%" : String.valueOf(graphTitle2) + ", segments do not overlap";
        }
        pg.setGraphTitle2(graphTitle2);
        pg.setXaxisLegend("Frequency");
        if (this.deltaTset) {
            pg.setXaxisUnitsName("cycles per unit time");
        } else {
            pg.setXaxisUnitsName("cycles per grid point");
        }
        pg.setYaxisLegend(yLegend);
        switch (this.plotLineOption) {
            case 0: {
                pg.setLine(3);
                break;
            }
            case 1: {
                pg.setLine(1);
                break;
            }
            case 2: {
                pg.setLine(2);
                break;
            }
            default: {
                pg.setLine(3);
            }
        }
        switch (this.plotPointOption) {
            case 0: {
                pg.setPoint(0);
                break;
            }
            case 1: {
                pg.setPoint(4);
                break;
            }
            default: {
                pg.setPoint(0);
            }
        }
        pg.plot();
    }

    public void setPlotLineOption(int lineOpt) {
        this.plotLineOption = lineOpt;
    }

    public int getPlotLineOption() {
        return this.plotLineOption;
    }

    public void setPlotPointOption(int pointOpt) {
        this.plotPointOption = pointOpt;
    }

    public int getPlotPointOption() {
        return this.plotPointOption;
    }

    public double[][] correlate(double[] data2) {
        int nLen = data2.length;
        if (!this.fftDataSet) {
            throw new IllegalArgumentException("No data has been previously entered");
        }
        if (nLen != this.originalDataLength) {
            throw new IllegalArgumentException("The two data sets to be correlated are of different length");
        }
        if (!FourierTransform.checkPowerOfTwo(nLen)) {
            throw new IllegalArgumentException("The length of the correlation data sets is not equal to an integer power of two");
        }
        this.complexCorr = Complex.oneDarray(nLen);
        int i = 0;
        while (i < nLen) {
            this.complexCorr[i].setReal(data2[i]);
            this.complexCorr[i].setImag(0.0);
            ++i;
        }
        this.fftCorr = new double[2 * nLen];
        int j = -1;
        int i2 = 0;
        while (i2 < nLen) {
            this.fftCorr[++j] = data2[i2];
            this.fftCorr[++j] = 0.0;
            ++i2;
        }
        return this.correlation(nLen);
    }

    public double[][] correlate(double[] data1, double[] data2) {
        int nLen = data1.length;
        int nLen2 = data2.length;
        if (nLen != nLen2) {
            throw new IllegalArgumentException("The two data sets to be correlated are of different length");
        }
        if (!FourierTransform.checkPowerOfTwo(nLen)) {
            throw new IllegalArgumentException("The length of the correlation data sets is not equal to an integer power of two");
        }
        this.fftDataLength = nLen;
        this.complexData = Complex.oneDarray(this.fftDataLength);
        int i = 0;
        while (i < this.fftDataLength) {
            this.complexData[i].setReal(data1[i]);
            this.complexData[i].setImag(0.0);
            ++i;
        }
        this.fftData = new double[2 * this.fftDataLength];
        int j = 0;
        int i2 = 0;
        while (i2 < this.fftDataLength) {
            this.fftData[j] = data1[i2];
            this.fftData[++j] = 0.0;
            ++j;
            ++i2;
        }
        this.fftDataSet = true;
        this.fftDataWindow = new double[2 * this.fftDataLength];
        this.weights = new double[this.fftDataLength];
        this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
        this.transformedDataFft = new double[2 * this.fftDataLength];
        this.transformedDataComplex = Complex.oneDarray(this.fftDataLength);
        this.complexCorr = Complex.oneDarray(nLen);
        i2 = 0;
        while (i2 < nLen) {
            this.complexCorr[i2].setReal(data2[i2]);
            this.complexCorr[i2].setImag(0.0);
            ++i2;
        }
        this.fftCorr = new double[2 * nLen];
        j = -1;
        i2 = 0;
        while (i2 < nLen) {
            this.fftCorr[++j] = data2[i2];
            this.fftCorr[++j] = 0.0;
            ++i2;
        }
        return this.correlation(nLen);
    }

    private double[][] correlation(int nLen) {
        this.fftDataWindow = new double[2 * nLen];
        this.fftCorrWindow = new double[2 * nLen];
        this.weights = new double[nLen];
        this.sumOfSquaredWeights = this.windowData(this.fftData, this.fftDataWindow, this.weights);
        this.windowData(this.fftCorr, this.fftCorrWindow, this.weights);
        int isign = 1;
        double[] hold1 = new double[2 * nLen];
        int i = 0;
        while (i < nLen * 2) {
            hold1[i] = this.fftDataWindow[i];
            ++i;
        }
        this.basicFft(hold1, nLen, isign);
        isign = 1;
        double[] hold2 = new double[2 * nLen];
        int i2 = 0;
        while (i2 < nLen * 2) {
            hold2[i2] = this.fftCorrWindow[i2];
            ++i2;
        }
        this.basicFft(hold2, nLen, isign);
        double[] hold3 = new double[2 * nLen];
        int j = 0;
        int i3 = 0;
        while (i3 < nLen) {
            hold3[j] = (hold1[j] * hold2[j] + hold1[j + 1] * hold2[j + 1]) / (double)nLen;
            hold3[j + 1] = (-hold1[j] * hold2[j + 1] + hold1[j + 1] * hold2[j]) / (double)nLen;
            j += 2;
            ++i3;
        }
        isign = -1;
        this.basicFft(hold3, nLen, isign);
        i3 = 0;
        while (i3 < 2 * nLen) {
            this.transformedDataFft[i3] = hold3[i3];
            ++i3;
        }
        this.correlationArray = new double[2][nLen];
        j = 0;
        int k = nLen;
        int i4 = nLen / 2 + 1;
        while (i4 < nLen) {
            this.correlationArray[1][j] = hold3[k] / (double)nLen;
            ++j;
            k += 2;
            ++i4;
        }
        k = 0;
        i4 = 0;
        while (i4 < nLen / 2) {
            this.correlationArray[1][j] = hold3[k] / (double)nLen;
            ++j;
            k += 2;
            ++i4;
        }
        this.correlationArray[0][0] = -((double)(nLen / 2)) * this.deltaT;
        i4 = 1;
        while (i4 < nLen) {
            this.correlationArray[0][i4] = this.correlationArray[0][i4 - 1] + this.deltaT;
            ++i4;
        }
        this.correlateDone = true;
        return this.correlationArray;
    }

    public double[][] getCorrelation() {
        if (!this.correlateDone) {
            System.out.println("getCorrelation - correlation has not been called - no correlation returned");
        }
        return this.correlationArray;
    }

    public void printCorrelation() {
        String filename = "Correlation.txt";
        this.printCorrelation(filename);
    }

    public void printCorrelation(String filename) {
        if (!this.correlateDone) {
            System.out.println("printCorrelation - correlate has not been called - no file printed");
        } else {
            FileOutput fout = new FileOutput(filename);
            fout.println("Correlation Output File from FourierTransform");
            fout.dateAndTimeln(filename);
            String title = "Window: " + this.windowNames[this.windowOption];
            if (this.windowOption == 6) {
                title = String.valueOf(title) + ", alpha = " + this.kaiserAlpha;
            }
            if (this.windowOption == 7) {
                title = String.valueOf(title) + ", alpha = " + this.gaussianAlpha;
            }
            fout.println(title);
            fout.printtab("Data length = ");
            fout.println(this.fftDataLength);
            fout.println();
            fout.printtab("Time lag");
            fout.println("Correlation");
            if (this.deltaTset) {
                fout.printtab("/unit time");
            } else {
                fout.printtab("/grid interval)");
            }
            fout.println("Coefficient");
            int n = this.correlationArray[0].length;
            int i = 0;
            while (i < n) {
                fout.printtab(Fmath.truncate(this.correlationArray[0][i], 4));
                fout.println(Fmath.truncate(this.correlationArray[1][i], 4));
                ++i;
            }
            fout.close();
        }
    }

    public void plotCorrelation() {
        if (!this.correlateDone) {
            System.out.println("plotCorrelation - correlation has not been called - no plot displayed");
        } else {
            String graphTitle = "Correlation Plot";
            this.plotCorrelation(graphTitle);
        }
    }

    public void plotCorrelation(String graphTitle) {
        if (!this.correlateDone) {
            System.out.println("plotCorrelation - correlate has not been called - no plot displayed");
        } else {
            PlotGraph pg = new PlotGraph(this.correlationArray);
            pg.setGraphTitle(graphTitle);
            String graphTitle2 = "Window: " + this.windowNames[this.windowOption];
            if (this.windowOption == 6) {
                graphTitle2 = String.valueOf(graphTitle2) + " - alpha = " + this.kaiserAlpha;
            }
            if (this.windowOption == 7) {
                graphTitle2 = String.valueOf(graphTitle2) + " - alpha = " + this.gaussianAlpha;
            }
            pg.setGraphTitle2(graphTitle2);
            pg.setXaxisLegend("Correlation Lag");
            if (this.deltaTset) {
                pg.setXaxisUnitsName("unit time");
            } else {
                pg.setXaxisUnitsName("grid interval");
            }
            pg.setYaxisLegend("Correlation coefficient");
            switch (this.plotLineOption) {
                case 0: {
                    pg.setLine(3);
                    break;
                }
                case 1: {
                    pg.setLine(1);
                    break;
                }
                case 2: {
                    pg.setLine(2);
                    break;
                }
                default: {
                    pg.setLine(3);
                }
            }
            switch (this.plotPointOption) {
                case 0: {
                    pg.setPoint(0);
                    break;
                }
                case 1: {
                    pg.setPoint(4);
                    break;
                }
                default: {
                    pg.setPoint(0);
                }
            }
            pg.plot();
        }
    }

    public double[][] shortTime(double windowTime) {
        int windowLength = (int)Math.round(windowTime / this.deltaT);
        if (!FourierTransform.checkPowerOfTwo(windowLength)) {
            int high;
            int low = FourierTransform.lastPowerOfTwo(windowLength);
            if (windowLength - low <= (high = FourierTransform.nextPowerOfTwo(windowLength)) - windowLength) {
                windowLength = low;
                if (low == 0) {
                    windowLength = high;
                }
            } else {
                windowLength = high;
            }
            System.out.println("Method - shortTime");
            System.out.println("Window length, provided as time, " + windowTime + ", did not convert to an integer power of two data points");
            System.out.println("A value of " + (double)(windowLength - 1) * this.deltaT + " was substituted");
        }
        return this.shortTime(windowLength);
    }

    public double[][] shortTime(int windowLength) {
        if (!FourierTransform.checkPowerOfTwo(windowLength)) {
            throw new IllegalArgumentException("Moving window data length ," + windowLength + ", is not an integer power of two");
        }
        if (!this.fftDataSet) {
            throw new IllegalArgumentException("No data has been entered for the Fast Fourier Transform");
        }
        if (windowLength > this.originalDataLength) {
            throw new IllegalArgumentException("The window length, " + windowLength + ", is greater than the data length, " + this.originalDataLength + ".");
        }
        if (this.windowOption == 0) {
            this.setGaussian();
        }
        this.numShortTimes = this.originalDataLength - windowLength + 1;
        this.numShortFreq = windowLength / 2;
        this.timeFrequency = new double[this.numShortFreq + 1][this.numShortTimes + 1];
        this.timeFrequency[0][0] = 0.0;
        this.timeFrequency[0][1] = (double)(windowLength - 1) * this.deltaT / 2.0;
        int i = 2;
        while (i <= this.numShortTimes) {
            this.timeFrequency[0][i] = this.timeFrequency[0][i - 1] + this.deltaT;
            ++i;
        }
        i = 0;
        while (i < this.numShortFreq) {
            this.timeFrequency[i + 1][0] = (double)i / ((double)windowLength * this.deltaT);
            ++i;
        }
        this.segmentLength = windowLength;
        int windowStartIndex = 0;
        double[] data2 = new double[2 * windowLength];
        double[] winPSD = new double[this.numShortFreq];
        int isign = 1;
        int i2 = 1;
        while (i2 <= this.numShortTimes) {
            int j = 0;
            while (j < 2 * windowLength) {
                data2[j] = this.fftData[windowStartIndex + j];
                ++j;
            }
            if (i2 == 1) {
                this.sumOfSquaredWeights = this.windowData(data2, data2, this.weights);
            } else {
                int k = 0;
                int j2 = 0;
                while (j2 < this.segmentLength) {
                    data2[k] = data2[k] * this.weights[j2];
                    data2[++k] = data2[k] * this.weights[j2];
                    ++k;
                    ++j2;
                }
            }
            this.basicFft(data2, windowLength, isign);
            winPSD[0] = Fmath.square(data2[0]) + Fmath.square(data2[1]);
            j = 1;
            while (j < this.numShortFreq) {
                winPSD[j] = Fmath.square(data2[2 * j]) + Fmath.square(data2[2 * j + 1]) + Fmath.square(data2[2 * windowLength - 2 * j]) + Fmath.square(data2[2 * windowLength - 2 * j + 1]);
                ++j;
            }
            j = 0;
            while (j < this.numShortFreq) {
                this.timeFrequency[j + 1][i2] = 2.0 * winPSD[j] / ((double)windowLength * this.sumOfSquaredWeights);
                ++j;
            }
            windowStartIndex += 2;
            ++i2;
        }
        this.shortTimeDone = true;
        return this.timeFrequency;
    }

    public double[][] getTimeFrequencyMatrix() {
        if (!this.shortTimeDone) {
            throw new IllegalArgumentException("No short time Fourier transform has been performed");
        }
        return this.timeFrequency;
    }

    public int getShortTimeNumberOfTimes() {
        if (!this.shortTimeDone) {
            throw new IllegalArgumentException("No short time Fourier transform has been performed");
        }
        return this.numShortTimes;
    }

    public int getShortTimeNumberOfFrequencies() {
        if (!this.shortTimeDone) {
            throw new IllegalArgumentException("No short time Fourier transform has been performed");
        }
        return this.numShortFreq;
    }

    public int getShortTimeWindowLength() {
        if (!this.shortTimeDone) {
            throw new IllegalArgumentException("No short time Fourier transform has been performed");
        }
        return this.segmentLength;
    }

    public void printShortTime() {
        String filename = "ShortTime.txt";
        this.printShortTime(filename);
    }

    public void printShortTime(String filename) {
        if (!this.shortTimeDone) {
            System.out.println("printShortTime- shortTime has not been called - no file printed");
        } else {
            FileOutput fout = new FileOutput(filename);
            fout.println("Short Time Fourier Transform Output File from FourierTransform");
            fout.dateAndTimeln(filename);
            String title = "Window: " + this.windowNames[this.windowOption];
            if (this.windowOption == 6) {
                title = String.valueOf(title) + ", alpha = " + this.kaiserAlpha;
            }
            if (this.windowOption == 7) {
                title = String.valueOf(title) + ", alpha = " + this.gaussianAlpha;
            }
            fout.println(title);
            fout.printtab("Data length = ");
            fout.println(this.originalDataLength);
            fout.printtab("Delta T = ");
            fout.println(this.deltaT);
            fout.printtab("Window length (points) = ");
            fout.println(this.segmentLength);
            fout.printtab("Window length (time units) = ");
            fout.println((double)(this.segmentLength - 1) * this.deltaT);
            fout.printtab("Number of frequency points = ");
            fout.println(this.numShortFreq);
            fout.printtab("Number of time points = ");
            fout.println(this.numShortTimes);
            boolean checkAve = false;
            int newTp = this.numShortTimes;
            int maxN = 100;
            int nAve = this.numShortTimes / maxN;
            int nLast = this.numShortTimes % maxN;
            if (this.numShortTimes > 127) {
                checkAve = true;
                if (nLast > 0) {
                    newTp = maxN;
                    nLast = this.numShortTimes - ++nAve * (newTp - 1);
                } else {
                    newTp = maxN;
                    nLast = nAve;
                }
                if (nLast != nAve) {
                    fout.println("In the output below, each of the first " + (newTp - 2) + " magnitude points, along the time axis, is the average of " + nAve + " calculated points");
                    fout.println("The last point is the average of " + nLast + " calculated points");
                } else {
                    fout.println("In the output below, each magnitude point is the average of " + nAve + " calculated points");
                }
                fout.println("The data, without averaging, may be accessed using the method getTimeFrequencyMatrix()");
            }
            fout.println();
            fout.println("first row = times");
            fout.println("first column = frequencies");
            fout.println("all other cells = mean square amplitudes at the corresponding time and frequency");
            if (checkAve) {
                double sum2 = 0.0;
                int start = 1;
                int workingAve = nAve;
                int i = 0;
                while (i <= this.numShortFreq) {
                    fout.printtab(Fmath.truncate(this.timeFrequency[i][0], 4));
                    start = 1;
                    int j = 1;
                    while (j <= newTp) {
                        workingAve = nAve;
                        if (j == newTp) {
                            workingAve = nLast;
                        }
                        sum2 = 0.0;
                        int k = start;
                        while (k <= start + workingAve - 1) {
                            sum2 += this.timeFrequency[i][k];
                            ++k;
                        }
                        fout.printtab(Fmath.truncate(sum2 /= (double)workingAve, 4));
                        start += workingAve;
                        ++j;
                    }
                    fout.println();
                    ++i;
                }
            } else {
                int i = 0;
                while (i <= this.numShortFreq) {
                    int j = 0;
                    while (j <= newTp) {
                        fout.printtab(Fmath.truncate(this.timeFrequency[i][j], 4));
                        ++j;
                    }
                    fout.println();
                    ++i;
                }
            }
            fout.close();
        }
    }

    @Override
    public void paint(Graphics g) {
        this.graph(g);
    }

    public void plotShortTime(String title) {
        this.shortTitle = title;
        this.plotShortTime();
    }

    public void plotShortTime() {
        JFrame window = new JFrame("Michael T Flanagan's plotting program - FourierTransform.plotShortTime");
        this.setSize(800, 600);
        window.getContentPane().setBackground(Color.white);
        window.setDefaultCloseOperation(3);
        window.getContentPane().add("Center", this);
        window.pack();
        window.setResizable(true);
        window.toFront();
        window.setVisible(true);
    }

    public void graph(Graphics g) {
        double max2;
        int j;
        int i;
        int j2;
        int xLen = 512;
        int yLen = 256;
        int yTop = 100;
        int xBot = 100;
        int numBands = 18;
        Color[] color = new Color[numBands + 1];
        color[18] = Color.black;
        color[17] = Color.darkGray;
        color[16] = Color.gray;
        color[15] = Color.lightGray;
        color[14] = Color.red.darker();
        color[13] = Color.red;
        color[12] = Color.magenta.darker();
        color[11] = Color.magenta;
        color[10] = Color.pink;
        color[9] = Color.pink.darker();
        color[8] = Color.orange.darker();
        color[7] = Color.orange;
        color[6] = Color.yellow;
        color[5] = Color.green;
        color[4] = Color.green.darker();
        color[3] = Color.cyan;
        color[2] = Color.cyan.darker();
        color[1] = Color.blue;
        color[0] = Color.blue.darker();
        int pixelsPerXpoint = 0;
        int xTp = 0;
        int xAve = 0;
        int xLast = 0;
        boolean xCheck = true;
        if (this.numShortTimes <= xLen) {
            pixelsPerXpoint = xLen / this.numShortTimes;
            xLen = pixelsPerXpoint * this.numShortTimes;
            xTp = this.numShortTimes;
        } else {
            xCheck = false;
            pixelsPerXpoint = 1;
            xTp = this.numShortTimes;
            xAve = this.numShortTimes / xLen;
            xLast = this.numShortTimes % xLen;
            if (xLast > 0) {
                xTp = this.numShortTimes / ++xAve + 1;
                xLast = this.numShortTimes - xAve * (xTp - 1);
            } else {
                xTp = this.numShortTimes / xAve;
                xLast = xAve;
            }
            xLen = xTp;
        }
        int pixelsPerYpoint = 0;
        int yTp = 0;
        int yAve = 0;
        int yLast = 0;
        boolean yCheck = true;
        if (this.numShortFreq <= yLen) {
            pixelsPerYpoint = yLen / this.numShortFreq;
            yLen = pixelsPerYpoint * this.numShortFreq;
            yTp = this.numShortFreq;
        } else {
            yCheck = false;
            pixelsPerYpoint = 1;
            yTp = this.numShortFreq;
            yAve = this.numShortFreq / yLen;
            yLast = this.numShortFreq % yLen;
            if (yLast > 0) {
                yTp = this.numShortFreq / ++yAve + 1;
                yLast = this.numShortFreq - yAve * (yTp - 1);
            } else {
                yTp = this.numShortFreq / yAve;
                yLast = yAve;
            }
            yLen = yTp;
        }
        int yBot = yTop + yLen;
        int xTop = xBot + xLen;
        double[][] averages = new double[yTp][xTp];
        int[][] pixels = new int[yTp][xTp];
        double[] times2 = new double[xTp];
        int[] timesPixels = new int[xTp];
        double[] freqs = new double[yTp];
        int[] freqPixels = new int[yTp];
        double[][] hold = new double[this.numShortFreq][xTp];
        if (xCheck) {
            int i2 = 0;
            while (i2 <= this.numShortFreq) {
                j2 = 1;
                while (j2 <= this.numShortTimes) {
                    if (i2 == 0) {
                        times2[j2 - 1] = this.timeFrequency[0][j2];
                    } else {
                        hold[i2 - 1][j2 - 1] = this.timeFrequency[i2][j2];
                    }
                    ++j2;
                }
                ++i2;
            }
        } else {
            double sum2 = 0.0;
            int start = 1;
            int workingAve = xAve;
            i = 0;
            while (i <= this.numShortFreq) {
                start = 1;
                j = 1;
                while (j <= xTp) {
                    workingAve = xAve;
                    if (j == xTp) {
                        workingAve = xLast;
                    }
                    sum2 = 0.0;
                    int k = start;
                    while (k <= start + workingAve - 1) {
                        sum2 += this.timeFrequency[i][k];
                        ++k;
                    }
                    if (i == 0) {
                        times2[j - 1] = sum2 / (double)workingAve;
                    } else {
                        hold[i - 1][j - 1] = sum2 / (double)workingAve;
                    }
                    start += workingAve;
                    ++j;
                }
                ++i;
            }
        }
        if (yCheck) {
            int i3 = 0;
            while (i3 < this.numShortFreq) {
                freqs[i3] = this.timeFrequency[i3 + 1][0];
                j2 = 0;
                while (j2 < xTp) {
                    averages[i3][j2] = hold[i3][j2];
                    ++j2;
                }
                ++i3;
            }
        } else {
            double sum3 = 0.0;
            double sFreq = 0.0;
            int start = 0;
            int workingAve = yAve;
            int i4 = 0;
            while (i4 < xTp) {
                start = 0;
                int j3 = 0;
                while (j3 < yTp) {
                    workingAve = yAve;
                    if (j3 == yTp - 1) {
                        workingAve = yLast;
                    }
                    sum3 = 0.0;
                    sFreq = 0.0;
                    int k = start;
                    while (k <= start + workingAve - 1) {
                        sum3 += hold[k][i4];
                        sFreq += this.timeFrequency[k + 1][0];
                        ++k;
                    }
                    averages[j3][i4] = sum3;
                    freqs[j3] = sFreq / (double)workingAve;
                    start += workingAve;
                    ++j3;
                }
                ++i4;
            }
        }
        double min2 = max2 = averages[0][0];
        i = 0;
        while (i < yTp) {
            j = 0;
            while (j < xTp) {
                if (averages[i][j] > max2) {
                    max2 = averages[i][j];
                }
                if (averages[i][j] < min2) {
                    min2 = averages[i][j];
                }
                ++j;
            }
            ++i;
        }
        double bandZero = 0.0;
        if (min2 > 0.1 * max2) {
            bandZero = 0.99 * min2;
        }
        double bandWidth = (1.01 * max2 - 0.99 * min2) / (double)numBands;
        double[] band = new double[numBands];
        band[0] = bandZero + bandWidth;
        int i5 = 1;
        while (i5 < numBands) {
            band[i5] = band[i5 - 1] + bandWidth;
            ++i5;
        }
        boolean test2 = true;
        int i6 = 0;
        while (i6 < yTp) {
            int j4 = 0;
            while (j4 < xTp) {
                test2 = true;
                int k = 0;
                while (test2) {
                    if (averages[i6][j4] <= band[k]) {
                        pixels[i6][j4] = k;
                        test2 = false;
                        continue;
                    }
                    ++k;
                }
                ++j4;
            }
            ++i6;
        }
        int yPixels = 0;
        int xPixels = 0;
        int yInner = 0;
        int xInner = 0;
        int xx = xBot;
        int yy = yTop;
        int i7 = 0;
        while (i7 < yTp) {
            int j5 = 0;
            while (j5 < xTp) {
                yInner = 0;
                int k = 0;
                while (k < pixelsPerYpoint) {
                    xInner = 0;
                    int l = 0;
                    while (l < pixelsPerXpoint) {
                        g.setColor(color[pixels[i7][j5]]);
                        xx = xBot + (xPixels + xInner);
                        yy = yBot - (yPixels + yInner);
                        g.drawLine(xx, yy, xx, yy);
                        ++xInner;
                        ++l;
                    }
                    ++yInner;
                    ++k;
                }
                xPixels += xInner;
                ++j5;
            }
            yPixels += yInner;
            xPixels = 0;
            ++i7;
        }
        g.setColor(color[numBands]);
        g.drawLine(xBot, yBot, xBot, yTop);
        g.drawLine(xTop, yBot, xTop, yTop);
        g.drawLine(xBot, yBot, xTop, yBot);
        g.drawLine(xBot, yTop, xTop, yTop);
        int yInc = yLen / 4;
        int yScale = this.numShortFreq / 4;
        double yUnits = (double)yInc * (freqs[1] - freqs[0]) / (double)(pixelsPerYpoint * yScale);
        String[] yArray = new String[5];
        int yArr = 0;
        yArray[0] = "0  ";
        int i8 = 1;
        while (i8 < 5) {
            yArray[i8] = String.valueOf(yArr += yScale) + "  ";
            ++i8;
        }
        xx = xBot;
        yy = yBot;
        int yWord = 6 * (yArray[4].length() + 1);
        int i9 = 0;
        while (i9 < 5) {
            g.drawLine(xx - 5, yy, xx, yy);
            g.drawString(yArray[i9], xx - yWord, yy + 4);
            yy -= yInc;
            ++i9;
        }
        int xInc = xLen / 8;
        int xScale = this.numShortTimes / 8;
        double xUnits = (double)xInc * (times2[1] - times2[0]) / (double)(pixelsPerXpoint * xScale);
        String[] xArray = new String[9];
        int xArr = 0;
        xArray[0] = "0 ";
        int i10 = 1;
        while (i10 < 9) {
            xArray[i10] = String.valueOf(xArr += xScale) + " ";
            ++i10;
        }
        xx = xBot;
        yy = yBot;
        i10 = 0;
        while (i10 < 9) {
            g.drawLine(xx, yy, xx, yy + 5);
            g.drawString(xArray[i10], xx - 4, yy + 20);
            xx += xInc;
            ++i10;
        }
        g.drawString("Short Time Fourier Transfer Time-Frequency Plot", xBot - 80, yTop - 80);
        g.drawString(this.shortTitle, xBot - 80, yTop - 60);
        String yAxis = "Frequency / (" + Fmath.truncate(yUnits, 3) + " cycles per time unit)";
        g.drawString(yAxis, xBot - 60, yTop - 20);
        String xAxis = "Time / (" + Fmath.truncate(xUnits, 3) + " time units)";
        g.drawString(xAxis, xBot, yBot + 40);
        String totalTime = "Total time = " + Fmath.truncate((double)xLen * (times2[1] - times2[0]) / (double)pixelsPerXpoint, 3) + " time units";
        g.drawString(totalTime, xBot, yBot + 80);
        String totalFreq = "Frequecy range = 0 to " + Fmath.truncate((double)yLen * (freqs[1] - freqs[0]) / (double)pixelsPerYpoint, 3) + " cycles per time unit";
        g.drawString(totalFreq, xBot, yBot + 100);
        g.drawString("Widow length = " + Fmath.truncate((double)(this.segmentLength - 1) * this.deltaT, 3) + " time units", xBot, yBot + 120);
        String filter2 = "Window filter = " + this.windowNames[this.windowOption];
        if (this.windowOption == 6) {
            filter2 = String.valueOf(filter2) + ", alpha = " + this.kaiserAlpha;
        }
        if (this.windowOption == 7) {
            filter2 = String.valueOf(filter2) + ", alpha = " + this.gaussianAlpha;
        }
        g.drawString(filter2, xBot, yBot + 140);
        yy = yBot + 100;
        xx = xTop + 40;
        double ss = Fmath.truncate(bandZero, 3);
        int i11 = 0;
        while (i11 < numBands) {
            double ff = Fmath.truncate(band[i11], 3);
            g.setColor(color[numBands]);
            g.drawString(String.valueOf(ss) + " - " + ff, xx + 25, yy);
            ss = ff;
            g.setColor(color[i11]);
            int j6 = 0;
            while (j6 < 20) {
                g.drawLine(xx, --yy, xx + 20, yy);
                ++j6;
            }
            ++i11;
        }
        g.setColor(Color.black);
        g.drawString("Mean square", xx + 25, yy - 25);
        g.drawString("amplitudes ", xx + 25, yy - 10);
    }

    public static int lastPowerOfTwo(int len) {
        boolean test0 = true;
        while (test0) {
            if (FourierTransform.checkPowerOfTwo(len)) {
                test0 = false;
                continue;
            }
            --len;
        }
        return len;
    }

    public static int nextPowerOfTwo(int len) {
        boolean test0 = true;
        while (test0) {
            if (FourierTransform.checkPowerOfTwo(len)) {
                test0 = false;
                continue;
            }
            ++len;
        }
        return len;
    }

    public static boolean checkPowerOfTwo(int n) {
        boolean test2 = true;
        int m = n;
        while (test2 && m > 1) {
            if (m % 2 != 0) {
                test2 = false;
                continue;
            }
            m /= 2;
        }
        return test2;
    }

    public static int checkIntegerTimesPowerOfTwo(int n) {
        boolean testOuter1 = true;
        boolean testInner1 = true;
        boolean testInner2 = true;
        boolean testReturn = true;
        int m = n;
        int j = 1;
        int mult = 0;
        while (testOuter1) {
            testInner1 = FourierTransform.checkPowerOfTwo(m);
            if (testInner1) {
                testReturn = true;
                testOuter1 = false;
                continue;
            }
            testInner2 = true;
            while (testInner2) {
                if ((m /= ++j) < 1) {
                    testInner2 = false;
                    testInner1 = false;
                    testOuter1 = false;
                    testReturn = false;
                    continue;
                }
                if (m % 2 != 0) continue;
                testInner2 = false;
            }
        }
        if (testReturn) {
            mult = j;
        }
        return mult;
    }

    public static long getSerialVersionUID() {
        return 1L;
    }
}

