/*
 * Decompiled with CFR 0.152.
 */
package flanagan.math;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class Fmath {
    public static final double N_AVAGADRO = 6.0221419947E23;
    public static final double K_BOLTZMANN = 1.380650324E-23;
    public static final double H_PLANCK = 6.6260687652E-34;
    public static final double H_PLANCK_RED = 1.0545715972483913E-34;
    public static final double C_LIGHT = 2.99792458E8;
    public static final double R_GAS = 8.31447215;
    public static final double F_FARADAY = 96485.341539;
    public static final double T_ABS = -273.15;
    public static final double Q_ELECTRON = -1.60217646263E-19;
    public static final double M_ELECTRON = 9.1093818872E-31;
    public static final double M_PROTON = 1.6726215813E-27;
    public static final double M_NEUTRON = 1.6749271613E-27;
    public static final double EPSILON_0 = 8.854187817E-12;
    public static final double MU_0 = 1.2566370614359173E-6;
    public static final double ETA_0 = 376.73031346177066;
    public static final double EULER_CONSTANT_GAMMA = 0.5772156649015627;
    public static final double PI = Math.PI;
    public static final double E = Math.E;
    private static final Map<Object, Object> integers = new HashMap<Object, Object>();

    static {
        integers.put(Integer.class, BigDecimal.valueOf(Integer.MAX_VALUE));
        integers.put(Long.class, BigDecimal.valueOf(Long.MAX_VALUE));
        integers.put(Byte.class, BigDecimal.valueOf(127L));
        integers.put(Short.class, BigDecimal.valueOf(32767L));
        integers.put(BigInteger.class, BigDecimal.valueOf(-1L));
    }

    public static double log10(double a) {
        return Math.log(a) / Math.log(10.0);
    }

    public static float log10(float a) {
        return (float)(Math.log(a) / Math.log(10.0));
    }

    public static double antilog10(double x2) {
        return Math.pow(10.0, x2);
    }

    public static float antilog10(float x2) {
        return (float)Math.pow(10.0, x2);
    }

    public static double log(double a) {
        return Math.log(a);
    }

    public static float log(float a) {
        return (float)Math.log(a);
    }

    public static double antilog(double x2) {
        return Math.exp(x2);
    }

    public static float antilog(float x2) {
        return (float)Math.exp(x2);
    }

    public static double log2(double a) {
        return Math.log(a) / Math.log(2.0);
    }

    public static float log2(float a) {
        return (float)(Math.log(a) / Math.log(2.0));
    }

    public static double antilog2(double x2) {
        return Math.pow(2.0, x2);
    }

    public static float antilog2(float x2) {
        return (float)Math.pow(2.0, x2);
    }

    public static double log10(double a, double b) {
        return Math.log(a) / Math.log(b);
    }

    public static double log10(double a, int b) {
        return Math.log(a) / Math.log(b);
    }

    public static float log10(float a, float b) {
        return (float)(Math.log(a) / Math.log(b));
    }

    public static float log10(float a, int b) {
        return (float)(Math.log(a) / Math.log(b));
    }

    public static double square(double a) {
        return a * a;
    }

    public static float square(float a) {
        return a * a;
    }

    public static BigDecimal square(BigDecimal a) {
        return a.multiply(a);
    }

    public static int square(int a) {
        return a * a;
    }

    public static long square(long a) {
        return a * a;
    }

    public static BigInteger square(BigInteger a) {
        return a.multiply(a);
    }

    public static int factorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n must be a positive integer");
        }
        if (n > 12) {
            throw new IllegalArgumentException("n must less than 13 to avoid integer overflow\nTry long or double argument");
        }
        int f2 = 1;
        int i = 2;
        while (i <= n) {
            f2 *= i;
            ++i;
        }
        return f2;
    }

    public static long factorial(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("n must be a positive integer");
        }
        if (n > 20L) {
            throw new IllegalArgumentException("n must less than 21 to avoid long integer overflow\nTry double argument");
        }
        long f2 = 1L;
        long iCount = 2L;
        while (iCount <= n) {
            f2 *= iCount;
            ++iCount;
        }
        return f2;
    }

    public static BigInteger factorial(BigInteger n) {
        BigInteger one;
        if (n.compareTo(BigInteger.ZERO) == -1) {
            throw new IllegalArgumentException("\nn must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        BigInteger f2 = one = BigInteger.ONE;
        BigInteger iCount = new BigInteger("2");
        while (iCount.compareTo(n) != 1) {
            f2 = f2.multiply(iCount);
            iCount = iCount.add(one);
        }
        one = null;
        iCount = null;
        return f2;
    }

    public static double factorial(double n) {
        if (n < 0.0 || n - Math.floor(n) != 0.0) {
            throw new IllegalArgumentException("\nn must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        double f2 = 1.0;
        double iCount = 2.0;
        while (iCount <= n) {
            f2 *= iCount;
            iCount += 1.0;
        }
        return f2;
    }

    public static BigDecimal factorial(BigDecimal n) {
        BigDecimal one;
        if (n.compareTo(BigDecimal.ZERO) == -1 || !Fmath.isInteger(n)) {
            throw new IllegalArgumentException("\nn must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        BigDecimal f2 = one = BigDecimal.ONE;
        BigDecimal iCount = new BigDecimal(2.0);
        while (iCount.compareTo(n) != 1) {
            f2 = f2.multiply(iCount);
            iCount = iCount.add(one);
        }
        one = null;
        iCount = null;
        return f2;
    }

    public static double logFactorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("\nn must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        double f2 = 0.0;
        int i = 2;
        while (i <= n) {
            f2 += Math.log(i);
            ++i;
        }
        return f2;
    }

    public static double logFactorial(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("\nn must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        double f2 = 0.0;
        long iCount = 2L;
        while (iCount <= n) {
            f2 += Math.log(iCount);
            ++iCount;
        }
        return f2;
    }

    public static double logFactorial(double n) {
        if (n < 0.0 || n - Math.floor(n) != 0.0) {
            throw new IllegalArgumentException("\nn must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        double f2 = 0.0;
        double iCount = 2.0;
        while (iCount <= n) {
            f2 += Math.log(iCount);
            iCount += 1.0;
        }
        return f2;
    }

    public static double sign(double x2) {
        if (x2 < 0.0) {
            return -1.0;
        }
        return 1.0;
    }

    public static float sign(float x2) {
        if (x2 < 0.0f) {
            return -1.0f;
        }
        return 1.0f;
    }

    public static int sign(int x2) {
        if (x2 < 0) {
            return -1;
        }
        return 1;
    }

    public static long sign(long x2) {
        if (x2 < 0L) {
            return -1L;
        }
        return 1L;
    }

    public static double hypot(double aa, double bb) {
        double amod = Math.abs(aa);
        double bmod = Math.abs(bb);
        double cc = 0.0;
        double ratio = 0.0;
        if (amod == 0.0) {
            cc = bmod;
        } else if (bmod == 0.0) {
            cc = amod;
        } else if (amod >= bmod) {
            ratio = bmod / amod;
            cc = amod * Math.sqrt(1.0 + ratio * ratio);
        } else {
            ratio = amod / bmod;
            cc = bmod * Math.sqrt(1.0 + ratio * ratio);
        }
        return cc;
    }

    public static float hypot(float aa, float bb) {
        return (float)Fmath.hypot((double)aa, (double)bb);
    }

    public static double angle(double xAtA, double yAtA, double xAtB, double yAtB, double xAtC, double yAtC) {
        double ccos = Fmath.cos(xAtA, yAtA, xAtB, yAtB, xAtC, yAtC);
        return Math.acos(ccos);
    }

    public static double angle(double sideAC, double sideBC, double sideAB) {
        double ccos = Fmath.cos(sideAC, sideBC, sideAB);
        return Math.acos(ccos);
    }

    public static double sin(double xAtA, double yAtA, double xAtB, double yAtB, double xAtC, double yAtC) {
        double angle = Fmath.angle(xAtA, yAtA, xAtB, yAtB, xAtC, yAtC);
        return Math.sin(angle);
    }

    public static double sin(double sideAC, double sideBC, double sideAB) {
        double angle = Fmath.angle(sideAC, sideBC, sideAB);
        return Math.sin(angle);
    }

    public static double sin(double arg) {
        return Math.sin(arg);
    }

    public static double asin(double a) {
        if (a < -1.0 && a > 1.0) {
            throw new IllegalArgumentException("Fmath.asin argument (" + a + ") must be >= -1.0 and <= 1.0");
        }
        return Math.asin(a);
    }

    public static double cos(double xAtA, double yAtA, double xAtB, double yAtB, double xAtC, double yAtC) {
        double sideAC = Fmath.hypot(xAtA - xAtC, yAtA - yAtC);
        double sideBC = Fmath.hypot(xAtB - xAtC, yAtB - yAtC);
        double sideAB = Fmath.hypot(xAtA - xAtB, yAtA - yAtB);
        return Fmath.cos(sideAC, sideBC, sideAB);
    }

    public static double cos(double sideAC, double sideBC, double sideAB) {
        return 0.5 * (sideAC / sideBC + sideBC / sideAC - sideAB / sideAC * (sideAB / sideBC));
    }

    public static double cos(double arg) {
        return Math.cos(arg);
    }

    public static double acos(double a) {
        if (a < -1.0 || a > 1.0) {
            throw new IllegalArgumentException("Fmath.acos argument (" + a + ") must be >= -1.0 and <= 1.0");
        }
        return Math.acos(a);
    }

    public static double tan(double xAtA, double yAtA, double xAtB, double yAtB, double xAtC, double yAtC) {
        double angle = Fmath.angle(xAtA, yAtA, xAtB, yAtB, xAtC, yAtC);
        return Math.tan(angle);
    }

    public static double tan(double sideAC, double sideBC, double sideAB) {
        double angle = Fmath.angle(sideAC, sideBC, sideAB);
        return Math.tan(angle);
    }

    public static double tan(double arg) {
        return Math.tan(arg);
    }

    public static double atan(double a) {
        return Math.atan(a);
    }

    public static double atan2(double a, double b) {
        return Math.atan2(a, b);
    }

    public static double cot(double a) {
        return 1.0 / Math.tan(a);
    }

    public static double acot(double a) {
        return Math.atan(1.0 / a);
    }

    public static double acot2(double a, double b) {
        return Math.atan2(b, a);
    }

    public static double sec(double a) {
        return 1.0 / Math.cos(a);
    }

    public static double asec(double a) {
        if (a < 1.0 && a > -1.0) {
            throw new IllegalArgumentException("asec argument (" + a + ") must be >= 1 or <= -1");
        }
        return Math.acos(1.0 / a);
    }

    public static double csc(double a) {
        return 1.0 / Math.sin(a);
    }

    public static double acsc(double a) {
        if (a < 1.0 && a > -1.0) {
            throw new IllegalArgumentException("acsc argument (" + a + ") must be >= 1 or <= -1");
        }
        return Math.asin(1.0 / a);
    }

    public static double exsec(double a) {
        return 1.0 / Math.cos(a) - 1.0;
    }

    public static double aexsec(double a) {
        if (a < 0.0 && a > -2.0) {
            throw new IllegalArgumentException("aexsec argument (" + a + ") must be >= 0.0 and <= -2");
        }
        return Math.asin(1.0 / (1.0 + a));
    }

    public static double vers(double a) {
        return 1.0 - Math.cos(a);
    }

    public static double avers(double a) {
        if (a < 0.0 && a > 2.0) {
            throw new IllegalArgumentException("avers argument (" + a + ") must be <= 2 and >= 0");
        }
        return Math.acos(1.0 - a);
    }

    public static double covers(double a) {
        return 1.0 - Math.sin(a);
    }

    public static double acovers(double a) {
        if (a < 0.0 && a > 2.0) {
            throw new IllegalArgumentException("acovers argument (" + a + ") must be <= 2 and >= 0");
        }
        return Math.asin(1.0 - a);
    }

    public static double hav(double a) {
        return 0.5 * Fmath.vers(a);
    }

    public static double ahav(double a) {
        if (a < 0.0 && a > 1.0) {
            throw new IllegalArgumentException("ahav argument (" + a + ") must be >= 0 and <= 1");
        }
        return Fmath.acos(1.0 - 2.0 * a);
    }

    public static double sinc(double a) {
        if (Math.abs(a) < 1.0E-40) {
            return 1.0;
        }
        return Math.sin(a) / a;
    }

    public static double nsinc(double a) {
        if (Math.abs(a) < 1.0E-40) {
            return 1.0;
        }
        return Math.sin(Math.PI * a) / (Math.PI * a);
    }

    public static double sinh(double a) {
        return 0.5 * (Math.exp(a) - Math.exp(-a));
    }

    public static double asinh(double a) {
        double sgn = 1.0;
        if (a < 0.0) {
            sgn = -1.0;
            a = -a;
        }
        return sgn * Math.log(a + Math.sqrt(a * a + 1.0));
    }

    public static double cosh(double a) {
        return 0.5 * (Math.exp(a) + Math.exp(-a));
    }

    public static double acosh(double a) {
        if (a < 1.0) {
            throw new IllegalArgumentException("acosh real number argument (" + a + ") must be >= 1");
        }
        return Math.log(a + Math.sqrt(a * a - 1.0));
    }

    public static double tanh(double a) {
        return Fmath.sinh(a) / Fmath.cosh(a);
    }

    public static double atanh(double a) {
        double sgn = 1.0;
        if (a < 0.0) {
            sgn = -1.0;
            a = -a;
        }
        if (a > 1.0) {
            throw new IllegalArgumentException("atanh real number argument (" + sgn * a + ") must be >= -1 and <= 1");
        }
        return 0.5 * sgn * (Math.log(1.0 + a) - Math.log(1.0 - a));
    }

    public static double coth(double a) {
        return 1.0 / Fmath.tanh(a);
    }

    public static double acoth(double a) {
        double sgn = 1.0;
        if (a < 0.0) {
            sgn = -1.0;
            a = -a;
        }
        if (a < 1.0) {
            throw new IllegalArgumentException("acoth real number argument (" + sgn * a + ") must be <= -1 or >= 1");
        }
        return 0.5 * sgn * (Math.log(1.0 + a) - Math.log(a - 1.0));
    }

    public static double sech(double a) {
        return 1.0 / Fmath.cosh(a);
    }

    public static double asech(double a) {
        if (a > 1.0 || a < 0.0) {
            throw new IllegalArgumentException("asech real number argument (" + a + ") must be >= 0 and <= 1");
        }
        return 0.5 * Math.log(1.0 / a + Math.sqrt(1.0 / (a * a) - 1.0));
    }

    public static double csch(double a) {
        return 1.0 / Fmath.sinh(a);
    }

    public static double acsch(double a) {
        double sgn = 1.0;
        if (a < 0.0) {
            sgn = -1.0;
            a = -a;
        }
        return 0.5 * sgn * Math.log(1.0 / a + Math.sqrt(1.0 / (a * a) + 1.0));
    }

    public static int checkPrecision(double number2) {
        boolean test2 = true;
        int prec = 0;
        if (Fmath.isNaN(number2)) {
            test2 = false;
        }
        if (Fmath.isPlusInfinity(number2)) {
            test2 = false;
        }
        if (Fmath.isMinusInfinity(number2)) {
            test2 = false;
        }
        while (test2) {
            if (number2 == Fmath.truncate(number2, prec)) {
                test2 = false;
                continue;
            }
            if (++prec <= 20) continue;
            test2 = false;
        }
        return prec;
    }

    public static int checkPrecision(float number2) {
        return Fmath.checkPrecision((double)number2);
    }

    public static double truncate(double xDouble, int trunc) {
        double xTruncated = xDouble;
        if (!(Fmath.isNaN(xDouble) || Fmath.isPlusInfinity(xDouble) || Fmath.isMinusInfinity(xDouble) || xDouble == 0.0)) {
            String xString = new Double(xDouble).toString().trim();
            xTruncated = Double.parseDouble(Fmath.truncateProcedure(xString, trunc));
        }
        return xTruncated;
    }

    public static float truncate(float xFloat, int trunc) {
        float xTruncated = xFloat;
        if (!(Fmath.isNaN(xFloat) || Fmath.isPlusInfinity(xFloat) || Fmath.isMinusInfinity(xFloat) || (double)xFloat == 0.0)) {
            String xString = new Float(xFloat).toString().trim();
            xTruncated = Float.parseFloat(Fmath.truncateProcedure(xString, trunc));
        }
        return xTruncated;
    }

    private static String truncateProcedure(String xValue, int trunc) {
        String xTruncated = xValue;
        String xWorking = xValue;
        String exponent2 = " ";
        String first = "+";
        int expPos = xValue.indexOf(69);
        int dotPos = xValue.indexOf(46);
        int minPos = xValue.indexOf(45);
        if (minPos != -1 && minPos == 0) {
            xWorking = xWorking.substring(1);
            first = "-";
            --dotPos;
            --expPos;
        }
        if (expPos > -1) {
            exponent2 = xWorking.substring(expPos);
            xWorking = xWorking.substring(0, expPos);
        }
        String xPreDot = null;
        String xPostDot = "0";
        String xDiscarded = null;
        String tempString = null;
        double tempDouble = 0.0;
        if (dotPos > -1) {
            xPreDot = xWorking.substring(0, dotPos);
            xPostDot = xWorking.substring(dotPos + 1);
            int xLength = xPostDot.length();
            if (trunc < xLength) {
                xDiscarded = xPostDot.substring(trunc);
                tempString = String.valueOf(xDiscarded.substring(0, 1)) + ".";
                tempString = xDiscarded.length() > 1 ? String.valueOf(tempString) + xDiscarded.substring(1) : String.valueOf(tempString) + "0";
                tempDouble = Math.round(Double.parseDouble(tempString));
                if (trunc > 0) {
                    if (tempDouble >= 5.0) {
                        int[] xArray = new int[trunc + 1];
                        xArray[0] = 0;
                        int i = 0;
                        while (i < trunc) {
                            xArray[i + 1] = Integer.parseInt(xPostDot.substring(i, i + 1));
                            ++i;
                        }
                        boolean test2 = true;
                        int iCounter = trunc;
                        while (test2) {
                            int n = iCounter;
                            xArray[n] = xArray[n] + 1;
                            if (iCounter > 0) {
                                if (xArray[iCounter] < 10) {
                                    test2 = false;
                                    continue;
                                }
                                xArray[iCounter] = 0;
                                --iCounter;
                                continue;
                            }
                            test2 = false;
                        }
                        int preInt = Integer.parseInt(xPreDot);
                        xPreDot = new Integer(preInt += xArray[0]).toString();
                        tempString = "";
                        int i2 = 1;
                        while (i2 <= trunc) {
                            tempString = String.valueOf(tempString) + new Integer(xArray[i2]).toString();
                            ++i2;
                        }
                        xPostDot = tempString;
                    } else {
                        xPostDot = xPostDot.substring(0, trunc);
                    }
                } else {
                    if (tempDouble >= 5.0) {
                        int preInt = Integer.parseInt(xPreDot);
                        xPreDot = new Integer(++preInt).toString();
                    }
                    xPostDot = "0";
                }
            }
            xTruncated = String.valueOf(first) + xPreDot.trim() + "." + xPostDot.trim() + exponent2;
        }
        return xTruncated.trim();
    }

    public static boolean isInfinity(double x2) {
        boolean test2 = false;
        if (x2 == Double.POSITIVE_INFINITY || x2 == Double.NEGATIVE_INFINITY) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isInfinity(float x2) {
        boolean test2 = false;
        if (x2 == Float.POSITIVE_INFINITY || x2 == Float.NEGATIVE_INFINITY) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isPlusInfinity(double x2) {
        boolean test2 = false;
        if (x2 == Double.POSITIVE_INFINITY) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isPlusInfinity(float x2) {
        boolean test2 = false;
        if (x2 == Float.POSITIVE_INFINITY) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isMinusInfinity(double x2) {
        boolean test2 = false;
        if (x2 == Double.NEGATIVE_INFINITY) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isMinusInfinity(float x2) {
        boolean test2 = false;
        if (x2 == Float.NEGATIVE_INFINITY) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isNaN(double x2) {
        boolean test2 = false;
        if (x2 != x2) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isNaN(float x2) {
        boolean test2 = false;
        if (x2 != x2) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isEqual(double x2, double y) {
        boolean test2 = false;
        if (Fmath.isNaN(x2)) {
            if (Fmath.isNaN(y)) {
                test2 = true;
            }
        } else if (Fmath.isPlusInfinity(x2)) {
            if (Fmath.isPlusInfinity(y)) {
                test2 = true;
            }
        } else if (Fmath.isMinusInfinity(x2)) {
            if (Fmath.isMinusInfinity(y)) {
                test2 = true;
            }
        } else if (x2 == y) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isEqual(float x2, float y) {
        boolean test2 = false;
        if (Fmath.isNaN(x2)) {
            if (Fmath.isNaN(y)) {
                test2 = true;
            }
        } else if (Fmath.isPlusInfinity(x2)) {
            if (Fmath.isPlusInfinity(y)) {
                test2 = true;
            }
        } else if (Fmath.isMinusInfinity(x2)) {
            if (Fmath.isMinusInfinity(y)) {
                test2 = true;
            }
        } else if (x2 == y) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isEqual(int x2, int y) {
        boolean test2 = false;
        if (x2 == y) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isEqual(char x2, char y) {
        boolean test2 = false;
        if (x2 == y) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isEqual(String x2, String y) {
        boolean test2 = false;
        if (x2.equals(y)) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isEqualWithinLimits(double x2, double y, double limit) {
        boolean test2 = false;
        if (Math.abs(x2 - y) <= Math.abs(limit)) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isEqualWithinLimits(float x2, float y, float limit) {
        boolean test2 = false;
        if (Math.abs(x2 - y) <= Math.abs(limit)) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isEqualWithinLimits(long x2, long y, long limit) {
        boolean test2 = false;
        if (Math.abs(x2 - y) <= Math.abs(limit)) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isEqualWithinLimits(int x2, int y, int limit) {
        boolean test2 = false;
        if (Math.abs(x2 - y) <= Math.abs(limit)) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isEqualWithinLimits(BigDecimal x2, BigDecimal y, BigDecimal limit) {
        boolean test2 = false;
        if (x2.subtract(y).abs().compareTo(limit.abs()) <= 0) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isEqualWithinLimits(BigInteger x2, BigInteger y, BigInteger limit) {
        boolean test2 = false;
        if (x2.subtract(y).abs().compareTo(limit.abs()) <= 0) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isEqualWithinPerCent(double x2, double y, double perCent) {
        boolean test2 = false;
        double limit = Math.abs((x2 + y) * perCent / 200.0);
        if (Math.abs(x2 - y) <= limit) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isEqualWithinPerCent(float x2, float y, float perCent) {
        boolean test2 = false;
        double limit = Math.abs((x2 + y) * perCent / 200.0f);
        if ((double)Math.abs(x2 - y) <= limit) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isEqualWithinPerCent(long x2, long y, double perCent) {
        boolean test2 = false;
        double limit = Math.abs((double)(x2 + y) * perCent / 200.0);
        if ((double)Math.abs(x2 - y) <= limit) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isEqualWithinPerCent(long x2, long y, long perCent) {
        boolean test2 = false;
        double limit = Math.abs((double)(x2 + y) * (double)perCent / 200.0);
        if ((double)Math.abs(x2 - y) <= limit) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isEqualWithinPerCent(int x2, int y, double perCent) {
        boolean test2 = false;
        double limit = Math.abs((double)(x2 + y) * perCent / 200.0);
        if ((double)Math.abs(x2 - y) <= limit) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isEqualWithinPerCent(int x2, int y, int perCent) {
        boolean test2 = false;
        double limit = Math.abs((double)(x2 + y) * (double)perCent / 200.0);
        if ((double)Math.abs(x2 - y) <= limit) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isEqualWithinPerCent(BigDecimal x2, BigDecimal y, BigDecimal perCent) {
        boolean test2 = false;
        BigDecimal limit = x2.add(y).multiply(perCent).multiply(new BigDecimal("0.005"));
        if (x2.subtract(y).abs().compareTo(limit.abs()) <= 0) {
            test2 = true;
        }
        limit = null;
        return test2;
    }

    public static boolean isEqualWithinPerCent(BigInteger x2, BigInteger y, BigDecimal perCent) {
        boolean test2 = false;
        BigDecimal xx = new BigDecimal(x2);
        BigDecimal yy = new BigDecimal(y);
        BigDecimal limit = xx.add(yy).multiply(perCent).multiply(new BigDecimal("0.005"));
        if (xx.subtract(yy).abs().compareTo(limit.abs()) <= 0) {
            test2 = true;
        }
        limit = null;
        xx = null;
        yy = null;
        return test2;
    }

    public static boolean isEqualWithinPerCent(BigInteger x2, BigInteger y, BigInteger perCent) {
        boolean test2 = false;
        BigDecimal xx = new BigDecimal(x2);
        BigDecimal yy = new BigDecimal(y);
        BigDecimal pc = new BigDecimal(perCent);
        BigDecimal limit = xx.add(yy).multiply(pc).multiply(new BigDecimal("0.005"));
        if (xx.subtract(yy).abs().compareTo(limit.abs()) <= 0) {
            test2 = true;
        }
        limit = null;
        xx = null;
        yy = null;
        pc = null;
        return test2;
    }

    public static int compare(double x2, double y) {
        Double X = new Double(x2);
        Double Y = new Double(y);
        return X.compareTo(Y);
    }

    public static int compare(int x2, int y) {
        Integer X = new Integer(x2);
        Integer Y = new Integer(y);
        return X.compareTo(Y);
    }

    public static int compare(long x2, long y) {
        Long X = new Long(x2);
        Long Y = new Long(y);
        return X.compareTo(Y);
    }

    public static int compare(float x2, float y) {
        Float X = new Float(x2);
        Float Y = new Float(y);
        return X.compareTo(Y);
    }

    public static int compare(byte x2, byte y) {
        Byte X = new Byte(x2);
        Byte Y = new Byte(y);
        return X.compareTo(Y);
    }

    public static int compare(short x2, short y) {
        Short X = new Short(x2);
        Short Y = new Short(y);
        return X.compareTo(Y);
    }

    public static boolean compare(double[] array1, double[] array2) {
        boolean ret = true;
        int n = array1.length;
        int m = array2.length;
        if (n != m) {
            ret = false;
        } else {
            int i = 0;
            while (i < n) {
                if (array1[i] != array2[i]) {
                    ret = false;
                    break;
                }
                ++i;
            }
        }
        return ret;
    }

    public static boolean compare(float[] array1, float[] array2) {
        boolean ret = true;
        int n = array1.length;
        int m = array2.length;
        if (n != m) {
            ret = false;
        } else {
            int i = 0;
            while (i < n) {
                if (array1[i] != array2[i]) {
                    ret = false;
                    break;
                }
                ++i;
            }
        }
        return ret;
    }

    public static boolean compare(int[] array1, int[] array2) {
        boolean ret = true;
        int n = array1.length;
        int m = array2.length;
        if (n != m) {
            ret = false;
        } else {
            int i = 0;
            while (i < n) {
                if (array1[i] != array2[i]) {
                    ret = false;
                    break;
                }
                ++i;
            }
        }
        return ret;
    }

    public static boolean compare(long[] array1, long[] array2) {
        boolean ret = true;
        int n = array1.length;
        int m = array2.length;
        if (n != m) {
            ret = false;
        } else {
            int i = 0;
            while (i < n) {
                if (array1[i] != array2[i]) {
                    ret = false;
                    break;
                }
                ++i;
            }
        }
        return ret;
    }

    public static boolean isInteger(double x2) {
        boolean retn = false;
        double xfloor = Math.floor(x2);
        if (x2 - xfloor == 0.0) {
            retn = true;
        }
        return retn;
    }

    public static boolean isInteger(double[] x2) {
        boolean retn = true;
        boolean test2 = true;
        int ii = 0;
        while (test2) {
            double xfloor = Math.floor(x2[ii]);
            if (x2[ii] - xfloor != 0.0) {
                retn = false;
                test2 = false;
                continue;
            }
            if (++ii != x2.length) continue;
            test2 = false;
        }
        return retn;
    }

    public static boolean isInteger(float x2) {
        boolean ret = false;
        float xfloor = (float)Math.floor(x2);
        if (x2 - xfloor == 0.0f) {
            ret = true;
        }
        return ret;
    }

    public static boolean isInteger(float[] x2) {
        boolean retn = true;
        boolean test2 = true;
        int ii = 0;
        while (test2) {
            float xfloor = (float)Math.floor(x2[ii]);
            if ((double)(x2[ii] - xfloor) != 0.0) {
                retn = false;
                test2 = false;
                continue;
            }
            if (++ii != x2.length) continue;
            test2 = false;
        }
        return retn;
    }

    public static boolean isInteger(Number numberAsObject) {
        boolean test2 = integers.containsKey(numberAsObject.getClass());
        if (!test2) {
            double dd;
            if (numberAsObject instanceof Double) {
                dd = numberAsObject.doubleValue();
                test2 = Fmath.isInteger(dd);
            }
            if (numberAsObject instanceof Float) {
                float dd2 = numberAsObject.floatValue();
                test2 = Fmath.isInteger(dd2);
            }
            if (numberAsObject instanceof BigDecimal) {
                dd = numberAsObject.doubleValue();
                test2 = Fmath.isInteger(dd);
            }
        }
        return test2;
    }

    public static boolean isInteger(Number[] numberAsObject) {
        boolean testall = true;
        int i = 0;
        while (i < numberAsObject.length) {
            boolean test2 = integers.containsKey(numberAsObject[i].getClass());
            if (!test2) {
                double dd;
                if (numberAsObject[i] instanceof Double && !(test2 = Fmath.isInteger(dd = numberAsObject[i].doubleValue()))) {
                    testall = false;
                }
                if (numberAsObject[i] instanceof Float && !(test2 = Fmath.isInteger(dd = numberAsObject[i].floatValue()))) {
                    testall = false;
                }
                if (numberAsObject[i] instanceof BigDecimal && !(test2 = Fmath.isInteger(dd = numberAsObject[i].doubleValue()))) {
                    testall = false;
                }
            }
            ++i;
        }
        return testall;
    }

    public static boolean isEven(int x2) {
        boolean test2 = false;
        if ((double)(x2 % 2) == 0.0) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isEven(float x2) {
        double y = Math.floor(x2);
        if ((double)x2 - y != 0.0) {
            throw new IllegalArgumentException("the argument is not an integer");
        }
        boolean test2 = false;
        y = Math.floor(x2 / 2.0f);
        if ((double)(x2 / 2.0f) - y == 0.0) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isEven(double x2) {
        double y = Math.floor(x2);
        if (x2 - y != 0.0) {
            throw new IllegalArgumentException("the argument is not an integer");
        }
        boolean test2 = false;
        y = Math.floor(x2 / 2.0);
        if (x2 / 2.0 - y == 0.0) {
            test2 = true;
        }
        return test2;
    }

    public static boolean isOdd(int x2) {
        boolean test2 = true;
        if ((double)(x2 % 2) == 0.0) {
            test2 = false;
        }
        return test2;
    }

    public static boolean isOdd(float x2) {
        double y = Math.floor(x2);
        if ((double)x2 - y != 0.0) {
            throw new IllegalArgumentException("the argument is not an integer");
        }
        boolean test2 = true;
        y = Math.floor(x2 / 2.0f);
        if ((double)(x2 / 2.0f) - y == 0.0) {
            test2 = false;
        }
        return test2;
    }

    public static boolean isOdd(double x2) {
        double y = Math.floor(x2);
        if (x2 - y != 0.0) {
            throw new IllegalArgumentException("the argument is not an integer");
        }
        boolean test2 = true;
        y = Math.floor(x2 / 2.0);
        if (x2 / 2.0 - y == 0.0) {
            test2 = false;
        }
        return test2;
    }

    public static boolean leapYear(int year) {
        boolean test2 = false;
        test2 = year % 4 != 0 ? false : (year % 400 == 0 ? true : year % 100 != 0);
        return test2;
    }

    public static long dateToJavaMilliS(int year, int month, int day, int hour, int min2, int sec) {
        long[] lArray = new long[13];
        lArray[1] = 31L;
        lArray[2] = 28L;
        lArray[3] = 31L;
        lArray[4] = 30L;
        lArray[5] = 31L;
        lArray[6] = 30L;
        lArray[7] = 31L;
        lArray[8] = 31L;
        lArray[9] = 30L;
        lArray[10] = 31L;
        lArray[11] = 30L;
        lArray[12] = 31L;
        long[] monthDays = lArray;
        long ms = 0L;
        long yearDiff = 0L;
        int yearTest = year - 1;
        while (yearTest >= 1970) {
            yearDiff += 365L;
            if (Fmath.leapYear(yearTest)) {
                ++yearDiff;
            }
            --yearTest;
        }
        yearDiff *= 86400000L;
        long monthDiff = 0L;
        int monthTest = month - 1;
        while (monthTest > 0) {
            monthDiff += monthDays[monthTest];
            if (Fmath.leapYear(year)) {
                ++monthDiff;
            }
            --monthTest;
        }
        ms = yearDiff + (monthDiff *= 86400000L) + (long)day * 24L * 60L * 60L * 1000L + (long)hour * 60L * 60L * 1000L + (long)min2 * 60L * 1000L + (long)sec * 1000L;
        return ms;
    }

    public static double maximum(double[] aa) {
        int n = aa.length;
        double aamax = aa[0];
        int i = 1;
        while (i < n) {
            if (aa[i] > aamax) {
                aamax = aa[i];
            }
            ++i;
        }
        return aamax;
    }

    public static float maximum(float[] aa) {
        int n = aa.length;
        float aamax = aa[0];
        int i = 1;
        while (i < n) {
            if (aa[i] > aamax) {
                aamax = aa[i];
            }
            ++i;
        }
        return aamax;
    }

    public static int maximum(int[] aa) {
        int n = aa.length;
        int aamax = aa[0];
        int i = 1;
        while (i < n) {
            if (aa[i] > aamax) {
                aamax = aa[i];
            }
            ++i;
        }
        return aamax;
    }

    public static long maximum(long[] aa) {
        long n = aa.length;
        long aamax = aa[0];
        int i = 1;
        while ((long)i < n) {
            if (aa[i] > aamax) {
                aamax = aa[i];
            }
            ++i;
        }
        return aamax;
    }

    public static double minimum(double[] aa) {
        int n = aa.length;
        double aamin = aa[0];
        int i = 1;
        while (i < n) {
            if (aa[i] < aamin) {
                aamin = aa[i];
            }
            ++i;
        }
        return aamin;
    }

    public static float minimum(float[] aa) {
        int n = aa.length;
        float aamin = aa[0];
        int i = 1;
        while (i < n) {
            if (aa[i] < aamin) {
                aamin = aa[i];
            }
            ++i;
        }
        return aamin;
    }

    public static int minimum(int[] aa) {
        int n = aa.length;
        int aamin = aa[0];
        int i = 1;
        while (i < n) {
            if (aa[i] < aamin) {
                aamin = aa[i];
            }
            ++i;
        }
        return aamin;
    }

    public static long minimum(long[] aa) {
        long n = aa.length;
        long aamin = aa[0];
        int i = 1;
        while ((long)i < n) {
            if (aa[i] < aamin) {
                aamin = aa[i];
            }
            ++i;
        }
        return aamin;
    }

    public static double maximumDifference(double[] aa) {
        return Fmath.maximum(aa) - Fmath.minimum(aa);
    }

    public static float maximumDifference(float[] aa) {
        return Fmath.maximum(aa) - Fmath.minimum(aa);
    }

    public static long maximumDifference(long[] aa) {
        return Fmath.maximum(aa) - Fmath.minimum(aa);
    }

    public static int maximumDifference(int[] aa) {
        return Fmath.maximum(aa) - Fmath.minimum(aa);
    }

    public static double minimumDifference(double[] aa) {
        double diff2;
        double[] sorted2 = Fmath.selectionSort(aa);
        double n = aa.length;
        double minDiff = diff2 = sorted2[1] - sorted2[0];
        int i = 1;
        while ((double)i < n - 1.0) {
            diff2 = sorted2[i + 1] - sorted2[i];
            if (diff2 < minDiff) {
                minDiff = diff2;
            }
            ++i;
        }
        return minDiff;
    }

    public static float minimumDifference(float[] aa) {
        float diff2;
        float[] sorted2 = Fmath.selectionSort(aa);
        float n = aa.length;
        float minDiff = diff2 = sorted2[1] - sorted2[0];
        int i = 1;
        while ((float)i < n - 1.0f) {
            diff2 = sorted2[i + 1] - sorted2[i];
            if (diff2 < minDiff) {
                minDiff = diff2;
            }
            ++i;
        }
        return minDiff;
    }

    public static long minimumDifference(long[] aa) {
        long diff2;
        long[] sorted2 = Fmath.selectionSort(aa);
        long n = aa.length;
        long minDiff = diff2 = sorted2[1] - sorted2[0];
        int i = 1;
        while ((long)i < n - 1L) {
            diff2 = sorted2[i + 1] - sorted2[i];
            if (diff2 < minDiff) {
                minDiff = diff2;
            }
            ++i;
        }
        return minDiff;
    }

    public static int minimumDifference(int[] aa) {
        int diff2;
        int[] sorted2 = Fmath.selectionSort(aa);
        int n = aa.length;
        int minDiff = diff2 = sorted2[1] - sorted2[0];
        int i = 1;
        while (i < n - 1) {
            diff2 = sorted2[i + 1] - sorted2[i];
            if (diff2 < minDiff) {
                minDiff = diff2;
            }
            ++i;
        }
        return minDiff;
    }

    public static double[] reverseArray(double[] aa) {
        int n = aa.length;
        double[] bb = new double[n];
        int i = 0;
        while (i < n) {
            bb[i] = aa[n - 1 - i];
            ++i;
        }
        return bb;
    }

    public static float[] reverseArray(float[] aa) {
        int n = aa.length;
        float[] bb = new float[n];
        int i = 0;
        while (i < n) {
            bb[i] = aa[n - 1 - i];
            ++i;
        }
        return bb;
    }

    public static int[] reverseArray(int[] aa) {
        int n = aa.length;
        int[] bb = new int[n];
        int i = 0;
        while (i < n) {
            bb[i] = aa[n - 1 - i];
            ++i;
        }
        return bb;
    }

    public static long[] reverseArray(long[] aa) {
        int n = aa.length;
        long[] bb = new long[n];
        int i = 0;
        while (i < n) {
            bb[i] = aa[n - 1 - i];
            ++i;
        }
        return bb;
    }

    public static char[] reverseArray(char[] aa) {
        int n = aa.length;
        char[] bb = new char[n];
        int i = 0;
        while (i < n) {
            bb[i] = aa[n - 1 - i];
            ++i;
        }
        return bb;
    }

    public static double[] arrayAbs(double[] aa) {
        int n = aa.length;
        double[] bb = new double[n];
        int i = 0;
        while (i < n) {
            bb[i] = Math.abs(aa[i]);
            ++i;
        }
        return bb;
    }

    public static float[] arrayAbs(float[] aa) {
        int n = aa.length;
        float[] bb = new float[n];
        int i = 0;
        while (i < n) {
            bb[i] = Math.abs(aa[i]);
            ++i;
        }
        return bb;
    }

    public static long[] arrayAbs(long[] aa) {
        int n = aa.length;
        long[] bb = new long[n];
        int i = 0;
        while (i < n) {
            bb[i] = Math.abs(aa[i]);
            ++i;
        }
        return bb;
    }

    public static int[] arrayAbs(int[] aa) {
        int n = aa.length;
        int[] bb = new int[n];
        int i = 0;
        while (i < n) {
            bb[i] = Math.abs(aa[i]);
            ++i;
        }
        return bb;
    }

    public static double[] arrayMultByConstant(double[] aa, double constant) {
        int n = aa.length;
        double[] bb = new double[n];
        int i = 0;
        while (i < n) {
            bb[i] = aa[i] * constant;
            ++i;
        }
        return bb;
    }

    public static double[] arrayMultByConstant(int[] aa, double constant) {
        int n = aa.length;
        double[] bb = new double[n];
        int i = 0;
        while (i < n) {
            bb[i] = (double)aa[i] * constant;
            ++i;
        }
        return bb;
    }

    public static double[] arrayMultByConstant(double[] aa, int constant) {
        int n = aa.length;
        double[] bb = new double[n];
        int i = 0;
        while (i < n) {
            bb[i] = aa[i] * (double)constant;
            ++i;
        }
        return bb;
    }

    public static double[] arrayMultByConstant(int[] aa, int constant) {
        int n = aa.length;
        double[] bb = new double[n];
        int i = 0;
        while (i < n) {
            bb[i] = aa[i] * constant;
            ++i;
        }
        return bb;
    }

    public static double[] log10Elements(double[] aa) {
        int n = aa.length;
        double[] bb = new double[n];
        int i = 0;
        while (i < n) {
            bb[i] = Math.log10(aa[i]);
            ++i;
        }
        return bb;
    }

    public static float[] log10Elements(float[] aa) {
        int n = aa.length;
        float[] bb = new float[n];
        int i = 0;
        while (i < n) {
            bb[i] = (float)Math.log10(aa[i]);
            ++i;
        }
        return bb;
    }

    public static double[] lnElements(double[] aa) {
        int n = aa.length;
        double[] bb = new double[n];
        int i = 0;
        while (i < n) {
            bb[i] = Math.log10(aa[i]);
            ++i;
        }
        return bb;
    }

    public static float[] lnElements(float[] aa) {
        int n = aa.length;
        float[] bb = new float[n];
        int i = 0;
        while (i < n) {
            bb[i] = (float)Math.log10(aa[i]);
            ++i;
        }
        return bb;
    }

    public static double[] squareRootElements(double[] aa) {
        int n = aa.length;
        double[] bb = new double[n];
        int i = 0;
        while (i < n) {
            bb[i] = Math.sqrt(aa[i]);
            ++i;
        }
        return bb;
    }

    public static float[] squareRootElements(float[] aa) {
        int n = aa.length;
        float[] bb = new float[n];
        int i = 0;
        while (i < n) {
            bb[i] = (float)Math.sqrt(aa[i]);
            ++i;
        }
        return bb;
    }

    public static double[] raiseElementsToPower(double[] aa, double power) {
        int n = aa.length;
        double[] bb = new double[n];
        int i = 0;
        while (i < n) {
            bb[i] = Math.pow(aa[i], power);
            ++i;
        }
        return bb;
    }

    public static double[] raiseElementsToPower(double[] aa, int power) {
        int n = aa.length;
        double[] bb = new double[n];
        int i = 0;
        while (i < n) {
            bb[i] = Math.pow(aa[i], power);
            ++i;
        }
        return bb;
    }

    public static float[] raiseElementsToPower(float[] aa, float power) {
        int n = aa.length;
        float[] bb = new float[n];
        int i = 0;
        while (i < n) {
            bb[i] = (float)Math.pow(aa[i], power);
            ++i;
        }
        return bb;
    }

    public static float[] raiseElementsToPower(float[] aa, int power) {
        int n = aa.length;
        float[] bb = new float[n];
        int i = 0;
        while (i < n) {
            bb[i] = (float)Math.pow(aa[i], power);
            ++i;
        }
        return bb;
    }

    public static double[] invertElements(double[] aa) {
        int n = aa.length;
        double[] bb = new double[n];
        int i = 0;
        while (i < n) {
            bb[i] = 1.0 / aa[i];
            ++i;
        }
        return bb;
    }

    public static float[] invertElements(float[] aa) {
        int n = aa.length;
        float[] bb = new float[n];
        int i = 0;
        while (i < n) {
            bb[i] = 1.0f / aa[i];
            ++i;
        }
        return bb;
    }

    public static int[] indicesOf(double[] array, double value2) {
        int[] indices = null;
        int numberOfIndices = 0;
        ArrayList<Integer> arrayl = new ArrayList<Integer>();
        int i = 0;
        while (i < array.length) {
            if (array[i] == value2) {
                ++numberOfIndices;
                arrayl.add(new Integer(i));
            }
            ++i;
        }
        if (numberOfIndices != 0) {
            indices = new int[numberOfIndices];
            i = 0;
            while (i < numberOfIndices) {
                indices[i] = (Integer)arrayl.get(i);
                ++i;
            }
        }
        return indices;
    }

    public static int[] indicesOf(float[] array, float value2) {
        int[] indices = null;
        int numberOfIndices = 0;
        ArrayList<Integer> arrayl = new ArrayList<Integer>();
        int i = 0;
        while (i < array.length) {
            if (array[i] == value2) {
                ++numberOfIndices;
                arrayl.add(new Integer(i));
            }
            ++i;
        }
        if (numberOfIndices != 0) {
            indices = new int[numberOfIndices];
            i = 0;
            while (i < numberOfIndices) {
                indices[i] = (Integer)arrayl.get(i);
                ++i;
            }
        }
        return indices;
    }

    public static int[] indicesOf(long[] array, long value2) {
        int[] indices = null;
        int numberOfIndices = 0;
        ArrayList<Integer> arrayl = new ArrayList<Integer>();
        int i = 0;
        while (i < array.length) {
            if (array[i] == value2) {
                ++numberOfIndices;
                arrayl.add(new Integer(i));
            }
            ++i;
        }
        if (numberOfIndices != 0) {
            indices = new int[numberOfIndices];
            i = 0;
            while (i < numberOfIndices) {
                indices[i] = (Integer)arrayl.get(i);
                ++i;
            }
        }
        return indices;
    }

    public static int[] indicesOf(int[] array, int value2) {
        int[] indices = null;
        int numberOfIndices = 0;
        ArrayList<Integer> arrayl = new ArrayList<Integer>();
        int i = 0;
        while (i < array.length) {
            if (array[i] == value2) {
                ++numberOfIndices;
                arrayl.add(new Integer(i));
            }
            ++i;
        }
        if (numberOfIndices != 0) {
            indices = new int[numberOfIndices];
            i = 0;
            while (i < numberOfIndices) {
                indices[i] = (Integer)arrayl.get(i);
                ++i;
            }
        }
        return indices;
    }

    public static int[] indicesOf(short[] array, short value2) {
        int[] indices = null;
        int numberOfIndices = 0;
        ArrayList<Integer> arrayl = new ArrayList<Integer>();
        int i = 0;
        while (i < array.length) {
            if (array[i] == value2) {
                ++numberOfIndices;
                arrayl.add(new Integer(i));
            }
            ++i;
        }
        if (numberOfIndices != 0) {
            indices = new int[numberOfIndices];
            i = 0;
            while (i < numberOfIndices) {
                indices[i] = (Integer)arrayl.get(i);
                ++i;
            }
        }
        return indices;
    }

    public static int[] indicesOf(byte[] array, byte value2) {
        int[] indices = null;
        int numberOfIndices = 0;
        ArrayList<Integer> arrayl = new ArrayList<Integer>();
        int i = 0;
        while (i < array.length) {
            if (array[i] == value2) {
                ++numberOfIndices;
                arrayl.add(new Integer(i));
            }
            ++i;
        }
        if (numberOfIndices != 0) {
            indices = new int[numberOfIndices];
            i = 0;
            while (i < numberOfIndices) {
                indices[i] = (Integer)arrayl.get(i);
                ++i;
            }
        }
        return indices;
    }

    public static int[] indicesOf(char[] array, char value2) {
        int[] indices = null;
        int numberOfIndices = 0;
        ArrayList<Integer> arrayl = new ArrayList<Integer>();
        int i = 0;
        while (i < array.length) {
            if (array[i] == value2) {
                ++numberOfIndices;
                arrayl.add(new Integer(i));
            }
            ++i;
        }
        if (numberOfIndices != 0) {
            indices = new int[numberOfIndices];
            i = 0;
            while (i < numberOfIndices) {
                indices[i] = (Integer)arrayl.get(i);
                ++i;
            }
        }
        return indices;
    }

    public static int[] indicesOf(String[] array, String value2) {
        int[] indices = null;
        int numberOfIndices = 0;
        ArrayList<Integer> arrayl = new ArrayList<Integer>();
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(value2)) {
                ++numberOfIndices;
                arrayl.add(new Integer(i));
            }
            ++i;
        }
        if (numberOfIndices != 0) {
            indices = new int[numberOfIndices];
            i = 0;
            while (i < numberOfIndices) {
                indices[i] = (Integer)arrayl.get(i);
                ++i;
            }
        }
        return indices;
    }

    public static int[] indicesOf(Object[] array, Object value2) {
        int[] indices = null;
        int numberOfIndices = 0;
        ArrayList<Integer> arrayl = new ArrayList<Integer>();
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(value2)) {
                ++numberOfIndices;
                arrayl.add(new Integer(i));
            }
            ++i;
        }
        if (numberOfIndices != 0) {
            indices = new int[numberOfIndices];
            i = 0;
            while (i < numberOfIndices) {
                indices[i] = (Integer)arrayl.get(i);
                ++i;
            }
        }
        return indices;
    }

    public static int indexOf(double[] array, double value2) {
        int index2 = -1;
        boolean test2 = true;
        int counter = 0;
        while (test2) {
            if (array[counter] == value2) {
                index2 = counter;
                test2 = false;
                continue;
            }
            if (++counter < array.length) continue;
            test2 = false;
        }
        return index2;
    }

    public static int indexOf(float[] array, float value2) {
        int index2 = -1;
        boolean test2 = true;
        int counter = 0;
        while (test2) {
            if (array[counter] == value2) {
                index2 = counter;
                test2 = false;
                continue;
            }
            if (++counter < array.length) continue;
            test2 = false;
        }
        return index2;
    }

    public static int indexOf(long[] array, long value2) {
        int index2 = -1;
        boolean test2 = true;
        int counter = 0;
        while (test2) {
            if (array[counter] == value2) {
                index2 = counter;
                test2 = false;
                continue;
            }
            if (++counter < array.length) continue;
            test2 = false;
        }
        return index2;
    }

    public static int indexOf(int[] array, int value2) {
        int index2 = -1;
        boolean test2 = true;
        int counter = 0;
        while (test2) {
            if (array[counter] == value2) {
                index2 = counter;
                test2 = false;
                continue;
            }
            if (++counter < array.length) continue;
            test2 = false;
        }
        return index2;
    }

    public static int indexOf(byte[] array, byte value2) {
        int index2 = -1;
        boolean test2 = true;
        int counter = 0;
        while (test2) {
            if (array[counter] == value2) {
                index2 = counter;
                test2 = false;
                continue;
            }
            if (++counter < array.length) continue;
            test2 = false;
        }
        return index2;
    }

    public static int indexOf(short[] array, short value2) {
        int index2 = -1;
        boolean test2 = true;
        int counter = 0;
        while (test2) {
            if (array[counter] == value2) {
                index2 = counter;
                test2 = false;
                continue;
            }
            if (++counter < array.length) continue;
            test2 = false;
        }
        return index2;
    }

    public static int indexOf(char[] array, char value2) {
        int index2 = -1;
        boolean test2 = true;
        int counter = 0;
        while (test2) {
            if (array[counter] == value2) {
                index2 = counter;
                test2 = false;
                continue;
            }
            if (++counter < array.length) continue;
            test2 = false;
        }
        return index2;
    }

    public static int indexOf(String[] array, String value2) {
        int index2 = -1;
        boolean test2 = true;
        int counter = 0;
        while (test2) {
            if (array[counter].equals(value2)) {
                index2 = counter;
                test2 = false;
                continue;
            }
            if (++counter < array.length) continue;
            test2 = false;
        }
        return index2;
    }

    public static int indexOf(Object[] array, Object value2) {
        int index2 = -1;
        boolean test2 = true;
        int counter = 0;
        while (test2) {
            if (array[counter].equals(value2)) {
                index2 = counter;
                test2 = false;
                continue;
            }
            if (++counter < array.length) continue;
            test2 = false;
        }
        return index2;
    }

    public static double nearestElementValue(double[] array, double value2) {
        double diff2 = Math.abs(array[0] - value2);
        double nearest = array[0];
        int i = 1;
        while (i < array.length) {
            if (Math.abs(array[i] - value2) < diff2) {
                diff2 = Math.abs(array[i] - value2);
                nearest = array[i];
            }
            ++i;
        }
        return nearest;
    }

    public static int nearestElementIndex(double[] array, double value2) {
        double diff2 = Math.abs(array[0] - value2);
        int nearest = 0;
        int i = 1;
        while (i < array.length) {
            if (Math.abs(array[i] - value2) < diff2) {
                diff2 = Math.abs(array[i] - value2);
                nearest = i;
            }
            ++i;
        }
        return nearest;
    }

    public static double nearestLowerElementValue(double[] array, double value2) {
        double diff0 = 0.0;
        double diff1 = 0.0;
        double nearest = 0.0;
        int ii = 0;
        boolean test2 = true;
        double min2 = array[0];
        while (test2) {
            if (array[ii] < min2) {
                min2 = array[ii];
            }
            if (value2 - array[ii] >= 0.0) {
                diff0 = value2 - array[ii];
                nearest = array[ii];
                test2 = false;
                continue;
            }
            if (++ii <= array.length - 1) continue;
            nearest = min2;
            diff0 = min2 - value2;
            test2 = false;
        }
        int i = 0;
        while (i < array.length) {
            diff1 = value2 - array[i];
            if (diff1 >= 0.0 && diff1 < diff0) {
                diff0 = diff1;
                nearest = array[i];
            }
            ++i;
        }
        return nearest;
    }

    public static int nearestLowerElementIndex(double[] array, double value2) {
        double diff0 = 0.0;
        double diff1 = 0.0;
        int nearest = 0;
        int ii = 0;
        boolean test2 = true;
        double min2 = array[0];
        int minI = 0;
        while (test2) {
            if (array[ii] < min2) {
                min2 = array[ii];
                minI = ii;
            }
            if (value2 - array[ii] >= 0.0) {
                diff0 = value2 - array[ii];
                nearest = ii;
                test2 = false;
                continue;
            }
            if (++ii <= array.length - 1) continue;
            nearest = minI;
            diff0 = min2 - value2;
            test2 = false;
        }
        int i = 0;
        while (i < array.length) {
            diff1 = value2 - array[i];
            if (diff1 >= 0.0 && diff1 < diff0) {
                diff0 = diff1;
                nearest = i;
            }
            ++i;
        }
        return nearest;
    }

    public static double nearestHigherElementValue(double[] array, double value2) {
        double diff0 = 0.0;
        double diff1 = 0.0;
        double nearest = 0.0;
        int ii = 0;
        boolean test2 = true;
        double max2 = array[0];
        while (test2) {
            if (array[ii] > max2) {
                max2 = array[ii];
            }
            if (array[ii] - value2 >= 0.0) {
                diff0 = value2 - array[ii];
                nearest = array[ii];
                test2 = false;
                continue;
            }
            if (++ii <= array.length - 1) continue;
            nearest = max2;
            diff0 = value2 - max2;
            test2 = false;
        }
        int i = 0;
        while (i < array.length) {
            diff1 = array[i] - value2;
            if (diff1 >= 0.0 && diff1 < diff0) {
                diff0 = diff1;
                nearest = array[i];
            }
            ++i;
        }
        return nearest;
    }

    public static int nearestHigherElementIndex(double[] array, double value2) {
        double diff0 = 0.0;
        double diff1 = 0.0;
        int nearest = 0;
        int ii = 0;
        boolean test2 = true;
        double max2 = array[0];
        int maxI = 0;
        while (test2) {
            if (array[ii] > max2) {
                max2 = array[ii];
                maxI = ii;
            }
            if (array[ii] - value2 >= 0.0) {
                diff0 = value2 - array[ii];
                nearest = ii;
                test2 = false;
                continue;
            }
            if (++ii <= array.length - 1) continue;
            nearest = maxI;
            diff0 = value2 - max2;
            test2 = false;
        }
        int i = 0;
        while (i < array.length) {
            diff1 = array[i] - value2;
            if (diff1 >= 0.0 && diff1 < diff0) {
                diff0 = diff1;
                nearest = i;
            }
            ++i;
        }
        return nearest;
    }

    public static int nearestElementValue(int[] array, int value2) {
        int diff2 = Math.abs(array[0] - value2);
        int nearest = array[0];
        int i = 1;
        while (i < array.length) {
            if (Math.abs(array[i] - value2) < diff2) {
                diff2 = Math.abs(array[i] - value2);
                nearest = array[i];
            }
            ++i;
        }
        return nearest;
    }

    public static int nearestElementIndex(int[] array, int value2) {
        int diff2 = Math.abs(array[0] - value2);
        int nearest = 0;
        int i = 1;
        while (i < array.length) {
            if (Math.abs(array[i] - value2) < diff2) {
                diff2 = Math.abs(array[i] - value2);
                nearest = i;
            }
            ++i;
        }
        return nearest;
    }

    public static int nearestLowerElementValue(int[] array, int value2) {
        int diff0 = 0;
        int diff1 = 0;
        int nearest = 0;
        int ii = 0;
        boolean test2 = true;
        int min2 = array[0];
        while (test2) {
            if (array[ii] < min2) {
                min2 = array[ii];
            }
            if (value2 - array[ii] >= 0) {
                diff0 = value2 - array[ii];
                nearest = array[ii];
                test2 = false;
                continue;
            }
            if (++ii <= array.length - 1) continue;
            nearest = min2;
            diff0 = min2 - value2;
            test2 = false;
        }
        int i = 0;
        while (i < array.length) {
            diff1 = value2 - array[i];
            if (diff1 >= 0 && diff1 < diff0) {
                diff0 = diff1;
                nearest = array[i];
            }
            ++i;
        }
        return nearest;
    }

    public static int nearestLowerElementIndex(int[] array, int value2) {
        int diff0 = 0;
        int diff1 = 0;
        int nearest = 0;
        int ii = 0;
        boolean test2 = true;
        int min2 = array[0];
        int minI = 0;
        while (test2) {
            if (array[ii] < min2) {
                min2 = array[ii];
                minI = ii;
            }
            if (value2 - array[ii] >= 0) {
                diff0 = value2 - array[ii];
                nearest = ii;
                test2 = false;
                continue;
            }
            if (++ii <= array.length - 1) continue;
            nearest = minI;
            diff0 = min2 - value2;
            test2 = false;
        }
        int i = 0;
        while (i < array.length) {
            diff1 = value2 - array[i];
            if (diff1 >= 0 && diff1 < diff0) {
                diff0 = diff1;
                nearest = i;
            }
            ++i;
        }
        return nearest;
    }

    public static int nearestHigherElementValue(int[] array, int value2) {
        int diff0 = 0;
        int diff1 = 0;
        int nearest = 0;
        int ii = 0;
        boolean test2 = true;
        int max2 = array[0];
        while (test2) {
            if (array[ii] > max2) {
                max2 = array[ii];
            }
            if (array[ii] - value2 >= 0) {
                diff0 = value2 - array[ii];
                nearest = array[ii];
                test2 = false;
                continue;
            }
            if (++ii <= array.length - 1) continue;
            nearest = max2;
            diff0 = value2 - max2;
            test2 = false;
        }
        int i = 0;
        while (i < array.length) {
            diff1 = array[i] - value2;
            if (diff1 >= 0 && diff1 < diff0) {
                diff0 = diff1;
                nearest = array[i];
            }
            ++i;
        }
        return nearest;
    }

    public static int nearestHigherElementIndex(int[] array, int value2) {
        int diff0 = 0;
        int diff1 = 0;
        int nearest = 0;
        int ii = 0;
        boolean test2 = true;
        int max2 = array[0];
        int maxI = 0;
        while (test2) {
            if (array[ii] > max2) {
                max2 = array[ii];
                maxI = ii;
            }
            if (array[ii] - value2 >= 0) {
                diff0 = value2 - array[ii];
                nearest = ii;
                test2 = false;
                continue;
            }
            if (++ii <= array.length - 1) continue;
            nearest = maxI;
            diff0 = value2 - max2;
            test2 = false;
        }
        int i = 0;
        while (i < array.length) {
            diff1 = array[i] - value2;
            if (diff1 >= 0 && diff1 < diff0) {
                diff0 = diff1;
                nearest = i;
            }
            ++i;
        }
        return nearest;
    }

    public static double arraySum(double[] array) {
        double sum2 = 0.0;
        double[] dArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            double i = dArray[n2];
            sum2 += i;
            ++n2;
        }
        return sum2;
    }

    public static float arraySum(float[] array) {
        float sum2 = 0.0f;
        float[] fArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            float i = fArray[n2];
            sum2 += i;
            ++n2;
        }
        return sum2;
    }

    public static int arraySum(int[] array) {
        int sum2 = 0;
        int[] nArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            sum2 += i;
            ++n2;
        }
        return sum2;
    }

    public static long arraySum(long[] array) {
        long sum2 = 0L;
        long[] lArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            long i = lArray[n2];
            sum2 += i;
            ++n2;
        }
        return sum2;
    }

    public static long arrayPositiveElementsSum(long[] array) {
        long sum2 = 0L;
        long[] lArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            long i = lArray[n2];
            if (i > 0L) {
                sum2 += i;
            }
            ++n2;
        }
        return sum2;
    }

    public static double arrayProduct(double[] array) {
        double product2 = 1.0;
        double[] dArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            double i = dArray[n2];
            product2 *= i;
            ++n2;
        }
        return product2;
    }

    public static float arrayProduct(float[] array) {
        float product2 = 1.0f;
        float[] fArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            float i = fArray[n2];
            product2 *= i;
            ++n2;
        }
        return product2;
    }

    public static int arrayProduct(int[] array) {
        int product2 = 1;
        int[] nArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            product2 *= i;
            ++n2;
        }
        return product2;
    }

    public static long arrayProduct(long[] array) {
        long product2 = 1L;
        long[] lArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            long i = lArray[n2];
            product2 *= i;
            ++n2;
        }
        return product2;
    }

    public static double[] concatenate(double[] aa, double[] bb) {
        int aLen = aa.length;
        int bLen = bb.length;
        int cLen = aLen + bLen;
        double[] cc = new double[cLen];
        int i = 0;
        while (i < aLen) {
            cc[i] = aa[i];
            ++i;
        }
        i = 0;
        while (i < bLen) {
            cc[i + aLen] = bb[i];
            ++i;
        }
        return cc;
    }

    public static float[] concatenate(float[] aa, float[] bb) {
        int aLen = aa.length;
        int bLen = bb.length;
        int cLen = aLen + bLen;
        float[] cc = new float[cLen];
        int i = 0;
        while (i < aLen) {
            cc[i] = aa[i];
            ++i;
        }
        i = 0;
        while (i < bLen) {
            cc[i + aLen] = bb[i];
            ++i;
        }
        return cc;
    }

    public static int[] concatenate(int[] aa, int[] bb) {
        int aLen = aa.length;
        int bLen = bb.length;
        int cLen = aLen + bLen;
        int[] cc = new int[cLen];
        int i = 0;
        while (i < aLen) {
            cc[i] = aa[i];
            ++i;
        }
        i = 0;
        while (i < bLen) {
            cc[i + aLen] = bb[i];
            ++i;
        }
        return cc;
    }

    public static long[] concatenate(long[] aa, long[] bb) {
        int aLen = aa.length;
        int bLen = bb.length;
        int cLen = aLen + bLen;
        long[] cc = new long[cLen];
        int i = 0;
        while (i < aLen) {
            cc[i] = aa[i];
            ++i;
        }
        i = 0;
        while (i < bLen) {
            cc[i + aLen] = bb[i];
            ++i;
        }
        return cc;
    }

    public static short[] concatenate(short[] aa, short[] bb) {
        int aLen = aa.length;
        int bLen = bb.length;
        int cLen = aLen + bLen;
        short[] cc = new short[cLen];
        int i = 0;
        while (i < aLen) {
            cc[i] = aa[i];
            ++i;
        }
        i = 0;
        while (i < bLen) {
            cc[i + aLen] = bb[i];
            ++i;
        }
        return cc;
    }

    public static byte[] concatenate(byte[] aa, byte[] bb) {
        int aLen = aa.length;
        int bLen = bb.length;
        int cLen = aLen + bLen;
        byte[] cc = new byte[cLen];
        int i = 0;
        while (i < aLen) {
            cc[i] = aa[i];
            ++i;
        }
        i = 0;
        while (i < bLen) {
            cc[i + aLen] = bb[i];
            ++i;
        }
        return cc;
    }

    public static char[] concatenate(char[] aa, char[] bb) {
        int aLen = aa.length;
        int bLen = bb.length;
        int cLen = aLen + bLen;
        char[] cc = new char[cLen];
        int i = 0;
        while (i < aLen) {
            cc[i] = aa[i];
            ++i;
        }
        i = 0;
        while (i < bLen) {
            cc[i + aLen] = bb[i];
            ++i;
        }
        return cc;
    }

    public static String[] concatenate(String[] aa, String[] bb) {
        int aLen = aa.length;
        int bLen = bb.length;
        int cLen = aLen + bLen;
        String[] cc = new String[cLen];
        int i = 0;
        while (i < aLen) {
            cc[i] = aa[i];
            ++i;
        }
        i = 0;
        while (i < bLen) {
            cc[i + aLen] = bb[i];
            ++i;
        }
        return cc;
    }

    public static Object[] concatenate(Object[] aa, Object[] bb) {
        int aLen = aa.length;
        int bLen = bb.length;
        int cLen = aLen + bLen;
        Object[] cc = new Object[cLen];
        int i = 0;
        while (i < aLen) {
            cc[i] = aa[i];
            ++i;
        }
        i = 0;
        while (i < bLen) {
            cc[i + aLen] = bb[i];
            ++i;
        }
        return cc;
    }

    public static double[] floatTOdouble(float[] aa) {
        int n = aa.length;
        double[] bb = new double[n];
        int i = 0;
        while (i < n) {
            bb[i] = aa[i];
            ++i;
        }
        return bb;
    }

    public static double[] intTOdouble(int[] aa) {
        int n = aa.length;
        double[] bb = new double[n];
        int i = 0;
        while (i < n) {
            bb[i] = aa[i];
            ++i;
        }
        return bb;
    }

    public static float[] intTOfloat(int[] aa) {
        int n = aa.length;
        float[] bb = new float[n];
        int i = 0;
        while (i < n) {
            bb[i] = aa[i];
            ++i;
        }
        return bb;
    }

    public static long[] intTOlong(int[] aa) {
        int n = aa.length;
        long[] bb = new long[n];
        int i = 0;
        while (i < n) {
            bb[i] = aa[i];
            ++i;
        }
        return bb;
    }

    public static double[] longTOdouble(long[] aa) {
        int n = aa.length;
        double[] bb = new double[n];
        int i = 0;
        while (i < n) {
            bb[i] = aa[i];
            ++i;
        }
        return bb;
    }

    public static float[] longTOfloat(long[] aa) {
        int n = aa.length;
        float[] bb = new float[n];
        int i = 0;
        while (i < n) {
            bb[i] = aa[i];
            ++i;
        }
        return bb;
    }

    public static double[] shortTOdouble(short[] aa) {
        int n = aa.length;
        double[] bb = new double[n];
        int i = 0;
        while (i < n) {
            bb[i] = aa[i];
            ++i;
        }
        return bb;
    }

    public static float[] shortTOfloat(short[] aa) {
        int n = aa.length;
        float[] bb = new float[n];
        int i = 0;
        while (i < n) {
            bb[i] = aa[i];
            ++i;
        }
        return bb;
    }

    public static long[] shortTOlong(short[] aa) {
        int n = aa.length;
        long[] bb = new long[n];
        int i = 0;
        while (i < n) {
            bb[i] = aa[i];
            ++i;
        }
        return bb;
    }

    public static int[] shortTOint(short[] aa) {
        int n = aa.length;
        int[] bb = new int[n];
        int i = 0;
        while (i < n) {
            bb[i] = aa[i];
            ++i;
        }
        return bb;
    }

    public static double[] byteTOdouble(byte[] aa) {
        int n = aa.length;
        double[] bb = new double[n];
        int i = 0;
        while (i < n) {
            bb[i] = aa[i];
            ++i;
        }
        return bb;
    }

    public static float[] byteTOfloat(byte[] aa) {
        int n = aa.length;
        float[] bb = new float[n];
        int i = 0;
        while (i < n) {
            bb[i] = aa[i];
            ++i;
        }
        return bb;
    }

    public static long[] byteTOlong(byte[] aa) {
        int n = aa.length;
        long[] bb = new long[n];
        int i = 0;
        while (i < n) {
            bb[i] = aa[i];
            ++i;
        }
        return bb;
    }

    public static int[] byteTOint(byte[] aa) {
        int n = aa.length;
        int[] bb = new int[n];
        int i = 0;
        while (i < n) {
            bb[i] = aa[i];
            ++i;
        }
        return bb;
    }

    public static short[] byteTOshort(byte[] aa) {
        int n = aa.length;
        short[] bb = new short[n];
        int i = 0;
        while (i < n) {
            bb[i] = aa[i];
            ++i;
        }
        return bb;
    }

    public static int[] doubleTOint(double[] aa) {
        int n = aa.length;
        int[] bb = new int[n];
        int i = 0;
        while (i < n) {
            bb[i] = (int)aa[i];
            ++i;
        }
        return bb;
    }

    public static void print(double[] aa) {
        int i = 0;
        while (i < aa.length) {
            System.out.print(String.valueOf(aa[i]) + "   ");
            ++i;
        }
        System.out.println();
    }

    public static void println(double[] aa) {
        int i = 0;
        while (i < aa.length) {
            System.out.println(String.valueOf(aa[i]) + "   ");
            ++i;
        }
    }

    public static void print(float[] aa) {
        int i = 0;
        while (i < aa.length) {
            System.out.print(String.valueOf(aa[i]) + "   ");
            ++i;
        }
        System.out.println();
    }

    public static void println(float[] aa) {
        int i = 0;
        while (i < aa.length) {
            System.out.println(String.valueOf(aa[i]) + "   ");
            ++i;
        }
    }

    public static void print(int[] aa) {
        int i = 0;
        while (i < aa.length) {
            System.out.print(String.valueOf(aa[i]) + "   ");
            ++i;
        }
        System.out.println();
    }

    public static void println(int[] aa) {
        int i = 0;
        while (i < aa.length) {
            System.out.println(String.valueOf(aa[i]) + "   ");
            ++i;
        }
    }

    public static void print(long[] aa) {
        int i = 0;
        while (i < aa.length) {
            System.out.print(String.valueOf(aa[i]) + "   ");
            ++i;
        }
        System.out.println();
    }

    public static void println(long[] aa) {
        int i = 0;
        while (i < aa.length) {
            System.out.println(String.valueOf(aa[i]) + "   ");
            ++i;
        }
    }

    public static void print(char[] aa) {
        int i = 0;
        while (i < aa.length) {
            System.out.print(String.valueOf(aa[i]) + "   ");
            ++i;
        }
        System.out.println();
    }

    public static void println(char[] aa) {
        int i = 0;
        while (i < aa.length) {
            System.out.println(String.valueOf(aa[i]) + "   ");
            ++i;
        }
    }

    public static void print(String[] aa) {
        int i = 0;
        while (i < aa.length) {
            System.out.print(String.valueOf(aa[i]) + "   ");
            ++i;
        }
        System.out.println();
    }

    public static void println(String[] aa) {
        int i = 0;
        while (i < aa.length) {
            System.out.println(String.valueOf(aa[i]) + "   ");
            ++i;
        }
    }

    public static void print(short[] aa) {
        int i = 0;
        while (i < aa.length) {
            System.out.print(String.valueOf(aa[i]) + "   ");
            ++i;
        }
        System.out.println();
    }

    public static void println(short[] aa) {
        int i = 0;
        while (i < aa.length) {
            System.out.println(String.valueOf(aa[i]) + "   ");
            ++i;
        }
    }

    public static void print(byte[] aa) {
        int i = 0;
        while (i < aa.length) {
            System.out.print(String.valueOf(aa[i]) + "   ");
            ++i;
        }
        System.out.println();
    }

    public static void println(byte[] aa) {
        int i = 0;
        while (i < aa.length) {
            System.out.println(String.valueOf(aa[i]) + "   ");
            ++i;
        }
    }

    public static void print(double[][] aa) {
        int i = 0;
        while (i < aa.length) {
            Fmath.print(aa[i]);
            ++i;
        }
    }

    public static Vector<Object> selectSortVector(double[] aa) {
        ArrayList<Object> list2 = Fmath.selectSortArrayList(aa);
        Vector<Object> ret = null;
        if (list2 != null) {
            int n = list2.size();
            ret = new Vector<Object>(n);
            int i = 0;
            while (i < n) {
                ret.addElement(list2.get(i));
                ++i;
            }
        }
        return ret;
    }

    public static ArrayList<Object> selectSortArrayList(double[] aa) {
        int index2 = 0;
        int lastIndex = -1;
        int n = aa.length;
        double holdb = 0.0;
        int holdi = 0;
        double[] bb = new double[n];
        int[] indices = new int[n];
        int i = 0;
        while (i < n) {
            bb[i] = aa[i];
            indices[i] = i;
            ++i;
        }
        while (lastIndex != n - 1) {
            index2 = lastIndex + 1;
            i = lastIndex + 2;
            while (i < n) {
                if (bb[i] < bb[index2]) {
                    index2 = i;
                }
                ++i;
            }
            holdb = bb[index2];
            bb[index2] = bb[++lastIndex];
            bb[lastIndex] = holdb;
            holdi = indices[index2];
            indices[index2] = indices[lastIndex];
            indices[lastIndex] = holdi;
        }
        ArrayList<Object> arrayl = new ArrayList<Object>();
        arrayl.add(aa);
        arrayl.add(bb);
        arrayl.add(indices);
        return arrayl;
    }

    public static double[] selectionSort(double[] aa) {
        int index2 = 0;
        int lastIndex = -1;
        int n = aa.length;
        double hold = 0.0;
        double[] bb = new double[n];
        int i = 0;
        while (i < n) {
            bb[i] = aa[i];
            ++i;
        }
        while (lastIndex != n - 1) {
            index2 = lastIndex + 1;
            i = lastIndex + 2;
            while (i < n) {
                if (bb[i] < bb[index2]) {
                    index2 = i;
                }
                ++i;
            }
            hold = bb[index2];
            bb[index2] = bb[++lastIndex];
            bb[lastIndex] = hold;
        }
        return bb;
    }

    public static float[] selectionSort(float[] aa) {
        int index2 = 0;
        int lastIndex = -1;
        int n = aa.length;
        float hold = 0.0f;
        float[] bb = new float[n];
        int i = 0;
        while (i < n) {
            bb[i] = aa[i];
            ++i;
        }
        while (lastIndex != n - 1) {
            index2 = lastIndex + 1;
            i = lastIndex + 2;
            while (i < n) {
                if (bb[i] < bb[index2]) {
                    index2 = i;
                }
                ++i;
            }
            hold = bb[index2];
            bb[index2] = bb[++lastIndex];
            bb[lastIndex] = hold;
        }
        return bb;
    }

    public static int[] selectionSort(int[] aa) {
        int index2 = 0;
        int lastIndex = -1;
        int n = aa.length;
        int hold = 0;
        int[] bb = new int[n];
        int i = 0;
        while (i < n) {
            bb[i] = aa[i];
            ++i;
        }
        while (lastIndex != n - 1) {
            index2 = lastIndex + 1;
            i = lastIndex + 2;
            while (i < n) {
                if (bb[i] < bb[index2]) {
                    index2 = i;
                }
                ++i;
            }
            hold = bb[index2];
            bb[index2] = bb[++lastIndex];
            bb[lastIndex] = hold;
        }
        return bb;
    }

    public static long[] selectionSort(long[] aa) {
        int index2 = 0;
        int lastIndex = -1;
        int n = aa.length;
        long hold = 0L;
        long[] bb = new long[n];
        int i = 0;
        while (i < n) {
            bb[i] = aa[i];
            ++i;
        }
        while (lastIndex != n - 1) {
            index2 = lastIndex + 1;
            i = lastIndex + 2;
            while (i < n) {
                if (bb[i] < bb[index2]) {
                    index2 = i;
                }
                ++i;
            }
            hold = bb[index2];
            bb[index2] = bb[++lastIndex];
            bb[lastIndex] = hold;
        }
        return bb;
    }

    public static void selectionSort(double[] aa, double[] bb, int[] indices) {
        int index2 = 0;
        int lastIndex = -1;
        int n = aa.length;
        double holdb = 0.0;
        int holdi = 0;
        int i = 0;
        while (i < n) {
            bb[i] = aa[i];
            indices[i] = i;
            ++i;
        }
        while (lastIndex != n - 1) {
            index2 = lastIndex + 1;
            i = lastIndex + 2;
            while (i < n) {
                if (bb[i] < bb[index2]) {
                    index2 = i;
                }
                ++i;
            }
            holdb = bb[index2];
            bb[index2] = bb[++lastIndex];
            bb[lastIndex] = holdb;
            holdi = indices[index2];
            indices[index2] = indices[lastIndex];
            indices[lastIndex] = holdi;
        }
    }

    public static void selectionSort(double[] aa, double[] bb, double[] cc, double[] dd) {
        int index2 = 0;
        int lastIndex = -1;
        int n = aa.length;
        int m = bb.length;
        if (n != m) {
            throw new IllegalArgumentException("First argument array, aa, (length = " + n + ") and the second argument array, bb, (length = " + m + ") should be the same length");
        }
        int nn = cc.length;
        if (nn < n) {
            throw new IllegalArgumentException("The third argument array, cc, (length = " + nn + ") should be at least as long as the first argument array, aa, (length = " + n + ")");
        }
        int mm = dd.length;
        if (mm < m) {
            throw new IllegalArgumentException("The fourth argument array, dd, (length = " + mm + ") should be at least as long as the second argument array, bb, (length = " + m + ")");
        }
        double holdx = 0.0;
        double holdy = 0.0;
        int i = 0;
        while (i < n) {
            cc[i] = aa[i];
            dd[i] = bb[i];
            ++i;
        }
        while (lastIndex != n - 1) {
            index2 = lastIndex + 1;
            i = lastIndex + 2;
            while (i < n) {
                if (cc[i] < cc[index2]) {
                    index2 = i;
                }
                ++i;
            }
            holdx = cc[index2];
            cc[index2] = cc[++lastIndex];
            cc[lastIndex] = holdx;
            holdy = dd[index2];
            dd[index2] = dd[lastIndex];
            dd[lastIndex] = holdy;
        }
    }

    public static void selectionSort(float[] aa, float[] bb, float[] cc, float[] dd) {
        int index2 = 0;
        int lastIndex = -1;
        int n = aa.length;
        int m = bb.length;
        if (n != m) {
            throw new IllegalArgumentException("First argument array, aa, (length = " + n + ") and the second argument array, bb, (length = " + m + ") should be the same length");
        }
        int nn = cc.length;
        if (nn < n) {
            throw new IllegalArgumentException("The third argument array, cc, (length = " + nn + ") should be at least as long as the first argument array, aa, (length = " + n + ")");
        }
        int mm = dd.length;
        if (mm < m) {
            throw new IllegalArgumentException("The fourth argument array, dd, (length = " + mm + ") should be at least as long as the second argument array, bb, (length = " + m + ")");
        }
        float holdx = 0.0f;
        float holdy = 0.0f;
        int i = 0;
        while (i < n) {
            cc[i] = aa[i];
            dd[i] = bb[i];
            ++i;
        }
        while (lastIndex != n - 1) {
            index2 = lastIndex + 1;
            i = lastIndex + 2;
            while (i < n) {
                if (cc[i] < cc[index2]) {
                    index2 = i;
                }
                ++i;
            }
            holdx = cc[index2];
            cc[index2] = cc[++lastIndex];
            cc[lastIndex] = holdx;
            holdy = dd[index2];
            dd[index2] = dd[lastIndex];
            dd[lastIndex] = holdy;
        }
    }

    public static void selectionSort(long[] aa, long[] bb, long[] cc, long[] dd) {
        int index2 = 0;
        int lastIndex = -1;
        int n = aa.length;
        int m = bb.length;
        if (n != m) {
            throw new IllegalArgumentException("First argument array, aa, (length = " + n + ") and the second argument array, bb, (length = " + m + ") should be the same length");
        }
        int nn = cc.length;
        if (nn < n) {
            throw new IllegalArgumentException("The third argument array, cc, (length = " + nn + ") should be at least as long as the first argument array, aa, (length = " + n + ")");
        }
        int mm = dd.length;
        if (mm < m) {
            throw new IllegalArgumentException("The fourth argument array, dd, (length = " + mm + ") should be at least as long as the second argument array, bb, (length = " + m + ")");
        }
        long holdx = 0L;
        long holdy = 0L;
        int i = 0;
        while (i < n) {
            cc[i] = aa[i];
            dd[i] = bb[i];
            ++i;
        }
        while (lastIndex != n - 1) {
            index2 = lastIndex + 1;
            i = lastIndex + 2;
            while (i < n) {
                if (cc[i] < cc[index2]) {
                    index2 = i;
                }
                ++i;
            }
            holdx = cc[index2];
            cc[index2] = cc[++lastIndex];
            cc[lastIndex] = holdx;
            holdy = dd[index2];
            dd[index2] = dd[lastIndex];
            dd[lastIndex] = holdy;
        }
    }

    public static void selectionSort(int[] aa, int[] bb, int[] cc, int[] dd) {
        int index2 = 0;
        int lastIndex = -1;
        int n = aa.length;
        int m = bb.length;
        if (n != m) {
            throw new IllegalArgumentException("First argument array, aa, (length = " + n + ") and the second argument array, bb, (length = " + m + ") should be the same length");
        }
        int nn = cc.length;
        if (nn < n) {
            throw new IllegalArgumentException("The third argument array, cc, (length = " + nn + ") should be at least as long as the first argument array, aa, (length = " + n + ")");
        }
        int mm = dd.length;
        if (mm < m) {
            throw new IllegalArgumentException("The fourth argument array, dd, (length = " + mm + ") should be at least as long as the second argument array, bb, (length = " + m + ")");
        }
        int holdx = 0;
        int holdy = 0;
        int i = 0;
        while (i < n) {
            cc[i] = aa[i];
            dd[i] = bb[i];
            ++i;
        }
        while (lastIndex != n - 1) {
            index2 = lastIndex + 1;
            i = lastIndex + 2;
            while (i < n) {
                if (cc[i] < cc[index2]) {
                    index2 = i;
                }
                ++i;
            }
            holdx = cc[index2];
            cc[index2] = cc[++lastIndex];
            cc[lastIndex] = holdx;
            holdy = dd[index2];
            dd[index2] = dd[lastIndex];
            dd[lastIndex] = holdy;
        }
    }

    public static void selectionSort(double[] aa, long[] bb, double[] cc, long[] dd) {
        int index2 = 0;
        int lastIndex = -1;
        int n = aa.length;
        int m = bb.length;
        if (n != m) {
            throw new IllegalArgumentException("First argument array, aa, (length = " + n + ") and the second argument array, bb, (length = " + m + ") should be the same length");
        }
        int nn = cc.length;
        if (nn < n) {
            throw new IllegalArgumentException("The third argument array, cc, (length = " + nn + ") should be at least as long as the first argument array, aa, (length = " + n + ")");
        }
        int mm = dd.length;
        if (mm < m) {
            throw new IllegalArgumentException("The fourth argument array, dd, (length = " + mm + ") should be at least as long as the second argument array, bb, (length = " + m + ")");
        }
        double holdx = 0.0;
        long holdy = 0L;
        int i = 0;
        while (i < n) {
            cc[i] = aa[i];
            dd[i] = bb[i];
            ++i;
        }
        while (lastIndex != n - 1) {
            index2 = lastIndex + 1;
            i = lastIndex + 2;
            while (i < n) {
                if (cc[i] < cc[index2]) {
                    index2 = i;
                }
                ++i;
            }
            holdx = cc[index2];
            cc[index2] = cc[++lastIndex];
            cc[lastIndex] = holdx;
            holdy = dd[index2];
            dd[index2] = dd[lastIndex];
            dd[lastIndex] = holdy;
        }
    }

    public static void selectionSort(long[] aa, double[] bb, long[] cc, double[] dd) {
        int index2 = 0;
        int lastIndex = -1;
        int n = aa.length;
        int m = bb.length;
        if (n != m) {
            throw new IllegalArgumentException("First argument array, aa, (length = " + n + ") and the second argument array, bb, (length = " + m + ") should be the same length");
        }
        int nn = cc.length;
        if (nn < n) {
            throw new IllegalArgumentException("The third argument array, cc, (length = " + nn + ") should be at least as long as the first argument array, aa, (length = " + n + ")");
        }
        int mm = dd.length;
        if (mm < m) {
            throw new IllegalArgumentException("The fourth argument array, dd, (length = " + mm + ") should be at least as long as the second argument array, bb, (length = " + m + ")");
        }
        long holdx = 0L;
        double holdy = 0.0;
        int i = 0;
        while (i < n) {
            cc[i] = aa[i];
            dd[i] = bb[i];
            ++i;
        }
        while (lastIndex != n - 1) {
            index2 = lastIndex + 1;
            i = lastIndex + 2;
            while (i < n) {
                if (cc[i] < cc[index2]) {
                    index2 = i;
                }
                ++i;
            }
            holdx = cc[index2];
            cc[index2] = cc[++lastIndex];
            cc[lastIndex] = holdx;
            holdy = dd[index2];
            dd[index2] = dd[lastIndex];
            dd[lastIndex] = holdy;
        }
    }

    public static void selectionSort(double[] aa, int[] bb, double[] cc, int[] dd) {
        int index2 = 0;
        int lastIndex = -1;
        int n = aa.length;
        int m = bb.length;
        if (n != m) {
            throw new IllegalArgumentException("First argument array, aa, (length = " + n + ") and the second argument array, bb, (length = " + m + ") should be the same length");
        }
        int nn = cc.length;
        if (nn < n) {
            throw new IllegalArgumentException("The third argument array, cc, (length = " + nn + ") should be at least as long as the first argument array, aa, (length = " + n + ")");
        }
        int mm = dd.length;
        if (mm < m) {
            throw new IllegalArgumentException("The fourth argument array, dd, (length = " + mm + ") should be at least as long as the second argument array, bb, (length = " + m + ")");
        }
        double holdx = 0.0;
        int holdy = 0;
        int i = 0;
        while (i < n) {
            cc[i] = aa[i];
            dd[i] = bb[i];
            ++i;
        }
        while (lastIndex != n - 1) {
            index2 = lastIndex + 1;
            i = lastIndex + 2;
            while (i < n) {
                if (cc[i] < cc[index2]) {
                    index2 = i;
                }
                ++i;
            }
            holdx = cc[index2];
            cc[index2] = cc[++lastIndex];
            cc[lastIndex] = holdx;
            holdy = dd[index2];
            dd[index2] = dd[lastIndex];
            dd[lastIndex] = holdy;
        }
    }

    public static void selectionSort(int[] aa, double[] bb, int[] cc, double[] dd) {
        int index2 = 0;
        int lastIndex = -1;
        int n = aa.length;
        int m = bb.length;
        if (n != m) {
            throw new IllegalArgumentException("First argument array, aa, (length = " + n + ") and the second argument array, bb, (length = " + m + ") should be the same length");
        }
        int nn = cc.length;
        if (nn < n) {
            throw new IllegalArgumentException("The third argument array, cc, (length = " + nn + ") should be at least as long as the first argument array, aa, (length = " + n + ")");
        }
        int mm = dd.length;
        if (mm < m) {
            throw new IllegalArgumentException("The fourth argument array, dd, (length = " + mm + ") should be at least as long as the second argument array, bb, (length = " + m + ")");
        }
        int holdx = 0;
        double holdy = 0.0;
        int i = 0;
        while (i < n) {
            cc[i] = aa[i];
            dd[i] = bb[i];
            ++i;
        }
        while (lastIndex != n - 1) {
            index2 = lastIndex + 1;
            i = lastIndex + 2;
            while (i < n) {
                if (cc[i] < cc[index2]) {
                    index2 = i;
                }
                ++i;
            }
            holdx = cc[index2];
            cc[index2] = cc[++lastIndex];
            cc[lastIndex] = holdx;
            holdy = dd[index2];
            dd[index2] = dd[lastIndex];
            dd[lastIndex] = holdy;
        }
    }

    public static void selectionSort(long[] aa, int[] bb, long[] cc, int[] dd) {
        int index2 = 0;
        int lastIndex = -1;
        int n = aa.length;
        int m = bb.length;
        if (n != m) {
            throw new IllegalArgumentException("First argument array, aa, (length = " + n + ") and the second argument array, bb, (length = " + m + ") should be the same length");
        }
        int nn = cc.length;
        if (nn < n) {
            throw new IllegalArgumentException("The third argument array, cc, (length = " + nn + ") should be at least as long as the first argument array, aa, (length = " + n + ")");
        }
        int mm = dd.length;
        if (mm < m) {
            throw new IllegalArgumentException("The fourth argument array, dd, (length = " + mm + ") should be at least as long as the second argument array, bb, (length = " + m + ")");
        }
        long holdx = 0L;
        int holdy = 0;
        int i = 0;
        while (i < n) {
            cc[i] = aa[i];
            dd[i] = bb[i];
            ++i;
        }
        while (lastIndex != n - 1) {
            index2 = lastIndex + 1;
            i = lastIndex + 2;
            while (i < n) {
                if (cc[i] < cc[index2]) {
                    index2 = i;
                }
                ++i;
            }
            holdx = cc[index2];
            cc[index2] = cc[++lastIndex];
            cc[lastIndex] = holdx;
            holdy = dd[index2];
            dd[index2] = dd[lastIndex];
            dd[lastIndex] = holdy;
        }
    }

    public static void selectionSort(int[] aa, long[] bb, int[] cc, long[] dd) {
        int index2 = 0;
        int lastIndex = -1;
        int n = aa.length;
        int m = bb.length;
        if (n != m) {
            throw new IllegalArgumentException("First argument array, aa, (length = " + n + ") and the second argument array, bb, (length = " + m + ") should be the same length");
        }
        int nn = cc.length;
        if (nn < n) {
            throw new IllegalArgumentException("The third argument array, cc, (length = " + nn + ") should be at least as long as the first argument array, aa, (length = " + n + ")");
        }
        int mm = dd.length;
        if (mm < m) {
            throw new IllegalArgumentException("The fourth argument array, dd, (length = " + mm + ") should be at least as long as the second argument array, bb, (length = " + m + ")");
        }
        int holdx = 0;
        long holdy = 0L;
        int i = 0;
        while (i < n) {
            cc[i] = aa[i];
            dd[i] = bb[i];
            ++i;
        }
        while (lastIndex != n - 1) {
            index2 = lastIndex + 1;
            i = lastIndex + 2;
            while (i < n) {
                if (cc[i] < cc[index2]) {
                    index2 = i;
                }
                ++i;
            }
            holdx = cc[index2];
            cc[index2] = cc[++lastIndex];
            cc[lastIndex] = holdx;
            holdy = dd[index2];
            dd[index2] = dd[lastIndex];
            dd[lastIndex] = holdy;
        }
    }

    public static void selectSort(double[] aa, double[] bb, int[] indices) {
        int index2 = 0;
        int lastIndex = -1;
        int m = bb.length;
        int n = aa.length;
        if (m < n) {
            throw new IllegalArgumentException("The second argument array, bb, (length = " + m + ") should be at least as long as the first argument array, aa, (length = " + n + ")");
        }
        int k = indices.length;
        if (m < n) {
            throw new IllegalArgumentException("The third argument array, indices, (length = " + k + ") should be at least as long as the first argument array, aa, (length = " + n + ")");
        }
        double holdb = 0.0;
        int holdi = 0;
        int i = 0;
        while (i < n) {
            bb[i] = aa[i];
            indices[i] = i;
            ++i;
        }
        while (lastIndex != n - 1) {
            index2 = lastIndex + 1;
            i = lastIndex + 2;
            while (i < n) {
                if (bb[i] < bb[index2]) {
                    index2 = i;
                }
                ++i;
            }
            holdb = bb[index2];
            bb[index2] = bb[++lastIndex];
            bb[lastIndex] = holdb;
            holdi = indices[index2];
            indices[index2] = indices[lastIndex];
            indices[lastIndex] = holdi;
        }
    }

    public static double[] copy(double[] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        double[] copy = new double[n];
        int i = 0;
        while (i < n) {
            copy[i] = array[i];
            ++i;
        }
        return copy;
    }

    public static float[] copy(float[] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        float[] copy = new float[n];
        int i = 0;
        while (i < n) {
            copy[i] = array[i];
            ++i;
        }
        return copy;
    }

    public static int[] copy(int[] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        int[] copy = new int[n];
        int i = 0;
        while (i < n) {
            copy[i] = array[i];
            ++i;
        }
        return copy;
    }

    public static long[] copy(long[] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        long[] copy = new long[n];
        int i = 0;
        while (i < n) {
            copy[i] = array[i];
            ++i;
        }
        return copy;
    }

    public static double[][] copy(double[][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        double[][] copy = new double[n][];
        int i = 0;
        while (i < n) {
            int m = array[i].length;
            copy[i] = new double[m];
            int j = 0;
            while (j < m) {
                copy[i][j] = array[i][j];
                ++j;
            }
            ++i;
        }
        return copy;
    }

    public static float[][] copy(float[][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        float[][] copy = new float[n][];
        int i = 0;
        while (i < n) {
            int m = array[i].length;
            copy[i] = new float[m];
            int j = 0;
            while (j < m) {
                copy[i][j] = array[i][j];
                ++j;
            }
            ++i;
        }
        return copy;
    }

    public static int[][] copy(int[][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        int[][] copy = new int[n][];
        int i = 0;
        while (i < n) {
            int m = array[i].length;
            copy[i] = new int[m];
            int j = 0;
            while (j < m) {
                copy[i][j] = array[i][j];
                ++j;
            }
            ++i;
        }
        return copy;
    }

    public static long[][] copy(long[][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        long[][] copy = new long[n][];
        int i = 0;
        while (i < n) {
            int m = array[i].length;
            copy[i] = new long[m];
            int j = 0;
            while (j < m) {
                copy[i][j] = array[i][j];
                ++j;
            }
            ++i;
        }
        return copy;
    }

    public static double[][][] copy(double[][][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        double[][][] copy = new double[n][][];
        int i = 0;
        while (i < n) {
            int m = array[i].length;
            copy[i] = new double[m][];
            int j = 0;
            while (j < m) {
                int l = array[i][j].length;
                copy[i][j] = new double[l];
                int k = 0;
                while (k < l) {
                    copy[i][j][k] = array[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return copy;
    }

    public static float[][][] copy(float[][][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        float[][][] copy = new float[n][][];
        int i = 0;
        while (i < n) {
            int m = array[i].length;
            copy[i] = new float[m][];
            int j = 0;
            while (j < m) {
                int l = array[i][j].length;
                copy[i][j] = new float[l];
                int k = 0;
                while (k < l) {
                    copy[i][j][k] = array[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return copy;
    }

    public static int[][][] copy(int[][][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        int[][][] copy = new int[n][][];
        int i = 0;
        while (i < n) {
            int m = array[i].length;
            copy[i] = new int[m][];
            int j = 0;
            while (j < m) {
                int l = array[i][j].length;
                copy[i][j] = new int[l];
                int k = 0;
                while (k < l) {
                    copy[i][j][k] = array[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return copy;
    }

    public static long[][][] copy(long[][][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        long[][][] copy = new long[n][][];
        int i = 0;
        while (i < n) {
            int m = array[i].length;
            copy[i] = new long[m][];
            int j = 0;
            while (j < m) {
                int l = array[i][j].length;
                copy[i][j] = new long[l];
                int k = 0;
                while (k < l) {
                    copy[i][j][k] = array[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return copy;
    }

    public static double[][][][] copy(double[][][][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        double[][][][] copy = new double[n][][][];
        int i = 0;
        while (i < n) {
            int m = array[i].length;
            copy[i] = new double[m][][];
            int j = 0;
            while (j < m) {
                int l = array[i][j].length;
                copy[i][j] = new double[l][];
                int k = 0;
                while (k < l) {
                    int ll = array[i][j][k].length;
                    copy[i][j][k] = new double[ll];
                    int kk = 0;
                    while (kk < ll) {
                        copy[i][j][k][kk] = array[i][j][k][kk];
                        ++kk;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return copy;
    }

    public static float[][][][] copy(float[][][][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        float[][][][] copy = new float[n][][][];
        int i = 0;
        while (i < n) {
            int m = array[i].length;
            copy[i] = new float[m][][];
            int j = 0;
            while (j < m) {
                int l = array[i][j].length;
                copy[i][j] = new float[l][];
                int k = 0;
                while (k < l) {
                    int ll = array[i][j][k].length;
                    copy[i][j][k] = new float[ll];
                    int kk = 0;
                    while (kk < ll) {
                        copy[i][j][k][kk] = array[i][j][k][kk];
                        ++kk;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return copy;
    }

    public static int[][][][] copy(int[][][][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        int[][][][] copy = new int[n][][][];
        int i = 0;
        while (i < n) {
            int m = array[i].length;
            copy[i] = new int[m][][];
            int j = 0;
            while (j < m) {
                int l = array[i][j].length;
                copy[i][j] = new int[l][];
                int k = 0;
                while (k < l) {
                    int ll = array[i][j][k].length;
                    copy[i][j][k] = new int[ll];
                    int kk = 0;
                    while (kk < ll) {
                        copy[i][j][k][kk] = array[i][j][k][kk];
                        ++kk;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return copy;
    }

    public static long[][][][] copy(long[][][][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        long[][][][] copy = new long[n][][][];
        int i = 0;
        while (i < n) {
            int m = array[i].length;
            copy[i] = new long[m][][];
            int j = 0;
            while (j < m) {
                int l = array[i][j].length;
                copy[i][j] = new long[l][];
                int k = 0;
                while (k < l) {
                    int ll = array[i][j][k].length;
                    copy[i][j][k] = new long[ll];
                    int kk = 0;
                    while (kk < ll) {
                        copy[i][j][k][kk] = array[i][j][k][kk];
                        ++kk;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return copy;
    }

    public static String[] copy(String[] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        String[] copy = new String[n];
        int i = 0;
        while (i < n) {
            copy[i] = array[i];
            ++i;
        }
        return copy;
    }

    public static String[][] copy(String[][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        String[][] copy = new String[n][];
        int i = 0;
        while (i < n) {
            int m = array[i].length;
            copy[i] = new String[m];
            int j = 0;
            while (j < m) {
                copy[i][j] = array[i][j];
                ++j;
            }
            ++i;
        }
        return copy;
    }

    public static String[][][] copy(String[][][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        String[][][] copy = new String[n][][];
        int i = 0;
        while (i < n) {
            int m = array[i].length;
            copy[i] = new String[m][];
            int j = 0;
            while (j < m) {
                int l = array[i][j].length;
                copy[i][j] = new String[l];
                int k = 0;
                while (k < l) {
                    copy[i][j][k] = array[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return copy;
    }

    public static String[][][][] copy(String[][][][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        String[][][][] copy = new String[n][][][];
        int i = 0;
        while (i < n) {
            int m = array[i].length;
            copy[i] = new String[m][][];
            int j = 0;
            while (j < m) {
                int l = array[i][j].length;
                copy[i][j] = new String[l][];
                int k = 0;
                while (k < l) {
                    int ll = array[i][j][k].length;
                    copy[i][j][k] = new String[ll];
                    int kk = 0;
                    while (kk < ll) {
                        copy[i][j][k][kk] = array[i][j][k][kk];
                        ++kk;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return copy;
    }

    public static boolean[] copy(boolean[] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        boolean[] copy = new boolean[n];
        int i = 0;
        while (i < n) {
            copy[i] = array[i];
            ++i;
        }
        return copy;
    }

    public static boolean[][] copy(boolean[][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        boolean[][] copy = new boolean[n][];
        int i = 0;
        while (i < n) {
            int m = array[i].length;
            copy[i] = new boolean[m];
            int j = 0;
            while (j < m) {
                copy[i][j] = array[i][j];
                ++j;
            }
            ++i;
        }
        return copy;
    }

    public static boolean[][][] copy(boolean[][][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        boolean[][][] copy = new boolean[n][][];
        int i = 0;
        while (i < n) {
            int m = array[i].length;
            copy[i] = new boolean[m][];
            int j = 0;
            while (j < m) {
                int l = array[i][j].length;
                copy[i][j] = new boolean[l];
                int k = 0;
                while (k < l) {
                    copy[i][j][k] = array[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return copy;
    }

    public static boolean[][][][] copy(boolean[][][][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        boolean[][][][] copy = new boolean[n][][][];
        int i = 0;
        while (i < n) {
            int m = array[i].length;
            copy[i] = new boolean[m][][];
            int j = 0;
            while (j < m) {
                int l = array[i][j].length;
                copy[i][j] = new boolean[l][];
                int k = 0;
                while (k < l) {
                    int ll = array[i][j][k].length;
                    copy[i][j][k] = new boolean[ll];
                    int kk = 0;
                    while (kk < ll) {
                        copy[i][j][k][kk] = array[i][j][k][kk];
                        ++kk;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return copy;
    }

    public static char[] copy(char[] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        char[] copy = new char[n];
        int i = 0;
        while (i < n) {
            copy[i] = array[i];
            ++i;
        }
        return copy;
    }

    public static char[][] copy(char[][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        char[][] copy = new char[n][];
        int i = 0;
        while (i < n) {
            int m = array[i].length;
            copy[i] = new char[m];
            int j = 0;
            while (j < m) {
                copy[i][j] = array[i][j];
                ++j;
            }
            ++i;
        }
        return copy;
    }

    public static char[][][] copy(char[][][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        char[][][] copy = new char[n][][];
        int i = 0;
        while (i < n) {
            int m = array[i].length;
            copy[i] = new char[m][];
            int j = 0;
            while (j < m) {
                int l = array[i][j].length;
                copy[i][j] = new char[l];
                int k = 0;
                while (k < l) {
                    copy[i][j][k] = array[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return copy;
    }

    public static char[][][][] copy(char[][][][] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        char[][][][] copy = new char[n][][][];
        int i = 0;
        while (i < n) {
            int m = array[i].length;
            copy[i] = new char[m][][];
            int j = 0;
            while (j < m) {
                int l = array[i][j].length;
                copy[i][j] = new char[l][];
                int k = 0;
                while (k < l) {
                    int ll = array[i][j][k].length;
                    copy[i][j][k] = new char[ll];
                    int kk = 0;
                    while (kk < ll) {
                        copy[i][j][k][kk] = array[i][j][k][kk];
                        ++kk;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return copy;
    }

    public static Object copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return Fmath.copyObject(obj);
    }

    public static Object copyObject(Object obj) {
        if (obj == null) {
            return null;
        }
        Object objCopy = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.flush();
            oos.close();
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
            objCopy = ois.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        return objCopy;
    }

    public static double radToDeg(double rad) {
        return rad * 180.0 / Math.PI;
    }

    public static double degToRad(double deg) {
        return deg * Math.PI / 180.0;
    }

    public static double frequencyToRadialFrequency(double frequency) {
        return Math.PI * 2 * frequency;
    }

    public static double radialFrequencyToFrequency(double radial) {
        return radial / (Math.PI * 2);
    }

    public static double evToNm(double ev) {
        return 2.99792458E17 / (-ev * -1.60217646263E-19 / 6.6260687652E-34);
    }

    public static double nmToEv(double nm) {
        return 2.99792458E8 / (-nm * 1.0E-9) * 6.6260687652E-34 / -1.60217646263E-19;
    }

    public static double molarToPercentWeightByVol(double molar, double molWeight) {
        return molar * molWeight / 10.0;
    }

    public static double percentWeightByVolToMolar(double perCent, double molWeight) {
        return perCent * 10.0 / molWeight;
    }

    public static double celsiusToKelvin(double cels) {
        return cels - -273.15;
    }

    public static double kelvinToCelsius(double kelv) {
        return kelv + -273.15;
    }

    public static double celsiusToFahren(double cels) {
        return cels * 1.8 + 32.0;
    }

    public static double fahrenToCelsius(double fahr) {
        return (fahr - 32.0) * 5.0 / 9.0;
    }

    public static double calorieToJoule(double cal) {
        return cal * 4.1868;
    }

    public static double jouleToCalorie(double joule) {
        return joule * 0.23884;
    }

    public static double gramToOunce(double gm) {
        return gm / 28.3459;
    }

    public static double ounceToGram(double oz) {
        return oz * 28.3459;
    }

    public static double kgToPound(double kg) {
        return kg / 0.4536;
    }

    public static double poundToKg(double pds) {
        return pds * 0.4536;
    }

    public static double kgToTon(double kg) {
        return kg / 1016.05;
    }

    public static double tonToKg(double tons) {
        return tons * 1016.05;
    }

    public static double millimetreToInch(double mm) {
        return mm / 25.4;
    }

    public static double inchToMillimetre(double in) {
        return in * 25.4;
    }

    public static double footToMetre(double ft) {
        return ft * 0.3048;
    }

    public static double metreToFoot(double metre) {
        return metre / 0.3048;
    }

    public static double yardToMetre(double yd) {
        return yd * 0.9144;
    }

    public static double metreToYard(double metre) {
        return metre / 0.9144;
    }

    public static double mileToKm(double mile) {
        return mile * 1.6093;
    }

    public static double kmToMile(double km) {
        return km / 1.6093;
    }

    public static double gallonToLitre(double gall) {
        return gall * 4.546;
    }

    public static double litreToGallon(double litre) {
        return litre / 4.546;
    }

    public static double quartToLitre(double quart) {
        return quart * 1.137;
    }

    public static double litreToQuart(double litre) {
        return litre / 1.137;
    }

    public static double pintToLitre(double pint) {
        return pint * 0.568;
    }

    public static double litreToPint(double litre) {
        return litre / 0.568;
    }

    public static double gallonPerMileToLitrePerKm(double gallPmile) {
        return gallPmile * 2.825;
    }

    public static double litrePerKmToGallonPerMile(double litrePkm) {
        return litrePkm / 2.825;
    }

    public static double milePerGallonToKmPerLitre(double milePgall) {
        return milePgall * 0.354;
    }

    public static double kmPerLitreToMilePerGallon(double kmPlitre) {
        return kmPlitre / 0.354;
    }

    public static double fluidOunceUKtoUS(double flOzUK) {
        return flOzUK * 0.961;
    }

    public static double fluidOunceUStoUK(double flOzUS) {
        return flOzUS * 1.041;
    }

    public static double pintUKtoUS(double pintUK) {
        return pintUK * 1.201;
    }

    public static double pintUStoUK(double pintUS) {
        return pintUS * 0.833;
    }

    public static double quartUKtoUS(double quartUK) {
        return quartUK * 1.201;
    }

    public static double quartUStoUK(double quartUS) {
        return quartUS * 0.833;
    }

    public static double gallonUKtoUS(double gallonUK) {
        return gallonUK * 1.201;
    }

    public static double gallonUStoUK(double gallonUS) {
        return gallonUS * 0.833;
    }

    public static double pintUKtoCupUS(double pintUK) {
        return pintUK / 0.417;
    }

    public static double cupUStoPintUK(double cupUS) {
        return cupUS * 0.417;
    }

    public static double calcBMImetric(double height, double weight) {
        return weight / (height * height);
    }

    public static double calcBMIimperial(double height, double weight) {
        height = Fmath.footToMetre(height);
        weight = Fmath.poundToKg(weight);
        return weight / (height * height);
    }

    public static double calcWeightFromBMImetric(double bmi, double height) {
        return bmi * height * height;
    }

    public static double calcWeightFromBMIimperial(double bmi, double height) {
        height = Fmath.footToMetre(height);
        double weight = bmi * height * height;
        weight = Fmath.kgToPound(weight);
        return weight;
    }
}

