/*
 * Decompiled with CFR 0.152.
 */
package flanagan.io;

import flanagan.io.FileTypeFilter;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class FileNameSelector {
    private File file;
    private String path = null;
    private String extn = null;
    private String fileName = null;
    private String stemName = null;
    private String pathName = null;
    private String dirPath = null;
    private boolean fileFound = false;

    public FileNameSelector() {
    }

    public FileNameSelector(String path) {
        this.path = path;
    }

    public String selectFile() {
        return this.selectFile("Select File");
    }

    public String selectFile(String prompt) {
        JFileChooser chooser = new JFileChooser(this.path);
        if (this.extn != null) {
            FileTypeFilter f2 = new FileTypeFilter();
            f2.addExtension(this.extn);
            f2.setDescription(String.valueOf(this.extn) + " files");
            chooser.setFileFilter(f2);
        } else {
            chooser.setAcceptAllFileFilterUsed(true);
        }
        chooser.setDialogTitle(prompt);
        chooser.showOpenDialog(null);
        this.file = chooser.getSelectedFile();
        if (this.file == null) {
            this.fileName = null;
            this.stemName = null;
            this.pathName = null;
            this.dirPath = null;
            this.fileFound = false;
        } else {
            this.pathName = this.file.toString();
            this.fileName = this.file.getName();
            this.dirPath = this.file.getParentFile().toString();
            int posDot = this.fileName.indexOf(46);
            this.stemName = posDot == -1 ? this.fileName : this.fileName.substring(0, posDot);
        }
        return this.fileName;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setExtension(String extn) {
        this.extn = extn;
    }

    public void setAllExtensions() {
        this.extn = null;
    }

    public String getExtension() {
        return this.extn;
    }

    public String getPathName() {
        return this.pathName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getStemName() {
        return this.stemName;
    }

    public String getDirPath() {
        return this.dirPath;
    }

    public boolean fileFound() {
        return this.fileFound;
    }

    public static final synchronized void endProgram() {
        int ans = JOptionPane.showConfirmDialog(null, "Do you wish to end the program", "End Program", 0, 3);
        if (ans == 0) {
            System.exit(0);
        } else {
            JOptionPane.showMessageDialog(null, "Now you must press the appropriate escape key/s, e.g. Ctrl C, to exit this program");
        }
    }
}

