/*
 * Decompiled with CFR 0.152.
 */
package flanagan.io;

import flanagan.io.FileInput;
import flanagan.io.FileTypeFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class FileChooser
extends FileInput {
    private File file;
    private String path = null;
    private String extn = null;

    public FileChooser() {
        this.path = System.getProperty("user.dir");
    }

    public FileChooser(String path) {
        this.path = path;
    }

    public String selectFile() {
        return this.selectFile("Select File");
    }

    public String selectFile(String prompt) {
        JFileChooser chooser = new JFileChooser(this.path);
        if (this.extn != null) {
            FileTypeFilter f2 = new FileTypeFilter();
            f2.addExtension(this.extn);
            f2.setDescription(String.valueOf(this.extn) + " files");
            chooser.setFileFilter(f2);
        } else {
            chooser.setAcceptAllFileFilterUsed(true);
        }
        chooser.setDialogTitle(prompt);
        chooser.showOpenDialog(null);
        this.file = chooser.getSelectedFile();
        if (this.file == null) {
            this.fileName = null;
            this.stemName = null;
            this.extension = null;
            this.pathName = null;
            this.dirPath = null;
            this.fileFound = false;
        } else {
            this.pathName = this.file.toString();
            this.fileName = this.file.getName();
            this.dirPath = this.file.getParentFile().toString();
            int posDot = this.fileName.indexOf(46);
            if (posDot == -1) {
                this.stemName = this.fileName;
                this.extension = "";
            } else {
                this.stemName = this.fileName.substring(0, posDot);
                this.extn = this.extension = this.fileName.substring(posDot);
            }
            try {
                this.input = new BufferedReader(new FileReader(this.pathName));
            }
            catch (FileNotFoundException e) {
                System.out.println(e);
                this.fileFound = false;
            }
        }
        return this.fileName;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setExtension(String extn) {
        this.extn = extn;
    }

    public void setAllExtensions() {
        this.extn = null;
    }

    @Override
    public String getExtension() {
        return this.extn;
    }

    public static final synchronized void endProgram() {
        int ans = JOptionPane.showConfirmDialog(null, "Do you wish to end the program", "End Program", 0, 3);
        if (ans == 0) {
            System.exit(0);
        } else {
            JOptionPane.showMessageDialog(null, "Now you must press the appropriate escape key/s, e.g. Ctrl C, to exit this program");
        }
    }
}

