/*
 * Decompiled with CFR 0.152.
 */
package flanagan.interpolation;

import flanagan.interpolation.TriCubicSpline;
import flanagan.math.ArrayMaths;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.math.Matrix;
import java.util.ArrayList;

public class TriCubicInterpolation {
    int[][] unitCube;
    private int lPoints;
    private int mPoints;
    private int nPoints;
    private double[] x1;
    private double[] x2;
    private double[] x3;
    private double[][][] y;
    private double[][][] dydx1;
    private double[][][] dydx2;
    private double[][][] dydx3;
    private double[][][] d2ydx1dx2;
    private double[][][] d2ydx1dx3;
    private double[][][] d2ydx2dx3;
    private double[][][] d3ydx1dx2dx3;
    private boolean derivCalculated;
    private TriCubicSpline tcs;
    private double incrX1;
    private double incrX2;
    private double incrX3;
    private double xx1;
    private double xx2;
    private double xx3;
    private ArrayList<Object> coeff;
    private double[][] weights;
    private int[] x1indices;
    private int[] x2indices;
    private int[] x3indices;
    private double[] xMin;
    private double[] xMax;
    private double interpolatedValue;
    private double interpolatedDydx1;
    private double interpolatedDydx2;
    private double interpolatedDydx3;
    private double interpolatedD2ydx1dx2;
    private double interpolatedD2ydx1dx3;
    private double interpolatedD2ydx2dx3;
    private double interpolatedD3ydx1dx2dx3;
    private boolean numerDiffFlag;
    private static double delta = 0.001;
    private static double potentialRoundingError = 5.0E-15;
    private static boolean roundingCheck = false;

    public TriCubicInterpolation(double[] x1, double[] x2, double[] x3, double[][][] y, int numerDiffOption) {
        int[][] nArrayArray = new int[8][];
        nArrayArray[0] = new int[3];
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArrayArray[1] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 1;
        nArray2[1] = 1;
        nArrayArray[2] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[1] = 1;
        nArrayArray[3] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[2] = 1;
        nArrayArray[4] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[0] = 1;
        nArray5[2] = 1;
        nArrayArray[5] = nArray5;
        nArrayArray[6] = new int[]{1, 1, 1};
        int[] nArray6 = new int[3];
        nArray6[1] = 1;
        nArray6[2] = 1;
        nArrayArray[7] = nArray6;
        this.unitCube = nArrayArray;
        this.lPoints = 0;
        this.mPoints = 0;
        this.nPoints = 0;
        this.x1 = null;
        this.x2 = null;
        this.x3 = null;
        this.y = null;
        this.dydx1 = null;
        this.dydx2 = null;
        this.dydx3 = null;
        this.d2ydx1dx2 = null;
        this.d2ydx1dx3 = null;
        this.d2ydx2dx3 = null;
        this.d3ydx1dx2dx3 = null;
        this.derivCalculated = false;
        this.tcs = null;
        this.incrX1 = 0.0;
        this.incrX2 = 0.0;
        this.incrX3 = 0.0;
        this.xx1 = Double.NaN;
        this.xx2 = Double.NaN;
        this.xx3 = Double.NaN;
        this.coeff = new ArrayList();
        this.weights = new double[64][64];
        this.x1indices = null;
        this.x2indices = null;
        this.x3indices = null;
        this.xMin = new double[3];
        this.xMax = new double[3];
        this.interpolatedValue = Double.NaN;
        this.interpolatedDydx1 = Double.NaN;
        this.interpolatedDydx2 = Double.NaN;
        this.interpolatedDydx3 = Double.NaN;
        this.interpolatedD2ydx1dx2 = Double.NaN;
        this.interpolatedD2ydx1dx3 = Double.NaN;
        this.interpolatedD2ydx2dx3 = Double.NaN;
        this.interpolatedD3ydx1dx2dx3 = Double.NaN;
        this.numerDiffFlag = true;
        if (numerDiffOption == 0) {
            this.numerDiffFlag = false;
        } else if (numerDiffOption == 1) {
            this.numerDiffFlag = true;
        } else {
            throw new IllegalArgumentException("The numerical differencing option, " + numerDiffOption + ", must be 0 or 1");
        }
        this.initialize(Conv.copy(x1), Conv.copy(x2), Conv.copy(x3), Conv.copy(y));
        this.calcDeriv();
        this.gridCoefficients();
    }

    public TriCubicInterpolation(double[] x1, double[] x2, double[] x3, double[][][] y, double[][][] dydx1, double[][][] dydx2, double[][][] dydx3, double[][][] d2ydx1dx2, double[][][] d2ydx1dx3, double[][][] d2ydx2dx3, double[][][] d3ydx1dx2dx3) {
        int[][] nArrayArray = new int[8][];
        nArrayArray[0] = new int[3];
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArrayArray[1] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 1;
        nArray2[1] = 1;
        nArrayArray[2] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[1] = 1;
        nArrayArray[3] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[2] = 1;
        nArrayArray[4] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[0] = 1;
        nArray5[2] = 1;
        nArrayArray[5] = nArray5;
        nArrayArray[6] = new int[]{1, 1, 1};
        int[] nArray6 = new int[3];
        nArray6[1] = 1;
        nArray6[2] = 1;
        nArrayArray[7] = nArray6;
        this.unitCube = nArrayArray;
        this.lPoints = 0;
        this.mPoints = 0;
        this.nPoints = 0;
        this.x1 = null;
        this.x2 = null;
        this.x3 = null;
        this.y = null;
        this.dydx1 = null;
        this.dydx2 = null;
        this.dydx3 = null;
        this.d2ydx1dx2 = null;
        this.d2ydx1dx3 = null;
        this.d2ydx2dx3 = null;
        this.d3ydx1dx2dx3 = null;
        this.derivCalculated = false;
        this.tcs = null;
        this.incrX1 = 0.0;
        this.incrX2 = 0.0;
        this.incrX3 = 0.0;
        this.xx1 = Double.NaN;
        this.xx2 = Double.NaN;
        this.xx3 = Double.NaN;
        this.coeff = new ArrayList();
        this.weights = new double[64][64];
        this.x1indices = null;
        this.x2indices = null;
        this.x3indices = null;
        this.xMin = new double[3];
        this.xMax = new double[3];
        this.interpolatedValue = Double.NaN;
        this.interpolatedDydx1 = Double.NaN;
        this.interpolatedDydx2 = Double.NaN;
        this.interpolatedDydx3 = Double.NaN;
        this.interpolatedD2ydx1dx2 = Double.NaN;
        this.interpolatedD2ydx1dx3 = Double.NaN;
        this.interpolatedD2ydx2dx3 = Double.NaN;
        this.interpolatedD3ydx1dx2dx3 = Double.NaN;
        this.numerDiffFlag = true;
        this.initialize(Conv.copy(x1), Conv.copy(x2), Conv.copy(x3), Conv.copy(y), Conv.copy(dydx1), Conv.copy(dydx2), Conv.copy(dydx3), Conv.copy(d2ydx1dx2), Conv.copy(d2ydx1dx3), Conv.copy(d2ydx2dx3), Conv.copy(d3ydx1dx2dx3));
        this.gridCoefficients();
    }

    private void initialize(double[] x1, double[] x2, double[] x3, double[][][] y) {
        this.initialize(x1, x2, x3, y, null, null, null, null, null, null, null, false);
    }

    private void initialize(double[] x1, double[] x2, double[] x3, double[][][] y, double[][][] dydx1, double[][][] dydx2, double[][][] dyd3, double[][][] d2ydx1dx2, double[][][] d2ydx1dx3, double[][][] d2ydx2dx3, double[][][] d3ydx1dx2dx3) {
        this.initialize(x1, x2, x3, y, dydx1, dydx2, this.dydx3, d2ydx1dx2, d2ydx1dx3, d2ydx2dx3, d3ydx1dx2dx3, true);
    }

    private void initialize(double[] x1, double[] x2, double[] x3, double[][][] y, double[][][] dydx1, double[][][] dydx2, double[][][] dyd3, double[][][] d2ydx1dx2, double[][][] d2ydx1dx3, double[][][] d2ydx2dx3, double[][][] d3ydx1dx2dx3, boolean flag) {
        int k;
        int j;
        int lPoints = x1.length;
        int mPoints = x2.length;
        int nPoints = x3.length;
        if (lPoints != y.length) {
            throw new IllegalArgumentException("Array x1 and y-row are of different length " + lPoints + " " + y.length);
        }
        if (mPoints != y[0].length) {
            throw new IllegalArgumentException("Array x2 and y-column are of different length " + mPoints + " " + y[0].length);
        }
        if (nPoints != y[0][0].length) {
            throw new IllegalArgumentException("Array x3 and y-column are of different length " + nPoints + " " + y[0][0].length);
        }
        if (lPoints < 2 || mPoints < 2 || nPoints < 2) {
            throw new IllegalArgumentException("The data matrix must have a minimum size of 2 X 2 X 2");
        }
        this.calcWeights();
        ArrayMaths am = new ArrayMaths(x1);
        am = am.sort();
        this.x1indices = am.originalIndices();
        x1 = am.array();
        double[][][] hold = new double[lPoints][mPoints][nPoints];
        double[][][] hold1 = null;
        double[][][] hold2 = null;
        double[][][] hold12 = null;
        int i = 0;
        while (i < lPoints) {
            j = 0;
            while (j < mPoints) {
                k = 0;
                while (k < nPoints) {
                    hold[i][j][k] = y[this.x1indices[i]][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < lPoints) {
            j = 0;
            while (j < mPoints) {
                k = 0;
                while (k < nPoints) {
                    y[i][j][k] = hold[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        if (flag) {
            hold1 = new double[lPoints][mPoints][nPoints];
            hold2 = new double[lPoints][mPoints][nPoints];
            hold12 = new double[lPoints][mPoints][nPoints];
            i = 0;
            while (i < lPoints) {
                j = 0;
                while (j < mPoints) {
                    k = 0;
                    while (k < nPoints) {
                        hold1[i][j][k] = dydx1[this.x1indices[i]][j][k];
                        hold2[i][j][k] = dydx2[this.x1indices[i]][j][k];
                        hold12[i][j][k] = d2ydx1dx2[this.x1indices[i]][j][k];
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < lPoints) {
                j = 0;
                while (j < mPoints) {
                    k = 0;
                    while (k < nPoints) {
                        dydx1[i][j][k] = hold1[i][j][k];
                        dydx2[i][j][k] = hold2[i][j][k];
                        d2ydx1dx2[i][j][k] = hold12[i][j][k];
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        am = new ArrayMaths(x2);
        am = am.sort();
        this.x2indices = am.originalIndices();
        x2 = am.array();
        i = 0;
        while (i < lPoints) {
            j = 0;
            while (j < mPoints) {
                k = 0;
                while (k < nPoints) {
                    hold[i][j][k] = y[i][this.x2indices[j]][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < lPoints) {
            j = 0;
            while (j < mPoints) {
                k = 0;
                while (k < nPoints) {
                    y[i][j][k] = hold[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        if (flag) {
            i = 0;
            while (i < lPoints) {
                j = 0;
                while (j < mPoints) {
                    k = 0;
                    while (k < nPoints) {
                        hold1[i][j][k] = dydx1[i][this.x2indices[j]][k];
                        hold2[i][j][k] = dydx2[i][this.x2indices[j]][k];
                        hold12[i][j][k] = d2ydx1dx2[i][this.x2indices[j]][k];
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < lPoints) {
                j = 0;
                while (j < mPoints) {
                    k = 0;
                    while (k < nPoints) {
                        dydx1[i][j][k] = hold1[i][j][k];
                        dydx2[i][j][k] = hold2[i][j][k];
                        d2ydx1dx2[i][j][k] = hold12[i][j][k];
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        am = new ArrayMaths(x3);
        am = am.sort();
        this.x3indices = am.originalIndices();
        x3 = am.array();
        i = 0;
        while (i < lPoints) {
            j = 0;
            while (j < mPoints) {
                k = 0;
                while (k < nPoints) {
                    hold[i][j][k] = y[i][j][this.x3indices[k]];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < lPoints) {
            j = 0;
            while (j < mPoints) {
                k = 0;
                while (k < nPoints) {
                    y[i][j][k] = hold[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        if (flag) {
            i = 0;
            while (i < lPoints) {
                j = 0;
                while (j < mPoints) {
                    k = 0;
                    while (k < nPoints) {
                        hold1[i][j][k] = dydx1[i][j][this.x3indices[k]];
                        hold2[i][j][k] = dydx2[i][j][this.x3indices[k]];
                        hold12[i][j][k] = d2ydx1dx2[i][j][this.x3indices[k]];
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < lPoints) {
                j = 0;
                while (j < mPoints) {
                    k = 0;
                    while (k < nPoints) {
                        dydx1[i][j][k] = hold1[i][j][k];
                        dydx2[i][j][k] = hold2[i][j][k];
                        d2ydx1dx2[i][j][k] = hold12[i][j][k];
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        i = 1;
        while (i < lPoints) {
            if (x1[i] == x1[i - 1]) {
                System.out.println("x1[" + this.x1indices[i] + "] and x1[" + this.x1indices[i + 1] + "] are identical, " + x1[i]);
                double sep = (Fmath.maximum(x1) - Fmath.minimum(x1)) / 5.0E-4;
                int n = i - 1;
                x1[n] = x1[n] - sep;
                int n2 = i;
                x1[n2] = x1[n2] + sep;
                System.out.println("They have been separated by" + 2.0 * sep);
            }
            ++i;
        }
        i = 1;
        while (i < mPoints) {
            if (x2[i] == x2[i - 1]) {
                System.out.println("x2[" + this.x2indices[i] + "] and x2[" + this.x2indices[i + 1] + "] are identical, " + x2[i]);
                double sep = (Fmath.maximum(x2) - Fmath.minimum(x2)) / 5.0E-4;
                int n = i - 1;
                x2[n] = x2[n] - sep;
                int n3 = i;
                x2[n3] = x2[n3] + sep;
                System.out.println("They have been separated by" + 2.0 * sep);
            }
            ++i;
        }
        i = 1;
        while (i < nPoints) {
            if (x3[i] == x3[i - 1]) {
                System.out.println("x3[" + this.x3indices[i] + "] and x3[" + this.x3indices[i + 1] + "] are identical, " + x3[i]);
                double sep = (Fmath.maximum(x3) - Fmath.minimum(x3)) / 5.0E-4;
                int n = i - 1;
                x3[n] = x3[n] - sep;
                int n4 = i;
                x3[n4] = x3[n4] + sep;
                System.out.println("They have been separated by" + 2.0 * sep);
            }
            ++i;
        }
        this.lPoints = lPoints;
        this.mPoints = mPoints;
        this.nPoints = nPoints;
        this.x1 = new double[this.lPoints];
        this.x2 = new double[this.mPoints];
        this.x3 = new double[this.nPoints];
        this.y = new double[this.lPoints][this.mPoints][this.nPoints];
        this.dydx1 = new double[this.lPoints][this.mPoints][this.nPoints];
        this.dydx2 = new double[this.lPoints][this.mPoints][this.nPoints];
        this.dydx3 = new double[this.lPoints][this.mPoints][this.nPoints];
        this.d2ydx1dx2 = new double[this.lPoints][this.mPoints][this.nPoints];
        this.d2ydx1dx3 = new double[this.lPoints][this.mPoints][this.nPoints];
        this.d2ydx2dx3 = new double[this.lPoints][this.mPoints][this.nPoints];
        this.d3ydx1dx2dx3 = new double[this.lPoints][this.mPoints][this.nPoints];
        i = 0;
        while (i < this.lPoints) {
            this.x1[i] = x1[i];
            ++i;
        }
        int j2 = 0;
        while (j2 < this.mPoints) {
            this.x2[j2] = x2[j2];
            ++j2;
        }
        int k2 = 0;
        while (k2 < this.nPoints) {
            this.x3[k2] = x3[k2];
            ++k2;
        }
        i = 0;
        while (i < this.lPoints) {
            int j3 = 0;
            while (j3 < this.mPoints) {
                k = 0;
                while (k < this.nPoints) {
                    this.y[i][j3][k] = y[i][j3][k];
                    ++k;
                }
                ++j3;
            }
            ++i;
        }
        if (flag) {
            i = 0;
            while (i < this.lPoints) {
                int j4 = 0;
                while (j4 < this.mPoints) {
                    k = 0;
                    while (k < this.nPoints) {
                        this.dydx1[i][j4][k] = dydx1[i][j4][k];
                        this.dydx2[i][j4][k] = dydx2[i][j4][k];
                        this.dydx3[i][j4][k] = this.dydx3[i][j4][k];
                        this.d2ydx1dx2[i][j4][k] = d2ydx1dx2[i][j4][k];
                        this.d2ydx1dx3[i][j4][k] = d2ydx1dx3[i][j4][k];
                        this.d2ydx2dx3[i][j4][k] = d2ydx2dx3[i][j4][k];
                        this.d3ydx1dx2dx3[i][j4][k] = d3ydx1dx2dx3[i][j4][k];
                        ++k;
                    }
                    ++j4;
                }
                ++i;
            }
            this.derivCalculated = true;
        }
        this.xMin[0] = Fmath.minimum(this.x1);
        this.xMax[0] = Fmath.maximum(this.x1);
        this.xMin[1] = Fmath.minimum(this.x2);
        this.xMax[1] = Fmath.maximum(this.x2);
        this.xMin[2] = Fmath.minimum(this.x3);
        this.xMax[2] = Fmath.maximum(this.x3);
        if (!flag && this.numerDiffFlag) {
            double minSep;
            double range1 = this.xMax[0] - this.xMin[0];
            double range2 = this.xMax[1] - this.xMin[1];
            double range3 = this.xMax[2] - this.xMin[2];
            double averageSeparation1 = range1 / (double)this.lPoints;
            double averageSeparation2 = range2 / (double)this.mPoints;
            double averageSeparation3 = range3 / (double)this.nPoints;
            double minimumSeparation1 = minSep = this.x1[1] - this.x1[0];
            int i2 = 2;
            while (i2 < this.lPoints) {
                minSep = this.x1[i2] - this.x1[i2 - 1];
                if (minSep < minimumSeparation1) {
                    minimumSeparation1 = minSep;
                }
                ++i2;
            }
            double minimumSeparation2 = minSep = this.x2[1] - this.x2[0];
            int i3 = 2;
            while (i3 < this.mPoints) {
                minSep = this.x2[i3] - this.x2[i3 - 1];
                if (minSep < minimumSeparation2) {
                    minimumSeparation2 = minSep;
                }
                ++i3;
            }
            double minimumSeparation3 = minSep = this.x3[1] - this.x3[0];
            int i4 = 2;
            while (i4 < this.nPoints) {
                minSep = this.x3[i4] - this.x3[i4 - 1];
                if (minSep < minimumSeparation3) {
                    minimumSeparation3 = minSep;
                }
                ++i4;
            }
            this.incrX1 = range1 * delta;
            double defaultIncr = minimumSeparation1;
            if (minimumSeparation1 < averageSeparation1 / 10.0) {
                defaultIncr = averageSeparation1 / 10.0;
            }
            if (this.incrX1 > averageSeparation1) {
                this.incrX1 = defaultIncr;
            }
            this.incrX2 = range2 * delta;
            defaultIncr = minimumSeparation2;
            if (minimumSeparation2 < averageSeparation2 / 10.0) {
                defaultIncr = averageSeparation2 / 10.0;
            }
            if (this.incrX2 > averageSeparation2) {
                this.incrX2 = defaultIncr;
            }
            this.incrX3 = range3 * delta;
            defaultIncr = minimumSeparation3;
            if (minimumSeparation3 < averageSeparation3 / 10.0) {
                defaultIncr = averageSeparation3 / 10.0;
            }
            if (this.incrX3 > averageSeparation3) {
                this.incrX3 = defaultIncr;
            }
        }
    }

    private void calcWeights() {
        int k;
        int j;
        int i;
        int n;
        int kk = 0;
        int m = 0;
        while (m < 8) {
            n = 0;
            i = 0;
            while (i < 4) {
                j = 0;
                while (j < 4) {
                    k = 0;
                    while (k < 4) {
                        this.weights[kk][n] = Math.pow(this.unitCube[m][0], i) * Math.pow(this.unitCube[m][1], j) * Math.pow(this.unitCube[m][2], k);
                        ++n;
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            ++kk;
            ++m;
        }
        m = 0;
        while (m < 8) {
            n = 0;
            i = 0;
            while (i < 4) {
                j = 0;
                while (j < 4) {
                    k = 0;
                    while (k < 4) {
                        this.weights[kk][n] = i == 0 ? 0.0 : (double)i * Math.pow(this.unitCube[m][0], i - 1) * Math.pow(this.unitCube[m][1], j) * Math.pow(this.unitCube[m][2], k);
                        ++n;
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            ++kk;
            ++m;
        }
        m = 0;
        while (m < 8) {
            n = 0;
            i = 0;
            while (i < 4) {
                j = 0;
                while (j < 4) {
                    k = 0;
                    while (k < 4) {
                        this.weights[kk][n] = j == 0 ? 0.0 : (double)j * Math.pow(this.unitCube[m][0], i) * Math.pow(this.unitCube[m][1], j - 1) * Math.pow(this.unitCube[m][2], k);
                        ++n;
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            ++kk;
            ++m;
        }
        m = 0;
        while (m < 8) {
            n = 0;
            i = 0;
            while (i < 4) {
                j = 0;
                while (j < 4) {
                    k = 0;
                    while (k < 4) {
                        this.weights[kk][n] = k == 0 ? 0.0 : (double)k * Math.pow(this.unitCube[m][0], i) * Math.pow(this.unitCube[m][1], j) * Math.pow(this.unitCube[m][2], k - 1);
                        ++n;
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            ++kk;
            ++m;
        }
        m = 0;
        while (m < 8) {
            n = 0;
            i = 0;
            while (i < 4) {
                j = 0;
                while (j < 4) {
                    k = 0;
                    while (k < 4) {
                        this.weights[kk][n] = i == 0 || j == 0 ? 0.0 : (double)(i * j) * Math.pow(this.unitCube[m][0], i - 1) * Math.pow(this.unitCube[m][1], j - 1) * Math.pow(this.unitCube[m][2], k);
                        ++n;
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            ++kk;
            ++m;
        }
        m = 0;
        while (m < 8) {
            n = 0;
            i = 0;
            while (i < 4) {
                j = 0;
                while (j < 4) {
                    k = 0;
                    while (k < 4) {
                        this.weights[kk][n] = i == 0 || k == 0 ? 0.0 : (double)(i * k) * Math.pow(this.unitCube[m][0], i - 1) * Math.pow(this.unitCube[m][1], j) * Math.pow(this.unitCube[m][2], k - 1);
                        ++n;
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            ++kk;
            ++m;
        }
        m = 0;
        while (m < 8) {
            n = 0;
            i = 0;
            while (i < 4) {
                j = 0;
                while (j < 4) {
                    k = 0;
                    while (k < 4) {
                        this.weights[kk][n] = j == 0 || k == 0 ? 0.0 : (double)(j * k) * Math.pow(this.unitCube[m][0], i) * Math.pow(this.unitCube[m][1], j - 1) * Math.pow(this.unitCube[m][2], k - 1);
                        ++n;
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            ++kk;
            ++m;
        }
        m = 0;
        while (m < 8) {
            n = 0;
            i = 0;
            while (i < 4) {
                j = 0;
                while (j < 4) {
                    k = 0;
                    while (k < 4) {
                        this.weights[kk][n] = i == 0 || j == 0 || k == 0 ? 0.0 : (double)(i * j * k) * Math.pow(this.unitCube[m][0], i - 1) * Math.pow(this.unitCube[m][1], j - 1) * Math.pow(this.unitCube[m][2], k - 1);
                        ++n;
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            ++kk;
            ++m;
        }
        Matrix mat = new Matrix(this.weights);
        mat = mat.inverse();
        this.weights = mat.getArrayCopy();
    }

    private void calcDeriv() {
        if (this.numerDiffFlag) {
            this.tcs = new TriCubicSpline(this.x1, this.x2, this.x3, this.y);
            double[] x1jp1 = new double[this.lPoints];
            double[] x1jm1 = new double[this.lPoints];
            double[] x2jp1 = new double[this.mPoints];
            double[] x2jm1 = new double[this.mPoints];
            double[] x3jp1 = new double[this.nPoints];
            double[] x3jm1 = new double[this.nPoints];
            int i = 0;
            while (i < this.lPoints) {
                x1jp1[i] = this.x1[i] + this.incrX1;
                if (x1jp1[i] > this.x1[this.lPoints - 1]) {
                    x1jp1[i] = this.x1[this.lPoints - 1];
                }
                x1jm1[i] = this.x1[i] - this.incrX1;
                if (x1jm1[i] < this.x1[0]) {
                    x1jm1[i] = this.x1[0];
                }
                ++i;
            }
            i = 0;
            while (i < this.mPoints) {
                x2jp1[i] = this.x2[i] + this.incrX2;
                if (x2jp1[i] > this.x2[this.mPoints - 1]) {
                    x2jp1[i] = this.x2[this.mPoints - 1];
                }
                x2jm1[i] = this.x2[i] - this.incrX2;
                if (x2jm1[i] < this.x2[0]) {
                    x2jm1[i] = this.x2[0];
                }
                ++i;
            }
            i = 0;
            while (i < this.nPoints) {
                x3jp1[i] = this.x3[i] + this.incrX3;
                if (x3jp1[i] > this.x3[this.nPoints - 1]) {
                    x3jp1[i] = this.x3[this.nPoints - 1];
                }
                x3jm1[i] = this.x3[i] - this.incrX3;
                if (x3jm1[i] < this.x3[0]) {
                    x3jm1[i] = this.x3[0];
                }
                ++i;
            }
            i = 0;
            while (i < this.lPoints) {
                int j = 0;
                while (j < this.mPoints) {
                    int k = 0;
                    while (k < this.nPoints) {
                        this.dydx1[i][j][k] = (this.tcs.interpolate(x1jp1[i], this.x2[j], this.x3[k]) - this.tcs.interpolate(x1jm1[i], this.x2[j], this.x3[k])) / (x1jp1[i] - x1jm1[i]);
                        this.dydx2[i][j][k] = (this.tcs.interpolate(this.x1[i], x2jp1[j], this.x3[k]) - this.tcs.interpolate(this.x1[i], x2jm1[j], this.x3[k])) / (x2jp1[j] - x2jm1[j]);
                        this.dydx3[i][j][k] = (this.tcs.interpolate(this.x1[i], this.x2[j], x3jp1[k]) - this.tcs.interpolate(this.x1[i], this.x2[j], x3jm1[k])) / (x3jp1[k] - x3jm1[k]);
                        this.d2ydx1dx2[i][j][k] = (this.tcs.interpolate(x1jp1[i], x2jp1[j], this.x3[k]) - this.tcs.interpolate(x1jp1[i], x2jm1[j], this.x3[k]) - this.tcs.interpolate(x1jm1[i], x2jp1[j], this.x3[k]) + this.tcs.interpolate(x1jm1[i], x2jm1[j], this.x3[k])) / ((x1jp1[i] - x1jm1[i]) * (x2jp1[j] - x2jm1[j]));
                        this.d2ydx1dx3[i][j][k] = (this.tcs.interpolate(x1jp1[i], this.x2[j], x3jp1[k]) - this.tcs.interpolate(x1jp1[i], this.x2[j], x3jm1[k]) - this.tcs.interpolate(x1jm1[i], this.x2[j], x3jp1[k]) + this.tcs.interpolate(x1jm1[i], this.x2[j], x3jm1[k])) / ((x1jp1[i] - x1jm1[i]) * (x3jp1[k] - x3jm1[k]));
                        this.d2ydx2dx3[i][j][k] = (this.tcs.interpolate(this.x1[i], x2jp1[j], x3jp1[k]) - this.tcs.interpolate(this.x1[i], x2jp1[j], x3jm1[k]) - this.tcs.interpolate(this.x1[i], x2jm1[j], x3jp1[k]) + this.tcs.interpolate(this.x1[i], x2jm1[j], x3jm1[k])) / ((x2jp1[j] - x2jm1[j]) * (x3jp1[k] - x3jm1[k]));
                        this.d3ydx1dx2dx3[i][j][k] = (this.tcs.interpolate(x1jp1[i], x2jp1[j], x3jp1[k]) - this.tcs.interpolate(x1jp1[i], x2jm1[j], x3jp1[k]) - this.tcs.interpolate(x1jm1[i], x2jp1[j], x3jp1[k]) + this.tcs.interpolate(x1jm1[i], x2jm1[j], x3jp1[k]) - (this.tcs.interpolate(x1jp1[i], x2jp1[j], x3jm1[k]) - this.tcs.interpolate(x1jp1[i], x2jm1[j], x3jm1[k]) - this.tcs.interpolate(x1jm1[i], x2jp1[j], x3jm1[k]) + this.tcs.interpolate(x1jm1[i], x2jm1[j], x3jm1[k]))) / ((x1jp1[i] - x1jm1[i]) * (x2jp1[j] - x2jm1[j]) * (x3jp1[k] - x3jm1[k]));
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            int iip = 0;
            int iim = 0;
            int jjp = 0;
            int jjm = 0;
            int kkp = 0;
            int kkm = 0;
            int i = 0;
            while (i < this.lPoints) {
                iip = i + 1;
                if (iip >= this.lPoints) {
                    iip = this.lPoints - 1;
                }
                if ((iim = i - 1) < 0) {
                    iim = 0;
                }
                int j = 0;
                while (j < this.mPoints) {
                    jjp = j + 1;
                    if (jjp >= this.mPoints) {
                        jjp = this.mPoints - 1;
                    }
                    if ((jjm = j - 1) < 0) {
                        jjm = 0;
                    }
                    int k = 0;
                    while (k < this.nPoints) {
                        kkp = k + 1;
                        if (kkp >= this.nPoints) {
                            kkp = this.nPoints - 1;
                        }
                        if ((kkm = k - 1) < 0) {
                            kkm = 0;
                        }
                        this.dydx1[i][j][k] = (this.y[iip][j][k] - this.y[iim][j][k]) / (this.x1[iip] - this.x1[iim]);
                        this.dydx2[i][j][k] = (this.y[i][jjp][k] - this.y[i][jjm][k]) / (this.x2[jjp] - this.x2[jjm]);
                        this.dydx3[i][j][k] = (this.y[i][j][kkp] - this.y[i][j][kkm]) / (this.x3[kkp] - this.x3[kkm]);
                        this.d2ydx1dx2[i][j][k] = (this.y[iip][jjp][k] - this.y[iip][jjm][k] - this.y[iim][jjp][k] + this.y[iim][jjm][k]) / ((this.x1[iip] - this.x1[iim]) * (this.x2[jjp] - this.x2[jjm]));
                        this.d2ydx1dx3[i][j][k] = (this.y[iip][j][kkp] - this.y[iip][j][kkm] - this.y[iim][j][kkp] + this.y[iim][j][kkm]) / ((this.x1[iip] - this.x1[iim]) * (this.x3[kkp] - this.x3[kkm]));
                        this.d2ydx2dx3[i][j][k] = (this.y[i][jjp][kkp] - this.y[i][jjp][kkm] - this.y[i][jjm][kkp] + this.y[i][jjm][kkm]) / ((this.x2[jjp] - this.x2[jjm]) * (this.x3[kkp] - this.x3[kkm]));
                        this.d2ydx1dx2[i][j][k] = (this.y[iip][jjp][kkp] - this.y[iip][jjm][kkp] - this.y[iim][jjp][kkp] + this.y[iim][jjm][kkp] - this.y[iip][jjp][kkm] + this.y[iip][jjm][kkm] + this.y[iim][jjp][kkm] - this.y[iim][jjm][kkm]) / ((this.x1[iip] - this.x1[iim]) * (this.x2[jjp] - this.x2[jjm]) * (this.x3[kkp] - this.x3[kkm]));
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.derivCalculated = true;
    }

    private void gridCoefficients() {
        double[] yt = new double[8];
        double[] dydx1t = new double[8];
        double[] dydx2t = new double[8];
        double[] dydx3t = new double[8];
        double[] d2ydx1dx2t = new double[8];
        double[] d2ydx1dx3t = new double[8];
        double[] d2ydx2dx3t = new double[8];
        double[] d3ydx1dx2dx3t = new double[8];
        double[] ct = new double[64];
        double[] xt = new double[64];
        double d1 = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int i = 0;
        while (i < this.lPoints - 1) {
            d1 = this.x1[i + 1] - this.x1[i];
            int j = 0;
            while (j < this.mPoints - 1) {
                d2 = this.x2[j + 1] - this.x2[j];
                int k = 0;
                while (k < this.nPoints - 1) {
                    d3 = this.x3[k + 1] - this.x3[k];
                    double[][][] cc = new double[4][4][4];
                    this.coeff.add(new Double(d1));
                    this.coeff.add(new Double(this.x1[i]));
                    this.coeff.add(new Double(d2));
                    this.coeff.add(new Double(this.x2[j]));
                    this.coeff.add(new Double(d3));
                    this.coeff.add(new Double(this.x3[k]));
                    int ii = 0;
                    while (ii < 8) {
                        yt[ii] = this.y[i + this.unitCube[ii][0]][j + this.unitCube[ii][1]][k + this.unitCube[ii][2]];
                        dydx1t[ii] = this.dydx1[i + this.unitCube[ii][0]][j + this.unitCube[ii][1]][k + this.unitCube[ii][2]];
                        dydx2t[ii] = this.dydx2[i + this.unitCube[ii][0]][j + this.unitCube[ii][1]][k + this.unitCube[ii][2]];
                        dydx3t[ii] = this.dydx3[i + this.unitCube[ii][0]][j + this.unitCube[ii][1]][k + this.unitCube[ii][2]];
                        d2ydx1dx2t[ii] = this.d2ydx1dx2[i + this.unitCube[ii][0]][j + this.unitCube[ii][1]][k + this.unitCube[ii][2]];
                        d2ydx1dx3t[ii] = this.d2ydx1dx3[i + this.unitCube[ii][0]][j + this.unitCube[ii][1]][k + this.unitCube[ii][2]];
                        d2ydx2dx3t[ii] = this.d2ydx2dx3[i + this.unitCube[ii][0]][j + this.unitCube[ii][1]][k + this.unitCube[ii][2]];
                        d3ydx1dx2dx3t[ii] = this.d3ydx1dx2dx3[i + this.unitCube[ii][0]][j + this.unitCube[ii][1]][k + this.unitCube[ii][2]];
                        ++ii;
                    }
                    int k2 = 0;
                    while (k2 < 8) {
                        xt[k2] = yt[k2];
                        xt[k2 + 8] = dydx1t[k2] * d1;
                        xt[k2 + 16] = dydx2t[k2] * d2;
                        xt[k2 + 24] = dydx3t[k2] * d3;
                        xt[k2 + 32] = d2ydx1dx2t[k2] * d1 * d2;
                        xt[k2 + 40] = d2ydx1dx3t[k2] * d1 * d3;
                        xt[k2 + 48] = d2ydx2dx3t[k2] * d2 * d3;
                        xt[k2 + 56] = d3ydx1dx2dx3t[k2] * d1 * d2 * d3;
                        ++k2;
                    }
                    double xh = 0.0;
                    int k22 = 0;
                    while (k22 < 64) {
                        int kk = 0;
                        while (kk < 64) {
                            xh += this.weights[k22][kk] * xt[kk];
                            ++kk;
                        }
                        ct[k22] = xh;
                        xh = 0.0;
                        ++k22;
                    }
                    int counter = 0;
                    int k23 = 0;
                    while (k23 < 4) {
                        int kk = 0;
                        while (kk < 4) {
                            int kkk = 0;
                            while (kkk < 4) {
                                cc[k23][kk][kkk] = ct[counter++];
                                ++kkk;
                            }
                            ++kk;
                        }
                        ++k23;
                    }
                    this.coeff.add(cc);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public double interpolate(double xx1, double xx2, double xx3) {
        int k;
        int j;
        if (xx1 < this.x1[0]) {
            if (xx1 >= this.x1[0] - potentialRoundingError) {
                xx1 = this.x1[0];
            } else {
                throw new IllegalArgumentException(String.valueOf(xx1) + " is outside the limits, " + this.x1[0] + " - " + this.x1[this.lPoints - 1]);
            }
        }
        if (xx2 < this.x2[0]) {
            if (xx2 >= this.x2[0] - potentialRoundingError) {
                xx2 = this.x2[0];
            } else {
                throw new IllegalArgumentException(String.valueOf(xx2) + " is outside the limits, " + this.x2[0] + " - " + this.x2[this.mPoints - 1]);
            }
        }
        if (xx3 < this.x3[0]) {
            if (xx3 >= this.x3[0] - potentialRoundingError) {
                xx3 = this.x3[0];
            } else {
                throw new IllegalArgumentException(String.valueOf(xx1) + " is outside the limits, " + this.x3[0] + " - " + this.x3[this.nPoints - 1]);
            }
        }
        if (xx1 > this.x1[this.lPoints - 1]) {
            if (xx1 <= this.x1[this.lPoints - 1] + potentialRoundingError) {
                xx1 = this.x1[this.lPoints - 1];
            } else {
                throw new IllegalArgumentException(String.valueOf(xx1) + " is outside the limits, " + this.x1[0] + " - " + this.x1[this.lPoints - 1]);
            }
        }
        if (xx2 > this.x2[this.mPoints - 1]) {
            if (xx2 <= this.x2[this.mPoints - 1] + potentialRoundingError) {
                xx2 = this.x2[this.mPoints - 1];
            } else {
                throw new IllegalArgumentException(String.valueOf(xx2) + " is outside the limits, " + this.x2[0] + " - " + this.x2[this.mPoints - 1]);
            }
        }
        if (xx3 > this.x3[this.nPoints - 1]) {
            if (xx3 <= this.x3[this.nPoints - 1] + potentialRoundingError) {
                xx3 = this.x3[this.mPoints - 1];
            } else {
                throw new IllegalArgumentException(String.valueOf(xx3) + " is outside the limits, " + this.x3[0] + " - " + this.x3[this.nPoints - 1]);
            }
        }
        this.xx1 = xx1;
        this.xx2 = xx2;
        this.xx3 = xx3;
        int gridn = 0;
        double distance1 = (Double)this.coeff.get(7 * gridn);
        double x1lower = (Double)this.coeff.get(7 * gridn + 1);
        double distance2 = (Double)this.coeff.get(7 * gridn + 2);
        double x2lower = (Double)this.coeff.get(7 * gridn + 3);
        double distance3 = (Double)this.coeff.get(7 * gridn + 4);
        double x3lower = (Double)this.coeff.get(7 * gridn + 5);
        boolean test2 = true;
        while (test2) {
            boolean test1 = false;
            boolean test22 = false;
            boolean test3 = false;
            if (xx1 >= x1lower && xx1 <= x1lower + distance1) {
                test1 = true;
            }
            if (xx2 >= x2lower && xx2 <= x2lower + distance2) {
                test22 = true;
            }
            if (xx3 >= x3lower && xx3 <= x3lower + distance3) {
                test3 = true;
            }
            if (test1 && test22 && test3) {
                test2 = false;
                continue;
            }
            distance1 = (Double)this.coeff.get(7 * ++gridn);
            x1lower = (Double)this.coeff.get(7 * gridn + 1);
            distance2 = (Double)this.coeff.get(7 * gridn + 2);
            x2lower = (Double)this.coeff.get(7 * gridn + 3);
            distance3 = (Double)this.coeff.get(7 * gridn + 4);
            x3lower = (Double)this.coeff.get(7 * gridn + 5);
        }
        double[][][] gCoeff = (double[][][])this.coeff.get(7 * gridn + 6);
        double x1Normalised = (xx1 - x1lower) / distance1;
        double x2Normalised = (xx2 - x2lower) / distance2;
        double x3Normalised = (xx3 - x3lower) / distance3;
        this.interpolatedValue = 0.0;
        int i = 0;
        while (i < 4) {
            j = 0;
            while (j < 4) {
                k = 0;
                while (k < 4) {
                    this.interpolatedValue += gCoeff[i][j][k] * Math.pow(x1Normalised, i) * Math.pow(x2Normalised, j) * Math.pow(x3Normalised, k);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.interpolatedDydx1 = 0.0;
        i = 1;
        while (i < 4) {
            j = 0;
            while (j < 4) {
                k = 0;
                while (k < 4) {
                    this.interpolatedDydx1 += (double)i * gCoeff[i][j][k] * Math.pow(x1Normalised, i - 1) * Math.pow(x2Normalised, j) * Math.pow(x3Normalised, k);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.interpolatedDydx2 = 0.0;
        i = 0;
        while (i < 4) {
            j = 1;
            while (j < 4) {
                k = 0;
                while (k < 4) {
                    this.interpolatedDydx2 += (double)j * gCoeff[i][j][k] * Math.pow(x1Normalised, i) * Math.pow(x2Normalised, j - 1) * Math.pow(x3Normalised, k);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.interpolatedDydx3 = 0.0;
        i = 0;
        while (i < 4) {
            j = 1;
            while (j < 4) {
                k = 0;
                while (k < 4) {
                    this.interpolatedDydx2 += (double)k * gCoeff[i][j][k] * Math.pow(x1Normalised, i) * Math.pow(x2Normalised, j) * Math.pow(x3Normalised, k - 1);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.interpolatedD2ydx1dx2 = 0.0;
        i = 1;
        while (i < 4) {
            j = 1;
            while (j < 4) {
                k = 0;
                while (k < 4) {
                    this.interpolatedD2ydx1dx2 += (double)(i * j) * gCoeff[i][j][k] * Math.pow(x1Normalised, i - 1) * Math.pow(x2Normalised, j - 1) * Math.pow(x3Normalised, k);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return this.interpolatedValue;
    }

    public double[] getInterpolatedValues() {
        double[] ret = new double[]{this.interpolatedValue, this.interpolatedDydx1, this.interpolatedDydx2, this.interpolatedDydx3, this.interpolatedD2ydx1dx2, this.interpolatedD2ydx1dx3, this.interpolatedD2ydx2dx3, this.interpolatedD3ydx1dx2dx3, this.xx1, this.xx2, this.xx3};
        return ret;
    }

    public double[][][] getGridDydx1() {
        double[][][] ret = new double[this.lPoints][this.mPoints][this.nPoints];
        int i = 0;
        while (i < this.lPoints) {
            int j = 0;
            while (j < this.mPoints) {
                int k = 0;
                while (k < this.nPoints) {
                    ret[this.x1indices[i]][this.x2indices[j]][this.x3indices[k]] = this.dydx1[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public double[][][] getGridDydx2() {
        double[][][] ret = new double[this.lPoints][this.mPoints][this.nPoints];
        int i = 0;
        while (i < this.lPoints) {
            int j = 0;
            while (j < this.mPoints) {
                int k = 0;
                while (k < this.nPoints) {
                    ret[this.x1indices[i]][this.x2indices[j]][this.x3indices[k]] = this.dydx2[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public double[][][] getGridDydx3() {
        double[][][] ret = new double[this.lPoints][this.mPoints][this.nPoints];
        int i = 0;
        while (i < this.lPoints) {
            int j = 0;
            while (j < this.mPoints) {
                int k = 0;
                while (k < this.nPoints) {
                    ret[this.x1indices[i]][this.x2indices[j]][this.x3indices[k]] = this.dydx3[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public double[][][] getGridD2ydx1dx2() {
        double[][][] ret = new double[this.lPoints][this.mPoints][this.nPoints];
        int i = 0;
        while (i < this.lPoints) {
            int j = 0;
            while (j < this.mPoints) {
                int k = 0;
                while (k < this.nPoints) {
                    ret[this.x1indices[i]][this.x2indices[j]][this.x3indices[k]] = this.d2ydx1dx2[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public double[][][] getGridD2ydx1dx3() {
        double[][][] ret = new double[this.lPoints][this.mPoints][this.nPoints];
        int i = 0;
        while (i < this.lPoints) {
            int j = 0;
            while (j < this.mPoints) {
                int k = 0;
                while (k < this.nPoints) {
                    ret[this.x1indices[i]][this.x2indices[j]][this.x3indices[k]] = this.d2ydx1dx3[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public double[][][] getGridD2ydx2dx3() {
        double[][][] ret = new double[this.lPoints][this.mPoints][this.nPoints];
        int i = 0;
        while (i < this.lPoints) {
            int j = 0;
            while (j < this.mPoints) {
                int k = 0;
                while (k < this.nPoints) {
                    ret[this.x1indices[i]][this.x2indices[j]][this.x3indices[k]] = this.d2ydx2dx3[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public double[][][] getGridD3ydx1dx2dx3() {
        double[][][] ret = new double[this.lPoints][this.mPoints][this.nPoints];
        int i = 0;
        while (i < this.lPoints) {
            int j = 0;
            while (j < this.mPoints) {
                int k = 0;
                while (k < this.nPoints) {
                    ret[this.x1indices[i]][this.x2indices[j]][this.x3indices[k]] = this.d3ydx1dx2dx3[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public static void resetDelta(double delta) {
        TriCubicInterpolation.delta = delta;
    }

    public static void noRoundingErrorCheck() {
        roundingCheck = false;
        potentialRoundingError = 0.0;
    }

    public static void potentialRoundingError(double potentialRoundingError) {
        TriCubicInterpolation.potentialRoundingError = potentialRoundingError;
    }

    public double[] getXmin() {
        return this.xMin;
    }

    public double[] getXmax() {
        return this.xMax;
    }

    public double[] getLimits() {
        double[] limits = new double[]{this.xMin[0], this.xMax[0], this.xMin[1], this.xMax[1], this.xMin[2], this.xMax[2]};
        return limits;
    }

    public void displayLimits() {
        System.out.println(" ");
        int i = 0;
        while (i < 3) {
            System.out.println("The limits to the x array x" + (i + 1) + " are " + this.xMin[i] + " and " + this.xMax[i]);
            ++i;
        }
        System.out.println(" ");
    }
}

