/*
 * Decompiled with CFR 0.152.
 */
package flanagan.interpolation;

import flanagan.interpolation.BiCubicSplineFast;
import flanagan.interpolation.CubicSplineFast;
import flanagan.math.Fmath;
import java.lang.reflect.Array;

public class PolyCubicSplineFast {
    private int nDimensions = 0;
    private Object fOfX = null;
    private Object xArrays = null;
    private Object method = null;
    private double[][] xArray = null;
    private double[] csArray = null;
    private PolyCubicSplineFast[] pcs = null;
    private int dimOne = 0;
    private double yValue = 0.0;

    public PolyCubicSplineFast(Object xArrays, Object fOfX) {
        this.fOfX = Fmath.copyObject(fOfX);
        this.xArrays = Fmath.copyObject(xArrays);
        Object internalArrays = Fmath.copyObject(fOfX);
        this.nDimensions = 1;
        while (!((internalArrays = Array.get(internalArrays, 0)) instanceof Double)) {
            ++this.nDimensions;
        }
        if (this.xArrays instanceof double[] && this.nDimensions == 1) {
            double[][] xArraysTemp = new double[][]{(double[])this.xArrays};
            this.xArrays = xArraysTemp;
        } else if (!(this.xArrays instanceof double[][])) {
            throw new IllegalArgumentException("xArrays should be a two dimensional array of doubles");
        }
        this.xArray = (double[][])this.xArrays;
        switch (this.nDimensions) {
            case 0: {
                throw new IllegalArgumentException("data array must have at least one dimension");
            }
            case 1: {
                CubicSplineFast cs = new CubicSplineFast(this.xArray[0], (double[])this.fOfX);
                this.method = cs;
                break;
            }
            case 2: {
                BiCubicSplineFast bcs = new BiCubicSplineFast(this.xArray[0], this.xArray[1], (double[][])this.fOfX);
                this.method = bcs;
                break;
            }
            default: {
                Object obj = fOfX;
                this.dimOne = Array.getLength(obj);
                this.csArray = new double[this.dimOne];
                double[][] newXarrays = new double[this.nDimensions - 1][];
                int i = 0;
                while (i < this.nDimensions - 1) {
                    newXarrays[i] = this.xArray[i + 1];
                    ++i;
                }
                this.pcs = new PolyCubicSplineFast[this.dimOne];
                i = 0;
                while (i < this.dimOne) {
                    Object objT = Array.get(obj, i);
                    this.pcs[i] = new PolyCubicSplineFast(newXarrays, objT);
                    ++i;
                }
                break block0;
            }
        }
    }

    public double interpolate(double[] unknownCoord) {
        int nUnknown = unknownCoord.length;
        if (nUnknown != this.nDimensions) {
            throw new IllegalArgumentException("Number of unknown value coordinates, " + nUnknown + ", does not equal the number of tabulated data dimensions, " + this.nDimensions);
        }
        switch (this.nDimensions) {
            case 0: {
                throw new IllegalArgumentException("data array must have at least one dimension");
            }
            case 1: {
                this.yValue = ((CubicSplineFast)this.method).interpolate(unknownCoord[0]);
                break;
            }
            case 2: {
                this.yValue = ((BiCubicSplineFast)this.method).interpolate(unknownCoord[0], unknownCoord[1]);
                break;
            }
            default: {
                double[] newCoord = new double[this.nDimensions - 1];
                int i = 0;
                while (i < this.nDimensions - 1) {
                    newCoord[i] = unknownCoord[i + 1];
                    ++i;
                }
                i = 0;
                while (i < this.dimOne) {
                    this.csArray[i] = this.pcs[i].interpolate(newCoord);
                    ++i;
                }
                CubicSplineFast ncs = new CubicSplineFast(this.xArray[0], this.csArray);
                this.yValue = ncs.interpolate(unknownCoord[0]);
            }
        }
        return this.yValue;
    }
}

