/*
 * Decompiled with CFR 0.152.
 */
package flanagan.interpolation;

import flanagan.interpolation.CubicSpline;
import flanagan.math.Fmath;

public class BiCubicSplinePartialDerivative {
    private int nPoints = 0;
    private int mPoints = 0;
    private double[][] y = null;
    private double[] x1 = null;
    private double[] x2 = null;
    private double[] xMin = new double[2];
    private double[] xMax = new double[2];
    private CubicSpline[] csn = null;
    private CubicSpline csm = null;
    private boolean derivCalculated = false;
    private boolean averageIdenticalAbscissae = false;
    private static double potentialRoundingError = 5.0E-15;
    private static boolean roundingCheck = true;

    public BiCubicSplinePartialDerivative(double[] x1, double[] x2, double[][] y) {
        this.nPoints = x1.length;
        this.mPoints = x2.length;
        if (this.nPoints != y.length) {
            throw new IllegalArgumentException("Arrays x1 and y-row are of different length " + this.nPoints + " " + y.length);
        }
        if (this.mPoints != y[0].length) {
            throw new IllegalArgumentException("Arrays x2 and y-column are of different length " + this.mPoints + " " + y[0].length);
        }
        if (this.nPoints < 3 || this.mPoints < 3) {
            throw new IllegalArgumentException("The data matrix must have a minimum size of 3 X 3");
        }
        this.csm = new CubicSpline(this.nPoints);
        this.csn = CubicSpline.oneDarray(this.nPoints, this.mPoints);
        this.x1 = new double[this.nPoints];
        this.x2 = new double[this.mPoints];
        this.y = new double[this.nPoints][this.mPoints];
        int i = 0;
        while (i < this.nPoints) {
            this.x1[i] = x1[i];
            ++i;
        }
        this.xMin[0] = Fmath.minimum(this.x1);
        this.xMax[0] = Fmath.maximum(this.x1);
        int j = 0;
        while (j < this.mPoints) {
            this.x2[j] = x2[j];
            ++j;
        }
        this.xMin[1] = Fmath.minimum(this.x2);
        this.xMax[1] = Fmath.maximum(this.x2);
        i = 0;
        while (i < this.nPoints) {
            int j2 = 0;
            while (j2 < this.mPoints) {
                this.y[i][j2] = y[i][j2];
                ++j2;
            }
            ++i;
        }
        double[] yTempn = new double[this.mPoints];
        int i2 = 0;
        while (i2 < this.nPoints) {
            int j3 = 0;
            while (j3 < this.mPoints) {
                yTempn[j3] = y[i2][j3];
                ++j3;
            }
            this.csn[i2].resetData(x2, yTempn);
            this.csn[i2].calcDeriv();
            ++i2;
        }
        this.derivCalculated = true;
    }

    public static void noRoundingErrorCheck() {
        roundingCheck = false;
        CubicSpline.noRoundingErrorCheck();
    }

    public static void potentialRoundingError(double potentialRoundingError) {
        BiCubicSplinePartialDerivative.potentialRoundingError = potentialRoundingError;
        CubicSpline.potentialRoundingError(potentialRoundingError);
    }

    public void averageIdenticalAbscissae() {
        this.averageIdenticalAbscissae = true;
        int i = 0;
        while (i < this.csn.length) {
            CubicSpline cfr_ignored_0 = this.csn[i];
            CubicSpline.averageIdenticalAbscissae();
            ++i;
        }
        CubicSpline.averageIdenticalAbscissae();
    }

    public double[] getXmin() {
        return this.xMin;
    }

    public double[] getXmax() {
        return this.xMax;
    }

    public double[] getLimits() {
        double[] limits = new double[]{this.xMin[0], this.xMax[0], this.xMin[1], this.xMax[1]};
        return limits;
    }

    public void displayLimits() {
        System.out.println(" ");
        int i = 0;
        while (i < 2) {
            System.out.println("The limits to the x array " + i + " are " + this.xMin[i] + " and " + this.xMax[i]);
            ++i;
        }
        System.out.println(" ");
    }

    public double[] interpolate(double xx1, double xx2) {
        double[] yTempm = new double[this.nPoints];
        int i = 0;
        while (i < this.nPoints) {
            yTempm[i] = this.csn[i].interpolate(xx2);
            ++i;
        }
        this.csm.resetData(this.x1, yTempm);
        return this.csm.interpolate_for_y_and_dydx(xx1);
    }
}

