/*
 * Decompiled with CFR 0.152.
 */
package flanagan.integration;

import flanagan.integration.DerivFunction;
import flanagan.integration.DerivnFunction;
import flanagan.math.Conv;

public class RungeKutta {
    private double x0 = Double.NaN;
    private double xn = Double.NaN;
    private double y0 = Double.NaN;
    private double[] yy0 = null;
    private int nODE = 0;
    private double step = Double.NaN;
    private double relTol = 1.0E-5;
    private double absTol = 0.001;
    private int maxIter = -1;
    private int nIter = 0;
    private static int nStepsMultiplier = 1000;
    private static double safetyFactor = 0.9;
    private static double incrementFactor = -0.2;
    private static double decrementFactor = -0.25;

    public void setInitialValueOfX(double x0) {
        this.x0 = x0;
    }

    public void setFinalValueOfX(double xn) {
        this.xn = xn;
    }

    public void setInitialValueOfY(double y0) {
        this.setInitialValuesOfY(y0);
    }

    public void setInitialValueOfY(double[] yy0) {
        this.setInitialValuesOfY(yy0);
    }

    public void setInitialValuesOfY(double y0) {
        this.y0 = y0;
        this.yy0 = new double[1];
        this.yy0[0] = y0;
        this.nODE = 1;
    }

    public void setInitialValuesOfY(double[] yy0) {
        this.yy0 = yy0;
        this.nODE = yy0.length;
        if (this.nODE == 1) {
            this.y0 = yy0[0];
        }
    }

    public void setStepSize(double step2) {
        this.step = step2;
    }

    public void setToleranceScalingFactor(double relTol) {
        this.relTol = relTol;
    }

    public void setToleranceAdditionFactor(double absTol) {
        this.absTol = absTol;
    }

    public void setMaximumIterations(int maxIter) {
        this.maxIter = maxIter;
    }

    public int getNumberOfIterations() {
        return this.nIter;
    }

    public static void resetNstepsMultiplier(int multiplier) {
        nStepsMultiplier = multiplier;
    }

    public double fourthOrder(DerivFunction g) {
        int nsteps;
        if (Double.isNaN(this.x0)) {
            throw new IllegalArgumentException("No initial x value has been entered");
        }
        if (Double.isNaN(this.xn)) {
            throw new IllegalArgumentException("No final x value has been entered");
        }
        if (Double.isNaN(this.y0)) {
            throw new IllegalArgumentException("No initial y value has been entered");
        }
        if (Double.isNaN(this.step)) {
            throw new IllegalArgumentException("No step size has been entered");
        }
        double k1 = 0.0;
        double k2 = 0.0;
        double k3 = 0.0;
        double k4 = 0.0;
        double x2 = 0.0;
        double y = this.y0;
        double ns = (this.xn - this.x0) / this.step;
        ns = Math.rint(ns);
        this.nIter = nsteps = (int)ns;
        double stepUsed = (this.xn - this.x0) / ns;
        int i = 0;
        while (i < nsteps) {
            x2 = this.x0 + (double)i * stepUsed;
            k1 = stepUsed * g.deriv(x2, y);
            k2 = stepUsed * g.deriv(x2 + stepUsed / 2.0, y + k1 / 2.0);
            k3 = stepUsed * g.deriv(x2 + stepUsed / 2.0, y + k2 / 2.0);
            k4 = stepUsed * g.deriv(x2 + stepUsed, y + k3);
            y += k1 / 6.0 + k2 / 3.0 + k3 / 3.0 + k4 / 6.0;
            ++i;
        }
        return y;
    }

    public static double fourthOrder(DerivFunction g, double x0, double y0, double xn, double h) {
        RungeKutta rk = new RungeKutta();
        rk.setInitialValueOfX(x0);
        rk.setFinalValueOfX(xn);
        rk.setInitialValueOfY(y0);
        rk.setStepSize(h);
        return rk.fourthOrder(g);
    }

    public double[] fourthOrder(DerivnFunction g) {
        int nsteps;
        if (Double.isNaN(this.x0)) {
            throw new IllegalArgumentException("No initial x value has been entered");
        }
        if (Double.isNaN(this.xn)) {
            throw new IllegalArgumentException("No final x value has been entered");
        }
        if (this.yy0 == null) {
            throw new IllegalArgumentException("No initial y values have been entered");
        }
        if (Double.isNaN(this.step)) {
            throw new IllegalArgumentException("No step size has been entered");
        }
        double[] k1 = new double[this.nODE];
        double[] k2 = new double[this.nODE];
        double[] k3 = new double[this.nODE];
        double[] k4 = new double[this.nODE];
        double[] y = new double[this.nODE];
        double[] yd = new double[this.nODE];
        double[] dydx = new double[this.nODE];
        double x2 = 0.0;
        double ns = (this.xn - this.x0) / this.step;
        ns = Math.rint(ns);
        this.nIter = nsteps = (int)ns;
        double stepUsed = (this.xn - this.x0) / ns;
        int i = 0;
        while (i < this.nODE) {
            y[i] = this.yy0[i];
            ++i;
        }
        int j = 0;
        while (j < nsteps) {
            x2 = this.x0 + (double)j * stepUsed;
            dydx = g.derivn(x2, y);
            int i2 = 0;
            while (i2 < this.nODE) {
                k1[i2] = stepUsed * dydx[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < this.nODE) {
                yd[i2] = y[i2] + k1[i2] / 2.0;
                ++i2;
            }
            dydx = g.derivn(x2 + stepUsed / 2.0, yd);
            i2 = 0;
            while (i2 < this.nODE) {
                k2[i2] = stepUsed * dydx[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < this.nODE) {
                yd[i2] = y[i2] + k2[i2] / 2.0;
                ++i2;
            }
            dydx = g.derivn(x2 + stepUsed / 2.0, yd);
            i2 = 0;
            while (i2 < this.nODE) {
                k3[i2] = stepUsed * dydx[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < this.nODE) {
                yd[i2] = y[i2] + k3[i2];
                ++i2;
            }
            dydx = g.derivn(x2 + stepUsed, yd);
            i2 = 0;
            while (i2 < this.nODE) {
                k4[i2] = stepUsed * dydx[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < this.nODE) {
                int n = i2;
                y[n] = y[n] + (k1[i2] / 6.0 + k2[i2] / 3.0 + k3[i2] / 3.0 + k4[i2] / 6.0);
                ++i2;
            }
            ++j;
        }
        return y;
    }

    public static double[] fourthOrder(DerivnFunction g, double x0, double[] y0, double xn, double h) {
        RungeKutta rk = new RungeKutta();
        rk.setInitialValueOfX(x0);
        rk.setFinalValueOfX(xn);
        rk.setInitialValuesOfY(y0);
        rk.setStepSize(h);
        return rk.fourthOrder(g);
    }

    public double cashKarp(DerivFunction g) {
        if (Double.isNaN(this.x0)) {
            throw new IllegalArgumentException("No initial x value has been entered");
        }
        if (Double.isNaN(this.xn)) {
            throw new IllegalArgumentException("No final x value has been entered");
        }
        if (Double.isNaN(this.y0)) {
            throw new IllegalArgumentException("No initial y value has been entered");
        }
        if (Double.isNaN(this.step)) {
            throw new IllegalArgumentException("No step size has been entered");
        }
        double k1 = 0.0;
        double k2 = 0.0;
        double k3 = 0.0;
        double k4 = 0.0;
        double k5 = 0.0;
        double k6 = 0.0;
        double y = this.y0;
        double y5 = 0.0;
        double y6 = 0.0;
        double yd = 0.0;
        double dydx = 0.0;
        double x2 = this.x0;
        double err2 = 0.0;
        double delta = 0.0;
        double tol = 0.0;
        int counter = 0;
        if (this.maxIter == -1) {
            this.maxIter = (int)((double)nStepsMultiplier * (this.xn - this.x0) / this.step);
        }
        double stepUsed = this.step;
        while (x2 < this.xn) {
            if (++counter > this.maxIter) {
                throw new ArithmeticException("Maximum number of iterations exceeded");
            }
            dydx = g.deriv(x2, y);
            k1 = stepUsed * dydx;
            yd = y + k1 / 5.0;
            dydx = g.deriv(x2 + stepUsed / 5.0, yd);
            k2 = stepUsed * dydx;
            yd = y + (3.0 * k1 + 9.0 * k2) / 40.0;
            dydx = g.deriv(x2 + 3.0 * stepUsed / 10.0, yd);
            k3 = stepUsed * dydx;
            yd = y + (3.0 * k1 - 9.0 * k2 + 12.0 * k3) / 10.0;
            dydx = g.deriv(x2 + 3.0 * stepUsed / 5.0, yd);
            k4 = stepUsed * dydx;
            yd = y - 11.0 * k1 / 54.0 + 5.0 * k2 / 2.0 - 70.0 * k3 / 27.0 + 35.0 * k4 / 27.0;
            dydx = g.deriv(x2 + stepUsed, yd);
            k5 = stepUsed * dydx;
            yd = y + 1631.0 * k1 / 55296.0 + 175.0 * k2 / 512.0 + 575.0 * k3 / 13824.0 + 44275.0 * k4 / 110592.0 + 253.0 * k5 / 4096.0;
            k6 = stepUsed * (dydx = g.deriv(x2 + 7.0 * stepUsed / 8.0, yd));
            y6 = y + 37.0 * k1 / 378.0 + 250.0 * k3 / 621.0 + 125.0 * k4 / 594.0 + 512.0 * k6 / 1771.0;
            err2 = Math.abs(y6 - (y5 = y + 2825.0 * k1 / 27648.0 + 18575.0 * k3 / 48384.0 + 13525.0 * k4 / 55296.0 + 277.0 * k5 / 14336.0 + k6 / 4.0));
            tol = err2 / (Math.abs(y5) * this.relTol + this.absTol);
            if (tol <= 1.0) {
                x2 += stepUsed;
                delta = safetyFactor * Math.pow(tol, incrementFactor);
                if (delta > 4.0) {
                    stepUsed *= 4.0;
                } else if (delta > 1.0) {
                    stepUsed *= delta;
                }
                if (x2 + stepUsed > this.xn) {
                    stepUsed = this.xn - x2;
                }
                y = y5;
                continue;
            }
            delta = safetyFactor * Math.pow(tol, decrementFactor);
            if (delta < 0.1) {
                stepUsed *= 0.1;
                continue;
            }
            stepUsed *= delta;
        }
        this.nIter = counter;
        return y;
    }

    public static double cashKarp(DerivFunction g, double x0, double y0, double xn, double h, double absTol, double relTol, int maxIter) {
        RungeKutta rk = new RungeKutta();
        rk.setInitialValueOfX(x0);
        rk.setFinalValueOfX(xn);
        rk.setInitialValueOfY(y0);
        rk.setStepSize(h);
        rk.setToleranceScalingFactor(relTol);
        rk.setToleranceAdditionFactor(absTol);
        rk.setMaximumIterations(maxIter);
        return rk.cashKarp(g);
    }

    public static double cashKarp(DerivFunction g, double x0, double y0, double xn, double h, double absTol, double relTol) {
        int maxIter = (int)((double)nStepsMultiplier * (xn - x0) / h);
        RungeKutta rk = new RungeKutta();
        rk.setInitialValueOfX(x0);
        rk.setFinalValueOfX(xn);
        rk.setInitialValueOfY(y0);
        rk.setStepSize(h);
        rk.setToleranceScalingFactor(relTol);
        rk.setToleranceAdditionFactor(absTol);
        rk.setMaximumIterations(maxIter);
        return rk.cashKarp(g);
    }

    public double[] cashKarp(DerivnFunction g) {
        if (Double.isNaN(this.x0)) {
            throw new IllegalArgumentException("No initial x value has been entered");
        }
        if (Double.isNaN(this.xn)) {
            throw new IllegalArgumentException("No final x value has been entered");
        }
        if (this.yy0 == null) {
            throw new IllegalArgumentException("No initial y values have been entered");
        }
        if (Double.isNaN(this.step)) {
            throw new IllegalArgumentException("No step size has been entered");
        }
        double[] k1 = new double[this.nODE];
        double[] k2 = new double[this.nODE];
        double[] k3 = new double[this.nODE];
        double[] k4 = new double[this.nODE];
        double[] k5 = new double[this.nODE];
        double[] k6 = new double[this.nODE];
        double[] y = new double[this.nODE];
        double[] y6 = new double[this.nODE];
        double[] y5 = new double[this.nODE];
        double[] yd = new double[this.nODE];
        double[] dydx = new double[this.nODE];
        double err2 = 0.0;
        double maxerr = 0.0;
        double delta = 0.0;
        double tol = 1.0;
        int counter = 0;
        int i = 0;
        while (i < this.nODE) {
            y[i] = this.yy0[i];
            ++i;
        }
        double x2 = this.x0;
        if (this.maxIter == -1) {
            this.maxIter = (int)((double)nStepsMultiplier * (this.xn - this.x0) / this.step);
        }
        double stepUsed = this.step;
        while (x2 < this.xn) {
            if (++counter > this.maxIter) {
                throw new ArithmeticException("Maximum number of iterations exceeded");
            }
            dydx = g.derivn(x2, y);
            int i2 = 0;
            while (i2 < this.nODE) {
                k1[i2] = stepUsed * dydx[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < this.nODE) {
                yd[i2] = y[i2] + k1[i2] / 5.0;
                ++i2;
            }
            dydx = g.derivn(x2 + stepUsed / 5.0, yd);
            i2 = 0;
            while (i2 < this.nODE) {
                k2[i2] = stepUsed * dydx[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < this.nODE) {
                yd[i2] = y[i2] + (3.0 * k1[i2] + 9.0 * k2[i2]) / 40.0;
                ++i2;
            }
            dydx = g.derivn(x2 + 3.0 * stepUsed / 10.0, yd);
            i2 = 0;
            while (i2 < this.nODE) {
                k3[i2] = stepUsed * dydx[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < this.nODE) {
                yd[i2] = y[i2] + (3.0 * k1[i2] - 9.0 * k2[i2] + 12.0 * k3[i2]) / 10.0;
                ++i2;
            }
            dydx = g.derivn(x2 + 3.0 * stepUsed / 5.0, yd);
            i2 = 0;
            while (i2 < this.nODE) {
                k4[i2] = stepUsed * dydx[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < this.nODE) {
                yd[i2] = y[i2] - 11.0 * k1[i2] / 54.0 + 5.0 * k2[i2] / 2.0 - 70.0 * k3[i2] / 27.0 + 35.0 * k4[i2] / 27.0;
                ++i2;
            }
            dydx = g.derivn(x2 + stepUsed, yd);
            i2 = 0;
            while (i2 < this.nODE) {
                k5[i2] = stepUsed * dydx[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < this.nODE) {
                yd[i2] = y[i2] + 1631.0 * k1[i2] / 55296.0 + 175.0 * k2[i2] / 512.0 + 575.0 * k3[i2] / 13824.0 + 44275.0 * k4[i2] / 110592.0 + 253.0 * k5[i2] / 4096.0;
                ++i2;
            }
            dydx = g.derivn(x2 + 7.0 * stepUsed / 8.0, yd);
            i2 = 0;
            while (i2 < this.nODE) {
                k6[i2] = stepUsed * dydx[i2];
                ++i2;
            }
            maxerr = 0.0;
            i2 = 0;
            while (i2 < this.nODE) {
                y5[i2] = y[i2] + 2825.0 * k1[i2] / 27648.0 + 18575.0 * k3[i2] / 48384.0 + 13525.0 * k4[i2] / 55296.0 + 277.0 * k5[i2] / 14336.0 + k6[i2] / 4.0;
                y6[i2] = y[i2] + 37.0 * k1[i2] / 378.0 + 250.0 * k3[i2] / 621.0 + 125.0 * k4[i2] / 594.0 + 512.0 * k6[i2] / 1771.0;
                err2 = Math.abs(y6[i2] - y5[i2]);
                tol = Math.abs(y5[i2]) * this.relTol + this.absTol;
                maxerr = Math.max(maxerr, err2 / tol);
                ++i2;
            }
            if (maxerr <= 1.0) {
                x2 += stepUsed;
                delta = safetyFactor * Math.pow(maxerr, incrementFactor);
                if (delta > 4.0) {
                    stepUsed *= 4.0;
                } else if (delta > 1.0) {
                    stepUsed *= delta;
                }
                if (x2 + stepUsed > this.xn) {
                    stepUsed = this.xn - x2;
                }
                y = Conv.copy(y5);
                continue;
            }
            delta = safetyFactor * Math.pow(maxerr, decrementFactor);
            if (delta < 0.1) {
                stepUsed *= 0.1;
                continue;
            }
            stepUsed *= delta;
        }
        this.nIter = counter;
        return y;
    }

    public static double[] cashKarp(DerivnFunction g, double x0, double[] y0, double xn, double h, double absTol, double relTol, int maxIter) {
        RungeKutta rk = new RungeKutta();
        rk.setInitialValueOfX(x0);
        rk.setFinalValueOfX(xn);
        rk.setInitialValuesOfY(y0);
        rk.setStepSize(h);
        rk.setToleranceScalingFactor(relTol);
        rk.setToleranceAdditionFactor(absTol);
        rk.setMaximumIterations(maxIter);
        return rk.cashKarp(g);
    }

    public static double[] cashKarp(DerivnFunction g, double x0, double[] y0, double xn, double h, double absTol, double relTol) {
        double nsteps = (xn - x0) / h;
        int maxIter = (int)nsteps * nStepsMultiplier;
        return RungeKutta.cashKarp(g, x0, y0, xn, h, absTol, relTol, maxIter);
    }

    public double fehlberg(DerivFunction g) {
        if (Double.isNaN(this.x0)) {
            throw new IllegalArgumentException("No initial x value has been entered");
        }
        if (Double.isNaN(this.xn)) {
            throw new IllegalArgumentException("No final x value has been entered");
        }
        if (Double.isNaN(this.y0)) {
            throw new IllegalArgumentException("No initial y value has been entered");
        }
        if (Double.isNaN(this.step)) {
            throw new IllegalArgumentException("No step size has been entered");
        }
        double k1 = 0.0;
        double k2 = 0.0;
        double k3 = 0.0;
        double k4 = 0.0;
        double k5 = 0.0;
        double k6 = 0.0;
        double x2 = this.x0;
        double y = this.y0;
        double y5 = 0.0;
        double y6 = 0.0;
        double err2 = 0.0;
        double delta = 0.0;
        double tol = 0.0;
        int counter = 0;
        if (this.maxIter == -1) {
            this.maxIter = (int)((double)nStepsMultiplier * (this.xn - this.x0) / this.step);
        }
        double stepUsed = this.step;
        while (x2 < this.xn) {
            if (++counter > this.maxIter) {
                throw new ArithmeticException("Maximum number of iterations exceeded");
            }
            k1 = stepUsed * g.deriv(x2, y);
            y6 = y + 16.0 * k1 / 135.0 + 6656.0 * (k3 = stepUsed * g.deriv(x2 + 3.0 * stepUsed / 8.0, y + (3.0 * k1 + 9.0 * (k2 = stepUsed * g.deriv(x2 + stepUsed / 4.0, y + k1 / 4.0))) / 32.0)) / 12825.0 + 28561.0 * (k4 = stepUsed * g.deriv(x2 + 12.0 * stepUsed / 13.0, y + (1932.0 * k1 - 7200.0 * k2 + 7296.0 * k3) / 2197.0)) / 56430.0 - 9.0 * (k5 = stepUsed * g.deriv(x2 + stepUsed, y + 439.0 * k1 / 216.0 - 8.0 * k2 + 3680.0 * k3 / 513.0 - 845.0 * k4 / 4104.0)) / 50.0 + 2.0 * (k6 = stepUsed * g.deriv(x2 + 0.5 * stepUsed, y - 8.0 * k1 / 27.0 + 2.0 * k2 - 3544.0 * k3 / 2565.0 + 1859.0 * k4 / 4104.0 - 11.0 * k5 / 40.0)) / 55.0;
            err2 = Math.abs(y6 - (y5 = y + 25.0 * k1 / 216.0 + 1408.0 * k3 / 2565.0 + 2197.0 * k4 / 4104.0 - k5 / 5.0));
            tol = err2 / (Math.abs(y5) * this.relTol + this.absTol);
            if (tol <= 1.0) {
                x2 += stepUsed;
                delta = safetyFactor * Math.pow(tol, incrementFactor);
                if (delta > 4.0) {
                    stepUsed *= 4.0;
                } else if (delta < 1.0) {
                    stepUsed *= delta;
                }
                if (x2 + stepUsed > this.xn) {
                    stepUsed = this.xn - x2;
                }
                y = y5;
                continue;
            }
            delta = safetyFactor * Math.pow(tol, decrementFactor);
            if (delta < 0.1) {
                stepUsed *= 0.1;
                continue;
            }
            stepUsed *= delta;
        }
        this.nIter = counter;
        return y;
    }

    public static double fehlberg(DerivFunction g, double x0, double y0, double xn, double h, double absTol, double relTol, int maxIter) {
        RungeKutta rk = new RungeKutta();
        rk.setInitialValueOfX(x0);
        rk.setFinalValueOfX(xn);
        rk.setInitialValueOfY(y0);
        rk.setStepSize(h);
        rk.setToleranceScalingFactor(relTol);
        rk.setToleranceAdditionFactor(absTol);
        rk.setMaximumIterations(maxIter);
        return rk.fehlberg(g);
    }

    public static double fehlberg(DerivFunction g, double x0, double y0, double xn, double h, double absTol, double relTol) {
        double nsteps = (xn - x0) / h;
        int maxIter = (int)nsteps * nStepsMultiplier;
        return RungeKutta.fehlberg(g, x0, y0, xn, h, absTol, relTol, maxIter);
    }

    public double[] fehlberg(DerivnFunction g) {
        if (Double.isNaN(this.x0)) {
            throw new IllegalArgumentException("No initial x value has been entered");
        }
        if (Double.isNaN(this.xn)) {
            throw new IllegalArgumentException("No final x value has been entered");
        }
        if (this.yy0 == null) {
            throw new IllegalArgumentException("No initial y values have been entered");
        }
        if (Double.isNaN(this.step)) {
            throw new IllegalArgumentException("No step size has been entered");
        }
        double[] k1 = new double[this.nODE];
        double[] k2 = new double[this.nODE];
        double[] k3 = new double[this.nODE];
        double[] k4 = new double[this.nODE];
        double[] k5 = new double[this.nODE];
        double[] k6 = new double[this.nODE];
        double[] y = new double[this.nODE];
        double[] y6 = new double[this.nODE];
        double[] y5 = new double[this.nODE];
        double[] yd = new double[this.nODE];
        double[] dydx = new double[this.nODE];
        double err2 = 0.0;
        double maxerr = 0.0;
        double delta = 0.0;
        double tol = 1.0;
        int counter = 0;
        int i = 0;
        while (i < this.nODE) {
            y[i] = this.yy0[i];
            ++i;
        }
        double x2 = this.x0;
        if (this.maxIter == -1) {
            this.maxIter = (int)((double)nStepsMultiplier * (this.xn - this.x0) / this.step);
        }
        double stepUsed = this.step;
        while (x2 < this.xn) {
            if (++counter > this.maxIter) {
                throw new ArithmeticException("Maximum number of iterations exceeded");
            }
            dydx = g.derivn(x2, y);
            int i2 = 0;
            while (i2 < this.nODE) {
                k1[i2] = stepUsed * dydx[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < this.nODE) {
                yd[i2] = y[i2] + k1[i2] / 4.0;
                ++i2;
            }
            dydx = g.derivn(x2 + stepUsed / 4.0, yd);
            i2 = 0;
            while (i2 < this.nODE) {
                k2[i2] = stepUsed * dydx[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < this.nODE) {
                yd[i2] = y[i2] + (3.0 * k1[i2] + 9.0 * k2[i2]) / 32.0;
                ++i2;
            }
            dydx = g.derivn(x2 + 3.0 * stepUsed / 8.0, yd);
            i2 = 0;
            while (i2 < this.nODE) {
                k3[i2] = stepUsed * dydx[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < this.nODE) {
                yd[i2] = y[i2] + (1932.0 * k1[i2] - 7200.0 * k2[i2] + 7296.0 * k3[i2]) / 2197.0;
                ++i2;
            }
            dydx = g.derivn(x2 + 12.0 * stepUsed / 13.0, yd);
            i2 = 0;
            while (i2 < this.nODE) {
                k4[i2] = stepUsed * dydx[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < this.nODE) {
                yd[i2] = y[i2] + 439.0 * k1[i2] / 216.0 - 8.0 * k2[i2] + 3680.0 * k3[i2] / 513.0 - 845.0 * k4[i2] / 4104.0;
                ++i2;
            }
            dydx = g.derivn(x2 + stepUsed, yd);
            i2 = 0;
            while (i2 < this.nODE) {
                k5[i2] = stepUsed * dydx[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < this.nODE) {
                yd[i2] = y[i2] - 8.0 * k1[i2] / 27.0 + 2.0 * k2[i2] - 3544.0 * k3[i2] / 2565.0 + 1859.0 * k4[i2] / 4104.0 - 11.0 * k5[i2] / 40.0;
                ++i2;
            }
            dydx = g.derivn(x2 + 0.5 * stepUsed, yd);
            i2 = 0;
            while (i2 < this.nODE) {
                k6[i2] = stepUsed * dydx[i2];
                ++i2;
            }
            maxerr = 0.0;
            i2 = 0;
            while (i2 < this.nODE) {
                y5[i2] = y[i2] + 25.0 * k1[i2] / 216.0 + 1408.0 * k3[i2] / 2565.0 + 2197.0 * k4[i2] / 4104.0 - k5[i2] / 5.0;
                y6[i2] = y[i2] + 16.0 * k1[i2] / 135.0 + 6656.0 * k3[i2] / 12825.0 + 28561.0 * k4[i2] / 56430.0 - 9.0 * k5[i2] / 50.0 + 2.0 * k6[i2] / 55.0;
                err2 = Math.abs(y6[i2] - y5[i2]);
                tol = y5[i2] * this.relTol + this.absTol;
                maxerr = Math.max(maxerr, err2 / tol);
                ++i2;
            }
            if (maxerr <= 1.0) {
                x2 += stepUsed;
                delta = safetyFactor * Math.pow(maxerr, incrementFactor);
                if (delta > 4.0) {
                    stepUsed *= 4.0;
                } else if (delta > 1.0) {
                    stepUsed *= delta;
                }
                if (x2 + stepUsed > this.xn) {
                    stepUsed = this.xn - x2;
                }
                y = Conv.copy(y5);
                continue;
            }
            delta = safetyFactor * Math.pow(maxerr, decrementFactor);
            if (delta < 0.1) {
                stepUsed *= 0.1;
                continue;
            }
            stepUsed *= delta;
        }
        this.nIter = counter;
        return y;
    }

    public static double[] fehlberg(DerivnFunction g, double x0, double[] y0, double xn, double h, double absTol, double relTol, int maxIter) {
        RungeKutta rk = new RungeKutta();
        rk.setInitialValueOfX(x0);
        rk.setFinalValueOfX(xn);
        rk.setInitialValuesOfY(y0);
        rk.setStepSize(h);
        rk.setToleranceScalingFactor(relTol);
        rk.setToleranceAdditionFactor(absTol);
        rk.setMaximumIterations(maxIter);
        return rk.fehlberg(g);
    }

    public static double[] fehlberg(DerivnFunction g, double x0, double[] y0, double xn, double h, double absTol, double relTol) {
        double nsteps = (xn - x0) / h;
        int maxIter = (int)nsteps * nStepsMultiplier;
        return RungeKutta.fehlberg(g, x0, y0, xn, h, absTol, relTol, maxIter);
    }
}

