/*
 * Decompiled with CFR 0.152.
 */
package flanagan.integration;

import flanagan.integration.IntegralFunction;
import flanagan.math.Fmath;
import java.util.ArrayList;

public class Integration {
    private IntegralFunction integralFunc = null;
    private boolean setFunction = false;
    private double lowerLimit = Double.NaN;
    private double upperLimit = Double.NaN;
    private boolean setLimits = false;
    private int glPoints = 0;
    private boolean setGLpoints = false;
    private int nIntervals = 0;
    private boolean setIntervals = false;
    private double integralSum = 0.0;
    private boolean setIntegration = false;
    private static ArrayList<Integer> gaussQuadIndex = new ArrayList();
    private static ArrayList<double[]> gaussQuadDistArrayList = new ArrayList();
    private static ArrayList<double[]> gaussQuadWeightArrayList = new ArrayList();
    private double requiredAccuracy = 0.0;
    private double trapeziumAccuracy = 0.0;
    private static double trapAccuracy = 0.0;
    private int maxIntervals = 0;
    private int trapeziumIntervals = 1;
    private static int trapIntervals = 1;

    public Integration() {
    }

    public Integration(IntegralFunction intFunc) {
        this.integralFunc = intFunc;
        this.setFunction = true;
    }

    public Integration(IntegralFunction intFunc, double lowerLimit, double upperLimit) {
        this.integralFunc = intFunc;
        this.setFunction = true;
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.setLimits = true;
    }

    public void setIntegrationFunction(IntegralFunction intFunc) {
        this.integralFunc = intFunc;
        this.setFunction = true;
    }

    public void setLimits(double lowerLimit, double upperLimit) {
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.setLimits = true;
    }

    public void setLowerLimit(double lowerLimit) {
        this.lowerLimit = lowerLimit;
        if (!Fmath.isNaN(this.upperLimit)) {
            this.setLimits = true;
        }
    }

    public void setlowerLimit(double lowerLimit) {
        this.lowerLimit = lowerLimit;
        if (!Fmath.isNaN(this.upperLimit)) {
            this.setLimits = true;
        }
    }

    public void setUpperLimit(double upperLimit) {
        this.upperLimit = upperLimit;
        if (!Fmath.isNaN(this.lowerLimit)) {
            this.setLimits = true;
        }
    }

    public void setupperLimit(double upperLimit) {
        this.upperLimit = upperLimit;
        if (!Fmath.isNaN(this.lowerLimit)) {
            this.setLimits = true;
        }
    }

    public void setGLpoints(int nPoints) {
        this.glPoints = nPoints;
        this.setGLpoints = true;
    }

    public void setNintervals(int nIntervals) {
        this.nIntervals = nIntervals;
        this.setIntervals = true;
    }

    public double getIntegralSum() {
        if (!this.setIntegration) {
            throw new IllegalArgumentException("No integration has been performed");
        }
        return this.integralSum;
    }

    public double gaussQuad() {
        if (!this.setGLpoints) {
            throw new IllegalArgumentException("Number of points not set");
        }
        if (!this.setLimits) {
            throw new IllegalArgumentException("One limit or both limits not set");
        }
        if (!this.setFunction) {
            throw new IllegalArgumentException("No integral function has been set");
        }
        double[] gaussQuadDist = new double[this.glPoints];
        double[] gaussQuadWeight = new double[this.glPoints];
        double sum2 = 0.0;
        double xplus = 0.5 * (this.upperLimit + this.lowerLimit);
        double xminus = 0.5 * (this.upperLimit - this.lowerLimit);
        double dx = 0.0;
        boolean test2 = true;
        int k = -1;
        int kn = -1;
        if (!gaussQuadIndex.isEmpty()) {
            k = 0;
            while (k < gaussQuadIndex.size()) {
                Integer ki = gaussQuadIndex.get(k);
                if (ki == this.glPoints) {
                    test2 = false;
                    kn = k;
                }
                ++k;
            }
        }
        if (test2) {
            Integration.gaussQuadCoeff(gaussQuadDist, gaussQuadWeight, this.glPoints);
            gaussQuadIndex.add(new Integer(this.glPoints));
            gaussQuadDistArrayList.add(gaussQuadDist);
            gaussQuadWeightArrayList.add(gaussQuadWeight);
        } else {
            gaussQuadDist = gaussQuadDistArrayList.get(kn);
            gaussQuadWeight = gaussQuadWeightArrayList.get(kn);
        }
        int i = 0;
        while (i < this.glPoints) {
            dx = xminus * gaussQuadDist[i];
            sum2 += gaussQuadWeight[i] * this.integralFunc.function(xplus + dx);
            ++i;
        }
        this.integralSum = sum2 * xminus;
        this.setIntegration = true;
        return this.integralSum;
    }

    public double gaussQuad(int glPoints) {
        this.glPoints = glPoints;
        this.setGLpoints = true;
        return this.gaussQuad();
    }

    public static double gaussQuad(IntegralFunction intFunc, double lowerLimit, double upperLimit, int glPoints) {
        Integration intgrtn = new Integration(intFunc, lowerLimit, upperLimit);
        return intgrtn.gaussQuad(glPoints);
    }

    public static void gaussQuadCoeff(double[] gaussQuadDist, double[] gaussQuadWeight, int n) {
        double z = 0.0;
        double z1 = 0.0;
        double pp = 0.0;
        double p1 = 0.0;
        double p2 = 0.0;
        double p3 = 0.0;
        double eps = 3.0E-11;
        double x1 = -1.0;
        double x2 = 1.0;
        int m = (n + 1) / 2;
        double xm = 0.5 * (x2 + x1);
        double xl = 0.5 * (x2 - x1);
        int i = 1;
        while (i <= m) {
            z = Math.cos(Math.PI * ((double)i - 0.25) / ((double)n + 0.5));
            do {
                p1 = 1.0;
                p2 = 0.0;
                int j = 1;
                while (j <= n) {
                    p3 = p2;
                    p2 = p1;
                    p1 = ((2.0 * (double)j - 1.0) * z * p2 - ((double)j - 1.0) * p3) / (double)j;
                    ++j;
                }
            } while (Math.abs((z = (z1 = z) - p1 / (pp = (double)n * (z * p1 - p2) / (z * z - 1.0))) - z1) > eps);
            gaussQuadDist[i - 1] = xm - xl * z;
            gaussQuadDist[n - i] = xm + xl * z;
            gaussQuadWeight[i - 1] = 2.0 * xl / ((1.0 - z * z) * pp * pp);
            gaussQuadWeight[n - i] = gaussQuadWeight[i - 1];
            ++i;
        }
    }

    public double trapezium() {
        if (!this.setIntervals) {
            throw new IllegalArgumentException("Number of intervals not set");
        }
        if (!this.setLimits) {
            throw new IllegalArgumentException("One limit or both limits not set");
        }
        if (!this.setFunction) {
            throw new IllegalArgumentException("No integral function has been set");
        }
        double y1 = 0.0;
        double interval = (this.upperLimit - this.lowerLimit) / (double)this.nIntervals;
        double x0 = this.lowerLimit;
        double x1 = this.lowerLimit + interval;
        double y0 = this.integralFunc.function(x0);
        this.integralSum = 0.0;
        int i = 0;
        while (i < this.nIntervals) {
            if (x1 > this.upperLimit) {
                x1 = this.upperLimit;
                interval -= x1 - this.upperLimit;
            }
            y1 = this.integralFunc.function(x1);
            this.integralSum += 0.5 * (y0 + y1) * interval;
            x0 = x1;
            y0 = y1;
            x1 += interval;
            ++i;
        }
        this.setIntegration = true;
        return this.integralSum;
    }

    public double trapezium(int nIntervals) {
        this.nIntervals = nIntervals;
        this.setIntervals = true;
        return this.trapezium();
    }

    public static double trapezium(IntegralFunction intFunc, double lowerLimit, double upperLimit, int nIntervals) {
        Integration intgrtn = new Integration(intFunc, lowerLimit, upperLimit);
        return intgrtn.trapezium(nIntervals);
    }

    public double trapezium(double accuracy, int maxIntervals) {
        double summ;
        this.requiredAccuracy = accuracy;
        this.maxIntervals = maxIntervals;
        this.trapeziumIntervals = 1;
        double oldSumm = summ = Integration.trapezium(this.integralFunc, this.lowerLimit, this.upperLimit, 1);
        int i = 2;
        i = 2;
        while (i <= this.maxIntervals) {
            summ = Integration.trapezium(this.integralFunc, this.lowerLimit, this.upperLimit, i);
            this.trapeziumAccuracy = Math.abs((summ - oldSumm) / oldSumm);
            if (this.trapeziumAccuracy <= this.requiredAccuracy) break;
            oldSumm = summ;
            ++i;
        }
        if (i > this.maxIntervals) {
            System.out.println("accuracy criterion was not met in Integration.trapezium - current sum was returned as result.");
            this.trapeziumIntervals = this.maxIntervals;
        } else {
            this.trapeziumIntervals = i;
        }
        trapIntervals = this.trapeziumIntervals;
        trapAccuracy = this.trapeziumAccuracy;
        return summ;
    }

    public static double trapezium(IntegralFunction intFunc, double lowerLimit, double upperLimit, double accuracy, int maxIntervals) {
        Integration intgrtn = new Integration(intFunc, lowerLimit, upperLimit);
        return intgrtn.trapezium(accuracy, maxIntervals);
    }

    public int getTrapeziumIntervals() {
        return this.trapeziumIntervals;
    }

    public static int getTrapIntervals() {
        return trapIntervals;
    }

    public double getTrapeziumAccuracy() {
        return this.trapeziumAccuracy;
    }

    public static double getTrapAccuracy() {
        return trapAccuracy;
    }

    public double backward() {
        if (!this.setIntervals) {
            throw new IllegalArgumentException("Number of intervals not set");
        }
        if (!this.setLimits) {
            throw new IllegalArgumentException("One limit or both limits not set");
        }
        if (!this.setFunction) {
            throw new IllegalArgumentException("No integral function has been set");
        }
        double interval = (this.upperLimit - this.lowerLimit) / (double)this.nIntervals;
        double x2 = this.lowerLimit + interval;
        double y = this.integralFunc.function(x2);
        this.integralSum = 0.0;
        int i = 0;
        while (i < this.nIntervals) {
            if (x2 > this.upperLimit) {
                x2 = this.upperLimit;
                interval -= x2 - this.upperLimit;
            }
            y = this.integralFunc.function(x2);
            this.integralSum += y * interval;
            x2 += interval;
            ++i;
        }
        this.setIntegration = true;
        return this.integralSum;
    }

    public double backward(int nIntervals) {
        this.nIntervals = nIntervals;
        this.setIntervals = true;
        return this.backward();
    }

    public static double backward(IntegralFunction intFunc, double lowerLimit, double upperLimit, int nIntervals) {
        Integration intgrtn = new Integration(intFunc, lowerLimit, upperLimit);
        return intgrtn.backward(nIntervals);
    }

    public double forward() {
        double interval = (this.upperLimit - this.lowerLimit) / (double)this.nIntervals;
        double x2 = this.lowerLimit;
        double y = this.integralFunc.function(x2);
        this.integralSum = 0.0;
        int i = 0;
        while (i < this.nIntervals) {
            if (x2 > this.upperLimit) {
                x2 = this.upperLimit;
                interval -= x2 - this.upperLimit;
            }
            y = this.integralFunc.function(x2);
            this.integralSum += y * interval;
            x2 += interval;
            ++i;
        }
        this.setIntegration = true;
        return this.integralSum;
    }

    public double forward(int nIntervals) {
        this.nIntervals = nIntervals;
        this.setIntervals = true;
        return this.forward();
    }

    public static double forward(IntegralFunction integralFunc, double lowerLimit, double upperLimit, int nIntervals) {
        Integration intgrtn = new Integration(integralFunc, lowerLimit, upperLimit);
        return intgrtn.forward(nIntervals);
    }

    public static double foreward(IntegralFunction integralFunc, double lowerLimit, double upperLimit, int nIntervals) {
        Integration intgrtn = new Integration(integralFunc, lowerLimit, upperLimit);
        return intgrtn.forward(nIntervals);
    }
}

