/*
 * Decompiled with CFR 0.152.
 */
package flanagan.control;

import flanagan.complex.Complex;
import flanagan.complex.ComplexPoly;
import flanagan.control.BlackBox;
import flanagan.plot.PlotGraph;

public class FirstOrder
extends BlackBox {
    private double aConst = 1.0;
    private double bConst = 1.0;
    private double cConst = 1.0;

    public FirstOrder() {
        super("FirstOrder");
        this.sPoles = Complex.oneDarray(1);
        super.setSnumer(new ComplexPoly(1.0));
        super.setSdenom(new ComplexPoly(1.0, 1.0));
        super.setZtransformMethod(1);
        super.addDeadTimeExtras();
    }

    public FirstOrder(double aa, double bb, double cc) {
        super("FirstOrder");
        this.aConst = aa;
        this.bConst = bb;
        this.cConst = cc;
        this.sPoles = Complex.oneDarray(1);
        super.setSnumer(new ComplexPoly(this.cConst));
        super.setSdenom(new ComplexPoly(this.bConst, this.aConst));
        super.setZtransformMethod(1);
        super.addDeadTimeExtras();
    }

    public void setCoeff(double aa, double bb, double cc) {
        this.aConst = aa;
        this.bConst = bb;
        this.cConst = cc;
        Complex[] num = Complex.oneDarray(1);
        num[0].reset(this.cConst, 0.0);
        this.sNumer.resetPoly(num);
        Complex[] den = Complex.oneDarray(2);
        den[0].reset(this.bConst, 0.0);
        den[1].reset(this.aConst, 0.0);
        this.sDenom.resetPoly(den);
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public void setA(double aa) {
        this.aConst = aa;
        Complex co = new Complex(this.aConst, 0.0);
        this.sDenom.resetCoeff(1, co);
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public void setB(double bb) {
        this.bConst = bb;
        Complex co = new Complex(this.bConst, 0.0);
        this.sDenom.resetCoeff(0, co);
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public void setC(double cc) {
        this.cConst = cc;
        Complex co = new Complex(this.cConst, 0.0);
        this.sNumer.resetCoeff(0, co);
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public double getA() {
        return this.aConst;
    }

    public double getB() {
        return this.bConst;
    }

    public double getC() {
        return this.cConst;
    }

    public double getTimeConstant() {
        return this.aConst / this.bConst;
    }

    @Override
    protected void calcPolesZerosS() {
        this.sPoles = Complex.oneDarray(1);
        this.sPoles[0].setReal(-this.bConst / this.aConst);
        if (this.sNumerSet) {
            this.sNumerScaleFactor = this.sNumer.coeffCopy(0);
        }
        if (this.sDenomSet) {
            this.sDenomScaleFactor = BlackBox.scaleFactor(this.sDenom, this.sPoles);
        }
    }

    @Override
    public void stepInput(double stepMag, double finalTime) {
        if (this.bConst / this.aConst == 0.0) {
            int n = 51;
            double incrT = finalTime / (double)(n - 2);
            double[][] cdata = new double[2][n];
            cdata[0][0] = 0.0;
            cdata[0][1] = 0.0;
            int i = 2;
            while (i < n) {
                cdata[0][i] = cdata[0][i - 1] + incrT;
                ++i;
            }
            double kpterm = this.cConst * stepMag / this.bConst;
            cdata[1][0] = 0.0;
            int i2 = 1;
            while (i2 < n) {
                cdata[1][i2] = kpterm;
                ++i2;
            }
            if (this.deadTime != 0.0) {
                i2 = 0;
                while (i2 < n) {
                    double[] dArray = cdata[0];
                    int n2 = i2++;
                    dArray[n2] = dArray[n2] + this.deadTime;
                }
            }
            PlotGraph pg = new PlotGraph(cdata);
            pg.setGraphTitle("Step Input Transient:   Step magnitude = " + stepMag);
            pg.setGraphTitle2(this.getName());
            pg.setXaxisLegend("Time");
            pg.setXaxisUnitsName("s");
            pg.setYaxisLegend("Output");
            pg.setPoint(0);
            pg.setLine(3);
            pg.plot();
        } else {
            super.stepInput(stepMag, finalTime);
        }
    }

    @Override
    public void zTransform() {
        if (this.deltaT == 0.0) {
            System.out.println("z-transform attempted in FirstOrder with a zero sampling period");
        }
        super.deadTimeWarning("zTransform");
        if (this.ztransMethod == 0) {
            this.mapstozAdHoc();
        } else {
            Complex[] ncoef = null;
            Complex[] dcoef = null;
            switch (this.integMethod) {
                case 0: {
                    ncoef = Complex.oneDarray(2);
                    ncoef[0].reset(this.deltaT * this.cConst, 0.0);
                    ncoef[1].reset(this.deltaT * this.cConst, 0.0);
                    this.zNumer = new ComplexPoly(1);
                    this.zNumer.resetPoly(ncoef);
                    this.zNumerDeg = 1;
                    dcoef = Complex.oneDarray(2);
                    dcoef[0].reset(this.bConst * this.deltaT - 2.0 * this.aConst, 0.0);
                    dcoef[1].reset(this.bConst * this.deltaT + 2.0 * this.aConst, 0.0);
                    this.zDenom = new ComplexPoly(1);
                    this.zDenom.resetPoly(dcoef);
                    this.zDenomDeg = 1;
                    this.zZeros = Complex.oneDarray(1);
                    this.zZeros[0].reset(-1.0, 0.0);
                    this.zPoles = Complex.oneDarray(1);
                    this.zPoles[0].reset((2.0 * this.aConst - this.deltaT * this.bConst) / (2.0 * this.aConst + this.deltaT * this.bConst), 0.0);
                    break;
                }
                case 1: {
                    ncoef = Complex.oneDarray(2);
                    ncoef[0].reset(0.0, 0.0);
                    ncoef[1].reset(this.cConst * this.deltaT, 0.0);
                    this.zNumer = new ComplexPoly(1);
                    this.zNumer.resetPoly(ncoef);
                    this.zNumerDeg = 1;
                    dcoef = Complex.oneDarray(2);
                    dcoef[0].reset(this.bConst * this.deltaT + this.aConst, 0.0);
                    dcoef[1].reset(this.aConst, 0.0);
                    this.zDenom = new ComplexPoly(1);
                    this.zDenom.resetPoly(dcoef);
                    this.zDenomDeg = 1;
                    this.zZeros = Complex.oneDarray(1);
                    this.zZeros[0].reset(0.0, 0.0);
                    this.zPoles = Complex.oneDarray(1);
                    this.zPoles[0].reset(this.aConst / (this.deltaT * this.bConst + this.aConst), 0.0);
                    break;
                }
                case 2: {
                    ncoef = Complex.oneDarray(1);
                    ncoef[0].reset(this.cConst * this.deltaT, 0.0);
                    this.zNumer = new ComplexPoly(0);
                    this.zNumer.resetPoly(ncoef);
                    this.zNumerDeg = 0;
                    dcoef = Complex.oneDarray(2);
                    dcoef[0].reset(-this.aConst, 0.0);
                    dcoef[1].reset(this.bConst * this.deltaT - this.aConst, 0.0);
                    this.zDenom = new ComplexPoly(1);
                    this.zDenom.resetPoly(dcoef);
                    this.zDenomDeg = 1;
                    this.zPoles = Complex.oneDarray(1);
                    this.zPoles[0].reset(this.aConst / (this.deltaT * this.bConst - this.aConst), 0.0);
                    break;
                }
                default: {
                    System.out.println("Integration method option in FirstOrder must be 0,1 or 2");
                    System.out.println("It was set at " + this.integMethod);
                    System.out.println("z-transform not performed");
                }
            }
        }
    }

    @Override
    public void zTransform(double deltaT) {
        super.setDeltaT(deltaT);
        this.zTransform();
    }

    @Override
    public Complex getOutputS(Complex sValue, Complex iinput) {
        this.sValue = sValue;
        this.inputS = iinput;
        return this.getOutputS();
    }

    @Override
    public Complex getOutputS() {
        Complex num = Complex.plusOne();
        num = num.times(this.cConst);
        Complex den = new Complex();
        den = this.sValue.times(this.aConst);
        den = den.plus(this.bConst);
        Complex term = new Complex();
        term = num.over(den);
        this.outputS = term.times(this.inputS);
        if (this.deadTime != 0.0) {
            this.outputS = this.outputS.times(Complex.exp(this.sValue.times(-this.deadTime)));
        }
        return this.outputS;
    }

    public double calcOutputT(double time, double input2) {
        super.setInputT(time, input2);
        return this.calcOutputT();
    }

    public double calcOutputT() {
        super.deadTimeWarning("calcOutputT()");
        return super.getCurrentOutputT();
    }

    public Complex[] getSzeros() {
        System.out.println("This standard first order process (class FirstOrder) has no s-domain zeros");
        return null;
    }

    @Override
    public FirstOrder copy() {
        if (this == null) {
            return null;
        }
        FirstOrder bb = new FirstOrder();
        this.copyBBvariables(bb);
        bb.aConst = this.aConst;
        bb.bConst = this.bConst;
        bb.cConst = this.cConst;
        return bb;
    }

    @Override
    public Object clone() {
        return this.copy();
    }
}

