/*
 * Decompiled with CFR 0.152.
 */
package flanagan.complex;

import flanagan.circuits.Phasor;
import flanagan.complex.Complex;
import flanagan.io.FileOutput;
import flanagan.math.ArrayMaths;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.math.Polynomial;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;

public class ComplexPoly {
    private int deg = 0;
    private int degwz = 0;
    private Complex[] coeff;
    private Complex[] coeffwz;
    private boolean suppressRootsErrorMessages = false;

    public ComplexPoly(int n) {
        this.deg = n;
        this.coeff = Complex.oneDarray(n + 1);
    }

    public ComplexPoly(Complex[] aa) {
        this.deg = aa.length - 1;
        this.coeff = Complex.oneDarray(this.deg + 1);
        int i = 0;
        while (i <= this.deg) {
            this.coeff[i] = Complex.copy(aa[i]);
            ++i;
        }
    }

    public ComplexPoly(double[] aa) {
        this.deg = aa.length - 1;
        this.coeff = Complex.oneDarray(this.deg + 1);
        int i = 0;
        while (i <= this.deg) {
            this.coeff[i].reset(aa[i], 0.0);
            ++i;
        }
    }

    public ComplexPoly(float[] aa) {
        this.deg = aa.length - 1;
        this.coeff = Complex.oneDarray(this.deg + 1);
        int i = 0;
        while (i <= this.deg) {
            this.coeff[i].reset(aa[i], 0.0);
            ++i;
        }
    }

    public ComplexPoly(int[] aa) {
        this.deg = aa.length - 1;
        this.coeff = Complex.oneDarray(this.deg + 1);
        int i = 0;
        while (i <= this.deg) {
            this.coeff[i].reset(aa[i], 0.0);
            ++i;
        }
    }

    public ComplexPoly(Polynomial aa) {
        this.deg = aa.getDeg();
        this.coeff = Complex.oneDarray(this.deg + 1);
        int i = 0;
        while (i <= this.deg) {
            this.coeff[i].reset(aa.getCoefficient(i), 0.0);
            ++i;
        }
    }

    public ComplexPoly(ArrayList<Object> aa) {
        this.deg = aa.size() - 1;
        this.coeff = Complex.oneDarray(this.deg + 1);
        int i = 0;
        while (i <= this.deg) {
            int code = this.getTypeCode(aa.get(i));
            switch (code) {
                case 1: {
                    this.coeff[i].reset(((Byte)aa.get(i)).byteValue(), 0.0);
                    break;
                }
                case 2: {
                    this.coeff[i].reset(((Short)aa.get(i)).shortValue(), 0.0);
                    break;
                }
                case 3: {
                    this.coeff[i].reset(((Integer)aa.get(i)).intValue(), 0.0);
                    break;
                }
                case 4: {
                    this.coeff[i].reset(((Long)aa.get(i)).longValue(), 0.0);
                    break;
                }
                case 5: {
                    this.coeff[i].reset(((Float)aa.get(i)).floatValue(), 0.0);
                    break;
                }
                case 6: {
                    this.coeff[i].reset((Double)aa.get(i), 0.0);
                    break;
                }
                case 7: {
                    this.coeff[i] = (Complex)aa.get(i);
                    break;
                }
                case 8: {
                    this.coeff[i] = ((Phasor)aa.get(i)).toComplex();
                    break;
                }
                case 9: {
                    this.coeff[i].reset(((BigInteger)aa.get(i)).doubleValue(), 0.0);
                    break;
                }
                case 10: {
                    this.coeff[i].reset(((BigDecimal)aa.get(i)).doubleValue(), 0.0);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Type code, " + code + ", not recognised");
                }
            }
            ++i;
        }
    }

    private int getTypeCode(Object obj) {
        int code = 0;
        if (obj instanceof Byte) {
            code = 1;
        } else if (obj instanceof Short) {
            code = 2;
        } else if (obj instanceof Integer) {
            code = 3;
        } else if (obj instanceof Long) {
            code = 4;
        } else if (obj instanceof Float) {
            code = 5;
        } else if (obj instanceof Double) {
            code = 6;
        } else if (obj instanceof Complex) {
            code = 7;
        } else if (obj instanceof Phasor) {
            code = 8;
        } else if (obj instanceof BigInteger) {
            code = 9;
        } else if (obj instanceof BigDecimal) {
            code = 10;
        }
        return code;
    }

    public ComplexPoly(Complex aa) {
        this.deg = 0;
        this.coeff = Complex.oneDarray(1);
        this.coeff[0] = Complex.copy(aa);
    }

    public ComplexPoly(double aa) {
        this.deg = 0;
        this.coeff = Complex.oneDarray(1);
        this.coeff[0].reset(aa, 0.0);
    }

    public ComplexPoly(Complex aa, Complex bb) {
        this.deg = 1;
        this.coeff = Complex.oneDarray(2);
        this.coeff[0] = Complex.copy(aa);
        this.coeff[1] = Complex.copy(bb);
    }

    public ComplexPoly(double aa, double bb) {
        this.deg = 1;
        this.coeff = Complex.oneDarray(2);
        this.coeff[0].reset(aa, 0.0);
        this.coeff[1].reset(bb, 0.0);
    }

    public ComplexPoly(Complex aa, Complex bb, Complex cc) {
        this.deg = 2;
        this.coeff = Complex.oneDarray(3);
        this.coeff[0] = Complex.copy(aa);
        this.coeff[1] = Complex.copy(bb);
        this.coeff[2] = Complex.copy(cc);
    }

    public ComplexPoly(double aa, double bb, double cc) {
        this.deg = 2;
        this.coeff = Complex.oneDarray(3);
        this.coeff[0].reset(aa, 0.0);
        this.coeff[1].reset(bb, 0.0);
        this.coeff[2].reset(cc, 0.0);
    }

    public ComplexPoly(Complex aa, Complex bb, Complex cc, Complex dd) {
        this.deg = 3;
        this.coeff = Complex.oneDarray(4);
        this.coeff[0] = Complex.copy(aa);
        this.coeff[1] = Complex.copy(bb);
        this.coeff[2] = Complex.copy(cc);
        this.coeff[3] = Complex.copy(dd);
    }

    public ComplexPoly(double aa, double bb, double cc, double dd) {
        this.deg = 3;
        this.coeff = Complex.oneDarray(4);
        this.coeff[0].reset(aa, 0.0);
        this.coeff[1].reset(bb, 0.0);
        this.coeff[2].reset(cc, 0.0);
        this.coeff[3].reset(dd, 0.0);
    }

    public static ComplexPoly rootsToPoly(Complex[] roots) {
        if (roots == null) {
            return null;
        }
        int pdeg = roots.length;
        Complex[] rootCoeff = Complex.oneDarray(2);
        rootCoeff[0] = roots[0].times(Complex.minusOne());
        rootCoeff[1] = Complex.plusOne();
        ComplexPoly rPoly = new ComplexPoly(rootCoeff);
        int i = 1;
        while (i < pdeg) {
            rootCoeff[0] = roots[i].times(Complex.minusOne());
            ComplexPoly cRoot = new ComplexPoly(rootCoeff);
            rPoly = rPoly.times(cRoot);
            ++i;
        }
        return rPoly;
    }

    public void resetPoly(Complex[] aa) {
        if (this.deg + 1 != aa.length) {
            throw new IllegalArgumentException("array lengths do not match");
        }
        int i = 0;
        while (i < this.deg) {
            this.coeff[i] = Complex.copy(aa[i]);
            ++i;
        }
    }

    public void resetPoly(ArrayList<Object> aa) {
        if (this.deg + 1 != aa.size()) {
            throw new IllegalArgumentException("array lengths do not match");
        }
        int i = 0;
        while (i <= this.deg) {
            int code = this.getTypeCode(aa.get(i));
            switch (code) {
                case 1: {
                    this.coeff[i].reset(((Byte)aa.get(i)).byteValue(), 0.0);
                    break;
                }
                case 2: {
                    this.coeff[i].reset(((Short)aa.get(i)).shortValue(), 0.0);
                    break;
                }
                case 3: {
                    this.coeff[i].reset(((Integer)aa.get(i)).intValue(), 0.0);
                    break;
                }
                case 4: {
                    this.coeff[i].reset(((Long)aa.get(i)).longValue(), 0.0);
                    break;
                }
                case 5: {
                    this.coeff[i].reset(((Float)aa.get(i)).floatValue(), 0.0);
                    break;
                }
                case 6: {
                    this.coeff[i].reset((Double)aa.get(i), 0.0);
                    break;
                }
                case 7: {
                    this.coeff[i] = (Complex)aa.get(i);
                    break;
                }
                case 8: {
                    this.coeff[i] = ((Phasor)aa.get(i)).toComplex();
                    break;
                }
                case 9: {
                    this.coeff[i].reset(((BigInteger)aa.get(i)).doubleValue(), 0.0);
                    break;
                }
                case 10: {
                    this.coeff[i].reset(((BigDecimal)aa.get(i)).doubleValue(), 0.0);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Type code, " + code + ", not recognised");
                }
            }
            ++i;
        }
    }

    public void resetCoeff(int i, Complex aa) {
        this.coeff[i] = Complex.copy(aa);
    }

    public ComplexPoly copy() {
        if (this == null) {
            return null;
        }
        ComplexPoly aa = new ComplexPoly(this.deg);
        int i = 0;
        while (i <= this.deg) {
            aa.coeff[i] = Complex.copy(this.coeff[i]);
            ++i;
        }
        aa.deg = this.deg;
        aa.degwz = this.degwz;
        aa.coeffwz = Conv.copy(this.coeffwz);
        return aa;
    }

    public static ComplexPoly copy(ComplexPoly bb) {
        if (bb == null) {
            return null;
        }
        ComplexPoly aa = new ComplexPoly(bb.deg);
        int i = 0;
        while (i <= bb.deg) {
            aa.coeff[i] = Complex.copy(bb.coeff[i]);
            ++i;
        }
        aa.deg = bb.deg;
        aa.degwz = bb.degwz;
        aa.coeffwz = Conv.copy(bb.coeffwz);
        return aa;
    }

    public Object clone() {
        return this.copy();
    }

    public Complex[] polyNomCopy() {
        Complex[] aa = Complex.oneDarray(this.deg + 1);
        int i = 0;
        while (i <= this.deg) {
            aa[i] = Complex.copy(this.coeff[i]);
            ++i;
        }
        return aa;
    }

    public Complex[] polyNomReference() {
        return this.coeff;
    }

    public Complex[] polyNomPointer() {
        return this.coeff;
    }

    public Complex coeffCopy(int i) {
        return Complex.copy(this.coeff[i]);
    }

    public Complex coeffReference(int i) {
        return this.coeff[i];
    }

    public Complex coeffPointer(int i) {
        return this.coeff[i];
    }

    public int getDeg() {
        return this.deg;
    }

    public void setj() {
        Complex.setj();
    }

    public void seti() {
        Complex.seti();
    }

    public String toString() {
        String ss = "";
        ss = String.valueOf(ss) + this.coeffCopy(0).toString();
        if (this.deg > 0) {
            ss = String.valueOf(ss) + " + (" + this.coeffCopy(1).toString() + ").x";
        }
        int i = 2;
        while (i <= this.deg) {
            ss = String.valueOf(ss) + " + (" + this.coeffCopy(i).toString() + ").x^" + i;
            ++i;
        }
        return ss;
    }

    public void print() {
        System.out.print(this.toString());
    }

    public void println() {
        System.out.println(this.toString());
    }

    public void printToText(String title) {
        title = String.valueOf(title) + ".txt";
        FileOutput fout = new FileOutput(title, 'n');
        fout.println("Output File for a ComplexPoly");
        fout.dateAndTimeln();
        fout.println();
        fout.print("Polynomial degree is ");
        fout.println(this.deg);
        fout.println();
        fout.println("The coefficients are ");
        int i = 0;
        while (i <= this.deg) {
            fout.println(this.coeff[i]);
            ++i;
        }
        fout.println();
        fout.println("End of file.");
        fout.close();
    }

    public void printToText() {
        String title = "ComplexPolyOut";
        this.printToText(title);
    }

    public ArrayList<ComplexPoly> sTransform() {
        return ComplexPoly.sTransform(this.coeff);
    }

    public static ArrayList<ComplexPoly> sTransform(double[] coeff) {
        ArrayMaths am = new ArrayMaths(coeff);
        Complex[] coeffc = am.getArray_as_Complex();
        return ComplexPoly.sTransform(coeffc);
    }

    public static ArrayList<ComplexPoly> sTransform(Complex[] coeff) {
        int n = coeff.length;
        ComplexPoly[] sNum = new ComplexPoly[n];
        ComplexPoly[] sDen = new ComplexPoly[n];
        ComplexPoly sNumer = null;
        ComplexPoly sDenom = new ComplexPoly(Complex.plusOne());
        int i = 0;
        while (i < n) {
            sNum[i] = new ComplexPoly(coeff[i].times(new Complex(Fmath.factorial(i), 0.0)));
            sDen[i] = new ComplexPoly(i + 1);
            sDen[i].resetCoeff(i + 1, Complex.plusOne());
            ++i;
        }
        sDenom = sDen[n - 1];
        i = 0;
        while (i < n - 1) {
            sNum[i] = sNum[i].times(sDen[n - i - 2]);
            ++i;
        }
        sNumer = sNum[0];
        i = 1;
        while (i < n) {
            sNumer = sNumer.plus(sNum[i]);
            ++i;
        }
        ArrayList<ComplexPoly> al = new ArrayList<ComplexPoly>();
        al.add(sNumer);
        al.add(sDenom);
        return al;
    }

    public boolean equals(ComplexPoly cp) {
        return this.isEqual(cp);
    }

    public boolean isEqual(ComplexPoly cp) {
        int nDegCp;
        boolean ret = false;
        int nDegThis = this.getDeg();
        if (nDegThis == (nDegCp = cp.getDeg())) {
            boolean test2 = true;
            int i = 0;
            while (test2) {
                if (!this.coeff[i].isEqual(cp.coeffReference(i))) {
                    test2 = false;
                    continue;
                }
                if (++i <= nDegCp) continue;
                test2 = false;
                ret = true;
            }
        }
        return ret;
    }

    public static boolean isEqual(ComplexPoly cp1, ComplexPoly cp2) {
        int nDegCp2;
        boolean ret = false;
        int nDegCp1 = cp1.getDeg();
        if (nDegCp1 == (nDegCp2 = cp2.getDeg())) {
            boolean test2 = true;
            int i = 0;
            while (test2) {
                if (!cp1.coeffReference(i).isEqual(cp2.coeffReference(i))) {
                    test2 = false;
                    continue;
                }
                if (++i <= nDegCp1) continue;
                test2 = false;
                ret = true;
            }
        }
        return ret;
    }

    public ComplexPoly plus(ComplexPoly b) {
        ComplexPoly c = null;
        if (b.deg <= this.deg) {
            c = new ComplexPoly(this.deg);
            int i = b.deg + 1;
            while (i <= this.deg) {
                c.coeff[i] = Complex.copy(this.coeff[i]);
                ++i;
            }
            i = 0;
            while (i <= b.deg) {
                c.coeff[i] = this.coeff[i].plus(b.coeff[i]);
                ++i;
            }
        } else {
            c = new ComplexPoly(b.deg);
            int i = this.deg + 1;
            while (i <= b.deg) {
                c.coeff[i] = Complex.copy(b.coeff[i]);
                ++i;
            }
            i = 0;
            while (i <= this.deg) {
                c.coeff[i] = this.coeff[i].plus(b.coeff[i]);
                ++i;
            }
        }
        return c;
    }

    public static ComplexPoly plus(ComplexPoly a, ComplexPoly b) {
        ComplexPoly c = null;
        if (b.deg <= a.deg) {
            c = new ComplexPoly(a.deg);
            int i = b.deg + 1;
            while (i <= a.deg) {
                c.coeff[i] = Complex.copy(a.coeff[i]);
                ++i;
            }
            i = 0;
            while (i <= b.deg) {
                c.coeff[i] = a.coeff[i].plus(b.coeff[i]);
                ++i;
            }
        } else {
            c = new ComplexPoly(b.deg);
            int i = a.deg + 1;
            while (i <= b.deg) {
                c.coeff[i] = Complex.copy(b.coeff[i]);
                ++i;
            }
            i = 0;
            while (i <= a.deg) {
                c.coeff[i] = a.coeff[i].plus(b.coeff[i]);
                ++i;
            }
        }
        return c;
    }

    public ComplexPoly plus(Complex bb) {
        ComplexPoly b = new ComplexPoly(bb);
        return this.plus(b);
    }

    public static ComplexPoly plus(ComplexPoly a, Complex bb) {
        ComplexPoly b = new ComplexPoly(bb);
        return ComplexPoly.plus(a, b);
    }

    public ComplexPoly plus(double bb) {
        ComplexPoly b = new ComplexPoly(new Complex(bb, 0.0));
        return this.plus(b);
    }

    public static ComplexPoly plus(ComplexPoly a, double bb) {
        ComplexPoly b = new ComplexPoly(new Complex(bb, 0.0));
        return ComplexPoly.plus(a, b);
    }

    public ComplexPoly plus(int bb) {
        ComplexPoly b = new ComplexPoly(new Complex(bb, 0.0));
        return this.plus(b);
    }

    public static ComplexPoly plus(ComplexPoly a, int bb) {
        ComplexPoly b = new ComplexPoly(new Complex(bb, 0.0));
        return ComplexPoly.plus(a, b);
    }

    public ComplexPoly minus(ComplexPoly b) {
        ComplexPoly c = null;
        if (b.deg <= this.deg) {
            c = new ComplexPoly(this.deg);
            int i = b.deg + 1;
            while (i <= this.deg) {
                c.coeff[i] = Complex.copy(this.coeff[i]);
                ++i;
            }
            i = 0;
            while (i <= b.deg) {
                c.coeff[i] = this.coeff[i].minus(b.coeff[i]);
                ++i;
            }
        } else {
            c = new ComplexPoly(b.deg);
            int i = this.deg + 1;
            while (i <= b.deg) {
                c.coeff[i] = b.coeff[i].times(Complex.minusOne());
                ++i;
            }
            i = 0;
            while (i <= this.deg) {
                c.coeff[i] = this.coeff[i].minus(b.coeff[i]);
                ++i;
            }
        }
        return c;
    }

    public ComplexPoly minus(Complex bb) {
        ComplexPoly b = new ComplexPoly(bb);
        return this.minus(b);
    }

    public ComplexPoly minus(double bb) {
        ComplexPoly b = new ComplexPoly(new Complex(bb, 0.0));
        return this.minus(b);
    }

    public ComplexPoly minus(int bb) {
        ComplexPoly b = new ComplexPoly(new Complex(bb, 0.0));
        return this.minus(b);
    }

    public static ComplexPoly minus(ComplexPoly a, ComplexPoly b) {
        ComplexPoly c = null;
        if (b.deg <= a.deg) {
            c = new ComplexPoly(a.deg);
            int i = b.deg + 1;
            while (i <= a.deg) {
                c.coeff[i] = Complex.copy(a.coeff[i]);
                ++i;
            }
            i = 0;
            while (i <= b.deg) {
                c.coeff[i] = a.coeff[i].minus(b.coeff[i]);
                ++i;
            }
        } else {
            c = new ComplexPoly(b.deg);
            int i = a.deg + 1;
            while (i <= b.deg) {
                c.coeff[i] = b.coeff[i].times(Complex.minusOne());
                ++i;
            }
            i = 0;
            while (i <= a.deg) {
                c.coeff[i] = a.coeff[i].minus(b.coeff[i]);
                ++i;
            }
        }
        return c;
    }

    public static ComplexPoly minus(ComplexPoly a, Complex bb) {
        ComplexPoly b = new ComplexPoly(bb);
        return ComplexPoly.minus(a, b);
    }

    public static ComplexPoly minus(ComplexPoly a, double bb) {
        ComplexPoly b = new ComplexPoly(new Complex(bb, 0.0));
        return ComplexPoly.minus(a, b);
    }

    public static ComplexPoly minus(ComplexPoly a, int bb) {
        ComplexPoly b = new ComplexPoly(new Complex(bb, 0.0));
        return ComplexPoly.minus(a, b);
    }

    public ComplexPoly times(ComplexPoly b) {
        int n = this.deg + b.deg;
        ComplexPoly c = new ComplexPoly(n);
        int i = 0;
        while (i <= this.deg) {
            int j = 0;
            while (j <= b.deg) {
                c.coeff[i + j].plusEquals(this.coeff[i].times(b.coeff[j]));
                ++j;
            }
            ++i;
        }
        return c;
    }

    public static ComplexPoly times(ComplexPoly a, ComplexPoly b) {
        int n = a.deg + b.deg;
        ComplexPoly c = new ComplexPoly(n);
        int i = 0;
        while (i <= a.deg) {
            int j = 0;
            while (j <= b.deg) {
                c.coeff[i + j].plusEquals(a.coeff[i].times(b.coeff[j]));
                ++j;
            }
            ++i;
        }
        return c;
    }

    public ComplexPoly times(Complex bb) {
        ComplexPoly c = new ComplexPoly(this.deg);
        int i = 0;
        while (i <= this.deg) {
            c.coeff[i] = this.coeff[i].times(bb);
            ++i;
        }
        return c;
    }

    public static ComplexPoly times(ComplexPoly a, Complex bb) {
        ComplexPoly c = new ComplexPoly(a.deg);
        int i = 0;
        while (i <= a.deg) {
            c.coeff[i] = a.coeff[i].times(bb);
            ++i;
        }
        return c;
    }

    public ComplexPoly times(double bb) {
        ComplexPoly c = new ComplexPoly(this.deg);
        int i = 0;
        while (i <= this.deg) {
            c.coeff[i] = this.coeff[i].times(new Complex(bb, 0.0));
            ++i;
        }
        return c;
    }

    public static ComplexPoly times(ComplexPoly a, double bb) {
        ComplexPoly c = new ComplexPoly(a.deg);
        int i = 0;
        while (i <= a.deg) {
            c.coeff[i] = a.coeff[i].times(new Complex(bb, 0.0));
            ++i;
        }
        return c;
    }

    public ComplexPoly nthDerivative(int n) {
        ComplexPoly dnydxn;
        if (n > this.deg) {
            dnydxn = new ComplexPoly(0.0);
        } else {
            dnydxn = new ComplexPoly(this.deg - n);
            Complex[] nc = Complex.oneDarray(this.deg - n + 1);
            int k = this.deg - n;
            int i = this.deg;
            while (i > n - 1) {
                nc[k] = Complex.copy(this.coeff[i]);
                int j = 0;
                while (j < n) {
                    nc[k] = Complex.times(nc[k], (double)(i - j));
                    ++j;
                }
                --k;
                --i;
            }
            dnydxn = new ComplexPoly(nc);
        }
        return dnydxn;
    }

    public Complex evaluate(Complex x2) {
        Complex y = new Complex();
        if (this.deg == 0) {
            y = Complex.copy(this.coeff[0]);
        } else {
            y = Complex.copy(this.coeff[this.deg]);
            int i = this.deg - 1;
            while (i >= 0) {
                y = Complex.plus(Complex.times(y, x2), this.coeff[i]);
                --i;
            }
        }
        return y;
    }

    public Complex evaluate(double xx) {
        Complex x2 = new Complex(xx, 0.0);
        Complex y = new Complex();
        if (this.deg == 0) {
            y = Complex.copy(this.coeff[0]);
        } else {
            y = Complex.copy(this.coeff[this.deg]);
            int i = this.deg - 1;
            while (i >= 0) {
                y = Complex.plus(Complex.times(y, x2), this.coeff[i]);
                --i;
            }
        }
        return y;
    }

    public Complex nthDerivEvaluate(int n, Complex x2) {
        Complex dnydxn = new Complex();
        Complex[] nc = Complex.oneDarray(this.deg + 1);
        if (n == 0) {
            dnydxn = this.evaluate(x2);
            System.out.println("n = 0 in ComplexPoly.nthDerivative");
            System.out.println("polynomial itself evaluated and returned");
        } else {
            ComplexPoly nthderiv = this.nthDerivative(n);
            dnydxn = nthderiv.evaluate(x2);
        }
        return dnydxn;
    }

    public Complex nthDerivEvaluate(int n, double xx) {
        Complex x2 = new Complex(xx, 0.0);
        return this.nthDerivEvaluate(n, x2);
    }

    public Complex[] roots() {
        boolean polish = true;
        Complex estx = new Complex(0.0, 0.0);
        return this.roots(polish, estx);
    }

    public Complex[] rootsNoMessages() {
        this.suppressRootsErrorMessages = true;
        return this.roots();
    }

    public Complex[] roots(boolean polish) {
        Complex estx = new Complex(0.0, 0.0);
        return this.roots(polish, estx);
    }

    public Complex[] roots(Complex estx) {
        boolean polish = true;
        return this.roots(polish, estx);
    }

    public Complex[] roots(boolean polish, Complex estx) {
        int i;
        Complex[] roots = Complex.oneDarray(this.deg);
        if (this.deg == 0 && !this.suppressRootsErrorMessages) {
            System.out.println("degree of the polynomial is zero in the method ComplexPoly.roots");
            System.out.println("null returned");
            return null;
        }
        int counter = 0;
        int i2 = 1;
        while (i2 <= this.deg) {
            if (this.coeff[i2].isZero()) {
                ++counter;
            }
            ++i2;
        }
        if (counter == this.deg && !this.suppressRootsErrorMessages) {
            System.out.println("polynomial coefficients above the zeroth are all zero in the method ComplexPoly.roots");
            System.out.println("null returned");
            return null;
        }
        int nonzerocoeff = 0;
        int nonzeroindex = 0;
        int i3 = 0;
        while (i3 <= this.deg) {
            if (!this.coeff[i3].isZero()) {
                ++nonzerocoeff;
                nonzeroindex = i3;
            }
            ++i3;
        }
        if (nonzerocoeff == 1) {
            System.out.println("all polynomial coefficients except a[" + nonzeroindex + "] are zero in the method ComplexPoly.roots");
            System.out.println("all roots returned as zero");
            i3 = 0;
            while (i3 < this.deg) {
                roots[i3] = Complex.zero();
                ++i3;
            }
            return roots;
        }
        boolean testzero = true;
        int ii = 0;
        int nzeros = 0;
        while (testzero) {
            if (this.coeff[ii].isZero()) {
                ++nzeros;
                ++ii;
                continue;
            }
            testzero = false;
        }
        if (nzeros > 0) {
            this.degwz = this.deg - nzeros;
            this.coeffwz = Complex.oneDarray(this.degwz + 1);
            i = 0;
            while (i <= this.degwz) {
                this.coeffwz[i] = this.coeff[i + nzeros].copy();
                ++i;
            }
        } else {
            this.degwz = this.deg;
            this.coeffwz = Complex.oneDarray(this.degwz + 1);
            i = 0;
            while (i <= this.degwz) {
                this.coeffwz[i] = this.coeff[i].copy();
                ++i;
            }
        }
        Complex[] root2 = Complex.oneDarray(this.degwz);
        switch (this.degwz) {
            case 1: {
                root2[0] = Complex.negate(this.coeffwz[0].over(this.coeffwz[1]));
                break;
            }
            case 2: {
                root2 = ComplexPoly.quadratic(this.coeffwz[0], this.coeffwz[1], this.coeffwz[2]);
                break;
            }
            case 3: {
                root2 = ComplexPoly.cubic(this.coeffwz[0], this.coeffwz[1], this.coeffwz[2], this.coeffwz[3]);
                break;
            }
            default: {
                root2 = this.laguerreAll(polish, estx);
            }
        }
        int i4 = 0;
        while (i4 < this.degwz) {
            roots[i4] = root2[i4].copy();
            ++i4;
        }
        if (nzeros > 0) {
            i4 = this.degwz;
            while (i4 < this.deg) {
                roots[i4] = Complex.zero();
                ++i4;
            }
        }
        return roots;
    }

    public static Complex[] quadratic(Complex c, Complex b, Complex a) {
        double qsign = 1.0;
        Complex qsqrt = new Complex();
        Complex qtest = new Complex();
        Complex bconj = new Complex();
        Complex[] root2 = Complex.oneDarray(2);
        bconj = b.conjugate();
        qtest = bconj.times(qsqrt = Complex.sqrt(Complex.square(b).minus(a.times(c).times(4.0))));
        if (qtest.getReal() < 0.0) {
            qsign = -1.0;
        }
        qsqrt = qsqrt.over(qsign).plus(b).over(-2.0);
        root2[0] = Complex.over(qsqrt, a);
        root2[1] = Complex.over(c, qsqrt);
        return root2;
    }

    public static Complex[] quadratic(double c, double b, double a) {
        Complex aa = new Complex(a, 0.0);
        Complex bb = new Complex(b, 0.0);
        Complex cc = new Complex(c, 0.0);
        return ComplexPoly.quadratic(cc, bb, aa);
    }

    public static Complex[] cubic(Complex aa, Complex bb, Complex cc, Complex dd) {
        Complex a = cc.over(dd);
        Complex b = bb.over(dd);
        Complex c = aa.over(dd);
        Complex[] roots = Complex.oneDarray(3);
        Complex bigQ = a.times(a).minus(b.times(3.0)).over(9.0);
        Complex bigR = a.times(a).times(a).times(2.0).minus(a.times(b).times(9.0)).plus(c.times(27.0)).over(54.0);
        Complex sign2 = Complex.plusOne();
        Complex bigAsqrtTerm = Complex.sqrt(bigR.times(bigR).minus(bigQ.times(bigQ).times(bigQ)));
        Complex bigRconjugate = bigR.conjugate();
        if (bigRconjugate.times(bigAsqrtTerm).getReal() < 0.0) {
            sign2 = Complex.minusOne();
        }
        Complex bigA = Complex.pow(bigR.plus(sign2.times(bigAsqrtTerm)), 0.3333333333333333).times(Complex.minusOne());
        Complex bigB = null;
        bigB = bigA.isZero() ? Complex.zero() : bigQ.over(bigA);
        Complex aPlusB = bigA.plus(bigB);
        Complex aMinusB = bigA.minus(bigB);
        Complex minusAplusB = aPlusB.times(Complex.minusOne());
        Complex aOver3 = a.over(3.0);
        Complex isqrt3over2 = new Complex(0.0, Math.sqrt(3.0) / 2.0);
        roots[0] = aPlusB.minus(aOver3);
        roots[1] = minusAplusB.over(2.0).minus(aOver3).plus(isqrt3over2.times(aMinusB));
        roots[2] = minusAplusB.over(2.0).minus(aOver3).minus(isqrt3over2.times(aMinusB));
        return roots;
    }

    public static Complex[] cubic(double d, double c, double b, double a) {
        Complex aa = new Complex(a, 0.0);
        Complex bb = new Complex(b, 0.0);
        Complex cc = new Complex(c, 0.0);
        Complex dd = new Complex(d, 0.0);
        return ComplexPoly.cubic(dd, cc, bb, aa);
    }

    public static Complex laguerre(Complex estx, Complex[] pcoeff, int m) {
        double eps = 1.0E-7;
        int mr = 8;
        int mt = 1000;
        int maxit = mr * mt;
        int niter = 0;
        double[] frac = new double[]{0.5, 0.25, 0.75, 0.13, 0.38, 0.62, 0.88, 1.0};
        Complex root2 = new Complex();
        Complex b = new Complex();
        Complex d = new Complex();
        Complex f2 = new Complex();
        Complex g = new Complex();
        Complex g2 = new Complex();
        Complex h = new Complex();
        Complex sq = new Complex();
        Complex gp = new Complex();
        Complex gm = new Complex();
        Complex dx = new Complex();
        Complex x1 = new Complex();
        Complex temp1 = new Complex();
        Complex temp2 = new Complex();
        double abp = 0.0;
        double abm = 0.0;
        double err2 = 0.0;
        double abx = 0.0;
        int i = 1;
        while (i <= maxit) {
            niter = i;
            b = Complex.copy(pcoeff[m]);
            err2 = Complex.abs(b);
            d = f2 = Complex.zero();
            abx = Complex.abs(estx);
            int j = m - 1;
            while (j >= 0) {
                f2 = Complex.plus(Complex.times(estx, f2), d);
                d = Complex.plus(Complex.times(estx, d), b);
                b = Complex.plus(Complex.times(estx, b), pcoeff[j]);
                err2 = Complex.abs(b) + abx * err2;
                --j;
            }
            err2 *= eps;
            if (Complex.abs(b) <= err2) {
                root2 = Complex.copy(estx);
                niter = i;
                return root2;
            }
            g = Complex.over(d, b);
            g2 = Complex.square(g);
            h = Complex.minus(g2, Complex.times(2.0, Complex.over(f2, b)));
            sq = Complex.sqrt(Complex.times((double)(m - 1), Complex.minus(Complex.times((double)m, h), g2)));
            gp = Complex.plus(g, sq);
            gm = Complex.minus(g, sq);
            abp = Complex.abs(gp);
            if (abp < (abm = Complex.abs(gm))) {
                gp = gm;
            }
            temp1.setReal(m);
            temp2.setReal(Math.cos(i));
            temp2.setImag(Math.sin(i));
            dx = Math.max(abp, abm) > 0.0 ? Complex.over(temp1, gp) : Complex.times(Math.exp(1.0 + abx), temp2);
            x1 = Complex.minus(estx, dx);
            if (Complex.isEqual(estx, x1)) {
                root2 = Complex.copy(estx);
                niter = i;
                return root2;
            }
            estx = i % mt != 0 ? Complex.copy(x1) : Complex.minus(estx, Complex.times(frac[i / mt - 1], dx));
            niter = i++;
        }
        root2 = Complex.copy(estx);
        System.out.println("Maximum number of iterations exceeded in laguerre");
        System.out.println("root returned at this point");
        return root2;
    }

    public Complex[] laguerreAll() {
        Complex estx = new Complex(0.0, 0.0);
        boolean polish = true;
        return this.laguerreAll(polish, estx);
    }

    public Complex[] laguerreAll(Complex estx) {
        boolean polish = true;
        return this.laguerreAll(polish, estx);
    }

    public Complex[] laguerreAll(boolean polish) {
        Complex estx = new Complex(0.0, 0.0);
        return this.laguerreAll(polish, estx);
    }

    public Complex[] laguerreAll(boolean polish, Complex estx) {
        int m = this.degwz;
        double eps = 2.0E-6;
        Complex x2 = new Complex();
        Complex b = new Complex();
        Complex c = new Complex();
        Complex[] ad = new Complex[m + 1];
        Complex[] roots = new Complex[m + 1];
        int j = 0;
        while (j <= m) {
            ad[j] = Complex.copy(this.coeffwz[j]);
            ++j;
        }
        j = m;
        while (j >= 1) {
            x2 = Complex.copy(estx);
            if (Math.abs((x2 = ComplexPoly.laguerre(x2, ad, j)).getImag()) <= 2.0 * eps * Math.abs(x2.getReal())) {
                x2.setImag(0.0);
            }
            roots[j] = Complex.copy(x2);
            b = Complex.copy(ad[j]);
            int jj = j - 1;
            while (jj >= 0) {
                c = Complex.copy(ad[jj]);
                ad[jj] = Complex.copy(b);
                b = x2.times(b).plus(c);
                --jj;
            }
            --j;
        }
        if (polish) {
            j = 1;
            while (j <= m) {
                roots[j] = ComplexPoly.laguerre(roots[j], this.coeffwz, m);
                ++j;
            }
        }
        j = 2;
        while (j <= m) {
            x2 = Complex.copy(roots[j]);
            int i = 0;
            i = j - 1;
            while (i >= 1) {
                if (roots[i].getReal() <= x2.getReal()) break;
                roots[i + 1] = Complex.copy(roots[i]);
                --i;
            }
            roots[i + 1] = Complex.copy(x2);
            ++j;
        }
        int i = 0;
        while (i < m) {
            roots[i] = Complex.copy(roots[i + 1]);
            ++i;
        }
        return roots;
    }
}

