/*
 * Decompiled with CFR 0.152.
 */
package flanagan.circuits;

import flanagan.circuits.ImpedSpecModel;
import flanagan.circuits.Impedance;
import flanagan.complex.Complex;
import flanagan.io.Db;
import flanagan.io.FileOutput;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.plot.PlotGraph;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;

public class ImpedSpecSimulation {
    private double lowestFrequency = 0.0;
    private double lowestOmega = 0.0;
    private boolean lowestSet = false;
    private double highestFrequency = 0.0;
    private double highestOmega = 0.0;
    private boolean highestSet = false;
    private boolean logOrLinear = true;
    private double increment = 0.0;
    private double[] frequencies = null;
    private double[] omegas = null;
    private double[] log10frequencies = null;
    private double[] log10omegas = null;
    private int numberOfFrequencies = 800;
    private boolean numberSet = true;
    private boolean frequenciesSet = false;
    private int modelNumber = 0;
    private double[] parameters = null;
    private int numberOfParameters = 0;
    private String[] modelParameterSymbols = null;
    private boolean parametersSet = false;
    private boolean modelSet = false;
    private Complex[] impedances = null;
    private double[] magnitudesZ = null;
    private double[] phasesRadZ = null;
    private double[] phasesDegZ = null;
    private double[] realZ = null;
    private double[] imagZ = null;
    private boolean impedancesSet = false;
    private Complex[] voltages = null;
    private double[] magnitudesV = null;
    private double[] phasesRadV = null;
    private double[] phasesDegV = null;
    private double[] realV = null;
    private double[] imagV = null;
    private ImpedSpecModel userModel = null;
    private String simulationTitle = null;
    private boolean fileType = false;
    private Complex appliedVoltage = null;
    private boolean voltageSet = false;
    private Complex referenceImpedance = null;
    private boolean referenceSet = false;

    public ImpedSpecSimulation() {
        this.simulationTitle = "  ";
    }

    public ImpedSpecSimulation(String simulationTitle) {
        this.simulationTitle = simulationTitle;
    }

    public void setScanRangeHz(double low, double high) {
        this.lowestFrequency = low;
        this.lowestOmega = Math.PI * 2 * low;
        this.highestFrequency = high;
        this.highestOmega = Math.PI * 2 * high;
        this.calculateFrequencies();
    }

    public void setScanRangeRadians(double low, double high) {
        this.lowestFrequency = low / (Math.PI * 2);
        this.lowestOmega = low;
        this.highestFrequency = high / (Math.PI * 2);
        this.highestOmega = high;
        this.calculateFrequencies();
    }

    public void setLowFrequency(double low) {
        this.lowestFrequency = low;
        this.lowestOmega = Math.PI * 2 * low;
        this.lowestSet = true;
        if (this.highestSet && this.numberSet) {
            this.calculateFrequencies();
        }
    }

    public void setLowRadialFrequency(double low) {
        this.lowestOmega = low;
        this.lowestFrequency = low / (Math.PI * 2);
        this.lowestSet = true;
        if (this.highestSet && this.numberSet) {
            this.calculateFrequencies();
        }
    }

    public void setHighFrequency(double high) {
        this.highestFrequency = high;
        this.highestOmega = Math.PI * 2 * high;
        this.highestSet = true;
        if (this.lowestSet && this.numberSet) {
            this.calculateFrequencies();
        }
    }

    public void setHighRadialFrequency(double high) {
        this.highestOmega = high;
        this.highestFrequency = high / (Math.PI * 2);
        this.highestSet = true;
        if (this.lowestSet && this.numberSet) {
            this.calculateFrequencies();
        }
    }

    private void calculateFrequencies() {
        if (this.logOrLinear) {
            double logLow = Fmath.log10(this.lowestFrequency);
            double logHigh = Fmath.log10(this.highestFrequency);
            this.increment = (logHigh - logLow) / (double)(this.numberOfFrequencies - 1);
            this.frequencies = new double[this.numberOfFrequencies];
            this.log10frequencies = new double[this.numberOfFrequencies];
            this.omegas = new double[this.numberOfFrequencies];
            this.log10omegas = new double[this.numberOfFrequencies];
            this.log10frequencies[0] = logLow;
            this.log10frequencies[this.numberOfFrequencies - 1] = logHigh;
            int i = 1;
            while (i < this.numberOfFrequencies - 1) {
                this.log10frequencies[i] = this.log10frequencies[i - 1] + this.increment;
                ++i;
            }
            i = 0;
            while (i < this.numberOfFrequencies) {
                this.frequencies[i] = Math.pow(10.0, this.log10frequencies[i]);
                this.omegas[i] = this.frequencies[i] * 2.0 * Math.PI;
                this.log10omegas[i] = Fmath.log10(this.omegas[i]);
                ++i;
            }
        } else {
            this.increment = (this.highestFrequency - this.lowestFrequency) / (double)(this.numberOfFrequencies - 1);
            this.frequencies = new double[this.numberOfFrequencies];
            this.frequencies[0] = this.lowestFrequency;
            this.log10frequencies = new double[this.numberOfFrequencies];
            this.omegas = new double[this.numberOfFrequencies];
            this.log10omegas = new double[this.numberOfFrequencies];
            this.frequencies[this.numberOfFrequencies - 1] = this.highestFrequency;
            int i = 1;
            while (i < this.numberOfFrequencies - 1) {
                this.frequencies[i] = this.frequencies[i - 1] + this.increment;
                ++i;
            }
            i = 0;
            while (i < this.numberOfFrequencies) {
                this.log10frequencies[i] = Fmath.log10(this.frequencies[i]);
                this.omegas[i] = this.frequencies[i] * 2.0 * Math.PI;
                this.log10omegas[i] = Fmath.log10(this.omegas[i]);
                ++i;
            }
        }
        this.frequenciesSet = true;
    }

    public void setLinearPlot() {
        this.logOrLinear = false;
        if (this.lowestSet && this.highestSet && this.numberSet) {
            this.calculateFrequencies();
        }
    }

    public void setLog10Plot() {
        this.logOrLinear = true;
        if (this.lowestSet && this.highestSet && this.numberSet) {
            this.calculateFrequencies();
        }
    }

    public void setAppliedVoltage(double voltage) {
        this.appliedVoltage = new Complex(voltage, 0.0);
        this.voltageSet = true;
    }

    public void setReferenceImpedance(double resistance) {
        this.referenceImpedance = new Complex(resistance, 0.0);
        this.referenceSet = true;
    }

    public void setReferenceImpedance(double real, double imag) {
        this.referenceImpedance = new Complex(real, imag);
        this.referenceSet = true;
    }

    public void setReferenceImpedance(Complex impedance) {
        this.referenceImpedance = impedance;
        this.referenceSet = true;
    }

    public void setModel(int modelNumber, double[] parameters) {
        if (modelNumber == 0 || modelNumber > Impedance.numberOfModels) {
            throw new IllegalArgumentException("The model number, " + modelNumber + ", must lie between 1 and " + Impedance.numberOfModels + " inclusive");
        }
        this.modelNumber = modelNumber;
        this.parameters = parameters;
        this.modelParameterSymbols = Impedance.modelComponents(modelNumber);
        this.numberOfParameters = this.modelParameterSymbols.length;
        if (this.numberOfParameters != this.parameters.length) {
            throw new IllegalArgumentException("The number of model parametes passed, " + parameters.length + ", does not match the number required, " + this.numberOfParameters + ", by model number " + modelNumber);
        }
        this.parametersSet = true;
        this.modelSet = true;
    }

    public void setModel(int modelNumber, double[] parameters, String[] symbols) {
        if (modelNumber == 0 || modelNumber > Impedance.numberOfModels) {
            throw new IllegalArgumentException("The model number, " + modelNumber + ", must lie between 1 and " + Impedance.numberOfModels + " inclusive");
        }
        this.modelNumber = modelNumber;
        this.parameters = parameters;
        this.modelParameterSymbols = Impedance.modelComponents(modelNumber);
        this.numberOfParameters = this.modelParameterSymbols.length;
        if (this.numberOfParameters != this.parameters.length) {
            throw new IllegalArgumentException("The number of model parametes passed, " + parameters.length + ", does not match the numbber required, " + this.numberOfParameters + ", by model number " + modelNumber);
        }
        if (this.numberOfParameters != symbols.length) {
            throw new IllegalArgumentException("The number of model symbols passed, " + symbols.length + ", does not match the number required, " + this.numberOfParameters + ", by model number " + modelNumber);
        }
        this.modelParameterSymbols = symbols;
        this.parametersSet = true;
        this.modelSet = true;
    }

    public void setModel(int modelNumber) {
        if (modelNumber == 0 || modelNumber > Impedance.numberOfModels) {
            throw new IllegalArgumentException("The model number, " + modelNumber + ", must lie between 1 and " + Impedance.numberOfModels + " inclusive");
        }
        this.modelNumber = modelNumber;
        this.modelSet = true;
        this.modelParameterSymbols = Impedance.modelComponents(modelNumber);
        this.numberOfParameters = this.modelParameterSymbols.length;
        this.parameters = new double[this.numberOfParameters];
        int ii = 0;
        String symbol = null;
        while (ii < this.numberOfParameters) {
            symbol = this.modelParameterSymbols[ii];
            if (symbol.trim().charAt(0) == 'R') {
                this.parameters[ii] = Db.readDouble("Enter resistance " + symbol.trim() + " [ohms]");
                ++ii;
                continue;
            }
            if (symbol.trim().charAt(0) == 'C') {
                this.parameters[ii] = Db.readDouble("Enter capacitance " + symbol.trim() + " [farads]");
                ++ii;
                continue;
            }
            if (symbol.trim().charAt(0) == 'L') {
                this.parameters[ii] = Db.readDouble("Enter inductance " + symbol.trim() + " [henries]");
                ++ii;
                continue;
            }
            if (symbol.trim().charAt(0) == 'W') {
                this.parameters[ii] = Db.readDouble("Enter 'infinite' Warburg constant, sigma, " + symbol.trim() + " [ohms*sqrt(radians)]");
                ++ii;
                continue;
            }
            if (symbol.trim().charAt(0) == 'F') {
                this.parameters[ii] = Db.readDouble("Enter 'finite' Warburg constant, sigma, " + symbol.trim() + " [SI units]");
                this.parameters[++ii] = Db.readDouble("Enter 'finite' Warburg power, alpha, " + symbol.trim());
                ++ii;
                continue;
            }
            if (symbol.trim().charAt(0) != 'Q') continue;
            this.parameters[ii] = Db.readDouble("Enter CPE constant, sigma, " + symbol.trim() + " [SI units]");
            this.parameters[++ii] = Db.readDouble("Enter CPE power, alpha, " + symbol.trim());
            ++ii;
        }
        this.parametersSet = true;
    }

    public void setModel(ImpedSpecModel userModel, double[] parameters) {
        this.userModel = userModel;
        this.parameters = parameters;
        this.numberOfParameters = parameters.length;
        this.modelParameterSymbols = new String[this.numberOfParameters];
        int i = 0;
        while (i < this.numberOfParameters) {
            this.modelParameterSymbols[i] = "P" + (i + 1);
            ++i;
        }
        this.parametersSet = true;
    }

    public void setModel(ImpedSpecModel userModel, double[] parameters, String[] symbols) {
        this.userModel = userModel;
        this.parameters = parameters;
        this.modelParameterSymbols = symbols;
        this.numberOfParameters = parameters.length;
        this.parametersSet = true;
    }

    public Complex[] calculateImpedances() {
        int i;
        if (!this.parametersSet) {
            throw new IllegalArgumentException("model parameters values have not been entered");
        }
        if (!this.frequenciesSet) {
            throw new IllegalArgumentException("frequency values have not been entered");
        }
        this.impedances = Complex.oneDarray(this.numberOfFrequencies);
        if (this.modelSet) {
            i = 0;
            while (i < this.numberOfFrequencies) {
                this.impedances[i] = Impedance.modelImpedance(this.parameters, this.omegas[i], this.modelNumber);
                ++i;
            }
        } else {
            i = 0;
            while (i < this.numberOfFrequencies) {
                this.impedances[i] = this.userModel.modelImpedance(this.parameters, this.omegas[i]);
                ++i;
            }
        }
        this.magnitudesZ = new double[this.numberOfFrequencies];
        this.phasesRadZ = new double[this.numberOfFrequencies];
        this.phasesDegZ = new double[this.numberOfFrequencies];
        this.realZ = new double[this.numberOfFrequencies];
        this.imagZ = new double[this.numberOfFrequencies];
        this.magnitudesV = new double[this.numberOfFrequencies];
        this.phasesRadV = new double[this.numberOfFrequencies];
        this.phasesDegV = new double[this.numberOfFrequencies];
        this.realV = new double[this.numberOfFrequencies];
        this.imagV = new double[this.numberOfFrequencies];
        this.voltages = Complex.oneDarray(this.numberOfFrequencies);
        i = 0;
        while (i < this.numberOfFrequencies) {
            this.magnitudesZ[i] = Complex.abs(this.impedances[i]);
            this.phasesRadZ[i] = Complex.arg(this.impedances[i]);
            this.phasesDegZ[i] = Math.toDegrees(this.phasesRadZ[i]);
            this.realZ[i] = this.impedances[i].getReal();
            this.imagZ[i] = this.impedances[i].getImag();
            if (this.voltageSet && this.referenceSet) {
                this.voltages[i] = this.appliedVoltage.times(this.impedances[i].over(this.impedances[i].plus(this.referenceImpedance)));
                this.magnitudesV[i] = Complex.abs(this.voltages[i]);
                this.phasesRadV[i] = Complex.arg(this.voltages[i]);
                this.phasesDegV[i] = Math.toDegrees(this.phasesRadV[i]);
                this.realV[i] = this.voltages[i].getReal();
                this.imagV[i] = this.voltages[i].getImag();
            }
            ++i;
        }
        this.impedancesSet = true;
        return this.impedances;
    }

    public ArrayList<Object> getSimulationResultsAsArrayList(int nPoints) {
        if (!this.impedancesSet) {
            this.calculateImpedances();
        }
        if (nPoints > this.numberOfFrequencies) {
            nPoints = this.numberOfFrequencies;
        }
        int increment = (int)Math.round((double)this.numberOfFrequencies / (double)nPoints);
        int[] points = new int[nPoints];
        points[0] = 0;
        int i = 1;
        while (i < nPoints) {
            points[i] = points[i - 1] + increment;
            ++i;
        }
        if (points[nPoints - 1] != this.numberOfFrequencies - 1) {
            points[nPoints - 1] = this.numberOfFrequencies - 1;
        }
        ArrayList<Object> selectedData = new ArrayList<Object>();
        Complex[] imp = Complex.oneDarray(nPoints);
        int i2 = 0;
        while (i2 < nPoints) {
            imp[i2] = this.impedances[points[i2]];
            ++i2;
        }
        selectedData.add(Complex.copy(imp));
        double[] hold = new double[nPoints];
        int i3 = 0;
        while (i3 < nPoints) {
            hold[i3] = this.realZ[points[i3]];
            ++i3;
        }
        selectedData.add(Conv.copy(hold));
        i3 = 0;
        while (i3 < nPoints) {
            hold[i3] = this.imagZ[points[i3]];
            ++i3;
        }
        selectedData.add(Conv.copy(hold));
        i3 = 0;
        while (i3 < nPoints) {
            hold[i3] = this.magnitudesZ[points[i3]];
            ++i3;
        }
        selectedData.add(Conv.copy(hold));
        i3 = 0;
        while (i3 < nPoints) {
            hold[i3] = this.phasesDegZ[points[i3]];
            ++i3;
        }
        selectedData.add(Conv.copy(hold));
        i3 = 0;
        while (i3 < nPoints) {
            hold[i3] = this.phasesRadZ[points[i3]];
            ++i3;
        }
        selectedData.add(Conv.copy(hold));
        i3 = 0;
        while (i3 < nPoints) {
            hold[i3] = this.frequencies[points[i3]];
            ++i3;
        }
        selectedData.add(Conv.copy(hold));
        i3 = 0;
        while (i3 < nPoints) {
            hold[i3] = this.log10frequencies[points[i3]];
            ++i3;
        }
        selectedData.add(Conv.copy(hold));
        i3 = 0;
        while (i3 < nPoints) {
            hold[i3] = this.omegas[points[i3]];
            ++i3;
        }
        selectedData.add(Conv.copy(hold));
        if (this.voltageSet && this.referenceSet) {
            selectedData.add(new Double(this.appliedVoltage.getReal()));
            selectedData.add(this.referenceImpedance);
            i3 = 0;
            while (i3 < nPoints) {
                imp[i3] = this.voltages[points[i3]];
                ++i3;
            }
            selectedData.add(Complex.copy(imp));
            i3 = 0;
            while (i3 < nPoints) {
                hold[i3] = this.realV[points[i3]];
                ++i3;
            }
            selectedData.add(Conv.copy(hold));
            i3 = 0;
            while (i3 < nPoints) {
                hold[i3] = this.imagV[points[i3]];
                ++i3;
            }
            selectedData.add(Conv.copy(hold));
            i3 = 0;
            while (i3 < nPoints) {
                hold[i3] = this.magnitudesV[points[i3]];
                ++i3;
            }
            selectedData.add(Conv.copy(hold));
            i3 = 0;
            while (i3 < nPoints) {
                hold[i3] = this.phasesDegV[points[i3]];
                ++i3;
            }
            selectedData.add(Conv.copy(hold));
            i3 = 0;
            while (i3 < nPoints) {
                hold[i3] = this.phasesRadV[points[i3]];
                ++i3;
            }
            selectedData.add(Conv.copy(hold));
        } else {
            i3 = 0;
            while (i3 < 8) {
                selectedData.add(null);
                ++i3;
            }
        }
        return selectedData;
    }

    public Vector<Object> getSimulationResultsAsVector(int nPoints) {
        if (!this.impedancesSet) {
            this.calculateImpedances();
        }
        if (nPoints > this.numberOfFrequencies) {
            nPoints = this.numberOfFrequencies;
        }
        int increment = (int)Math.round((double)this.numberOfFrequencies / (double)nPoints);
        int[] points = new int[nPoints];
        points[0] = 0;
        int i = 1;
        while (i < nPoints) {
            points[i] = points[i - 1] + increment;
            ++i;
        }
        if (points[nPoints - 1] != this.numberOfFrequencies - 1) {
            points[nPoints - 1] = this.numberOfFrequencies - 1;
        }
        Vector<Object> vec = new Vector<Object>();
        Complex[] imp = Complex.oneDarray(nPoints);
        int i2 = 0;
        while (i2 < nPoints) {
            imp[i2] = this.impedances[points[i2]];
            ++i2;
        }
        vec.addElement(Complex.copy(imp));
        double[] hold = new double[nPoints];
        int i3 = 0;
        while (i3 < nPoints) {
            hold[i3] = this.realZ[points[i3]];
            ++i3;
        }
        vec.addElement(Conv.copy(hold));
        i3 = 0;
        while (i3 < nPoints) {
            hold[i3] = this.imagZ[points[i3]];
            ++i3;
        }
        vec.addElement(Conv.copy(hold));
        i3 = 0;
        while (i3 < nPoints) {
            hold[i3] = this.magnitudesZ[points[i3]];
            ++i3;
        }
        vec.addElement(Conv.copy(hold));
        i3 = 0;
        while (i3 < nPoints) {
            hold[i3] = this.phasesDegZ[points[i3]];
            ++i3;
        }
        vec.addElement(Conv.copy(hold));
        i3 = 0;
        while (i3 < nPoints) {
            hold[i3] = this.phasesRadZ[points[i3]];
            ++i3;
        }
        vec.addElement(Conv.copy(hold));
        i3 = 0;
        while (i3 < nPoints) {
            hold[i3] = this.frequencies[points[i3]];
            ++i3;
        }
        vec.addElement(Conv.copy(hold));
        i3 = 0;
        while (i3 < nPoints) {
            hold[i3] = this.log10frequencies[points[i3]];
            ++i3;
        }
        vec.addElement(Conv.copy(hold));
        i3 = 0;
        while (i3 < nPoints) {
            hold[i3] = this.omegas[points[i3]];
            ++i3;
        }
        vec.addElement(Conv.copy(hold));
        if (this.voltageSet && this.referenceSet) {
            vec.addElement(new Double(this.appliedVoltage.getReal()));
            vec.addElement(this.referenceImpedance);
            i3 = 0;
            while (i3 < nPoints) {
                imp[i3] = this.voltages[points[i3]];
                ++i3;
            }
            vec.addElement(Complex.copy(imp));
            i3 = 0;
            while (i3 < nPoints) {
                hold[i3] = this.realV[points[i3]];
                ++i3;
            }
            vec.addElement(Conv.copy(hold));
            i3 = 0;
            while (i3 < nPoints) {
                hold[i3] = this.imagV[points[i3]];
                ++i3;
            }
            vec.addElement(Conv.copy(hold));
            i3 = 0;
            while (i3 < nPoints) {
                hold[i3] = this.magnitudesV[points[i3]];
                ++i3;
            }
            vec.addElement(Conv.copy(hold));
            i3 = 0;
            while (i3 < nPoints) {
                hold[i3] = this.phasesDegV[points[i3]];
                ++i3;
            }
            vec.addElement(Conv.copy(hold));
            i3 = 0;
            while (i3 < nPoints) {
                hold[i3] = this.phasesRadV[points[i3]];
                ++i3;
            }
            vec.addElement(Conv.copy(hold));
        } else {
            i3 = 0;
            while (i3 < 8) {
                vec.addElement(null);
                ++i3;
            }
        }
        return vec;
    }

    public Vector<Object> getSimulationResults(int nPoints) {
        return this.getSimulationResultsAsVector(nPoints);
    }

    public void plotImpedanceMagnitudes() {
        this.plotImpedanceMagnitudeVersusFrequency();
    }

    public void plotImpedanceMagnitudeVersusFrequency() {
        String[] dAndT = this.dateAndTime();
        String graphTitle1 = "ImpedSpecSimulation program:  Impedance Magnitude versus Frequency   [" + dAndT[0] + "    " + dAndT[1] + "]";
        String graphTitle2 = this.simulationTitle;
        if (this.logOrLinear) {
            this.impedanceMagnitudeVersusLogFrequencyPlot(graphTitle1, graphTitle2);
        } else {
            this.impedanceMagnitudeVersusFrequencyPlot(graphTitle1, graphTitle2);
        }
    }

    public void plotMagnitudeVersusFrequency() {
        this.plotImpedanceMagnitudeVersusFrequency();
    }

    private void impedanceMagnitudeVersusLogFrequencyPlot(String graphTitle1, String graphTitle2) {
        if (!this.impedancesSet) {
            this.calculateImpedances();
        }
        double[][] data2 = new double[2][this.numberOfFrequencies];
        data2[0] = this.log10frequencies;
        data2[1] = this.magnitudesZ;
        PlotGraph pg = new PlotGraph(data2);
        pg.setLine(3);
        pg.setPoint(0);
        pg.setGraphTitle(graphTitle1);
        pg.setGraphTitle2(graphTitle2);
        pg.setXaxisLegend("Log10[Frequency / Hz]");
        pg.setYaxisLegend("Impedance Magnitude");
        pg.plot();
    }

    private void impedanceMagnitudeVersusFrequencyPlot(String graphTitle1, String graphTitle2) {
        if (!this.impedancesSet) {
            this.calculateImpedances();
        }
        double[][] data2 = new double[2][this.numberOfFrequencies];
        data2[0] = this.frequencies;
        data2[1] = this.magnitudesZ;
        PlotGraph pg = new PlotGraph(data2);
        pg.setLine(3);
        pg.setPoint(0);
        pg.setGraphTitle(graphTitle1);
        pg.setGraphTitle2(graphTitle2);
        pg.setXaxisLegend("Frequency");
        pg.setXaxisUnitsName("Hz");
        pg.setYaxisLegend("Impedance Magnitude");
        pg.plot();
    }

    public void plotImpedancePhases() {
        this.plotImpedancePhaseVersusFrequency();
    }

    public void plotImpedancePhaseVersusFrequency() {
        String[] dAndT = this.dateAndTime();
        String graphTitle1 = "ImpedSpecSimulation program:  Impedance Phase versus Frequency   [" + dAndT[0] + "    " + dAndT[1] + "]";
        String graphTitle2 = this.simulationTitle;
        if (this.logOrLinear) {
            this.impedancePhaseVersusLogFrequencyPlot(graphTitle1, graphTitle2);
        } else {
            this.impedancePhaseVersusFrequencyPlot(graphTitle1, graphTitle2);
        }
    }

    public void plotPhaseVersusFrequency() {
        this.plotImpedancePhaseVersusFrequency();
    }

    private void impedancePhaseVersusLogFrequencyPlot(String graphTitle1, String graphTitle2) {
        if (!this.impedancesSet) {
            this.calculateImpedances();
        }
        double[][] data2 = new double[2][this.numberOfFrequencies];
        data2[0] = this.log10frequencies;
        data2[1] = this.phasesDegZ;
        PlotGraph pg = new PlotGraph(data2);
        pg.setLine(3);
        pg.setPoint(0);
        pg.setGraphTitle(graphTitle1);
        pg.setGraphTitle2(graphTitle2);
        pg.setXaxisLegend("Log10[Frequency / Hz]");
        pg.setYaxisLegend("Impedance Phase");
        pg.setYaxisUnitsName("degrees");
        pg.plot();
    }

    private void impedancePhaseVersusFrequencyPlot(String graphTitle1, String graphTitle2) {
        if (!this.impedancesSet) {
            this.calculateImpedances();
        }
        double[][] data2 = new double[2][this.numberOfFrequencies];
        data2[0] = this.frequencies;
        data2[1] = this.phasesDegZ;
        PlotGraph pg = new PlotGraph(data2);
        pg.setLine(3);
        pg.setPoint(0);
        pg.setGraphTitle(graphTitle1);
        pg.setGraphTitle2(graphTitle2);
        pg.setXaxisLegend("Frequency");
        pg.setXaxisUnitsName("Hz");
        pg.setYaxisLegend("Impedance Phase");
        pg.setYaxisUnitsName("degrees");
        pg.plot();
    }

    public void plotColeCole() {
        String[] dAndT = this.dateAndTime();
        String graphTitle1 = "ImpedSpecSimulation program:  Cole - Cole plot   [" + dAndT[0] + "    " + dAndT[1] + "]";
        String graphTitle2 = this.simulationTitle;
        this.coleColePlot(graphTitle1, graphTitle2);
    }

    private void coleColePlot(String graphTitle1, String graphTitle2) {
        if (!this.impedancesSet) {
            this.calculateImpedances();
        }
        double[][] data2 = new double[2][this.numberOfFrequencies];
        int i = 0;
        while (i < this.numberOfFrequencies) {
            data2[0][i] = this.realZ[this.numberOfFrequencies - i - 1];
            data2[1][i] = -this.imagZ[this.numberOfFrequencies - i - 1];
            ++i;
        }
        PlotGraph pg = new PlotGraph(data2);
        pg.setLine(3);
        pg.setPoint(0);
        pg.setGraphTitle(graphTitle1);
        pg.setGraphTitle2(graphTitle2);
        pg.setXaxisLegend("Real[Impedance / ohms]");
        pg.setYaxisLegend("-Imag[Impedance / ohms]");
        pg.plot();
    }

    public void plotVoltageMagnitudes() {
        this.plotVoltageMagnitudeVersusFrequency();
    }

    public void plotVoltageMagnitudeVersusFrequency() {
        if (this.voltageSet && this.referenceSet) {
            String[] dAndT = this.dateAndTime();
            String graphTitle1 = "ImpedSpecSimulation program:  Voltage Magnitude versus Frequency   [" + dAndT[0] + "    " + dAndT[1] + "]";
            String graphTitle2 = this.simulationTitle;
            if (this.logOrLinear) {
                this.voltageMagnitudeVersusLogFrequencyPlot(graphTitle1, graphTitle2);
            } else {
                this.voltageMagnitudeVersusFrequencyPlot(graphTitle1, graphTitle2);
            }
        } else {
            System.out.println("A Voltage phase plot cannot be displayed, either no applied");
            System.out.println("voltage and/or reference impedance has been entered");
        }
    }

    private void voltageMagnitudeVersusLogFrequencyPlot(String graphTitle1, String graphTitle2) {
        if (!this.impedancesSet) {
            this.calculateImpedances();
        }
        double[][] data2 = new double[2][this.numberOfFrequencies];
        data2[0] = this.log10frequencies;
        data2[1] = this.magnitudesV;
        PlotGraph pg = new PlotGraph(data2);
        pg.setLine(3);
        pg.setPoint(0);
        pg.setGraphTitle(graphTitle1);
        pg.setGraphTitle2(graphTitle2);
        pg.setXaxisLegend("Log10[Frequency / Hz]");
        pg.setYaxisLegend("Voltage Magnitude");
        pg.plot();
    }

    private void voltageMagnitudeVersusFrequencyPlot(String graphTitle1, String graphTitle2) {
        if (!this.impedancesSet) {
            this.calculateImpedances();
        }
        double[][] data2 = new double[2][this.numberOfFrequencies];
        data2[0] = this.frequencies;
        data2[1] = this.magnitudesV;
        PlotGraph pg = new PlotGraph(data2);
        pg.setLine(3);
        pg.setPoint(0);
        pg.setGraphTitle(graphTitle1);
        pg.setGraphTitle2(graphTitle2);
        pg.setXaxisLegend("Frequency");
        pg.setXaxisUnitsName("Hz");
        pg.setYaxisLegend("Voltage Magnitude");
        pg.plot();
    }

    public void plotVoltagePhases() {
        this.plotVoltagePhaseVersusFrequency();
    }

    public void plotVoltagePhaseVersusFrequency() {
        if (this.voltageSet && this.referenceSet) {
            String[] dAndT = this.dateAndTime();
            String graphTitle1 = "ImpedSpecSimulation program:  Voltage Phase versus Frequency   [" + dAndT[0] + "    " + dAndT[1] + "]";
            String graphTitle2 = this.simulationTitle;
            if (this.logOrLinear) {
                this.voltagePhaseVersusLogFrequencyPlot(graphTitle1, graphTitle2);
            } else {
                this.voltagePhaseVersusFrequencyPlot(graphTitle1, graphTitle2);
            }
        } else {
            System.out.println("A Voltage phase plot cannot be displayed, either no applied");
            System.out.println("voltage and/or reference impedance has been entered");
        }
    }

    private void voltagePhaseVersusLogFrequencyPlot(String graphTitle1, String graphTitle2) {
        if (!this.impedancesSet) {
            this.calculateImpedances();
        }
        double[][] data2 = new double[2][this.numberOfFrequencies];
        data2[0] = this.log10frequencies;
        data2[1] = this.phasesDegV;
        PlotGraph pg = new PlotGraph(data2);
        pg.setLine(3);
        pg.setPoint(0);
        pg.setGraphTitle(graphTitle1);
        pg.setGraphTitle2(graphTitle2);
        pg.setXaxisLegend("Log10[Frequency / Hz]");
        pg.setYaxisLegend("Voltage Phase");
        pg.setYaxisUnitsName("degrees");
        pg.plot();
    }

    private void voltagePhaseVersusFrequencyPlot(String graphTitle1, String graphTitle2) {
        if (!this.impedancesSet) {
            this.calculateImpedances();
        }
        double[][] data2 = new double[2][this.numberOfFrequencies];
        data2[0] = this.frequencies;
        data2[1] = this.phasesDegV;
        PlotGraph pg = new PlotGraph(data2);
        pg.setLine(3);
        pg.setPoint(0);
        pg.setGraphTitle(graphTitle1);
        pg.setGraphTitle2(graphTitle2);
        pg.setXaxisLegend("Frequency");
        pg.setXaxisUnitsName("Hz");
        pg.setYaxisLegend("Voltage Phase");
        pg.setYaxisUnitsName("degrees");
        pg.plot();
    }

    public String[] dateAndTime() {
        Date d = new Date();
        String[] ret = new String[]{DateFormat.getDateInstance().format(d), DateFormat.getTimeInstance().format(d)};
        return ret;
    }

    public void printToTextFile(int nPoints) {
        String fileName = "ImpedSpecSimulationOutput.txt";
        this.fileType = true;
        this.printToTextFile(fileName, nPoints);
    }

    public void print(int nPoints) {
        String fileName = "ImpedSpecSimulationOutput.txt";
        this.fileType = true;
        this.printToTextFile(fileName, nPoints);
    }

    public void print(String fileName, int nPoints) {
        this.printToTextFile(fileName, nPoints);
    }

    public void printToTextFile(String fileName, int nPoints) {
        if (!this.impedancesSet) {
            this.calculateImpedances();
        }
        int field2 = 10;
        int trunc = 4;
        int dotPosition = (fileName = fileName.trim()).indexOf(46);
        if (dotPosition == -1) {
            fileName = String.valueOf(fileName) + ".txt";
        }
        if (nPoints > this.numberOfFrequencies) {
            nPoints = this.numberOfFrequencies;
        }
        int increment = (int)Math.round((double)this.numberOfFrequencies / (double)nPoints);
        int[] points = new int[nPoints];
        points[0] = 0;
        int i = 1;
        while (i < nPoints) {
            points[i] = points[i - 1] + increment;
            ++i;
        }
        if (points[nPoints - 1] != this.numberOfFrequencies - 1) {
            points[nPoints - 1] = this.numberOfFrequencies - 1;
        }
        FileOutput fout = null;
        fout = this.fileType ? new FileOutput(fileName, 'n') : new FileOutput(fileName);
        fout.println("ImpedSpecSimulation Program Output File:  " + this.simulationTitle);
        fout.dateAndTimeln(fileName);
        fout.println();
        if (this.modelSet) {
            fout.println("Circuit - model number " + this.modelNumber);
        } else {
            fout.println("Circuit supplied by the user");
        }
        fout.println();
        fout.println("Circuit Parameters");
        fout.printtab("Parameters");
        fout.println("Value (SI unit)");
        int i2 = 0;
        while (i2 < this.numberOfParameters) {
            fout.printtab(this.modelParameterSymbols[i2], field2);
            fout.println(this.parameters[i2]);
            ++i2;
        }
        fout.println();
        field2 = 14;
        fout.println("Frequecy - Impedance data");
        fout.print("Frequency", field2);
        fout.print("Magnitude", field2);
        fout.print("Phase", field2);
        fout.print("Phase", field2);
        fout.print("Real[Z]", field2);
        fout.print("Imag[Z]", field2);
        fout.print("Log10(freq)", field2);
        fout.println("Radial frequency");
        fout.print("/Hz [freq]", field2);
        fout.print("  ", field2);
        fout.print("/degrees", field2);
        fout.print("/radians", field2);
        fout.print("/ohms", field2);
        fout.print("/ohms", field2);
        fout.print("  ", field2);
        fout.println("/radians");
        i2 = 0;
        while (i2 < nPoints) {
            fout.print(Fmath.truncate(this.frequencies[points[i2]], trunc), field2);
            fout.print(Fmath.truncate(this.magnitudesZ[points[i2]], trunc), field2);
            fout.print(Fmath.truncate(this.phasesDegZ[points[i2]], trunc), field2);
            fout.print(Fmath.truncate(this.phasesRadZ[points[i2]], trunc), field2);
            fout.print(Fmath.truncate(this.realZ[points[i2]], trunc), field2);
            fout.print(Fmath.truncate(this.imagZ[points[i2]], trunc), field2);
            fout.print(Fmath.truncate(this.log10frequencies[points[i2]], trunc), field2);
            fout.println(Fmath.truncate(this.omegas[points[i2]], trunc));
            ++i2;
        }
        fout.println();
        if (this.voltageSet && this.referenceSet) {
            fout.println("Aplied voltage: " + this.appliedVoltage.getReal() + " volts");
            fout.println();
            fout.println("Reference impedance: " + this.referenceImpedance + " ohms");
            fout.println();
            field2 = 14;
            fout.println("Frequecy - Voltage data");
            fout.print("Frequency", field2);
            fout.print("Magnitude", field2);
            fout.print("Phase", field2);
            fout.print("Phase", field2);
            fout.print("Real[V]", field2);
            fout.print("Imag[V]", field2);
            fout.print("Log10(freq)", field2);
            fout.println("Radial frequency");
            fout.print("/Hz [freq]", field2);
            fout.print("  ", field2);
            fout.print("/degrees", field2);
            fout.print("/radians", field2);
            fout.print("/volts", field2);
            fout.print("/volts", field2);
            fout.print("  ", field2);
            fout.println("/radians");
            i2 = 0;
            while (i2 < nPoints) {
                fout.print(Fmath.truncate(this.frequencies[points[i2]], trunc), field2);
                fout.print(Fmath.truncate(this.magnitudesV[points[i2]], trunc), field2);
                fout.print(Fmath.truncate(this.phasesDegV[points[i2]], trunc), field2);
                fout.print(Fmath.truncate(this.phasesRadV[points[i2]], trunc), field2);
                fout.print(Fmath.truncate(this.realV[points[i2]], trunc), field2);
                fout.print(Fmath.truncate(this.imagV[points[i2]], trunc), field2);
                fout.print(Fmath.truncate(this.log10frequencies[points[i2]], trunc), field2);
                fout.println(Fmath.truncate(this.omegas[points[i2]], trunc));
                ++i2;
            }
        }
        fout.close();
    }

    public void printToExcelFile(int nPoints) {
        String fileName = "ImpedSpecSimulationOutput.xls";
        this.fileType = true;
        this.printToExcelFile(fileName, nPoints);
    }

    public void printForExcel(int nPoints) {
        String fileName = "ImpedSpecSimulationOutput.xls";
        this.fileType = true;
        this.printToExcelFile(fileName, nPoints);
    }

    public void printForExcel(String fileName, int nPoints) {
        this.printToExcelFile(fileName, nPoints);
    }

    public void printToExcelFile(String fileName, int nPoints) {
        if (!this.impedancesSet) {
            this.calculateImpedances();
        }
        int field2 = 10;
        int trunc = 4;
        int dotPosition = (fileName = fileName.trim()).indexOf(46);
        fileName = dotPosition == -1 ? String.valueOf(fileName) + ".xls" : String.valueOf(fileName.substring(0, dotPosition)) + ".xls";
        if (nPoints > this.numberOfFrequencies) {
            nPoints = this.numberOfFrequencies;
        }
        int increment = (int)Math.round((double)this.numberOfFrequencies / (double)nPoints);
        int[] points = new int[nPoints];
        points[0] = 0;
        int i = 1;
        while (i < nPoints) {
            points[i] = points[i - 1] + increment;
            ++i;
        }
        if (points[nPoints - 1] != this.numberOfFrequencies - 1) {
            points[nPoints - 1] = this.numberOfFrequencies - 1;
        }
        FileOutput fout = null;
        fout = this.fileType ? new FileOutput(fileName, 'n') : new FileOutput(fileName);
        fout.println("ImpedSpecSimulation Program Output File:  " + this.simulationTitle);
        fout.dateAndTimeln(fileName);
        fout.println();
        if (this.modelSet) {
            fout.println("Circuit - model number " + this.modelNumber);
        } else {
            fout.println("Circuit supplied by the user");
        }
        fout.println();
        fout.println("Circuit Parameters");
        fout.printtab("Parameters");
        fout.println("Value (SI unit)");
        int i2 = 0;
        while (i2 < this.numberOfParameters) {
            fout.printtab(this.modelParameterSymbols[i2], field2);
            fout.println(this.parameters[i2]);
            ++i2;
        }
        fout.println();
        field2 = 10;
        fout.println("Frequecy - Impedance data");
        fout.printtab("Frequency", field2);
        fout.printtab("Magnitude", field2);
        fout.printtab("Phase", field2);
        fout.printtab("Phase", field2);
        fout.printtab("Real[Z]", field2);
        fout.printtab("Imag[Z]", field2);
        fout.printtab("Log10(freq)", field2);
        fout.println("Radial frequency");
        fout.printtab("/Hz [freq]", field2);
        fout.printtab("  ", field2);
        fout.printtab("/degrees", field2);
        fout.printtab("/radians", field2);
        fout.printtab("/ohms", field2);
        fout.printtab("/ohms", field2);
        fout.printtab("  ", field2);
        fout.println("/radians");
        i2 = 0;
        while (i2 < nPoints) {
            fout.printtab(Fmath.truncate(this.frequencies[points[i2]], trunc), field2);
            fout.printtab(Fmath.truncate(this.magnitudesZ[points[i2]], trunc), field2);
            fout.printtab(Fmath.truncate(this.phasesDegZ[points[i2]], trunc), field2);
            fout.printtab(Fmath.truncate(this.phasesRadZ[points[i2]], trunc), field2);
            fout.printtab(Fmath.truncate(this.realZ[points[i2]], trunc), field2);
            fout.printtab(Fmath.truncate(this.imagZ[points[i2]], trunc), field2);
            fout.printtab(Fmath.truncate(this.log10frequencies[points[i2]], trunc), field2);
            fout.println(Fmath.truncate(this.omegas[points[i2]], trunc));
            ++i2;
        }
        fout.println();
        if (this.voltageSet && this.referenceSet) {
            fout.println("Aplied voltage: " + this.appliedVoltage.getReal() + " volts");
            fout.println();
            fout.println("Reference impedance: " + this.referenceImpedance + " ohms");
            fout.println();
            field2 = 14;
            fout.println("Frequecy - Voltage data");
            fout.printtab("Frequency", field2);
            fout.printtab("Magnitude", field2);
            fout.printtab("Phase", field2);
            fout.printtab("Phase", field2);
            fout.printtab("Real[V]", field2);
            fout.printtab("Imag[V]", field2);
            fout.printtab("Log10(freq)", field2);
            fout.println("Radial frequency");
            fout.printtab("/Hz [freq]", field2);
            fout.printtab("  ", field2);
            fout.printtab("/degrees", field2);
            fout.printtab("/radians", field2);
            fout.printtab("/volts", field2);
            fout.printtab("/volts", field2);
            fout.printtab("  ", field2);
            fout.println("/radians");
            i2 = 0;
            while (i2 < nPoints) {
                fout.printtab(Fmath.truncate(this.frequencies[points[i2]], trunc), field2);
                fout.printtab(Fmath.truncate(this.magnitudesV[points[i2]], trunc), field2);
                fout.printtab(Fmath.truncate(this.phasesDegV[points[i2]], trunc), field2);
                fout.printtab(Fmath.truncate(this.phasesRadV[points[i2]], trunc), field2);
                fout.printtab(Fmath.truncate(this.realV[points[i2]], trunc), field2);
                fout.printtab(Fmath.truncate(this.imagV[points[i2]], trunc), field2);
                fout.printtab(Fmath.truncate(this.log10frequencies[points[i2]], trunc), field2);
                fout.println(Fmath.truncate(this.omegas[points[i2]], trunc));
                ++i2;
            }
        }
        fout.close();
    }
}

