/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.Cronbach;
import flanagan.analysis.PCA;
import flanagan.analysis.Stat;
import flanagan.io.Db;
import flanagan.io.FileChooser;
import flanagan.io.FileInput;
import flanagan.io.FileOutput;
import flanagan.math.ArrayMaths;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.math.Matrix;
import flanagan.plot.PlotGraph;
import java.text.DateFormat;
import java.util.Date;

public class Scores {
    protected String[] title = null;
    protected int titleLines = 0;
    protected String inputFilename = null;
    protected String outputFilename = null;
    protected int fileOption = 1;
    protected boolean fileOptionSet = false;
    protected String[] fileExtensions = new String[]{".txt", ".xls"};
    protected boolean fileNumberingSet = false;
    protected int trunc = 6;
    protected boolean truncAll = false;
    protected int originalDataType = -1;
    protected int originalDataOrder = -1;
    protected Object originalData = null;
    protected double[][] scores0 = null;
    protected double[][] originalScores0 = null;
    protected double[][] standardizedScores0 = null;
    protected double[][] scores1 = null;
    protected double[][] originalScores1 = null;
    protected double[][] standardizedScores1 = null;
    protected boolean dataEntered = false;
    protected boolean dataPreprocessed = false;
    protected int nItems = 0;
    protected int originalNitems = 0;
    protected String[] itemNames = null;
    protected String[] originalItemNames = null;
    protected boolean itemNamesSet = false;
    protected int nPersons = 0;
    protected int originalNpersons = 0;
    protected String[] personNames = null;
    protected int nScores = 0;
    protected int originalNscores = 0;
    protected String otherFalse = null;
    protected String otherTrue = null;
    protected boolean otherDichotomousDataSet = false;
    protected boolean[] dichotomous = null;
    protected double[] dichotomousPercentage = null;
    protected boolean dichotomousOverall = false;
    protected boolean dichotomousCheckDone = false;
    protected boolean letterToNumeralSet = true;
    protected boolean ignoreNoResponseRequests = false;
    protected double itemDeletionPercentage = 100.0;
    protected boolean itemDeletionPercentageSet = false;
    protected double personDeletionPercentage = 100.0;
    protected boolean personDeletionPercentageSet = false;
    protected int replacementOption = 3;
    protected String[] replacementOptionNames = new String[]{"score replaced by zero", "score replaced by person's mean", "score replaced by item mean", "score replaced by overall mean", "user supplied score for each 'no response'"};
    protected boolean replacementOptionSet = false;
    protected boolean allNoResponseOptionsSet = false;
    protected boolean noResponseHandlingSet = false;
    protected int nNaN = 0;
    protected boolean[] deletedItems = null;
    protected int nDeletedItems = 0;
    protected int[] deletedItemsIndices = null;
    protected int[] itemIndices = null;
    protected boolean[] deletedPersons = null;
    protected int nDeletedPersons = 0;
    protected int[] deletedPersonsIndices = null;
    protected int[] personIndices = null;
    protected int nReplacements = 0;
    protected String[] replacementIndices = null;
    protected double[] rawItemMeans = null;
    protected double rawItemMeansMean = Double.NaN;
    protected double rawItemMeansSd = Double.NaN;
    protected double rawItemMeansVar = Double.NaN;
    protected double rawItemMeansMin = Double.NaN;
    protected double rawItemMeansMax = Double.NaN;
    protected double rawItemMeansRange = Double.NaN;
    protected double[] rawItemStandardDeviations = null;
    protected double rawItemStandardDeviationsMean = Double.NaN;
    protected double rawItemStandardDeviationsSd = Double.NaN;
    protected double rawItemStandardDeviationsVar = Double.NaN;
    protected double rawItemStandardDeviationsMin = Double.NaN;
    protected double rawItemStandardDeviationsMax = Double.NaN;
    protected double rawItemStandardDeviationsRange = Double.NaN;
    protected double[] rawItemVariances = null;
    protected double rawItemVariancesMean = Double.NaN;
    protected double rawItemVariancesSd = Double.NaN;
    protected double rawItemVariancesVar = Double.NaN;
    protected double rawItemVariancesMin = Double.NaN;
    protected double rawItemVariancesMax = Double.NaN;
    protected double rawItemVariancesRange = Double.NaN;
    protected double[] rawItemMinima = null;
    protected double rawItemMinimaMean = Double.NaN;
    protected double rawItemMinimaSd = Double.NaN;
    protected double rawItemMinimaVar = Double.NaN;
    protected double rawItemMinimaMin = Double.NaN;
    protected double rawItemMinimaMax = Double.NaN;
    protected double rawItemMinimaRange = Double.NaN;
    protected double[] rawItemMaxima = null;
    protected double rawItemMaximaMean = Double.NaN;
    protected double rawItemMaximaSd = Double.NaN;
    protected double rawItemMaximaVar = Double.NaN;
    protected double rawItemMaximaMin = Double.NaN;
    protected double rawItemMaximaMax = Double.NaN;
    protected double rawItemMaximaRange = Double.NaN;
    protected double[] rawItemRanges = null;
    protected double rawItemRangesMean = Double.NaN;
    protected double rawItemRangesSd = Double.NaN;
    protected double rawItemRangesVar = Double.NaN;
    protected double rawItemRangesMin = Double.NaN;
    protected double rawItemRangesMax = Double.NaN;
    protected double rawItemRangesRange = Double.NaN;
    protected double[] rawItemTotals = null;
    protected double rawItemTotalsMean = Double.NaN;
    protected double rawItemTotalsSd = Double.NaN;
    protected double rawItemTotalsVar = Double.NaN;
    protected double rawItemTotalsMin = Double.NaN;
    protected double rawItemTotalsMax = Double.NaN;
    protected double rawItemTotalsRange = Double.NaN;
    protected double[] rawItemMedians = null;
    protected double rawItemMediansMean = Double.NaN;
    protected double rawItemMediansSd = Double.NaN;
    protected double rawItemMediansVar = Double.NaN;
    protected double rawItemMediansMin = Double.NaN;
    protected double rawItemMediansMax = Double.NaN;
    protected double rawItemMediansRange = Double.NaN;
    protected double[] rawItemMomentSkewness = null;
    protected double[] rawItemMedianSkewness = null;
    protected double[] rawItemQuartileSkewness = null;
    protected double[] rawItemKurtosisExcess = null;
    protected double[] rawPersonMeans = null;
    protected double[] rawPersonStandardDeviations = null;
    protected double[] rawPersonVariances = null;
    protected double[] rawPersonMinima = null;
    protected double[] rawPersonMaxima = null;
    protected double[] rawPersonRanges = null;
    protected double[] rawPersonTotals = null;
    protected double rawAllResponsesMean = Double.NaN;
    protected double rawAllResponsesStandardDeviation = Double.NaN;
    protected double rawAllResponsesVariance = Double.NaN;
    protected double rawAllResponsesMinimum = Double.NaN;
    protected double rawAllResponsesMaximum = Double.NaN;
    protected double rawAllResponsesRange = Double.NaN;
    protected double rawAllResponsesTotal = Double.NaN;
    protected double[][] rawCovariances = null;
    protected double[][] rawCorrelationCoefficients = null;
    protected double[] rawRhosWithTotal = null;
    protected double rawMeanRhoWithTotals = Double.NaN;
    protected double rawStandardDeviationRhoWithTotals = Double.NaN;
    protected double rawMeanRhoWithoutTotals = Double.NaN;
    protected double rawStandardDeviationRhoWithoutTotals = Double.NaN;
    protected double[] standardizedItemMeans = null;
    protected double standardizedItemMeansMean = Double.NaN;
    protected double standardizedItemMeansSd = Double.NaN;
    protected double standardizedItemMeansVar = Double.NaN;
    protected double standardizedItemMeansMin = Double.NaN;
    protected double standardizedItemMeansMax = Double.NaN;
    protected double standardizedItemMeansRange = Double.NaN;
    protected double[] standardizedItemStandardDeviations = null;
    protected double standardizedItemStandardDeviationsMean = Double.NaN;
    protected double standardizedItemStandardDeviationsSd = Double.NaN;
    protected double standardizedItemStandardDeviationsVar = Double.NaN;
    protected double standardizedItemStandardDeviationsMin = Double.NaN;
    protected double standardizedItemStandardDeviationsMax = Double.NaN;
    protected double standardizedItemStandardDeviationsRange = Double.NaN;
    protected double[] standardizedItemVariances = null;
    protected double standardizedItemVariancesMean = Double.NaN;
    protected double standardizedItemVariancesSd = Double.NaN;
    protected double standardizedItemVariancesVar = Double.NaN;
    protected double standardizedItemVariancesMin = Double.NaN;
    protected double standardizedItemVariancesMax = Double.NaN;
    protected double standardizedItemVariancesRange = Double.NaN;
    protected double[] standardizedItemMinima = null;
    protected double standardizedItemMinimaMean = Double.NaN;
    protected double standardizedItemMinimaSd = Double.NaN;
    protected double standardizedItemMinimaVar = Double.NaN;
    protected double standardizedItemMinimaMin = Double.NaN;
    protected double standardizedItemMinimaMax = Double.NaN;
    protected double standardizedItemMinimaRange = Double.NaN;
    protected double[] standardizedItemMaxima = null;
    protected double standardizedItemMaximaMean = Double.NaN;
    protected double standardizedItemMaximaSd = Double.NaN;
    protected double standardizedItemMaximaVar = Double.NaN;
    protected double standardizedItemMaximaMin = Double.NaN;
    protected double standardizedItemMaximaMax = Double.NaN;
    protected double standardizedItemMaximaRange = Double.NaN;
    protected double[] standardizedItemRanges = null;
    protected double standardizedItemRangesMean = Double.NaN;
    protected double standardizedItemRangesSd = Double.NaN;
    protected double standardizedItemRangesVar = Double.NaN;
    protected double standardizedItemRangesMin = Double.NaN;
    protected double standardizedItemRangesMax = Double.NaN;
    protected double standardizedItemRangesRange = Double.NaN;
    protected double[] standardizedItemTotals = null;
    protected double standardizedItemTotalsMean = Double.NaN;
    protected double standardizedItemTotalsSd = Double.NaN;
    protected double standardizedItemTotalsVar = Double.NaN;
    protected double standardizedItemTotalsMin = Double.NaN;
    protected double standardizedItemTotalsMax = Double.NaN;
    protected double standardizedItemTotalsRange = Double.NaN;
    protected double[] standardizedItemMedians = null;
    protected double standardizedItemMediansMean = Double.NaN;
    protected double standardizedItemMediansSd = Double.NaN;
    protected double standardizedItemMediansVar = Double.NaN;
    protected double standardizedItemMediansMin = Double.NaN;
    protected double standardizedItemMediansMax = Double.NaN;
    protected double standardizedItemMediansRange = Double.NaN;
    protected double[] standardizedItemMomentSkewness = null;
    protected double[] standardizedItemMedianSkewness = null;
    protected double[] standardizedItemQuartileSkewness = null;
    protected double[] standardizedItemKurtosisExcess = null;
    protected double[] standardizedPersonMeans = null;
    protected double[] standardizedPersonStandardDeviations = null;
    protected double[] standardizedPersonVariances = null;
    protected double[] standardizedPersonMinima = null;
    protected double[] standardizedPersonMaxima = null;
    protected double[] standardizedPersonRanges = null;
    protected double[] standardizedPersonTotals = null;
    protected double standardizedAllResponsesMean = Double.NaN;
    protected double standardizedAllResponsesStandardDeviation = Double.NaN;
    protected double standardizedAllResponsesVariance = Double.NaN;
    protected double standardizedAllResponsesMinimum = Double.NaN;
    protected double standardizedAllResponsesMaximum = Double.NaN;
    protected double standardizedAllResponsesRange = Double.NaN;
    protected double standardizedAllResponsesTotal = Double.NaN;
    protected double[][] standardizedCovariances = null;
    protected double[][] standardizedCorrelationCoefficients = null;
    protected double[] standardizedRhosWithTotal = null;
    protected double standardizedMeanRhoWithTotals = Double.NaN;
    protected double standardizedStandardDeviationRhoWithTotals = Double.NaN;
    protected double standardizedMeanRhoWithoutTotals = Double.NaN;
    protected double standardizedStandardDeviationRhoWithoutTotals = Double.NaN;
    protected boolean variancesCalculated = false;
    protected boolean covariancesCalculated = false;
    protected boolean nFactorOption = false;
    protected int sameCheck = 0;

    public void enterTitle(String title) {
        if (this.title == null) {
            this.title = new String[2];
            this.title[0] = "Title: " + title;
            Date d = new Date();
            String day = DateFormat.getDateInstance().format(d);
            String tim = DateFormat.getTimeInstance().format(d);
            this.title[1] = "Program execution initiated at " + tim + " on " + day;
        } else {
            this.title[0] = title;
        }
    }

    public void setPersonDeletionPercentage(double perCent) {
        this.personDeletionPercentage = perCent;
        this.personDeletionPercentageSet = true;
        if (this.itemDeletionPercentageSet && this.replacementOptionSet) {
            this.allNoResponseOptionsSet = true;
            if (this.dataEntered) {
                this.preprocessData();
            }
        }
    }

    public void setItemDeletionPercentage(double perCent) {
        this.itemDeletionPercentage = perCent;
        this.itemDeletionPercentageSet = true;
        if (this.personDeletionPercentageSet && this.replacementOptionSet) {
            this.allNoResponseOptionsSet = true;
            if (this.dataEntered) {
                this.preprocessData();
            }
        }
    }

    public void setMissingDataOption(int option) {
        if (option < 1 || option > 5) {
            throw new IllegalArgumentException("The missing response option entered is " + option + "; the option must be 1, 2, 3, 4 or 5");
        }
        this.replacementOption = option;
        this.replacementOptionSet = true;
        if (this.personDeletionPercentageSet && this.itemDeletionPercentageSet) {
            this.allNoResponseOptionsSet = true;
            if (this.dataEntered) {
                this.preprocessData();
            }
        }
    }

    public void ignoreMissingDataOptionRequests() {
        this.ignoreNoResponseRequests = true;
        this.allNoResponseOptionsSet = true;
        this.itemDeletionPercentageSet = true;
        this.personDeletionPercentageSet = true;
        this.allNoResponseOptionsSet = true;
    }

    protected void noResponseHandling() {
        if (this.nNaN > 0 && !this.noResponseHandlingSet) {
            int counter;
            double pc;
            int j;
            int i;
            this.nDeletedPersons = 0;
            int j2 = 0;
            while (j2 < this.nPersons) {
                int nIndNaN = 0;
                this.deletedPersons[j2] = false;
                i = 0;
                while (i < this.nItems) {
                    if (Double.isNaN(this.scores0[i][j2])) {
                        ++nIndNaN;
                    }
                    ++i;
                }
                if (nIndNaN == this.nItems) {
                    this.deletedPersons[j2] = true;
                }
                ++j2;
            }
            int i2 = 0;
            while (i2 < this.nPersons) {
                if (!this.deletedPersons[i2]) {
                    int deletedSum = 0;
                    j = 0;
                    while (j < this.nItems) {
                        if (Double.isNaN(this.scores0[j][i2]) && (pc = (double)(++deletedSum) * 100.0 / (double)this.nItems) > this.personDeletionPercentage) {
                            this.deletedPersons[i2] = true;
                        }
                        ++j;
                    }
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < this.nPersons) {
                if (this.deletedPersons[i2]) {
                    ++this.nDeletedPersons;
                }
                ++i2;
            }
            if (this.nDeletedPersons > 0) {
                counter = 0;
                this.deletedPersonsIndices = new int[this.nDeletedPersons];
                int j3 = 0;
                while (j3 < this.nPersons) {
                    if (this.deletedPersons[j3]) {
                        this.deletedPersonsIndices[counter] = j3;
                        ++counter;
                    }
                    ++j3;
                }
                double[][] scoreTemp = new double[this.nItems][this.nPersons - this.nDeletedPersons];
                this.personIndices = new int[this.nPersons - this.nDeletedPersons];
                counter = 0;
                i = 0;
                while (i < this.nPersons) {
                    if (!this.deletedPersons[i]) {
                        int j4 = 0;
                        while (j4 < this.nItems) {
                            scoreTemp[j4][counter] = this.scores0[j4][i];
                            ++j4;
                        }
                        this.personIndices[counter] = i;
                        ++counter;
                    }
                    ++i;
                }
                this.nPersons -= this.nDeletedPersons;
                this.nScores = this.nPersons * this.nItems;
                this.scores0 = scoreTemp;
            }
            if (this.nDeletedPersons == 0) {
                this.personIndices = new int[this.nPersons];
                i2 = 0;
                while (i2 < this.nPersons) {
                    this.personIndices[i2] = i2;
                    ++i2;
                }
            }
            this.deletedItems = new boolean[this.nItems];
            this.nDeletedItems = 0;
            i2 = 0;
            while (i2 < this.nItems) {
                int nItemNaN = 0;
                this.deletedItems[i2] = false;
                j = 0;
                while (j < this.nPersons) {
                    if (Double.isNaN(this.scores0[i2][j])) {
                        ++nItemNaN;
                    }
                    ++j;
                }
                if (nItemNaN == this.nPersons) {
                    this.deletedItems[i2] = true;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < this.nItems) {
                this.deletedItems[i2] = false;
                int deletedSum = 0;
                j = 0;
                while (j < this.nPersons) {
                    if (Double.isNaN(this.scores0[i2][j]) && (pc = (double)(++deletedSum) * 100.0 / (double)this.nPersons) > this.itemDeletionPercentage) {
                        this.deletedItems[i2] = true;
                    }
                    ++j;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < this.nItems) {
                if (this.deletedItems[i2]) {
                    ++this.nDeletedItems;
                }
                ++i2;
            }
            if (this.nDeletedItems > 0) {
                counter = 0;
                this.deletedItemsIndices = new int[this.nDeletedItems];
                int i3 = 0;
                while (i3 < this.nItems) {
                    if (this.deletedItems[i3]) {
                        this.deletedItemsIndices[counter] = i3;
                        ++counter;
                    }
                    ++i3;
                }
                if (this.nItems - this.nDeletedItems <= 1) {
                    throw new IllegalArgumentException("You have deleted " + this.nDeletedItems + " items leaving " + (this.nItems - this.nDeletedItems) + " items and hence no possibility calculation of alpha");
                }
                double[][] scoreTemp = new double[this.nItems - this.nDeletedItems][this.nPersons];
                String[] nameTemp = new String[this.nItems - this.nDeletedItems];
                this.itemIndices = new int[this.nItems - this.nDeletedItems];
                counter = 0;
                int i4 = 0;
                while (i4 < this.nItems) {
                    if (!this.deletedItems[i4]) {
                        nameTemp[counter] = this.itemNames[i4];
                        int j5 = 0;
                        while (j5 < this.nPersons) {
                            scoreTemp[counter][j5] = this.scores0[i4][j5];
                            ++j5;
                        }
                        this.itemIndices[counter] = i4;
                        ++counter;
                    }
                    ++i4;
                }
                this.nItems -= this.nDeletedItems;
                this.nScores = this.nPersons * this.nItems;
                this.scores0 = scoreTemp;
                this.scores1 = this.transpose0to1(this.scores0);
                this.itemNames = nameTemp;
            }
            if (this.nDeletedItems == 0) {
                this.itemIndices = new int[this.nItems];
                i2 = 0;
                while (i2 < this.nItems) {
                    this.itemIndices[i2] = i2;
                    ++i2;
                }
            }
            int newNaNn = 0;
            int i5 = 0;
            while (i5 < this.nPersons) {
                int j6 = 0;
                while (j6 < this.nItems) {
                    if (!Double.isNaN(this.scores0[j6][i5])) {
                        ++newNaNn;
                    }
                    ++j6;
                }
                ++i5;
            }
            if (newNaNn > 0) {
                int j7;
                double[] tItemMeans = new double[this.nItems];
                double tTotalMean = 0.0;
                int counter2 = 0;
                int i6 = 0;
                while (i6 < this.nItems) {
                    tItemMeans[i6] = 0.0;
                    int counter3 = 0;
                    int j8 = 0;
                    while (j8 < this.nPersons) {
                        if (!Double.isNaN(this.scores0[i6][j8])) {
                            int n = i6;
                            tItemMeans[n] = tItemMeans[n] + this.scores0[i6][j8];
                            ++counter3;
                            tTotalMean += this.scores0[i6][j8];
                            ++counter2;
                        }
                        ++j8;
                    }
                    int n = i6++;
                    tItemMeans[n] = tItemMeans[n] / (double)counter3;
                    tTotalMean /= (double)counter2;
                }
                double[] tIndivMeans = new double[this.nPersons];
                int i7 = 0;
                while (i7 < this.nPersons) {
                    tIndivMeans[i7] = 0.0;
                    int counter4 = 0;
                    j7 = 0;
                    while (j7 < this.nItems) {
                        if (!Double.isNaN(this.scores0[j7][i7])) {
                            int n = i7;
                            tIndivMeans[n] = tIndivMeans[n] + this.scores0[j7][i7];
                            ++counter4;
                        }
                        ++j7;
                    }
                    int n = i7++;
                    tIndivMeans[n] = tIndivMeans[n] / (double)counter4;
                }
                this.replacementIndices = new String[newNaNn];
                int rcounter = 0;
                switch (this.replacementOption) {
                    case 1: {
                        int i8 = 0;
                        while (i8 < this.nItems) {
                            j7 = 0;
                            while (j7 < this.nPersons) {
                                if (Double.isNaN(this.scores0[i8][j7])) {
                                    this.scores0[i8][j7] = 0.0;
                                    this.replacementIndices[rcounter] = String.valueOf(this.itemNames[i8]) + ", " + (j7 + 1) + ";";
                                    ++rcounter;
                                }
                                ++j7;
                            }
                            ++i8;
                        }
                        break;
                    }
                    case 2: {
                        int i8 = 0;
                        while (i8 < this.nItems) {
                            j7 = 0;
                            while (j7 < this.nPersons) {
                                if (Double.isNaN(this.scores0[i8][j7])) {
                                    this.scores0[i8][j7] = tIndivMeans[i8];
                                    this.replacementIndices[rcounter] = String.valueOf(this.itemNames[i8]) + ", " + (j7 + 1) + ";";
                                    ++rcounter;
                                }
                                ++j7;
                            }
                            ++i8;
                        }
                        break;
                    }
                    case 3: {
                        int i8 = 0;
                        while (i8 < this.nItems) {
                            j7 = 0;
                            while (j7 < this.nPersons) {
                                if (Double.isNaN(this.scores0[i8][j7])) {
                                    this.scores0[i8][j7] = tItemMeans[i8];
                                    this.replacementIndices[rcounter] = String.valueOf(this.itemNames[i8]) + ", " + (j7 + 1) + ";";
                                    ++rcounter;
                                }
                                ++j7;
                            }
                            ++i8;
                        }
                        break;
                    }
                    case 4: {
                        int i8 = 0;
                        while (i8 < this.nItems) {
                            j7 = 0;
                            while (j7 < this.nPersons) {
                                if (Double.isNaN(this.scores0[i8][j7])) {
                                    this.scores0[i8][j7] = tTotalMean;
                                    this.replacementIndices[rcounter] = String.valueOf(this.itemNames[i8]) + ", " + (j7 + 1) + ";";
                                    ++rcounter;
                                }
                                ++j7;
                            }
                            ++i8;
                        }
                        break;
                    }
                    case 5: {
                        int i8 = 0;
                        while (i8 < this.nItems) {
                            j7 = 0;
                            while (j7 < this.nPersons) {
                                if (Double.isNaN(this.scores0[i8][j7])) {
                                    String message1 = "Missing response:";
                                    String message2 = "\nItem index = " + i8 + ",    item mean = " + Fmath.truncate(tItemMeans[i8], 4);
                                    String message3 = "\nPerson index = " + j7 + ",    person's responses mean = " + Fmath.truncate(tIndivMeans[j7], 4);
                                    String message4 = "\nTotal mean = " + Fmath.truncate(tTotalMean, 4);
                                    String message5 = "\nEnter the replacement value";
                                    String message = String.valueOf(message1) + message2 + message3 + message4 + message5;
                                    this.scores0[i8][j7] = Db.readDouble(message);
                                    this.replacementIndices[rcounter] = String.valueOf(this.itemNames[i8]) + ", " + (j7 + 1) + ";";
                                    ++rcounter;
                                }
                                ++j7;
                            }
                            ++i8;
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("!! It should not be possible to have an option choice (replacementOption) = " + this.replacementOption);
                    }
                }
                this.nReplacements = rcounter--;
            }
        }
        this.scores1 = this.transpose0to1(this.scores0);
        this.noResponseHandlingSet = true;
    }

    protected void noResponseRequests() {
        if (!this.allNoResponseOptionsSet) {
            if (!this.ignoreNoResponseRequests) {
                String message6;
                String message5;
                String message4;
                String message3;
                String message2;
                String message1;
                String message0;
                if (this.personDeletionPercentage != 0.0 && !this.itemDeletionPercentageSet) {
                    message0 = "There are missing responses in this data set";
                    message1 = "\nYou have not set the percentage of no responses at which you will delete an item";
                    message2 = "\n(0% = item deleted if a single 'no response' present in the item)";
                    message3 = "\n(100% = item never deleted)";
                    message4 = "\nEnter the required value and click OK ";
                    message5 = "\nor simply click OK for default value";
                    message6 = String.valueOf(message0) + message1 + message2 + message3 + message4 + message5;
                    this.itemDeletionPercentage = Db.readDouble(message6, this.itemDeletionPercentage);
                }
                this.itemDeletionPercentageSet = true;
                if (this.itemDeletionPercentage != 0.0 && !this.personDeletionPercentageSet) {
                    message0 = "There are missing responses in this data set";
                    message1 = "\nYou have not set the percentage of no responses at which you will delete a person";
                    message2 = "\n(0% = person deleted if gives a single 'no response')";
                    message3 = "\n(100% = person never deleted)";
                    message4 = "\nEnter the required value and click OK ";
                    message5 = "\nor simply click OK for default value";
                    message6 = String.valueOf(message0) + message1 + message2 + message3 + message4 + message5;
                    this.personDeletionPercentage = Db.readDouble(message6, this.personDeletionPercentage);
                }
                this.personDeletionPercentageSet = true;
                if (this.itemDeletionPercentage != 0.0 && this.personDeletionPercentage != 0.0 && !this.replacementOptionSet) {
                    message0 = "There are missing responses in this data set";
                    message1 = "\nYou have not set the option flag for replacing a missing score";
                    message2 = "\n  option = 1 - score replaced by zero";
                    message3 = "\n  option = 2 - score replaced by person's mean";
                    message4 = "\n  option = 3 - score replaced by item mean (default option)";
                    message5 = "\n  option = 4 - score replaced by overall mean";
                    message6 = "\n  option = 5 - user supplied score for each 'no response'";
                    String message7 = "\nEnter the required value and click OK ";
                    String message8 = "\nor simply click OK for default value";
                    String message9 = String.valueOf(message0) + message1 + message2 + message3 + message4 + message5 + message6 + message7 + message8;
                    this.replacementOption = Db.readInt(message9, this.replacementOption);
                }
                this.replacementOptionSet = true;
            }
            this.allNoResponseOptionsSet = true;
        }
    }

    public void setDenominatorToN() {
        this.nFactorOption = true;
    }

    public void setDenominatorToNminusOne() {
        this.nFactorOption = false;
    }

    public int[] deletedPersonsIndices() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (this.nDeletedPersons == 0) {
            System.out.println("Method - deletedPersonsIndices: there are no deleted persons; null returned");
            return null;
        }
        ArrayMaths am1 = new ArrayMaths(this.deletedPersonsIndices);
        ArrayMaths am2 = am1.plus(1);
        return am2.array_as_int();
    }

    public int numberOfDeletedPersons() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.nDeletedPersons;
    }

    public int[] deletedItemsIndices() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (this.nDeletedItems == 0) {
            System.out.println("Method - deletedItemsIndices: there are no deleted items; null returned");
            return null;
        }
        ArrayMaths am1 = new ArrayMaths(this.deletedItemsIndices);
        ArrayMaths am2 = am1.plus(1);
        return am2.array_as_int();
    }

    public String[] deletedItemsNames() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (this.nDeletedItems == 0) {
            System.out.println("Method - deletedItemsIndices: there are no deleted items; null returned");
            return null;
        }
        String[] nam = new String[this.nDeletedItems];
        int i = 0;
        while (i < this.nDeletedItems) {
            nam[i] = this.originalItemNames[this.deletedItemsIndices[i]];
            ++i;
        }
        return nam;
    }

    public int numberOfDeletedItems() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.nDeletedItems;
    }

    public void readScoresAsRowPerItem() {
        int lineNumber = 1;
        FileChooser fin = new FileChooser();
        this.inputFilename = fin.selectFile();
        if (fin.eol()) {
            ++lineNumber;
        }
        this.title = new String[3];
        this.titleLines = 3;
        this.title[0] = fin.readLine();
        this.title[1] = "Data read from file: " + this.inputFilename;
        Date d = new Date();
        String day = DateFormat.getDateInstance().format(d);
        String tim = DateFormat.getTimeInstance().format(d);
        this.title[2] = "Program execution initiated at " + tim + " on " + day;
        this.nItems = fin.readInt();
        if (fin.eol()) {
            ++lineNumber;
        }
        this.nPersons = fin.readInt();
        if (fin.eol()) {
            ++lineNumber;
        }
        this.nScores = this.nItems * this.nPersons;
        this.itemNames = new String[this.nItems + 1];
        this.personNames = new String[this.nPersons + 1];
        int i = 0;
        while (i < this.nItems) {
            this.itemNames[i] = fin.readWord();
            if (fin.eol()) {
                ++lineNumber;
            }
            ++i;
        }
        this.itemNames[this.nItems] = "total";
        this.originalItemNames = this.itemNames;
        this.itemNamesSet = true;
        String[][] scores = new String[this.nItems][this.nPersons];
        int i2 = 0;
        while (i2 < this.nItems) {
            int wordsPerLine = 1;
            int j = 0;
            while (j < this.nPersons) {
                scores[i2][j] = fin.readWord();
                if (fin.eol()) {
                    if (wordsPerLine != this.nPersons) {
                        throw new IllegalArgumentException("Line " + lineNumber + ": the number of scores in this row, " + wordsPerLine + ", does not equal the total number of persons, " + this.nPersons);
                    }
                    ++lineNumber;
                } else {
                    ++wordsPerLine;
                }
                ++j;
            }
            ++i2;
        }
        fin.close();
        this.originalData = scores;
        this.originalDataType = 1;
        this.originalDataOrder = 0;
        this.dataEntered = true;
    }

    public void readScoresAsRowPerItem(String filename) {
        int lineNumber = 1;
        this.inputFilename = filename;
        FileInput fin = new FileInput(filename);
        if (fin.eol()) {
            ++lineNumber;
        }
        this.title = new String[3];
        this.titleLines = 3;
        this.title[0] = fin.readLine();
        this.title[1] = "Data read from file: " + filename;
        Date d = new Date();
        String day = DateFormat.getDateInstance().format(d);
        String tim = DateFormat.getTimeInstance().format(d);
        this.title[2] = "Program execution initiated at " + tim + " on " + day;
        this.nItems = fin.readInt();
        if (fin.eol()) {
            ++lineNumber;
        }
        this.itemNames = new String[this.nItems + 1];
        int i = 0;
        while (i < this.nItems) {
            this.itemNames[i] = "item " + i;
            System.out.println(this.itemNames[i]);
            ++i;
        }
        this.nPersons = fin.readInt();
        if (fin.eol()) {
            ++lineNumber;
        }
        this.personNames = new String[this.nPersons];
        this.nScores = this.nItems * this.nPersons;
        i = 0;
        while (i < this.nPersons) {
            this.personNames[i] = fin.readWord();
            if (fin.eol()) {
                ++lineNumber;
            }
            ++i;
        }
        this.itemNames[this.nItems] = "total";
        this.originalItemNames = this.itemNames;
        this.itemNamesSet = true;
        String[][] scores = new String[this.nItems][this.nPersons];
        int i2 = 0;
        while (i2 < this.nItems) {
            int wordsPerLine = 1;
            int j = 0;
            while (j < this.nPersons) {
                scores[i2][j] = fin.readWord();
                System.out.println("w " + i2 + " " + j + " " + scores[i2][j] + " " + lineNumber);
                if (fin.eol()) {
                    if (wordsPerLine != this.nPersons) {
                        throw new IllegalArgumentException("Line " + lineNumber + ": the number of scores in this row, " + wordsPerLine + ", does not equal the total number of persons, " + this.nPersons);
                    }
                    ++lineNumber;
                } else {
                    ++wordsPerLine;
                }
                ++j;
            }
            ++i2;
        }
        fin.close();
        this.originalData = scores;
        this.originalDataType = 1;
        this.originalDataOrder = 0;
        this.dataEntered = true;
    }

    public void enterScoresAsRowPerItem(String[][] scores) {
        this.nItems = scores.length;
        this.nPersons = scores[0].length;
        this.nScores = this.nItems * this.nPersons;
        if (this.title == null) {
            this.title = new String[2];
            this.title[0] = "Untitled Scores Analysis";
            Date d = new Date();
            String day = DateFormat.getDateInstance().format(d);
            String tim = DateFormat.getTimeInstance().format(d);
            this.title[1] = "Program execution initiated at " + tim + " on " + day;
        }
        this.originalData = Conv.copy(scores);
        this.originalDataType = 1;
        this.originalDataOrder = 0;
        this.dataEntered = true;
    }

    public void enterScoresAsRowPerItem(double[][] scores) {
        this.nItems = scores.length;
        this.nPersons = scores[0].length;
        this.nScores = this.nItems * this.nPersons;
        if (this.title == null) {
            this.title = new String[2];
            this.title[0] = "Untitled";
            Date d = new Date();
            String day = DateFormat.getDateInstance().format(d);
            String tim = DateFormat.getTimeInstance().format(d);
            this.title[1] = "Program execution initiated at " + tim + " on " + day;
        }
        this.originalData = Conv.copy(scores);
        this.originalDataType = 2;
        this.originalDataOrder = 0;
        this.dataEntered = true;
    }

    public void enterScoresAsRowPerItem(Matrix scores) {
        double[][] scoresdd = scores.getArrayCopy();
        this.nItems = scoresdd.length;
        this.nPersons = scoresdd[0].length;
        this.nScores = this.nItems * this.nPersons;
        if (this.title == null) {
            this.title = new String[2];
            this.title[0] = "Untitled Scores Analysis";
            Date d = new Date();
            String day = DateFormat.getDateInstance().format(d);
            String tim = DateFormat.getTimeInstance().format(d);
            this.title[1] = "Program execution initiated at " + tim + " on " + day;
        }
        this.originalData = scores.copy();
        this.originalDataType = 3;
        this.originalDataOrder = 0;
        this.dataEntered = true;
    }

    public void enterScoresAsRowPerItem(float[][] scores) {
        this.nItems = scores.length;
        this.nPersons = scores[0].length;
        this.nScores = this.nItems * this.nPersons;
        if (this.title == null) {
            this.title = new String[2];
            this.title[0] = "Untitled Scores Analysis";
            Date d = new Date();
            String day = DateFormat.getDateInstance().format(d);
            String tim = DateFormat.getTimeInstance().format(d);
            this.title[1] = "Program execution initiated at " + tim + " on " + day;
        }
        this.originalData = Conv.copy(scores);
        this.originalDataType = 4;
        this.originalDataOrder = 0;
        this.dataEntered = true;
    }

    public void enterScoresAsRowPerItem(int[][] scores) {
        this.nItems = scores.length;
        this.nPersons = scores[0].length;
        this.nScores = this.nItems * this.nPersons;
        if (this.title == null) {
            this.title = new String[2];
            this.title[0] = "Untitled Scores Analysis";
            Date d = new Date();
            String day = DateFormat.getDateInstance().format(d);
            String tim = DateFormat.getTimeInstance().format(d);
            this.title[1] = "Program execution initiated at " + tim + " on " + day;
        }
        this.originalData = Conv.copy(scores);
        this.originalDataType = 5;
        this.originalDataOrder = 0;
        this.dataEntered = true;
    }

    public void enterScoresAsRowPerItem(char[][] scores) {
        this.nItems = scores.length;
        this.nPersons = scores[0].length;
        this.nScores = this.nItems * this.nPersons;
        if (this.title == null) {
            this.title = new String[2];
            this.title[0] = "Untitled Scores Analysis";
            Date d = new Date();
            String day = DateFormat.getDateInstance().format(d);
            String tim = DateFormat.getTimeInstance().format(d);
            this.title[1] = "Program execution initiated at " + tim + " on " + day;
        }
        this.originalData = Conv.copy(scores);
        this.originalDataType = 6;
        this.originalDataOrder = 0;
        this.dataEntered = true;
    }

    public void enterScoresAsRowPerItem(boolean[][] scores) {
        this.nItems = scores.length;
        this.nPersons = scores[0].length;
        this.nScores = this.nItems * this.nPersons;
        this.dichotomous = new boolean[this.nItems];
        this.dichotomousPercentage = new double[this.nItems];
        int i = 0;
        while (i < this.nItems) {
            this.dichotomous[i] = true;
            this.dichotomousPercentage[i] = 100.0;
            ++i;
        }
        this.dichotomousOverall = true;
        this.dichotomousCheckDone = true;
        if (this.title == null) {
            this.title = new String[2];
            this.title[0] = "Untitled Scores Analysis";
            Date d = new Date();
            String day = DateFormat.getDateInstance().format(d);
            String tim = DateFormat.getTimeInstance().format(d);
            this.title[1] = "Program execution initiated at " + tim + " on " + day;
        }
        this.originalData = Conv.copy(scores);
        this.originalDataType = 7;
        this.originalDataOrder = 0;
        this.dataEntered = true;
    }

    public void readScoresAsRowPerPerson() {
        int lineNumber = 1;
        FileChooser fin = new FileChooser();
        this.inputFilename = fin.selectFile();
        if (fin.eol()) {
            ++lineNumber;
        }
        this.title = new String[3];
        this.titleLines = 3;
        this.title[0] = "Title: " + fin.readLine();
        this.title[1] = "Data read from file: " + this.inputFilename;
        Date d = new Date();
        String day = DateFormat.getDateInstance().format(d);
        String tim = DateFormat.getTimeInstance().format(d);
        this.title[2] = "Program execution initiated at " + tim + " on " + day;
        this.nItems = fin.readInt();
        if (fin.eol()) {
            ++lineNumber;
        }
        this.nPersons = fin.readInt();
        if (fin.eol()) {
            ++lineNumber;
        }
        this.nScores = this.nItems * this.nPersons;
        this.itemNames = new String[this.nItems + 1];
        int i = 0;
        while (i < this.nItems) {
            this.itemNames[i] = fin.readWord();
            if (fin.eol()) {
                ++lineNumber;
            }
            ++i;
        }
        this.itemNames[this.nItems] = "total";
        this.originalItemNames = this.itemNames;
        this.itemNamesSet = true;
        String[][] scores = new String[this.nPersons][this.nItems];
        int i2 = 0;
        while (i2 < this.nPersons) {
            int wordsPerLine = 1;
            int j = 0;
            while (j < this.nItems) {
                scores[i2][j] = fin.readWord();
                if (fin.eol()) {
                    if (wordsPerLine != this.nItems) {
                        throw new IllegalArgumentException("Line " + lineNumber + ": the number of scores in this row, " + wordsPerLine + ", does not equal the total number of items, " + this.nItems);
                    }
                    ++lineNumber;
                } else {
                    ++wordsPerLine;
                }
                ++j;
            }
            ++i2;
        }
        fin.close();
        this.originalData = scores;
        this.originalDataType = 1;
        this.originalDataOrder = 1;
        this.dataEntered = true;
    }

    public void readScoresAsRowPerPerson(String filename) {
        int lineNumber = 1;
        this.inputFilename = filename;
        FileInput fin = new FileInput(filename);
        if (fin.eol()) {
            ++lineNumber;
        }
        this.title = new String[3];
        this.titleLines = 3;
        this.title[0] = "Title: " + fin.readLine();
        this.title[1] = "Data read from file: " + filename;
        Date d = new Date();
        String day = DateFormat.getDateInstance().format(d);
        String tim = DateFormat.getTimeInstance().format(d);
        this.title[2] = "Program execution initiated at " + tim + " on " + day;
        this.nItems = fin.readInt();
        if (fin.eol()) {
            ++lineNumber;
        }
        this.nPersons = fin.readInt();
        if (fin.eol()) {
            ++lineNumber;
        }
        this.nScores = this.nItems * this.nPersons;
        this.itemNames = new String[this.nItems + 1];
        int i = 0;
        while (i < this.nItems) {
            this.itemNames[i] = fin.readWord();
            if (fin.eol()) {
                ++lineNumber;
            }
            ++i;
        }
        this.itemNames[this.nItems] = "total";
        this.originalItemNames = this.itemNames;
        this.itemNamesSet = true;
        String[][] scores = new String[this.nPersons][this.nItems];
        int i2 = 0;
        while (i2 < this.nPersons) {
            int wordsPerLine = 1;
            int j = 0;
            while (j < this.nItems) {
                scores[i2][j] = fin.readWord();
                if (fin.eol()) {
                    if (wordsPerLine != this.nItems) {
                        throw new IllegalArgumentException("Line " + lineNumber + ": the number of scores in this row, " + wordsPerLine + ", does not equal the total number of items, " + this.nItems);
                    }
                    ++lineNumber;
                } else {
                    ++wordsPerLine;
                }
                ++j;
            }
            ++i2;
        }
        fin.close();
        this.originalData = scores;
        this.originalDataType = 1;
        this.originalDataOrder = 1;
        this.dataEntered = true;
    }

    public void enterScoresAsRowPerPerson(String[][] scores) {
        this.nPersons = scores.length;
        this.nItems = scores[0].length;
        this.nScores = this.nItems * this.nPersons;
        if (this.title == null) {
            this.title = new String[2];
            this.title[0] = "Untitled Scores Analysis";
            Date d = new Date();
            String day = DateFormat.getDateInstance().format(d);
            String tim = DateFormat.getTimeInstance().format(d);
            this.title[1] = "Program execution initiated at " + tim + " on " + day;
        }
        this.originalData = Conv.copy(scores);
        this.originalDataType = 1;
        this.originalDataOrder = 1;
        this.dataEntered = true;
    }

    public void enterScoresAsRowPerIperson(String[][] scores) {
        this.enterScoresAsRowPerPerson(scores);
    }

    public void enterScoresAsRowPerPerson(double[][] scores) {
        this.nPersons = scores.length;
        this.nItems = scores[0].length;
        this.nScores = this.nItems * this.nPersons;
        if (this.title == null) {
            this.title = new String[2];
            this.title[0] = "Untitled Scores Analysis";
            Date d = new Date();
            String day = DateFormat.getDateInstance().format(d);
            String tim = DateFormat.getTimeInstance().format(d);
            this.title[1] = "Program execution initiated at " + tim + " on " + day;
        }
        this.originalData = Conv.copy(scores);
        this.originalDataType = 2;
        this.originalDataOrder = 1;
        this.dataEntered = true;
    }

    public void enterScoresAsRowPerPerson(Matrix scores) {
        double[][] scoresdd = scores.getArrayCopy();
        this.nPersons = scoresdd.length;
        this.nItems = scoresdd[0].length;
        this.nScores = this.nItems * this.nPersons;
        if (this.title == null) {
            this.title = new String[2];
            this.title[0] = "Untitled Scores Analysis";
            Date d = new Date();
            String day = DateFormat.getDateInstance().format(d);
            String tim = DateFormat.getTimeInstance().format(d);
            this.title[1] = "Program execution initiated at " + tim + " on " + day;
        }
        this.originalData = scores.copy();
        this.originalDataType = 3;
        this.originalDataOrder = 1;
        this.dataEntered = true;
    }

    public void enterScoresAsRowPerPerson(float[][] scores) {
        this.nPersons = scores.length;
        this.nItems = scores[0].length;
        this.nScores = this.nItems * this.nPersons;
        if (this.title == null) {
            this.title = new String[2];
            this.title[0] = "Untitled Scores Analysis";
            Date d = new Date();
            String day = DateFormat.getDateInstance().format(d);
            String tim = DateFormat.getTimeInstance().format(d);
            this.title[1] = "Program execution initiated at " + tim + " on " + day;
        }
        this.originalData = Conv.copy(scores);
        this.originalDataType = 4;
        this.originalDataOrder = 1;
        this.dataEntered = true;
    }

    public void enterScoresAsRowPerPerson(int[][] scores) {
        this.nPersons = scores.length;
        this.nItems = scores[0].length;
        this.nScores = this.nItems * this.nPersons;
        if (this.title == null) {
            this.title = new String[2];
            this.title[0] = "Untitled Scores Analysis";
            Date d = new Date();
            String day = DateFormat.getDateInstance().format(d);
            String tim = DateFormat.getTimeInstance().format(d);
            this.title[1] = "Program execution initiated at " + tim + " on " + day;
        }
        this.originalData = Conv.copy(scores);
        this.originalDataType = 5;
        this.originalDataOrder = 1;
        this.dataEntered = true;
    }

    public void enterScoresAsRowPerPerson(char[][] scores) {
        this.nPersons = scores.length;
        this.nItems = scores[0].length;
        this.nScores = this.nItems * this.nPersons;
        if (this.title == null) {
            this.title = new String[2];
            this.title[0] = "Untitled Scores Analysis";
            Date d = new Date();
            String day = DateFormat.getDateInstance().format(d);
            String tim = DateFormat.getTimeInstance().format(d);
            this.title[1] = "Program execution initiated at " + tim + " on " + day;
        }
        this.originalData = Conv.copy(scores);
        this.originalDataType = 6;
        this.originalDataOrder = 1;
        this.dataEntered = true;
    }

    public void enterScoresAsRowPerPerson(boolean[][] scores) {
        this.nPersons = scores.length;
        this.nItems = scores[0].length;
        this.nScores = this.nItems * this.nPersons;
        this.dichotomous = new boolean[this.nItems];
        this.dichotomousPercentage = new double[this.nItems];
        int i = 0;
        while (i < this.nItems) {
            this.dichotomous[i] = true;
            this.dichotomousPercentage[i] = 100.0;
            ++i;
        }
        this.dichotomousOverall = true;
        this.dichotomousCheckDone = true;
        if (this.title == null) {
            this.title = new String[2];
            this.title[0] = "Untitled Scores Analysis";
            Date d = new Date();
            String day = DateFormat.getDateInstance().format(d);
            String tim = DateFormat.getTimeInstance().format(d);
            this.title[1] = "Program execution initiated at " + tim + " on " + day;
        }
        this.originalData = Conv.copy(scores);
        this.originalDataType = 7;
        this.originalDataOrder = 1;
        this.dataEntered = true;
    }

    public void enterItemNames(String[] itemNames) {
        int len = itemNames.length;
        this.itemNames = new String[len + 1];
        int i = 0;
        while (i < len) {
            this.itemNames[i] = itemNames[i];
            ++i;
        }
        this.itemNames[len] = "total";
        this.itemNamesSet = true;
    }

    public void letterToNumeral() {
        this.letterToNumeralSet = true;
    }

    public void suspendLetterToNumeral() {
        this.letterToNumeralSet = false;
    }

    public void otherDichotomousData(String falseSign, String trueSign) {
        this.otherFalse = falseSign;
        this.otherTrue = trueSign;
        this.otherDichotomousDataSet = true;
    }

    protected double[][] transpose0to1(double[][] scores00) {
        int n0 = scores00.length;
        int n1 = scores00[0].length;
        double[][] scores11 = new double[n1][n0];
        int i = 0;
        while (i < n0) {
            int j = 0;
            while (j < n1) {
                scores11[j][i] = scores00[i][j];
                ++j;
            }
            ++i;
        }
        return scores11;
    }

    protected String[][] transpose0to1(String[][] scores00) {
        int n0 = scores00.length;
        int n1 = scores00[0].length;
        String[][] scores11 = new String[n1][n0];
        int i = 0;
        while (i < n0) {
            int j = 0;
            while (j < n1) {
                scores11[j][i] = scores00[i][j];
                ++j;
            }
            ++i;
        }
        return scores11;
    }

    protected double[][] transpose1to0(double[][] scores11) {
        int n0 = scores11.length;
        int n1 = scores11[0].length;
        double[][] scores00 = new double[n1][n0];
        int i = 0;
        while (i < n0) {
            int j = 0;
            while (j < n1) {
                scores00[j][i] = scores11[i][j];
                ++j;
            }
            ++i;
        }
        return scores00;
    }

    protected String[][] transpose1to0(String[][] scores11) {
        int n0 = scores11.length;
        int n1 = scores11[0].length;
        String[][] scores00 = new String[n1][n0];
        int i = 0;
        while (i < n0) {
            int j = 0;
            while (j < n1) {
                scores00[j][i] = scores11[i][j];
                ++j;
            }
            ++i;
        }
        return scores00;
    }

    protected boolean[][] transpose1to0(boolean[][] scores11) {
        int n0 = scores11.length;
        int n1 = scores11[0].length;
        boolean[][] scores00 = new boolean[n1][n0];
        int i = 0;
        while (i < n0) {
            int j = 0;
            while (j < n1) {
                scores00[j][i] = scores11[i][j];
                ++j;
            }
            ++i;
        }
        return scores00;
    }

    protected void checkLengths(String[][] scores) {
        int n0 = scores.length;
        int n1 = scores[0].length;
        int i = 1;
        while (i < n0) {
            if (scores[i].length != n1) {
                throw new IllegalArgumentException("The length of each item and of each person's responses must be identical (missing responses must be included - see documentation web page)");
            }
            ++i;
        }
    }

    protected void checkLengths(double[][] scores) {
        int n0 = scores.length;
        int n1 = scores[0].length;
        int i = 1;
        while (i < n0) {
            if (scores[i].length != n1) {
                throw new IllegalArgumentException("The length of each item and of each person's responses must be identical (missing responses must be included - see documentation web page)");
            }
            ++i;
        }
    }

    protected void checkLengths(char[][] scores) {
        int n0 = scores.length;
        int n1 = scores[0].length;
        int i = 1;
        while (i < n0) {
            if (scores[i].length != n1) {
                throw new IllegalArgumentException("The length of each item and of each person's responses must be identical (missing responses must be included - see documentation web page)");
            }
            ++i;
        }
    }

    protected void checkLengths(float[][] scores) {
        int n0 = scores.length;
        int n1 = scores[0].length;
        int i = 1;
        while (i < n0) {
            if (scores[i].length != n1) {
                throw new IllegalArgumentException("The length of each item and of each person's responses must be identical (missing responses must be included - see documentation web page)");
            }
            ++i;
        }
    }

    protected void checkLengths(int[][] scores) {
        int n0 = scores.length;
        int n1 = scores[0].length;
        int i = 1;
        while (i < n0) {
            if (scores[i].length != n1) {
                throw new IllegalArgumentException("The length of each item and of each person's responses must be identical (missing responses must be included - see documentation web page)");
            }
            ++i;
        }
    }

    protected void checkLengths(boolean[][] scores) {
        int n0 = scores.length;
        int n1 = scores[0].length;
        int i = 1;
        while (i < n0) {
            if (scores[i].length != n1) {
                throw new IllegalArgumentException("The length of each item and of each person's responses must be identical (missing responses must be included - see documentation web page)");
            }
            ++i;
        }
    }

    protected void trimScores(String[][] scores) {
        int n = scores.length;
        int m = scores[0].length;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                scores[i][j].trim();
                ++j;
            }
            ++i;
        }
    }

    protected void preprocessData() {
        if (!this.dataPreprocessed) {
            if (!this.dataEntered) {
                throw new IllegalArgumentException("No data has been entered");
            }
            this.scores0 = new double[this.nItems][this.nPersons];
            this.originalScores0 = new double[this.nItems][this.nPersons];
            this.scores1 = new double[this.nPersons][this.nItems];
            this.originalScores1 = new double[this.nPersons][this.nItems];
            this.deletedPersons = new boolean[this.nPersons];
            this.deletedItems = new boolean[this.nItems];
            this.personIndices = new int[this.nPersons];
            int i = 0;
            while (i < this.nPersons) {
                this.personIndices[i] = i;
                ++i;
            }
            this.itemIndices = new int[this.nItems];
            i = 0;
            while (i < this.nItems) {
                this.itemIndices[i] = i;
                ++i;
            }
            this.nNaN = 0;
            this.nDeletedPersons = 0;
            this.nDeletedItems = 0;
            if (this.itemNamesSet) {
                if (this.nItems + 1 != this.itemNames.length) {
                    throw new IllegalArgumentException("The number of item names, " + this.itemNames.length + ", does not equal the number of items, " + this.nItems);
                }
            } else {
                this.itemNames = new String[this.nItems + 1];
                i = 0;
                while (i < this.nItems) {
                    this.itemNames[i] = "item" + i;
                    ++i;
                }
                this.itemNames[this.nItems] = "total";
            }
            String[][] holdingArrayS = null;
            double[][] holdingArrayD = null;
            boolean[][] holdingArrayB = null;
            int m = 0;
            int n = 0;
            switch (this.originalDataType) {
                case 1: {
                    holdingArrayS = (String[][])this.originalData;
                    this.checkLengths(holdingArrayS);
                    if (this.originalDataOrder == 1) {
                        holdingArrayS = this.transpose1to0(holdingArrayS);
                    }
                    this.trimScores(holdingArrayS);
                    break;
                }
                case 2: {
                    holdingArrayD = (double[][])this.originalData;
                    this.checkLengths(holdingArrayD);
                    if (this.originalDataOrder == 1) {
                        holdingArrayD = this.transpose1to0(holdingArrayD);
                    }
                    holdingArrayS = this.dataToString(holdingArrayD);
                    break;
                }
                case 3: {
                    holdingArrayD = ((Matrix)this.originalData).getArrayCopy();
                    this.checkLengths(holdingArrayD);
                    if (this.originalDataOrder == 1) {
                        holdingArrayD = this.transpose1to0(holdingArrayD);
                    }
                    holdingArrayS = this.dataToString(holdingArrayD);
                    break;
                }
                case 4: {
                    float[][] holdingArrayF = (float[][])this.originalData;
                    this.checkLengths(holdingArrayF);
                    m = holdingArrayF.length;
                    n = holdingArrayF[0].length;
                    int i2 = 0;
                    while (i2 < m) {
                        int j = 0;
                        while (j < n) {
                            holdingArrayD[i2][j] = new Float(holdingArrayF[i2][j]).doubleValue();
                            ++j;
                        }
                        ++i2;
                    }
                    if (this.originalDataOrder == 1) {
                        holdingArrayD = this.transpose1to0(holdingArrayD);
                    }
                    holdingArrayS = this.dataToString(holdingArrayD);
                    break;
                }
                case 5: {
                    int[][] holdingArrayI = (int[][])this.originalData;
                    this.checkLengths(holdingArrayI);
                    m = holdingArrayI.length;
                    n = holdingArrayI[0].length;
                    int i3 = 0;
                    while (i3 < m) {
                        int j = 0;
                        while (j < n) {
                            holdingArrayD[i3][j] = new Integer(holdingArrayI[i3][j]).doubleValue();
                            ++j;
                        }
                        ++i3;
                    }
                    if (this.originalDataOrder == 1) {
                        holdingArrayD = this.transpose1to0(holdingArrayD);
                    }
                    holdingArrayS = this.dataToString(holdingArrayD);
                    break;
                }
                case 6: {
                    char[][] holdingArrayC = (char[][])this.originalData;
                    this.checkLengths(holdingArrayC);
                    m = holdingArrayC.length;
                    n = holdingArrayC[0].length;
                    holdingArrayS = new String[m][n];
                    int i4 = 0;
                    while (i4 < m) {
                        int j = 0;
                        while (j < n) {
                            holdingArrayS[i4][j] = Character.toString(holdingArrayC[i4][j]);
                            ++j;
                        }
                        ++i4;
                    }
                    if (this.originalDataOrder == 1) {
                        holdingArrayS = this.transpose1to0(holdingArrayS);
                    }
                    this.trimScores(holdingArrayS);
                    break;
                }
                case 7: {
                    holdingArrayB = (boolean[][])this.originalData;
                    this.checkLengths(holdingArrayB);
                    if (this.originalDataOrder == 1) {
                        holdingArrayB = this.transpose1to0(holdingArrayB);
                    }
                    holdingArrayS = this.dataToString(holdingArrayB);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Original data type, " + this.originalDataType + ", not recognised");
                }
            }
            if (this.letterToNumeralSet) {
                int i5 = 0;
                while (i5 < this.nItems) {
                    char elem2;
                    int nYN = 0;
                    int j = 0;
                    while (j < this.nPersons) {
                        elem2 = holdingArrayS[i5][j].charAt(0);
                        if ((elem2 == 'y' || elem2 == 'n' || elem2 == 'Y' || elem2 == 'N' || elem2 == ' ') && holdingArrayS[i5][j].length() == 1) {
                            ++nYN;
                        }
                        ++j;
                    }
                    if (nYN == this.nPersons) {
                        j = 0;
                        while (j < this.nPersons) {
                            elem2 = holdingArrayS[i5][j].charAt(0);
                            if ((elem2 == 'y' || elem2 == 'Y') && holdingArrayS[i5][j].length() == 1) {
                                holdingArrayS[i5][j] = "1";
                            } else if ((elem2 == 'n' || elem2 == 'N') && holdingArrayS[i5][j].length() == 1) {
                                holdingArrayS[i5][j] = "-1";
                            }
                            ++j;
                        }
                    }
                    ++i5;
                }
            }
            if (this.letterToNumeralSet) {
                int i6 = 0;
                while (i6 < this.nItems) {
                    int j = 0;
                    while (j < this.nPersons) {
                        char elem3 = holdingArrayS[i6][j].charAt(0);
                        if (elem3 > '@' && elem3 < '[' && holdingArrayS[i6][j].length() == 1) {
                            holdingArrayS[i6][j] = "" + (elem3 - 63);
                        } else if (elem3 > '`' && elem3 < '{' && holdingArrayS[i6][j].length() == 1) {
                            holdingArrayS[i6][j] = "" + (elem3 - 96);
                        }
                        ++j;
                    }
                    ++i6;
                }
                this.letterToNumeralSet = false;
            }
            switch (this.originalDataType) {
                case 1: 
                case 6: {
                    int i7 = 0;
                    while (i7 < this.nItems) {
                        int j = 0;
                        while (j < this.nPersons) {
                            boolean elementSet = false;
                            if (this.otherDichotomousDataSet) {
                                if (holdingArrayS[i7][j].equalsIgnoreCase(this.otherTrue)) {
                                    this.scores0[i7][j] = 1.0;
                                    elementSet = true;
                                } else if (holdingArrayS[i7][j].equalsIgnoreCase(this.otherFalse)) {
                                    this.scores0[i7][j] = -1.0;
                                    elementSet = true;
                                } else {
                                    this.scores0[i7][j] = Double.NaN;
                                    elementSet = true;
                                }
                            }
                            if (!elementSet) {
                                if (holdingArrayS[i7][j].equalsIgnoreCase("yes") || holdingArrayS[i7][j].equalsIgnoreCase("y") || holdingArrayS[i7][j].equalsIgnoreCase("true")) {
                                    this.scores0[i7][j] = 1.0;
                                    elementSet = true;
                                } else if (holdingArrayS[i7][j].equalsIgnoreCase("no") || holdingArrayS[i7][j].equalsIgnoreCase("n") || holdingArrayS[i7][j].equalsIgnoreCase("false")) {
                                    this.scores0[i7][j] = -1.0;
                                    elementSet = true;
                                }
                            }
                            if (!elementSet) {
                                try {
                                    this.scores0[i7][j] = Double.valueOf(holdingArrayS[i7][j]);
                                }
                                catch (Exception e) {
                                    this.scores0[i7][j] = Double.NaN;
                                    ++this.nNaN;
                                }
                            }
                            ++j;
                        }
                        ++i7;
                    }
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    int i8 = 0;
                    while (i8 < this.nItems) {
                        int j = 0;
                        while (j < this.nPersons) {
                            try {
                                this.scores0[i8][j] = holdingArrayD[i8][j];
                            }
                            catch (Exception e) {
                                this.scores0[i8][j] = Double.NaN;
                                ++this.nNaN;
                            }
                            ++j;
                        }
                        ++i8;
                    }
                    break;
                }
                case 7: {
                    int i9 = 0;
                    while (i9 < this.nItems) {
                        int j = 0;
                        while (j < this.nPersons) {
                            this.scores0[i9][j] = holdingArrayB[i9][j] ? 1.0 : 0.0;
                            ++j;
                        }
                        ++i9;
                    }
                    break;
                }
            }
            int maxPrec = 0;
            int prec0 = 0;
            int i10 = 0;
            while (i10 < this.nItems) {
                int j = 0;
                while (j < this.nPersons) {
                    prec0 = Fmath.checkPrecision(this.scores0[i10][j]);
                    if (prec0 > maxPrec) {
                        maxPrec = prec0;
                    }
                    ++j;
                }
                ++i10;
            }
            if (maxPrec > this.trunc && !this.truncAll) {
                this.trunc = maxPrec;
            }
            this.originalScores0 = Conv.copy(this.scores0);
            this.originalScores1 = this.transpose0to1(this.scores0);
            this.originalNitems = this.nItems;
            this.originalNpersons = this.nPersons;
            this.originalNscores = this.originalNitems * this.originalNpersons;
            if (this.nNaN > 0) {
                this.noResponseHandling();
                this.scores1 = this.transpose0to1(this.scores0);
            }
            this.scores1 = new double[this.nPersons][this.nItems];
            i10 = 0;
            while (i10 < this.nItems) {
                int j = 0;
                while (j < this.nPersons) {
                    this.scores1[j][i10] = this.scores0[i10][j];
                    ++j;
                }
                ++i10;
            }
            this.checkWhetherRawItemsDichotomous();
            this.standardizedScores0 = new double[this.nItems][this.nPersons];
            this.standardizedScores1 = new double[this.nPersons][this.nItems];
            i10 = 0;
            while (i10 < this.nItems) {
                Stat st = new Stat(this.scores0[i10]);
                this.standardizedScores0[i10] = st.standardize();
                ++i10;
            }
            this.standardizedScores1 = this.transpose0to1(this.standardizedScores0);
            this.checkForIdenticalElements();
            this.meansAndVariances();
            this.covariancesAndCorrelationCoefficients();
            this.dataPreprocessed = true;
        }
    }

    private void checkForIdenticalElements() {
        int j;
        double check2;
        int sum2;
        boolean test2 = false;
        int i = 0;
        while (i < this.nItems) {
            sum2 = 0;
            check2 = this.scores0[i][0];
            j = 0;
            while (j < this.nPersons) {
                if (this.scores0[i][j] == check2) {
                    ++sum2;
                }
                ++j;
            }
            if (sum2 == this.nPersons) {
                this.sameCheck = 1;
                test2 = true;
            }
            ++i;
        }
        i = 0;
        while (i < this.nPersons) {
            sum2 = 0;
            check2 = this.scores0[0][i];
            j = 0;
            while (j < this.nItems) {
                if (this.scores0[j][i] == check2) {
                    ++sum2;
                }
                ++j;
            }
            if (sum2 == this.nItems) {
                this.sameCheck = 2;
                if (test2) {
                    this.sameCheck = 3;
                }
            }
            ++i;
        }
    }

    private String[][] dataToString(double[][] ddata) {
        int nn = ddata.length;
        int mm = ddata[0].length;
        String[][] sdata = new String[nn][mm];
        int i = 0;
        while (i < nn) {
            int j = 0;
            while (j < mm) {
                sdata[i][j] = new Double(ddata[i][j]).toString();
                ++j;
            }
            ++i;
        }
        return sdata;
    }

    private String[][] dataToString(boolean[][] ddata) {
        int nn = ddata.length;
        int mm = ddata[0].length;
        String[][] sdata = new String[nn][mm];
        int i = 0;
        while (i < nn) {
            int j = 0;
            while (j < mm) {
                sdata[i][j] = new Boolean(ddata[i][j]).toString();
                ++j;
            }
            ++i;
        }
        return sdata;
    }

    public Object originalResponses() {
        return this.originalScores();
    }

    public Object originalScores() {
        if (!this.dataEntered) {
            throw new IllegalArgumentException("No data has been entered");
        }
        return this.originalData;
    }

    public double[][] originalResponsesAsRowPerPerson() {
        return this.originalScoresAsRowPerPerson();
    }

    public double[][] originalScoresAsRowPerPerson() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.originalScores1;
    }

    public double[][] originalResponsesAsRowPerItem() {
        return this.originalScoresAsRowPerItem();
    }

    public double[][] originalScoresAsRowPerItem() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.originalScores0;
    }

    public double[][] usedresponsesAsRowPerPerson() {
        return this.usedScoresAsRowPerPerson();
    }

    public double[][] usedScoresAsRowPerPerson() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.scores1;
    }

    public double[][] usedScoresAsRowPerItem() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.scores0;
    }

    public double[][] standardizedScoresAsRowPerPerson() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.standardizedScores1;
    }

    public double[][] standardisedScoresAsRowPerPerson() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.standardizedScores1;
    }

    public double[][] standardizedScoresAsRowPerItem() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.standardizedScores0;
    }

    public double[][] standardisedScoresAsRowPerItem() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.standardizedScores0;
    }

    public int originalNumberOfItems() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.originalNitems;
    }

    public int originalNumberOfPersons() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.originalNpersons;
    }

    public int usedNumberOfItems() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.nItems;
    }

    public int usedNumberOfPersons() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.nPersons;
    }

    public int originalTotalNumberOfScores() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.originalNscores;
    }

    public int usedTotalNumberOfScores() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.nScores;
    }

    public int numberOfDeletedScores() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.originalNscores - this.nScores;
    }

    public int numberOfReplacedScores() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.nReplacements;
    }

    public String[] indicesOfReplacedScores() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        return this.replacementIndices;
    }

    public String[] itemNames() {
        if (!this.dataEntered) {
            throw new IllegalArgumentException("no data has been entered");
        }
        String[] ret = new String[this.nItems];
        int i = 0;
        while (i < this.nItems) {
            ret[i] = this.itemNames[i];
            ++i;
        }
        return ret;
    }

    public String[] originalItemNames() {
        if (!this.dataEntered) {
            throw new IllegalArgumentException("no data has been entered");
        }
        String[] ret = new String[this.originalNitems];
        int i = 0;
        while (i < this.originalNitems) {
            ret[i] = this.originalItemNames[i];
            ++i;
        }
        return ret;
    }

    public int itemIndex(String itemName) {
        if (!this.dataEntered) {
            throw new IllegalArgumentException("no data has been entered");
        }
        int index2 = -1;
        int jj = 0;
        boolean test2 = true;
        while (test2) {
            if (itemName.trim().equalsIgnoreCase(this.itemNames[jj].trim())) {
                index2 = jj;
                test2 = false;
                continue;
            }
            if (++jj <= this.nItems) continue;
            throw new IllegalArgumentException("Item name, " + itemName + ", is not present in the list of entered item names");
        }
        return index2 + 1;
    }

    public String itemName(int index2) {
        if (!this.dataEntered) {
            throw new IllegalArgumentException("no data has been entered");
        }
        return this.itemNames[index2 - 1];
    }

    protected void meansAndVariances() {
        ArrayMaths ams0;
        this.rawItemMeans = new double[this.nItems];
        this.rawItemMedians = new double[this.nItems];
        this.rawItemStandardDeviations = new double[this.nItems];
        this.rawItemVariances = new double[this.nItems];
        this.rawItemMinima = new double[this.nItems];
        this.rawItemMaxima = new double[this.nItems];
        this.rawItemRanges = new double[this.nItems];
        this.rawItemTotals = new double[this.nItems];
        this.rawItemMomentSkewness = new double[this.nItems];
        this.rawItemMedianSkewness = new double[this.nItems];
        this.rawItemQuartileSkewness = new double[this.nItems];
        this.rawItemKurtosisExcess = new double[this.nItems];
        int i = 0;
        while (i < this.nItems) {
            Stat am0 = new Stat(this.scores0[i]);
            if (this.nFactorOption) {
                am0.setDenominatorToN();
            } else {
                am0.setDenominatorToNminusOne();
            }
            this.rawItemMeans[i] = am0.mean_as_double();
            this.rawItemVariances[i] = am0.variance_as_double();
            this.rawItemStandardDeviations[i] = Math.sqrt(this.rawItemVariances[i]);
            this.rawItemMinima[i] = am0.minimum_as_double();
            this.rawItemMaxima[i] = am0.maximum_as_double();
            this.rawItemRanges[i] = this.rawItemMaxima[i] - this.rawItemMinima[i];
            this.rawItemTotals[i] = am0.sum_as_double();
            ams0 = am0.sort();
            Stat ss = new Stat(ams0.array());
            this.rawItemMedians[i] = ss.median_as_double();
            this.rawItemMomentSkewness[i] = am0.momentSkewness_as_double();
            this.rawItemMedianSkewness[i] = am0.medianSkewness_as_double();
            this.rawItemQuartileSkewness[i] = am0.quartileSkewness_as_double();
            this.rawItemKurtosisExcess[i] = am0.kurtosisExcess_as_double();
            ++i;
        }
        Stat st = new Stat(this.rawItemMeans);
        if (this.nFactorOption) {
            st.setDenominatorToN();
        } else {
            st.setDenominatorToNminusOne();
        }
        this.rawItemMeansMean = st.mean_as_double();
        this.rawItemMeansVar = st.variance_as_double();
        this.rawItemMeansSd = Math.sqrt(this.rawItemMeansVar);
        this.rawItemMeansMin = st.minimum_as_double();
        this.rawItemMeansMax = st.maximum_as_double();
        this.rawItemMeansRange = this.rawItemMeansMax - this.rawItemMeansMin;
        st = new Stat(this.rawItemStandardDeviations);
        if (this.nFactorOption) {
            st.setDenominatorToN();
        } else {
            st.setDenominatorToNminusOne();
        }
        this.rawItemStandardDeviationsMean = st.mean_as_double();
        this.rawItemStandardDeviationsVar = st.variance_as_double();
        this.rawItemStandardDeviationsSd = Math.sqrt(this.rawItemStandardDeviationsVar);
        this.rawItemStandardDeviationsMin = st.minimum_as_double();
        this.rawItemStandardDeviationsMax = st.maximum_as_double();
        this.rawItemStandardDeviationsRange = this.rawItemStandardDeviationsMax - this.rawItemStandardDeviationsMin;
        st = new Stat(this.rawItemVariances);
        if (this.nFactorOption) {
            st.setDenominatorToN();
        } else {
            st.setDenominatorToNminusOne();
        }
        this.rawItemVariancesMean = st.mean_as_double();
        this.rawItemVariancesVar = st.variance_as_double();
        this.rawItemVariancesSd = Math.sqrt(this.rawItemVariancesVar);
        this.rawItemVariancesMin = st.minimum_as_double();
        this.rawItemVariancesMax = st.maximum_as_double();
        this.rawItemVariancesRange = this.rawItemVariancesMax - this.rawItemVariancesMin;
        st = new Stat(this.rawItemMinima);
        if (this.nFactorOption) {
            st.setDenominatorToN();
        } else {
            st.setDenominatorToNminusOne();
        }
        this.rawItemMinimaMean = st.mean_as_double();
        this.rawItemMinimaVar = st.variance_as_double();
        this.rawItemMinimaSd = Math.sqrt(this.rawItemMinimaVar);
        this.rawItemMinimaMin = st.minimum_as_double();
        this.rawItemMinimaMax = st.maximum_as_double();
        this.rawItemMinimaRange = this.rawItemMinimaMax - this.rawItemMinimaMin;
        st = new Stat(this.rawItemMaxima);
        if (this.nFactorOption) {
            st.setDenominatorToN();
        } else {
            st.setDenominatorToNminusOne();
        }
        this.rawItemMaximaMean = st.mean_as_double();
        this.rawItemMaximaVar = st.variance_as_double();
        this.rawItemMaximaSd = Math.sqrt(this.rawItemMaximaVar);
        this.rawItemMaximaMin = st.minimum_as_double();
        this.rawItemMaximaMax = st.maximum_as_double();
        this.rawItemMaximaRange = this.rawItemMaximaMax - this.rawItemMaximaMin;
        st = new Stat(this.rawItemRanges);
        if (this.nFactorOption) {
            st.setDenominatorToN();
        } else {
            st.setDenominatorToNminusOne();
        }
        this.rawItemRangesMean = st.mean_as_double();
        this.rawItemRangesVar = st.variance_as_double();
        this.rawItemRangesSd = Math.sqrt(this.rawItemRangesVar);
        this.rawItemRangesMin = st.minimum_as_double();
        this.rawItemRangesMax = st.maximum_as_double();
        this.rawItemRangesRange = this.rawItemRangesMax - this.rawItemRangesMin;
        st = new Stat(this.rawItemTotals);
        if (this.nFactorOption) {
            st.setDenominatorToN();
        } else {
            st.setDenominatorToNminusOne();
        }
        this.rawItemTotalsMean = st.mean_as_double();
        this.rawItemTotalsVar = st.variance_as_double();
        this.rawItemTotalsSd = Math.sqrt(this.rawItemTotalsVar);
        this.rawItemTotalsMin = st.minimum_as_double();
        this.rawItemTotalsMax = st.maximum_as_double();
        this.rawItemTotalsRange = this.rawItemTotalsMax - this.rawItemTotalsMin;
        st = new Stat(this.rawItemMedians);
        if (this.nFactorOption) {
            st.setDenominatorToN();
        } else {
            st.setDenominatorToNminusOne();
        }
        this.rawItemMediansMean = st.mean_as_double();
        this.rawItemMediansVar = st.variance_as_double();
        this.rawItemMediansSd = Math.sqrt(this.rawItemMediansVar);
        this.rawItemMediansMin = st.minimum_as_double();
        this.rawItemMediansMax = st.maximum_as_double();
        this.rawItemMediansRange = this.rawItemMediansMax - this.rawItemMediansMin;
        this.standardizedItemMeans = new double[this.nItems];
        this.standardizedItemMedians = new double[this.nItems];
        this.standardizedItemStandardDeviations = new double[this.nItems];
        this.standardizedItemVariances = new double[this.nItems];
        this.standardizedItemMinima = new double[this.nItems];
        this.standardizedItemMaxima = new double[this.nItems];
        this.standardizedItemRanges = new double[this.nItems];
        this.standardizedItemTotals = new double[this.nItems];
        this.standardizedItemMomentSkewness = new double[this.nItems];
        this.standardizedItemMedianSkewness = new double[this.nItems];
        this.standardizedItemQuartileSkewness = new double[this.nItems];
        this.standardizedItemKurtosisExcess = new double[this.nItems];
        int i2 = 0;
        while (i2 < this.nItems) {
            ams0 = new Stat(this.standardizedScores0[i2]);
            if (this.nFactorOption) {
                ((Stat)ams0).setDenominatorToN();
            } else {
                ((Stat)ams0).setDenominatorToNminusOne();
            }
            this.standardizedItemMeans[i2] = 0.0;
            this.standardizedItemVariances[i2] = 1.0;
            this.standardizedItemStandardDeviations[i2] = 1.0;
            this.standardizedItemMinima[i2] = ams0.minimum_as_double();
            this.standardizedItemMaxima[i2] = ams0.maximum_as_double();
            this.standardizedItemRanges[i2] = this.standardizedItemMaxima[i2] - this.standardizedItemMinima[i2];
            this.standardizedItemTotals[i2] = 0.0;
            ArrayMaths amss0 = ams0.sort();
            Stat ss = new Stat(amss0.array());
            this.standardizedItemMedians[i2] = ss.median_as_double();
            this.standardizedItemMomentSkewness[i2] = ((Stat)ams0).momentSkewness_as_double();
            this.standardizedItemMedianSkewness[i2] = ((Stat)ams0).medianSkewness_as_double();
            this.standardizedItemQuartileSkewness[i2] = ((Stat)ams0).quartileSkewness_as_double();
            this.standardizedItemKurtosisExcess[i2] = ((Stat)ams0).kurtosisExcess_as_double();
            ++i2;
        }
        st = new Stat(this.standardizedItemMeans);
        if (this.nFactorOption) {
            st.setDenominatorToN();
        } else {
            st.setDenominatorToNminusOne();
        }
        this.standardizedItemMeansMean = st.mean_as_double();
        this.standardizedItemMeansVar = st.variance_as_double();
        this.standardizedItemMeansSd = Math.sqrt(this.standardizedItemMeansVar);
        this.standardizedItemMeansMin = st.minimum_as_double();
        this.standardizedItemMeansMax = st.maximum_as_double();
        this.standardizedItemMeansRange = this.standardizedItemMeansMax - this.standardizedItemMeansMin;
        st = new Stat(this.standardizedItemStandardDeviations);
        if (this.nFactorOption) {
            st.setDenominatorToN();
        } else {
            st.setDenominatorToNminusOne();
        }
        this.standardizedItemStandardDeviationsMean = st.mean_as_double();
        this.standardizedItemStandardDeviationsVar = st.variance_as_double();
        this.standardizedItemStandardDeviationsSd = Math.sqrt(this.standardizedItemStandardDeviationsVar);
        this.standardizedItemStandardDeviationsMin = st.minimum_as_double();
        this.standardizedItemStandardDeviationsMax = st.maximum_as_double();
        this.standardizedItemStandardDeviationsRange = this.standardizedItemStandardDeviationsMax - this.standardizedItemStandardDeviationsMin;
        st = new Stat(this.standardizedItemVariances);
        if (this.nFactorOption) {
            st.setDenominatorToN();
        } else {
            st.setDenominatorToNminusOne();
        }
        this.standardizedItemVariancesMean = st.mean_as_double();
        this.standardizedItemVariancesVar = st.variance_as_double();
        this.standardizedItemVariancesSd = Math.sqrt(this.standardizedItemVariancesVar);
        this.standardizedItemVariancesMin = st.minimum_as_double();
        this.standardizedItemVariancesMax = st.maximum_as_double();
        this.standardizedItemVariancesRange = this.standardizedItemVariancesMax - this.standardizedItemVariancesMin;
        st = new Stat(this.standardizedItemMinima);
        if (this.nFactorOption) {
            st.setDenominatorToN();
        } else {
            st.setDenominatorToNminusOne();
        }
        this.standardizedItemMinimaMean = st.mean_as_double();
        this.standardizedItemMinimaVar = st.variance_as_double();
        this.standardizedItemMinimaSd = Math.sqrt(this.standardizedItemMinimaVar);
        this.standardizedItemMinimaMin = st.minimum_as_double();
        this.standardizedItemMinimaMax = st.maximum_as_double();
        this.standardizedItemMinimaRange = this.standardizedItemMinimaMax - this.standardizedItemMinimaMin;
        st = new Stat(this.standardizedItemMaxima);
        if (this.nFactorOption) {
            st.setDenominatorToN();
        } else {
            st.setDenominatorToNminusOne();
        }
        this.standardizedItemMaximaMean = st.mean_as_double();
        this.standardizedItemMaximaVar = st.variance_as_double();
        this.standardizedItemMaximaSd = Math.sqrt(this.standardizedItemMaximaVar);
        this.standardizedItemMaximaMin = st.minimum_as_double();
        this.standardizedItemMaximaMax = st.maximum_as_double();
        this.standardizedItemMaximaRange = this.standardizedItemMaximaMax - this.standardizedItemMaximaMin;
        st = new Stat(this.standardizedItemRanges);
        if (this.nFactorOption) {
            st.setDenominatorToN();
        } else {
            st.setDenominatorToNminusOne();
        }
        this.standardizedItemRangesMean = st.mean_as_double();
        this.standardizedItemRangesVar = st.variance_as_double();
        this.standardizedItemRangesSd = Math.sqrt(this.standardizedItemRangesVar);
        this.standardizedItemRangesMin = st.minimum_as_double();
        this.standardizedItemRangesMax = st.maximum_as_double();
        this.standardizedItemRangesRange = this.standardizedItemRangesMax - this.standardizedItemRangesMin;
        this.standardizedItemTotalsMean = 0.0;
        this.standardizedItemTotalsVar = 0.0;
        this.standardizedItemTotalsSd = 0.0;
        this.standardizedItemTotalsMin = 0.0;
        this.standardizedItemTotalsMax = 0.0;
        this.standardizedItemTotalsRange = 0.0;
        st = new Stat(this.standardizedItemMedians);
        if (this.nFactorOption) {
            st.setDenominatorToN();
        } else {
            st.setDenominatorToNminusOne();
        }
        this.standardizedItemMediansMean = st.mean_as_double();
        this.standardizedItemMediansVar = st.variance_as_double();
        this.standardizedItemMediansSd = Math.sqrt(this.standardizedItemMediansVar);
        this.standardizedItemMediansMin = st.minimum_as_double();
        this.standardizedItemMediansMax = st.maximum_as_double();
        this.standardizedItemMediansRange = this.standardizedItemMediansMax - this.standardizedItemMediansMin;
        this.rawPersonMeans = new double[this.nPersons];
        this.rawPersonStandardDeviations = new double[this.nPersons];
        this.rawPersonVariances = new double[this.nPersons];
        this.rawPersonMinima = new double[this.nPersons];
        this.rawPersonMaxima = new double[this.nPersons];
        this.rawPersonRanges = new double[this.nPersons];
        this.rawPersonTotals = new double[this.nPersons];
        Stat[] am1 = new Stat[this.nPersons];
        int i3 = 0;
        while (i3 < this.nPersons) {
            am1[i3] = new Stat(this.scores1[i3]);
            if (this.nFactorOption) {
                am1[i3].setDenominatorToN();
            } else {
                am1[i3].setDenominatorToNminusOne();
            }
            this.rawPersonMeans[i3] = am1[i3].mean_as_double();
            this.rawPersonVariances[i3] = am1[i3].variance_as_double();
            this.rawPersonStandardDeviations[i3] = Math.sqrt(this.rawPersonVariances[i3]);
            this.rawPersonMinima[i3] = am1[i3].minimum_as_double();
            this.rawPersonMaxima[i3] = am1[i3].maximum_as_double();
            this.rawPersonRanges[i3] = this.rawPersonMaxima[i3] - this.rawPersonMinima[i3];
            this.rawPersonTotals[i3] = am1[i3].sum_as_double();
            ++i3;
        }
        this.standardizedPersonMeans = new double[this.nPersons];
        this.standardizedPersonStandardDeviations = new double[this.nPersons];
        this.standardizedPersonVariances = new double[this.nPersons];
        this.standardizedPersonMinima = new double[this.nPersons];
        this.standardizedPersonMaxima = new double[this.nPersons];
        this.standardizedPersonRanges = new double[this.nPersons];
        this.standardizedPersonTotals = new double[this.nPersons];
        Stat[] ams1 = new Stat[this.nPersons];
        int i4 = 0;
        while (i4 < this.nPersons) {
            ams1[i4] = new Stat(this.standardizedScores1[i4]);
            if (this.nFactorOption) {
                ams1[i4].setDenominatorToN();
            } else {
                ams1[i4].setDenominatorToNminusOne();
            }
            this.standardizedPersonMeans[i4] = ams1[i4].mean_as_double();
            this.standardizedPersonVariances[i4] = ams1[i4].variance_as_double();
            this.standardizedPersonStandardDeviations[i4] = Math.sqrt(this.standardizedPersonVariances[i4]);
            this.standardizedPersonMinima[i4] = ams1[i4].minimum_as_double();
            this.standardizedPersonMaxima[i4] = ams1[i4].maximum_as_double();
            this.standardizedPersonRanges[i4] = this.standardizedPersonMaxima[i4] - this.standardizedPersonMinima[i4];
            this.standardizedPersonTotals[i4] = ams1[i4].sum_as_double();
            ++i4;
        }
        ArrayMaths am = new ArrayMaths(this.scores0[0]);
        int i5 = 1;
        while (i5 < this.nItems) {
            am = am.concatenate(this.scores0[i5]);
            ++i5;
        }
        Stat ams = new Stat(am.array());
        if (this.nFactorOption) {
            ams.setDenominatorToN();
        } else {
            ams.setDenominatorToNminusOne();
        }
        this.rawAllResponsesMean = ams.mean_as_double();
        this.rawAllResponsesVariance = ams.variance_as_double();
        this.rawAllResponsesStandardDeviation = Math.sqrt(this.rawAllResponsesVariance);
        this.rawAllResponsesMinimum = ams.minimum_as_double();
        this.rawAllResponsesMaximum = ams.maximum_as_double();
        this.rawAllResponsesRange = this.rawAllResponsesMaximum - this.rawAllResponsesMinimum;
        this.rawAllResponsesTotal = ams.sum_as_double();
        ArrayMaths amm = new ArrayMaths(this.standardizedScores0[0]);
        int i6 = 1;
        while (i6 < this.nItems) {
            amm = amm.concatenate(this.standardizedScores0[i6]);
            ++i6;
        }
        Stat amss = new Stat(amm.array());
        if (this.nFactorOption) {
            amss.setDenominatorToN();
        } else {
            amss.setDenominatorToNminusOne();
        }
        this.standardizedAllResponsesMean = amss.mean_as_double();
        this.standardizedAllResponsesVariance = amss.variance_as_double();
        this.standardizedAllResponsesStandardDeviation = Math.sqrt(this.standardizedAllResponsesVariance);
        this.standardizedAllResponsesMinimum = amss.minimum_as_double();
        this.standardizedAllResponsesMaximum = amss.maximum_as_double();
        this.standardizedAllResponsesRange = this.standardizedAllResponsesMaximum - this.standardizedAllResponsesMinimum;
        this.standardizedAllResponsesTotal = 0.0;
        this.variancesCalculated = true;
    }

    public double[] rawItemMeans() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemMeans;
    }

    public double[] standardizedItemMeans() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemMeans;
    }

    public double[] standardisedItemMeans() {
        return this.standardizedItemMeans();
    }

    public double rawItemMean(String itemName) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        int index2 = this.itemIndex(itemName);
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemMeans[index2 - 1];
    }

    public double rawItemMean(int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index2 < 1 || index2 > this.nItems) {
            throw new IllegalArgumentException("The item index, " + index2 + ", must lie between 1 and the number of items," + this.nItems + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemMeans[index2 - 1];
    }

    public double rawMeanOfItemMeans() {
        return this.rawItemMeansMean;
    }

    public double rawStandardDeviationOfItemMeans() {
        return this.rawItemMeansSd;
    }

    public double rawVarianceOfItemMeans() {
        return this.rawItemMeansVar;
    }

    public double rawMaximumOfItemMeans() {
        return this.rawItemMeansMax;
    }

    public double rawMinimumOfItemMeans() {
        return this.rawItemMeansMin;
    }

    public double rawRangeOfItemMeans() {
        return this.rawItemMeansRange;
    }

    public double standardizedItemMean(String itemName) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        int index2 = this.itemIndex(itemName);
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemMeans[index2 - 1];
    }

    public double standardisedItemMean(String itemName) {
        return this.standardizedItemMean(itemName);
    }

    public double standardizedItemMean(int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index2 < 1 || index2 > this.nItems) {
            throw new IllegalArgumentException("The item index, " + index2 + ", must lie between 1 and the number of items," + this.nItems + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemMeans[index2 - 1];
    }

    public double standardisedItemMean(int index2) {
        return this.standardizedItemMean(index2);
    }

    public double standardizedMeanOfItemMeans() {
        return this.standardizedItemMeansMean;
    }

    public double standardisedMeanOfItemMeans() {
        return this.standardizedItemMeansMean;
    }

    public double standardizedStanadarDeviationOfItemMeans() {
        return this.standardizedItemMeansSd;
    }

    public double standardisedStanadarDeviationOfItemMeans() {
        return this.standardizedItemMeansSd;
    }

    public double standardizedVarianceOfItemMeans() {
        return this.standardizedItemMeansVar;
    }

    public double standardizedMaximumOfItemMeans() {
        return this.standardizedItemMeansMax;
    }

    public double standardisedVarianceOfItemMeans() {
        return this.standardizedItemMeansVar;
    }

    public double standardizedMinimumOfItemMeans() {
        return this.standardizedItemMeansMin;
    }

    public double standardisedMinimumOfItemMeans() {
        return this.standardizedItemMeansMin;
    }

    public double standardizedRangeOfItemMeans() {
        return this.standardizedItemMeansRange;
    }

    public double standardisedRangeOfItemMeans() {
        return this.standardizedItemMeansRange;
    }

    public double[] rawItemStandardDeviations() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemStandardDeviations;
    }

    public double rawItemStandardDeviation(String itemName) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        int index2 = this.itemIndex(itemName);
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemStandardDeviations[index2 - 1];
    }

    public double rawItemStandardDeviation(int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index2 < 1 || index2 > this.nItems) {
            throw new IllegalArgumentException("The item index, " + index2 + ", must lie between 1 and the number of items," + this.nItems + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemStandardDeviations[index2 - 1];
    }

    public double rawMeanOfItemStandardDeviations() {
        return this.rawItemStandardDeviationsMean;
    }

    public double rawStanadarDeviationOfItemStandardDeviations() {
        return this.rawItemStandardDeviationsSd;
    }

    public double rawVarianceOfItemStandardDeviations() {
        return this.rawItemStandardDeviationsVar;
    }

    public double rawMaximumOfItemStandardDeviations() {
        return this.rawItemStandardDeviationsMax;
    }

    public double rawMinimumOfItemStandardDeviations() {
        return this.rawItemStandardDeviationsMin;
    }

    public double rawRangeOfItemStandardDeviations() {
        return this.rawItemStandardDeviationsRange;
    }

    public double[] standardizedItemStandardDeviations() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemStandardDeviations;
    }

    public double[] standardisedItemStandardDeviations() {
        return this.standardizedItemStandardDeviations();
    }

    public double standardizedItemStandardDeviation(String itemName) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        int index2 = this.itemIndex(itemName);
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemStandardDeviations[index2 - 1];
    }

    public double standardisedItemStandardDeviation(String itemName) {
        return this.standardizedItemStandardDeviation(itemName);
    }

    public double standardizedItemStandardDeviation(int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index2 < 1 || index2 > this.nItems) {
            throw new IllegalArgumentException("The item index, " + index2 + ", must lie between 1 and the number of items," + this.nItems + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemStandardDeviations[index2 - 1];
    }

    public double standardisedItemStandardDeviation(int index2) {
        return this.standardizedItemStandardDeviation(index2);
    }

    public double standardizedMeanOfItemStandardDeviations() {
        return this.standardizedItemStandardDeviationsMean;
    }

    public double standardisedMeanOfItemStandardDeviations() {
        return this.standardizedItemStandardDeviationsMean;
    }

    public double standardizedStanadarDeviationOfItemStandardDeviations() {
        return this.standardizedItemStandardDeviationsSd;
    }

    public double standardisedStanadarDeviationOfItemStandardDeviations() {
        return this.standardizedItemStandardDeviationsSd;
    }

    public double standardizedVarianceOfItemStandardDeviations() {
        return this.standardizedItemStandardDeviationsVar;
    }

    public double standardisedVarianceOfItemStandardDeviations() {
        return this.standardizedItemStandardDeviationsVar;
    }

    public double standardizedMaximumOfItemStandardDeviations() {
        return this.standardizedItemStandardDeviationsMax;
    }

    public double standardisedMaximumOfItemStandardDeviations() {
        return this.standardizedItemStandardDeviationsMax;
    }

    public double standardizedMinimumOfItemStandardDeviations() {
        return this.standardizedItemStandardDeviationsMin;
    }

    public double standardisedMinimumOfItemStandardDeviations() {
        return this.standardizedItemStandardDeviationsMin;
    }

    public double standardizedRangeOfItemStandardDeviations() {
        return this.standardizedItemStandardDeviationsRange;
    }

    public double standardisedRangeOfItemStandardDeviations() {
        return this.standardizedItemStandardDeviationsRange;
    }

    public double[] rawItemVariances() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemVariances;
    }

    public double[] standardizedItemVariances() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemVariances;
    }

    public double[] standardisedItemVariances() {
        return this.standardizedItemVariances();
    }

    public double rawItemVariance(String itemName) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        int index2 = this.itemIndex(itemName);
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemVariances[index2 - 1];
    }

    public double rawItemVariance(int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index2 < 1 || index2 > this.nItems) {
            throw new IllegalArgumentException("The item index, " + index2 + ", must lie between 1 and the number of items," + this.nItems + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemVariances[index2 - 1];
    }

    public double standardizedItemVariance(String itemName) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        int index2 = this.itemIndex(itemName);
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemVariances[index2 - 1];
    }

    public double standardisedItemVariance(String itemName) {
        return this.standardizedItemVariance(itemName);
    }

    public double standardizedItemVariance(int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index2 < 1 || index2 > this.nItems) {
            throw new IllegalArgumentException("The item index, " + index2 + ", must lie between 1 and the number of items," + this.nItems + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemVariances[index2 - 1];
    }

    public double standardisedItemVariance(int index2) {
        return this.standardizedItemVariance(index2);
    }

    public double rawMeanOfItemVariances() {
        return this.rawItemVariancesMean;
    }

    public double rawStanadarDeviationOfItemVariances() {
        return this.rawItemVariancesSd;
    }

    public double rawVarianceOfItemVariances() {
        return this.rawItemVariancesVar;
    }

    public double rawMaximumOfItemVariances() {
        return this.rawItemVariancesMax;
    }

    public double rawMinimumOfItemVariances() {
        return this.rawItemVariancesMin;
    }

    public double rawRangeOfItemVariances() {
        return this.rawItemVariancesRange;
    }

    public double standardizedMeanOfItemVariances() {
        return this.standardizedItemVariancesMean;
    }

    public double standardisedMeanOfItemVariances() {
        return this.standardizedItemVariancesMean;
    }

    public double standardizedStanadarDeviationOfItemVariances() {
        return this.standardizedItemVariancesSd;
    }

    public double standardisedStanadarDeviationOfItemVariances() {
        return this.standardizedItemVariancesSd;
    }

    public double standardizedVarianceOfItemVariances() {
        return this.standardizedItemVariancesVar;
    }

    public double standardisedVarianceOfItemVariances() {
        return this.standardizedItemVariancesVar;
    }

    public double standardizedMaximumOfItemVariances() {
        return this.standardizedItemVariancesMax;
    }

    public double standardisedMaximumOfItemVariances() {
        return this.standardizedItemVariancesMax;
    }

    public double standardizedMinimumOfItemVariances() {
        return this.standardizedItemVariancesMin;
    }

    public double standardisedMinimumOfItemVariances() {
        return this.standardizedItemVariancesMin;
    }

    public double standardizedRangeOfItemVariances() {
        return this.standardizedItemVariancesRange;
    }

    public double standardisedRangeOfItemVariances() {
        return this.standardizedItemVariancesRange;
    }

    public double[] rawItemMinima() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemMinima;
    }

    public double[] standardizedItemMinima() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemMinima;
    }

    public double[] standardisedItemMinima() {
        return this.standardizedItemMinima();
    }

    public double rawItemMinimum(int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index2 < 1 || index2 > this.nItems) {
            throw new IllegalArgumentException("The item index, " + index2 + ", must lie between 1 and the number of items," + this.nItems + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemMinima[index2 - 1];
    }

    public double standardizedItemMinimum(int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index2 < 1 || index2 > this.nItems) {
            throw new IllegalArgumentException("The item index, " + index2 + ", must lie between 1 and the number of items," + this.nItems + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemMinima[index2 - 1];
    }

    public double standardisedItemMinimum(int index2) {
        return this.standardizedItemMinimum(index2);
    }

    public double rawMeanOfItemMinima() {
        return this.rawItemMinimaMean;
    }

    public double rawStanadarDeviationOfItemMinima() {
        return this.rawItemMinimaSd;
    }

    public double rawVarianceOfItemMinima() {
        return this.rawItemMinimaVar;
    }

    public double rawMaximumOfItemMinima() {
        return this.rawItemMinimaMax;
    }

    public double rawMinimumOfItemMinima() {
        return this.rawItemMinimaMin;
    }

    public double rawRangeOfItemMinima() {
        return this.rawItemMinimaRange;
    }

    public double standardizedMeanOfItemMinima() {
        return this.standardizedItemMinimaMean;
    }

    public double standardisedMeanOfItemMinima() {
        return this.standardizedItemMinimaMean;
    }

    public double standardizedStanadarDeviationOfItemMinima() {
        return this.standardizedItemMinimaSd;
    }

    public double standardisedStanadarDeviationOfItemMinima() {
        return this.standardizedItemMinimaSd;
    }

    public double standardizedVarianceOfItemMinima() {
        return this.standardizedItemMinimaVar;
    }

    public double standardisedVarianceOfItemMinima() {
        return this.standardizedItemMinimaVar;
    }

    public double standardizedMaximumOfItemMinima() {
        return this.standardizedItemMinimaMax;
    }

    public double standardisedMaximumOfItemMinima() {
        return this.standardizedItemMinimaMax;
    }

    public double standardizedMinimumOfItemMinima() {
        return this.standardizedItemMinimaMin;
    }

    public double standardisedMinimumOfItemMinima() {
        return this.standardizedItemMinimaMin;
    }

    public double standardizedRangeOfItemMinima() {
        return this.standardizedItemMinimaRange;
    }

    public double standardisedRangeOfItemMinima() {
        return this.standardizedItemMinimaRange;
    }

    public double[] rawItemMaxima() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemMaxima;
    }

    public double[] standardizedItemMaxima() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemMaxima;
    }

    public double[] standardisedItemMaxima() {
        return this.standardizedItemMaxima();
    }

    public double rawItemMaximum(int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index2 < 1 || index2 > this.nItems) {
            throw new IllegalArgumentException("The item index, " + index2 + ", must lie between 1 and the number of items," + this.nItems + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemMaxima[index2 - 1];
    }

    public double standardizedItemMaximum(int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index2 < 1 || index2 > this.nItems) {
            throw new IllegalArgumentException("The item index, " + index2 + ", must lie between 1 and the number of items," + this.nItems + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemMaxima[index2 - 1];
    }

    public double standardisedItemMaximum(int index2) {
        return this.standardizedItemMaximum(index2);
    }

    public double rawMeanOfItemMaxima() {
        return this.rawItemMaximaMean;
    }

    public double rawStanadarDeviationOfItemMaxima() {
        return this.rawItemMaximaSd;
    }

    public double rawVarianceOfItemMaxima() {
        return this.rawItemMaximaVar;
    }

    public double rawMaximumOfItemMaxima() {
        return this.rawItemMaximaMax;
    }

    public double rawMinimumOfItemMaxima() {
        return this.rawItemMaximaMin;
    }

    public double rawRangeOfItemMaxima() {
        return this.rawItemMaximaRange;
    }

    public double standardizedMeanOfItemMaxima() {
        return this.standardizedItemMaximaMean;
    }

    public double standardisedMeanOfItemMaxima() {
        return this.standardizedItemMaximaMean;
    }

    public double standardizedStanadarDeviationOfItemMaxima() {
        return this.standardizedItemMaximaSd;
    }

    public double standardisedStanadarDeviationOfItemMaxima() {
        return this.standardizedItemMaximaSd;
    }

    public double standardizedVarianceOfItemMaxima() {
        return this.standardizedItemMaximaVar;
    }

    public double standardisedVarianceOfItemMaxima() {
        return this.standardizedItemMaximaVar;
    }

    public double standardizedMaximumOfItemMaxima() {
        return this.standardizedItemMaximaMax;
    }

    public double standardisedMaximumOfItemMaxima() {
        return this.standardizedItemMaximaMax;
    }

    public double standardizedMinimumOfItemMaxima() {
        return this.standardizedItemMaximaMin;
    }

    public double standardisedMinimumOfItemMaxima() {
        return this.standardizedItemMaximaMin;
    }

    public double standardizedRangeOfItemMaxima() {
        return this.standardizedItemMaximaRange;
    }

    public double standardisedRangeOfItemMaxima() {
        return this.standardizedItemMaximaRange;
    }

    public double[] rawItemRanges() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemRanges;
    }

    public double[] standardizedItemRanges() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemRanges;
    }

    public double[] standardisedItemRanges() {
        return this.standardizedItemRanges();
    }

    public double rawItemRange(int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index2 < 1 || index2 > this.nItems) {
            throw new IllegalArgumentException("The item index, " + index2 + ", must lie between 1 and the number of items," + this.nItems + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemRanges[index2 - 1];
    }

    public double standardizedItemRange(int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index2 < 1 || index2 > this.nItems) {
            throw new IllegalArgumentException("The item index, " + index2 + ", must lie between 1 and the number of items," + this.nItems + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemRanges[index2 - 1];
    }

    public double standardisedItemRange(int index2) {
        return this.standardizedItemRange(index2);
    }

    public double rawMeanOfItemRanges() {
        return this.rawItemRangesMean;
    }

    public double rawStanadarDeviationOfItemRanges() {
        return this.rawItemRangesSd;
    }

    public double rawVarianceOfItemRanges() {
        return this.rawItemRangesVar;
    }

    public double rawMaximumOfItemRanges() {
        return this.rawItemRangesMax;
    }

    public double rawMinimumOfItemRanges() {
        return this.rawItemRangesMin;
    }

    public double rawRangeOfItemRanges() {
        return this.rawItemRangesRange;
    }

    public double standardizedMeanOfItemRanges() {
        return this.standardizedItemRangesMean;
    }

    public double standardisedMeanOfItemRanges() {
        return this.standardizedItemRangesMean;
    }

    public double standardizedStanadarDeviationOfItemRanges() {
        return this.standardizedItemRangesSd;
    }

    public double standardisedStanadarDeviationOfItemRanges() {
        return this.standardizedItemRangesSd;
    }

    public double standardizedVarianceOfItemRanges() {
        return this.standardizedItemRangesVar;
    }

    public double standardisedVarianceOfItemRanges() {
        return this.standardizedItemRangesVar;
    }

    public double standardizedMaximumOfItemRanges() {
        return this.standardizedItemRangesMax;
    }

    public double standardisedMaximumOfItemRanges() {
        return this.standardizedItemRangesMax;
    }

    public double standardizedMinimumOfItemRanges() {
        return this.standardizedItemRangesMin;
    }

    public double standardisedMinimumOfItemRanges() {
        return this.standardizedItemRangesMin;
    }

    public double standardizedRangeOfItemRanges() {
        return this.standardizedItemRangesRange;
    }

    public double standardisedRangeOfItemRanges() {
        return this.standardizedItemRangesRange;
    }

    public double[] rawItemTotals() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemTotals;
    }

    public double[] standardizedItemTotals() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemTotals;
    }

    public double[] standardisedItemTotals() {
        return this.standardizedItemTotals();
    }

    public double rawItemTotal(String itemName) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        int index2 = this.itemIndex(itemName);
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemTotals[index2 - 1];
    }

    public double rawItemTotal(int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index2 < 1 || index2 > this.nItems) {
            throw new IllegalArgumentException("The item index, " + index2 + ", must lie between 1 and the number of items," + this.nItems + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemTotals[index2 - 1];
    }

    public double standardizedItemTotal(String itemName) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        int index2 = this.itemIndex(itemName);
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemTotals[index2 - 1];
    }

    public double standardisedItemTotal(String itemName) {
        return this.standardizedItemTotal(itemName);
    }

    public double standardizedItemTotal(int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index2 < 1 || index2 > this.nItems) {
            throw new IllegalArgumentException("The item index, " + index2 + ", must lie between 1 and the number of items," + this.nItems + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemTotals[index2 - 1];
    }

    public double standardisedItemTotal(int index2) {
        return this.standardizedItemTotal(index2);
    }

    public double rawMeanOfItemTotals() {
        return this.rawItemTotalsMean;
    }

    public double rawStanadarDeviationOfItemTotals() {
        return this.rawItemTotalsSd;
    }

    public double rawVarianceOfItemTotals() {
        return this.rawItemTotalsVar;
    }

    public double rawMaximumOfItemTotals() {
        return this.rawItemTotalsMax;
    }

    public double rawMinimumOfItemTotals() {
        return this.rawItemTotalsMin;
    }

    public double rawRangeOfItemTotals() {
        return this.rawItemTotalsRange;
    }

    public double standardizedMeanOfItemTotals() {
        return this.standardizedItemTotalsMean;
    }

    public double standardisedMeanOfItemTotals() {
        return this.standardizedItemTotalsMean;
    }

    public double standardizedStanadarDeviationOfItemTotals() {
        return this.standardizedItemTotalsSd;
    }

    public double standardisedStanadarDeviationOfItemTotals() {
        return this.standardizedItemTotalsSd;
    }

    public double standardizedVarianceOfItemTotals() {
        return this.standardizedItemTotalsVar;
    }

    public double standardisedVarianceOfItemTotals() {
        return this.standardizedItemTotalsVar;
    }

    public double standardizedMaximumOfItemTotals() {
        return this.standardizedItemTotalsMax;
    }

    public double standardisedMaximumOfItemTotals() {
        return this.standardizedItemTotalsMax;
    }

    public double standardizedMinimumOfItemTotals() {
        return this.standardizedItemTotalsMin;
    }

    public double standardisedMinimumOfItemTotals() {
        return this.standardizedItemTotalsMin;
    }

    public double standardizedRangeOfItemTotals() {
        return this.standardizedItemTotalsRange;
    }

    public double standardisedRangeOfItemTotals() {
        return this.standardizedItemTotalsRange;
    }

    public double[] rawPersonMeans() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawPersonMeans;
    }

    public double[] standardizedPersonMeans() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedPersonMeans;
    }

    public double[] standardisedPersonMeans() {
        return this.standardizedPersonMeans();
    }

    public double rawPersonMean(int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index2 < 1 || index2 > this.nPersons) {
            throw new IllegalArgumentException("The person index, " + index2 + ", must lie between 1 and the number of persons," + this.nPersons + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawPersonMeans[index2 - 1];
    }

    public double standardizedPersonMean(int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index2 < 1 || index2 > this.nPersons) {
            throw new IllegalArgumentException("The person index, " + index2 + ", must lie between 1 and the number of persons," + this.nPersons + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedPersonMeans[index2 - 1];
    }

    public double standardisedPersonMean(int index2) {
        return this.standardizedPersonMean(index2);
    }

    public double[] rawPersonStandardDeviations() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawPersonStandardDeviations;
    }

    public double[] standardizedPersonStandardDeviations() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedPersonStandardDeviations;
    }

    public double[] standardisedPersonStandardDeviations() {
        return this.standardizedPersonStandardDeviations();
    }

    public double rawPersonStandardDeviation(int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index2 < 1 || index2 > this.nPersons) {
            throw new IllegalArgumentException("The person index, " + index2 + ", must lie between 1 and the number of persons," + this.nPersons + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawPersonStandardDeviations[index2 - 1];
    }

    public double standardizedPersonStandardDeviation(int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index2 < 1 || index2 > this.nPersons) {
            throw new IllegalArgumentException("The person index, " + index2 + ", must lie between 1 and the number of persons," + this.nPersons + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedPersonStandardDeviations[index2 - 1];
    }

    public double standardisedPersonStandardDeviation(int index2) {
        return this.standardizedPersonStandardDeviation(index2);
    }

    public double[] rawPersonVariances() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawPersonVariances;
    }

    public double[] standardizedPersonVariances() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedPersonVariances;
    }

    public double[] standardisedPersonVariances() {
        return this.standardizedPersonVariances();
    }

    public double rawPersonVariance(int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index2 < 1 || index2 > this.nPersons) {
            throw new IllegalArgumentException("The person index, " + index2 + ", must lie between 1 and the number of persons," + this.nPersons + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawPersonVariances[index2 - 1];
    }

    public double standardizedPersonVariance(int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index2 < 1 || index2 > this.nPersons) {
            throw new IllegalArgumentException("The person index, " + index2 + ", must lie between 1 and the number of persons," + this.nPersons + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedPersonVariances[index2 - 1];
    }

    public double standardisedPersonVariance(int index2) {
        return this.standardizedPersonVariance(index2);
    }

    public double[] rawPersonMinima() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawPersonMinima;
    }

    public double[] standardizedPersonMinima() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedPersonMinima;
    }

    public double[] standardisedPersonMinima() {
        return this.standardisedPersonMinima();
    }

    public double rawPersonMinimum(int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index2 < 1 || index2 > this.nItems) {
            throw new IllegalArgumentException("The person index, " + index2 + ", must lie between 1 and the number of persons," + this.nPersons + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawPersonMinima[index2 - 1];
    }

    public double standardizedPersonMinimum(int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index2 < 1 || index2 > this.nPersons) {
            throw new IllegalArgumentException("The person index, " + index2 + ", must lie between 1 and the number of persons," + this.nPersons + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedPersonMinima[index2 - 1];
    }

    public double standardisedPersonMinimum(int index2) {
        return this.standardizedPersonMinimum(index2);
    }

    public double[] rawPersonMaxima() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawPersonMaxima;
    }

    public double[] standardizedPersonMaxima() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedPersonMaxima;
    }

    public double[] standardisedPersonMaxima() {
        return this.standardizedPersonMaxima();
    }

    public double rawPersonMaximum(int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index2 < 1 || index2 > this.nItems) {
            throw new IllegalArgumentException("The person index, " + index2 + ", must lie between 1 and the number of persons," + this.nPersons + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawPersonMaxima[index2 - 1];
    }

    public double standardizedPersonMaximum(int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index2 < 1 || index2 > this.nPersons) {
            throw new IllegalArgumentException("The person index, " + index2 + ", must lie between 1 and the number of persons," + this.nPersons + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedPersonMaxima[index2 - 1];
    }

    public double standardisedPersonMaximum(int index2) {
        return this.standardizedPersonMaximum(index2);
    }

    public double[] rawPersonRanges() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawPersonRanges;
    }

    public double[] standardizedPersonRanges() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedPersonRanges;
    }

    public double[] standardisedPersonRanges() {
        return this.standardizedPersonRanges();
    }

    public double rawPersonRange(int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index2 < 1 || index2 > this.nItems) {
            throw new IllegalArgumentException("The person index, " + index2 + ", must lie between 1 and the number of persons," + this.nPersons + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawPersonRanges[index2 - 1];
    }

    public double standardizedPersonRange(int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index2 < 1 || index2 > this.nPersons) {
            throw new IllegalArgumentException("The person index, " + index2 + ", must lie between 1 and the number of persons," + this.nPersons + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedPersonRanges[index2 - 1];
    }

    public double standardisedPersonRange(int index2) {
        return this.standardizedPersonRange(index2);
    }

    public double[] rawItemMedians() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemMedians;
    }

    public double[] standardizedItemMedians() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemMedians;
    }

    public double[] standardisedItemMedians() {
        return this.standardizedItemMedians();
    }

    public double rawItemMedian(String itemName) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        int index2 = this.itemIndex(itemName);
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemMedians[index2 - 1];
    }

    public double rawItemMedian(int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index2 < 1 || index2 > this.nItems) {
            throw new IllegalArgumentException("The item index, " + index2 + ", must lie between 1 and the number of items," + this.nItems + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawItemMedians[index2 - 1];
    }

    public double standardizedItemMedian(String itemName) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        int index2 = this.itemIndex(itemName);
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemMedians[index2 - 1];
    }

    public double standardisedItemMedian(String itemName) {
        return this.standardizedItemMedian(itemName);
    }

    public double standardizedItemMedian(int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index2 < 1 || index2 > this.nItems) {
            throw new IllegalArgumentException("The item index, " + index2 + ", must lie between 1 and the number of items," + this.nItems + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedItemMedians[index2 - 1];
    }

    public double standardisedItemMedian(int index2) {
        return this.standardizedItemMedian(index2);
    }

    public double rawMeanOfItemMedians() {
        return this.rawItemMediansMean;
    }

    public double rawStanadarDeviationOfItemMedians() {
        return this.rawItemMediansSd;
    }

    public double rawVarianceOfItemMedians() {
        return this.rawItemMediansVar;
    }

    public double rawMaximumOfItemMedians() {
        return this.rawItemMediansMax;
    }

    public double rawMinimumOfItemMedians() {
        return this.rawItemMediansMin;
    }

    public double rawRangeOfItemMedians() {
        return this.rawItemMediansRange;
    }

    public double standardizedMeanOfItemMedians() {
        return this.standardizedItemMediansMean;
    }

    public double standardisedMeanOfItemMedians() {
        return this.standardizedItemMediansMean;
    }

    public double standardizedStanadarDeviationOfItemMedians() {
        return this.standardizedItemMediansSd;
    }

    public double standardisedStanadarDeviationOfItemMedians() {
        return this.standardizedItemMediansSd;
    }

    public double standardizedVarianceOfItemMedians() {
        return this.standardizedItemMediansVar;
    }

    public double standardisedVarianceOfItemMedians() {
        return this.standardizedItemMediansVar;
    }

    public double standardizedMaximumOfItemMedians() {
        return this.standardizedItemMediansMax;
    }

    public double standardisedMaximumOfItemMedians() {
        return this.standardizedItemMediansMax;
    }

    public double standardizedMinimumOfItemMedians() {
        return this.standardizedItemMediansMin;
    }

    public double standardisedMinimumOfItemMedians() {
        return this.standardizedItemMediansMin;
    }

    public double standardizedRangeOfItemMedians() {
        return this.standardizedItemMediansRange;
    }

    public double standardisedRangeOfItemMedians() {
        return this.standardizedItemMediansRange;
    }

    public double[] rawPersonTotals() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawPersonTotals;
    }

    public double[] standardizedPersonTotals() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedPersonTotals;
    }

    public double[] standardisedPersonTotals() {
        return this.standardizedPersonTotals();
    }

    public double rawPersonTotal(int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index2 < 1 || index2 > this.nItems) {
            throw new IllegalArgumentException("The person index, " + index2 + ", must lie between 1 and the number of persons," + this.nPersons + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawPersonTotals[index2 - 1];
    }

    public double standardizedPersonTotal(int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index2 < 1 || index2 > this.nPersons) {
            throw new IllegalArgumentException("The person index, " + index2 + ", must lie between 1 and the number of persons," + this.nPersons + ", inclusive");
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedPersonTotals[index2 - 1];
    }

    public double standardisedPersonTotal(int index2) {
        return this.standardizedPersonTotal(index2);
    }

    public double rawAllResponsesMean() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawAllResponsesMean;
    }

    public double standardizedAllResponsesMean() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedAllResponsesMean;
    }

    public double standardisedTotalMean() {
        return this.standardizedAllResponsesMean();
    }

    public double rawAllResponsesStandardDeviation() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawAllResponsesStandardDeviation;
    }

    public double standardizedAllResponsesStandardDeviation() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedAllResponsesStandardDeviation;
    }

    public double standardisedTotalStandardDeviation() {
        return this.standardizedAllResponsesStandardDeviation();
    }

    public double rawAllResponsesVariance() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawAllResponsesVariance;
    }

    public double standardizedAllResponsesVariance() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedAllResponsesVariance;
    }

    public double standardisedTotalVariance() {
        return this.standardizedAllResponsesVariance();
    }

    public double rawAllResponsesMinimum() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawAllResponsesMinimum;
    }

    public double standardizedAllResponsesMinimum() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedAllResponsesMinimum;
    }

    public double standardisedTotalMinimum() {
        return this.standardizedAllResponsesMinimum();
    }

    public double rawAllResponsesMaximum() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawAllResponsesMaximum;
    }

    public double standardizedAllResponsesMaximum() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedAllResponsesMaximum;
    }

    public double standardisedTotalMaximum() {
        return this.standardizedAllResponsesMaximum();
    }

    public double rawAllResponsesRange() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawAllResponsesRange;
    }

    public double standardizedAllResponsesRange() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedAllResponsesRange;
    }

    public double standardisedTotalRange() {
        return this.standardizedAllResponsesRange();
    }

    public double rawAllResponsesTotal() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.rawAllResponsesTotal;
    }

    public double standardizedAllResponsesTotal() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.variancesCalculated) {
            this.meansAndVariances();
        }
        return this.standardizedAllResponsesTotal;
    }

    public double standardisedTotalTotal() {
        return this.standardizedAllResponsesTotal();
    }

    protected void covariancesAndCorrelationCoefficients() {
        int j;
        int j2;
        this.rawCovariances = new double[this.nItems + 1][this.nItems + 1];
        int i = 0;
        while (i < this.nItems) {
            j2 = i;
            while (j2 < this.nItems) {
                this.rawCovariances[i][j2] = Stat.covariance(this.scores0[i], this.scores0[j2]);
                if (i != j2) {
                    this.rawCovariances[j2][i] = this.rawCovariances[i][j2];
                }
                ++j2;
            }
            ++i;
        }
        i = 0;
        while (i < this.nItems) {
            this.rawCovariances[i][this.nItems] = Stat.covariance(this.scores0[i], this.rawPersonTotals);
            this.rawCovariances[this.nItems][i] = this.rawCovariances[i][this.nItems];
            ++i;
        }
        this.rawCovariances[this.nItems][this.nItems] = Stat.covariance(this.rawPersonTotals, this.rawPersonTotals);
        this.standardizedCovariances = new double[this.nItems + 1][this.nItems + 1];
        i = 0;
        while (i < this.nItems) {
            j2 = i;
            while (j2 < this.nItems) {
                this.standardizedCovariances[i][j2] = Stat.covariance(this.scores0[i], this.scores0[j2]);
                if (i != j2) {
                    this.standardizedCovariances[j2][i] = this.standardizedCovariances[i][j2];
                }
                ++j2;
            }
            ++i;
        }
        i = 0;
        while (i < this.nItems) {
            this.standardizedCovariances[i][this.nItems] = Stat.covariance(this.scores0[i], this.standardizedPersonTotals);
            this.standardizedCovariances[this.nItems][i] = this.standardizedCovariances[i][this.nItems];
            ++i;
        }
        this.standardizedCovariances[this.nItems][this.nItems] = Stat.covariance(this.standardizedPersonTotals, this.standardizedPersonTotals);
        this.rawCorrelationCoefficients = new double[this.nItems + 1][this.nItems + 1];
        i = 0;
        while (i < this.nItems) {
            this.rawCorrelationCoefficients[i][i] = 1.0;
            j2 = i + 1;
            while (j2 < this.nItems) {
                this.rawCorrelationCoefficients[i][j2] = this.rawCovariances[i][j2] / Math.sqrt(this.rawCovariances[i][i] * this.rawCovariances[j2][j2]);
                if (Fmath.isNaN(this.rawCorrelationCoefficients[i][j2])) {
                    this.rawCorrelationCoefficients[i][j2] = 0.0;
                }
                this.rawCorrelationCoefficients[j2][i] = this.rawCorrelationCoefficients[i][j2];
                ++j2;
            }
            ++i;
        }
        i = 0;
        while (i < this.nItems) {
            this.rawCorrelationCoefficients[i][this.nItems] = this.rawCovariances[i][this.nItems] / Math.sqrt(this.rawCovariances[i][i] * this.rawCovariances[this.nItems][this.nItems]);
            if (Fmath.isNaN(this.rawCorrelationCoefficients[i][this.nItems])) {
                this.rawCorrelationCoefficients[i][this.nItems] = 0.0;
            }
            this.rawCorrelationCoefficients[this.nItems][i] = this.rawCorrelationCoefficients[i][this.nItems];
            ++i;
        }
        this.rawCorrelationCoefficients[this.nItems][this.nItems] = 1.0;
        double[] rhoArray = new double[this.nItems * (this.nItems - 1) / 2];
        int kk = 0;
        int i2 = 0;
        while (i2 < this.nItems) {
            int j3 = i2 + 1;
            while (j3 < this.nItems) {
                rhoArray[kk] = this.rawCorrelationCoefficients[i2][j3];
                ++kk;
                ++j3;
            }
            ++i2;
        }
        Stat st = new Stat(rhoArray);
        if (this.nFactorOption) {
            st.setDenominatorToN();
        } else {
            st.setDenominatorToNminusOne();
        }
        this.rawMeanRhoWithoutTotals = st.mean_as_double();
        this.rawStandardDeviationRhoWithoutTotals = st.standardDeviation_as_double();
        rhoArray = new double[this.nItems * (this.nItems + 1) / 2];
        kk = 0;
        int i3 = 0;
        while (i3 <= this.nItems) {
            j = i3 + 1;
            while (j <= this.nItems) {
                rhoArray[kk] = this.rawCorrelationCoefficients[i3][j];
                ++kk;
                ++j;
            }
            ++i3;
        }
        st = new Stat(rhoArray);
        if (this.nFactorOption) {
            st.setDenominatorToN();
        } else {
            st.setDenominatorToNminusOne();
        }
        this.rawMeanRhoWithTotals = st.mean_as_double();
        this.rawStandardDeviationRhoWithTotals = st.standardDeviation_as_double();
        this.standardizedCorrelationCoefficients = new double[this.nItems + 1][this.nItems + 1];
        i3 = 0;
        while (i3 < this.nItems) {
            this.standardizedCorrelationCoefficients[i3][i3] = 1.0;
            j = i3 + 1;
            while (j < this.nItems) {
                this.standardizedCorrelationCoefficients[i3][j] = this.standardizedCovariances[i3][j] / Math.sqrt(this.standardizedCovariances[i3][i3] * this.standardizedCovariances[j][j]);
                if (Fmath.isNaN(this.standardizedCorrelationCoefficients[i3][j])) {
                    this.standardizedCorrelationCoefficients[i3][j] = 0.0;
                }
                this.standardizedCorrelationCoefficients[j][i3] = this.standardizedCorrelationCoefficients[i3][j];
                ++j;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < this.nItems) {
            this.standardizedCorrelationCoefficients[i3][this.nItems] = this.standardizedCovariances[i3][this.nItems] / Math.sqrt(this.standardizedCovariances[i3][i3] * this.standardizedCovariances[this.nItems][this.nItems]);
            if (Fmath.isNaN(this.standardizedCorrelationCoefficients[i3][this.nItems])) {
                this.standardizedCorrelationCoefficients[i3][this.nItems] = 0.0;
            }
            this.standardizedCorrelationCoefficients[this.nItems][i3] = this.standardizedCorrelationCoefficients[i3][this.nItems];
            ++i3;
        }
        this.standardizedCorrelationCoefficients[this.nItems][this.nItems] = 1.0;
        rhoArray = new double[this.nItems * (this.nItems - 1) / 2];
        kk = 0;
        i3 = 0;
        while (i3 < this.nItems) {
            j = i3 + 1;
            while (j < this.nItems) {
                rhoArray[kk] = this.standardizedCorrelationCoefficients[i3][j];
                ++kk;
                ++j;
            }
            ++i3;
        }
        st = new Stat(rhoArray);
        if (this.nFactorOption) {
            st.setDenominatorToN();
        } else {
            st.setDenominatorToNminusOne();
        }
        this.standardizedMeanRhoWithoutTotals = st.mean_as_double();
        this.standardizedStandardDeviationRhoWithoutTotals = st.standardDeviation_as_double();
        rhoArray = new double[this.nItems * (this.nItems + 1) / 2];
        kk = 0;
        i3 = 0;
        while (i3 <= this.nItems) {
            j = i3 + 1;
            while (j <= this.nItems) {
                rhoArray[kk] = this.standardizedCorrelationCoefficients[i3][j];
                ++kk;
                ++j;
            }
            ++i3;
        }
        st = new Stat(rhoArray);
        if (this.nFactorOption) {
            st.setDenominatorToN();
        } else {
            st.setDenominatorToNminusOne();
        }
        this.standardizedMeanRhoWithTotals = st.mean_as_double();
        this.standardizedStandardDeviationRhoWithTotals = st.standardDeviation_as_double();
        this.covariancesCalculated = true;
    }

    public double[][] rawCovariances() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.rawCovariances;
    }

    public double[][] standardizedCovariances() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.standardizedCovariances;
    }

    public double[][] standardisedCovariances() {
        return this.standardizedCovariances();
    }

    public double rawCovariance(String itemName1, String itemName2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        int index1 = this.itemIndex(itemName1);
        int index2 = this.itemIndex(itemName2);
        return this.rawCovariances[index1 - 1][index2 - 1];
    }

    public double rawCovariance(int index1, int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index1 < 1 || index1 > this.nItems) {
            throw new IllegalArgumentException("The first item index, " + index1 + ", must lie between 1 and the number of items plus one (for totals)," + (this.nItems + 1) + ", inclusive");
        }
        if (index2 < 1 || index2 > this.nItems) {
            throw new IllegalArgumentException("The second item index, " + index2 + ", must lie between 1 and the number of items plus one (for totals)," + (this.nItems + 1) + ", inclusive");
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.rawCovariances[index1 - 1][index2 - 1];
    }

    public double rawCovariance(String itemName) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        int index2 = this.itemIndex(itemName);
        return this.rawCovariances[index2 - 1][this.nItems];
    }

    public double rawCovariance(int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index2 < 1 || index2 > this.nItems) {
            throw new IllegalArgumentException("The first item index, " + index2 + ", must lie between 1 and the number of items plus one (for totals)," + (this.nItems + 1) + ", inclusive");
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.rawCovariances[index2 - 1][this.nItems];
    }

    public double standardizedCovariance(String itemName1, String itemName2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        int index1 = this.itemIndex(itemName1);
        int index2 = this.itemIndex(itemName2);
        return this.standardizedCovariances[index1 + 1][index2 + 1];
    }

    public double standardisedCovariance(String itemName1, String itemName2) {
        return this.standardizedCovariance(itemName1, itemName2);
    }

    public double standardizedCovariance(int index1, int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index1 < 1 || index1 > this.nItems) {
            throw new IllegalArgumentException("The first item index, " + index1 + ", must lie between 1 and the number of items plus one (for totals)," + (this.nItems + 1) + ", inclusive");
        }
        if (index2 < 1 || index2 > this.nItems) {
            throw new IllegalArgumentException("The second item index, " + index2 + ", must lie between 1 and the number of items plus one (for totals)," + (this.nItems + 1) + ", inclusive");
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.standardizedCovariances[index1 + 1][index2 + 1];
    }

    public double standardisedCovariance(int index1, int index2) {
        return this.standardizedCovariance(index1, index2);
    }

    public double standardizedCovariance(String itemName) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        int index2 = this.itemIndex(itemName);
        return this.standardizedCovariances[index2 + 1][this.nItems];
    }

    public double standardisedCovariance(String itemName) {
        return this.standardizedCovariance(itemName);
    }

    public double standardizedCovariance(int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index2 < 1 || index2 > this.nItems) {
            throw new IllegalArgumentException("The first item index, " + index2 + ", must lie between 1 and the number of items plus one (for totals)," + (this.nItems + 1) + ", inclusive");
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.standardizedCovariances[index2 + 1][this.nItems];
    }

    public double standardisedCovariance(int index2) {
        return this.standardizedCovariance(index2);
    }

    public double rawAverageCorrelationCoefficients() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.rawMeanRhoWithoutTotals;
    }

    public double rawStandardDeviationCorrelationCoefficients() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.rawStandardDeviationRhoWithoutTotals;
    }

    public double standardizedAverageCorrelationCoefficients() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.standardizedMeanRhoWithoutTotals;
    }

    public double standardisedAverageCorrelationCoefficients() {
        return this.standardizedAverageCorrelationCoefficients();
    }

    public double standardizedStandardDeviationCorrelationCoefficients() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.standardizedStandardDeviationRhoWithoutTotals;
    }

    public double standardisedStandardDeviationCorrelationCoefficients() {
        return this.standardizedStandardDeviationCorrelationCoefficients();
    }

    public double rawAverageCorrelationCoefficientsWithTotals() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.rawMeanRhoWithTotals;
    }

    public double rawStandardDeviationCorrelationCoefficientsWithTotals() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.rawStandardDeviationRhoWithTotals;
    }

    public double standardizedAverageCorrelationCoefficientsWithTotals() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.standardizedMeanRhoWithTotals;
    }

    public double standardisedAverageCorrelationCoefficientsWithTotals() {
        return this.standardizedAverageCorrelationCoefficientsWithTotals();
    }

    public double standardizedStandardDeviationCorrelationCoefficientsWithTotals() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.standardizedStandardDeviationRhoWithTotals;
    }

    public double standardisedStandardDeviationCorrelationCoefficientsWithTotals() {
        return this.standardizedStandardDeviationCorrelationCoefficientsWithTotals();
    }

    public double[][] rawCorrelationCoefficients() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.rawCorrelationCoefficients;
    }

    public double[][] standardizedCorrelationCoefficients() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.standardizedCorrelationCoefficients;
    }

    public double[][] standardisedCorrelationCoefficients() {
        return this.standardizedCorrelationCoefficients();
    }

    public double rawCorrelationCoefficient(String itemName1, String itemName2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        int index1 = this.itemIndex(itemName1);
        int index2 = this.itemIndex(itemName2);
        return this.rawCorrelationCoefficients[index1 - 1][index2 - 1];
    }

    public double rawCorrelationCoefficient(int index1, int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index1 < 1 || index1 > this.nItems) {
            throw new IllegalArgumentException("The first item index, " + index1 + ", must lie between 1 and the number of items plus one (for totals)," + (this.nItems + 1) + ", inclusive");
        }
        if (index2 < 1 || index2 > this.nItems) {
            throw new IllegalArgumentException("The second item index, " + index2 + ", must lie between 1 and the number of items plus one (for totals)," + (this.nItems + 1) + ", inclusive");
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.rawCorrelationCoefficients[index1 - 1][index2 - 1];
    }

    public double rawCorrelationCoefficient(String itemName) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        int index2 = this.itemIndex(itemName);
        return this.rawCorrelationCoefficients[index2 - 1][this.nItems];
    }

    public double rawCorrelationCoefficient(int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index2 < 1 || index2 > this.nItems) {
            throw new IllegalArgumentException("The first item index, " + index2 + ", must lie between 1 and the number of items plus one (for totals)," + (this.nItems + 1) + ", inclusive");
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.rawCorrelationCoefficients[index2 - 1][this.nItems];
    }

    public double standardizedCorrelationCoefficient(String itemName1, String itemName2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        int index1 = this.itemIndex(itemName1);
        int index2 = this.itemIndex(itemName2);
        return this.standardizedCorrelationCoefficients[index1 + 1][index2 + 1];
    }

    public double standardisedCorrelationCoefficient(String itemName1, String itemName2) {
        return this.standardizedCorrelationCoefficient(itemName1, itemName2);
    }

    public double standardizedCorrelationCoefficient(int index1, int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index1 < 1 || index1 > this.nItems) {
            throw new IllegalArgumentException("The first item index, " + index1 + ", must lie between 1 and the number of items plus one (for totals)," + (this.nItems + 1) + ", inclusive");
        }
        if (index2 < 1 || index2 > this.nItems) {
            throw new IllegalArgumentException("The second item index, " + index2 + ", must lie between 1 and the number of items plus one (for totals)," + (this.nItems + 1) + ", inclusive");
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.standardizedCorrelationCoefficients[index1 + 1][index2 + 1];
    }

    public double standardisedCorrelationCoefficient(int index1, int index2) {
        return this.standardizedCorrelationCoefficient(index1, index2);
    }

    public double standardizedCorrelationCoefficient(String itemName) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        int index2 = this.itemIndex(itemName);
        return this.standardizedCorrelationCoefficients[index2 + 1][this.nItems];
    }

    public double standardisedCorrelationCoefficient(String itemName) {
        return this.standardizedCorrelationCoefficient(itemName);
    }

    public double standardizedCorrelationCoefficient(int index2) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        if (index2 < 1 || index2 > this.nItems) {
            throw new IllegalArgumentException("The first item index, " + index2 + ", must lie between 1 and the number of items plus one (for totals)," + (this.nItems + 1) + ", inclusive");
        }
        if (!this.covariancesCalculated) {
            this.covariancesAndCorrelationCoefficients();
        }
        return this.standardizedCorrelationCoefficients[index2 + 1][this.nItems];
    }

    public double standardisedCorrelationCoefficient(int index2) {
        return this.standardizedCorrelationCoefficient(index2);
    }

    protected double[] checkWhetherRawItemsDichotomous() {
        if (!this.dichotomousCheckDone) {
            this.dichotomous = new boolean[this.nItems];
            this.dichotomousPercentage = new double[this.nItems];
            int nDich = 0;
            int k = 0;
            while (k < this.nItems) {
                this.dichotomousPercentage[k] = this.checkWhetherDichotomous(this.scores0[k]);
                if (this.dichotomousPercentage[k] == 100.0) {
                    this.dichotomous[k] = true;
                    ++nDich;
                }
                ++k;
            }
            if (nDich == this.nItems) {
                this.dichotomousOverall = true;
            }
            this.dichotomousCheckDone = false;
        }
        return this.dichotomousPercentage;
    }

    protected double checkWhetherDichotomous(double[] array) {
        int n = array.length;
        double[] responseMatching = new double[n];
        boolean[] matchingCheck = new boolean[n];
        int i = 0;
        while (i < n) {
            responseMatching[i] = 0.0;
            matchingCheck[i] = false;
            ++i;
        }
        i = 0;
        while (i < n) {
            responseMatching[i] = 0.0;
            int j = 0;
            while (j < n) {
                if (array[i] == array[j] && !matchingCheck[j]) {
                    int n2 = i;
                    responseMatching[n2] = responseMatching[n2] + 1.0;
                    matchingCheck[j] = true;
                }
                ++j;
            }
            ++i;
        }
        ArrayMaths am0 = new ArrayMaths(responseMatching);
        ArrayMaths am1 = am0.sort();
        double[] sorted2 = am1.array();
        double max2 = (sorted2[n - 1] + sorted2[n - 2]) * 100.0 / (double)n;
        return max2;
    }

    public double[][] deleteItem(String name) {
        int index2 = this.itemIndex(name);
        return this.deleteItem(index2);
    }

    public double[][] deleteItem(int index2) {
        --index2;
        int jj = 0;
        double[][] array1 = new double[this.nItems - 1][this.nPersons];
        int i = 0;
        while (i < this.nItems) {
            if (i != index2) {
                array1[jj] = this.scores0[i];
                ++jj;
            }
            ++i;
        }
        return this.transpose0to1(array1);
    }

    public void rawItemItemPlot(String itemName1, String itemName2) {
        int index1 = this.itemIndex(itemName1);
        int index2 = this.itemIndex(itemName2);
        this.rawItemItemPlot(index1, index2);
    }

    public void rawItemItemPlot(int itemIndex1, int itemIndex2) {
        PlotGraph pg = new PlotGraph(this.scores0[--itemIndex1], this.scores0[--itemIndex2]);
        String graphTitle = "Scores: plot of responses to the item, " + this.itemNames[itemIndex1] + ", against those to the item, " + this.itemNames[itemIndex2];
        pg.setGraphTitle(graphTitle);
        pg.setXaxisLegend("Responses to the item, " + this.itemNames[itemIndex1]);
        pg.setYaxisLegend("Responses to the item, " + this.itemNames[itemIndex2]);
        pg.setLine(0);
        pg.setPoint(4);
        pg.plot();
    }

    public void rawItemMeansPlot(String itemName) {
        int index2 = this.itemIndex(itemName);
        this.rawItemMeansPlot(index2);
    }

    public void rawItemMeansPlot(int itemIndex) {
        PlotGraph pg = new PlotGraph(this.rawPersonMeans, this.scores0[--itemIndex]);
        String graphTitle = "Scores: plot of responses to the item, " + this.itemNames[itemIndex] + ", against the means of the responses to all items";
        pg.setGraphTitle(graphTitle);
        pg.setXaxisLegend("Mean of the responses to all the items, ");
        pg.setYaxisLegend("Responses to the item, " + this.itemNames[itemIndex]);
        pg.setLine(0);
        pg.setPoint(4);
        pg.plot();
    }

    public void standardizedItemItemPlot(String itemName1, String itemName2) {
        int index1 = this.itemIndex(itemName1);
        int index2 = this.itemIndex(itemName2);
        this.standardizedItemItemPlot(index1, index2);
    }

    public void standardisedItemItemPlot(String itemName1, String itemName2) {
        this.standardizedItemItemPlot(itemName1, itemName2);
    }

    public void standardizedItemItemPlot(int itemIndex1, int itemIndex2) {
        PlotGraph pg = new PlotGraph(this.standardizedScores0[--itemIndex1], this.standardizedScores0[--itemIndex2]);
        String graphTitle = "Scores: plot of responses to the item, " + this.itemNames[itemIndex1] + ", against those to the item, " + this.itemNames[itemIndex2];
        pg.setGraphTitle(graphTitle);
        pg.setXaxisLegend("Responses to the item, " + this.itemNames[itemIndex1]);
        pg.setYaxisLegend("Responses to the item, " + this.itemNames[itemIndex2]);
        pg.setLine(0);
        pg.setPoint(4);
        pg.plot();
    }

    public void standardisedItemItemPlot(int itemIndex1, int itemIndex2) {
        this.standardizedItemItemPlot(itemIndex1, itemIndex2);
    }

    public void standardizedItemMeansPlot(String itemName) {
        int index2 = this.itemIndex(itemName);
        this.standardizedItemMeansPlot(index2);
    }

    public void standardisedItemMeansPlot(String itemName) {
        this.standardizedItemMeansPlot(itemName);
    }

    public void standardizedItemMeansPlot(int itemIndex) {
        PlotGraph pg = new PlotGraph(this.standardizedPersonMeans, this.standardizedScores0[--itemIndex]);
        String graphTitle = "Scores: plot of responses to the item, " + this.itemNames[itemIndex] + ", against the means of the responses to all items";
        pg.setGraphTitle(graphTitle);
        pg.setXaxisLegend("Mean of the responses to all the items, ");
        pg.setYaxisLegend("Responses to the item, " + this.itemNames[itemIndex]);
        pg.setLine(0);
        pg.setPoint(4);
        pg.plot();
    }

    public void standardisedItemMeansPlot(int itemIndex) {
        this.standardizedItemMeansPlot(itemIndex);
    }

    public void numberOfDecimalPlaces(int trunc) {
        this.trunc = trunc;
    }

    public void numberOfDecimalPlacesAll(int trunc) {
        this.trunc = trunc;
        this.truncAll = true;
    }

    public void setOutputFileType(int option) {
        this.fileOption = option;
        this.fileOptionSet = true;
    }

    public void setFileNumbering() {
        this.fileNumberingSet = true;
    }

    public void removeFileNumbering() {
        this.fileNumberingSet = false;
    }

    public String getTitle() {
        return this.title[0];
    }

    public String getInputFileName() {
        return this.inputFilename;
    }

    public void outputProcessedData() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        this.outputFilename = "ScoresOutput";
        this.outputFilename = this.fileOption == 1 ? String.valueOf(this.outputFilename) + ".txt" : String.valueOf(this.outputFilename) + ".xls";
        String message1 = "Output file name for the processes scores:";
        String message2 = "\nEnter the required name (as a single word) and click OK ";
        String message3 = "\nor simply click OK for default value";
        String message = String.valueOf(message1) + message2 + message3;
        String defaultName = this.outputFilename;
        this.outputFilename = Db.readLine(message, defaultName);
        this.outputProcessedData(this.outputFilename);
    }

    public void outputProcessedData(String filename) {
        this.outputProcessedDataCommon(filename, this.originalDataOrder);
    }

    public void outputProcessedDataAlternate() {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        this.outputFilename = "ScoresOutput";
        this.outputFilename = this.fileOption == 1 ? String.valueOf(this.outputFilename) + ".txt" : String.valueOf(this.outputFilename) + ".xls";
        String message1 = "Output file name for the processes scores:";
        String message2 = "\nEnter the required name (as a single word) and click OK ";
        String message3 = "\nor simply click OK for default value";
        String message = String.valueOf(message1) + message2 + message3;
        String defaultName = this.outputFilename;
        this.outputFilename = Db.readLine(message, defaultName);
        this.outputProcessedDataAlternate(this.outputFilename);
    }

    public void outputProcessedDataAlternate(String filename) {
        int orderChoice = 0;
        if (this.originalDataOrder == 0) {
            orderChoice = 1;
        }
        this.outputProcessedDataCommon(filename, orderChoice);
    }

    private void outputProcessedDataCommon(String filename, int orderChoice) {
        if (!this.dataPreprocessed) {
            this.preprocessData();
        }
        this.outputFilename = filename;
        String outputFilenameWithoutExtension = null;
        String extension = null;
        int pos = filename.indexOf(46);
        if (pos == -1) {
            outputFilenameWithoutExtension = filename;
            this.outputFilename = this.fileOption == 1 ? String.valueOf(this.outputFilename) + ".txt" : String.valueOf(this.outputFilename) + ".xls";
        } else {
            int opt2;
            int defaultBox;
            String[] boxTitles;
            String[] comments;
            String message;
            String headerComment;
            String message2;
            String message1;
            extension = filename.substring(pos).trim();
            outputFilenameWithoutExtension = filename.substring(0, pos).trim();
            if (extension.equalsIgnoreCase(".xls") && this.fileOption == 1) {
                if (this.fileOptionSet) {
                    message1 = "Your entered output file type is .xls";
                    message2 = "\nbut you have chosen a .txt output";
                    headerComment = "Your output file name extension";
                    message = String.valueOf(message1) + message2;
                    comments = new String[]{message, "replace it with .txt [text file]"};
                    opt2 = Db.optionBox(headerComment, comments, boxTitles = new String[]{"Retain", ".txt"}, defaultBox = 1);
                    if (opt2 == 2) {
                        this.outputFilename = String.valueOf(outputFilenameWithoutExtension) + ".txt";
                    }
                } else {
                    this.fileOption = 2;
                }
            }
            if (extension.equalsIgnoreCase(".txt") && this.fileOption == 2) {
                if (this.fileOptionSet) {
                    message1 = "Your entered output file type is .txt";
                    message2 = "\nbut you have chosen a .xls output";
                    headerComment = "Your output file name extension";
                    message = String.valueOf(message1) + message2;
                    comments = new String[]{message, "replace it with .xls [Excel file]"};
                    opt2 = Db.optionBox(headerComment, comments, boxTitles = new String[]{"Retain", ".xls"}, defaultBox = 1);
                    if (opt2 == 2) {
                        this.outputFilename = String.valueOf(outputFilenameWithoutExtension) + ".xls";
                    }
                } else {
                    this.fileOption = 1;
                }
            }
            if (!extension.equalsIgnoreCase(".txt") && !extension.equalsIgnoreCase(".xls")) {
                message1 = "Your extension is " + extension;
                message2 = "\n    Do you wish to retain it:";
                message = String.valueOf(message1) + message2;
                headerComment = "Your output file name extension";
                comments = new String[]{message, "replace it with .txt [text file]", "replace it with .xls [MS Excel file]"};
                boxTitles = new String[]{"Retain", ".txt", ".xls"};
                defaultBox = 1;
                opt2 = Db.optionBox(headerComment, comments, boxTitles, defaultBox);
                switch (opt2) {
                    case 1: {
                        this.fileOption = 1;
                        break;
                    }
                    case 2: {
                        this.outputFilename = String.valueOf(outputFilenameWithoutExtension) + ".txt";
                        this.fileOption = 1;
                        break;
                    }
                    case 3: {
                        this.outputFilename = String.valueOf(outputFilenameWithoutExtension) + ".xls";
                        this.fileOption = 2;
                    }
                }
            }
        }
        this.title[0] = orderChoice == 0 ? String.valueOf(this.title[0]) + "   (output: row per item)" : String.valueOf(this.title[0]) + "   (output: row per person)";
        if (this.fileOption == 1) {
            this.outputText(orderChoice);
        } else {
            this.outputExcel(orderChoice);
        }
    }

    private void outputText(int orderChoice) {
        FileOutput fout = new FileOutput(this.outputFilename);
        fout.println(this.title[0]);
        fout.println(this.nItems);
        fout.println(this.nPersons);
        int i = 0;
        while (i < this.nItems) {
            fout.printtab(this.itemNames[i]);
            ++i;
        }
        fout.println();
        if (orderChoice == 0) {
            i = 0;
            while (i < this.nItems) {
                int j = 0;
                while (j < this.nPersons) {
                    fout.printtab(Fmath.truncate(this.scores0[i][j], this.trunc));
                    ++j;
                }
                fout.println();
                ++i;
            }
        } else {
            int j = 0;
            while (j < this.nPersons) {
                int i2 = 0;
                while (i2 < this.nItems) {
                    fout.printtab(Fmath.truncate(this.scores1[j][i2], this.trunc));
                    ++i2;
                }
                fout.println();
                ++j;
            }
        }
        fout.close();
    }

    private void outputExcel(int orderChoice) {
        FileOutput fout = new FileOutput(this.outputFilename);
        fout.println(this.title[0]);
        fout.println(this.nItems);
        fout.println(this.nPersons);
        int i = 0;
        while (i < this.nItems) {
            fout.printtab(this.itemNames[i]);
            ++i;
        }
        fout.println();
        if (orderChoice == 0) {
            i = 0;
            while (i < this.nItems) {
                int j = 0;
                while (j < this.nPersons) {
                    fout.printtab(Fmath.truncate(this.scores0[i][j], this.trunc));
                    ++j;
                }
                fout.println();
                ++i;
            }
        } else {
            int j = 0;
            while (j < this.nPersons) {
                int i2 = 0;
                while (i2 < this.nItems) {
                    fout.printtab(Fmath.truncate(this.scores1[j][i2], this.trunc));
                    ++i2;
                }
                fout.println();
                ++j;
            }
        }
        fout.close();
    }

    public PCA toPCA() {
        PCA pca = new PCA();
        pca.title = this.title;
        pca.titleLines = this.titleLines;
        pca.inputFilename = this.inputFilename;
        pca.outputFilename = this.outputFilename;
        pca.fileOption = this.fileOption;
        pca.fileOptionSet = this.fileOptionSet;
        pca.fileExtensions = this.fileExtensions;
        pca.fileNumberingSet = this.fileNumberingSet;
        pca.originalDataType = this.originalDataType;
        pca.originalDataOrder = this.originalDataOrder;
        pca.originalData = this.originalData;
        pca.scores0 = Conv.copy(this.scores0);
        pca.originalScores0 = Conv.copy(this.originalScores0);
        pca.standardizedScores0 = Conv.copy(this.standardizedScores0);
        pca.scores1 = Conv.copy(this.scores1);
        pca.originalScores1 = Conv.copy(this.originalScores1);
        pca.standardizedScores1 = Conv.copy(this.standardizedScores1);
        pca.dataEntered = this.dataEntered;
        pca.nItems = this.nItems;
        pca.originalNitems = this.originalNitems;
        pca.itemNames = Conv.copy(this.itemNames);
        pca.originalItemNames = Conv.copy(this.originalItemNames);
        pca.itemNamesSet = this.itemNamesSet;
        pca.nPersons = this.nPersons;
        pca.originalNpersons = this.originalNpersons;
        pca.nScores = this.nScores;
        pca.originalNscores = this.originalNscores;
        pca.otherFalse = this.otherFalse;
        pca.otherTrue = this.otherTrue;
        pca.otherDichotomousDataSet = this.otherDichotomousDataSet;
        pca.dichotomous = Conv.copy(this.dichotomous);
        pca.dichotomousPercentage = Conv.copy(this.dichotomousPercentage);
        pca.dichotomousOverall = this.dichotomousOverall;
        pca.dichotomousCheckDone = this.dichotomousCheckDone;
        pca.letterToNumeralSet = this.letterToNumeralSet;
        pca.ignoreNoResponseRequests = this.ignoreNoResponseRequests;
        pca.itemDeletionPercentage = this.itemDeletionPercentage;
        pca.itemDeletionPercentageSet = this.itemDeletionPercentageSet;
        pca.personDeletionPercentage = this.personDeletionPercentage;
        pca.personDeletionPercentageSet = this.personDeletionPercentageSet;
        pca.replacementOption = this.replacementOption;
        pca.replacementOptionNames = Conv.copy(this.replacementOptionNames);
        pca.replacementOptionSet = this.replacementOptionSet;
        pca.allNoResponseOptionsSet = this.allNoResponseOptionsSet;
        pca.noResponseHandlingSet = this.noResponseHandlingSet;
        pca.nNaN = this.nNaN;
        pca.deletedItems = Conv.copy(this.deletedItems);
        pca.nDeletedItems = this.nDeletedItems;
        pca.deletedItemsIndices = Conv.copy(this.deletedItemsIndices);
        pca.itemIndices = Conv.copy(this.itemIndices);
        pca.deletedPersons = Conv.copy(this.deletedPersons);
        pca.nDeletedPersons = this.nDeletedPersons;
        pca.deletedPersonsIndices = Conv.copy(this.deletedPersonsIndices);
        pca.personIndices = Conv.copy(this.personIndices);
        pca.nReplacements = this.nReplacements;
        pca.replacementIndices = Conv.copy(this.replacementIndices);
        pca.nFactorOption = this.nFactorOption;
        if (this.dataEntered) {
            pca.dataPreprocessed = false;
            pca.preprocessData();
        }
        return pca;
    }

    public Cronbach toCronbach() {
        Cronbach cr = new Cronbach();
        cr.title = this.title;
        cr.titleLines = this.titleLines;
        cr.inputFilename = this.inputFilename;
        cr.outputFilename = this.outputFilename;
        cr.fileOption = this.fileOption;
        cr.fileOptionSet = this.fileOptionSet;
        cr.fileExtensions = this.fileExtensions;
        cr.fileNumberingSet = this.fileNumberingSet;
        cr.originalDataType = this.originalDataType;
        cr.originalDataOrder = this.originalDataOrder;
        cr.originalData = this.originalData;
        cr.scores0 = Conv.copy(this.scores0);
        cr.originalScores0 = Conv.copy(this.originalScores0);
        cr.standardizedScores0 = Conv.copy(this.standardizedScores0);
        cr.scores1 = Conv.copy(this.scores1);
        cr.originalScores1 = Conv.copy(this.originalScores1);
        cr.standardizedScores1 = Conv.copy(this.standardizedScores1);
        cr.dataEntered = this.dataEntered;
        cr.nItems = this.nItems;
        cr.originalNitems = this.originalNitems;
        cr.itemNames = Conv.copy(this.itemNames);
        cr.originalItemNames = Conv.copy(this.originalItemNames);
        cr.itemNamesSet = this.itemNamesSet;
        cr.nPersons = this.nPersons;
        cr.originalNpersons = this.originalNpersons;
        cr.nScores = this.nScores;
        cr.originalNscores = this.originalNscores;
        cr.otherFalse = this.otherFalse;
        cr.otherTrue = this.otherTrue;
        cr.otherDichotomousDataSet = this.otherDichotomousDataSet;
        cr.dichotomous = Conv.copy(this.dichotomous);
        cr.dichotomousPercentage = Conv.copy(this.dichotomousPercentage);
        cr.dichotomousOverall = this.dichotomousOverall;
        cr.dichotomousCheckDone = this.dichotomousCheckDone;
        cr.letterToNumeralSet = this.letterToNumeralSet;
        cr.ignoreNoResponseRequests = this.ignoreNoResponseRequests;
        cr.itemDeletionPercentage = this.itemDeletionPercentage;
        cr.itemDeletionPercentageSet = this.itemDeletionPercentageSet;
        cr.personDeletionPercentage = this.personDeletionPercentage;
        cr.personDeletionPercentageSet = this.personDeletionPercentageSet;
        cr.replacementOption = this.replacementOption;
        cr.replacementOptionNames = Conv.copy(this.replacementOptionNames);
        cr.replacementOptionSet = this.replacementOptionSet;
        cr.allNoResponseOptionsSet = this.allNoResponseOptionsSet;
        cr.noResponseHandlingSet = this.noResponseHandlingSet;
        cr.nNaN = this.nNaN;
        cr.deletedItems = Conv.copy(this.deletedItems);
        cr.nDeletedItems = this.nDeletedItems;
        cr.deletedItemsIndices = Conv.copy(this.deletedItemsIndices);
        cr.itemIndices = Conv.copy(this.itemIndices);
        cr.deletedPersons = Conv.copy(this.deletedPersons);
        cr.nDeletedPersons = this.nDeletedPersons;
        cr.deletedPersonsIndices = Conv.copy(this.deletedPersonsIndices);
        cr.personIndices = Conv.copy(this.personIndices);
        cr.nReplacements = this.nReplacements;
        cr.replacementIndices = Conv.copy(this.replacementIndices);
        cr.nFactorOption = this.nFactorOption;
        if (this.dataEntered) {
            cr.dataPreprocessed = false;
            cr.preprocessData();
        }
        return cr;
    }
}

