/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.RegressionFunction;
import flanagan.math.Fmath;

class LorentzianFunction
implements RegressionFunction {
    public boolean scaleOption = true;
    public double scaleFactor = 1.0;

    LorentzianFunction() {
    }

    @Override
    public double function(double[] p, double[] x2) {
        double yScale = this.scaleFactor;
        if (this.scaleOption) {
            yScale = p[2];
        }
        double y = yScale / Math.PI * (p[1] / 2.0) / (Fmath.square(x2[0] - p[0]) + Fmath.square(p[1] / 2.0));
        return y;
    }
}

