/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.charts4j.parameters;

import com.googlecode.charts4j.collect.ImmutableList;
import com.googlecode.charts4j.collect.Lists;
import com.googlecode.charts4j.parameters.AbstractParameter;
import com.googlecode.charts4j.parameters.ParameterUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DataLegendsParameter
extends AbstractParameter {
    private static final String URL_PARAMETER_KEY = "chdl";
    private final List<String> legends = Lists.newLinkedList();

    DataLegendsParameter() {
    }

    void addLegends(ImmutableList<? extends String> legends) {
        this.legends.addAll(legends);
    }

    @Override
    public String getKey() {
        return URL_PARAMETER_KEY;
    }

    @Override
    public String getValue() {
        StringBuilder sb = new StringBuilder();
        int cnt = 0;
        for (String legend : this.legends) {
            String l = ParameterUtil.utf8Encode(legend);
            sb.append(cnt++ > 0 ? "|" : "").append(l);
        }
        return !this.legends.isEmpty() ? sb.toString() : "";
    }
}

