/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.vcf;

import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.util.HashMap;

public class VcfGenotype {
    String values;
    int[] genotype;
    int ploidy;
    boolean phased;
    double gQuality;
    int depth;
    int[] genotypeLikelihoodPhred;
    HashMap<String, String> fields;
    VcfEntry vcfEntry;

    public VcfGenotype(VcfEntry vcfEntry, String format2, String values2) {
        this.vcfEntry = vcfEntry;
        this.values = values2;
    }

    public void add(String name, String value2) {
        if (value2.indexOf(32) >= 0 || value2.indexOf(9) >= 0 || value2.indexOf(61) >= 0) {
            throw new RuntimeException("Error: Attempt to add a value containin illegal characters: no white-space, semi-colons, or equals-signs permitted\n\tname : '" + name + "'\n\tvalue : '" + value2 + "'");
        }
        if (this.vcfEntry.getFormat().indexOf(name) < 0) {
            throw new RuntimeException("Error Attempt to add a field (name=" + name + ") that is not present in FORMAT field. Use VcfEntry.addFormat() method first!");
        }
        this.values = String.valueOf(this.values) + (this.values.endsWith(":") ? "" : ":") + value2;
        if (this.fields != null) {
            this.fields.put(name, value2);
        }
    }

    public String get(String fieldName) {
        this.parseFields();
        return this.fields.get(fieldName);
    }

    public int[] getGenotype() {
        this.parseFields();
        return this.genotype;
    }

    public String getGenotype(int idx) {
        this.parseFields();
        if (this.genotype == null) {
            return "";
        }
        int num = this.genotype[idx];
        if (num < 0) {
            return "";
        }
        return num == 0 ? this.vcfEntry.getRef() : this.vcfEntry.getAlts()[num - 1];
    }

    public int getGenotypeCode() {
        this.parseFields();
        if (this.genotype == null) {
            return -1;
        }
        int code = 0;
        int i = 0;
        while (i < this.genotype.length) {
            if (this.genotype[i] < 0 || this.genotype[i] > 1) {
                return -1;
            }
            code += this.genotype[i];
            ++i;
        }
        return code;
    }

    public String getGenotypeStr() {
        this.parseFields();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.genotype.length) {
            int num = this.genotype[i];
            String gen = ".";
            if (num == 0) {
                gen = this.vcfEntry.getRef();
            } else if (num > 0) {
                gen = this.vcfEntry.getAlts()[num - 1];
            }
            sb.append(gen);
            if (i < this.genotype.length - 1) {
                if (this.isPhased()) {
                    sb.append("|");
                } else {
                    sb.append("/");
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public boolean isHeterozygous() {
        return !this.isHomozygous();
    }

    public boolean isHomozygous() {
        this.parseFields();
        if (this.genotype != null) {
            int i = 1;
            while (i < this.genotype.length) {
                if (this.genotype[i] != this.genotype[i - 1]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return this.vcfEntry.isHomozygous();
    }

    public boolean isMissing() {
        this.parseFields();
        if (this.genotype == null) {
            return true;
        }
        int i = 0;
        while (i < this.genotype.length) {
            if (this.genotype[i] < 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isPhased() {
        this.parseFields();
        return this.phased;
    }

    public boolean isVariant() {
        if (this.values.isEmpty()) {
            return false;
        }
        this.parseFields();
        if (this.genotype != null) {
            int i = 0;
            while (i < this.genotype.length) {
                if (this.genotype[i] > 0) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return this.vcfEntry.isVariant();
    }

    void parseFields() {
        if (this.fields != null) {
            return;
        }
        try {
            this.fields = new HashMap();
            if (this.values.isEmpty()) {
                return;
            }
            String[] fieldNames = this.vcfEntry.getFormat().split(":");
            String[] fieldValues = this.values.split(":");
            int min2 = Math.min(fieldValues.length, fieldNames.length);
            int i = 0;
            while (i < min2) {
                String name = fieldNames[i];
                String value2 = fieldValues[i];
                this.fields.put(name, value2);
                if (name.equals("GT")) {
                    this.parseGt(value2);
                } else if (name.equals("PL")) {
                    this.parsePl(value2);
                } else if (name.equals("GQ")) {
                    this.gQuality = Gpr.parseDoubleSafe(value2);
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing fields on line:\n\tFormat: '" + this.vcfEntry.getFormat() + "'\n\tValues: '" + this.values + "'", e);
        }
    }

    void parseGt(String value2) {
        String[] gtStr = null;
        if (value2.indexOf(124) >= 0) {
            gtStr = value2.split("\\|");
            this.phased = true;
        } else {
            gtStr = value2.split("/");
            this.phased = false;
        }
        this.genotype = new int[gtStr.length];
        int i = 0;
        while (i < this.genotype.length) {
            if (gtStr[i].isEmpty() || gtStr[i].isEmpty() || gtStr[i].equals(".")) {
                this.genotype[i] = -1;
            } else {
                this.genotype[i] = Gpr.parseIntSafe(gtStr[i]);
                if (this.genotype[i] - 1 >= this.vcfEntry.getAlts().length) {
                    boolean plural = this.vcfEntry.getAlts().length > 1;
                    throw new RuntimeException("Error: Bad genotype field '" + value2 + "'. Genotype says '" + this.genotype[i] + "' but there " + (plural ? "are" : "is") + " only '" + this.vcfEntry.getAlts().length + "' allele" + (plural ? "s" : "") + " ('" + this.vcfEntry.getAltsStr() + "').");
                }
            }
            ++i;
        }
    }

    void parsePl(String value2) {
        String[] plStr = value2.split(",");
        this.genotypeLikelihoodPhred = new int[plStr.length];
        int i = 0;
        while (i < plStr.length) {
            this.genotypeLikelihoodPhred[i] = Gpr.parseIntSafe(plStr[i]);
            ++i;
        }
    }

    public String toString() {
        return this.values.isEmpty() ? "." : this.values;
    }
}

