/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.stats;

import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.stats.ChrPosStats;
import ca.mcgill.mcb.pcingola.stats.CountByType;
import ca.mcgill.mcb.pcingola.stats.IntStats;
import ca.mcgill.mcb.pcingola.stats.SamplingStats;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class SeqChangeStats
implements SamplingStats<SeqChange> {
    public static final String CHANGE_SEPARATOR = "\t";
    static final char[] bases = new char[]{'A', 'C', 'G', 'T'};
    Genome genome;
    IntStats qualityStats;
    IntStats coverageStats;
    IntStats indelLen;
    HashMap<String, ChrPosStats> chrPosStatsbyName;
    long countSeqChanges = 0L;
    long countVariants = 0L;
    long countNonVariants;
    long countNonEmptyId;
    CountByType countByChangeType;
    CountByType countByChangeTypeHet;
    CountByType countByChangeTypeHom;
    CountByType baseChangesCount;

    public SeqChangeStats(Genome genome) {
        this.genome = genome;
        this.qualityStats = new IntStats();
        this.coverageStats = new IntStats();
        this.indelLen = new IntStats();
        this.chrPosStatsbyName = new HashMap();
        this.countByChangeType = new CountByType();
        this.countByChangeTypeHom = new CountByType();
        this.countByChangeTypeHet = new CountByType();
        this.baseChangesCount = new CountByType();
    }

    private String changeKey(String oldItem, String newItem) {
        return String.valueOf(oldItem) + CHANGE_SEPARATOR + newItem;
    }

    public char[] getBases() {
        return bases;
    }

    public String getBasesChangesColor(String oldBase, String newBase) {
        return this.baseChangesCount.getColorHtml(this.changeKey(oldBase, newBase));
    }

    public long getBasesChangesCount(String oldBase, String newBase) {
        return this.baseChangesCount.get(this.changeKey(oldBase, newBase));
    }

    public SeqChange.ChangeType[] getChangeType() {
        return SeqChange.ChangeType.values();
    }

    public int getChangeTypeLength() {
        return SeqChange.ChangeType.values().length;
    }

    public int getChromosomeLength(String chromoName) {
        Chromosome chr = this.genome.getChromosome(chromoName);
        if (chr != null) {
            return chr.size();
        }
        return 0;
    }

    public List<String> getChromosomeNamesEffective() {
        ArrayList<Chromosome> chrsEffective = new ArrayList<Chromosome>();
        for (String chrName : this.chrPosStatsbyName.keySet()) {
            chrsEffective.add(this.genome.getChromosome(chrName));
        }
        Collections.sort(chrsEffective);
        ArrayList<String> chrNames = new ArrayList<String>();
        for (Chromosome chr : chrsEffective) {
            chrNames.add(chr.getId());
        }
        return chrNames;
    }

    public ChrPosStats getChrPosStats(String chrName) {
        return this.chrPosStatsbyName.get(chrName);
    }

    public String getChrPosStatsChartUrl(String chrName) {
        return this.chrPosStatsbyName.get(chrName).toStringHistoPlot("Changes histogram: " + chrName, "Position", "Changes");
    }

    public long getCount() {
        return this.countSeqChanges;
    }

    public CountByType getCountByChangeType() {
        return this.countByChangeType;
    }

    public CountByType getCountByChangeTypeHet() {
        return this.countByChangeTypeHet;
    }

    public CountByType getCountByChangeTypeHom() {
        return this.countByChangeTypeHom;
    }

    public int getCountByChromosome(String chromoName) {
        ChrPosStats chrStats = this.chrPosStatsbyName.get(chromoName);
        if (chrStats == null) {
            return 0;
        }
        return chrStats.getTotal();
    }

    public long getCountNonEmptyId() {
        return this.countNonEmptyId;
    }

    public long getCountNonVariants() {
        return this.countNonVariants;
    }

    public String getCoverageHistoUrl() {
        return this.coverageStats.toStringPlot("Coverage histogram", "Coverage", true);
    }

    public IntStats getCoverageStats() {
        return this.coverageStats;
    }

    public long getGenomeLen() {
        return this.genome.length();
    }

    public long getGenomeLenEffective() {
        long len = 0L;
        for (String chrName : this.chrPosStatsbyName.keySet()) {
            Chromosome ch = this.genome.getChromosome(chrName);
            len += (long)(ch.getEnd() - ch.getStart() + 1);
        }
        return len;
    }

    public IntStats getIndelLen() {
        return this.indelLen;
    }

    public String getIndelLenHistoUrl() {
        return this.indelLen.toStringPlot("Insertion deletion length histogram", "Length", true);
    }

    public double getKnownRatio() {
        double tot = this.countSeqChanges;
        double known = this.countNonEmptyId;
        return tot > 0.0 ? known / tot : 0.0;
    }

    public String getQualityHistoUrl() {
        return this.qualityStats.toStringPlot("Quality histogram", "Quality", true);
    }

    public IntStats getQualityStats() {
        return this.qualityStats;
    }

    public long getRateOfChange() {
        return this.countSeqChanges > 0L ? this.getGenomeLenEffective() / this.countSeqChanges : 0L;
    }

    public int getRateOfChangeByChromosome(String chromoName) {
        int rate = 0;
        int len = this.getChromosomeLength(chromoName);
        int count2 = this.getCountByChromosome(chromoName);
        if (count2 > 0) {
            rate = len / count2;
        }
        return rate;
    }

    public long getTransitions() {
        return this.baseChangesCount.get(this.changeKey("A", "G")) + this.baseChangesCount.get(this.changeKey("G", "A")) + this.baseChangesCount.get(this.changeKey("C", "T")) + this.baseChangesCount.get(this.changeKey("T", "C"));
    }

    public long getTransversions() {
        return this.baseChangesCount.get(this.changeKey("A", "C")) + this.baseChangesCount.get(this.changeKey("C", "A")) + this.baseChangesCount.get(this.changeKey("A", "T")) + this.baseChangesCount.get(this.changeKey("T", "A")) + this.baseChangesCount.get(this.changeKey("G", "C")) + this.baseChangesCount.get(this.changeKey("C", "G")) + this.baseChangesCount.get(this.changeKey("G", "T")) + this.baseChangesCount.get(this.changeKey("T", "G"));
    }

    public double getTsTvRatio() {
        double ts = this.getTransitions();
        double tv = this.getTransversions();
        return tv > 0.0 ? ts / tv : 0.0;
    }

    @Override
    public boolean hasData() {
        return this.countSeqChanges != 0L;
    }

    void indelSample(SeqChange seqChange) {
        int len = (seqChange.isDel() ? -1 : 1) * (seqChange.getChangeOption(0).length() - 1);
        this.indelLen.sample(len);
    }

    @Override
    public void sample(SeqChange seqChange) {
        if (!seqChange.isChange()) {
            ++this.countNonVariants;
            return;
        }
        ++this.countSeqChanges;
        if (seqChange.getId() != null && !seqChange.getId().isEmpty()) {
            ++this.countNonEmptyId;
        }
        String changeType = seqChange.getChangeType().toString();
        this.countByChangeType.inc(changeType);
        if (seqChange.isHomozygous()) {
            this.countByChangeTypeHom.inc(changeType);
        }
        if (seqChange.isHeterozygous()) {
            this.countByChangeTypeHet.inc(changeType);
        }
        if (seqChange.getQuality() >= 0.0) {
            this.qualityStats.sample((int)seqChange.getQuality());
        }
        if (seqChange.getCoverage() >= 0) {
            this.coverageStats.sample(seqChange.getCoverage());
        }
        if (seqChange.isSnp()) {
            this.snpSample(seqChange);
        } else if (seqChange.isInDel()) {
            this.indelSample(seqChange);
        }
        Chromosome chr = seqChange.getChromosome();
        if (chr != null) {
            String chrName = chr.getId();
            ChrPosStats chrPosStats = this.chrPosStatsbyName.get(chrName);
            if (chrPosStats == null) {
                chrPosStats = new ChrPosStats(chrName, chr.size());
                this.chrPosStatsbyName.put(chrName, chrPosStats);
            }
            chrPosStats.sample(seqChange.getStart());
        }
    }

    void snpSample(SeqChange seqChange) {
        String ref = seqChange.getReference();
        int numOpts = seqChange.getChangeOptionCount();
        int i = 0;
        while (i < numOpts) {
            String snp = seqChange.getChangeOption(i);
            if (ref != snp) {
                this.baseChangesCount.inc(this.changeKey(ref, snp));
            }
            ++i;
        }
    }
}

