/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.stats;

import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import ca.mcgill.mcb.pcingola.stats.CountByType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class GeneCountByTypeTable
implements Iterable<Gene>,
Serializable {
    public static int GENE_CPG_NUM_BINS = 30;
    public static boolean debug = false;
    int prevSeqChangePos = -1;
    HashSet<String> latestTypes;
    HashSet<Gene> genes = new HashSet();
    HashMap<String, CountByType> countersByType = new HashMap();

    public GeneCountByTypeTable() {
        this.latestTypes = new HashSet();
    }

    public CountByType getCounter(String type) {
        CountByType counter = this.countersByType.get(type);
        if (counter == null) {
            counter = new CountByType();
            this.countersByType.put(type, counter);
        }
        return counter;
    }

    public List<Gene> getGeneList() {
        ArrayList<Gene> geneList = new ArrayList<Gene>();
        geneList.addAll(this.genes);
        Collections.sort(geneList, new Comparator<Gene>(){

            @Override
            public int compare(Gene o1, Gene o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
        return geneList;
    }

    public List<String> getTypeList() {
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.addAll(this.countersByType.keySet());
        Collections.sort(typeList);
        return typeList;
    }

    @Override
    public Iterator<Gene> iterator() {
        return this.genes.iterator();
    }

    public void sample(Gene gene, Marker marker, String type, ChangeEffect changeEffect) {
        SeqChange seqChange = changeEffect.getSeqChange();
        if (this.prevSeqChangePos != seqChange.getStart()) {
            this.latestTypes.clear();
            this.prevSeqChangePos = seqChange.getStart();
        }
        if (this.latestTypes.contains(type)) {
            return;
        }
        this.latestTypes.add(type);
        CountByType counter = this.getCounter(type);
        int start = Math.max(seqChange.getStart(), marker.getStart());
        int end = Math.min(seqChange.getEnd(), marker.getEnd());
        int size2 = end - start + 1;
        if (size2 > 0) {
            counter.inc(gene.getId(), size2);
            if (!Double.isNaN(seqChange.getScore())) {
                counter.addScore(gene.getId(), seqChange.getScore());
            }
        }
        this.genes.add(gene);
    }
}

