/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases;

import ca.mcgill.mcb.pcingola.codons.CodonTable;
import ca.mcgill.mcb.pcingola.codons.CodonTables;
import ca.mcgill.mcb.pcingola.fileIterator.FastaFileIterator;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.GprSeq;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class TestCompareCds {
    public static boolean debug;
    public static boolean quiet;
    public static boolean verbose;
    public static boolean onlyOneError;
    public static double maxErrorPercentage;
    Config config;
    Map<String, String> cdsByTrId;
    int totalErrors = 0;
    int totalOk = 0;
    int totalWarnings = 0;
    int totalNotFound = 0;

    static {
        quiet = debug = false;
        verbose = debug;
        onlyOneError = false;
        maxErrorPercentage = 0.01;
    }

    public static void main(String[] args) {
        String configFile = "snpEff.config";
        String genomeToTest = "";
        if (args.length <= 0) {
            System.err.println("Usage: TestCaseCompareCds genomeToTest\n");
            System.exit(-1);
        }
        if (args[0].equals("-c")) {
            configFile = args[1];
            genomeToTest = args[2];
        } else if (args[0].equals("-d")) {
            verbose = true;
            debug = true;
            genomeToTest = args[1];
        } else {
            genomeToTest = args[0];
        }
        TestCompareCds.test(genomeToTest, configFile);
    }

    public static void test(String genomeVersion) {
        TestCompareCds.test(genomeVersion, "snpEff.config");
    }

    public static void test(String genomeVersion, String configFile) {
        if (!quiet) {
            System.out.println("CDS test for " + genomeVersion);
        }
        TestCompareCds testCompareCds = new TestCompareCds(genomeVersion, configFile);
        testCompareCds.readCdsFile();
        double perc = testCompareCds.cdsCompare();
        if (perc > maxErrorPercentage) {
            throw new RuntimeException("Too many errors. Percentaje : " + 100.0 * perc + "%");
        }
    }

    public TestCompareCds(String genomeVersion, String configFile) {
        this.config = new Config(genomeVersion, configFile);
        this.cdsByTrId = new HashMap<String, String>();
        try {
            if (!quiet) {
                System.out.print("Loading predictor " + this.config.getGenome().getVersion() + " ");
            }
            this.config.loadSnpEffectPredictor();
            if (!quiet) {
                System.out.println("done");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public double cdsCompare() {
        int i = 1;
        for (Gene gint : this.config.getGenome().getGenes()) {
            for (Transcript tint : gint) {
                String cds = tint.cds().toUpperCase();
                String cdsAndUtrs = tint.mRna().toUpperCase();
                String cdsReference = this.cdsByTrId.get(tint.getId());
                if (cdsReference == null || cds.length() <= 0) {
                    if (verbose) {
                        System.err.println("\nWARNING:Cannot find CDS for transcript " + tint.getId());
                    }
                    ++this.totalNotFound;
                    if (verbose && !quiet) {
                        System.out.print('.');
                    }
                } else if (cds.equals(cdsReference)) {
                    ++this.totalOk;
                    if (verbose && !quiet) {
                        System.out.print('+');
                    }
                    if (cds != null && cds.length() >= 3) {
                        String stopCodon;
                        String startCodon;
                        CodonTable ctable = CodonTables.getInstance().getTable(this.config.getGenome(), tint.getChromosomeName());
                        if (!ctable.isStart(startCodon = cds.substring(0, 3))) {
                            if (verbose) {
                                System.err.println("\nWARNING: CDS for transcript '" + tint.getId() + "' does not start with a start codon:\n\t" + startCodon + "\t" + cds);
                            }
                            ++this.totalWarnings;
                        }
                        if (!ctable.isStop(stopCodon = cds.substring(cds.length() - 3, cds.length()))) {
                            if (verbose) {
                                System.err.println("\nWARNING: CDS for transcript '" + tint.getId() + "' does not end with a stop codon:\n\t" + stopCodon + "\t" + cds);
                            }
                            ++this.totalWarnings;
                        }
                    }
                } else if (cdsAndUtrs.equals(cdsReference)) {
                    ++this.totalOk;
                    if (verbose && !quiet) {
                        System.out.print('-');
                    }
                } else {
                    if (verbose || onlyOneError) {
                        System.err.println("\nERROR:CDS do not match for transcript " + tint.getId() + "\tStrand:" + tint.getStrand() + "\tExons: " + tint.numChilds() + "\n\tsnpEff (" + cds.length() + "):\t" + cds.toLowerCase() + "\n\tReference(" + cdsReference.length() + "):\t" + cdsReference.toLowerCase() + "\nTranscript details:\n" + tint);
                    } else if (!quiet) {
                        System.out.print('*');
                    }
                    ++this.totalErrors;
                    if (onlyOneError) {
                        System.err.println("Transcript details:\n" + tint);
                        throw new RuntimeException("DIE");
                    }
                }
                if (verbose && !quiet && i % 100 == 0) {
                    System.out.println("");
                }
                ++i;
            }
        }
        double perc = (double)this.totalErrors / (double)(this.totalErrors + this.totalOk);
        if (!quiet) {
            System.out.println("");
        }
        System.out.println(String.valueOf(this.config.getGenome().getVersion()) + "\tOK: " + this.totalOk + "\tWarnings: " + this.totalWarnings + "\tNot found: " + this.totalNotFound + "\tErrors: " + this.totalErrors + "\tError percentage: " + 100.0 * perc + "%");
        return perc;
    }

    void readCdsFastaFile(String cdsFastaFileName) {
        int lineNum = 1;
        if (!quiet) {
            System.out.print("Reading file:" + cdsFastaFileName + "\t");
        }
        FastaFileIterator ffi = new FastaFileIterator(cdsFastaFileName);
        for (String cds : ffi) {
            String trid = GprSeq.readId(ffi.getHeader());
            if (this.cdsByTrId.get(trid) != null && !this.cdsByTrId.get(trid).equals(cds)) {
                System.err.println("ERROR: Different CDS for the same transcript ID. This should never happen!!!\n\tLine number: " + lineNum + "\n\tTranscript ID:\t" + trid + "\n\tCDS:\t\t" + this.cdsByTrId.get(trid) + "\n\tCDS (new):\t" + cds);
            }
            this.cdsByTrId.put(trid, cds);
            ++lineNum;
        }
        if (!quiet) {
            System.out.println("done reading " + this.cdsByTrId.size() + " CDSs");
        }
    }

    void readCdsFile() {
        String cdsFileName = String.valueOf(this.config.getDirDataVersion()) + "/cds.txt.gz";
        File file = new File(cdsFileName);
        if (file.exists()) {
            this.readCdsFile(cdsFileName);
            return;
        }
        String cdsFastaFileName = String.valueOf(this.config.getDirDataVersion()) + "/cds.fa.gz";
        file = new File(cdsFastaFileName);
        if (file.exists()) {
            this.readCdsFastaFile(cdsFastaFileName);
            return;
        }
        throw new RuntimeException("Neither '" + cdsFileName + "' nor '" + cdsFastaFileName + "' file exists!");
    }

    void readCdsFile(String cdsFileName) {
        String[] cdsLines;
        int lineNum = 1;
        if (!quiet) {
            System.out.print("Reading file:" + cdsFileName + "\t");
        }
        String cdsFile = Gpr.readFile(cdsFileName);
        String[] stringArray = cdsLines = cdsFile.split("\n");
        int n = cdsLines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] records = line.split("\\t");
            String trid = records[0].trim();
            String cds = records[1].trim().toUpperCase();
            if (this.cdsByTrId.get(trid) != null && !this.cdsByTrId.get(trid).equals(cds)) {
                System.err.println("ERROR: Different CDS for the same transcript ID. This should never happen!!!\n\tLine number: " + lineNum + "\n\tTranscript ID:\t" + trid + "\n\tCDS:\t\t" + this.cdsByTrId.get(trid) + "\n\tCDS (new):\t" + cds);
            }
            this.cdsByTrId.put(trid, cds);
            ++lineNum;
            ++n2;
        }
        if (!quiet) {
            System.out.println("done reading " + this.cdsByTrId.size() + " CDSs");
        }
    }
}

