/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases;

import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryRand;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestCasesTranscript
extends TestCase {
    boolean debug = false;
    Random rand;
    Config config;
    Genome genome;
    Chromosome chromosome;
    Gene gene;
    Transcript transcript;
    SnpEffectPredictor snpEffectPredictor;
    String chromoSequence = "";
    char[] chromoBases;

    public TestCasesTranscript() {
        this.init();
    }

    void init() {
        this.initRand();
        this.initSnpEffPredictor();
    }

    void initRand() {
        this.rand = new Random(20120131L);
    }

    void initSnpEffPredictor() {
        this.config = new Config("testCase", "snpEff.config");
        int maxGeneLen = 1000;
        int maxTranscripts = 1;
        int maxExons = 5;
        SnpEffPredictorFactoryRand sepf = new SnpEffPredictorFactoryRand(this.config, 1, this.rand, maxGeneLen, maxTranscripts, maxExons);
        this.snpEffectPredictor = sepf.create();
        this.config.setSnpEffectPredictor(this.snpEffectPredictor);
        this.chromoSequence = sepf.getChromoSequence();
        this.chromoBases = this.chromoSequence.toCharArray();
        this.config.getSnpEffectPredictor().setUpDownStreamLength(0);
        this.config.getSnpEffectPredictor().buildForest();
        this.chromosome = sepf.getChromo();
        this.genome = this.config.getGenome();
        this.gene = this.genome.getGenes().iterator().next();
        this.transcript = (Transcript)this.gene.iterator().next();
    }

    public void test_CdsPos() {
        int N = 1000;
        int iter2 = 0;
        while (iter2 < N) {
            this.initSnpEffPredictor();
            if (this.debug) {
                System.out.println("Test CDS pos iteration: " + iter2 + "\n" + this.transcript);
            } else {
                System.out.println("Test CDS pos iteration: " + iter2 + "\t" + (this.transcript.getStrand() >= 0 ? "+" : "-") + "\t" + this.transcript.cds());
            }
            int cdsBaseNum = 0;
            int[] cds2pos = this.transcript.cdsBaseNumber2ChrPos();
            for (Exon exon : this.transcript.sortedStrand()) {
                int min2 = this.transcript.isStrandPlus() ? exon.getStart() : exon.getEnd();
                int step2 = this.transcript.isStrandPlus() ? 1 : -1;
                int pos = min2;
                while (exon.intersects(pos)) {
                    int cdsBaseNumCalc = this.transcript.cdsBaseNumber(pos, true);
                    Assert.assertEquals(cdsBaseNum, cdsBaseNumCalc);
                    Assert.assertEquals(pos, cds2pos[cdsBaseNum]);
                    pos += step2;
                    ++cdsBaseNum;
                }
            }
            ++iter2;
        }
    }
}

