/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases;

import ca.mcgill.mcb.pcingola.binseq.coder.DnaCoder;
import ca.mcgill.mcb.pcingola.nmer.Nmer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Random;
import junit.framework.TestCase;

public class TestCasesNmers
extends TestCase {
    public static boolean verbose = false;

    String randSeq(int len, Random rand) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < len) {
            int r = rand.nextInt() & 3;
            sb.append(DnaCoder.get().toBase(r));
            ++i;
        }
        return sb.toString();
    }

    public void test_03_Nmers() {
        long seed = 20100615L;
        Random rand = new Random(seed);
        int numTests = 100;
        int len = 1;
        while (len <= 32) {
            int t2 = 0;
            while (t2 < numTests) {
                Nmer nmer;
                String seq2 = this.randSeq(len, rand);
                if (verbose) {
                    System.out.println("Nmer test:" + t2 + "\tlen:" + len + "\t" + seq2);
                }
                if (!seq2.equals((nmer = new Nmer(seq2)).toString())) {
                    throw new RuntimeException("Sequences do not match:\n\tSeq    :\t" + seq2 + "\n\tBinSeq :\t" + nmer);
                }
                ++t2;
            }
            ++len;
        }
    }

    public void test_20_Nmers_read_write() {
        String testFile = "/tmp/nmer_test.bin";
        int nmerSize = 32;
        int numNmers = 100000;
        try {
            FileOutputStream os = new FileOutputStream(new File(testFile));
            Random rand = new Random(20100825L);
            ArrayList<Nmer> list2 = new ArrayList<Nmer>();
            int i = 0;
            while (i < numNmers) {
                Nmer nmer = new Nmer(nmerSize);
                nmer.setNmer(rand.nextLong());
                list2.add(nmer);
                nmer.write(os);
                ++i;
            }
            os.close();
            Nmer nmer = new Nmer(nmerSize);
            FileInputStream is = new FileInputStream(new File(testFile));
            int i2 = 0;
            while (nmer.read(is) >= 0) {
                Nmer nmerOri = (Nmer)list2.get(i2);
                if (nmerOri.getNmer() != nmer.getNmer()) {
                    throw new RuntimeException("Nmers differ:\n\t" + nmerOri + "\t" + Long.toHexString(nmerOri.getNmer()) + "\n\t" + nmer + "\t" + Long.toHexString(nmer.getNmer()));
                }
                ++i2;
            }
            is.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

