/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases;

import ca.mcgill.mcb.pcingola.binseq.DnaSequence;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Markers;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.tree.IntervalForest;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.GprSeq;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;

public class TestCasesIntervals
extends TestCase {
    int maxLen = 100;
    boolean verbose = true;
    boolean compareCdsTestsEnable = false;
    Random rand;
    Genome genome;

    public TestCasesIntervals() {
        this.initRand();
        String genomeName = "testCaseHg";
        this.genome = new Genome(genomeName);
        int i = 1;
        while (i < 22) {
            this.genome.add(new Chromosome(this.genome, 0, 0, 1, "" + i));
            ++i;
        }
        this.genome.add(new Chromosome(this.genome, 0, 0, 1, "X"));
        this.genome.add(new Chromosome(this.genome, 0, 0, 1, "Y"));
    }

    boolean anyResultMatches(String transcriptId, SeqChange seqChange, List<ChangeEffect> resultsList, boolean useSimple, StringBuilder resultsSoFar) {
        boolean ok = false;
        for (ChangeEffect chEff : resultsList) {
            String resStr = chEff.toStringSimple(!useSimple);
            if (this.verbose) {
                System.out.println(seqChange + "\t'" + resStr + "'");
            }
            String effTrId = chEff.getMarker().findParent(Transcript.class).getId();
            if (transcriptId != null && !transcriptId.equals(effTrId)) continue;
            if (!seqChange.getId().equals(resStr)) {
                if (this.verbose) {
                    Gpr.debug("SeqChange: " + seqChange + "\tResult: '" + chEff + "'");
                }
                resultsSoFar.append(seqChange + "\t'" + resStr + "'\n");
                continue;
            }
            ok = true;
            break;
        }
        return ok;
    }

    public void compareToFile(String result2, String fileName) {
        String file = Gpr.readFile(fileName).trim();
        if (!(result2 = result2.trim()).equals(file)) {
            String errMsg = "Results and file '" + fileName + "' do not match:\n--- Results ---\n" + result2 + "\n--- File '" + fileName + "' ---\n" + file + "\n--- End ---\n";
            System.err.println(errMsg);
            throw new RuntimeException(errMsg);
        }
    }

    public void DnaSequenceBaseAt(int len) {
        char[] bases = new char[len];
        int i = 0;
        while (i < bases.length) {
            char base;
            bases[i] = base = GprSeq.BASES[(int)(Math.random() * 4.0)];
            ++i;
        }
        String sequence2 = new String(bases);
        DnaSequence DnaSequence2 = new DnaSequence(sequence2);
        System.out.println("DnaSequence (len:" + len + ") : " + DnaSequence2);
        int i2 = 0;
        while (i2 < bases.length) {
            char base = Character.toUpperCase(DnaSequence2.getBase(i2));
            if (base != bases[i2]) {
                throw new RuntimeException("Bases do not match! Base:" + base + "\tOriginal sequence: " + bases[i2]);
            }
            ++i2;
        }
    }

    void initRand() {
        this.rand = new Random(20100629L);
    }

    public Markers randomIntervals(int numIntervals, int maxStart, int maxLength, int numChromo) {
        Markers ints = new Markers();
        int ch = 1;
        while (ch <= numChromo) {
            int i = 0;
            while (i < numIntervals) {
                int start = this.rand.nextInt(maxStart);
                int end = Math.min(start + this.rand.nextInt(maxLength), maxStart - 1);
                Marker interval = new Marker(this.genome.getChromosome("" + ch), start, end, 1, "");
                ints.add(interval);
                ++i;
            }
            ++ch;
        }
        return ints;
    }

    public void test_00() {
        this.initRand();
        int len = 1;
        while (len < 1000) {
            this.DnaSequenceBaseAt(len);
            ++len;
        }
    }

    public void test_01() {
        this.initRand();
        Markers intervals = Markers.readTxt("tests/interval_data_100.txt", this.genome);
        this.compareToFile(intervals.toStringTxt(), "tests/test_01.txt");
    }

    public void test_02() {
        this.initRand();
        Markers intervals = this.randomIntervals(10, this.maxLen, 10, 5);
        intervals.sort(false, false);
        this.compareToFile(intervals.toStringTxt(), "tests/test_02.txt");
    }

    public void test_03() {
        this.initRand();
        Markers intervals = this.randomIntervals(100, this.maxLen, 25, 2);
        intervals.sort(true, false);
        this.compareToFile(intervals.toStringTxt(), "tests/test_03.txt");
    }

    public void test_04() {
        this.initRand();
        Markers intervals = this.randomIntervals(20, this.maxLen, 10, 2);
        Markers merge = intervals.merge();
        if (this.verbose) {
            System.out.println("Merge :\n" + merge.toStringAsciiArt(this.maxLen));
        }
        this.compareToFile(merge.toStringTxt(), "tests/test_04.txt");
    }

    public void test_05() {
        this.initRand();
        Markers intervals = this.randomIntervals(5, this.maxLen, 10, 2);
        Markers intervals2 = this.randomIntervals(5, this.maxLen, 10, 2);
        Markers union2 = intervals.union(intervals2);
        this.compareToFile(union2.toStringTxt(), "tests/test_05.txt");
        if (this.verbose) {
            intervals.sort(false, false);
            intervals2.sort(false, false);
            union2.sort(false, false);
            System.out.println("Intervals 1:\n" + intervals.toStringAsciiArt(this.maxLen));
            System.out.println("Intervals 2:\n" + intervals2.toStringAsciiArt(this.maxLen));
            System.out.println("Union :\n" + union2.toStringAsciiArt(this.maxLen));
        }
    }

    public void test_06() {
        int numInts = 10;
        while (numInts < 1000) {
            Markers intervals = this.randomIntervals(numInts, this.maxLen, 20, 2);
            IntervalForest forest = new IntervalForest(intervals);
            if (this.verbose) {
                intervals.sort(false, false);
                System.out.println(intervals.toStringAsciiArt(this.maxLen));
                forest.build();
                System.out.println(forest);
            }
            Markers intervals2 = this.randomIntervals(numInts, this.maxLen, 20, 2);
            for (Marker i : intervals2) {
                Markers intersectBf;
                Markers intersect2 = forest.query(i);
                if (intersect2.equals(intersectBf = intervals.intersects(i))) continue;
                intersect2.sort(false, false);
                intersectBf.sort(false, false);
                String errMsg = "Interval: " + i + "\n\tIntersects  : " + intersect2 + "\n\tIntersectsBf: " + intersectBf;
                System.err.println(errMsg);
                throw new RuntimeException(errMsg);
            }
            numInts *= 2;
        }
    }

    public void test_07_01() {
        Chromosome chr = this.genome.getChromosome("1");
        Markers intervals = new Markers();
        intervals.add(new Marker(chr, 10, 90, 1, ""));
        Markers intervals2 = new Markers();
        intervals2.add(new Marker(chr, 10, 90, 1, ""));
        Markers minus2 = intervals.minus(intervals2);
        TestCasesIntervals.assertEquals(0, minus2.size());
        if (this.verbose) {
            System.out.println(minus2.toStringAsciiArt(this.maxLen));
        }
    }

    public void test_07_02() {
        Chromosome chr = this.genome.getChromosome("1");
        Markers intervals = new Markers();
        intervals.add(new Marker(chr, 10, 90, 1, ""));
        Markers intervals2 = new Markers();
        intervals2.add(new Marker(chr, 9, 91, 1, ""));
        Markers minus2 = intervals.minus(intervals2);
        TestCasesIntervals.assertEquals(0, minus2.size());
        if (this.verbose) {
            System.out.println(minus2.toStringAsciiArt(this.maxLen));
        }
    }

    public void test_07_03() {
        Chromosome chr = this.genome.getChromosome("1");
        Markers intervals = new Markers();
        intervals.add(new Marker(chr, 10, 90, 1, ""));
        Markers intervals2 = new Markers();
        intervals2.add(new Marker(chr, 9, 50, 1, ""));
        Markers minus2 = intervals.minus(intervals2);
        TestCasesIntervals.assertEquals(1, minus2.size());
        Marker minusInt = minus2.iterator().next();
        TestCasesIntervals.assertEquals(51, minusInt.getStart());
        TestCasesIntervals.assertEquals(90, minusInt.getEnd());
        if (this.verbose) {
            System.out.println(minus2.toStringAsciiArt(this.maxLen));
        }
    }

    public void test_07_04() {
        Chromosome chr = this.genome.getChromosome("1");
        Markers intervals = new Markers();
        intervals.add(new Marker(chr, 10, 90, 1, ""));
        Markers intervals2 = new Markers();
        intervals2.add(new Marker(chr, 51, 91, 1, ""));
        Markers minus2 = intervals.minus(intervals2);
        if (this.verbose) {
            System.out.println(minus2.toStringAsciiArt(this.maxLen));
        }
        TestCasesIntervals.assertEquals(1, minus2.size());
        Marker minusInt = minus2.iterator().next();
        TestCasesIntervals.assertEquals(10, minusInt.getStart());
        TestCasesIntervals.assertEquals(50, minusInt.getEnd());
    }

    public void test_07_05() {
        Chromosome chr = this.genome.getChromosome("1");
        Markers intervals = new Markers();
        intervals.add(new Marker(chr, 10, 90, 1, ""));
        Markers intervals2 = new Markers();
        intervals2.add(new Marker(chr, 40, 60, 1, ""));
        Markers minus2 = intervals.minus(intervals2);
        if (this.verbose) {
            System.out.println(minus2.toStringAsciiArt(this.maxLen));
        }
        TestCasesIntervals.assertEquals(2, minus2.size());
        Iterator<Marker> it = minus2.iterator();
        Marker minusInt = it.next();
        TestCasesIntervals.assertEquals(10, minusInt.getStart());
        TestCasesIntervals.assertEquals(39, minusInt.getEnd());
        minusInt = it.next();
        TestCasesIntervals.assertEquals(61, minusInt.getStart());
        TestCasesIntervals.assertEquals(90, minusInt.getEnd());
    }
}

