/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases;

import ca.mcgill.mcb.pcingola.binseq.DnaAndQualitySequence;
import ca.mcgill.mcb.pcingola.binseq.DnaSequence;
import ca.mcgill.mcb.pcingola.binseq.comparator.DnaQualSubsequenceComparator;
import ca.mcgill.mcb.pcingola.binseq.comparator.DnaSubsequenceComparator;
import ca.mcgill.mcb.pcingola.binseq.comparator.SequenceReference;
import ca.mcgill.mcb.pcingola.binseq.indexer.SequenceIndexer;
import ca.mcgill.mcb.pcingola.binseq.indexer.SuffixIndexerNmer;
import ca.mcgill.mcb.pcingola.fastq.Fastq;
import ca.mcgill.mcb.pcingola.fastq.FastqVariant;
import ca.mcgill.mcb.pcingola.fileIterator.FastaFileIterator;
import ca.mcgill.mcb.pcingola.fileIterator.FastqFileIterator;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.ArrayList;
import java.util.Collections;
import junit.framework.TestCase;

public class TestCaseSequenceIndexer
extends TestCase {
    public static final int NMER_SIZE = 15;
    public static int NUMBER_OF_COMPARISSONS = 100000;
    SequenceIndexer<DnaAndQualitySequence> seqIndex;
    ArrayList<Long> references;

    void readFile(String fastqFileName) {
        this.seqIndex = new SequenceIndexer<DnaAndQualitySequence>(new DnaQualSubsequenceComparator(false));
        this.references = new ArrayList();
        int referencesPerSequence = 10;
        int seqIdx = 0;
        for (Fastq fastq : new FastqFileIterator(fastqFileName, FastqVariant.FASTQ_ILLUMINA)) {
            String seq2 = fastq.getSequence();
            if (seq2.indexOf(78) >= 0) continue;
            String qual = fastq.getQuality();
            DnaAndQualitySequence bseq = new DnaAndQualitySequence(seq2, qual, FastqVariant.FASTQ_ILLUMINA);
            this.seqIndex.add(bseq);
            int i = 0;
            while (i < referencesPerSequence) {
                int start = (int)(Math.random() * (double)bseq.length());
                long ref = SequenceReference.getReference(seqIdx, start);
                this.references.add(ref);
                ++i;
            }
            ++seqIdx;
        }
    }

    public void test_01() {
        this.readFile("tests/indexer_test_01.fastq");
        int i = 0;
        while (i < NUMBER_OF_COMPARISSONS) {
            long ref1 = this.references.get((int)(Math.random() * (double)this.references.size()));
            long ref2 = this.references.get((int)(Math.random() * (double)this.references.size()));
            int comp = this.seqIndex.compare(ref1, ref2);
            DnaAndQualitySequence seq1 = this.seqIndex.get(SequenceReference.getSeqIdx(ref1));
            DnaAndQualitySequence seq2 = this.seqIndex.get(SequenceReference.getSeqIdx(ref2));
            int start1 = SequenceReference.getStart(ref1);
            int start2 = SequenceReference.getStart(ref2);
            String subseq1 = seq1.getSequence().substring(start1);
            String subseq2 = seq2.getSequence().substring(start2);
            int comp2 = subseq1.compareTo(subseq2);
            if (Math.signum(comp) != Math.signum(comp2)) {
                throw new RuntimeException("Comparing references: " + ref1 + ", " + ref2 + "\t" + comp + " != " + comp2 + "\n\tseq1:\t" + seq1 + "\n\tseq2:\t" + seq2 + "\n\tsubseq1:\t" + subseq1 + "\n\tsubseq2:\t" + subseq2);
            }
            ++i;
        }
    }

    public void test_02() {
        this.readFile("tests/indexer_test_01.fastq");
        String latest = "";
        Collections.sort(this.references, this.seqIndex);
        for (Long ref : this.references) {
            DnaAndQualitySequence seq2 = this.seqIndex.get(SequenceReference.getSeqIdx(ref));
            int start = SequenceReference.getStart(ref);
            Math.min(seq2.length() - start, latest.length());
            String subseq = seq2.getSequence().substring(start);
            if (subseq.compareTo(latest) < 0) {
                throw new RuntimeException("References out of order!\n\t" + SequenceReference.getSeqIdx(ref) + ":" + SequenceReference.getStart(ref) + "\t" + ref + "\t" + subseq + "\n\tLatest: " + latest);
            }
            latest = subseq;
        }
    }

    public void test_03() {
        System.out.println("\n\nSuffixIndexerNmer: Add test");
        String fastqFileName = "tests/short.fastq";
        SuffixIndexerNmer<DnaAndQualitySequence> seqIndexNmer = new SuffixIndexerNmer<DnaAndQualitySequence>(new DnaQualSubsequenceComparator(true), 15);
        for (Fastq fastq : new FastqFileIterator(fastqFileName, FastqVariant.FASTQ_ILLUMINA)) {
            String seq2 = fastq.getSequence();
            if (seq2.indexOf(78) >= 0) continue;
            String qual = fastq.getQuality();
            DnaAndQualitySequence bseq = new DnaAndQualitySequence(seq2, qual, FastqVariant.FASTQ_ILLUMINA);
            seqIndexNmer.add(bseq);
        }
        seqIndexNmer.sanityCheck();
    }

    public void test_04() {
        System.out.println("\n\nSuffixIndexerNmer: Add & overlap test");
        String fastqFileName = "tests/short.fastq";
        SuffixIndexerNmer<DnaAndQualitySequence> seqIndexNmer = new SuffixIndexerNmer<DnaAndQualitySequence>(new DnaQualSubsequenceComparator(true), 15);
        for (Fastq fastq : new FastqFileIterator(fastqFileName, FastqVariant.FASTQ_ILLUMINA)) {
            String seq2 = fastq.getSequence();
            if (seq2.indexOf(78) >= 0) continue;
            String qual = fastq.getQuality();
            DnaAndQualitySequence bseq = new DnaAndQualitySequence(seq2, qual, FastqVariant.FASTQ_ILLUMINA);
            seqIndexNmer.add(bseq);
            boolean joined = seqIndexNmer.overlap(bseq);
            if (joined) continue;
            seqIndexNmer.add(bseq);
        }
        seqIndexNmer.sanityCheck();
    }

    public void test_05() {
        System.out.println("\n\nSuffixIndexerNmer: Building the first 5K bases from A.Thaliana's genome");
        String fileName = "tests/a_thaliana_test/assembly_test.fa";
        String result2 = Gpr.readFile("tests/a_thaliana_test/assembly_test.result");
        SuffixIndexerNmer<DnaAndQualitySequence> seqIndex = new SuffixIndexerNmer<DnaAndQualitySequence>(new DnaQualSubsequenceComparator(true), 15);
        for (String seq2 : new FastaFileIterator(fileName)) {
            DnaAndQualitySequence bseq = new DnaAndQualitySequence(seq2);
            boolean joined = seqIndex.overlap(bseq);
            if (joined) continue;
            seqIndex.add(bseq);
        }
        DnaAndQualitySequence bseq = (DnaAndQualitySequence)seqIndex.get(1);
        TestCaseSequenceIndexer.assertEquals(result2.trim().toUpperCase(), bseq.getSequence().trim().toUpperCase());
    }

    public void test_06() {
        String[] seqStr = new String[]{"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"};
        SuffixIndexerNmer<DnaSequence> seqIndex = new SuffixIndexerNmer<DnaSequence>(new DnaSubsequenceComparator(true, 0), 15);
        int i = 0;
        while (i < seqStr.length) {
            DnaSequence bseq = new DnaSequence(seqStr[i]);
            if (!seqIndex.overlap(bseq)) {
                seqIndex.add(bseq);
            }
            ++i;
        }
        TestCaseSequenceIndexer.assertEquals(seqStr[0], ((DnaSequence)seqIndex.get(1)).getSequence());
    }

    public void test_07() {
        int nmerSize = 32;
        String[] seqStr = new String[]{"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaac", "caaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"};
        SuffixIndexerNmer<DnaSequence> seqIndex = new SuffixIndexerNmer<DnaSequence>(new DnaSubsequenceComparator(true, 0), nmerSize);
        int i = 0;
        while (i < seqStr.length) {
            DnaSequence bseq = new DnaSequence(seqStr[i]);
            if (!seqIndex.overlap(bseq)) {
                seqIndex.add(bseq);
            }
            ++i;
        }
        TestCaseSequenceIndexer.assertEquals("caaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaac", ((DnaSequence)seqIndex.get(1)).getSequence());
    }

    public void test_08() {
        int nmerSize = 32;
        String[] seqStr = new String[]{"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaac"};
        SuffixIndexerNmer<DnaSequence> seqIndex = new SuffixIndexerNmer<DnaSequence>(new DnaSubsequenceComparator(true, 0), nmerSize);
        int i = 0;
        while (i < seqStr.length) {
            DnaSequence bseq = new DnaSequence(seqStr[i]);
            if (!seqIndex.overlap(bseq)) {
                seqIndex.add(bseq);
            }
            ++i;
        }
        TestCaseSequenceIndexer.assertEquals("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaac", ((DnaSequence)seqIndex.get(1)).getSequence());
    }

    public void test_09() {
        int nmerSize = 32;
        String[] seqStr = new String[]{"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "caaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"};
        SuffixIndexerNmer<DnaSequence> seqIndex = new SuffixIndexerNmer<DnaSequence>(new DnaSubsequenceComparator(true, 0), nmerSize);
        int i = 0;
        while (i < seqStr.length) {
            DnaSequence bseq = new DnaSequence(seqStr[i]);
            if (!seqIndex.overlap(bseq)) {
                seqIndex.add(bseq);
            }
            ++i;
        }
        TestCaseSequenceIndexer.assertEquals("caaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", ((DnaSequence)seqIndex.get(1)).getSequence());
    }

    public void test_10() {
        int nmerSize = 32;
        String[] seqStr = new String[]{"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "caaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaag"};
        SuffixIndexerNmer<DnaSequence> seqIndex = new SuffixIndexerNmer<DnaSequence>(new DnaSubsequenceComparator(true, 0), nmerSize);
        int i = 0;
        while (i < seqStr.length) {
            DnaSequence bseq = new DnaSequence(seqStr[i]);
            if (!seqIndex.overlap(bseq)) {
                seqIndex.add(bseq);
            }
            ++i;
        }
        TestCaseSequenceIndexer.assertEquals("caaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaag", ((DnaSequence)seqIndex.get(1)).getSequence());
    }
}

