/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases;

import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.List;

public class CreateSpliceSiteTestCase {
    StringBuilder out = new StringBuilder();

    public static void main(String[] args) {
        CreateSpliceSiteTestCase zzz = new CreateSpliceSiteTestCase();
        zzz.run();
    }

    void out(Exon exon, int from2, int to2, ChangeEffect.EffectType type) {
        StringBuilder sb = new StringBuilder();
        int i = from2;
        while (i <= to2) {
            sb.append(String.valueOf(exon.getChromosomeName()) + "\t" + (i + 1) + "\tA\tC\t+\t0\t0\t" + (Object)((Object)type) + "\n");
            ++i;
        }
        System.out.print(sb);
        this.out.append(sb.toString());
    }

    public void run() {
        Gpr.debug("Loading config files");
        Config config = new Config("testCase", "snpEff.config");
        config.loadSnpEffectPredictor();
        for (Gene gint : config.getGenome().getGenes()) {
            for (Transcript tr : gint) {
                List exons = tr.sortedStrand();
                for (Exon eint : exons) {
                    if (eint.size() <= 2) continue;
                    if (gint.getStrand() >= 0) {
                        if (eint.getRank() > 1) {
                            this.out(eint, eint.getStart() - 2, eint.getStart() - 1, ChangeEffect.EffectType.SPLICE_SITE_ACCEPTOR);
                        } else {
                            this.out(eint, eint.getStart() - 2, eint.getStart() - 1, ChangeEffect.EffectType.UPSTREAM);
                        }
                        if (eint.getRank() < exons.size()) {
                            this.out(eint, eint.getEnd() + 1, eint.getEnd() + 2, ChangeEffect.EffectType.SPLICE_SITE_DONOR);
                            continue;
                        }
                        this.out(eint, eint.getEnd() + 1, eint.getEnd() + 2, ChangeEffect.EffectType.DOWNSTREAM);
                        continue;
                    }
                    if (eint.getRank() > 1) {
                        this.out(eint, eint.getEnd() + 1, eint.getEnd() + 2, ChangeEffect.EffectType.SPLICE_SITE_ACCEPTOR);
                    } else {
                        this.out(eint, eint.getEnd() + 1, eint.getEnd() + 2, ChangeEffect.EffectType.UPSTREAM);
                    }
                    if (eint.getRank() < exons.size()) {
                        this.out(eint, eint.getStart() - 2, eint.getStart() - 1, ChangeEffect.EffectType.SPLICE_SITE_DONOR);
                        continue;
                    }
                    this.out(eint, eint.getStart() - 2, eint.getStart() - 1, ChangeEffect.EffectType.DOWNSTREAM);
                }
            }
        }
        Gpr.toFile("/tmp/CreateSpliceSiteTestCase.txt", this.out.toString());
    }
}

