/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.factory;

import ca.mcgill.mcb.pcingola.interval.Cds;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactory;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.BufferedReader;
import java.util.HashMap;

public class SnpEffPredictorFactoryRefSeq
extends SnpEffPredictorFactory {
    private final HashMap<String, String> biotypeById = new HashMap();
    public static final String CDS_STAT_COMPLETE = "cmpl";
    int ignoredTr = 0;

    public SnpEffPredictorFactoryRefSeq(Config config) {
        super(config, 0);
        this.biotypeById.put("AC", "Alternate_Genomic");
        this.biotypeById.put("AP", "Alternate_Protein");
        this.biotypeById.put("NC", "Genomic   ");
        this.biotypeById.put("NG", "Incomplete_Genomic");
        this.biotypeById.put("NM", "mRNA");
        this.biotypeById.put("NP", "Protein");
        this.biotypeById.put("NR", "Non-coding_transcript");
        this.biotypeById.put("NT", "Intermediate_Genomic");
        this.biotypeById.put("NW", "Intermediate_Genomic");
        this.biotypeById.put("NZ", "Genomic");
        this.biotypeById.put("XM", "mRNA");
        this.biotypeById.put("XP", "Protein");
        this.biotypeById.put("XR", "Non-coding_transcript");
        this.biotypeById.put("YP", "Protein");
        this.biotypeById.put("ZP", "Protein");
        this.biotypeById.put("NS", "Genomic");
    }

    String bioType(String id) {
        if (id.length() < 2) {
            return "";
        }
        String key = id.substring(0, 2);
        String biotype = this.biotypeById.get(key);
        return biotype != null ? biotype : "";
    }

    @Override
    public SnpEffectPredictor create() {
        this.fileName = String.valueOf(this.config.getBaseFileNameGenes()) + ".txt";
        System.out.println("Reading gene intervals file : '" + this.fileName + "'");
        this.readRefSeqFile();
        this.beforeExonSequences();
        this.readExonSequences();
        this.finishUp(false);
        boolean error = this.config.getGenome().showStats();
        System.out.println("# Ignored transcripts        : " + this.ignoredTr);
        if (error) {
            throw new RuntimeException("Most Exons do not have sequences!");
        }
        return this.snpEffectPredictor;
    }

    boolean isProteinCoding(String id) {
        String biotype = this.bioType(id).toLowerCase();
        return biotype.equals("mrna") || biotype.equals("protein");
    }

    protected void readRefSeqFile() {
        try {
            int count2 = 0;
            BufferedReader reader = Gpr.reader(this.fileName);
            if (reader == null) {
                return;
            }
            this.lineNum = 1;
            while (reader.ready()) {
                String[] fields;
                this.line = reader.readLine();
                if (!this.line.startsWith("#") && (fields = this.line.split("\t")).length >= 16) {
                    String id = fields[1];
                    String chromoName = fields[2];
                    int strand = fields[3].equals("-") ? -1 : 1;
                    int txstart = this.parsePosition(fields[4]);
                    int txend = this.parsePosition(fields[5]) - 1;
                    int cdsStart = this.parsePosition(fields[6]);
                    int cdsEnd = this.parsePosition(fields[7]) - 1;
                    int exonCount = Gpr.parseIntSafe(fields[8]);
                    String exonStarts = fields[9];
                    String exonEnds = fields[10];
                    String geneName = fields[12];
                    String cdsStartStat = fields[13];
                    String cdsEndStat = fields[14];
                    String exonFrames = fields[15];
                    Chromosome chromo = this.getOrCreateChromosome(chromoName);
                    String geneId = String.valueOf(geneName) + "." + chromo.getId();
                    Gene gene = (Gene)this.genesById.get(geneId);
                    if (gene == null) {
                        gene = new Gene(chromo, txstart, txend, strand, geneId, geneName, this.bioType(id));
                        this.genesById.put(geneId, gene);
                        this.snpEffectPredictor.add(gene);
                    }
                    String trId = this.uniqueTrId(id);
                    Transcript tr = new Transcript(gene, txstart, txend, strand, trId);
                    boolean markAsCoding = this.isProteinCoding(id) && cdsStartStat.equals(CDS_STAT_COMPLETE) && cdsEndStat.equals(CDS_STAT_COMPLETE);
                    tr.setProteinCoding(markAsCoding);
                    this.add(tr);
                    String[] exStartStr = exonStarts.split(",");
                    String[] exEndStr = exonEnds.split(",");
                    String[] exFrameStr = exonFrames.split(",");
                    int i = 0;
                    while (i < exonCount) {
                        int exStart = this.parsePosition(exStartStr[i]);
                        int exEnd = this.parsePosition(exEndStr[i]) - 1;
                        int exFrame = Gpr.parseIntSafe(exFrameStr[i]);
                        String exId = String.valueOf(trId) + ".ex." + (i + 1);
                        Exon ex = new Exon(tr, exStart, exEnd, strand, exId, i);
                        ex.setFrame(exFrame);
                        this.add(ex);
                        if (exStart <= cdsEnd && exEnd >= cdsStart) {
                            Cds cds = new Cds(tr, Math.max(cdsStart, exStart), Math.min(cdsEnd, exEnd), strand, exId);
                            this.add(cds);
                        }
                        ++i;
                    }
                    if (++count2 % 1000 == 0) {
                        System.out.print('.');
                    }
                    if (count2 % 100000 == 0) {
                        System.out.print("\n\t");
                    }
                }
                ++this.lineNum;
            }
            reader.close();
        }
        catch (Exception e) {
            Gpr.debug("Offending line (lineNum: " + this.lineNum + "): '" + this.line + "'");
            throw new RuntimeException(e);
        }
    }

    String uniqueTrId(String id) {
        if (!this.transcriptsById.containsKey(id)) {
            return id;
        }
        int i = 2;
        String trId;
        while (this.transcriptsById.containsKey(trId = String.valueOf(id) + "." + i)) {
            ++i;
        }
        return trId;
    }
}

