/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.factory;

import ca.mcgill.mcb.pcingola.genBank.Feature;
import ca.mcgill.mcb.pcingola.genBank.Features;
import ca.mcgill.mcb.pcingola.interval.Cds;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactory;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.GprSeq;

public abstract class SnpEffPredictorFactoryFeatures
extends SnpEffPredictorFactory {
    public static final int OFFSET = 1;
    Chromosome chromosome;

    public SnpEffPredictorFactoryFeatures(Config config) {
        super(config, 1);
    }

    protected void addFeatures(Features features) {
        String trId;
        int end;
        int start;
        for (Feature f2 : features.getFeatures()) {
            start = f2.getStart() - this.inOffset;
            end = f2.getEnd() - this.inOffset;
            if (f2.getType() != Feature.Type.SOURCE) continue;
            if (this.chromosome != null) {
                throw new RuntimeException("SOURCE already assigned to chromosome");
            }
            this.chromosome = new Chromosome(this.genome, start, end, 1, this.chromoName(f2));
            this.add(this.chromosome);
        }
        if (this.chromosome == null) {
            throw new RuntimeException("Could not find SOURCE feature");
        }
        for (Feature f2 : features.getFeatures()) {
            if (f2.getType() != Feature.Type.GENE) continue;
            this.findOrCreateGene(f2, this.chromosome, false);
        }
        for (Feature f2 : features.getFeatures()) {
            if (f2.getType() != Feature.Type.MRNA) continue;
            start = f2.getStart() - this.inOffset;
            end = f2.getEnd() - this.inOffset;
            trId = this.getTrId(f2);
            Gene gene = this.findOrCreateGene(f2, this.chromosome, false);
            Transcript tr = new Transcript(gene, start, end, f2.isComplement() ? -1 : 1, trId);
            this.add(tr);
        }
        for (Feature f2 : features.getFeatures()) {
            if (f2.getType() != Feature.Type.CDS) continue;
            start = f2.getStart() - this.inOffset;
            end = f2.getEnd() - this.inOffset;
            trId = this.getTrId(f2);
            Transcript tr = this.findTranscript(trId);
            if (tr == null) {
                if (this.verbose) {
                    System.err.println("WARNING: Transcript '" + trId + "' not found. Creating new transcript." + f2);
                }
                Gene gene = this.findOrCreateGene(f2, this.chromosome, false);
                trId = "Tr_" + start + "_" + end;
                tr = new Transcript(gene, start, end, f2.isComplement() ? -1 : 1, trId);
                this.add(tr);
            }
            if (f2.get("translation") != null) {
                tr.setProteinCoding(true);
            }
            Cds cds = new Cds(tr, f2.getStart() - this.inOffset, f2.getEnd() - this.inOffset, f2.isComplement() ? -1 : 1, "CDS_" + trId);
            this.add(cds);
        }
    }

    String chromoName(Feature f2) {
        if (f2.getType() != Feature.Type.SOURCE) {
            throw new RuntimeException("Cannot find chromosome name in a non-SOURCE feature");
        }
        String chrName = f2.get("chromosome");
        return chrName != null ? chrName : this.genome.getId();
    }

    @Override
    public SnpEffectPredictor create() {
        System.out.println("Reading data file  : '" + this.fileName + "'");
        try {
            Features features = this.readFeatures();
            this.addFeatures(features);
            this.beforeExonSequences();
            String sequence2 = this.sequence(features);
            this.addExonSequences(this.chromosome.getId(), sequence2);
            this.finishUp(false);
            boolean error = this.config.getGenome().showStats();
            if (error) {
                throw new RuntimeException("Most Exons do not have sequences!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error reading file '" + this.fileName + "'\n" + e);
        }
        return this.snpEffectPredictor;
    }

    Gene findOrCreateGene(Feature f2, Chromosome chr, boolean warn) {
        int start = f2.getStart() - this.inOffset;
        int end = f2.getEnd() - this.inOffset;
        String geneId = this.geneId(f2, start, end);
        String geneName = this.geneName(f2, start, end);
        Gene gene = this.findGene(geneId);
        if (gene == null) {
            gene = new Gene(chr, start, end, f2.isComplement() ? -1 : 1, geneId, geneName, "");
            this.add(gene);
            if (warn) {
                System.err.println("WARNING: Gene '" + geneId + "' not found");
            }
        }
        return gene;
    }

    protected String geneId(Feature f2, int start, int end) {
        String geneId = f2.get("locus_tag");
        if (geneId != null) {
            return geneId;
        }
        geneId = f2.get("db_xref");
        if (geneId != null) {
            return geneId;
        }
        geneId = f2.get("gene");
        if (geneId != null) {
            return geneId;
        }
        return "Gene_" + start + "_" + end;
    }

    protected String geneName(Feature f2, int start, int end) {
        String geneName = f2.get("gene");
        if (geneName != null) {
            return geneName;
        }
        geneName = f2.get("locus_tag");
        if (geneName != null) {
            return geneName;
        }
        return "Gene_" + start + "_" + end;
    }

    protected String getTrId(Feature f2) {
        String id = f2.get("product");
        if (id != null) {
            id = id.replaceAll("\\s", "_");
        }
        if (id == null || id.length() > 20 && f2.get("gene") != null) {
            return "Tr_" + f2.get("gene");
        }
        return id;
    }

    protected abstract Features readFeatures();

    String sequence(Features features) {
        String seq2 = features.getSequence();
        if (seq2 != null && !seq2.isEmpty()) {
            return seq2;
        }
        if (this.verbose) {
            System.out.println("No sequence found in feature file.");
        }
        for (String fastaFile : this.config.getFileListGenomeFasta()) {
            if (this.verbose) {
                System.out.println("\tTrying fasta file '" + fastaFile + "'");
            }
            if (!Gpr.canRead(fastaFile) || (seq2 = GprSeq.fastaSimpleRead(fastaFile)) == null || seq2.isEmpty()) continue;
            return seq2;
        }
        throw new RuntimeException("Cannot find sequence for '" + this.config.getGenome().getVersion() + "'");
    }
}

