/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.commandLine;

import ca.mcgill.mcb.pcingola.fileIterator.FastaFileIterator;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import java.util.HashMap;

public class SnpEffCmdProtein
extends SnpEff {
    public static boolean onlyOneError = false;
    public static double maxErrorPercentage = 0.01;
    boolean verbose = false;
    int totalErrors = 0;
    int totalOk = 0;
    int totalWarnings = 0;
    int totalNotFound = 0;
    String configFile = "snpEff.config";
    String genomeVer = "";
    String proteinFile = "";
    Config config;
    HashMap<String, String> proteinByTrId;

    public static int diffCount(String s1, String s2) {
        int minLen = Math.min(s1.length(), s2.length());
        int count2 = 0;
        int j = 0;
        while (j < minLen) {
            if (s1.charAt(j) != s2.charAt(j)) {
                ++count2;
            }
            ++j;
        }
        return count2;
    }

    public static String diffStr(String s1, String s2) {
        int minLen = Math.min(s1.length(), s2.length());
        char[] diff2 = new char[minLen];
        int j = 0;
        while (j < minLen) {
            diff2[j] = s1.charAt(j) != s2.charAt(j) ? 124 : 32;
            ++j;
        }
        return new String(diff2);
    }

    public SnpEffCmdProtein() {
    }

    public SnpEffCmdProtein(Config config) {
        this.config = config;
        this.proteinFile = config.getFileNameProteins();
    }

    public SnpEffCmdProtein(String genomeVer, String configFile, String proteinFile) {
        this.configFile = configFile;
        this.genomeVer = genomeVer;
        this.proteinFile = proteinFile;
    }

    void add(String trId, String seq2, int lineNum) {
        if (this.proteinByTrId.get(trId) != null && !this.proteinByTrId.get(trId).equals(seq2)) {
            System.err.println("ERROR: Different protein for the same transcript ID. This should never happen!!!\n\tLine number   : " + lineNum + "\n\tTranscript ID : '" + trId + "'" + "\n\tProtein       : " + this.proteinByTrId.get(trId) + "\n\tProtein (new) : " + seq2);
        }
        if (trId.indexOf(32) > 0) {
            trId = trId.split("\\s")[0];
        }
        this.proteinByTrId.put(trId, seq2);
    }

    boolean equals(String protein, String proteinRef) {
        if (protein.isEmpty() && proteinRef.isEmpty()) {
            return true;
        }
        if ((protein = this.proteinFormat(protein)).equals(proteinRef = this.proteinFormat(proteinRef))) {
            return true;
        }
        String refUnk = "";
        if (proteinRef.length() > 0 && protein.equals(refUnk = proteinRef.substring(0, proteinRef.length() - 1))) {
            return true;
        }
        String proteinNoStart = "";
        String refNoStart = "";
        if (protein.length() > 0 && proteinRef.length() > 0 && (proteinNoStart = protein.substring(1)).equals(refNoStart = proteinRef.substring(1))) {
            return true;
        }
        String proteinU = protein.replace('*', 'U');
        if (proteinU.equals(proteinRef) || proteinU.equals(refUnk)) {
            return true;
        }
        String proteinNoStartU = proteinNoStart.replace('*', 'U');
        return proteinNoStartU.equals(refNoStart);
    }

    public int getTotalErrors() {
        return this.totalErrors;
    }

    public int getTotalOk() {
        return this.totalOk;
    }

    @Override
    public void parseArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith("-")) {
                if (args[i].equals("-c") || args[i].equalsIgnoreCase("-config")) {
                    if (i + 1 < args.length) {
                        this.configFile = args[++i];
                    } else {
                        this.usage("Option '-c' without config file argument");
                    }
                } else if (args[i].equals("-v") || args[i].equalsIgnoreCase("-verbose")) {
                    this.verbose = true;
                } else {
                    this.usage("Unknow option '" + args[i] + "'");
                }
            } else if (this.genomeVer.isEmpty()) {
                this.genomeVer = args[i];
            } else if (this.proteinFile.isEmpty()) {
                this.proteinFile = args[i];
            } else {
                this.usage("Unknow parameter '" + args[i] + "'");
            }
            ++i;
        }
        if (this.genomeVer.isEmpty()) {
            this.usage("Missing genomer_version parameter");
        }
        if (this.proteinFile.isEmpty()) {
            this.usage("Missing protein_file parameter");
        }
    }

    double proteinCompare() {
        int i = 1;
        for (Gene gene : this.config.getGenome().getGenes()) {
            for (Transcript tr : gene) {
                String protein = tr.protein();
                String proteinReference = this.proteinByTrId.get(tr.getId());
                if (proteinReference == null) {
                    if (tr.isProteinCoding()) {
                        ++this.totalNotFound;
                        if (this.verbose) {
                            System.err.println("\nWARNING:Cannot find Protein for transcript " + tr.getId());
                        } else {
                            System.out.print('-');
                        }
                    }
                } else if (this.equals(protein, proteinReference)) {
                    ++this.totalOk;
                    if (!this.verbose) {
                        System.out.print('+');
                    }
                } else {
                    if (this.verbose || onlyOneError) {
                        protein = this.proteinFormat(protein);
                        proteinReference = this.proteinFormat(proteinReference);
                        String diffStr = SnpEffCmdProtein.diffStr(protein, proteinReference);
                        int countDiff = SnpEffCmdProtein.diffCount(protein, proteinReference);
                        System.err.println("\nERROR:Protein sequence does not match:\n\tTranscript " + tr.getId() + "\t, Gene: " + ((Gene)tr.getParent()).getGeneName() + "\t, Strand:" + tr.getStrand() + "\t, Exons: " + tr.numChilds() + "\n\tsnpEff    (" + protein.length() + "):\t" + protein.toLowerCase() + "\n\tReference (" + proteinReference.length() + "):\t" + this.proteinFormat(proteinReference).toLowerCase() + "\n\tdiff      (" + countDiff + "):\t" + diffStr + "\n\tTranscript details:\t" + tr);
                    } else if (!this.verbose) {
                        System.out.print('*');
                    }
                    ++this.totalErrors;
                    if (onlyOneError) {
                        System.err.println("Transcript details:\n" + tr);
                        throw new RuntimeException("DIE");
                    }
                }
                if (!this.verbose && i % 100 == 0) {
                    System.out.print("\n\t");
                }
                ++i;
            }
        }
        double perc = (double)this.totalErrors / (double)(this.totalErrors + this.totalOk);
        System.out.println("\nProtein check:\t" + this.config.getGenome().getVersion() + "\tOK: " + this.totalOk + "\tWarnings: " + this.totalWarnings + "\tNot found: " + this.totalNotFound + "\tErrors: " + this.totalErrors + "\tError percentage: " + 100.0 * perc + "%");
        return perc;
    }

    String proteinFormat(String protein) {
        int idxLast;
        if (protein.isEmpty()) {
            return "";
        }
        char lastChar = (protein = protein.toUpperCase()).charAt(idxLast = protein.length() - 1);
        if (lastChar == '*' || lastChar == '?') {
            protein = protein.substring(0, idxLast);
        }
        protein = protein.replace('X', '?');
        return protein;
    }

    void readProteinFile() {
        this.proteinByTrId = new HashMap();
        if (this.proteinFile.endsWith("txt") || this.proteinFile.endsWith("txt.gz")) {
            this.readProteinFileTxt();
        } else {
            this.readProteinFileFasta();
        }
    }

    void readProteinFileFasta() {
        FastaFileIterator ffi = new FastaFileIterator(this.proteinFile);
        for (String seq2 : ffi) {
            String trId = ffi.getTranscriptId();
            this.add(trId, seq2, ffi.getLineNum());
        }
    }

    void readProteinFileTxt() {
        String proteinData = Gpr.readFile(this.proteinFile);
        String[] proteinLines = proteinData.split("\n");
        int lineNum = 1;
        String[] stringArray = proteinLines;
        int n = proteinLines.length;
        int n2 = 0;
        while (n2 < n) {
            String proteinLine = stringArray[n2];
            String[] field2 = proteinLine.split("\\s+");
            if (field2.length >= 2) {
                String seq2 = field2[1].trim();
                String trId = field2[0].trim();
                this.add(trId, seq2, lineNum);
            }
            ++lineNum;
            ++n2;
        }
    }

    @Override
    public boolean run() {
        if (this.verbose) {
            Timer.showStdErr("Checking database using CDS sequences");
        }
        if (this.config == null) {
            if (this.verbose) {
                Timer.showStdErr("Reading configuration...");
            }
            this.config = new Config(this.genomeVer, this.configFile);
            if (this.verbose) {
                Timer.showStdErr("done");
            }
        }
        if (this.verbose) {
            Timer.showStdErr("Reading proteins from file '" + this.proteinFile + "'...");
        }
        this.readProteinFile();
        if (this.verbose) {
            Timer.showStdErr("done (" + this.proteinByTrId.size() + " Proteins).");
        }
        if (this.config.getSnpEffectPredictor() == null) {
            if (this.verbose) {
                Timer.showStdErr("Reading database...");
            }
            this.config.loadSnpEffectPredictor();
            if (this.verbose) {
                Timer.showStdErr("done");
            }
        }
        if (this.verbose) {
            Timer.showStdErr("Comparing Protein...");
        }
        this.proteinCompare();
        if (this.verbose) {
            Timer.showStdErr("done");
        }
        return true;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error: " + message + "\n");
        }
        System.err.println("snpEff version SnpEff 3.0c (build 2012-07-30), by Pablo Cingolani");
        System.err.println("Usage: snpEff protein [options] genome_version proteing_file");
        System.err.println("\nOptions:");
        System.err.println("\t-c , -config            : Specify config file");
        System.err.println("\t-noLog                  : Do not report usage statistics to server");
        System.err.println("\t-v , -verbose           : Verbose mode");
        System.exit(-1);
    }
}

