/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.commandLine;

import akka.actor.Actor;
import akka.actor.Props;
import akka.actor.UntypedActorFactory;
import ca.mcgill.mcb.pcingola.akka.vcf.VcfWorkQueue;
import ca.mcgill.mcb.pcingola.fileIterator.SeqChangeBedFileIterator;
import ca.mcgill.mcb.pcingola.fileIterator.SeqChangeFileIterator;
import ca.mcgill.mcb.pcingola.fileIterator.SeqChangeFilePileUp;
import ca.mcgill.mcb.pcingola.fileIterator.SeqChangeFileTxt;
import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.filter.ChangeEffectFilter;
import ca.mcgill.mcb.pcingola.filter.SeqChangeFilter;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Custom;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Regulation;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.interval.codonChange.CodonChange;
import ca.mcgill.mcb.pcingola.interval.tree.IntervalForest;
import ca.mcgill.mcb.pcingola.outputFormatter.BedAnnotationOutputFormatter;
import ca.mcgill.mcb.pcingola.outputFormatter.BedOutputFormatter;
import ca.mcgill.mcb.pcingola.outputFormatter.OutputFormatter;
import ca.mcgill.mcb.pcingola.outputFormatter.TxtOutputFormatter;
import ca.mcgill.mcb.pcingola.outputFormatter.VcfOutputFormatter;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.eff.MasterEff;
import ca.mcgill.mcb.pcingola.stats.ChangeEffectResutStats;
import ca.mcgill.mcb.pcingola.stats.SeqChangeStats;
import ca.mcgill.mcb.pcingola.stats.VcfStats;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public class SnpEffCmdEff
extends SnpEff {
    public static final String SUMMARY_TEMPLATE = "snpEff_summary.ftl";
    public static final String SUMMARY_GENES_TEMPLATE = "snpEff_genes.ftl";
    boolean canonical = false;
    boolean supressOutput = false;
    boolean createSummary = true;
    boolean useLocalTemplate = false;
    Boolean treatAllAsProteinCoding = null;
    boolean chromoPlots = true;
    boolean onlyRegulation = false;
    int upDownStreamLength = 5000;
    int totalErrs = 0;
    long countInputLines = 0L;
    long countVariants = 0L;
    long countEffects = 0L;
    long countVariantsFilteredOut = 0L;
    String chrStr = "";
    String inputFile = "";
    String summaryFile = "snpEff_summary.html";
    String summaryGenesFile = "snpEff_genes.txt";
    SeqChangeFilter seqChangeFilter;
    SnpEff.InputFormat inputFormat = SnpEff.InputFormat.VCF;
    SnpEff.OutputFormat outputFormat = SnpEff.OutputFormat.VCF;
    ChangeEffectFilter changeEffectResutFilter;
    ArrayList<String> filterIntervalFiles;
    IntervalForest filterIntervals;
    ArrayList<String> customIntervalFiles;
    SeqChangeStats seqChangeStats;
    ChangeEffectResutStats changeEffectResutStats;
    VcfStats vcfStats;
    HashSet<String> regulationTracks = new HashSet();

    public SnpEffCmdEff() {
        this.seqChangeFilter = new SeqChangeFilter();
        this.changeEffectResutFilter = new ChangeEffectFilter();
        this.filterIntervalFiles = new ArrayList();
        this.filterIntervals = new IntervalForest();
        this.customIntervalFiles = new ArrayList();
    }

    public ChangeEffectResutStats getChangeEffectResutStats() {
        return this.changeEffectResutStats;
    }

    public SeqChangeStats getSeqChangeStats() {
        return this.seqChangeStats;
    }

    void iterateSeqChange(OutputFormatter outputFormatter) {
        SeqChangeFileIterator seqChangeFileIterator;
        SnpEffectPredictor snpEffectPredictor = this.config.getSnpEffectPredictor();
        if (this.inputFormat == SnpEff.InputFormat.PILEUP) {
            seqChangeFileIterator = new SeqChangeFilePileUp(this.inputFile, this.config.getGenome(), this.inOffset);
        } else if (this.inputFormat == SnpEff.InputFormat.BED) {
            seqChangeFileIterator = new SeqChangeBedFileIterator(this.inputFile, this.config.getGenome(), this.inOffset);
        } else if (this.inputFormat == SnpEff.InputFormat.TXT) {
            seqChangeFileIterator = new SeqChangeFileTxt(this.inputFile, this.config.getGenome(), this.inOffset);
        } else {
            throw new RuntimeException("Cannot create SeqChange file iterator on input format '" + (Object)((Object)this.inputFormat) + "'");
        }
        for (SeqChange seqChange : seqChangeFileIterator) {
            try {
                ++this.countInputLines;
                this.countVariants += (long)seqChange.getChangeOptionCount();
                if (this.verbose && this.countVariants % 100000L == 0L) {
                    Timer.showStdErr("\t" + this.countVariants + " variants");
                }
                if (this.seqChangeFilter == null || this.seqChangeFilter.filter(seqChange)) {
                    if (this.filterIntervals != null && this.filterIntervals.stab(seqChange).size() <= 0) continue;
                    if (this.createSummary) {
                        this.seqChangeStats.sample(seqChange);
                    }
                    List<ChangeEffect> changeEffects = snpEffectPredictor.seqChangeEffect(seqChange);
                    outputFormatter.startSection(seqChange);
                    for (ChangeEffect changeEffect : changeEffects) {
                        this.changeEffectResutStats.sample(changeEffect);
                        outputFormatter.add(changeEffect);
                        ++this.countEffects;
                    }
                    outputFormatter.printSection(seqChange);
                    continue;
                }
                this.countVariantsFilteredOut += (long)seqChange.getChangeOptionCount();
            }
            catch (Throwable t2) {
                ++this.totalErrs;
                this.error(t2, "Error while processing variant (line " + seqChangeFileIterator.getLineNum() + ") :\n\t" + seqChange + "\n" + t2);
            }
        }
        seqChangeFileIterator.close();
    }

    void iterateVcf(OutputFormatter outputFormatter) {
        SnpEffectPredictor snpEffectPredictor = this.config.getSnpEffectPredictor();
        VcfFileIterator vcfFile = new VcfFileIterator(this.inputFile, this.config.getGenome());
        vcfFile.setInOffset(this.inOffset);
        for (VcfEntry vcfEntry : vcfFile) {
            try {
                ++this.countInputLines;
                if (this.createSummary) {
                    this.vcfStats.sample(vcfEntry);
                }
                if (this.filterIntervals != null && this.filterIntervals.query(vcfEntry).isEmpty()) continue;
                outputFormatter.startSection(vcfEntry);
                for (SeqChange seqChange : vcfEntry.seqChanges()) {
                    this.countVariants += (long)seqChange.getChangeOptionCount();
                    if (this.verbose && this.countVariants % 100000L == 0L) {
                        Timer.showStdErr("\t" + this.countVariants + " variants");
                    }
                    if (this.seqChangeFilter == null || this.seqChangeFilter.filter(seqChange)) {
                        if (this.createSummary) {
                            this.seqChangeStats.sample(seqChange);
                        }
                        List<ChangeEffect> changeEffects = snpEffectPredictor.seqChangeEffect(seqChange);
                        outputFormatter.startSection(seqChange);
                        for (ChangeEffect changeEffect : changeEffects) {
                            if (this.createSummary) {
                                this.changeEffectResutStats.sample(changeEffect);
                            }
                            outputFormatter.add(changeEffect);
                            ++this.countEffects;
                        }
                        outputFormatter.printSection(seqChange);
                        continue;
                    }
                    this.countVariantsFilteredOut += (long)seqChange.getChangeOptionCount();
                }
                outputFormatter.printSection(vcfEntry);
            }
            catch (Throwable t2) {
                ++this.totalErrs;
                this.error(t2, "Error while processing VCF entry (line " + vcfFile.getLineNum() + ") :\n\t" + vcfEntry + "\n" + t2);
            }
        }
        vcfFile.close();
    }

    void iterateVcfMulti(final OutputFormatter outputFormatter) {
        if (this.verbose) {
            Timer.showStdErr("Running multi-threaded mode (numThreads=" + this.numWorkers + ").");
        }
        outputFormatter.setShowHeader(false);
        final SnpEffectPredictor snpEffectPredictor = this.config.getSnpEffectPredictor();
        final VcfOutputFormatter vcfOutForm = (VcfOutputFormatter)outputFormatter;
        final SnpEffCmdEff snpEffCmdEff = this;
        VcfFileIterator vcfFile = new VcfFileIterator(this.inputFile, this.config.getGenome());
        vcfFile.setInOffset(this.inOffset);
        Props props = new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            @Override
            public Actor create() {
                MasterEff master = new MasterEff(SnpEffCmdEff.this.numWorkers, snpEffCmdEff, snpEffectPredictor, outputFormatter, SnpEffCmdEff.this.filterIntervals, SnpEffCmdEff.this.seqChangeFilter);
                master.setAddHeader(vcfOutForm.getNewHeaderLines().toArray(new String[0]));
                return master;
            }
        });
        int batchSize = 10;
        VcfWorkQueue vcfWorkQueue = new VcfWorkQueue(this.inputFile, batchSize, -1, props);
        vcfWorkQueue.run(true);
    }

    @Override
    public void parseArgs(String[] args) {
        this.args = args;
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith("-")) {
                if (args[i].equals("-c") || args[i].equalsIgnoreCase("-config")) {
                    if (i + 1 < args.length) {
                        this.configFile = args[++i];
                    } else {
                        this.usage("Option '-c' without config file argument");
                    }
                } else if (args[i].equals("-v") || args[i].equalsIgnoreCase("-verbose")) {
                    this.verbose = true;
                    this.quiet = false;
                } else if (args[i].equals("-q") || args[i].equalsIgnoreCase("-quiet")) {
                    this.quiet = true;
                    this.verbose = false;
                } else if (args[i].equals("-1")) {
                    this.outOffset = 1;
                    this.inOffset = 1;
                } else if (args[i].equals("-0")) {
                    this.outOffset = 0;
                    this.inOffset = 0;
                } else if (args[i].equals("-h") || args[i].equalsIgnoreCase("-help")) {
                    this.usage(null);
                    System.exit(0);
                } else if (args[i].equals("-t")) {
                    this.multiThreaded = true;
                    this.createSummary = false;
                } else if (args[i].equals("-o")) {
                    if (i + 1 < args.length) {
                        String outFor;
                        if ((outFor = args[++i].toUpperCase()).equals("TXT")) {
                            this.outputFormat = SnpEff.OutputFormat.TXT;
                            this.outOffset = 1;
                        } else if (outFor.equals("VCF")) {
                            this.outputFormat = SnpEff.OutputFormat.VCF;
                            this.outOffset = 1;
                        } else if (outFor.equals("BED")) {
                            this.outputFormat = SnpEff.OutputFormat.BED;
                            this.outOffset = 0;
                        } else if (outFor.equals("BEDANN")) {
                            this.outputFormat = SnpEff.OutputFormat.BEDANN;
                            this.outOffset = 0;
                        } else {
                            this.usage("Unknown output file format '" + outFor + "'");
                        }
                    }
                } else if (args[i].equals("-a") || args[i].equalsIgnoreCase("-around")) {
                    if (i + 1 < args.length) {
                        CodonChange.SHOW_CODONS_AROUND_CHANGE = Gpr.parseIntSafe(args[++i]);
                    } else {
                        this.usage("Option '-i' without config interval_file argument");
                    }
                } else if (args[i].equals("-s") || args[i].equalsIgnoreCase("-stats")) {
                    if (i + 1 < args.length) {
                        this.summaryFile = args[++i];
                        String dir = Gpr.dirName(this.summaryFile);
                        this.summaryGenesFile = String.valueOf(dir != null ? String.valueOf(dir) + "/" : "") + Gpr.baseName(this.summaryFile, ".html") + ".genes.txt";
                    }
                } else if (args[i].equals("-of") || args[i].equalsIgnoreCase("-outOffset")) {
                    if (i + 1 < args.length) {
                        this.outOffset = Gpr.parseIntSafe(args[++i]);
                    }
                } else if (args[i].equalsIgnoreCase("-chr")) {
                    this.chrStr = args[++i];
                } else if (args[i].equalsIgnoreCase("-useLocalTemplate")) {
                    this.useLocalTemplate = true;
                } else if (args[i].equalsIgnoreCase("-noOut")) {
                    this.supressOutput = true;
                } else if (args[i].equalsIgnoreCase("-noStats")) {
                    this.createSummary = false;
                } else if (args[i].equalsIgnoreCase("-noChromoPlots")) {
                    this.chromoPlots = false;
                } else if (args[i].equalsIgnoreCase("-treatAllAsProteinCoding")) {
                    if (i + 1 < args.length) {
                        this.treatAllAsProteinCoding = args[++i].equalsIgnoreCase("auto") ? null : Boolean.valueOf(Gpr.parseBoolSafe(args[i]));
                    }
                } else if (args[i].equalsIgnoreCase("-canon")) {
                    this.canonical = true;
                } else if (args[i].equalsIgnoreCase("-interval")) {
                    if (i + 1 < args.length) {
                        this.customIntervalFiles.add(args[++i]);
                    } else {
                        this.usage("Option '-i' without config interval_file argument");
                    }
                } else if (args[i].equals("-fi") || args[i].equalsIgnoreCase("-filterInterval")) {
                    if (i + 1 < args.length) {
                        this.filterIntervalFiles.add(args[++i]);
                    } else {
                        this.usage("Option '-fi' without config filter_interval_file argument");
                    }
                } else if (args[i].equals("-i")) {
                    if (i + 1 < args.length) {
                        String inFor;
                        if ((inFor = args[++i].toUpperCase()).equals("TXT")) {
                            this.inputFormat = SnpEff.InputFormat.TXT;
                            this.inOffset = 1;
                        } else if (inFor.equals("PILEUP")) {
                            this.inputFormat = SnpEff.InputFormat.PILEUP;
                            this.inOffset = 1;
                        } else if (inFor.equals("VCF")) {
                            this.inputFormat = SnpEff.InputFormat.VCF;
                            this.inOffset = 1;
                        } else if (inFor.equals("BED")) {
                            this.inputFormat = SnpEff.InputFormat.BED;
                            this.inOffset = 0;
                        } else {
                            this.usage("Unknown input file format '" + inFor + "'");
                        }
                    }
                } else if (args[i].equals("-if") || args[i].equalsIgnoreCase("-inOffset")) {
                    if (i + 1 < args.length) {
                        this.inOffset = Gpr.parseIntSafe(args[++i]);
                    }
                } else if (args[i].equals("-onlyReg")) {
                    this.onlyRegulation = true;
                } else if (args[i].equals("-reg")) {
                    if (i + 1 < args.length) {
                        this.regulationTracks.add(args[++i]);
                    }
                } else if (args[i].equals("-minQ") || args[i].equalsIgnoreCase("-minQuality")) {
                    if (i + 1 < args.length) {
                        this.seqChangeFilter.setMinQuality(Gpr.parseIntSafe(args[++i]));
                    }
                } else if (args[i].equals("-maxQ") || args[i].equalsIgnoreCase("-maxQuality")) {
                    if (i + 1 < args.length) {
                        this.seqChangeFilter.setMaxQuality(Gpr.parseIntSafe(args[++i]));
                    }
                } else if (args[i].equals("-minC") || args[i].equalsIgnoreCase("-minCoverage")) {
                    if (i + 1 < args.length) {
                        this.seqChangeFilter.setMinCoverage(Gpr.parseIntSafe(args[++i]));
                    }
                } else if (args[i].equals("-maxC") || args[i].equalsIgnoreCase("-maxCoverage")) {
                    if (i + 1 < args.length) {
                        this.seqChangeFilter.setMaxCoverage(Gpr.parseIntSafe(args[++i]));
                    }
                } else if (args[i].equals("-ud") || args[i].equalsIgnoreCase("-upDownStreamLen")) {
                    if (i + 1 < args.length) {
                        this.upDownStreamLength = Gpr.parseIntSafe(args[++i]);
                    }
                } else if (args[i].equals("-hom")) {
                    this.seqChangeFilter.setHeterozygous(false);
                } else if (args[i].equals("-het")) {
                    this.seqChangeFilter.setHeterozygous(true);
                } else if (args[i].equals("-snp")) {
                    this.seqChangeFilter.setChangeType(SeqChange.ChangeType.SNP);
                } else if (args[i].equals("-mnp")) {
                    this.seqChangeFilter.setChangeType(SeqChange.ChangeType.MNP);
                } else if (args[i].equals("-ins")) {
                    this.seqChangeFilter.setChangeType(SeqChange.ChangeType.INS);
                } else if (args[i].equals("-del")) {
                    this.seqChangeFilter.setChangeType(SeqChange.ChangeType.DEL);
                } else if (args[i].equalsIgnoreCase("-no-downstream")) {
                    this.changeEffectResutFilter.setDownstream(true);
                } else if (args[i].equalsIgnoreCase("-no-upstream")) {
                    this.changeEffectResutFilter.setUpstream(true);
                } else if (args[i].equalsIgnoreCase("-no-intergenic")) {
                    this.changeEffectResutFilter.setIntergenic(true);
                } else if (args[i].equalsIgnoreCase("-no-intron")) {
                    this.changeEffectResutFilter.setIntron(true);
                } else if (args[i].equalsIgnoreCase("-no-utr")) {
                    this.changeEffectResutFilter.setUtr(true);
                } else if (args[i].equalsIgnoreCase("-no")) {
                    String[] filterOutArray;
                    String filterOut = "";
                    if (i + 1 < args.length) {
                        filterOut = args[++i];
                    }
                    String[] stringArray = filterOutArray = filterOut.split(",");
                    int n = filterOutArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String filterStr = stringArray[n2];
                        if (filterStr.equalsIgnoreCase("downstream")) {
                            this.changeEffectResutFilter.setDownstream(true);
                        } else if (filterStr.equalsIgnoreCase("upstream")) {
                            this.changeEffectResutFilter.setUpstream(true);
                        } else if (filterStr.equalsIgnoreCase("intergenic")) {
                            this.changeEffectResutFilter.setIntergenic(true);
                        } else if (filterStr.equalsIgnoreCase("intron")) {
                            this.changeEffectResutFilter.setIntron(true);
                        } else if (filterStr.equalsIgnoreCase("utr")) {
                            this.changeEffectResutFilter.setUtr(true);
                        } else if (!filterStr.equalsIgnoreCase("None")) {
                            this.usage("Unknown filter option '" + filterStr + "'");
                        }
                        ++n2;
                    }
                } else {
                    this.usage("Unknow option '" + args[i] + "'");
                }
            } else if (this.genomeVer.length() <= 0) {
                this.genomeVer = args[i];
            } else if (this.inputFile.length() <= 0) {
                this.inputFile = args[i];
            } else {
                this.usage("Unknow parameter '" + args[i] + "'");
            }
            ++i;
        }
        if (this.genomeVer.isEmpty()) {
            this.usage("Missing genomer_version parameter");
        }
        if (this.inputFile.isEmpty()) {
            this.inputFile = "-";
        }
        if (this.outputFormat == SnpEff.OutputFormat.VCF && this.inputFormat != SnpEff.InputFormat.VCF) {
            this.usage("Output in VCF format is only supported when the input is also in VCF format");
        }
        if (this.multiThreaded && this.outputFormat != SnpEff.OutputFormat.VCF) {
            this.usage("Multi-threaded option is only supported when when output is in VCF format");
        }
        if (this.multiThreaded && this.createSummary) {
            this.usage("Multi-threaded option should be used with 'noStats'.");
        }
    }

    int readCustomIntFile(String intFile) {
        String file = this.readFile(intFile);
        String[] lines2 = file.split("\n");
        int count2 = 0;
        int lineNum = 0;
        while (lineNum < lines2.length) {
            Custom ci = new Custom(null, 0, 0, 0, "");
            ci.readTxt(lines2[lineNum], lineNum + 1, this.config.getGenome(), this.inOffset);
            this.config.getSnpEffectPredictor().add(ci);
            ++count2;
            ++lineNum;
        }
        return count2;
    }

    String readFile(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            this.fatalError("No such file '" + fileName + "'");
        }
        if (!file.canRead()) {
            this.fatalError("Cannot open file '" + fileName + "'");
        }
        return Gpr.readFile(fileName);
    }

    int readFilterIntFile(String intFile) {
        String file = this.readFile(intFile);
        String[] lines2 = file.split("\n");
        int count2 = 0;
        int lineNum = 0;
        while (lineNum < lines2.length) {
            Custom ci = new Custom(null, 0, 0, 0, "");
            ci.readTxt(lines2[lineNum], lineNum + 1, this.config.getGenome(), this.inOffset);
            this.filterIntervals.add(ci);
            ++count2;
            ++lineNum;
        }
        return count2;
    }

    void readRegulationTrack(String regTrack) {
        if (this.verbose) {
            Timer.showStdErr("Reading regulation track '" + regTrack + "'");
        }
        String regFile = String.valueOf(this.config.getDirDataVersion()) + "/regulation_" + regTrack + ".bin";
        ArrayList regulation = (ArrayList)Gpr.readFileSerializedGz(regFile);
        Genome genome = this.config.getGenome();
        HashMap<String, Integer> chrs = new HashMap<String, Integer>();
        for (Regulation r : regulation) {
            String chr = r.getChromosomeName();
            int max2 = chrs.containsKey(chr) ? (Integer)chrs.get(chr) : 0;
            max2 = Math.max(max2, r.getEnd());
            chrs.put(chr, max2);
        }
        for (String chr : chrs.keySet()) {
            if (genome.getChromosome(chr) != null) continue;
            genome.add(new Chromosome(genome, 0, (int)((Integer)chrs.get(chr)), 1, chr));
        }
        SnpEffectPredictor snpEffectPredictor = this.config.getSnpEffectPredictor();
        for (Regulation r : regulation) {
            snpEffectPredictor.add(r);
        }
    }

    @Override
    public HashMap<String, String> reportValues() {
        HashMap<String, String> report = super.reportValues();
        if (this.seqChangeStats != null) {
            report.put("SeqChanges", String.valueOf(this.seqChangeStats.getCount()));
        }
        return report;
    }

    @Override
    public boolean run() {
        int count2;
        if (!this.changeEffectResutFilter.anythingSet()) {
            this.changeEffectResutFilter = null;
        }
        this.filterIntervals = null;
        if (this.verbose) {
            Timer.showStdErr("Reading configuration file '" + this.configFile + "'");
        }
        this.config = new Config(this.genomeVer, this.configFile);
        if (this.verbose) {
            Timer.showStdErr("done");
        }
        if (this.onlyRegulation) {
            this.config.setSnpEffectPredictor(new SnpEffectPredictor(this.config.getGenome()));
            this.config.setOnlyRegulation(true);
            this.config.setErrorOnMissingChromo(false);
            this.config.setErrorChromoHit(false);
        } else {
            if (this.verbose) {
                Timer.showStdErr("Reading database for genome '" + this.genomeVer + "' (this might take a while)");
            }
            this.config.loadSnpEffectPredictor();
            if (this.verbose) {
                Timer.showStdErr("done");
            }
        }
        if (!this.inputFile.equals("-") && !new File(this.inputFile).canRead()) {
            this.usage("Cannot open input file '" + this.inputFile + "'");
        }
        if (this.treatAllAsProteinCoding != null) {
            this.config.setTreatAllAsProteinCoding(this.treatAllAsProteinCoding);
        } else {
            boolean tapc;
            boolean bl = tapc = !this.config.getGenome().hasCodingInfo();
            if (this.verbose) {
                Timer.showStdErr("Setting '-treatAllAsProteinCoding' to '" + tapc + "'");
            }
            this.config.setTreatAllAsProteinCoding(tapc);
        }
        for (String intFile : this.customIntervalFiles) {
            if (this.verbose) {
                Timer.showStdErr("Reading interval file '" + intFile + "'");
            }
            count2 = this.readCustomIntFile(intFile);
            if (!this.verbose) continue;
            Timer.showStdErr("done (" + count2 + " intervals loaded). ");
        }
        for (String filterIntFile : this.filterIntervalFiles) {
            if (this.filterIntervals == null) {
                this.filterIntervals = new IntervalForest();
            }
            if (this.verbose) {
                Timer.showStdErr("Reading filter interval file '" + filterIntFile + "'");
            }
            count2 = this.readFilterIntFile(filterIntFile);
            if (!this.verbose) continue;
            Timer.showStdErr("done (" + count2 + " intervals loaded). ");
        }
        for (String regTrack : this.regulationTracks) {
            this.readRegulationTrack(regTrack);
        }
        if (this.filterIntervals != null) {
            if (this.verbose) {
                Timer.showStdErr("Building filter interval forest");
            }
            this.filterIntervals.build();
            if (this.verbose) {
                Timer.showStdErr("done.");
            }
        }
        this.config.getSnpEffectPredictor().setUpDownStreamLength(this.upDownStreamLength);
        if (this.canonical) {
            if (this.verbose) {
                Timer.showStdErr("Filtering out non-canonical transcripts.");
            }
            this.config.getSnpEffectPredictor().removeNonCanonical();
            if (this.verbose) {
                Timer.showStdErr("done.");
            }
        }
        if (this.verbose) {
            Timer.showStdErr("Building interval forest");
        }
        this.config.getSnpEffectPredictor().buildForest();
        if (this.verbose) {
            Timer.showStdErr("done.");
        }
        if (this.verbose) {
            Timer.showStdErr("Predicting variants");
        }
        this.runAnalysis();
        if (this.verbose) {
            Timer.showStdErr("done.");
        }
        return true;
    }

    public void runAnalysis() {
        this.seqChangeStats = new SeqChangeStats(this.config.getGenome());
        this.changeEffectResutStats = new ChangeEffectResutStats(this.config.getGenome());
        this.vcfStats = new VcfStats();
        int totalErrs = 0;
        OutputFormatter outputFormatter = null;
        switch (this.outputFormat) {
            case TXT: {
                outputFormatter = new TxtOutputFormatter();
                break;
            }
            case VCF: {
                outputFormatter = new VcfOutputFormatter();
                break;
            }
            case BED: {
                outputFormatter = new BedOutputFormatter();
                break;
            }
            case BEDANN: {
                outputFormatter = new BedAnnotationOutputFormatter();
                break;
            }
            default: {
                throw new RuntimeException("Unknown output format '" + (Object)((Object)this.outputFormat) + "'");
            }
        }
        outputFormatter.setVersion("SnpEff 3.0c (build 2012-07-30), by Pablo Cingolani");
        outputFormatter.setCommandLineStr(this.commandLineStr(false));
        outputFormatter.setChangeEffectResutFilter(this.changeEffectResutFilter);
        outputFormatter.setSupressOutput(this.supressOutput);
        outputFormatter.setOutOffset(this.outOffset);
        outputFormatter.setChrStr(this.chrStr);
        switch (this.inputFormat) {
            case VCF: {
                if (this.multiThreaded) {
                    this.iterateVcfMulti(outputFormatter);
                    break;
                }
                this.iterateVcf(outputFormatter);
                break;
            }
            default: {
                this.iterateSeqChange(outputFormatter);
            }
        }
        if (this.createSummary && this.summaryFile != null) {
            if (this.verbose) {
                Timer.showStdErr("Creating summary file: " + this.summaryFile);
            }
            this.summary(SUMMARY_TEMPLATE, this.summaryFile, false);
            if (this.verbose) {
                Timer.showStdErr("Creating genes file: " + this.summaryGenesFile);
            }
            this.summary(SUMMARY_GENES_TEMPLATE, this.summaryGenesFile, true);
        }
        if (totalErrs > 0) {
            System.err.println(String.valueOf(totalErrs) + " errors.");
        }
    }

    void summary(String templateFile, String outputFile, boolean noCommas) {
        try {
            Configuration cfg = new Configuration();
            if (this.useLocalTemplate) {
                cfg.setDirectoryForTemplateLoading(new File("./templates/"));
            } else {
                cfg.setClassForTemplateLoading(SnpEffCmdEff.class, "/");
            }
            cfg.setObjectWrapper(new DefaultObjectWrapper());
            cfg.setLocale(Locale.US);
            if (noCommas) {
                cfg.setNumberFormat("0.######");
            }
            HashMap<String, Object> root2 = this.summaryCreateHash();
            Template temp = cfg.getTemplate(templateFile);
            OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(new File(outputFile)));
            temp.process(root2, out);
            ((Writer)out).flush();
            ((Writer)out).close();
        }
        catch (IOException e) {
            this.error(e, "Error creating summary: " + e.getMessage());
        }
        catch (TemplateException e) {
            this.error(e, "Error creating summary: " + e.getMessage());
        }
    }

    HashMap<String, Object> summaryCreateHash() {
        HashMap<String, Object> root2 = new HashMap<String, Object>();
        root2.put("args", this.commandLineStr(true));
        root2.put("changeStats", this.changeEffectResutStats);
        root2.put("chromoPlots", this.chromoPlots);
        root2.put("countEffects", this.countEffects);
        root2.put("countInputLines", this.countInputLines);
        root2.put("countVariants", this.countVariants);
        root2.put("countVariantsFilteredOut", this.countVariantsFilteredOut);
        root2.put("date", String.format("%1$TY-%1$Tm-%1$Td %1$TH:%1$TM", new Date()));
        root2.put("genesFile", Gpr.baseName(this.summaryGenesFile, ""));
        root2.put("genome", this.config.getGenome());
        root2.put("genomeVersion", this.genomeVer);
        root2.put("seqChangeFilter", this.seqChangeFilter);
        root2.put("seqStats", this.seqChangeStats);
        root2.put("snpEffectPredictor", this.config.getSnpEffectPredictor());
        root2.put("vcfStats", this.vcfStats);
        root2.put("version", "SnpEff 3.0c (build 2012-07-30), by Pablo Cingolani");
        return root2;
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error        :\t" + message);
            System.err.println("Command line :\t" + this.commandLineStr(false) + "\n");
        }
        System.err.println("snpEff version SnpEff 3.0c (build 2012-07-30), by Pablo Cingolani");
        System.err.println("Usage: snpEff [eff] genome_version [variants_file]");
        System.err.println("\nInput file: Default is STDIN");
        System.err.println("\nOptions:");
        System.err.println("\t-a , -around            : Show N codons and amino acids around change (only in coding regions). Default is " + CodonChange.SHOW_CODONS_AROUND_CHANGE + " codons.");
        System.err.println("\t-i <format>             : Input format [ vcf, txt, pileup, bed ]. Default: VCF.");
        System.err.println("\t-o <format>             : Ouput format [ txt, vcf, bed, bedAnn ]. Default: VCF.");
        System.err.println("\t-interval               : Use a custom interval file (you may use this option many times)");
        System.err.println("\t-chr <string>           : Prepend 'string' to chromosome name (e.g. 'chr1' instead of '1'). Only on TXT output.");
        System.err.println("\t-s,  -stats             : Name of stats file (summary). Default is 'snpEff_summary.html'");
        System.err.println("\t-t                      : Use multiple threads (implies '-noStats'). Default 'off'");
        System.err.println("\nSequence change filter options:");
        System.err.println("\t-del                    : Analyze deletions only");
        System.err.println("\t-ins                    : Analyze insertions only");
        System.err.println("\t-hom                    : Analyze homozygous variants only");
        System.err.println("\t-het                    : Analyze heterozygous variants only");
        System.err.println("\t-minQ X, -minQuality X  : Filter out variants with quality lower than X");
        System.err.println("\t-maxQ X, -maxQuality X  : Filter out variants with quality higher than X");
        System.err.println("\t-minC X, -minCoverage X : Filter out variants with coverage lower than X");
        System.err.println("\t-maxC X, -maxCoverage X : Filter out variants with coverage higher than X");
        System.err.println("\t-nmp                    : Only MNPs (multiple nucleotide polymorphisms)");
        System.err.println("\t-snp                    : Only SNPs (single nucleotide polymorphisms)");
        System.err.println("\nResults filter options:");
        System.err.println("\t-fi  <bedFile>                  : Only analyze changes that intersect with the intervals specified in this file (you may use this option many times)");
        System.err.println("\t-no-downstream                  : Do not show DOWNSTREAM changes");
        System.err.println("\t-no-intergenic                  : Do not show INTERGENIC changes");
        System.err.println("\t-no-intron                      : Do not show INTRON changes");
        System.err.println("\t-no-upstream                    : Do not show UPSTREAM changes");
        System.err.println("\t-no-utr                         : Do not show 5_PRIME_UTR or 3_PRIME_UTR changes");
        System.err.println("\nAnnotations filter options:");
        System.err.println("\t-canon                          : Only use canonical transcripts.");
        System.err.println("\t-onlyReg                        : Only use regulation tracks.");
        System.err.println("\t-reg <name>                     : Regulation track to use (this option can be used add several times).");
        System.err.println("\t-treatAllAsProteinCoding <bool> : If true, all transcript are treated as if they were protein conding. Default: Auto");
        System.err.println("\t-ud, -upDownStreamLen           : Set upstream downstream interval length (in bases)");
        System.err.println("\nGeneric options:");
        System.err.println("\t-0                      : File positions are zero-based (same as '-inOffset 0 -outOffset 0')");
        System.err.println("\t-1                      : File positions are one-based (same as '-inOffset 1 -outOffset 1')");
        System.err.println("\t-c , -config            : Specify config file");
        System.err.println("\t-h , -help              : Show this help and exit");
        System.err.println("\t-if, -inOffset          : Offset input by a number of bases. E.g. '-inOffset 1' for one-based input files");
        System.err.println("\t-of, -outOffset         : Offset output by a number of bases. E.g. '-outOffset 1' for one-based output files");
        System.err.println("\t-noLog                  : Do not report usage statistics to server");
        System.err.println("\t-noStats                : Do not create stats (summary) file");
        System.err.println("\t-q , -quiet             : Quiet mode (do not show any messages or errors)");
        System.err.println("\t-v , -verbose           : Verbose mode");
        System.exit(-1);
    }
}

