/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.commandLine;

import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class SnpEffCmdDownload
extends SnpEff {
    public static boolean debug = false;
    private static int BUFFER_SIZE = 10480;
    String version = "3.0";

    String baseName(String url) {
        String[] f2 = url.toString().split("/");
        return f2[f2.length - 1];
    }

    private URL buildUrl() {
        try {
            this.version = this.version.replace('.', '_');
            String urlRoot = this.config.getDatabaseRepository();
            StringBuilder urlsb = new StringBuilder();
            urlsb.append(urlRoot);
            if (urlsb.charAt(urlRoot.length() - 1) != '/') {
                urlsb.append("/");
            }
            urlsb.append("v" + this.version + "/snpEff_v" + this.version + "_" + this.genomeVer + ".zip");
            return new URL(urlsb.toString());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    boolean download(URL url, String localFile) {
        boolean res = false;
        try {
            Timer.show("Connecting to " + url);
            URLConnection connection = url.openConnection();
            boolean followRedirect = true;
            while (followRedirect) {
                HttpURLConnection httpConnection = (HttpURLConnection)connection;
                int code = httpConnection.getResponseCode();
                if (code == 200) {
                    followRedirect = false;
                    continue;
                }
                if (code == 302) {
                    String newUrl = connection.getHeaderField("Location");
                    Timer.show("Following redirect: " + newUrl);
                    url = new URL(newUrl);
                    connection = url.openConnection();
                    continue;
                }
                if (code == 404) {
                    throw new RuntimeException("File not found on the server. Make sure the database name is correct.");
                }
                throw new RuntimeException("Error code from server: " + code);
            }
            InputStream is = url.openStream();
            Date date = new Date(connection.getLastModified());
            Timer.show("Copying file (type: " + connection.getContentType() + ", modified on: " + date + ")");
            Timer.show("Local file name: '" + localFile + "'");
            FileOutputStream os = null;
            os = new FileOutputStream(localFile);
            int count2 = 0;
            int total = 0;
            int lastShown = 0;
            byte[] data2 = new byte[BUFFER_SIZE];
            while ((count2 = is.read(data2, 0, BUFFER_SIZE)) != -1) {
                os.write(data2, 0, count2);
                if ((total += count2) - lastShown <= 0x100000) continue;
                Timer.show("Downloaded " + total + " bytes");
                lastShown = total;
            }
            is.close();
            os.close();
            Timer.show("Donwload finished. Total " + total + " bytes.");
            res = true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return res;
    }

    @Override
    public void parseArgs(String[] args) {
        this.args = args;
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith("-")) {
                if (args[i].equals("-c") || args[i].equalsIgnoreCase("-config")) {
                    if (i + 1 < args.length) {
                        this.configFile = args[++i];
                    } else {
                        this.usage("Option '-c' without config file argument");
                    }
                } else if (args[i].equals("-v") || args[i].equalsIgnoreCase("-verbose")) {
                    this.verbose = true;
                    this.quiet = false;
                } else if (args[i].equals("-h") || args[i].equalsIgnoreCase("-help")) {
                    this.usage(null);
                    System.exit(0);
                } else {
                    this.usage("Unknow option '" + args[i] + "'");
                }
            } else if (this.genomeVer.length() <= 0) {
                this.genomeVer = args[i];
            } else {
                this.usage("Unknow parameter '" + args[i] + "'");
            }
            ++i;
        }
        if (this.genomeVer.isEmpty()) {
            this.usage("Missing genomer_version parameter");
        }
    }

    @Override
    public boolean run() {
        this.config = new Config(this.genomeVer, this.configFile);
        Timer.show("Downloading database for '" + this.genomeVer + "'");
        URL url = this.buildUrl();
        String localFile = this.baseName(url.toString());
        if (this.download(url, localFile) && this.unzip(localFile)) {
            Timer.show("Unzip: OK");
        }
        Timer.show("Done");
        return true;
    }

    boolean unzip(String zipFile) {
        try {
            ZipEntry entry;
            FileInputStream fis = new FileInputStream(zipFile);
            ZipInputStream zin = new ZipInputStream(new BufferedInputStream(fis));
            while ((entry = zin.getNextEntry()) != null) {
                byte[] data2 = new byte[BUFFER_SIZE];
                Timer.show("Extracting file '" + entry.getName() + "'");
                String entryName = entry.getName();
                String[] entryPath = entryName.split("/");
                String dataName = String.valueOf(entryPath[entryPath.length - 2]) + "/" + entryPath[entryPath.length - 1];
                entryName = String.valueOf(this.config.getDirData()) + "/" + dataName;
                Timer.show("Local file name: '" + entryName + "'");
                String dir = Gpr.dirName(entryName);
                Timer.show("Creating local directory: '" + dir + "'");
                new File(dir).mkdirs();
                FileOutputStream fos = new FileOutputStream(entryName);
                BufferedOutputStream dest = new BufferedOutputStream(fos, BUFFER_SIZE);
                int count2 = 0;
                while ((count2 = zin.read(data2, 0, BUFFER_SIZE)) != -1) {
                    dest.write(data2, 0, count2);
                }
                dest.flush();
                dest.close();
            }
            zin.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error: " + message + "\n");
        }
        System.err.println("snpEff version SnpEff 3.0c (build 2012-07-30), by Pablo Cingolani");
        System.err.println("Usage: snpEff download [options] genome_version");
        System.err.println("\nGeneric options:");
        System.err.println("\t-c , -config            : Specify config file");
        System.err.println("\t-h , -help              : Show this help and exit");
        System.err.println("\t-v , -verbose           : Verbose mode");
        System.err.println("\t-noLog                  : Do not report usage statistics to server");
        System.exit(-1);
    }
}

